(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_pages_settings_settings-themes_settings-themes_module_ts"],{

/***/ 3745:
/*!******************************************!*\
  !*** ./src/app/api/theme-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeApiService": () => (/* binding */ ThemeApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);



class ThemeApiService {
    constructor(rest) {
        this.rest = rest;
    }
    get(id) {
        return this.rest.get(`/themes/${id}`);
    }
    getCurrent() {
        return this.rest.get(`/themes/current`);
    }
    list(params) {
        return this.rest.get('/themes', params);
    }
    save(data) {
        return this.rest.post('/themes', data);
    }
    edit(data) {
        return this.rest.put(`/themes/${data.id}`, data);
    }
    delete(ids) {
        return this.rest.delete(`/themes`, {
            ids,
        });
    }
    upload(file) {
        const formData = new FormData();
        formData.append('file', file);
        return this.rest.post(`/themes/upload`, formData);
    }
    import(file) {
        const formData = new FormData();
        formData.append('file', file);
        return this.rest.post(`/themes/import`, formData);
    }
    export(id) {
        return this.rest.post(`/themes/${id}/export`, {}, {
            responseType: plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ResponseType.Blob,
        });
    }
    selectAsGlobal(id) {
        return this.rest.post(`/themes/${id}/select`);
    }
    resetGlobal() {
        return this.rest.post(`/themes/reset-global`);
    }
}
ThemeApiService.ɵfac = function ThemeApiService_Factory(t) { return new (t || ThemeApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.RestService)); };
ThemeApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: ThemeApiService, factory: ThemeApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 3755:
/*!********************************!*\
  !*** ./src/app/enums/state.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ELoadingState": () => (/* binding */ ELoadingState)
/* harmony export */ });
var ELoadingState;
(function (ELoadingState) {
    ELoadingState[ELoadingState["Default"] = 0] = "Default";
    ELoadingState[ELoadingState["Wait"] = 1] = "Wait";
    ELoadingState[ELoadingState["Success"] = 2] = "Success";
    ELoadingState[ELoadingState["Reject"] = 3] = "Reject";
})(ELoadingState || (ELoadingState = {}));


/***/ }),

/***/ 9677:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/settings/settings-themes/settings-themes.component.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SettingsThemesComponent": () => (/* binding */ SettingsThemesComponent)
/* harmony export */ });
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../enums/state */ 3755);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _services_server_response_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../services/server-response.service */ 2429);
/* harmony import */ var _api_theme_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../api/theme-api.service */ 3745);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! shoelace-style-angular */ 5219);










function SettingsThemesComponent_ng_container_0_sl_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SettingsThemesComponent_ng_container_0_sl_button_3_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r12.resetGlobal()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "resetTheme"), " ");
} }
function SettingsThemesComponent_ng_container_0_core_table_filter_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-table-filter");
} }
function SettingsThemesComponent_ng_container_0_sl_button_6_Template(rf, ctx) { if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SettingsThemesComponent_ng_container_0_sl_button_6_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](8); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](_r4.show(ctx_r14.checked)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 2, "$.delete"), " ", ctx_r8.checked.length, " ");
} }
function SettingsThemesComponent_ng_container_0_p_11_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx_r16.currentTheme.name, " ");
} }
function SettingsThemesComponent_ng_container_0_p_11_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](1, "translate");
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](1, 1, "systemTheme"), " ");
} }
function SettingsThemesComponent_ng_container_0_p_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "p", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "sl-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, SettingsThemesComponent_ng_container_0_p_11_ng_container_3_Template, 2, 1, "ng-container", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](4, SettingsThemesComponent_ng_container_0_p_11_ng_template_4_Template, 2, 3, "ng-template", null, 26, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](5);
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r9.currentTheme)("ngIfElse", _r17);
} }
function SettingsThemesComponent_ng_container_0_core_empty_state_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-empty-state", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](1, "translate");
} if (rf & 2) {
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("description", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](1, 1, ctx_r10.emptyState));
} }
function SettingsThemesComponent_ng_container_0_core_table_13_tr_28_Template(rf, ctx) { if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "tr")(1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](2, "core-table-checkbox", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "td", 38)(4, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](10, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](12, "core-relative-time", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](13, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](14, "core-relative-time", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "td", 40)(16, "sl-dropdown", 41)(17, "sl-button", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](18, "sl-icon", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](19, "sl-menu")(20, "sl-menu-item", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SettingsThemesComponent_ng_container_0_core_table_13_tr_28_Template_sl_menu_item_click_20_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r22); const theme_r20 = restoredCtx.$implicit; const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r21.selectAsGlobal(theme_r20.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](23, "sl-menu-item", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SettingsThemesComponent_ng_container_0_core_table_13_tr_28_Template_sl_menu_item_click_23_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r22); const theme_r20 = restoredCtx.$implicit; const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r23.showThemeCreateComponent(theme_r20.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](24);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](25, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](26, "sl-menu-item", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SettingsThemesComponent_ng_container_0_core_table_13_tr_28_Template_sl_menu_item_click_26_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r22); const theme_r20 = restoredCtx.$implicit; const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](3); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](4); ctx_r24.themeInConfirm = theme_r20; return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](_r3.show(theme_r20)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](27);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](28, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()()()();
} if (rf & 2) {
    const theme_r20 = ctx.$implicit;
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("current", theme_r20.selected_as_global);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("value", theme_r20);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", theme_r20.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", theme_r20.description || "", " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](10, 12, theme_r20.author), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("date", theme_r20.create_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("date", theme_r20.update_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("disabled", ctx_r19.isDisabledApply(theme_r20.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](22, 14, "$.apply"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](25, 16, "$.edit"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](28, 18, "delete"), " ");
} }
function SettingsThemesComponent_ng_container_0_core_table_13_Template(rf, ctx) { if (rf & 1) {
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "core-table", 28)(1, "thead")(2, "tr")(3, "th", 29)(4, "core-table-checkbox-controller", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("change", function SettingsThemesComponent_ng_container_0_core_table_13_Template_core_table_checkbox_controller_change_4_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r26); const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r25.checked = $event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](5, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](8, "core-table-sort", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](12, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](14, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](15, "core-table-sort", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](16, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](18, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](19, "core-table-sort", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](20, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](23, "core-table-sort", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](24, "th", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](25);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](26, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](27, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](28, SettingsThemesComponent_ng_container_0_core_table_13_tr_28_Template, 29, 20, "tr", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("total", ctx_r11.total)("loading", ctx_r11.loadingState === ctx_r11.ELoadingState.Wait);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](7, 9, "$.name"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](11, 11, "description"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](14, 13, "author"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](18, 15, "$.createDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](22, 17, "$.updateDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](26, 19, "$.actions"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx_r11.themes);
} }
function SettingsThemesComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r28 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "core-header", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, SettingsThemesComponent_ng_container_0_sl_button_3_Template, 3, 3, "sl-button", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](5, SettingsThemesComponent_ng_container_0_core_table_filter_5_Template, 1, 0, "core-table-filter", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](6, SettingsThemesComponent_ng_container_0_sl_button_6_Template, 3, 4, "sl-button", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "sl-button", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function SettingsThemesComponent_ng_container_0_Template_sl_button_click_7_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r28); const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r27.showThemeCreateComponent()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](10, "sl-icon", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](11, SettingsThemesComponent_ng_container_0_p_11_Template, 6, 2, "p", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](12, SettingsThemesComponent_ng_container_0_core_empty_state_12_Template, 2, 3, "core-empty-state", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](13, SettingsThemesComponent_ng_container_0_core_table_13_Template, 29, 21, "core-table", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 8, "title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.currentTheme);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.isSearch || ctx_r0.total);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.checked.length);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](9, 10, "addTheme"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.themes.length);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", !ctx_r0.themes.length && ctx_r0.loadingState !== ctx_r0.ELoadingState.Wait);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.themes.length);
} }
function SettingsThemesComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-error-state", 46);
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("code", ctx_r2.responseServerError);
} }
function SettingsThemesComponent_p_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r29 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](item_r29.name);
} }
class SettingsThemesComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_4__.SubscribableComponent {
    constructor(activatedRoute, notifyService, responseErrorService, router, serverResponseService, themeApiService) {
        super();
        this.activatedRoute = activatedRoute;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.router = router;
        this.serverResponseService = serverResponseService;
        this.themeApiService = themeApiService;
        this.ELoadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState;
        this.checked = [];
        this.themes = [];
        this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Default;
        this.owners = {};
        this.total = 1;
        this.responseServerError = null;
    }
    get isSearch() {
        return this.activatedRoute.snapshot.queryParams.search;
    }
    get currentTheme() {
        return this.themes.find((theme) => theme.selected_as_global);
    }
    get emptyState() {
        return this.isSearch ? 'emptyStateFilter' : 'emptyState';
    }
    get confirmDescription() {
        var _a, _b;
        return ((_a = this.themeInConfirm) === null || _a === void 0 ? void 0 : _a.id) !== ((_b = this.currentTheme) === null || _b === void 0 ? void 0 : _b.id)
            ? 'confirm.deleteThemeConfirmDescription'
            : 'confirm.deleteSelectThemeConfirmDescription';
    }
    ngOnInit() {
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe(() => {
                this.load();
            }),
        ];
    }
    showThemeCreateComponent(id) {
        this.router.navigate(['/setting/themes/create'], {
            queryParams: { id },
        });
    }
    resetGlobal() {
        this.themeApiService.resetGlobal().subscribe({
            next: () => {
                this.notifyService.toastByName('resetGlobal');
                window.location.reload();
            },
            error: (response) => {
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Reject;
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'themeResetGlobalDanger',
                });
            },
        });
    }
    selectAsGlobal(id) {
        if (this.currentTheme && id === this.currentTheme.id) {
            return;
        }
        this.themeApiService.selectAsGlobal(id).subscribe({
            next: () => {
                this.notifyService.toastByName('selectAsGlobal');
                window.location.reload();
            },
            error: (response) => {
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Reject;
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'themeSelectAsGlobalDanger',
                });
            },
        });
    }
    isDisabledApply(id) {
        return this.currentTheme && id === this.currentTheme.id;
    }
    delete(theme) {
        this.deleteThemes([theme]);
    }
    deleteThemes(themes) {
        this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Wait;
        this.themeApiService.delete(themes.map(plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.toIds)).subscribe({
            next: () => {
                this.checked = [];
                this.load();
                this.notifyService.toastByName(themes.length === 1 ? 'themeDelete' : 'themesDelete');
            },
            error: (response) => {
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Reject;
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: themes.length === 1
                        ? 'themeDeleteDanger'
                        : 'themesDeleteDanger',
                });
            },
        });
    }
    load() {
        const query = Object.assign({}, this.activatedRoute.snapshot.queryParams);
        this.themeApiService.list(query).subscribe({
            next: ({ rows, total }) => {
                this.themes = rows;
                this.total = total || 0;
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Success;
            },
            error: (response) => {
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Reject;
                this.responseServerError =
                    this.serverResponseService.getStatusOrNotify(response, 'themesGetListDanger');
            },
        });
    }
}
SettingsThemesComponent.ɵfac = function SettingsThemesComponent_Factory(t) { return new (t || SettingsThemesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_6__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_6__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_services_server_response_service__WEBPACK_IMPORTED_MODULE_1__.ServerResponseService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_api_theme_api_service__WEBPACK_IMPORTED_MODULE_2__.ThemeApiService)); };
SettingsThemesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: SettingsThemesComponent, selectors: [["app-settings-themes"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵInheritDefinitionFeature"]], decls: 23, vars: 24, consts: [[4, "ngIf", "ngIfElse"], ["errorTemplate", ""], [3, "title", "description", "ok"], ["confirmComponent", ""], [3, "title", "ok"], ["deleteCheckedConfirm", ""], [4, "ngFor", "ngForOf"], ["variant", "success", "name", "selectAsGlobal"], ["variant", "success", "name", "resetGlobal"], ["variant", "success", "name", "themeDelete"], ["variant", "success", "name", "themesDelete"], [3, "title"], ["class", "theme-reset", "variant", "text", 3, "click", 4, "ngIf"], [1, "header-actions"], [4, "ngIf"], ["variant", "danger", "class", "header-btn", 3, "click", 4, "ngIf"], ["variant", "primary", 1, "header-btn", 3, "click"], ["name", "plus", "slot", "suffix"], ["class", "current-theme", 4, "ngIf"], ["imageSrc", "/assets/images/themes-empty.svg", 3, "description", 4, "ngIf"], [3, "total", "loading", 4, "ngIf"], ["variant", "text", 1, "theme-reset", 3, "click"], ["variant", "danger", 1, "header-btn", 3, "click"], [1, "current-theme"], ["name", "palette2"], ["tooltipify", ""], ["baseTheme", ""], ["imageSrc", "/assets/images/themes-empty.svg", 3, "description"], [3, "total", "loading"], ["width", "5vw"], [3, "change"], ["width", "10vw"], ["routing", "", "by", "name"], ["routing", "", "by", "author"], ["routing", "", "by", "create_date"], ["routing", "", "by", "update_date"], [3, "current", 4, "ngFor", "ngForOf"], [3, "value"], ["maxWidth", "10vw"], [3, "date"], ["maxWidth", "5vw", 1, "center"], ["placement", "left-start", "hoist", ""], ["slot", "trigger", 1, "actions"], ["slot", "prefix", "name", "three-dots-vertical"], [3, "disabled", "click"], [3, "click"], [3, "code"]], template: function SettingsThemesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](0, SettingsThemesComponent_ng_container_0_Template, 14, 12, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, SettingsThemesComponent_ng_template_1_Template, 1, 1, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "core-confirm", 2, 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("ok", function SettingsThemesComponent_Template_core_confirm_ok_3_listener($event) { return ctx.delete($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "core-confirm", 4, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("ok", function SettingsThemesComponent_Template_core_confirm_ok_7_listener($event) { return ctx.deleteThemes($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](10, SettingsThemesComponent_p_10_Template, 2, 1, "p", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "core-notify", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](14, "core-notify", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](17, "core-notify", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](20, "core-notify", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", !ctx.responseServerError)("ngIfElse", _r1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 10, "confirm.deleteThemeConfirm"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 12, ctx.confirmDescription));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](9, 14, "confirm.deleteThemesConfirm"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx.checked);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](13, 16, "themeSelectAsGlobal"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](16, 18, "themeResetGlobal"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](19, 20, "themeDelete"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](22, 22, "themesDelete"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_7__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.EmptyStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ErrorStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.HeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.RelativeTimeComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.OpenableDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableCheckboxComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableCheckboxControllerComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableFilterComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableSortRoutingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.WidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TooltipifyDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UsernamePipe], styles: ["core-header[_ngcontent-%COMP%]     h1 {\n  line-height: 48px;\n  white-space: nowrap;\n}\ncore-header[_ngcontent-%COMP%]     .content {\n  flex: 0;\n}\ncore-header[_ngcontent-%COMP%]     .controls {\n  flex: 1;\n}\n.theme-reset[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-medium);\n}\n.theme-reset[_ngcontent-%COMP%]::part(base) {\n  font-weight: 600;\n}\n.header-actions[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  flex-grow: 1;\n}\n.header-btn[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-medium);\n}\ncore-table-filter[_ngcontent-%COMP%] {\n  display: block;\n}\n.actions[_ngcontent-%COMP%]::part(base) {\n  border: none;\n  background: transparent;\n}\n.center[_ngcontent-%COMP%] {\n  text-align: center;\n}\nsl-dropdown[_ngcontent-%COMP%] {\n  text-align: left;\n}\n.current-theme[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  margin: 0 0 var(--sl-spacing-large);\n  font-size: 13px;\n  line-height: 140%;\n  color: var(--sl-color-secondary-700);\n}\n.current-theme[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n}\ntr.current[_ngcontent-%COMP%] {\n  background: rgba(124, 58, 237, 0.12);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 1411:
/*!**************************************************************************!*\
  !*** ./src/app/pages/settings/settings-themes/settings-themes.module.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SettingsThemesModule": () => (/* binding */ SettingsThemesModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _ctrl_ngx_codemirror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ctrl/ngx-codemirror */ 662);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _settings_themes_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings-themes.component */ 9677);
/* harmony import */ var _theme_create_theme_create_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./theme-create/theme-create.component */ 9963);
/* harmony import */ var _theme_create_upload_file_upload_file_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./theme-create/upload-file/upload-file.component */ 5914);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
















class SettingsThemesModule {
}
SettingsThemesModule.ɵfac = function SettingsThemesModule_Factory(t) { return new (t || SettingsThemesModule)(); };
SettingsThemesModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({ type: SettingsThemesModule });
SettingsThemesModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.providePageTranslations)({
            sources: ['assets/i18n/settings/themes/'],
        }),
    ], imports: [_ctrl_ngx_codemirror__WEBPACK_IMPORTED_MODULE_5__.CodemirrorModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ErrorStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FileModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.RelativeTimeModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterModule.forChild([
            {
                path: '',
                component: _settings_themes_component__WEBPACK_IMPORTED_MODULE_0__.SettingsThemesComponent,
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PageTranslationsGuard],
            },
            {
                path: 'create',
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PageTranslationsGuard],
                component: _theme_create_theme_create_component__WEBPACK_IMPORTED_MODULE_1__.ThemeCreateComponent,
            },
        ]),
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_9__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipeModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetNgModuleScope"](SettingsThemesModule, { declarations: [_settings_themes_component__WEBPACK_IMPORTED_MODULE_0__.SettingsThemesComponent,
        _theme_create_theme_create_component__WEBPACK_IMPORTED_MODULE_1__.ThemeCreateComponent,
        _theme_create_upload_file_upload_file_component__WEBPACK_IMPORTED_MODULE_2__.UploadFileComponent], imports: [_ctrl_ngx_codemirror__WEBPACK_IMPORTED_MODULE_5__.CodemirrorModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ErrorStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FileModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.RelativeTimeModule, _angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_9__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipeModule] }); })();
_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetComponentScope"](_theme_create_theme_create_component__WEBPACK_IMPORTED_MODULE_1__.ThemeCreateComponent, function () { return [_ctrl_ngx_codemirror__WEBPACK_IMPORTED_MODULE_5__.CodemirrorComponent, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ValidateComponent, _angular_forms__WEBPACK_IMPORTED_MODULE_7__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_7__.NgModel, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_9__.OpenableDirective, _theme_create_upload_file_upload_file_component__WEBPACK_IMPORTED_MODULE_2__.UploadFileComponent]; }, function () { return [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe]; });


/***/ }),

/***/ 9963:
/*!***************************************************************************************!*\
  !*** ./src/app/pages/settings/settings-themes/theme-create/theme-create.component.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeCreateComponent": () => (/* binding */ ThemeCreateComponent),
/* harmony export */   "UploadFileType": () => (/* binding */ UploadFileType)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 2313);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var codemirror_mode_css_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! codemirror/mode/css/css */ 2815);
/* harmony import */ var codemirror_mode_css_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(codemirror_mode_css_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var codemirror_mode_javascript_javascript__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! codemirror/mode/javascript/javascript */ 1484);
/* harmony import */ var codemirror_mode_javascript_javascript__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(codemirror_mode_javascript_javascript__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var codemirror_addon_edit_closebrackets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! codemirror/addon/edit/closebrackets */ 1987);
/* harmony import */ var codemirror_addon_edit_closebrackets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(codemirror_addon_edit_closebrackets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _api_theme_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../api/theme-api.service */ 3745);













const _c0 = ["codeMirrorCss"];
const _c1 = ["codeMirrorJs"];
function ThemeCreateComponent_sl_button_6_Template(rf, ctx) { if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-button", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_sl_button_6_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r8); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r7.export()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "sl-icon", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 1, "themeCreate.export"), " ");
} }
function ThemeCreateComponent_div_54_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 35)(1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "div")(4, "sl-icon-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_div_54_Template_sl_icon_button_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r10); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r9.deleteFile(ctx_r9.UploadFile.Icon)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](ctx_r3.icon.name);
} }
function ThemeCreateComponent_div_64_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 35)(1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "div")(4, "sl-icon-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_div_64_Template_sl_icon_button_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r12); const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r11.deleteFile(ctx_r11.UploadFile.Logo)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](ctx_r4.logo.name);
} }
function ThemeCreateComponent_div_74_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 35)(1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "div")(4, "sl-tooltip", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "sl-icon-button", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_div_74_div_1_Template_sl_icon_button_click_6_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17); const font_r14 = restoredCtx.$implicit; const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r16.copyPath(font_r14.name)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "sl-icon-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_div_74_div_1_Template_sl_icon_button_click_7_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17); const i_r15 = restoredCtx.index; const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r18.deleteFile(ctx_r18.UploadFile.Font, i_r15)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const font_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](font_r14.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("content", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](5, 2, "themeCreate.fonts.tooltip"));
} }
function ThemeCreateComponent_div_74_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](1, ThemeCreateComponent_div_74_div_1_Template, 8, 4, "div", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r5.fonts);
} }
const _c2 = function () { return { lineNumbers: true, mode: "css", matchBrackets: true, autoCloseBrackets: true }; };
const _c3 = function () { return { lineNumbers: true, mode: "javascript", autoCloseBrackets: true }; };
var CodemirrorMode;
(function (CodemirrorMode) {
    CodemirrorMode[CodemirrorMode["CSS"] = 0] = "CSS";
    CodemirrorMode[CodemirrorMode["JS"] = 1] = "JS";
})(CodemirrorMode || (CodemirrorMode = {}));
var UploadFileType;
(function (UploadFileType) {
    UploadFileType[UploadFileType["Icon"] = 0] = "Icon";
    UploadFileType[UploadFileType["Logo"] = 1] = "Logo";
    UploadFileType[UploadFileType["Font"] = 2] = "Font";
    UploadFileType[UploadFileType["Theme"] = 3] = "Theme";
})(UploadFileType || (UploadFileType = {}));
class ThemeCreateComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__.SubscribableComponent {
    constructor(appService, activatedRoute, formService, router, translateService, themeApiService, responseErrorService, notifyService) {
        super();
        this.appService = appService;
        this.activatedRoute = activatedRoute;
        this.formService = formService;
        this.router = router;
        this.translateService = translateService;
        this.themeApiService = themeApiService;
        this.responseErrorService = responseErrorService;
        this.notifyService = notifyService;
        this.UploadFile = UploadFileType;
        this.CodemirrorMode = CodemirrorMode;
        this.form = this.formService.form({
            id: [],
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.stringValidator)({ min: -1, max: 250 })]],
            description: [null, [(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.stringValidator)({ min: -1, max: 250 })]],
            system_name: [],
            css: [],
            javascript: [],
            icon: new _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormControl(),
            logo: new _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormControl(),
            fonts: new _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormControl(),
        });
        this.fonts = [];
        this.loading = false;
    }
    get title() {
        return this.form.state === plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormState.Create ? '$.create' : '$.save';
    }
    get icon() {
        return this.form.value.icon;
    }
    get logo() {
        return this.form.value.logo;
    }
    ngOnInit() {
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe((value) => {
                if (value.id) {
                    this.getCurrentTheme();
                    this.loadTheme(value.id);
                }
                else {
                    this.form.patchValue({
                        css: this.translateService.getTranslation('themeCreate.cssDefaultValue'),
                    });
                    this.form.patchValue({
                        javascript: this.translateService.getTranslation('themeCreate.jsDefaultValue'),
                    });
                }
            }),
        ];
    }
    ngAfterContentInit() {
        var _a, _b;
        (_a = this.codeMirrorCss.codeMirror) === null || _a === void 0 ? void 0 : _a.refresh();
        (_b = this.codeMirrorJs.codeMirror) === null || _b === void 0 ? void 0 : _b.refresh();
    }
    codemirrorValueChanged(value, mode) {
        switch (mode) {
            case CodemirrorMode.CSS:
                this.form.patchValue({
                    css: value,
                });
                break;
            case CodemirrorMode.JS:
                this.form.patchValue({
                    javascript: value,
                });
                break;
        }
    }
    setFile(data) {
        switch (data.uploadFileType) {
            case UploadFileType.Icon:
                this.form.patchValue({
                    icon: data.uploadData,
                });
                break;
            case UploadFileType.Logo:
                this.form.patchValue({
                    logo: data.uploadData,
                });
                break;
            case UploadFileType.Font:
                this.fonts.push(data.uploadData);
                this.form.patchValue({
                    fonts: this.fonts,
                });
                break;
        }
    }
    importTheme(theme) {
        this.form.patchValue(theme);
        this.fonts = theme.fonts;
    }
    deleteFile(uploadFile, i = 0) {
        switch (uploadFile) {
            case UploadFileType.Icon:
                this.form.patchValue({
                    icon: null,
                });
                break;
            case UploadFileType.Logo:
                this.form.patchValue({
                    logo: null,
                });
                break;
            case UploadFileType.Font:
                this.fonts.splice(i, 1);
                this.form.patchValue({
                    fonts: this.fonts,
                });
                break;
        }
    }
    export() {
        const id = this.form.value.id;
        const name = this.form.value.name;
        this.themeApiService.export(id).subscribe({
            next: (data) => {
                this.notifyService.toastByName('themeExport');
                (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.download)(name, data);
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'themeCreate.notification.error.export',
                });
            },
        });
    }
    copyPath(name) {
        const path = `/fonts/${name}`;
        navigator.clipboard.writeText(path);
    }
    cancel() {
        this.router.navigateByUrl('/setting/themes');
    }
    submit() {
        this.loading = true;
        if (this.form.state === plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormState.Create) {
            this.themeApiService.save(this.form.value).subscribe({
                next: ({ id }) => {
                    this.loadTheme(id);
                    this.notifyService.toastByName('themeCreate');
                },
                error: (response) => {
                    if (response.status === 400 /* HttpStatusCode.BadRequest */)
                        this.formService.showServerErrors(this.form, response.error);
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: `themeCreate.notification.error.${this.form.state}`,
                    });
                    this.loading = false;
                },
            });
        }
        else {
            this.themeApiService.edit(this.form.value).subscribe({
                next: () => {
                    const id = this.form.value.id;
                    this.loadTheme(id);
                    this.notifyService.toastByName('themeCreate');
                    if (this.currentThemeId === id)
                        window.location.reload();
                },
                error: (response) => {
                    if (response.status === 400 /* HttpStatusCode.BadRequest */)
                        this.formService.showServerErrors(this.form, response.error);
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: `themeCreate.notification.error.${this.form.state}`,
                    });
                    this.loading = false;
                },
            });
        }
    }
    getCurrentTheme() {
        this.appService.theme.subscribe((theme) => {
            if (theme)
                this.currentThemeId = theme.id;
        });
    }
    loadTheme(id) {
        this.themeApiService
            .get(id)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.finalize)(() => (this.loading = false)))
            .subscribe({
            next: (theme) => {
                this.form.patchValue(theme);
                this.fonts = theme.fonts;
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'themesGetDanger',
                });
            },
        });
    }
}
ThemeCreateComponent.ɵfac = function ThemeCreateComponent_Factory(t) { return new (t || ThemeCreateComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslateService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_theme_api_service__WEBPACK_IMPORTED_MODULE_3__.ThemeApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.NotifyService)); };
ThemeCreateComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: ThemeCreateComponent, selectors: [["app-theme-create"]], viewQuery: function ThemeCreateComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c1, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.codeMirrorCss = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.codeMirrorJs = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 83, vars: 63, consts: [[3, "data", "submit"], [1, "header"], [1, "header-actions"], ["variant", "primary", "outline", "", 3, "click", 4, "ngIf"], ["variant", "primary", "outline", "", 3, "click"], ["name", "box-arrow-in-down"], [1, "form"], [1, "col-1"], [1, "fields"], ["name", "name", 1, "input", 3, "placeholder"], ["name", "description", 1, "input", 3, "placeholder"], ["name", "system_name", 1, "input", 3, "placeholder"], [1, "codemirror"], [3, "options", "ngModel", "ngModelChange"], ["codeMirrorCss", ""], ["codeMirrorJs", ""], [1, "actions"], ["variant", "primary", "type", "submit", 3, "disabled"], [1, "files-title"], [1, "files"], [1, "file-item"], [1, "file-header"], ["library", "platform", "name", "theme-icon"], ["variant", "text", 3, "disabled", "click"], ["class", "uploaded-file", 4, "ngIf"], ["library", "platform", "name", "theme-logo"], [1, "file-item", "fonts-wrap"], ["library", "platform", "name", "theme-font"], ["variant", "text", 3, "click"], ["class", "fonts", 4, "ngIf"], [3, "fonts", "onUploadFile", "onUploadTheme"], ["uploadFileComponent", ""], ["variant", "success", "name", "themeCreate"], ["variant", "success", "name", "themeExport"], ["name", "box-arrow-up"], [1, "uploaded-file"], ["name", "x", 3, "click"], [1, "fonts"], ["class", "uploaded-file", 4, "ngFor", "ngForOf"], [3, "content"], ["name", "link-45deg", 3, "click"]], template: function ThemeCreateComponent_Template(rf, ctx) { if (rf & 1) {
        const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "core-form", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("submit", function ThemeCreateComponent_Template_core_form_submit_0_listener() { return ctx.submit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 1)(2, "h1");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](6, ThemeCreateComponent_sl_button_6_Template, 4, 3, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_Template_sl_button_click_7_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](76); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r6.show(ctx.UploadFile.Theme)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](8, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](10, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "div", 6)(12, "div", 7)(13, "div", 8)(14, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](15, "sl-input", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](17, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](18, "sl-input", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](20, "sl-input", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](22, "div", 8)(23, "div", 12)(24, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](25, "CSS");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "ngx-codemirror", 13, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ThemeCreateComponent_Template_ngx_codemirror_ngModelChange_26_listener($event) { return ctx.form.value.css = $event; })("ngModelChange", function ThemeCreateComponent_Template_ngx_codemirror_ngModelChange_26_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](27); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx.codemirrorValueChanged(_r1.value, ctx.CodemirrorMode.CSS)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](28, "div", 12)(29, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](30, "JavaScript");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](31, "ngx-codemirror", 13, 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ThemeCreateComponent_Template_ngx_codemirror_ngModelChange_31_listener($event) { return ctx.form.value.javascript = $event; })("ngModelChange", function ThemeCreateComponent_Template_ngx_codemirror_ngModelChange_31_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](32); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx.codemirrorValueChanged(_r2.value, ctx.CodemirrorMode.JS)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](33, "div", 16)(34, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_Template_sl_button_click_34_listener() { return ctx.cancel(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](35);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](36, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](37, "sl-button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](38);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](39, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](40, "div")(41, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](43, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](44, "div", 19)(45, "div", 20)(46, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](47, "sl-icon", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](48, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](49);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](50, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](51, "sl-button", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_Template_sl_button_click_51_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](76); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r6.show(ctx.UploadFile.Icon)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](52);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](53, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](54, ThemeCreateComponent_div_54_Template, 5, 1, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](55, "div", 20)(56, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](57, "sl-icon", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](58, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](59);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](60, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](61, "sl-button", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_Template_sl_button_click_61_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](76); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r6.show(ctx.UploadFile.Logo)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](62);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](63, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](64, ThemeCreateComponent_div_64_Template, 5, 1, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](65, "div", 26)(66, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](67, "sl-icon", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](68, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](69);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](70, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](71, "sl-button", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ThemeCreateComponent_Template_sl_button_click_71_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](76); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r6.show(ctx.UploadFile.Font)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](72);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](73, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](74, ThemeCreateComponent_div_74_Template, 2, 1, "div", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](75, "app-upload-file", 30, 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onUploadFile", function ThemeCreateComponent_Template_app_upload_file_onUploadFile_75_listener($event) { return ctx.setFile($event); })("onUploadTheme", function ThemeCreateComponent_Template_app_upload_file_onUploadTheme_75_listener($event) { return ctx.importTheme($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](77, "core-notify", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](78);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](79, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](80, "core-notify", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](81);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](82, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 29, "themeCreate." + ctx.form.state));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.form.value.id);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](10, 31, "themeCreate.import"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](16, 33, "themeCreate.name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](19, 35, "themeCreate.description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](21, 37, "themeCreate.systemName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("options", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](61, _c2))("ngModel", ctx.form.value.css);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("options", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](62, _c3))("ngModel", ctx.form.value.javascript);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](36, 39, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("disabled", ctx.loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](39, 41, ctx.title), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](43, 43, "themeCreate.files"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](50, 45, "themeCreate.icon"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("disabled", ctx.icon);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](53, 47, "$.upload"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.icon);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](60, 49, "themeCreate.logo"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("disabled", ctx.logo);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](63, 51, "$.upload"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.logo);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](70, 53, "themeCreate.fonts"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](73, 55, "$.upload"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.fonts && ctx.fonts.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("fonts", ctx.fonts);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](79, 57, "themeCreate.notification.success." + ctx.form.state), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](82, 59, "themeCreate.notification.success.export"), "\n");
    } }, styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n}\n.header-actions[_ngcontent-%COMP%] {\n  display: flex;\n  column-gap: 14px;\n}\n.header-actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  height: auto;\n  padding: var(--sl-spacing-2x-small) 14px;\n  background: var(--sl-color-neutral-0);\n}\n.header-actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(label) {\n  padding: 0;\n  font-size: 13px;\n  line-height: 18px;\n}\n.header-actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n  font-size: var(--sl-spacing-medium);\n}\nh1[_ngcontent-%COMP%] {\n  margin: 0;\n  font-size: var(--sl-font-size-large);\n  line-height: 48px;\n  color: var(--sl-color-secondary-900);\n}\n.form[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: 66% calc(34% - var(--sl-spacing-3x-large));\n  column-gap: var(--sl-spacing-3x-large);\n  margin-top: 24px;\n}\n.fields[_ngcontent-%COMP%] {\n  display: grid;\n  row-gap: var(--sl-spacing-x-small);\n}\n.col-1[_ngcontent-%COMP%] {\n  display: grid;\n  row-gap: var(--sl-spacing-medium);\n  align-content: baseline;\n}\n.files-title[_ngcontent-%COMP%] {\n  margin: 0 0 var(--sl-spacing-small);\n  font-size: var(--sl-font-size-small);\n  font-weight: 600;\n  line-height: 29px;\n  color: var(--sl-color-secondary-900);\n}\n.files[_ngcontent-%COMP%] {\n  display: grid;\n  row-gap: var(--sl-spacing-small);\n}\n.file-item[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-small) var(--sl-spacing-medium);\n  background: var(--sl-color-neutral-0);\n  border: 0 solid var(--sl-color-borders-and-bg-200);\n  border-radius: var(--sl-border-radius-medium);\n}\n.fonts-wrap[_ngcontent-%COMP%] {\n  padding-right: 0;\n}\n.fonts-wrap[_ngcontent-%COMP%]   .file-header[_ngcontent-%COMP%] {\n  padding-right: var(--sl-spacing-medium);\n}\n.fonts[_ngcontent-%COMP%] {\n  margin-top: var(--sl-spacing-x-small);\n  max-height: 59vh;\n  overflow-y: auto;\n  scrollbar-gutter: stable;\n}\n.fonts[_ngcontent-%COMP%]   .uploaded-file[_ngcontent-%COMP%] {\n  padding-right: var(--sl-spacing-small);\n}\n.file-header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.file-header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  flex: 1;\n  margin-left: 10px;\n}\n.file-header[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  padding: var(--sl-spacing-2x-small) 10px;\n  font-size: 13px;\n}\nh2[_ngcontent-%COMP%] {\n  margin: 0;\n  font-size: var(--sl-font-size-small);\n  line-height: 29px;\n  color: var(--sl-color-secondary-900);\n}\n.actions[_ngcontent-%COMP%] {\n  display: flex;\n  column-gap: 14px;\n}\n.actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:first-of-type::part(base) {\n  background: var(--sl-color-neutral-0);\n}\n.codemirror[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 22vh;\n  padding: var(--sl-spacing-2x-small) var(--sl-spacing-medium);\n  border: 1px dashed var(--sl-color-borders-and-bg-200);\n  border-radius: var(--sl-border-radius-medium);\n  background: var(--sl-color-neutral-0);\n  overflow: hidden;\n}\nngx-codemirror[_ngcontent-%COMP%] {\n  overflow: auto;\n}\n.uploaded-file[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.uploaded-file[_ngcontent-%COMP%]:not(:first-of-type) {\n  margin-top: var(--sl-spacing-x-small);\n}\n.uploaded-file[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  flex-grow: 1;\n  font-size: 14px;\n  line-height: 19px;\n  color: var(--sl-color-primary-500);\n}\n.uploaded-file[_ngcontent-%COMP%]   div[_ngcontent-%COMP%] {\n  display: flex;\n  column-gap: var(--sl-spacing-x-small);\n}\n.uploaded-file[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%]::part(base) {\n  padding: 0;\n}\ncore-validate[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.Debounce)(100)
], ThemeCreateComponent.prototype, "ngAfterContentInit", null);


/***/ }),

/***/ 5914:
/*!**************************************************************************************************!*\
  !*** ./src/app/pages/settings/settings-themes/theme-create/upload-file/upload-file.component.ts ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoadingStatus": () => (/* binding */ LoadingStatus),
/* harmony export */   "UploadFileComponent": () => (/* binding */ UploadFileComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _theme_create_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../theme-create.component */ 9963);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _api_theme_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../api/theme-api.service */ 3745);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! shoelace-style-angular */ 5219);











function UploadFileComponent_ng_container_5_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function UploadFileComponent_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](4, "sl-icon", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, UploadFileComponent_ng_container_5_ng_container_5_Template, 1, 0, "ng-container", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 2, "uploadFile.fileUploadError"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5);
} }
const _c0 = function (a0) { return { type: a0 }; };
function UploadFileComponent_ng_container_6_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind2"](2, 1, "uploadFile.fileType", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](4, _c0, ctx_r8.typeOfFile)), " ");
} }
function UploadFileComponent_ng_container_6_ng_template_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 1, "uploadFile.fileTypeTheme"), " ");
} }
function UploadFileComponent_ng_container_6_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function UploadFileComponent_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, UploadFileComponent_ng_container_6_ng_container_2_Template, 3, 6, "ng-container", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, UploadFileComponent_ng_container_6_ng_template_3_Template, 2, 3, "ng-template", null, 16, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, UploadFileComponent_ng_container_6_ng_container_5_Template, 1, 0, "ng-container", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](4);
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r1.uploadFileType !== ctx_r1.UploadFileType.Theme)("ngIfElse", _r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5);
} }
function UploadFileComponent_ng_container_7_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function UploadFileComponent_ng_container_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "span", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, UploadFileComponent_ng_container_7_ng_container_6_Template, 1, 0, "ng-container", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](ctx_r2.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](5, 3, "uploadFile.fileUploadSuccess"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5);
} }
function UploadFileComponent_p_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "uploadFile.theme"), " ");
} }
function UploadFileComponent_sl_button_13_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function UploadFileComponent_sl_button_13_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r13.save()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "$.save"), " ");
} }
function UploadFileComponent_ng_template_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](1, "sl-icon", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("loading", ctx_r6.loadStatus === ctx_r6.LoadingStatus.Loading);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 2, ctx_r6.titleBtn), " ");
} }
var LoadingStatus;
(function (LoadingStatus) {
    LoadingStatus[LoadingStatus["Default"] = 0] = "Default";
    LoadingStatus[LoadingStatus["Loading"] = 1] = "Loading";
    LoadingStatus[LoadingStatus["Success"] = 2] = "Success";
    LoadingStatus[LoadingStatus["Fail"] = 3] = "Fail";
})(LoadingStatus || (LoadingStatus = {}));
const ERROR_MESSAGE = 'Error downloading the file. Download a .zip file';
class UploadFileComponent {
    constructor(themeApiService, notifyService, responseErrorService, formService) {
        this.themeApiService = themeApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.formService = formService;
        this.fonts = [];
        this.onUploadFile = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.onUploadTheme = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.LoadingStatus = LoadingStatus;
        this.UploadFileType = _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType;
        this.open = false;
        this.loadStatus = LoadingStatus.Default;
        this.name = '';
        this.errorMessage = '';
        this.validatorExist = (control) => {
            const exist = this.fonts.find((font) => font.name.split('.').shift() === control.value);
            return exist
                ? {
                    'themeCreate.fonts.exist': {
                        value: control.value,
                    },
                }
                : null;
        };
        this.form = this.formService.form({
            name: [
                '',
                [
                    this.validatorExist,
                    plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required,
                    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.stringValidator)({ min: -1, max: 250 }),
                ],
            ],
        });
    }
    get title() {
        switch (this.uploadFileType) {
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Icon:
                return 'uploadFile.importIcon';
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Logo:
                return 'uploadFile.importLogo';
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Font:
                return 'uploadFile.importFont';
            default:
                return 'uploadFile.importTheme';
        }
    }
    get titleBtn() {
        return this.loadStatus === LoadingStatus.Success
            ? 'uploadFile.uploadNew'
            : 'uploadFile.upload';
    }
    get typeOfFile() {
        switch (this.uploadFileType) {
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Icon:
                return '.ico';
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Logo:
                return '.jpeg, .jpg, .png, .svg';
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Font:
                return '.ttf, .otf';
            case _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Theme:
                return '.zip';
            default:
                return '';
        }
    }
    show(uploadFile) {
        this.open = true;
        this.uploadFileType = uploadFile;
        this.reset();
    }
    upload(file) {
        this.loadStatus = LoadingStatus.Loading;
        this.name = file.name;
        this.form.patchValue({
            name: file.name.split('.').shift(),
        });
        if (this.uploadFileType !== _theme_create_component__WEBPACK_IMPORTED_MODULE_0__.UploadFileType.Theme) {
            this.themeApiService.upload(file).subscribe({
                next: ({ relative_path }) => {
                    this.loadStatus = LoadingStatus.Success;
                    this.uploadData = {
                        name: file.name,
                        file_path: relative_path,
                    };
                },
                error: (response) => {
                    this.loadStatus = LoadingStatus.Fail;
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: 'themeCreate.notification.error.fileError',
                    });
                },
            });
        }
        else {
            this.themeApiService.import(file).subscribe({
                next: (theme) => {
                    this.loadStatus = LoadingStatus.Success;
                    this.themeImportData = theme;
                    this.notifyService.toastByName('themeImport');
                },
                error: (response) => {
                    this.loadStatus = LoadingStatus.Fail;
                    const message = (name) => `themeCreate.notification.error.${name}`;
                    if (response.status === 400 /* HttpStatusCode.BadRequest */) {
                        if (response.error.message === ERROR_MESSAGE) {
                            this.errorMessage =
                                file.size < 100
                                    ? message('layoutZip')
                                    : message('notZip');
                        }
                        else {
                            this.errorMessage = message('layoutZip');
                        }
                        this.notifyService.toastByName('noValidZip');
                    }
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: 'themeCreate.notification.error.import',
                    });
                },
            });
        }
    }
    save() {
        if (this.form.invalid) {
            this.formService.showLocalErrors(this.form);
            return;
        }
        this.open = false;
        this.loadStatus = LoadingStatus.Default;
        if (this.uploadData) {
            const name = this.form.value.name;
            if (name)
                this.uploadData.name = `${name.trim()}.${this.uploadData.name
                    .split('.')
                    .pop()}`;
            this.onUploadFile.emit({
                uploadFileType: this.uploadFileType,
                uploadData: this.uploadData,
            });
        }
        if (this.themeImportData)
            this.onUploadTheme.emit(this.themeImportData);
    }
    reset() {
        this.name = '';
        this.uploadData = undefined;
        this.themeImportData = undefined;
        this.loadStatus = LoadingStatus.Default;
        this.form.reset();
    }
}
UploadFileComponent.ɵfac = function UploadFileComponent_Factory(t) { return new (t || UploadFileComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_api_theme_api_service__WEBPACK_IMPORTED_MODULE_1__.ThemeApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService)); };
UploadFileComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: UploadFileComponent, selectors: [["app-upload-file"]], inputs: { fonts: "fonts" }, outputs: { onUploadFile: "onUploadFile", onUploadTheme: "onUploadTheme" }, decls: 22, vars: 25, consts: [[3, "open", "label", "openChange", "hide"], [3, "accept", "pick"], [1, "container", 3, "ngSwitch"], [4, "ngSwitchCase"], [3, "data"], ["name", "name", 3, "label"], ["class", "hint", 4, "ngIf"], ["slot", "footer", "variant", "primary", 3, "click", 4, "ngIf"], ["uploadButton", ""], ["variant", "success", "name", "themeImport"], ["variant", "danger", "name", "noValidZip"], [1, "status"], ["name", "exclamation-circle"], [4, "ngTemplateOutlet"], [1, "type"], [4, "ngIf", "ngIfElse"], ["theme", ""], [1, "file-name"], [1, "hint"], ["slot", "footer", "variant", "primary", 3, "click"], ["variant", "primary", "outline", "", 1, "upload-button", 3, "loading"], ["name", "box-arrow-in-down"]], template: function UploadFileComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function UploadFileComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.open = $event; })("hide", function UploadFileComponent_Template_sl_dialog_hide_0_listener() { return ctx.reset(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "core-file")(3, "core-file-source", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("pick", function UploadFileComponent_Template_core_file_source_pick_3_listener($event) { return ctx.upload($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, UploadFileComponent_ng_container_5_Template, 6, 4, "ng-container", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, UploadFileComponent_ng_container_6_Template, 6, 3, "ng-container", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](7, UploadFileComponent_ng_container_7_Template, 7, 5, "ng-container", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](8, "core-form", 4)(9, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](10, "sl-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](12, UploadFileComponent_p_12_Template, 3, 3, "p", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](13, UploadFileComponent_sl_button_13_Template, 3, 3, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](14, UploadFileComponent_ng_template_14_Template, 4, 4, "ng-template", null, 8, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](16, "core-notify", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "core-notify", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("open", ctx.open)("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 17, ctx.title));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("accept", ctx.typeOfFile);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngSwitch", ctx.loadStatus);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngSwitchCase", ctx.LoadingStatus.Fail);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngSwitchCase", ctx.LoadingStatus.Default);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngSwitchCase", ctx.LoadingStatus.Success);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.loadStatus !== ctx.LoadingStatus.Success);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.uploadFileType !== ctx.UploadFileType.Font);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 19, "themeCreate.fonts.label"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.loadStatus !== ctx.LoadingStatus.Success && ctx.uploadFileType === ctx.UploadFileType.Theme);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.loadStatus === ctx.LoadingStatus.Success);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](18, 21, "themeCreate.notification.success.import"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](21, 23, ctx.errorMessage), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgTemplateOutlet, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgSwitch, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgSwitchCase, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FileComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FileSourceComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["core-file[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-large);\n  padding: 0 var(--sl-spacing-medium);\n  background-color: var(--sl-color-border-and-bg-50);\n  border: 1px dashed var(--sl-color-borders-and-bg-200);\n  border-radius: var(--sl-border-radius-medium);\n}\ncore-file[_ngcontent-%COMP%]     sl-icon[name='upload'] {\n  margin-bottom: 0;\n}\ncore-file[_ngcontent-%COMP%]     .items {\n  grid-template-columns: 1fr;\n  font-size: 14px;\n  line-height: 19px;\n  color: var(--sl-color-primary-500);\n}\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.type[_ngcontent-%COMP%] {\n  display: inline-block;\n  margin-bottom: 24px;\n}\n.file-name[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: var(--sl-spacing-x-small);\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n  text-align: center;\n  color: var(--sl-color-primary-500);\n  word-break: break-word;\n}\n.status[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: 24px;\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n  text-align: center;\n  color: var(--sl-color-info-500);\n}\n.status[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-danger-500);\n}\nsl-button.upload-button[_ngcontent-%COMP%]::part(base) {\n  height: auto;\n  padding: var(--sl-spacing-2x-small) 14px;\n  background: var(--sl-color-neutral-0);\n}\nsl-button.upload-button[_ngcontent-%COMP%]::part(label) {\n  padding: 0;\n  font-size: 13px;\n  line-height: 18px;\n}\nsl-button.upload-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n  font-size: var(--sl-spacing-medium);\n}\n.hint[_ngcontent-%COMP%] {\n  margin: 0;\n  font-size: var(--sl-font-size-x-small);\n  line-height: 140%;\n  color: var(--sl-color-info-500);\n  white-space: break-spaces;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.UpdateImmediately)()
], UploadFileComponent.prototype, "errorMessage", void 0);


/***/ }),

/***/ 2429:
/*!*****************************************************!*\
  !*** ./src/app/services/server-response.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ServerResponseService": () => (/* binding */ ServerResponseService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);



class ServerResponseService {
    constructor(responseErrorService) {
        this.responseErrorService = responseErrorService;
        this.errorsTemplate = [
            404 /* HttpStatusCode.NotFound */,
            403 /* HttpStatusCode.Forbidden */,
            500 /* HttpStatusCode.InternalServerError */,
            503 /* HttpStatusCode.ServiceUnavailable */,
        ];
    }
    getStatusOrNotify(response, key = '') {
        if (this.errorsTemplate.includes(response.status)) {
            return response.status;
        }
        this.responseErrorService.show.emit({
            responseError: response,
            key,
        });
        return null;
    }
}
ServerResponseService.ɵfac = function ServerResponseService_Factory(t) { return new (t || ServerResponseService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.ResponseErrorService)); };
ServerResponseService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ServerResponseService, factory: ServerResponseService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 1987:
/*!*************************************************************!*\
  !*** ./node_modules/codemirror/addon/edit/closebrackets.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE
(function (mod) {
  if (true) // CommonJS
    mod(__webpack_require__(/*! ../../lib/codemirror */ 8394));else {}
})(function (CodeMirror) {
  var defaults = {
    pairs: "()[]{}''\"\"",
    closeBefore: ")]}'\":;>",
    triples: "",
    explode: "[]{}"
  };
  var Pos = CodeMirror.Pos;
  CodeMirror.defineOption("autoCloseBrackets", false, function (cm, val, old) {
    if (old && old != CodeMirror.Init) {
      cm.removeKeyMap(keyMap);
      cm.state.closeBrackets = null;
    }

    if (val) {
      ensureBound(getOption(val, "pairs"));
      cm.state.closeBrackets = val;
      cm.addKeyMap(keyMap);
    }
  });

  function getOption(conf, name) {
    if (name == "pairs" && typeof conf == "string") return conf;
    if (typeof conf == "object" && conf[name] != null) return conf[name];
    return defaults[name];
  }

  var keyMap = {
    Backspace: handleBackspace,
    Enter: handleEnter
  };

  function ensureBound(chars) {
    for (var i = 0; i < chars.length; i++) {
      var ch = chars.charAt(i),
          key = "'" + ch + "'";
      if (!keyMap[key]) keyMap[key] = handler(ch);
    }
  }

  ensureBound(defaults.pairs + "`");

  function handler(ch) {
    return function (cm) {
      return handleChar(cm, ch);
    };
  }

  function getConfig(cm) {
    var deflt = cm.state.closeBrackets;
    if (!deflt || deflt.override) return deflt;
    var mode = cm.getModeAt(cm.getCursor());
    return mode.closeBrackets || deflt;
  }

  function handleBackspace(cm) {
    var conf = getConfig(cm);
    if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;
    var pairs = getOption(conf, "pairs");
    var ranges = cm.listSelections();

    for (var i = 0; i < ranges.length; i++) {
      if (!ranges[i].empty()) return CodeMirror.Pass;
      var around = charsAround(cm, ranges[i].head);
      if (!around || pairs.indexOf(around) % 2 != 0) return CodeMirror.Pass;
    }

    for (var i = ranges.length - 1; i >= 0; i--) {
      var cur = ranges[i].head;
      cm.replaceRange("", Pos(cur.line, cur.ch - 1), Pos(cur.line, cur.ch + 1), "+delete");
    }
  }

  function handleEnter(cm) {
    var conf = getConfig(cm);
    var explode = conf && getOption(conf, "explode");
    if (!explode || cm.getOption("disableInput")) return CodeMirror.Pass;
    var ranges = cm.listSelections();

    for (var i = 0; i < ranges.length; i++) {
      if (!ranges[i].empty()) return CodeMirror.Pass;
      var around = charsAround(cm, ranges[i].head);
      if (!around || explode.indexOf(around) % 2 != 0) return CodeMirror.Pass;
    }

    cm.operation(function () {
      var linesep = cm.lineSeparator() || "\n";
      cm.replaceSelection(linesep + linesep, null);
      moveSel(cm, -1);
      ranges = cm.listSelections();

      for (var i = 0; i < ranges.length; i++) {
        var line = ranges[i].head.line;
        cm.indentLine(line, null, true);
        cm.indentLine(line + 1, null, true);
      }
    });
  }

  function moveSel(cm, dir) {
    var newRanges = [],
        ranges = cm.listSelections(),
        primary = 0;

    for (var i = 0; i < ranges.length; i++) {
      var range = ranges[i];
      if (range.head == cm.getCursor()) primary = i;
      var pos = range.head.ch || dir > 0 ? {
        line: range.head.line,
        ch: range.head.ch + dir
      } : {
        line: range.head.line - 1
      };
      newRanges.push({
        anchor: pos,
        head: pos
      });
    }

    cm.setSelections(newRanges, primary);
  }

  function contractSelection(sel) {
    var inverted = CodeMirror.cmpPos(sel.anchor, sel.head) > 0;
    return {
      anchor: new Pos(sel.anchor.line, sel.anchor.ch + (inverted ? -1 : 1)),
      head: new Pos(sel.head.line, sel.head.ch + (inverted ? 1 : -1))
    };
  }

  function handleChar(cm, ch) {
    var conf = getConfig(cm);
    if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;
    var pairs = getOption(conf, "pairs");
    var pos = pairs.indexOf(ch);
    if (pos == -1) return CodeMirror.Pass;
    var closeBefore = getOption(conf, "closeBefore");
    var triples = getOption(conf, "triples");
    var identical = pairs.charAt(pos + 1) == ch;
    var ranges = cm.listSelections();
    var opening = pos % 2 == 0;
    var type;

    for (var i = 0; i < ranges.length; i++) {
      var range = ranges[i],
          cur = range.head,
          curType;
      var next = cm.getRange(cur, Pos(cur.line, cur.ch + 1));

      if (opening && !range.empty()) {
        curType = "surround";
      } else if ((identical || !opening) && next == ch) {
        if (identical && stringStartsAfter(cm, cur)) curType = "both";else if (triples.indexOf(ch) >= 0 && cm.getRange(cur, Pos(cur.line, cur.ch + 3)) == ch + ch + ch) curType = "skipThree";else curType = "skip";
      } else if (identical && cur.ch > 1 && triples.indexOf(ch) >= 0 && cm.getRange(Pos(cur.line, cur.ch - 2), cur) == ch + ch) {
        if (cur.ch > 2 && /\bstring/.test(cm.getTokenTypeAt(Pos(cur.line, cur.ch - 2)))) return CodeMirror.Pass;
        curType = "addFour";
      } else if (identical) {
        var prev = cur.ch == 0 ? " " : cm.getRange(Pos(cur.line, cur.ch - 1), cur);
        if (!CodeMirror.isWordChar(next) && prev != ch && !CodeMirror.isWordChar(prev)) curType = "both";else return CodeMirror.Pass;
      } else if (opening && (next.length === 0 || /\s/.test(next) || closeBefore.indexOf(next) > -1)) {
        curType = "both";
      } else {
        return CodeMirror.Pass;
      }

      if (!type) type = curType;else if (type != curType) return CodeMirror.Pass;
    }

    var left = pos % 2 ? pairs.charAt(pos - 1) : ch;
    var right = pos % 2 ? ch : pairs.charAt(pos + 1);
    cm.operation(function () {
      if (type == "skip") {
        moveSel(cm, 1);
      } else if (type == "skipThree") {
        moveSel(cm, 3);
      } else if (type == "surround") {
        var sels = cm.getSelections();

        for (var i = 0; i < sels.length; i++) sels[i] = left + sels[i] + right;

        cm.replaceSelections(sels, "around");
        sels = cm.listSelections().slice();

        for (var i = 0; i < sels.length; i++) sels[i] = contractSelection(sels[i]);

        cm.setSelections(sels);
      } else if (type == "both") {
        cm.replaceSelection(left + right, null);
        cm.triggerElectric(left + right);
        moveSel(cm, -1);
      } else if (type == "addFour") {
        cm.replaceSelection(left + left + left + left, "before");
        moveSel(cm, 1);
      }
    });
  }

  function charsAround(cm, pos) {
    var str = cm.getRange(Pos(pos.line, pos.ch - 1), Pos(pos.line, pos.ch + 1));
    return str.length == 2 ? str : null;
  }

  function stringStartsAfter(cm, pos) {
    var token = cm.getTokenAt(Pos(pos.line, pos.ch + 1));
    return /\bstring/.test(token.type) && token.start == pos.ch && (pos.ch == 0 || !/\bstring/.test(cm.getTokenTypeAt(pos)));
  }
});

/***/ }),

/***/ 2815:
/*!*************************************************!*\
  !*** ./node_modules/codemirror/mode/css/css.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE
(function (mod) {
  if (true) // CommonJS
    mod(__webpack_require__(/*! ../../lib/codemirror */ 8394));else {}
})(function (CodeMirror) {
  "use strict";

  CodeMirror.defineMode("css", function (config, parserConfig) {
    var inline = parserConfig.inline;
    if (!parserConfig.propertyKeywords) parserConfig = CodeMirror.resolveMode("text/css");
    var indentUnit = config.indentUnit,
        tokenHooks = parserConfig.tokenHooks,
        documentTypes = parserConfig.documentTypes || {},
        mediaTypes = parserConfig.mediaTypes || {},
        mediaFeatures = parserConfig.mediaFeatures || {},
        mediaValueKeywords = parserConfig.mediaValueKeywords || {},
        propertyKeywords = parserConfig.propertyKeywords || {},
        nonStandardPropertyKeywords = parserConfig.nonStandardPropertyKeywords || {},
        fontProperties = parserConfig.fontProperties || {},
        counterDescriptors = parserConfig.counterDescriptors || {},
        colorKeywords = parserConfig.colorKeywords || {},
        valueKeywords = parserConfig.valueKeywords || {},
        allowNested = parserConfig.allowNested,
        lineComment = parserConfig.lineComment,
        supportsAtComponent = parserConfig.supportsAtComponent === true,
        highlightNonStandardPropertyKeywords = config.highlightNonStandardPropertyKeywords !== false;
    var type, override;

    function ret(style, tp) {
      type = tp;
      return style;
    } // Tokenizers


    function tokenBase(stream, state) {
      var ch = stream.next();

      if (tokenHooks[ch]) {
        var result = tokenHooks[ch](stream, state);
        if (result !== false) return result;
      }

      if (ch == "@") {
        stream.eatWhile(/[\w\\\-]/);
        return ret("def", stream.current());
      } else if (ch == "=" || (ch == "~" || ch == "|") && stream.eat("=")) {
        return ret(null, "compare");
      } else if (ch == "\"" || ch == "'") {
        state.tokenize = tokenString(ch);
        return state.tokenize(stream, state);
      } else if (ch == "#") {
        stream.eatWhile(/[\w\\\-]/);
        return ret("atom", "hash");
      } else if (ch == "!") {
        stream.match(/^\s*\w*/);
        return ret("keyword", "important");
      } else if (/\d/.test(ch) || ch == "." && stream.eat(/\d/)) {
        stream.eatWhile(/[\w.%]/);
        return ret("number", "unit");
      } else if (ch === "-") {
        if (/[\d.]/.test(stream.peek())) {
          stream.eatWhile(/[\w.%]/);
          return ret("number", "unit");
        } else if (stream.match(/^-[\w\\\-]*/)) {
          stream.eatWhile(/[\w\\\-]/);
          if (stream.match(/^\s*:/, false)) return ret("variable-2", "variable-definition");
          return ret("variable-2", "variable");
        } else if (stream.match(/^\w+-/)) {
          return ret("meta", "meta");
        }
      } else if (/[,+>*\/]/.test(ch)) {
        return ret(null, "select-op");
      } else if (ch == "." && stream.match(/^-?[_a-z][_a-z0-9-]*/i)) {
        return ret("qualifier", "qualifier");
      } else if (/[:;{}\[\]\(\)]/.test(ch)) {
        return ret(null, ch);
      } else if (stream.match(/^[\w-.]+(?=\()/)) {
        if (/^(url(-prefix)?|domain|regexp)$/i.test(stream.current())) {
          state.tokenize = tokenParenthesized;
        }

        return ret("variable callee", "variable");
      } else if (/[\w\\\-]/.test(ch)) {
        stream.eatWhile(/[\w\\\-]/);
        return ret("property", "word");
      } else {
        return ret(null, null);
      }
    }

    function tokenString(quote) {
      return function (stream, state) {
        var escaped = false,
            ch;

        while ((ch = stream.next()) != null) {
          if (ch == quote && !escaped) {
            if (quote == ")") stream.backUp(1);
            break;
          }

          escaped = !escaped && ch == "\\";
        }

        if (ch == quote || !escaped && quote != ")") state.tokenize = null;
        return ret("string", "string");
      };
    }

    function tokenParenthesized(stream, state) {
      stream.next(); // Must be '('

      if (!stream.match(/^\s*[\"\')]/, false)) state.tokenize = tokenString(")");else state.tokenize = null;
      return ret(null, "(");
    } // Context management


    function Context(type, indent, prev) {
      this.type = type;
      this.indent = indent;
      this.prev = prev;
    }

    function pushContext(state, stream, type, indent) {
      state.context = new Context(type, stream.indentation() + (indent === false ? 0 : indentUnit), state.context);
      return type;
    }

    function popContext(state) {
      if (state.context.prev) state.context = state.context.prev;
      return state.context.type;
    }

    function pass(type, stream, state) {
      return states[state.context.type](type, stream, state);
    }

    function popAndPass(type, stream, state, n) {
      for (var i = n || 1; i > 0; i--) state.context = state.context.prev;

      return pass(type, stream, state);
    } // Parser


    function wordAsValue(stream) {
      var word = stream.current().toLowerCase();
      if (valueKeywords.hasOwnProperty(word)) override = "atom";else if (colorKeywords.hasOwnProperty(word)) override = "keyword";else override = "variable";
    }

    var states = {};

    states.top = function (type, stream, state) {
      if (type == "{") {
        return pushContext(state, stream, "block");
      } else if (type == "}" && state.context.prev) {
        return popContext(state);
      } else if (supportsAtComponent && /@component/i.test(type)) {
        return pushContext(state, stream, "atComponentBlock");
      } else if (/^@(-moz-)?document$/i.test(type)) {
        return pushContext(state, stream, "documentTypes");
      } else if (/^@(media|supports|(-moz-)?document|import)$/i.test(type)) {
        return pushContext(state, stream, "atBlock");
      } else if (/^@(font-face|counter-style)/i.test(type)) {
        state.stateArg = type;
        return "restricted_atBlock_before";
      } else if (/^@(-(moz|ms|o|webkit)-)?keyframes$/i.test(type)) {
        return "keyframes";
      } else if (type && type.charAt(0) == "@") {
        return pushContext(state, stream, "at");
      } else if (type == "hash") {
        override = "builtin";
      } else if (type == "word") {
        override = "tag";
      } else if (type == "variable-definition") {
        return "maybeprop";
      } else if (type == "interpolation") {
        return pushContext(state, stream, "interpolation");
      } else if (type == ":") {
        return "pseudo";
      } else if (allowNested && type == "(") {
        return pushContext(state, stream, "parens");
      }

      return state.context.type;
    };

    states.block = function (type, stream, state) {
      if (type == "word") {
        var word = stream.current().toLowerCase();

        if (propertyKeywords.hasOwnProperty(word)) {
          override = "property";
          return "maybeprop";
        } else if (nonStandardPropertyKeywords.hasOwnProperty(word)) {
          override = highlightNonStandardPropertyKeywords ? "string-2" : "property";
          return "maybeprop";
        } else if (allowNested) {
          override = stream.match(/^\s*:(?:\s|$)/, false) ? "property" : "tag";
          return "block";
        } else {
          override += " error";
          return "maybeprop";
        }
      } else if (type == "meta") {
        return "block";
      } else if (!allowNested && (type == "hash" || type == "qualifier")) {
        override = "error";
        return "block";
      } else {
        return states.top(type, stream, state);
      }
    };

    states.maybeprop = function (type, stream, state) {
      if (type == ":") return pushContext(state, stream, "prop");
      return pass(type, stream, state);
    };

    states.prop = function (type, stream, state) {
      if (type == ";") return popContext(state);
      if (type == "{" && allowNested) return pushContext(state, stream, "propBlock");
      if (type == "}" || type == "{") return popAndPass(type, stream, state);
      if (type == "(") return pushContext(state, stream, "parens");

      if (type == "hash" && !/^#([0-9a-fA-F]{3,4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})$/.test(stream.current())) {
        override += " error";
      } else if (type == "word") {
        wordAsValue(stream);
      } else if (type == "interpolation") {
        return pushContext(state, stream, "interpolation");
      }

      return "prop";
    };

    states.propBlock = function (type, _stream, state) {
      if (type == "}") return popContext(state);

      if (type == "word") {
        override = "property";
        return "maybeprop";
      }

      return state.context.type;
    };

    states.parens = function (type, stream, state) {
      if (type == "{" || type == "}") return popAndPass(type, stream, state);
      if (type == ")") return popContext(state);
      if (type == "(") return pushContext(state, stream, "parens");
      if (type == "interpolation") return pushContext(state, stream, "interpolation");
      if (type == "word") wordAsValue(stream);
      return "parens";
    };

    states.pseudo = function (type, stream, state) {
      if (type == "meta") return "pseudo";

      if (type == "word") {
        override = "variable-3";
        return state.context.type;
      }

      return pass(type, stream, state);
    };

    states.documentTypes = function (type, stream, state) {
      if (type == "word" && documentTypes.hasOwnProperty(stream.current())) {
        override = "tag";
        return state.context.type;
      } else {
        return states.atBlock(type, stream, state);
      }
    };

    states.atBlock = function (type, stream, state) {
      if (type == "(") return pushContext(state, stream, "atBlock_parens");
      if (type == "}" || type == ";") return popAndPass(type, stream, state);
      if (type == "{") return popContext(state) && pushContext(state, stream, allowNested ? "block" : "top");
      if (type == "interpolation") return pushContext(state, stream, "interpolation");

      if (type == "word") {
        var word = stream.current().toLowerCase();
        if (word == "only" || word == "not" || word == "and" || word == "or") override = "keyword";else if (mediaTypes.hasOwnProperty(word)) override = "attribute";else if (mediaFeatures.hasOwnProperty(word)) override = "property";else if (mediaValueKeywords.hasOwnProperty(word)) override = "keyword";else if (propertyKeywords.hasOwnProperty(word)) override = "property";else if (nonStandardPropertyKeywords.hasOwnProperty(word)) override = highlightNonStandardPropertyKeywords ? "string-2" : "property";else if (valueKeywords.hasOwnProperty(word)) override = "atom";else if (colorKeywords.hasOwnProperty(word)) override = "keyword";else override = "error";
      }

      return state.context.type;
    };

    states.atComponentBlock = function (type, stream, state) {
      if (type == "}") return popAndPass(type, stream, state);
      if (type == "{") return popContext(state) && pushContext(state, stream, allowNested ? "block" : "top", false);
      if (type == "word") override = "error";
      return state.context.type;
    };

    states.atBlock_parens = function (type, stream, state) {
      if (type == ")") return popContext(state);
      if (type == "{" || type == "}") return popAndPass(type, stream, state, 2);
      return states.atBlock(type, stream, state);
    };

    states.restricted_atBlock_before = function (type, stream, state) {
      if (type == "{") return pushContext(state, stream, "restricted_atBlock");

      if (type == "word" && state.stateArg == "@counter-style") {
        override = "variable";
        return "restricted_atBlock_before";
      }

      return pass(type, stream, state);
    };

    states.restricted_atBlock = function (type, stream, state) {
      if (type == "}") {
        state.stateArg = null;
        return popContext(state);
      }

      if (type == "word") {
        if (state.stateArg == "@font-face" && !fontProperties.hasOwnProperty(stream.current().toLowerCase()) || state.stateArg == "@counter-style" && !counterDescriptors.hasOwnProperty(stream.current().toLowerCase())) override = "error";else override = "property";
        return "maybeprop";
      }

      return "restricted_atBlock";
    };

    states.keyframes = function (type, stream, state) {
      if (type == "word") {
        override = "variable";
        return "keyframes";
      }

      if (type == "{") return pushContext(state, stream, "top");
      return pass(type, stream, state);
    };

    states.at = function (type, stream, state) {
      if (type == ";") return popContext(state);
      if (type == "{" || type == "}") return popAndPass(type, stream, state);
      if (type == "word") override = "tag";else if (type == "hash") override = "builtin";
      return "at";
    };

    states.interpolation = function (type, stream, state) {
      if (type == "}") return popContext(state);
      if (type == "{" || type == ";") return popAndPass(type, stream, state);
      if (type == "word") override = "variable";else if (type != "variable" && type != "(" && type != ")") override = "error";
      return "interpolation";
    };

    return {
      startState: function (base) {
        return {
          tokenize: null,
          state: inline ? "block" : "top",
          stateArg: null,
          context: new Context(inline ? "block" : "top", base || 0, null)
        };
      },
      token: function (stream, state) {
        if (!state.tokenize && stream.eatSpace()) return null;
        var style = (state.tokenize || tokenBase)(stream, state);

        if (style && typeof style == "object") {
          type = style[1];
          style = style[0];
        }

        override = style;
        if (type != "comment") state.state = states[state.state](type, stream, state);
        return override;
      },
      indent: function (state, textAfter) {
        var cx = state.context,
            ch = textAfter && textAfter.charAt(0);
        var indent = cx.indent;
        if (cx.type == "prop" && (ch == "}" || ch == ")")) cx = cx.prev;

        if (cx.prev) {
          if (ch == "}" && (cx.type == "block" || cx.type == "top" || cx.type == "interpolation" || cx.type == "restricted_atBlock")) {
            // Resume indentation from parent context.
            cx = cx.prev;
            indent = cx.indent;
          } else if (ch == ")" && (cx.type == "parens" || cx.type == "atBlock_parens") || ch == "{" && (cx.type == "at" || cx.type == "atBlock")) {
            // Dedent relative to current context.
            indent = Math.max(0, cx.indent - indentUnit);
          }
        }

        return indent;
      },
      electricChars: "}",
      blockCommentStart: "/*",
      blockCommentEnd: "*/",
      blockCommentContinue: " * ",
      lineComment: lineComment,
      fold: "brace"
    };
  });

  function keySet(array) {
    var keys = {};

    for (var i = 0; i < array.length; ++i) {
      keys[array[i].toLowerCase()] = true;
    }

    return keys;
  }

  var documentTypes_ = ["domain", "regexp", "url", "url-prefix"],
      documentTypes = keySet(documentTypes_);
  var mediaTypes_ = ["all", "aural", "braille", "handheld", "print", "projection", "screen", "tty", "tv", "embossed"],
      mediaTypes = keySet(mediaTypes_);
  var mediaFeatures_ = ["width", "min-width", "max-width", "height", "min-height", "max-height", "device-width", "min-device-width", "max-device-width", "device-height", "min-device-height", "max-device-height", "aspect-ratio", "min-aspect-ratio", "max-aspect-ratio", "device-aspect-ratio", "min-device-aspect-ratio", "max-device-aspect-ratio", "color", "min-color", "max-color", "color-index", "min-color-index", "max-color-index", "monochrome", "min-monochrome", "max-monochrome", "resolution", "min-resolution", "max-resolution", "scan", "grid", "orientation", "device-pixel-ratio", "min-device-pixel-ratio", "max-device-pixel-ratio", "pointer", "any-pointer", "hover", "any-hover", "prefers-color-scheme", "dynamic-range", "video-dynamic-range"],
      mediaFeatures = keySet(mediaFeatures_);
  var mediaValueKeywords_ = ["landscape", "portrait", "none", "coarse", "fine", "on-demand", "hover", "interlace", "progressive", "dark", "light", "standard", "high"],
      mediaValueKeywords = keySet(mediaValueKeywords_);
  var propertyKeywords_ = ["align-content", "align-items", "align-self", "alignment-adjust", "alignment-baseline", "all", "anchor-point", "animation", "animation-delay", "animation-direction", "animation-duration", "animation-fill-mode", "animation-iteration-count", "animation-name", "animation-play-state", "animation-timing-function", "appearance", "azimuth", "backdrop-filter", "backface-visibility", "background", "background-attachment", "background-blend-mode", "background-clip", "background-color", "background-image", "background-origin", "background-position", "background-position-x", "background-position-y", "background-repeat", "background-size", "baseline-shift", "binding", "bleed", "block-size", "bookmark-label", "bookmark-level", "bookmark-state", "bookmark-target", "border", "border-bottom", "border-bottom-color", "border-bottom-left-radius", "border-bottom-right-radius", "border-bottom-style", "border-bottom-width", "border-collapse", "border-color", "border-image", "border-image-outset", "border-image-repeat", "border-image-slice", "border-image-source", "border-image-width", "border-left", "border-left-color", "border-left-style", "border-left-width", "border-radius", "border-right", "border-right-color", "border-right-style", "border-right-width", "border-spacing", "border-style", "border-top", "border-top-color", "border-top-left-radius", "border-top-right-radius", "border-top-style", "border-top-width", "border-width", "bottom", "box-decoration-break", "box-shadow", "box-sizing", "break-after", "break-before", "break-inside", "caption-side", "caret-color", "clear", "clip", "color", "color-profile", "column-count", "column-fill", "column-gap", "column-rule", "column-rule-color", "column-rule-style", "column-rule-width", "column-span", "column-width", "columns", "contain", "content", "counter-increment", "counter-reset", "crop", "cue", "cue-after", "cue-before", "cursor", "direction", "display", "dominant-baseline", "drop-initial-after-adjust", "drop-initial-after-align", "drop-initial-before-adjust", "drop-initial-before-align", "drop-initial-size", "drop-initial-value", "elevation", "empty-cells", "fit", "fit-content", "fit-position", "flex", "flex-basis", "flex-direction", "flex-flow", "flex-grow", "flex-shrink", "flex-wrap", "float", "float-offset", "flow-from", "flow-into", "font", "font-family", "font-feature-settings", "font-kerning", "font-language-override", "font-optical-sizing", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-synthesis", "font-variant", "font-variant-alternates", "font-variant-caps", "font-variant-east-asian", "font-variant-ligatures", "font-variant-numeric", "font-variant-position", "font-variation-settings", "font-weight", "gap", "grid", "grid-area", "grid-auto-columns", "grid-auto-flow", "grid-auto-rows", "grid-column", "grid-column-end", "grid-column-gap", "grid-column-start", "grid-gap", "grid-row", "grid-row-end", "grid-row-gap", "grid-row-start", "grid-template", "grid-template-areas", "grid-template-columns", "grid-template-rows", "hanging-punctuation", "height", "hyphens", "icon", "image-orientation", "image-rendering", "image-resolution", "inline-box-align", "inset", "inset-block", "inset-block-end", "inset-block-start", "inset-inline", "inset-inline-end", "inset-inline-start", "isolation", "justify-content", "justify-items", "justify-self", "left", "letter-spacing", "line-break", "line-height", "line-height-step", "line-stacking", "line-stacking-ruby", "line-stacking-shift", "line-stacking-strategy", "list-style", "list-style-image", "list-style-position", "list-style-type", "margin", "margin-bottom", "margin-left", "margin-right", "margin-top", "marks", "marquee-direction", "marquee-loop", "marquee-play-count", "marquee-speed", "marquee-style", "mask-clip", "mask-composite", "mask-image", "mask-mode", "mask-origin", "mask-position", "mask-repeat", "mask-size", "mask-type", "max-block-size", "max-height", "max-inline-size", "max-width", "min-block-size", "min-height", "min-inline-size", "min-width", "mix-blend-mode", "move-to", "nav-down", "nav-index", "nav-left", "nav-right", "nav-up", "object-fit", "object-position", "offset", "offset-anchor", "offset-distance", "offset-path", "offset-position", "offset-rotate", "opacity", "order", "orphans", "outline", "outline-color", "outline-offset", "outline-style", "outline-width", "overflow", "overflow-style", "overflow-wrap", "overflow-x", "overflow-y", "padding", "padding-bottom", "padding-left", "padding-right", "padding-top", "page", "page-break-after", "page-break-before", "page-break-inside", "page-policy", "pause", "pause-after", "pause-before", "perspective", "perspective-origin", "pitch", "pitch-range", "place-content", "place-items", "place-self", "play-during", "position", "presentation-level", "punctuation-trim", "quotes", "region-break-after", "region-break-before", "region-break-inside", "region-fragment", "rendering-intent", "resize", "rest", "rest-after", "rest-before", "richness", "right", "rotate", "rotation", "rotation-point", "row-gap", "ruby-align", "ruby-overhang", "ruby-position", "ruby-span", "scale", "scroll-behavior", "scroll-margin", "scroll-margin-block", "scroll-margin-block-end", "scroll-margin-block-start", "scroll-margin-bottom", "scroll-margin-inline", "scroll-margin-inline-end", "scroll-margin-inline-start", "scroll-margin-left", "scroll-margin-right", "scroll-margin-top", "scroll-padding", "scroll-padding-block", "scroll-padding-block-end", "scroll-padding-block-start", "scroll-padding-bottom", "scroll-padding-inline", "scroll-padding-inline-end", "scroll-padding-inline-start", "scroll-padding-left", "scroll-padding-right", "scroll-padding-top", "scroll-snap-align", "scroll-snap-type", "shape-image-threshold", "shape-inside", "shape-margin", "shape-outside", "size", "speak", "speak-as", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "stress", "string-set", "tab-size", "table-layout", "target", "target-name", "target-new", "target-position", "text-align", "text-align-last", "text-combine-upright", "text-decoration", "text-decoration-color", "text-decoration-line", "text-decoration-skip", "text-decoration-skip-ink", "text-decoration-style", "text-emphasis", "text-emphasis-color", "text-emphasis-position", "text-emphasis-style", "text-height", "text-indent", "text-justify", "text-orientation", "text-outline", "text-overflow", "text-rendering", "text-shadow", "text-size-adjust", "text-space-collapse", "text-transform", "text-underline-position", "text-wrap", "top", "touch-action", "transform", "transform-origin", "transform-style", "transition", "transition-delay", "transition-duration", "transition-property", "transition-timing-function", "translate", "unicode-bidi", "user-select", "vertical-align", "visibility", "voice-balance", "voice-duration", "voice-family", "voice-pitch", "voice-range", "voice-rate", "voice-stress", "voice-volume", "volume", "white-space", "widows", "width", "will-change", "word-break", "word-spacing", "word-wrap", "writing-mode", "z-index", // SVG-specific
  "clip-path", "clip-rule", "mask", "enable-background", "filter", "flood-color", "flood-opacity", "lighting-color", "stop-color", "stop-opacity", "pointer-events", "color-interpolation", "color-interpolation-filters", "color-rendering", "fill", "fill-opacity", "fill-rule", "image-rendering", "marker", "marker-end", "marker-mid", "marker-start", "paint-order", "shape-rendering", "stroke", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke-width", "text-rendering", "baseline-shift", "dominant-baseline", "glyph-orientation-horizontal", "glyph-orientation-vertical", "text-anchor", "writing-mode"],
      propertyKeywords = keySet(propertyKeywords_);
  var nonStandardPropertyKeywords_ = ["accent-color", "aspect-ratio", "border-block", "border-block-color", "border-block-end", "border-block-end-color", "border-block-end-style", "border-block-end-width", "border-block-start", "border-block-start-color", "border-block-start-style", "border-block-start-width", "border-block-style", "border-block-width", "border-inline", "border-inline-color", "border-inline-end", "border-inline-end-color", "border-inline-end-style", "border-inline-end-width", "border-inline-start", "border-inline-start-color", "border-inline-start-style", "border-inline-start-width", "border-inline-style", "border-inline-width", "content-visibility", "margin-block", "margin-block-end", "margin-block-start", "margin-inline", "margin-inline-end", "margin-inline-start", "overflow-anchor", "overscroll-behavior", "padding-block", "padding-block-end", "padding-block-start", "padding-inline", "padding-inline-end", "padding-inline-start", "scroll-snap-stop", "scrollbar-3d-light-color", "scrollbar-arrow-color", "scrollbar-base-color", "scrollbar-dark-shadow-color", "scrollbar-face-color", "scrollbar-highlight-color", "scrollbar-shadow-color", "scrollbar-track-color", "searchfield-cancel-button", "searchfield-decoration", "searchfield-results-button", "searchfield-results-decoration", "shape-inside", "zoom"],
      nonStandardPropertyKeywords = keySet(nonStandardPropertyKeywords_);
  var fontProperties_ = ["font-display", "font-family", "src", "unicode-range", "font-variant", "font-feature-settings", "font-stretch", "font-weight", "font-style"],
      fontProperties = keySet(fontProperties_);
  var counterDescriptors_ = ["additive-symbols", "fallback", "negative", "pad", "prefix", "range", "speak-as", "suffix", "symbols", "system"],
      counterDescriptors = keySet(counterDescriptors_);
  var colorKeywords_ = ["aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "grey", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "rebeccapurple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"],
      colorKeywords = keySet(colorKeywords_);
  var valueKeywords_ = ["above", "absolute", "activeborder", "additive", "activecaption", "afar", "after-white-space", "ahead", "alias", "all", "all-scroll", "alphabetic", "alternate", "always", "amharic", "amharic-abegede", "antialiased", "appworkspace", "arabic-indic", "armenian", "asterisks", "attr", "auto", "auto-flow", "avoid", "avoid-column", "avoid-page", "avoid-region", "axis-pan", "background", "backwards", "baseline", "below", "bidi-override", "binary", "bengali", "blink", "block", "block-axis", "blur", "bold", "bolder", "border", "border-box", "both", "bottom", "break", "break-all", "break-word", "brightness", "bullets", "button", "buttonface", "buttonhighlight", "buttonshadow", "buttontext", "calc", "cambodian", "capitalize", "caps-lock-indicator", "caption", "captiontext", "caret", "cell", "center", "checkbox", "circle", "cjk-decimal", "cjk-earthly-branch", "cjk-heavenly-stem", "cjk-ideographic", "clear", "clip", "close-quote", "col-resize", "collapse", "color", "color-burn", "color-dodge", "column", "column-reverse", "compact", "condensed", "conic-gradient", "contain", "content", "contents", "content-box", "context-menu", "continuous", "contrast", "copy", "counter", "counters", "cover", "crop", "cross", "crosshair", "cubic-bezier", "currentcolor", "cursive", "cyclic", "darken", "dashed", "decimal", "decimal-leading-zero", "default", "default-button", "dense", "destination-atop", "destination-in", "destination-out", "destination-over", "devanagari", "difference", "disc", "discard", "disclosure-closed", "disclosure-open", "document", "dot-dash", "dot-dot-dash", "dotted", "double", "down", "drop-shadow", "e-resize", "ease", "ease-in", "ease-in-out", "ease-out", "element", "ellipse", "ellipsis", "embed", "end", "ethiopic", "ethiopic-abegede", "ethiopic-abegede-am-et", "ethiopic-abegede-gez", "ethiopic-abegede-ti-er", "ethiopic-abegede-ti-et", "ethiopic-halehame-aa-er", "ethiopic-halehame-aa-et", "ethiopic-halehame-am-et", "ethiopic-halehame-gez", "ethiopic-halehame-om-et", "ethiopic-halehame-sid-et", "ethiopic-halehame-so-et", "ethiopic-halehame-ti-er", "ethiopic-halehame-ti-et", "ethiopic-halehame-tig", "ethiopic-numeric", "ew-resize", "exclusion", "expanded", "extends", "extra-condensed", "extra-expanded", "fantasy", "fast", "fill", "fill-box", "fixed", "flat", "flex", "flex-end", "flex-start", "footnotes", "forwards", "from", "geometricPrecision", "georgian", "grayscale", "graytext", "grid", "groove", "gujarati", "gurmukhi", "hand", "hangul", "hangul-consonant", "hard-light", "hebrew", "help", "hidden", "hide", "higher", "highlight", "highlighttext", "hiragana", "hiragana-iroha", "horizontal", "hsl", "hsla", "hue", "hue-rotate", "icon", "ignore", "inactiveborder", "inactivecaption", "inactivecaptiontext", "infinite", "infobackground", "infotext", "inherit", "initial", "inline", "inline-axis", "inline-block", "inline-flex", "inline-grid", "inline-table", "inset", "inside", "intrinsic", "invert", "italic", "japanese-formal", "japanese-informal", "justify", "kannada", "katakana", "katakana-iroha", "keep-all", "khmer", "korean-hangul-formal", "korean-hanja-formal", "korean-hanja-informal", "landscape", "lao", "large", "larger", "left", "level", "lighter", "lighten", "line-through", "linear", "linear-gradient", "lines", "list-item", "listbox", "listitem", "local", "logical", "loud", "lower", "lower-alpha", "lower-armenian", "lower-greek", "lower-hexadecimal", "lower-latin", "lower-norwegian", "lower-roman", "lowercase", "ltr", "luminosity", "malayalam", "manipulation", "match", "matrix", "matrix3d", "media-play-button", "media-slider", "media-sliderthumb", "media-volume-slider", "media-volume-sliderthumb", "medium", "menu", "menulist", "menulist-button", "menutext", "message-box", "middle", "min-intrinsic", "mix", "mongolian", "monospace", "move", "multiple", "multiple_mask_images", "multiply", "myanmar", "n-resize", "narrower", "ne-resize", "nesw-resize", "no-close-quote", "no-drop", "no-open-quote", "no-repeat", "none", "normal", "not-allowed", "nowrap", "ns-resize", "numbers", "numeric", "nw-resize", "nwse-resize", "oblique", "octal", "opacity", "open-quote", "optimizeLegibility", "optimizeSpeed", "oriya", "oromo", "outset", "outside", "outside-shape", "overlay", "overline", "padding", "padding-box", "painted", "page", "paused", "persian", "perspective", "pinch-zoom", "plus-darker", "plus-lighter", "pointer", "polygon", "portrait", "pre", "pre-line", "pre-wrap", "preserve-3d", "progress", "push-button", "radial-gradient", "radio", "read-only", "read-write", "read-write-plaintext-only", "rectangle", "region", "relative", "repeat", "repeating-linear-gradient", "repeating-radial-gradient", "repeating-conic-gradient", "repeat-x", "repeat-y", "reset", "reverse", "rgb", "rgba", "ridge", "right", "rotate", "rotate3d", "rotateX", "rotateY", "rotateZ", "round", "row", "row-resize", "row-reverse", "rtl", "run-in", "running", "s-resize", "sans-serif", "saturate", "saturation", "scale", "scale3d", "scaleX", "scaleY", "scaleZ", "screen", "scroll", "scrollbar", "scroll-position", "se-resize", "searchfield", "searchfield-cancel-button", "searchfield-decoration", "searchfield-results-button", "searchfield-results-decoration", "self-start", "self-end", "semi-condensed", "semi-expanded", "separate", "sepia", "serif", "show", "sidama", "simp-chinese-formal", "simp-chinese-informal", "single", "skew", "skewX", "skewY", "skip-white-space", "slide", "slider-horizontal", "slider-vertical", "sliderthumb-horizontal", "sliderthumb-vertical", "slow", "small", "small-caps", "small-caption", "smaller", "soft-light", "solid", "somali", "source-atop", "source-in", "source-out", "source-over", "space", "space-around", "space-between", "space-evenly", "spell-out", "square", "square-button", "start", "static", "status-bar", "stretch", "stroke", "stroke-box", "sub", "subpixel-antialiased", "svg_masks", "super", "sw-resize", "symbolic", "symbols", "system-ui", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row", "table-row-group", "tamil", "telugu", "text", "text-bottom", "text-top", "textarea", "textfield", "thai", "thick", "thin", "threeddarkshadow", "threedface", "threedhighlight", "threedlightshadow", "threedshadow", "tibetan", "tigre", "tigrinya-er", "tigrinya-er-abegede", "tigrinya-et", "tigrinya-et-abegede", "to", "top", "trad-chinese-formal", "trad-chinese-informal", "transform", "translate", "translate3d", "translateX", "translateY", "translateZ", "transparent", "ultra-condensed", "ultra-expanded", "underline", "unidirectional-pan", "unset", "up", "upper-alpha", "upper-armenian", "upper-greek", "upper-hexadecimal", "upper-latin", "upper-norwegian", "upper-roman", "uppercase", "urdu", "url", "var", "vertical", "vertical-text", "view-box", "visible", "visibleFill", "visiblePainted", "visibleStroke", "visual", "w-resize", "wait", "wave", "wider", "window", "windowframe", "windowtext", "words", "wrap", "wrap-reverse", "x-large", "x-small", "xor", "xx-large", "xx-small"],
      valueKeywords = keySet(valueKeywords_);
  var allWords = documentTypes_.concat(mediaTypes_).concat(mediaFeatures_).concat(mediaValueKeywords_).concat(propertyKeywords_).concat(nonStandardPropertyKeywords_).concat(colorKeywords_).concat(valueKeywords_);
  CodeMirror.registerHelper("hintWords", "css", allWords);

  function tokenCComment(stream, state) {
    var maybeEnd = false,
        ch;

    while ((ch = stream.next()) != null) {
      if (maybeEnd && ch == "/") {
        state.tokenize = null;
        break;
      }

      maybeEnd = ch == "*";
    }

    return ["comment", "comment"];
  }

  CodeMirror.defineMIME("text/css", {
    documentTypes: documentTypes,
    mediaTypes: mediaTypes,
    mediaFeatures: mediaFeatures,
    mediaValueKeywords: mediaValueKeywords,
    propertyKeywords: propertyKeywords,
    nonStandardPropertyKeywords: nonStandardPropertyKeywords,
    fontProperties: fontProperties,
    counterDescriptors: counterDescriptors,
    colorKeywords: colorKeywords,
    valueKeywords: valueKeywords,
    tokenHooks: {
      "/": function (stream, state) {
        if (!stream.eat("*")) return false;
        state.tokenize = tokenCComment;
        return tokenCComment(stream, state);
      }
    },
    name: "css"
  });
  CodeMirror.defineMIME("text/x-scss", {
    mediaTypes: mediaTypes,
    mediaFeatures: mediaFeatures,
    mediaValueKeywords: mediaValueKeywords,
    propertyKeywords: propertyKeywords,
    nonStandardPropertyKeywords: nonStandardPropertyKeywords,
    colorKeywords: colorKeywords,
    valueKeywords: valueKeywords,
    fontProperties: fontProperties,
    allowNested: true,
    lineComment: "//",
    tokenHooks: {
      "/": function (stream, state) {
        if (stream.eat("/")) {
          stream.skipToEnd();
          return ["comment", "comment"];
        } else if (stream.eat("*")) {
          state.tokenize = tokenCComment;
          return tokenCComment(stream, state);
        } else {
          return ["operator", "operator"];
        }
      },
      ":": function (stream) {
        if (stream.match(/^\s*\{/, false)) return [null, null];
        return false;
      },
      "$": function (stream) {
        stream.match(/^[\w-]+/);
        if (stream.match(/^\s*:/, false)) return ["variable-2", "variable-definition"];
        return ["variable-2", "variable"];
      },
      "#": function (stream) {
        if (!stream.eat("{")) return false;
        return [null, "interpolation"];
      }
    },
    name: "css",
    helperType: "scss"
  });
  CodeMirror.defineMIME("text/x-less", {
    mediaTypes: mediaTypes,
    mediaFeatures: mediaFeatures,
    mediaValueKeywords: mediaValueKeywords,
    propertyKeywords: propertyKeywords,
    nonStandardPropertyKeywords: nonStandardPropertyKeywords,
    colorKeywords: colorKeywords,
    valueKeywords: valueKeywords,
    fontProperties: fontProperties,
    allowNested: true,
    lineComment: "//",
    tokenHooks: {
      "/": function (stream, state) {
        if (stream.eat("/")) {
          stream.skipToEnd();
          return ["comment", "comment"];
        } else if (stream.eat("*")) {
          state.tokenize = tokenCComment;
          return tokenCComment(stream, state);
        } else {
          return ["operator", "operator"];
        }
      },
      "@": function (stream) {
        if (stream.eat("{")) return [null, "interpolation"];
        if (stream.match(/^(charset|document|font-face|import|(-(moz|ms|o|webkit)-)?keyframes|media|namespace|page|supports)\b/i, false)) return false;
        stream.eatWhile(/[\w\\\-]/);
        if (stream.match(/^\s*:/, false)) return ["variable-2", "variable-definition"];
        return ["variable-2", "variable"];
      },
      "&": function () {
        return ["atom", "atom"];
      }
    },
    name: "css",
    helperType: "less"
  });
  CodeMirror.defineMIME("text/x-gss", {
    documentTypes: documentTypes,
    mediaTypes: mediaTypes,
    mediaFeatures: mediaFeatures,
    propertyKeywords: propertyKeywords,
    nonStandardPropertyKeywords: nonStandardPropertyKeywords,
    fontProperties: fontProperties,
    counterDescriptors: counterDescriptors,
    colorKeywords: colorKeywords,
    valueKeywords: valueKeywords,
    supportsAtComponent: true,
    tokenHooks: {
      "/": function (stream, state) {
        if (!stream.eat("*")) return false;
        state.tokenize = tokenCComment;
        return tokenCComment(stream, state);
      }
    },
    name: "css",
    helperType: "gss"
  });
});

/***/ }),

/***/ 1484:
/*!***************************************************************!*\
  !*** ./node_modules/codemirror/mode/javascript/javascript.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE
(function (mod) {
  if (true) // CommonJS
    mod(__webpack_require__(/*! ../../lib/codemirror */ 8394));else {}
})(function (CodeMirror) {
  "use strict";

  CodeMirror.defineMode("javascript", function (config, parserConfig) {
    var indentUnit = config.indentUnit;
    var statementIndent = parserConfig.statementIndent;
    var jsonldMode = parserConfig.jsonld;
    var jsonMode = parserConfig.json || jsonldMode;
    var trackScope = parserConfig.trackScope !== false;
    var isTS = parserConfig.typescript;
    var wordRE = parserConfig.wordCharacters || /[\w$\xa1-\uffff]/; // Tokenizer

    var keywords = function () {
      function kw(type) {
        return {
          type: type,
          style: "keyword"
        };
      }

      var A = kw("keyword a"),
          B = kw("keyword b"),
          C = kw("keyword c"),
          D = kw("keyword d");
      var operator = kw("operator"),
          atom = {
        type: "atom",
        style: "atom"
      };
      return {
        "if": kw("if"),
        "while": A,
        "with": A,
        "else": B,
        "do": B,
        "try": B,
        "finally": B,
        "return": D,
        "break": D,
        "continue": D,
        "new": kw("new"),
        "delete": C,
        "void": C,
        "throw": C,
        "debugger": kw("debugger"),
        "var": kw("var"),
        "const": kw("var"),
        "let": kw("var"),
        "function": kw("function"),
        "catch": kw("catch"),
        "for": kw("for"),
        "switch": kw("switch"),
        "case": kw("case"),
        "default": kw("default"),
        "in": operator,
        "typeof": operator,
        "instanceof": operator,
        "true": atom,
        "false": atom,
        "null": atom,
        "undefined": atom,
        "NaN": atom,
        "Infinity": atom,
        "this": kw("this"),
        "class": kw("class"),
        "super": kw("atom"),
        "yield": C,
        "export": kw("export"),
        "import": kw("import"),
        "extends": C,
        "await": C
      };
    }();

    var isOperatorChar = /[+\-*&%=<>!?|~^@]/;
    var isJsonldKeyword = /^@(context|id|value|language|type|container|list|set|reverse|index|base|vocab|graph)"/;

    function readRegexp(stream) {
      var escaped = false,
          next,
          inSet = false;

      while ((next = stream.next()) != null) {
        if (!escaped) {
          if (next == "/" && !inSet) return;
          if (next == "[") inSet = true;else if (inSet && next == "]") inSet = false;
        }

        escaped = !escaped && next == "\\";
      }
    } // Used as scratch variables to communicate multiple values without
    // consing up tons of objects.


    var type, content;

    function ret(tp, style, cont) {
      type = tp;
      content = cont;
      return style;
    }

    function tokenBase(stream, state) {
      var ch = stream.next();

      if (ch == '"' || ch == "'") {
        state.tokenize = tokenString(ch);
        return state.tokenize(stream, state);
      } else if (ch == "." && stream.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/)) {
        return ret("number", "number");
      } else if (ch == "." && stream.match("..")) {
        return ret("spread", "meta");
      } else if (/[\[\]{}\(\),;\:\.]/.test(ch)) {
        return ret(ch);
      } else if (ch == "=" && stream.eat(">")) {
        return ret("=>", "operator");
      } else if (ch == "0" && stream.match(/^(?:x[\dA-Fa-f_]+|o[0-7_]+|b[01_]+)n?/)) {
        return ret("number", "number");
      } else if (/\d/.test(ch)) {
        stream.match(/^[\d_]*(?:n|(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)?/);
        return ret("number", "number");
      } else if (ch == "/") {
        if (stream.eat("*")) {
          state.tokenize = tokenComment;
          return tokenComment(stream, state);
        } else if (stream.eat("/")) {
          stream.skipToEnd();
          return ret("comment", "comment");
        } else if (expressionAllowed(stream, state, 1)) {
          readRegexp(stream);
          stream.match(/^\b(([gimyus])(?![gimyus]*\2))+\b/);
          return ret("regexp", "string-2");
        } else {
          stream.eat("=");
          return ret("operator", "operator", stream.current());
        }
      } else if (ch == "`") {
        state.tokenize = tokenQuasi;
        return tokenQuasi(stream, state);
      } else if (ch == "#" && stream.peek() == "!") {
        stream.skipToEnd();
        return ret("meta", "meta");
      } else if (ch == "#" && stream.eatWhile(wordRE)) {
        return ret("variable", "property");
      } else if (ch == "<" && stream.match("!--") || ch == "-" && stream.match("->") && !/\S/.test(stream.string.slice(0, stream.start))) {
        stream.skipToEnd();
        return ret("comment", "comment");
      } else if (isOperatorChar.test(ch)) {
        if (ch != ">" || !state.lexical || state.lexical.type != ">") {
          if (stream.eat("=")) {
            if (ch == "!" || ch == "=") stream.eat("=");
          } else if (/[<>*+\-|&?]/.test(ch)) {
            stream.eat(ch);
            if (ch == ">") stream.eat(ch);
          }
        }

        if (ch == "?" && stream.eat(".")) return ret(".");
        return ret("operator", "operator", stream.current());
      } else if (wordRE.test(ch)) {
        stream.eatWhile(wordRE);
        var word = stream.current();

        if (state.lastType != ".") {
          if (keywords.propertyIsEnumerable(word)) {
            var kw = keywords[word];
            return ret(kw.type, kw.style, word);
          }

          if (word == "async" && stream.match(/^(\s|\/\*([^*]|\*(?!\/))*?\*\/)*[\[\(\w]/, false)) return ret("async", "keyword", word);
        }

        return ret("variable", "variable", word);
      }
    }

    function tokenString(quote) {
      return function (stream, state) {
        var escaped = false,
            next;

        if (jsonldMode && stream.peek() == "@" && stream.match(isJsonldKeyword)) {
          state.tokenize = tokenBase;
          return ret("jsonld-keyword", "meta");
        }

        while ((next = stream.next()) != null) {
          if (next == quote && !escaped) break;
          escaped = !escaped && next == "\\";
        }

        if (!escaped) state.tokenize = tokenBase;
        return ret("string", "string");
      };
    }

    function tokenComment(stream, state) {
      var maybeEnd = false,
          ch;

      while (ch = stream.next()) {
        if (ch == "/" && maybeEnd) {
          state.tokenize = tokenBase;
          break;
        }

        maybeEnd = ch == "*";
      }

      return ret("comment", "comment");
    }

    function tokenQuasi(stream, state) {
      var escaped = false,
          next;

      while ((next = stream.next()) != null) {
        if (!escaped && (next == "`" || next == "$" && stream.eat("{"))) {
          state.tokenize = tokenBase;
          break;
        }

        escaped = !escaped && next == "\\";
      }

      return ret("quasi", "string-2", stream.current());
    }

    var brackets = "([{}])"; // This is a crude lookahead trick to try and notice that we're
    // parsing the argument patterns for a fat-arrow function before we
    // actually hit the arrow token. It only works if the arrow is on
    // the same line as the arguments and there's no strange noise
    // (comments) in between. Fallback is to only notice when we hit the
    // arrow, and not declare the arguments as locals for the arrow
    // body.

    function findFatArrow(stream, state) {
      if (state.fatArrowAt) state.fatArrowAt = null;
      var arrow = stream.string.indexOf("=>", stream.start);
      if (arrow < 0) return;

      if (isTS) {
        // Try to skip TypeScript return type declarations after the arguments
        var m = /:\s*(?:\w+(?:<[^>]*>|\[\])?|\{[^}]*\})\s*$/.exec(stream.string.slice(stream.start, arrow));
        if (m) arrow = m.index;
      }

      var depth = 0,
          sawSomething = false;

      for (var pos = arrow - 1; pos >= 0; --pos) {
        var ch = stream.string.charAt(pos);
        var bracket = brackets.indexOf(ch);

        if (bracket >= 0 && bracket < 3) {
          if (!depth) {
            ++pos;
            break;
          }

          if (--depth == 0) {
            if (ch == "(") sawSomething = true;
            break;
          }
        } else if (bracket >= 3 && bracket < 6) {
          ++depth;
        } else if (wordRE.test(ch)) {
          sawSomething = true;
        } else if (/["'\/`]/.test(ch)) {
          for (;; --pos) {
            if (pos == 0) return;
            var next = stream.string.charAt(pos - 1);

            if (next == ch && stream.string.charAt(pos - 2) != "\\") {
              pos--;
              break;
            }
          }
        } else if (sawSomething && !depth) {
          ++pos;
          break;
        }
      }

      if (sawSomething && !depth) state.fatArrowAt = pos;
    } // Parser


    var atomicTypes = {
      "atom": true,
      "number": true,
      "variable": true,
      "string": true,
      "regexp": true,
      "this": true,
      "import": true,
      "jsonld-keyword": true
    };

    function JSLexical(indented, column, type, align, prev, info) {
      this.indented = indented;
      this.column = column;
      this.type = type;
      this.prev = prev;
      this.info = info;
      if (align != null) this.align = align;
    }

    function inScope(state, varname) {
      if (!trackScope) return false;

      for (var v = state.localVars; v; v = v.next) if (v.name == varname) return true;

      for (var cx = state.context; cx; cx = cx.prev) {
        for (var v = cx.vars; v; v = v.next) if (v.name == varname) return true;
      }
    }

    function parseJS(state, style, type, content, stream) {
      var cc = state.cc; // Communicate our context to the combinators.
      // (Less wasteful than consing up a hundred closures on every call.)

      cx.state = state;
      cx.stream = stream;
      cx.marked = null, cx.cc = cc;
      cx.style = style;
      if (!state.lexical.hasOwnProperty("align")) state.lexical.align = true;

      while (true) {
        var combinator = cc.length ? cc.pop() : jsonMode ? expression : statement;

        if (combinator(type, content)) {
          while (cc.length && cc[cc.length - 1].lex) cc.pop()();

          if (cx.marked) return cx.marked;
          if (type == "variable" && inScope(state, content)) return "variable-2";
          return style;
        }
      }
    } // Combinator utils


    var cx = {
      state: null,
      column: null,
      marked: null,
      cc: null
    };

    function pass() {
      for (var i = arguments.length - 1; i >= 0; i--) cx.cc.push(arguments[i]);
    }

    function cont() {
      pass.apply(null, arguments);
      return true;
    }

    function inList(name, list) {
      for (var v = list; v; v = v.next) if (v.name == name) return true;

      return false;
    }

    function register(varname) {
      var state = cx.state;
      cx.marked = "def";
      if (!trackScope) return;

      if (state.context) {
        if (state.lexical.info == "var" && state.context && state.context.block) {
          // FIXME function decls are also not block scoped
          var newContext = registerVarScoped(varname, state.context);

          if (newContext != null) {
            state.context = newContext;
            return;
          }
        } else if (!inList(varname, state.localVars)) {
          state.localVars = new Var(varname, state.localVars);
          return;
        }
      } // Fall through means this is global


      if (parserConfig.globalVars && !inList(varname, state.globalVars)) state.globalVars = new Var(varname, state.globalVars);
    }

    function registerVarScoped(varname, context) {
      if (!context) {
        return null;
      } else if (context.block) {
        var inner = registerVarScoped(varname, context.prev);
        if (!inner) return null;
        if (inner == context.prev) return context;
        return new Context(inner, context.vars, true);
      } else if (inList(varname, context.vars)) {
        return context;
      } else {
        return new Context(context.prev, new Var(varname, context.vars), false);
      }
    }

    function isModifier(name) {
      return name == "public" || name == "private" || name == "protected" || name == "abstract" || name == "readonly";
    } // Combinators


    function Context(prev, vars, block) {
      this.prev = prev;
      this.vars = vars;
      this.block = block;
    }

    function Var(name, next) {
      this.name = name;
      this.next = next;
    }

    var defaultVars = new Var("this", new Var("arguments", null));

    function pushcontext() {
      cx.state.context = new Context(cx.state.context, cx.state.localVars, false);
      cx.state.localVars = defaultVars;
    }

    function pushblockcontext() {
      cx.state.context = new Context(cx.state.context, cx.state.localVars, true);
      cx.state.localVars = null;
    }

    pushcontext.lex = pushblockcontext.lex = true;

    function popcontext() {
      cx.state.localVars = cx.state.context.vars;
      cx.state.context = cx.state.context.prev;
    }

    popcontext.lex = true;

    function pushlex(type, info) {
      var result = function () {
        var state = cx.state,
            indent = state.indented;
        if (state.lexical.type == "stat") indent = state.lexical.indented;else for (var outer = state.lexical; outer && outer.type == ")" && outer.align; outer = outer.prev) indent = outer.indented;
        state.lexical = new JSLexical(indent, cx.stream.column(), type, null, state.lexical, info);
      };

      result.lex = true;
      return result;
    }

    function poplex() {
      var state = cx.state;

      if (state.lexical.prev) {
        if (state.lexical.type == ")") state.indented = state.lexical.indented;
        state.lexical = state.lexical.prev;
      }
    }

    poplex.lex = true;

    function expect(wanted) {
      function exp(type) {
        if (type == wanted) return cont();else if (wanted == ";" || type == "}" || type == ")" || type == "]") return pass();else return cont(exp);
      }

      ;
      return exp;
    }

    function statement(type, value) {
      if (type == "var") return cont(pushlex("vardef", value), vardef, expect(";"), poplex);
      if (type == "keyword a") return cont(pushlex("form"), parenExpr, statement, poplex);
      if (type == "keyword b") return cont(pushlex("form"), statement, poplex);
      if (type == "keyword d") return cx.stream.match(/^\s*$/, false) ? cont() : cont(pushlex("stat"), maybeexpression, expect(";"), poplex);
      if (type == "debugger") return cont(expect(";"));
      if (type == "{") return cont(pushlex("}"), pushblockcontext, block, poplex, popcontext);
      if (type == ";") return cont();

      if (type == "if") {
        if (cx.state.lexical.info == "else" && cx.state.cc[cx.state.cc.length - 1] == poplex) cx.state.cc.pop()();
        return cont(pushlex("form"), parenExpr, statement, poplex, maybeelse);
      }

      if (type == "function") return cont(functiondef);
      if (type == "for") return cont(pushlex("form"), pushblockcontext, forspec, statement, popcontext, poplex);

      if (type == "class" || isTS && value == "interface") {
        cx.marked = "keyword";
        return cont(pushlex("form", type == "class" ? type : value), className, poplex);
      }

      if (type == "variable") {
        if (isTS && value == "declare") {
          cx.marked = "keyword";
          return cont(statement);
        } else if (isTS && (value == "module" || value == "enum" || value == "type") && cx.stream.match(/^\s*\w/, false)) {
          cx.marked = "keyword";
          if (value == "enum") return cont(enumdef);else if (value == "type") return cont(typename, expect("operator"), typeexpr, expect(";"));else return cont(pushlex("form"), pattern, expect("{"), pushlex("}"), block, poplex, poplex);
        } else if (isTS && value == "namespace") {
          cx.marked = "keyword";
          return cont(pushlex("form"), expression, statement, poplex);
        } else if (isTS && value == "abstract") {
          cx.marked = "keyword";
          return cont(statement);
        } else {
          return cont(pushlex("stat"), maybelabel);
        }
      }

      if (type == "switch") return cont(pushlex("form"), parenExpr, expect("{"), pushlex("}", "switch"), pushblockcontext, block, poplex, poplex, popcontext);
      if (type == "case") return cont(expression, expect(":"));
      if (type == "default") return cont(expect(":"));
      if (type == "catch") return cont(pushlex("form"), pushcontext, maybeCatchBinding, statement, poplex, popcontext);
      if (type == "export") return cont(pushlex("stat"), afterExport, poplex);
      if (type == "import") return cont(pushlex("stat"), afterImport, poplex);
      if (type == "async") return cont(statement);
      if (value == "@") return cont(expression, statement);
      return pass(pushlex("stat"), expression, expect(";"), poplex);
    }

    function maybeCatchBinding(type) {
      if (type == "(") return cont(funarg, expect(")"));
    }

    function expression(type, value) {
      return expressionInner(type, value, false);
    }

    function expressionNoComma(type, value) {
      return expressionInner(type, value, true);
    }

    function parenExpr(type) {
      if (type != "(") return pass();
      return cont(pushlex(")"), maybeexpression, expect(")"), poplex);
    }

    function expressionInner(type, value, noComma) {
      if (cx.state.fatArrowAt == cx.stream.start) {
        var body = noComma ? arrowBodyNoComma : arrowBody;
        if (type == "(") return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, expect("=>"), body, popcontext);else if (type == "variable") return pass(pushcontext, pattern, expect("=>"), body, popcontext);
      }

      var maybeop = noComma ? maybeoperatorNoComma : maybeoperatorComma;
      if (atomicTypes.hasOwnProperty(type)) return cont(maybeop);
      if (type == "function") return cont(functiondef, maybeop);

      if (type == "class" || isTS && value == "interface") {
        cx.marked = "keyword";
        return cont(pushlex("form"), classExpression, poplex);
      }

      if (type == "keyword c" || type == "async") return cont(noComma ? expressionNoComma : expression);
      if (type == "(") return cont(pushlex(")"), maybeexpression, expect(")"), poplex, maybeop);
      if (type == "operator" || type == "spread") return cont(noComma ? expressionNoComma : expression);
      if (type == "[") return cont(pushlex("]"), arrayLiteral, poplex, maybeop);
      if (type == "{") return contCommasep(objprop, "}", null, maybeop);
      if (type == "quasi") return pass(quasi, maybeop);
      if (type == "new") return cont(maybeTarget(noComma));
      return cont();
    }

    function maybeexpression(type) {
      if (type.match(/[;\}\)\],]/)) return pass();
      return pass(expression);
    }

    function maybeoperatorComma(type, value) {
      if (type == ",") return cont(maybeexpression);
      return maybeoperatorNoComma(type, value, false);
    }

    function maybeoperatorNoComma(type, value, noComma) {
      var me = noComma == false ? maybeoperatorComma : maybeoperatorNoComma;
      var expr = noComma == false ? expression : expressionNoComma;
      if (type == "=>") return cont(pushcontext, noComma ? arrowBodyNoComma : arrowBody, popcontext);

      if (type == "operator") {
        if (/\+\+|--/.test(value) || isTS && value == "!") return cont(me);
        if (isTS && value == "<" && cx.stream.match(/^([^<>]|<[^<>]*>)*>\s*\(/, false)) return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, me);
        if (value == "?") return cont(expression, expect(":"), expr);
        return cont(expr);
      }

      if (type == "quasi") {
        return pass(quasi, me);
      }

      if (type == ";") return;
      if (type == "(") return contCommasep(expressionNoComma, ")", "call", me);
      if (type == ".") return cont(property, me);
      if (type == "[") return cont(pushlex("]"), maybeexpression, expect("]"), poplex, me);

      if (isTS && value == "as") {
        cx.marked = "keyword";
        return cont(typeexpr, me);
      }

      if (type == "regexp") {
        cx.state.lastType = cx.marked = "operator";
        cx.stream.backUp(cx.stream.pos - cx.stream.start - 1);
        return cont(expr);
      }
    }

    function quasi(type, value) {
      if (type != "quasi") return pass();
      if (value.slice(value.length - 2) != "${") return cont(quasi);
      return cont(maybeexpression, continueQuasi);
    }

    function continueQuasi(type) {
      if (type == "}") {
        cx.marked = "string-2";
        cx.state.tokenize = tokenQuasi;
        return cont(quasi);
      }
    }

    function arrowBody(type) {
      findFatArrow(cx.stream, cx.state);
      return pass(type == "{" ? statement : expression);
    }

    function arrowBodyNoComma(type) {
      findFatArrow(cx.stream, cx.state);
      return pass(type == "{" ? statement : expressionNoComma);
    }

    function maybeTarget(noComma) {
      return function (type) {
        if (type == ".") return cont(noComma ? targetNoComma : target);else if (type == "variable" && isTS) return cont(maybeTypeArgs, noComma ? maybeoperatorNoComma : maybeoperatorComma);else return pass(noComma ? expressionNoComma : expression);
      };
    }

    function target(_, value) {
      if (value == "target") {
        cx.marked = "keyword";
        return cont(maybeoperatorComma);
      }
    }

    function targetNoComma(_, value) {
      if (value == "target") {
        cx.marked = "keyword";
        return cont(maybeoperatorNoComma);
      }
    }

    function maybelabel(type) {
      if (type == ":") return cont(poplex, statement);
      return pass(maybeoperatorComma, expect(";"), poplex);
    }

    function property(type) {
      if (type == "variable") {
        cx.marked = "property";
        return cont();
      }
    }

    function objprop(type, value) {
      if (type == "async") {
        cx.marked = "property";
        return cont(objprop);
      } else if (type == "variable" || cx.style == "keyword") {
        cx.marked = "property";
        if (value == "get" || value == "set") return cont(getterSetter);
        var m; // Work around fat-arrow-detection complication for detecting typescript typed arrow params

        if (isTS && cx.state.fatArrowAt == cx.stream.start && (m = cx.stream.match(/^\s*:\s*/, false))) cx.state.fatArrowAt = cx.stream.pos + m[0].length;
        return cont(afterprop);
      } else if (type == "number" || type == "string") {
        cx.marked = jsonldMode ? "property" : cx.style + " property";
        return cont(afterprop);
      } else if (type == "jsonld-keyword") {
        return cont(afterprop);
      } else if (isTS && isModifier(value)) {
        cx.marked = "keyword";
        return cont(objprop);
      } else if (type == "[") {
        return cont(expression, maybetype, expect("]"), afterprop);
      } else if (type == "spread") {
        return cont(expressionNoComma, afterprop);
      } else if (value == "*") {
        cx.marked = "keyword";
        return cont(objprop);
      } else if (type == ":") {
        return pass(afterprop);
      }
    }

    function getterSetter(type) {
      if (type != "variable") return pass(afterprop);
      cx.marked = "property";
      return cont(functiondef);
    }

    function afterprop(type) {
      if (type == ":") return cont(expressionNoComma);
      if (type == "(") return pass(functiondef);
    }

    function commasep(what, end, sep) {
      function proceed(type, value) {
        if (sep ? sep.indexOf(type) > -1 : type == ",") {
          var lex = cx.state.lexical;
          if (lex.info == "call") lex.pos = (lex.pos || 0) + 1;
          return cont(function (type, value) {
            if (type == end || value == end) return pass();
            return pass(what);
          }, proceed);
        }

        if (type == end || value == end) return cont();
        if (sep && sep.indexOf(";") > -1) return pass(what);
        return cont(expect(end));
      }

      return function (type, value) {
        if (type == end || value == end) return cont();
        return pass(what, proceed);
      };
    }

    function contCommasep(what, end, info) {
      for (var i = 3; i < arguments.length; i++) cx.cc.push(arguments[i]);

      return cont(pushlex(end, info), commasep(what, end), poplex);
    }

    function block(type) {
      if (type == "}") return cont();
      return pass(statement, block);
    }

    function maybetype(type, value) {
      if (isTS) {
        if (type == ":") return cont(typeexpr);
        if (value == "?") return cont(maybetype);
      }
    }

    function maybetypeOrIn(type, value) {
      if (isTS && (type == ":" || value == "in")) return cont(typeexpr);
    }

    function mayberettype(type) {
      if (isTS && type == ":") {
        if (cx.stream.match(/^\s*\w+\s+is\b/, false)) return cont(expression, isKW, typeexpr);else return cont(typeexpr);
      }
    }

    function isKW(_, value) {
      if (value == "is") {
        cx.marked = "keyword";
        return cont();
      }
    }

    function typeexpr(type, value) {
      if (value == "keyof" || value == "typeof" || value == "infer" || value == "readonly") {
        cx.marked = "keyword";
        return cont(value == "typeof" ? expressionNoComma : typeexpr);
      }

      if (type == "variable" || value == "void") {
        cx.marked = "type";
        return cont(afterType);
      }

      if (value == "|" || value == "&") return cont(typeexpr);
      if (type == "string" || type == "number" || type == "atom") return cont(afterType);
      if (type == "[") return cont(pushlex("]"), commasep(typeexpr, "]", ","), poplex, afterType);
      if (type == "{") return cont(pushlex("}"), typeprops, poplex, afterType);
      if (type == "(") return cont(commasep(typearg, ")"), maybeReturnType, afterType);
      if (type == "<") return cont(commasep(typeexpr, ">"), typeexpr);

      if (type == "quasi") {
        return pass(quasiType, afterType);
      }
    }

    function maybeReturnType(type) {
      if (type == "=>") return cont(typeexpr);
    }

    function typeprops(type) {
      if (type.match(/[\}\)\]]/)) return cont();
      if (type == "," || type == ";") return cont(typeprops);
      return pass(typeprop, typeprops);
    }

    function typeprop(type, value) {
      if (type == "variable" || cx.style == "keyword") {
        cx.marked = "property";
        return cont(typeprop);
      } else if (value == "?" || type == "number" || type == "string") {
        return cont(typeprop);
      } else if (type == ":") {
        return cont(typeexpr);
      } else if (type == "[") {
        return cont(expect("variable"), maybetypeOrIn, expect("]"), typeprop);
      } else if (type == "(") {
        return pass(functiondecl, typeprop);
      } else if (!type.match(/[;\}\)\],]/)) {
        return cont();
      }
    }

    function quasiType(type, value) {
      if (type != "quasi") return pass();
      if (value.slice(value.length - 2) != "${") return cont(quasiType);
      return cont(typeexpr, continueQuasiType);
    }

    function continueQuasiType(type) {
      if (type == "}") {
        cx.marked = "string-2";
        cx.state.tokenize = tokenQuasi;
        return cont(quasiType);
      }
    }

    function typearg(type, value) {
      if (type == "variable" && cx.stream.match(/^\s*[?:]/, false) || value == "?") return cont(typearg);
      if (type == ":") return cont(typeexpr);
      if (type == "spread") return cont(typearg);
      return pass(typeexpr);
    }

    function afterType(type, value) {
      if (value == "<") return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, afterType);
      if (value == "|" || type == "." || value == "&") return cont(typeexpr);
      if (type == "[") return cont(typeexpr, expect("]"), afterType);

      if (value == "extends" || value == "implements") {
        cx.marked = "keyword";
        return cont(typeexpr);
      }

      if (value == "?") return cont(typeexpr, expect(":"), typeexpr);
    }

    function maybeTypeArgs(_, value) {
      if (value == "<") return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, afterType);
    }

    function typeparam() {
      return pass(typeexpr, maybeTypeDefault);
    }

    function maybeTypeDefault(_, value) {
      if (value == "=") return cont(typeexpr);
    }

    function vardef(_, value) {
      if (value == "enum") {
        cx.marked = "keyword";
        return cont(enumdef);
      }

      return pass(pattern, maybetype, maybeAssign, vardefCont);
    }

    function pattern(type, value) {
      if (isTS && isModifier(value)) {
        cx.marked = "keyword";
        return cont(pattern);
      }

      if (type == "variable") {
        register(value);
        return cont();
      }

      if (type == "spread") return cont(pattern);
      if (type == "[") return contCommasep(eltpattern, "]");
      if (type == "{") return contCommasep(proppattern, "}");
    }

    function proppattern(type, value) {
      if (type == "variable" && !cx.stream.match(/^\s*:/, false)) {
        register(value);
        return cont(maybeAssign);
      }

      if (type == "variable") cx.marked = "property";
      if (type == "spread") return cont(pattern);
      if (type == "}") return pass();
      if (type == "[") return cont(expression, expect(']'), expect(':'), proppattern);
      return cont(expect(":"), pattern, maybeAssign);
    }

    function eltpattern() {
      return pass(pattern, maybeAssign);
    }

    function maybeAssign(_type, value) {
      if (value == "=") return cont(expressionNoComma);
    }

    function vardefCont(type) {
      if (type == ",") return cont(vardef);
    }

    function maybeelse(type, value) {
      if (type == "keyword b" && value == "else") return cont(pushlex("form", "else"), statement, poplex);
    }

    function forspec(type, value) {
      if (value == "await") return cont(forspec);
      if (type == "(") return cont(pushlex(")"), forspec1, poplex);
    }

    function forspec1(type) {
      if (type == "var") return cont(vardef, forspec2);
      if (type == "variable") return cont(forspec2);
      return pass(forspec2);
    }

    function forspec2(type, value) {
      if (type == ")") return cont();
      if (type == ";") return cont(forspec2);

      if (value == "in" || value == "of") {
        cx.marked = "keyword";
        return cont(expression, forspec2);
      }

      return pass(expression, forspec2);
    }

    function functiondef(type, value) {
      if (value == "*") {
        cx.marked = "keyword";
        return cont(functiondef);
      }

      if (type == "variable") {
        register(value);
        return cont(functiondef);
      }

      if (type == "(") return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, mayberettype, statement, popcontext);
      if (isTS && value == "<") return cont(pushlex(">"), commasep(typeparam, ">"), poplex, functiondef);
    }

    function functiondecl(type, value) {
      if (value == "*") {
        cx.marked = "keyword";
        return cont(functiondecl);
      }

      if (type == "variable") {
        register(value);
        return cont(functiondecl);
      }

      if (type == "(") return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, mayberettype, popcontext);
      if (isTS && value == "<") return cont(pushlex(">"), commasep(typeparam, ">"), poplex, functiondecl);
    }

    function typename(type, value) {
      if (type == "keyword" || type == "variable") {
        cx.marked = "type";
        return cont(typename);
      } else if (value == "<") {
        return cont(pushlex(">"), commasep(typeparam, ">"), poplex);
      }
    }

    function funarg(type, value) {
      if (value == "@") cont(expression, funarg);
      if (type == "spread") return cont(funarg);

      if (isTS && isModifier(value)) {
        cx.marked = "keyword";
        return cont(funarg);
      }

      if (isTS && type == "this") return cont(maybetype, maybeAssign);
      return pass(pattern, maybetype, maybeAssign);
    }

    function classExpression(type, value) {
      // Class expressions may have an optional name.
      if (type == "variable") return className(type, value);
      return classNameAfter(type, value);
    }

    function className(type, value) {
      if (type == "variable") {
        register(value);
        return cont(classNameAfter);
      }
    }

    function classNameAfter(type, value) {
      if (value == "<") return cont(pushlex(">"), commasep(typeparam, ">"), poplex, classNameAfter);

      if (value == "extends" || value == "implements" || isTS && type == ",") {
        if (value == "implements") cx.marked = "keyword";
        return cont(isTS ? typeexpr : expression, classNameAfter);
      }

      if (type == "{") return cont(pushlex("}"), classBody, poplex);
    }

    function classBody(type, value) {
      if (type == "async" || type == "variable" && (value == "static" || value == "get" || value == "set" || isTS && isModifier(value)) && cx.stream.match(/^\s+#?[\w$\xa1-\uffff]/, false)) {
        cx.marked = "keyword";
        return cont(classBody);
      }

      if (type == "variable" || cx.style == "keyword") {
        cx.marked = "property";
        return cont(classfield, classBody);
      }

      if (type == "number" || type == "string") return cont(classfield, classBody);
      if (type == "[") return cont(expression, maybetype, expect("]"), classfield, classBody);

      if (value == "*") {
        cx.marked = "keyword";
        return cont(classBody);
      }

      if (isTS && type == "(") return pass(functiondecl, classBody);
      if (type == ";" || type == ",") return cont(classBody);
      if (type == "}") return cont();
      if (value == "@") return cont(expression, classBody);
    }

    function classfield(type, value) {
      if (value == "!") return cont(classfield);
      if (value == "?") return cont(classfield);
      if (type == ":") return cont(typeexpr, maybeAssign);
      if (value == "=") return cont(expressionNoComma);
      var context = cx.state.lexical.prev,
          isInterface = context && context.info == "interface";
      return pass(isInterface ? functiondecl : functiondef);
    }

    function afterExport(type, value) {
      if (value == "*") {
        cx.marked = "keyword";
        return cont(maybeFrom, expect(";"));
      }

      if (value == "default") {
        cx.marked = "keyword";
        return cont(expression, expect(";"));
      }

      if (type == "{") return cont(commasep(exportField, "}"), maybeFrom, expect(";"));
      return pass(statement);
    }

    function exportField(type, value) {
      if (value == "as") {
        cx.marked = "keyword";
        return cont(expect("variable"));
      }

      if (type == "variable") return pass(expressionNoComma, exportField);
    }

    function afterImport(type) {
      if (type == "string") return cont();
      if (type == "(") return pass(expression);
      if (type == ".") return pass(maybeoperatorComma);
      return pass(importSpec, maybeMoreImports, maybeFrom);
    }

    function importSpec(type, value) {
      if (type == "{") return contCommasep(importSpec, "}");
      if (type == "variable") register(value);
      if (value == "*") cx.marked = "keyword";
      return cont(maybeAs);
    }

    function maybeMoreImports(type) {
      if (type == ",") return cont(importSpec, maybeMoreImports);
    }

    function maybeAs(_type, value) {
      if (value == "as") {
        cx.marked = "keyword";
        return cont(importSpec);
      }
    }

    function maybeFrom(_type, value) {
      if (value == "from") {
        cx.marked = "keyword";
        return cont(expression);
      }
    }

    function arrayLiteral(type) {
      if (type == "]") return cont();
      return pass(commasep(expressionNoComma, "]"));
    }

    function enumdef() {
      return pass(pushlex("form"), pattern, expect("{"), pushlex("}"), commasep(enummember, "}"), poplex, poplex);
    }

    function enummember() {
      return pass(pattern, maybeAssign);
    }

    function isContinuedStatement(state, textAfter) {
      return state.lastType == "operator" || state.lastType == "," || isOperatorChar.test(textAfter.charAt(0)) || /[,.]/.test(textAfter.charAt(0));
    }

    function expressionAllowed(stream, state, backUp) {
      return state.tokenize == tokenBase && /^(?:operator|sof|keyword [bcd]|case|new|export|default|spread|[\[{}\(,;:]|=>)$/.test(state.lastType) || state.lastType == "quasi" && /\{\s*$/.test(stream.string.slice(0, stream.pos - (backUp || 0)));
    } // Interface


    return {
      startState: function (basecolumn) {
        var state = {
          tokenize: tokenBase,
          lastType: "sof",
          cc: [],
          lexical: new JSLexical((basecolumn || 0) - indentUnit, 0, "block", false),
          localVars: parserConfig.localVars,
          context: parserConfig.localVars && new Context(null, null, false),
          indented: basecolumn || 0
        };
        if (parserConfig.globalVars && typeof parserConfig.globalVars == "object") state.globalVars = parserConfig.globalVars;
        return state;
      },
      token: function (stream, state) {
        if (stream.sol()) {
          if (!state.lexical.hasOwnProperty("align")) state.lexical.align = false;
          state.indented = stream.indentation();
          findFatArrow(stream, state);
        }

        if (state.tokenize != tokenComment && stream.eatSpace()) return null;
        var style = state.tokenize(stream, state);
        if (type == "comment") return style;
        state.lastType = type == "operator" && (content == "++" || content == "--") ? "incdec" : type;
        return parseJS(state, style, type, content, stream);
      },
      indent: function (state, textAfter) {
        if (state.tokenize == tokenComment || state.tokenize == tokenQuasi) return CodeMirror.Pass;
        if (state.tokenize != tokenBase) return 0;
        var firstChar = textAfter && textAfter.charAt(0),
            lexical = state.lexical,
            top; // Kludge to prevent 'maybelse' from blocking lexical scope pops

        if (!/^\s*else\b/.test(textAfter)) for (var i = state.cc.length - 1; i >= 0; --i) {
          var c = state.cc[i];
          if (c == poplex) lexical = lexical.prev;else if (c != maybeelse && c != popcontext) break;
        }

        while ((lexical.type == "stat" || lexical.type == "form") && (firstChar == "}" || (top = state.cc[state.cc.length - 1]) && (top == maybeoperatorComma || top == maybeoperatorNoComma) && !/^[,\.=+\-*:?[\(]/.test(textAfter))) lexical = lexical.prev;

        if (statementIndent && lexical.type == ")" && lexical.prev.type == "stat") lexical = lexical.prev;
        var type = lexical.type,
            closing = firstChar == type;
        if (type == "vardef") return lexical.indented + (state.lastType == "operator" || state.lastType == "," ? lexical.info.length + 1 : 0);else if (type == "form" && firstChar == "{") return lexical.indented;else if (type == "form") return lexical.indented + indentUnit;else if (type == "stat") return lexical.indented + (isContinuedStatement(state, textAfter) ? statementIndent || indentUnit : 0);else if (lexical.info == "switch" && !closing && parserConfig.doubleIndentSwitch != false) return lexical.indented + (/^(?:case|default)\b/.test(textAfter) ? indentUnit : 2 * indentUnit);else if (lexical.align) return lexical.column + (closing ? 0 : 1);else return lexical.indented + (closing ? 0 : indentUnit);
      },
      electricInput: /^\s*(?:case .*?:|default:|\{|\})$/,
      blockCommentStart: jsonMode ? null : "/*",
      blockCommentEnd: jsonMode ? null : "*/",
      blockCommentContinue: jsonMode ? null : " * ",
      lineComment: jsonMode ? null : "//",
      fold: "brace",
      closeBrackets: "()[]{}''\"\"``",
      helperType: jsonMode ? "json" : "javascript",
      jsonldMode: jsonldMode,
      jsonMode: jsonMode,
      expressionAllowed: expressionAllowed,
      skipExpression: function (state) {
        parseJS(state, "atom", "atom", "true", new CodeMirror.StringStream("", 2, null));
      }
    };
  });
  CodeMirror.registerHelper("wordChars", "javascript", /[\w$]/);
  CodeMirror.defineMIME("text/javascript", "javascript");
  CodeMirror.defineMIME("text/ecmascript", "javascript");
  CodeMirror.defineMIME("application/javascript", "javascript");
  CodeMirror.defineMIME("application/x-javascript", "javascript");
  CodeMirror.defineMIME("application/ecmascript", "javascript");
  CodeMirror.defineMIME("application/json", {
    name: "javascript",
    json: true
  });
  CodeMirror.defineMIME("application/x-json", {
    name: "javascript",
    json: true
  });
  CodeMirror.defineMIME("application/manifest+json", {
    name: "javascript",
    json: true
  });
  CodeMirror.defineMIME("application/ld+json", {
    name: "javascript",
    jsonld: true
  });
  CodeMirror.defineMIME("text/typescript", {
    name: "javascript",
    typescript: true
  });
  CodeMirror.defineMIME("application/typescript", {
    name: "javascript",
    typescript: true
  });
});

/***/ })

}]);
//# sourceMappingURL=src_app_pages_settings_settings-themes_settings-themes_module_ts.js.map