"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["default-src_app_components_access_entities_entities_component_ts-src_app_components_modal-act-3e87f4"],{

/***/ 8024:
/*!******************************************!*\
  !*** ./src/app/api/group-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GroupApiService": () => (/* binding */ GroupApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);


class GroupApiService {
    constructor(rest) {
        this.rest = rest;
    }
    get(id) {
        return this.rest.get(`/group/${id}`);
    }
    list(params) {
        return this.rest.get('/group', params);
    }
    save(data) {
        if (data.id) {
            return this.rest.put(`/group/${data.id}`, data);
        }
        else {
            return this.rest.post('/group', data);
        }
    }
    delete(id) {
        return this.rest.delete(`/group/${id}`);
    }
    deleteList(ids) {
        return this.rest.delete(`/group`, {
            ids,
        });
    }
}
GroupApiService.ɵfac = function GroupApiService_Factory(t) { return new (t || GroupApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
GroupApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: GroupApiService, factory: GroupApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 1908:
/*!*******************************************************!*\
  !*** ./src/app/components/access/access.component.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccessComponent": () => (/* binding */ AccessComponent),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ 9295);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access.service */ 652);
/* harmony import */ var _api_group_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../api/group-api.service */ 8024);
/* harmony import */ var _services_server_response_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/server-response.service */ 2429);











function AccessComponent_div_0_app_entities_13_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](0);
} if (rf & 2) {
    const group_r8 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", group_r8.name, " ");
} }
function AccessComponent_div_0_app_entities_13_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "app-entities", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onSelect", function AccessComponent_div_0_app_entities_13_Template_app_entities_onSelect_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r10); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r9.select($event)); })("errorResponse", function AccessComponent_div_0_app_entities_13_Template_app_entities_errorResponse_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r10); const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r11.errorShow($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, AccessComponent_div_0_app_entities_13_ng_template_1_Template, 1, 1, "ng-template", null, 14, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](8);
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("entitiesProvider", ctx_r4.groupsProvider)("entityTemplate", _r6)("searchInput", _r3)("selected", ctx_r4.groups);
} }
function AccessComponent_div_0_app_entities_14_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-avatar", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const user_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("user", user_r14)("size", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 3, user_r14), " ");
} }
function AccessComponent_div_0_app_entities_14_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "app-entities", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onSelect", function AccessComponent_div_0_app_entities_14_Template_app_entities_onSelect_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r16); const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r15.select($event)); })("errorResponse", function AccessComponent_div_0_app_entities_14_Template_app_entities_errorResponse_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r16); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r17.errorShow($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, AccessComponent_div_0_app_entities_14_ng_template_1_Template, 4, 5, "ng-template", null, 16, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](8);
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("isUser", true)("entitiesProvider", ctx_r5.usersProvider)("entityTemplate", _r12)("searchInput", _r3)("selected", ctx_r5.users);
} }
const _c0 = function (a0, a1) { return { count: a0, total: a1 }; };
function AccessComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 3)(1, "div", 4)(2, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](3, "sl-icon", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "sl-input", 7, 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](10, "sl-icon", 9)(11, "sl-icon-button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerStart"](12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](13, AccessComponent_div_0_app_entities_13_Template, 3, 4, "app-entities", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](14, AccessComponent_div_0_app_entities_14_Template, 3, 5, "app-entities", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("name", ctx_r0.iconName);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind2"](6, 5, ctx_r0.title, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction2"](10, _c0, ctx_r0.selected.length || "0", ctx_r0.total)), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](9, 8, "access#search"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.state === ctx_r0.State.Groups);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r0.state === ctx_r0.State.Users);
} }
function AccessComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-error-state", 18);
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("code", ctx_r2.responseServerError);
} }
var State;
(function (State) {
    State[State["Users"] = 0] = "Users";
    State[State["Groups"] = 1] = "Groups";
})(State || (State = {}));
class AccessComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_4__.SubscribableComponent {
    constructor(accessService, groupApiService, userApiService, serverResponseService) {
        super();
        this.accessService = accessService;
        this.groupApiService = groupApiService;
        this.userApiService = userApiService;
        this.serverResponseService = serverResponseService;
        this.groups = [];
        this.users = [];
        this.onApply = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.onError = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.State = State;
        this.groupsProvider = (params) => this.groupApiService.list(Object.assign({ order_by: 'name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SortDirection.Asc }, params));
        this.usersProvider = (params) => this.userApiService.list(Object.assign({ order_by: 'last_name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SortDirection.Asc }, params));
        this.selected = [];
        this.total = 0;
        this.responseServerError = null;
    }
    get title() {
        const title = this.state === State.Groups ? 'groups' : 'users';
        return `access#${title}`;
    }
    get state() {
        return this.accessService.state.value;
    }
    get iconName() {
        return this.state === State.Groups ? 'people' : 'person';
    }
    ngOnChanges() {
        this.selected =
            this.state === State.Groups ? [...this.groups] : [...this.users];
    }
    ngOnInit() {
        this.subscriptions = [
            this.accessService.total.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.take)(1)).subscribe((total) => {
                this.total = total;
            }),
        ];
    }
    apply() {
        this.onApply.emit(this.selected);
    }
    select(entities) {
        this.selected = entities;
    }
    errorShow(response) {
        const key = this.state === State.Groups
            ? 'access#faildGetListGroup'
            : 'access#faildGetListUsers';
        this.responseServerError = response
            ? this.serverResponseService.getStatusOrNotify(response, key)
            : null;
    }
}
AccessComponent.ɵfac = function AccessComponent_Factory(t) { return new (t || AccessComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_access_service__WEBPACK_IMPORTED_MODULE_0__.AccessService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_api_group_api_service__WEBPACK_IMPORTED_MODULE_1__.GroupApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UserApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_services_server_response_service__WEBPACK_IMPORTED_MODULE_2__.ServerResponseService)); };
AccessComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: AccessComponent, selectors: [["app-access"]], inputs: { groups: "groups", users: "users", form: "form" }, outputs: { onApply: "onApply", onError: "onError" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵInheritDefinitionFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵNgOnChangesFeature"]], decls: 6, vars: 5, consts: [["class", "access", 4, "ngIf", "ngIfElse"], ["responseError", ""], ["variant", "text", 1, "access-btn", 3, "click"], [1, "access"], [1, "header"], [1, "title"], [3, "name"], ["size", "medium", "clearable", "", 1, "search-input", 3, "placeholder"], ["searchInput", ""], ["name", "search-bold", "library", "core", "slot", "suffix"], ["name", "x", "slot", "clear-icon"], [3, "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse", 4, "ngIf"], [3, "isUser", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse", 4, "ngIf"], [3, "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse"], ["groupEntityTemplate", ""], [3, "isUser", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse"], ["userEntityTemplate", ""], [3, "user", "size"], [3, "code"]], template: function AccessComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](0, AccessComponent_div_0_Template, 15, 13, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, AccessComponent_ng_template_1_Template, 1, 1, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "sl-button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function AccessComponent_Template_sl_button_click_3_listener() { return ctx.apply(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", !ctx.responseServerError)("ngIfElse", _r1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 3, "$.back"), "\n");
    } }, styles: ["[_nghost-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  flex: 1;\n}\n.access[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  flex: 1;\n}\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-large);\n}\n.title[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  font-weight: var(--sl-font-weight-semibold);\n  font-size: var(--sl-font-size-small);\n  line-height: 29px;\n  color: var(--sl-color-secondary-900);\n}\n.title[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-small);\n  font-size: var(--sl-font-size-x-large);\n}\n.title[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin: 0;\n}\n.search-input[_ngcontent-%COMP%] {\n  width: 266px;\n}\n.search-input[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%]::part(base) {\n  padding: 0;\n}\n.access-btn[_ngcontent-%COMP%] {\n  position: absolute;\n  left: var(--sl-spacing-x-large);\n  bottom: calc(var(--sl-spacing-x-large) + var(--sl-spacing-2x-small));\n}\n.access-btn[_ngcontent-%COMP%]::part(base) {\n  padding: var(--sl-spacing-2x-small) var(--sl-spacing-x-small);\n  height: auto;\n  background: transparent;\n  border: none;\n}\n.access-btn[_ngcontent-%COMP%]::part(label) {\n  padding: 0;\n  font-weight: var(--sl-font-weight-normal);\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n}\ncore-error-state[_ngcontent-%COMP%] {\n  margin-top: 0;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], AccessComponent.prototype, "selected", void 0);


/***/ }),

/***/ 652:
/*!*****************************************************!*\
  !*** ./src/app/components/access/access.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccessService": () => (/* binding */ AccessService)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 228);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 6317);
/* harmony import */ var _access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access.component */ 1908);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);



class AccessService {
    constructor() {
        this.total = new rxjs__WEBPACK_IMPORTED_MODULE_1__.Subject();
        this.state = new rxjs__WEBPACK_IMPORTED_MODULE_2__.BehaviorSubject(_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups);
    }
}
AccessService.ɵfac = function AccessService_Factory(t) { return new (t || AccessService)(); };
AccessService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjectable"]({ token: AccessService, factory: AccessService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 1405:
/*!******************************************************************!*\
  !*** ./src/app/components/access/entities/entities.component.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EntitiesComponent": () => (/* binding */ EntitiesComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! logical-not */ 2905);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../access.service */ 652);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-track-by */ 1050);












function EntitiesComponent_ng_container_0_p_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "access#noSearchResults"));
} }
function EntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
const _c0 = function (a0) { return { $implicit: a0 }; };
function EntitiesComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0, 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, EntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template, 1, 0, "ng-container", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const entity_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](2, _c0, entity_r7));
} }
function EntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function EntitiesComponent_ng_container_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-checkbox", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-change", function EntitiesComponent_ng_container_0_ng_template_4_Template_sl_checkbox_sl_change_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r12); const entity_r9 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r11.onToggle(entity_r9)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, EntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template, 1, 0, "ng-container", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const entity_r9 = ctx.$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("checked", ctx_r6.isSelected(entity_r9.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", ctx_r6.entityTemplate)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](3, _c0, entity_r9));
} }
function EntitiesComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, EntitiesComponent_ng_container_0_p_2_Template, 3, 3, "p", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, EntitiesComponent_ng_container_0_ng_container_3_Template, 2, 4, "ng-container", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, EntitiesComponent_ng_container_0_ng_template_4_Template, 2, 5, "ng-template", null, 4, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "core-pagination", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onPageChange", function EntitiesComponent_ng_container_0_Template_core_pagination_onPageChange_6_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r13.onPageChange($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassMapInterpolate1"]("content content-", ctx_r0.gridSize, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r0.isEmpty);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r0.entities);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("total", ctx_r0.total)("limit", ctx_r0.params.limit)("page", ctx_r0.page);
} }
function EntitiesComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "sl-spinner", 9);
} }
class EntitiesComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__.SubscribableComponent {
    constructor(accessService, hostRef) {
        super();
        this.accessService = accessService;
        this.hostRef = hostRef;
        this.isUser = false;
        this.gridSize = 10;
        this.onSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.errorResponse = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.entities = [];
        this.params = {};
        this.total = 0;
        this.page = 1;
        this.isEmpty = false;
        this.loading = false;
        this.inited = false;
    }
    ngOnInit() {
        this.dialog = this.hostRef.nativeElement.closest('sl-dialog');
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_4__.fromEvent)(this.dialog, 'sl-show').subscribe((event) => {
                if (event.target === this.dialog) {
                    this.inited = false;
                    this.init();
                }
            }),
            (0,rxjs__WEBPACK_IMPORTED_MODULE_4__.fromEvent)(this.searchInput, 'sl-input').subscribe(() => {
                this.onSearch(this.searchInput.value);
            }),
        ];
    }
    onSearch(search) {
        this.params.search = search;
        this.params.offset = 0;
        this.page = 1;
        this.load();
    }
    isSelected(id) {
        var _a;
        return (_a = this.selected) === null || _a === void 0 ? void 0 : _a.find((item) => item.id === id);
    }
    onToggle(entity) {
        const idx = this.selected.findIndex((item) => item.id === entity.id);
        if (idx >= 0) {
            this.selected.splice(idx, 1);
        }
        else {
            this.selected.push(entity);
        }
        this.onSelect.emit(this.selected);
    }
    onPageChange(page) {
        this.page = page;
        this.params.offset = (page - 1) * this.params.limit;
        this.load();
    }
    init() {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.inited)) {
            this.inited = true;
            this.params = {
                search: '',
                limit: this.gridSize * 2,
                offset: 0,
            };
            this.page = 1;
            this.searchInput.value = '';
            this.load();
        }
        else {
            this.searchInput.value = this.params.search || '';
        }
    }
    load() {
        this.entities = [];
        this.loading = true;
        this.entitiesProvider(this.params).subscribe({
            next: ({ rows, total }) => {
                this.errorResponse.emit(null);
                this.entities = rows;
                this.total = total;
                this.isEmpty = total === 0;
                this.loading = false;
                this.accessService.total.next(this.total);
            },
            error: (response) => {
                this.loading = false;
                this.errorResponse.emit(response);
            },
        });
    }
}
EntitiesComponent.ɵfac = function EntitiesComponent_Factory(t) { return new (t || EntitiesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_access_service__WEBPACK_IMPORTED_MODULE_1__.AccessService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__.ElementRef)); };
EntitiesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: EntitiesComponent, selectors: [["app-entities"]], inputs: { entitiesProvider: "entitiesProvider", entityTemplate: "entityTemplate", searchInput: "searchInput", selected: "selected", isUser: "isUser", gridSize: "gridSize" }, outputs: { onSelect: "onSelect", errorResponse: "errorResponse" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"]], decls: 3, vars: 2, consts: [[4, "ngIf", "ngIfElse"], ["loader", ""], [4, "ngIf"], ["trackById", "", 4, "ngFor", "ngForOf"], ["rowTemplate", ""], [3, "total", "limit", "page", "onPageChange"], ["trackById", ""], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["tooltipify", "", 1, "checkbox", 3, "checked", "sl-change"], [1, "spinner"]], template: function EntitiesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, EntitiesComponent_ng_container_0_Template, 7, 8, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, EntitiesComponent_ng_template_1_Template, 1, 0, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", !ctx.loading)("ngIfElse", _r1);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.PaginationComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TooltipifyDirective, ng_track_by__WEBPACK_IMPORTED_MODULE_7__.TrackByIdDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  position: relative;\n  flex: 1;\n}\n.content[_ngcontent-%COMP%] {\n  display: grid;\n  grid-auto-flow: column;\n  grid-template-columns: repeat(2, 50%);\n  grid-row-gap: 4px;\n  margin-bottom: var(--sl-spacing-large);\n}\n.content-10[_ngcontent-%COMP%] {\n  grid-template-rows: repeat(10, 32px);\n}\n.content-12[_ngcontent-%COMP%] {\n  grid-template-rows: repeat(12, 32px);\n}\n.checkbox[_ngcontent-%COMP%]::part(base) {\n  display: initial;\n}\n.checkbox[_ngcontent-%COMP%]::part(label) {\n  margin-left: var(--sl-spacing-x-small);\n}\n.checkbox[_ngcontent-%COMP%]::part(control) {\n  position: relative;\n  top: 3px;\n}\n.spinner[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  font-size: 1rem;\n  background: rgba(255, 255, 255, 0.5);\n}\ncore-pagination[_ngcontent-%COMP%] {\n  margin-top: calc(0px - var(--sl-spacing-small));\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVudGl0aWVzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksa0JBQUE7RUFDQSxPQUFBO0FBQ0o7QUFFQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHFDQUFBO0VBQ0EsaUJBQUE7RUFDQSxzQ0FBQTtBQUFKO0FBRUk7RUFDSSxvQ0FBQTtBQUFSO0FBR0k7RUFDSSxvQ0FBQTtBQURSO0FBTUk7RUFDSSxnQkFBQTtBQUpSO0FBT0k7RUFDSSxzQ0FBQTtBQUxSO0FBUUk7RUFDSSxrQkFBQTtFQUNBLFFBQUE7QUFOUjtBQVVBO0VBQ0ksa0JBQUE7RUFDQSxRQUFBO0VBQ0EsU0FBQTtFQUNBLGdDQUFBO0VBQ0EsZUFBQTtFQUNBLG9DQUFBO0FBUko7QUFXQTtFQUNJLCtDQUFBO0FBVEoiLCJmaWxlIjoiZW50aXRpZXMuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyI6aG9zdCB7XG4gICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgIGZsZXg6IDE7XG59XG5cbi5jb250ZW50IHtcbiAgICBkaXNwbGF5OiBncmlkO1xuICAgIGdyaWQtYXV0by1mbG93OiBjb2x1bW47XG4gICAgZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOiByZXBlYXQoMiwgNTAlKTtcbiAgICBncmlkLXJvdy1nYXA6IDRweDtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcblxuICAgICYtMTAge1xuICAgICAgICBncmlkLXRlbXBsYXRlLXJvd3M6IHJlcGVhdCgxMCwgMzJweCk7XG4gICAgfVxuXG4gICAgJi0xMiB7XG4gICAgICAgIGdyaWQtdGVtcGxhdGUtcm93czogcmVwZWF0KDEyLCAzMnB4KTtcbiAgICB9XG59XG5cbi5jaGVja2JveCB7XG4gICAgJjo6cGFydChiYXNlKSB7XG4gICAgICAgIGRpc3BsYXk6IGluaXRpYWw7XG4gICAgfVxuXG4gICAgJjo6cGFydChsYWJlbCkge1xuICAgICAgICBtYXJnaW4tbGVmdDogdmFyKC0tc2wtc3BhY2luZy14LXNtYWxsKTtcbiAgICB9XG5cbiAgICAmOjpwYXJ0KGNvbnRyb2wpIHtcbiAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICB0b3A6IDNweDtcbiAgICB9XG59XG5cbi5zcGlubmVyIHtcbiAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgdG9wOiA1MCU7XG4gICAgbGVmdDogNTAlO1xuICAgIHRyYW5zZm9ybTogdHJhbnNsYXRlKC01MCUsIC01MCUpO1xuICAgIGZvbnQtc2l6ZTogMXJlbTtcbiAgICBiYWNrZ3JvdW5kOiByZ2JhKDI1NSwgMjU1LCAyNTUsIDAuNSk7XG59XG5cbmNvcmUtcGFnaW5hdGlvbiB7XG4gICAgbWFyZ2luLXRvcDogY2FsYygwcHggLSB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKSk7XG59XG4iXX0= */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], EntitiesComponent.prototype, "entities", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.Debounce)(300)
], EntitiesComponent.prototype, "onSearch", null);


/***/ }),

/***/ 4335:
/*!*********************************************************************!*\
  !*** ./src/app/components/modal-actions/modal-actions.component.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalActionsComponent": () => (/* binding */ ModalActionsComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);




function ModalActionsComponent_sl_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalActionsComponent_sl_button_1_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r4); const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r3.onBack.emit()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r0.backTitle), " ");
} }
function ModalActionsComponent_sl_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalActionsComponent_sl_button_3_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.onCancel.emit()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r1.cancelTitle), " ");
} }
function ModalActionsComponent_sl_button_4_Template(rf, ctx) { if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalActionsComponent_sl_button_4_Template_sl_button_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r8); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r7.onOk.emit($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("extra-margin", ctx_r2.extraMargin);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("type", ctx_r2.type)("loading", ctx_r2.loading);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 5, ctx_r2.okTitle), " ");
} }
const _c0 = ["*"];
class ModalActionsComponent {
    constructor() {
        this.hasCancel = true;
        this.hasOk = true;
        this.hasBack = false;
        this.okTitle = '$.save';
        this.cancelTitle = '$.cancel';
        this.backTitle = '$.back';
        this.loading = false;
        this.type = 'submit';
        this.extraMargin = false;
        this.onOk = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onBack = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }
}
ModalActionsComponent.ɵfac = function ModalActionsComponent_Factory(t) { return new (t || ModalActionsComponent)(); };
ModalActionsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ModalActionsComponent, selectors: [["app-modal-actions"]], inputs: { hasCancel: "hasCancel", hasOk: "hasOk", hasBack: "hasBack", okTitle: "okTitle", cancelTitle: "cancelTitle", backTitle: "backTitle", loading: "loading", type: "type", extraMargin: "extraMargin" }, outputs: { onOk: "onOk", onCancel: "onCancel", onBack: "onBack" }, ngContentSelectors: _c0, decls: 6, vars: 5, consts: [[1, "actions"], ["variant", "text", 3, "click", 4, "ngIf"], [1, "right-panel"], ["variant", "primary", "outline", "", 3, "click", 4, "ngIf"], ["variant", "primary", 3, "type", "loading", "extra-margin", "click", 4, "ngIf"], ["variant", "text", 3, "click"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", 3, "type", "loading", "click"]], template: function ModalActionsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ModalActionsComponent_sl_button_1_Template, 3, 3, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, ModalActionsComponent_sl_button_3_Template, 3, 3, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, ModalActionsComponent_sl_button_4_Template, 3, 7, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("has-back-button", ctx.hasBack);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.hasBack);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.hasCancel);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.hasOk);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_1__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.TranslatePipe], styles: [".actions[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  margin-top: var(--sl-spacing-x-large);\n}\n.right-panel[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n.has-back-button[_ngcontent-%COMP%] {\n  justify-content: space-between;\n}\nsl-button[_ngcontent-%COMP%]:not([variant='text']) {\n  margin-left: var(--sl-spacing-small);\n}\nsl-button[_ngcontent-%COMP%]:not([variant='text'])::part(base) {\n  border-radius: 2px;\n  height: auto;\n}\nsl-button[_ngcontent-%COMP%]:not([variant='text'])::part(label) {\n  padding: calc(var(--sl-spacing-2x-small) - 1px) calc(var(--sl-spacing-medium) - 1px);\n  line-height: 28px;\n}\n.extra-margin[_ngcontent-%COMP%] {\n  margin-left: 24px !important;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vZGFsLWFjdGlvbnMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSx5QkFBQTtFQUNBLHFDQUFBO0FBQ0o7QUFFQTtFQUVRLGdCQUFBO0FBRFI7QUFLQTtFQUNJLDhCQUFBO0FBSEo7QUFNQTtFQUNJLG9DQUFBO0FBSko7QUFNSTtFQUNJLGtCQUFBO0VBQ0EsWUFBQTtBQUpSO0FBT0k7RUFDSSxvRkFBQTtFQUVBLGlCQUFBO0FBTlI7QUFVQTtFQUNJLDRCQUFBO0FBUkoiLCJmaWxlIjoibW9kYWwtYWN0aW9ucy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5hY3Rpb25zIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gICAganVzdGlmeS1jb250ZW50OiBmbGV4LWVuZDtcbiAgICBtYXJnaW4tdG9wOiB2YXIoLS1zbC1zcGFjaW5nLXgtbGFyZ2UpO1xufVxuXG4ucmlnaHQtcGFuZWwge1xuICAgIHNsLWJ1dHRvbiB7XG4gICAgICAgIG1pbi13aWR0aDogMTAwcHg7XG4gICAgfVxufVxuXG4uaGFzLWJhY2stYnV0dG9uIHtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG5cbnNsLWJ1dHRvbjpub3QoW3ZhcmlhbnQ9J3RleHQnXSkge1xuICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcblxuICAgICY6OnBhcnQoYmFzZSkge1xuICAgICAgICBib3JkZXItcmFkaXVzOiAycHg7XG4gICAgICAgIGhlaWdodDogYXV0bztcbiAgICB9XG5cbiAgICAmOjpwYXJ0KGxhYmVsKSB7XG4gICAgICAgIHBhZGRpbmc6IGNhbGModmFyKC0tc2wtc3BhY2luZy0yeC1zbWFsbCkgLSAxcHgpXG4gICAgICAgICAgICBjYWxjKHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKSAtIDFweCk7XG4gICAgICAgIGxpbmUtaGVpZ2h0OiAyOHB4O1xuICAgIH1cbn1cblxuLmV4dHJhLW1hcmdpbiB7XG4gICAgbWFyZ2luLWxlZnQ6IDI0cHggIWltcG9ydGFudDtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 4108:
/*!******************************************************************!*\
  !*** ./src/app/components/modal-actions/modal-actions.module.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalActionsModule": () => (/* binding */ ModalActionsModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modal_actions_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modal-actions.component */ 4335);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);




class ModalActionsModule {
}
ModalActionsModule.ɵfac = function ModalActionsModule_Factory(t) { return new (t || ModalActionsModule)(); };
ModalActionsModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: ModalActionsModule });
ModalActionsModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](ModalActionsModule, { declarations: [_modal_actions_component__WEBPACK_IMPORTED_MODULE_0__.ModalActionsComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule], exports: [_modal_actions_component__WEBPACK_IMPORTED_MODULE_0__.ModalActionsComponent] }); })();


/***/ }),

/***/ 2429:
/*!*****************************************************!*\
  !*** ./src/app/services/server-response.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ServerResponseService": () => (/* binding */ ServerResponseService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);



class ServerResponseService {
    constructor(responseErrorService) {
        this.responseErrorService = responseErrorService;
        this.errorsTemplate = [
            404 /* HttpStatusCode.NotFound */,
            403 /* HttpStatusCode.Forbidden */,
            500 /* HttpStatusCode.InternalServerError */,
            503 /* HttpStatusCode.ServiceUnavailable */,
        ];
    }
    getStatusOrNotify(response, key = '') {
        if (this.errorsTemplate.includes(response.status)) {
            return response.status;
        }
        this.responseErrorService.show.emit({
            responseError: response,
            key,
        });
        return null;
    }
}
ServerResponseService.ɵfac = function ServerResponseService_Factory(t) { return new (t || ServerResponseService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.ResponseErrorService)); };
ServerResponseService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ServerResponseService, factory: ServerResponseService.ɵfac, providedIn: 'root' });


/***/ })

}]);
//# sourceMappingURL=default-src_app_components_access_entities_entities_component_ts-src_app_components_modal-act-3e87f4.js.map