"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["default-src_app_api_data-api_service_ts-src_app_enums_dataset_ts-src_app_enums_update-dataset-14c649"],{

/***/ 9613:
/*!*****************************************!*\
  !*** ./src/app/api/data-api.service.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataApiService": () => (/* binding */ DataApiService)
/* harmony export */ });
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs/operators */ 635);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);



class DataApiService {
    constructor(restService) {
        this.restService = restService;
    }
    dataset(data) {
        return this.restService.post('/data/dataset', data);
    }
    merge(data) {
        return this.restService.post('/data/merge', data);
    }
    formula(data) {
        return this.restService.post('/data/formula', data);
    }
    ping(datasetId) {
        return this.restService
            .get(`/dataset/ping`, {
            ids: [datasetId],
        })
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)((progressMap) => progressMap[datasetId]));
    }
}
DataApiService.ɵfac = function DataApiService_Factory(t) { return new (t || DataApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.RestService)); };
DataApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: DataApiService, factory: DataApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 6119:
/*!*************************************************!*\
  !*** ./src/app/api/dataset-rule-api.service.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetRuleApiService": () => (/* binding */ DatasetRuleApiService),
/* harmony export */   "GlobalRule": () => (/* binding */ GlobalRule)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);



class DatasetRuleApiService {
    constructor(restService) {
        this.restService = restService;
    }
    getLocalRules(datasetId, globalRule, params) {
        return this.restService.get(`/dataset/${datasetId}/data-restrictions/${globalRule}/rules`, params);
    }
    getLocalRule(datasetId, globalRule, ruleId) {
        return this.restService.get(`/dataset/${datasetId}/data-restrictions/${globalRule}/rules/${ruleId}`);
    }
    deleteLocalRules(datasetId, globalRule, ruleIds) {
        return this.restService.delete(`/dataset/${datasetId}/data-restrictions/${globalRule}/rules`, { ids: ruleIds });
    }
    saveLocaleRule(datasetId, globalRule, rule) {
        return this.restService.put(`/dataset/${datasetId}/data-restrictions/${globalRule}/rules`, rule);
    }
    saveGlobalRule(id, params) {
        return this.restService.patch(`/dataset/${id}/data-restrictions`, params);
    }
    getGlobalRulesUsers(datasetId, globalRule, params) {
        return this.restService.get(`/dataset/${datasetId}/data-restrictions/${globalRule}/users`, params);
    }
    getGlobalRulesGroups(datasetId, globalRule, params) {
        return this.restService.get(`/dataset/${datasetId}/data-restrictions/${globalRule}/groups`, params);
    }
    getLocalRulesAvailableGroups(datasetId, globalRule, params) {
        return this.restService.get(`/dataset/${datasetId}/data-restrictions/${globalRule}/rules-groups`, params);
    }
    getLocalRulesAvailableUsers(datasetId, globalRule, params) {
        return this.restService.get(`/dataset/${datasetId}/data-restrictions/${globalRule}/rules-users`, params);
    }
}
DatasetRuleApiService.ɵfac = function DatasetRuleApiService_Factory(t) { return new (t || DatasetRuleApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
DatasetRuleApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: DatasetRuleApiService, factory: DatasetRuleApiService.ɵfac, providedIn: 'root' });
var GlobalRule;
(function (GlobalRule) {
    GlobalRule["AllowAll"] = "allow-all";
    GlobalRule["AllowSelect"] = "allow-select";
    GlobalRule["RestrictSelect"] = "restrict-select";
    GlobalRule["RestrictAll"] = "restrict-all";
})(GlobalRule || (GlobalRule = {}));


/***/ }),

/***/ 8283:
/*!*****************************************************************************************!*\
  !*** ./src/app/components/rule-access/rule-access-modal/rule-access-modal.component.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RuleAccessModalComponent": () => (/* binding */ RuleAccessModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../rule-access.component */ 8034);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _access_entities_entities_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../access/entities/entities.component */ 1405);








function RuleAccessModalComponent_ng_template_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](0);
} if (rf & 2) {
    const group_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r6.name, " ");
} }
function RuleAccessModalComponent_ng_template_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "core-avatar", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const user_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("user", user_r7)("size", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 3, user_r7), " ");
} }
class RuleAccessModalComponent {
    constructor() {
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = _rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State;
        this.isEmpty = false;
        this.loading = false;
        this.currentState = _rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups;
        this.open = false;
        this.selectedGroups = [];
        this.selectedUsers = [];
    }
    selectUsers(event) {
        this.selectedUsers = event;
    }
    selectGroups(event) {
        this.selectedGroups = event;
    }
    show(users, groups, state = _rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups) {
        this.selectedUsers = [...users];
        this.selectedGroups = [...groups];
        this.currentState = state;
        this.open = true;
    }
    hide() {
        this.open = false;
    }
    changeState(state) {
        this.currentState = state;
    }
    save() {
        const params = {
            users: this.selectedUsers,
            groups: this.selectedGroups,
        };
        this.onSave.emit(params);
    }
    onShow(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = 'hidden';
    }
    onHide(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = '';
    }
}
RuleAccessModalComponent.ɵfac = function RuleAccessModalComponent_Factory(t) { return new (t || RuleAccessModalComponent)(); };
RuleAccessModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: RuleAccessModalComponent, selectors: [["app-rule-access-modal"]], inputs: { usersProvider: "usersProvider", groupsProvider: "groupsProvider", state: "state", dataset: "dataset", globalRule: "globalRule" }, outputs: { onSave: "onSave" }, decls: 29, vars: 32, consts: [[3, "open", "label", "openChange", "sl-show", "sl-hide"], ["dialog", ""], [1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], ["clearable", "", 1, "search", 3, "placeholder"], ["searchInput", ""], ["slot", "clear-icon", "name", "x"], ["slot", "suffix", "library", "core", "name", "search-bold"], [1, "ents"], [1, "entities"], [3, "gridSize", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect"], ["groupEntityTemplate", ""], [3, "gridSize", "isUser", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect"], ["userEntityTemplate", ""], [3, "click"], ["variant", "primary", 3, "click"], [3, "user", "size"]], template: function RuleAccessModalComponent_Template(rf, ctx) { if (rf & 1) {
        const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0, 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function RuleAccessModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.open = $event; })("sl-show", function RuleAccessModalComponent_Template_sl_dialog_sl_show_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onShow(_r0)); })("sl-hide", function RuleAccessModalComponent_Template_sl_dialog_sl_hide_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onHide(_r0)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "div", 2)(4, "div")(5, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_5_listener() { return ctx.changeState(ctx.State.Groups); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_7_listener() { return ctx.changeState(ctx.State.Users); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](8, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "sl-input", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](12, "sl-icon", 8)(13, "sl-icon", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](14, "div", 10)(15, "div", 11)(16, "app-entities", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function RuleAccessModalComponent_Template_app_entities_onSelect_16_listener($event) { return ctx.selectGroups($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](17, RuleAccessModalComponent_ng_template_17_Template, 1, 1, "ng-template", null, 13, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "app-entities", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function RuleAccessModalComponent_Template_app_entities_onSelect_19_listener($event) { return ctx.selectUsers($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](20, RuleAccessModalComponent_ng_template_20_Template, 4, 5, "ng-template", null, 15, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](22, "footer")(23, "sl-button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_23_listener() { return ctx.open = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](25, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](26, "sl-button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_26_listener() { return ctx.save(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](10);
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](18);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("open", ctx.open)("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 24, "_$.access.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 26, "_$.access.search"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("gridSize", 12)("entitiesProvider", ctx.groupsProvider)("entityTemplate", _r2)("searchInput", _r1)("selected", ctx.selectedGroups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("gridSize", 12)("isUser", true)("entitiesProvider", ctx.usersProvider)("entityTemplate", _r4)("searchInput", _r1)("selected", ctx.selectedUsers);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](25, 28, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](28, 30, "$.apply"), " ");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AvatarComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, _access_entities_entities_component__WEBPACK_IMPORTED_MODULE_1__.EntitiesComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipe], styles: ["sl-dialog[_ngcontent-%COMP%] {\n  --width: 730px;\n  visibility: visible;\n}\n.search[_ngcontent-%COMP%] {\n  width: 266px;\n}\n.label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-large);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.ents[_ngcontent-%COMP%] {\n  min-height: 420px;\n  height: 100%;\n}\ncore-avatar[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-small);\n  margin-bottom: var(--sl-spacing-2x-small);\n}\nsl-checkbox[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(base) {\n  width: 100%;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(label) {\n  display: flex;\n  overflow: hidden;\n}\n.spinner-container[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], RuleAccessModalComponent.prototype, "loading", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], RuleAccessModalComponent.prototype, "selectedGroups", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], RuleAccessModalComponent.prototype, "selectedUsers", void 0);


/***/ }),

/***/ 8034:
/*!*****************************************************************!*\
  !*** ./src/app/components/rule-access/rule-access.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RuleAccessComponent": () => (/* binding */ RuleAccessComponent),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_to_parent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ng-to-parent */ 5468);
/* harmony import */ var _rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rule-access-modal/rule-access-modal.component */ 8283);




function RuleAccessComponent_sl_badge_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "sl-badge", 12);
} }
function RuleAccessComponent_sl_badge_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "sl-badge", 12);
} }
function RuleAccessComponent_ng_container_12_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function RuleAccessComponent_ng_container_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, RuleAccessComponent_ng_container_12_ng_container_1_Template, 1, 0, "ng-container", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r4);
} }
function RuleAccessComponent_ng_container_13_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function RuleAccessComponent_ng_container_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, RuleAccessComponent_ng_container_13_ng_container_1_Template, 1, 0, "ng-container", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r6);
} }
function RuleAccessComponent_ng_template_14_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-tag", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-remove", function RuleAccessComponent_ng_template_14_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const group_r12 = restoredCtx.$implicit; const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.removeGroup.emit(group_r12.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const group_r12 = ctx.$implicit;
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("error", ctx_r11.errorGroupIds == null ? null : ctx_r11.errorGroupIds.has(group_r12.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", group_r12.name, " ");
} }
function RuleAccessComponent_ng_template_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, RuleAccessComponent_ng_template_14_sl_tag_0_Template, 3, 3, "sl-tag", 14);
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r5.groups);
} }
function RuleAccessComponent_ng_template_16_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-tag", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-remove", function RuleAccessComponent_ng_template_16_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r18); const user_r16 = restoredCtx.$implicit; const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r17.removeUser.emit(user_r16.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const user_r16 = ctx.$implicit;
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("error", ctx_r15.errorUserIds == null ? null : ctx_r15.errorUserIds.has(user_r16.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 3, user_r16), " ");
} }
function RuleAccessComponent_ng_template_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, RuleAccessComponent_ng_template_16_sl_tag_0_Template, 4, 5, "sl-tag", 14);
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r7.users);
} }
var State;
(function (State) {
    State[State["Users"] = 0] = "Users";
    State[State["Groups"] = 1] = "Groups";
})(State || (State = {}));
class RuleAccessComponent {
    constructor() {
        this.users = [];
        this.groups = [];
        this.removeUser = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.removeGroup = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.State = State;
        this.state = State.Groups;
    }
    set globalRule(value) {
        this._globalRule = value;
        if (!this._globalRule || !this.dataset)
            return;
    }
    get globalRule() {
        return this._globalRule;
    }
}
RuleAccessComponent.ɵfac = function RuleAccessComponent_Factory(t) { return new (t || RuleAccessComponent)(); };
RuleAccessComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: RuleAccessComponent, selectors: [["app-rule-access"]], viewQuery: function RuleAccessComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessModalComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.ruleAccessModal = _t.first);
    } }, inputs: { users: "users", groups: "groups", usersProvider: "usersProvider", groupsProvider: "groupsProvider", dataset: "dataset", errorUserIds: "errorUserIds", errorGroupIds: "errorGroupIds", globalRule: "globalRule" }, outputs: { removeUser: "removeUser", removeGroup: "removeGroup", update: "update" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"]([ng_to_parent__WEBPACK_IMPORTED_MODULE_2__.ToParent])], decls: 23, vars: 19, consts: [[1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["variant", "danger", "pill", "", 4, "ngIf"], ["name", "person"], [1, "values"], [4, "ngIf"], ["groupTemplate", ""], ["userTemplate", ""], ["variant", "text", 3, "click"], [3, "dataset", "state", "globalRule", "usersProvider", "groupsProvider", "onSave"], ["ruleAccesModal", ""], ["variant", "danger", "pill", ""], [4, "ngTemplateOutlet"], ["pill", "", "removable", "", 3, "error", "sl-remove", 4, "ngFor", "ngForOf"], ["pill", "", "removable", "", 3, "sl-remove"], ["tooltipify", "", 1, "tag-name"]], template: function RuleAccessComponent_Template(rf, ctx) { if (rf & 1) {
        const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0)(1, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div")(5, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function RuleAccessComponent_Template_sl_button_click_5_listener() { return ctx.state = ctx.State.Groups; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](6, "sl-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, RuleAccessComponent_sl_badge_7_Template, 1, 0, "sl-badge", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function RuleAccessComponent_Template_sl_button_click_8_listener() { return ctx.state = ctx.State.Users; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](9, "sl-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, RuleAccessComponent_sl_badge_10_Template, 1, 0, "sl-badge", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, RuleAccessComponent_ng_container_12_Template, 2, 1, "ng-container", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](13, RuleAccessComponent_ng_container_13_Template, 2, 1, "ng-container", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](14, RuleAccessComponent_ng_template_14_Template, 1, 1, "ng-template", null, 7, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](16, RuleAccessComponent_ng_template_16_Template, 1, 1, "ng-template", null, 8, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "sl-button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function RuleAccessComponent_Template_sl_button_click_18_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r19); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](22); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](_r8.show(ctx.users, ctx.groups, ctx.state)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "app-rule-access-modal", 10, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onSave", function RuleAccessComponent_Template_app_rule_access_modal_onSave_21_listener($event) { return ctx.update.emit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 15, "entitiesTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.errorGroupIds == null ? null : ctx.errorGroupIds.size);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.errorUserIds == null ? null : ctx.errorUserIds.size);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](20, 17, "_$.access.add"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("dataset", ctx.dataset)("state", ctx.state)("globalRule", ctx.globalRule)("usersProvider", ctx.usersProvider)("groupsProvider", ctx.groupsProvider);
    } }, styles: [".label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-small);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.values[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  gap: 10px 11px;\n  overflow: hidden auto;\n  max-height: 240px;\n}\n.values[_ngcontent-%COMP%]:not(:empty) {\n  padding: var(--sl-spacing-small) 0;\n}\nsl-tag[_ngcontent-%COMP%] {\n  max-width: 100%;\n  background-color: var(--sl-color-neutral-0);\n  border-radius: 20px;\n}\nsl-tag[_ngcontent-%COMP%]::part(base) {\n  height: 26px;\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button) {\n  margin-left: var(--sl-spacing-x-small);\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button__base) {\n  height: 16px;\n  width: 16px;\n}\nsl-tag[_ngcontent-%COMP%]::part(content) {\n  display: flex;\n  overflow: hidden;\n}\nsl-badge[_ngcontent-%COMP%] {\n  top: 4px;\n  right: 5px;\n}\nsl-badge[_ngcontent-%COMP%]::part(base) {\n  padding: var(--sl-spacing-2x-small);\n}\n.error[_ngcontent-%COMP%]::part(base) {\n  border: 1px solid var(--sl-color-danger-600);\n}\n.tag-name[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-950);\n  font-size: 13px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 163:
/*!**********************************!*\
  !*** ./src/app/enums/dataset.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProgressType": () => (/* binding */ ProgressType),
/* harmony export */   "RowLimit": () => (/* binding */ RowLimit),
/* harmony export */   "SqlColumnType": () => (/* binding */ SqlColumnType),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
var ProgressType;
(function (ProgressType) {
    ProgressType[ProgressType["Default"] = 0] = "Default";
    ProgressType[ProgressType["Bytes"] = 1] = "Bytes";
    ProgressType[ProgressType["Rows"] = 2] = "Rows";
})(ProgressType || (ProgressType = {}));
var State;
(function (State) {
    State[State["Default"] = 0] = "Default";
    State[State["Wait"] = 1] = "Wait";
    State[State["Done"] = 2] = "Done";
    State[State["Reject"] = 3] = "Reject";
})(State || (State = {}));
var RowLimit;
(function (RowLimit) {
    RowLimit[RowLimit["Ten"] = 10] = "Ten";
    RowLimit[RowLimit["Fifty"] = 50] = "Fifty";
    RowLimit[RowLimit["Hundred"] = 100] = "Hundred";
    RowLimit[RowLimit["All"] = 101] = "All";
})(RowLimit || (RowLimit = {}));
var SqlColumnType;
(function (SqlColumnType) {
    SqlColumnType["New"] = "new";
    SqlColumnType["Changed"] = "change";
    SqlColumnType["Deleted"] = "remove";
    SqlColumnType["Old"] = "old";
})(SqlColumnType || (SqlColumnType = {}));


/***/ }),

/***/ 8278:
/*!*****************************************!*\
  !*** ./src/app/enums/update-dataset.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DayWeek": () => (/* binding */ DayWeek),
/* harmony export */   "InputsType": () => (/* binding */ InputsType),
/* harmony export */   "Month": () => (/* binding */ Month),
/* harmony export */   "ScheduleType": () => (/* binding */ ScheduleType)
/* harmony export */ });
var ScheduleType;
(function (ScheduleType) {
    ScheduleType[ScheduleType["Interval"] = 0] = "Interval";
    ScheduleType[ScheduleType["Period"] = 1] = "Period";
})(ScheduleType || (ScheduleType = {}));
var DayWeek;
(function (DayWeek) {
    DayWeek[DayWeek["Monday"] = 1] = "Monday";
    DayWeek[DayWeek["Tuesday"] = 2] = "Tuesday";
    DayWeek[DayWeek["Wednesday"] = 3] = "Wednesday";
    DayWeek[DayWeek["Thursday"] = 4] = "Thursday";
    DayWeek[DayWeek["Friday"] = 5] = "Friday";
    DayWeek[DayWeek["Saturday"] = 6] = "Saturday";
    DayWeek[DayWeek["Sunday"] = 7] = "Sunday";
})(DayWeek || (DayWeek = {}));
var InputsType;
(function (InputsType) {
    InputsType[InputsType["Hour"] = 1] = "Hour";
    InputsType[InputsType["Day"] = 2] = "Day";
    InputsType[InputsType["Month"] = 3] = "Month";
    InputsType[InputsType["WeekDay"] = 4] = "WeekDay";
    InputsType[InputsType["Year"] = 5] = "Year";
})(InputsType || (InputsType = {}));
var Month;
(function (Month) {
    Month[Month["January"] = 1] = "January";
    Month[Month["February"] = 2] = "February";
    Month[Month["March"] = 3] = "March";
    Month[Month["April"] = 4] = "April";
    Month[Month["May"] = 5] = "May";
    Month[Month["June"] = 6] = "June";
    Month[Month["July"] = 7] = "July";
    Month[Month["August"] = 8] = "August";
    Month[Month["September"] = 9] = "September";
    Month[Month["October"] = 10] = "October";
    Month[Month["November"] = 11] = "November";
    Month[Month["December"] = 12] = "December";
})(Month || (Month = {}));


/***/ }),

/***/ 1893:
/*!***********************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/access/entities/local-entities.component.ts ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalEntitiesComponent": () => (/* binding */ LocalEntitiesComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! logical-not */ 2905);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-track-by */ 1050);











function LocalEntitiesComponent_ng_container_0_p_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "access#noSearchResults"));
} }
function LocalEntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
const _c0 = function (a0) { return { $implicit: a0 }; };
function LocalEntitiesComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0, 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LocalEntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const entity_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r5)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](2, _c0, entity_r7));
} }
function LocalEntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function LocalEntitiesComponent_ng_container_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-checkbox", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-change", function LocalEntitiesComponent_ng_container_0_ng_template_4_Template_sl_checkbox_sl_change_0_listener($event) { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r12); const entity_r9 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onToggle(entity_r9, $event.target.checked)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LocalEntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const entity_r9 = ctx.$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("checked", ctx_r6.isSelected(entity_r9));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", ctx_r6.entityTemplate)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](3, _c0, entity_r9));
} }
function LocalEntitiesComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, LocalEntitiesComponent_ng_container_0_p_2_Template, 3, 3, "p", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, LocalEntitiesComponent_ng_container_0_ng_container_3_Template, 2, 4, "ng-container", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, LocalEntitiesComponent_ng_container_0_ng_template_4_Template, 2, 5, "ng-template", null, 5, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "core-pagination", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onPageChange", function LocalEntitiesComponent_ng_container_0_Template_core_pagination_onPageChange_6_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onPageChange($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.isEmpty);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r0.entities);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("total", ctx_r0.total)("limit", ctx_r0.params.limit)("page", ctx_r0.page);
} }
function LocalEntitiesComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "sl-spinner", 10);
} }
class LocalEntitiesComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__.SubscribableComponent {
    constructor(hostRef) {
        super();
        this.hostRef = hostRef;
        this.onSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.errorResponse = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.entities = [];
        this.params = {};
        this.total = 0;
        this.page = 1;
        this.isEmpty = false;
        this.loading = false;
        this.inited = false;
    }
    ngOnInit() {
        this.dialog = this.hostRef.nativeElement.closest('sl-dialog');
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.dialog, 'sl-show').subscribe((event) => {
                if (event.target === this.dialog) {
                    this.inited = false;
                    this.init();
                }
            }),
            (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.searchInput, 'sl-input').subscribe(() => {
                this.onSearch(this.searchInput.value);
            }),
        ];
    }
    onSearch(search) {
        this.params.search = search;
        this.params.offset = 0;
        this.page = 1;
        this.load();
    }
    isSelected(entity) {
        const isAddedItem = this.changes.added.some((item) => item.id === entity.id);
        const isRemovedItem = this.changes.removed.some((item) => item.id === entity.id);
        return (entity.selected || isAddedItem) && !isRemovedItem;
    }
    onToggle(entity, flag) {
        this.changes.removed = this.changes.removed.filter((item) => item.id !== entity.id);
        this.changes.added = this.changes.added.filter((item) => item.id !== entity.id);
        if (entity.selected !== flag) {
            flag
                ? this.changes.added.push(entity)
                : this.changes.removed.push(entity);
        }
        this.onSelect.emit({
            added: this.changes.added,
            removed: this.changes.removed,
        });
    }
    onPageChange(page) {
        this.page = page;
        this.params.offset = (page - 1) * this.params.limit;
        this.load();
    }
    init() {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.inited)) {
            this.inited = true;
            this.params = {
                search: '',
                limit: 24,
                offset: 0,
            };
            this.page = 1;
            this.searchInput.value = '';
            this.load();
        }
        else {
            this.searchInput.value = this.params.search || '';
        }
    }
    load() {
        this.entities = [];
        this.loading = true;
        this.entitiesProvider(this.params).subscribe({
            next: ({ rows, total }) => {
                this.entities = rows;
                this.total = total;
                this.isEmpty = total === 0;
                this.loading = false;
            },
            error: (response) => {
                this.errorResponse.emit(response);
            },
        });
    }
}
LocalEntitiesComponent.ɵfac = function LocalEntitiesComponent_Factory(t) { return new (t || LocalEntitiesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef)); };
LocalEntitiesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: LocalEntitiesComponent, selectors: [["app-local-entities"]], inputs: { entitiesProvider: "entitiesProvider", entityTemplate: "entityTemplate", searchInput: "searchInput", changes: "changes" }, outputs: { onSelect: "onSelect", errorResponse: "errorResponse" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 3, vars: 2, consts: [[4, "ngIf", "ngIfElse"], ["loader", ""], [1, "content"], [4, "ngIf"], ["trackById", "", 4, "ngFor", "ngForOf"], ["rowTemplate", ""], [3, "total", "limit", "page", "onPageChange"], ["trackById", ""], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["tooltipify", "", 1, "checkbox", 3, "checked", "sl-change"], [1, "spinner"]], template: function LocalEntitiesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, LocalEntitiesComponent_ng_container_0_Template, 7, 5, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LocalEntitiesComponent_ng_template_1_Template, 1, 0, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.loading)("ngIfElse", _r1);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PaginationComponent, ng_track_by__WEBPACK_IMPORTED_MODULE_6__.TrackByIdDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  position: relative;\n  flex: 1;\n}\n.content[_ngcontent-%COMP%] {\n  display: grid;\n  grid-auto-flow: column;\n  grid-template-columns: repeat(2, 50%);\n  grid-template-rows: repeat(12, 32px);\n  grid-row-gap: 4px;\n  margin-bottom: var(--sl-spacing-large);\n}\n.checkbox[_ngcontent-%COMP%]::part(base) {\n  display: initial;\n}\n.checkbox[_ngcontent-%COMP%]::part(label) {\n  margin-left: var(--sl-spacing-x-small);\n}\n.checkbox[_ngcontent-%COMP%]::part(control) {\n  position: relative;\n  top: 3px;\n}\n.spinner[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  font-size: 1rem;\n  background: rgba(255, 255, 255, 0.5);\n}\ncore-pagination[_ngcontent-%COMP%] {\n  margin-top: calc(0px - var(--sl-spacing-small));\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvY2FsLWVudGl0aWVzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksa0JBQUE7RUFDQSxPQUFBO0FBQ0o7QUFFQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHFDQUFBO0VBQ0Esb0NBQUE7RUFDQSxpQkFBQTtFQUNBLHNDQUFBO0FBQUo7QUFJSTtFQUNJLGdCQUFBO0FBRlI7QUFLSTtFQUNJLHNDQUFBO0FBSFI7QUFNSTtFQUNJLGtCQUFBO0VBQ0EsUUFBQTtBQUpSO0FBUUE7RUFDSSxrQkFBQTtFQUNBLFFBQUE7RUFDQSxTQUFBO0VBQ0EsZ0NBQUE7RUFDQSxlQUFBO0VBQ0Esb0NBQUE7QUFOSjtBQVNBO0VBQ0ksK0NBQUE7QUFQSiIsImZpbGUiOiJsb2NhbC1lbnRpdGllcy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgZmxleDogMTtcbn1cblxuLmNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGdyaWQ7XG4gICAgZ3JpZC1hdXRvLWZsb3c6IGNvbHVtbjtcbiAgICBncmlkLXRlbXBsYXRlLWNvbHVtbnM6IHJlcGVhdCgyLCA1MCUpO1xuICAgIGdyaWQtdGVtcGxhdGUtcm93czogcmVwZWF0KDEyLCAzMnB4KTtcbiAgICBncmlkLXJvdy1nYXA6IDRweDtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcbn1cblxuLmNoZWNrYm94IHtcbiAgICAmOjpwYXJ0KGJhc2UpIHtcbiAgICAgICAgZGlzcGxheTogaW5pdGlhbDtcbiAgICB9XG5cbiAgICAmOjpwYXJ0KGxhYmVsKSB7XG4gICAgICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXgtc21hbGwpO1xuICAgIH1cblxuICAgICY6OnBhcnQoY29udHJvbCkge1xuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgIHRvcDogM3B4O1xuICAgIH1cbn1cblxuLnNwaW5uZXIge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB0b3A6IDUwJTtcbiAgICBsZWZ0OiA1MCU7XG4gICAgdHJhbnNmb3JtOiB0cmFuc2xhdGUoLTUwJSwgLTUwJSk7XG4gICAgZm9udC1zaXplOiAxcmVtO1xuICAgIGJhY2tncm91bmQ6IHJnYmEoMjU1LCAyNTUsIDI1NSwgMC41KTtcbn1cblxuY29yZS1wYWdpbmF0aW9uIHtcbiAgICBtYXJnaW4tdG9wOiBjYWxjKDBweCAtIHZhcigtLXNsLXNwYWNpbmctc21hbGwpKTtcbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalEntitiesComponent.prototype, "entities", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.Debounce)(300)
], LocalEntitiesComponent.prototype, "onSearch", null);


/***/ }),

/***/ 7150:
/*!**********************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/rule-access/local-rule-access.component.ts ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleAccessComponent": () => (/* binding */ LocalRuleAccessComponent),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_to_parent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-to-parent */ 5468);
/* harmony import */ var src_app_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/api/dataset-rule-api.service */ 6119);
/* harmony import */ var _rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rule-access-modal/local-rule-access-modal.component */ 6127);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 1989);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);











const _c0 = ["groupsContainer"];
const _c1 = ["usersContainer"];
function LocalRuleAccessComponent_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function LocalRuleAccessComponent_ng_container_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function LocalRuleAccessComponent_ng_template_15_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-tag", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-remove", function LocalRuleAccessComponent_ng_template_15_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r12); const group_r10 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r11.removeGroup(group_r10.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const group_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r10.name, " ");
} }
function LocalRuleAccessComponent_ng_template_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, LocalRuleAccessComponent_ng_template_15_sl_tag_0_Template, 3, 1, "sl-tag", 15);
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r5.groups);
} }
function LocalRuleAccessComponent_ng_template_17_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-tag", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-remove", function LocalRuleAccessComponent_ng_template_17_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r16); const user_r14 = restoredCtx.$implicit; const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r15.removeUser(user_r14.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const user_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 1, user_r14), " ");
} }
function LocalRuleAccessComponent_ng_template_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, LocalRuleAccessComponent_ng_template_17_sl_tag_0_Template, 4, 3, "sl-tag", 15);
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r7.users);
} }
var State;
(function (State) {
    State[State["Users"] = 0] = "Users";
    State[State["Groups"] = 1] = "Groups";
})(State || (State = {}));
const MAX_LIMIT = 150;
const EPSILON = 1;
class LocalRuleAccessComponent {
    constructor(datasetRuleApiService, notifyService, responseErrorService) {
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.users = [];
        this.groups = [];
        this.removedUser = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.removedGroup = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = State;
        this.state = State.Groups;
        this.userTotal = Number.MAX_SAFE_INTEGER;
        this.userParams = this.getDefaultConfig();
        this.groupTotal = Number.MAX_SAFE_INTEGER;
        this.groupParams = this.getDefaultConfig();
    }
    set globalRule(value) {
        this._globalRule = value;
        if (this._globalRule &&
            this.dataset &&
            this._globalRule !== src_app_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.AllowAll)
            this.refresh();
    }
    get globalRule() {
        return this._globalRule;
    }
    ngAfterViewInit() {
        (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.groupsContainer.nativeElement, 'scroll')
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.debounceTime)(500))
            .subscribe(() => {
            if (!this.isScrollEnd(this.groupsContainer.nativeElement)) {
                return;
            }
            this.groupParams.offset += this.groupParams.limit;
            if (this.groupParams.offset >= this.groupTotal) {
                return;
            }
            this.getGroups();
        });
        (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.usersContainer.nativeElement, 'scroll')
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.debounceTime)(500))
            .subscribe(() => {
            if (!this.isScrollEnd(this.usersContainer.nativeElement)) {
                return;
            }
            this.userParams.offset += this.userParams.limit;
            if (this.userParams.offset >= this.userTotal) {
                return;
            }
            this.getUsers();
        });
    }
    isScrollEnd(element) {
        return (element.scrollHeight - element.scrollTop - element.clientHeight <
            EPSILON);
    }
    resetParams() {
        this.users = [];
        this.userTotal = Number.MAX_SAFE_INTEGER;
        this.userParams = this.getDefaultConfig();
        this.groups = [];
        this.groupTotal = Number.MAX_SAFE_INTEGER;
        this.groupParams = this.getDefaultConfig();
    }
    getUsers() {
        this.usersProvider({
            include_not_selected: false,
            search: '',
            limit: this.userParams.limit,
            offset: this.userParams.offset,
        }).subscribe({
            next: (res) => {
                this.userTotal = res.total;
                this.users = [...this.users, ...(res.rows || [])];
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'getUsersGlobalRuleError',
                });
            },
        });
    }
    getGroups() {
        this.groupsProvider({
            include_not_selected: false,
            search: '',
            limit: this.groupParams.limit,
            offset: this.groupParams.offset,
        }).subscribe({
            next: (res) => {
                this.groupTotal = res.total;
                this.groups = [...this.groups, ...(res.rows || [])];
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'getGroupsGlobalRuleError',
                });
            },
        });
    }
    removeUser(userId) {
        this.datasetRuleApiService
            .saveGlobalRule(this.dataset.id, {
            data_access_restriction: this.globalRule,
            remove_users: [userId],
        })
            .subscribe({
            next: () => {
                this.users = this.users.filter((user) => user.id !== userId);
                this.removedUser.emit(userId);
                this.notifyService.toastByName('deleteUser');
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteUserGlobalRuleError',
                });
            },
        });
    }
    removeGroup(groupId) {
        this.datasetRuleApiService
            .saveGlobalRule(this.dataset.id, {
            data_access_restriction: this.globalRule,
            remove_groups: [groupId],
        })
            .subscribe({
            next: () => {
                this.groups = this.groups.filter((group) => group.id !== groupId);
                this.removedGroup.emit(groupId);
                this.notifyService.toastByName('deleteGroup');
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteGroupGlobalRuleError',
                });
            },
        });
    }
    refresh() {
        this.resetParams();
        this.getUsers();
        this.getGroups();
    }
    getDefaultConfig() {
        return {
            limit: MAX_LIMIT,
            offset: 0,
        };
    }
}
LocalRuleAccessComponent.ɵfac = function LocalRuleAccessComponent_Factory(t) { return new (t || LocalRuleAccessComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](src_app_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService)); };
LocalRuleAccessComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: LocalRuleAccessComponent, selectors: [["app-local-rule-access"]], viewQuery: function LocalRuleAccessComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__.LocalRuleAccessModalComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_c1, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.ruleAccessModal = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.groupsContainer = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.usersContainer = _t.first);
    } }, inputs: { usersProvider: "usersProvider", groupsProvider: "groupsProvider", dataset: "dataset", globalRule: "globalRule" }, outputs: { removedUser: "removedUser", removedGroup: "removedGroup", update: "update" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵProvidersFeature"]([ng_to_parent__WEBPACK_IMPORTED_MODULE_6__.ToParent])], decls: 30, vars: 27, consts: [[1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], [1, "values"], ["groupsContainer", ""], [4, "ngTemplateOutlet"], ["usersContainer", ""], ["groupTemplate", ""], ["userTemplate", ""], ["variant", "text", 3, "click"], [3, "dataset", "state", "globalRule", "usersProvider", "groupsProvider", "onSave"], ["ruleAccesModal", ""], ["variant", "success", "name", "deleteUser"], ["variant", "success", "name", "deleteGroup"], ["pill", "", "removable", "", 3, "sl-remove", 4, "ngFor", "ngForOf"], ["pill", "", "removable", "", 3, "sl-remove"], ["tooltipify", "", 1, "tag-name"]], template: function LocalRuleAccessComponent_Template(rf, ctx) { if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0)(1, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "div")(5, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessComponent_Template_sl_button_click_5_listener() { return ctx.state = ctx.State.Groups; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessComponent_Template_sl_button_click_7_listener() { return ctx.state = ctx.State.Users; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](8, "sl-icon", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "div", 4, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](11, LocalRuleAccessComponent_ng_container_11_Template, 1, 0, "ng-container", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "div", 4, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](14, LocalRuleAccessComponent_ng_container_14_Template, 1, 0, "ng-container", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](15, LocalRuleAccessComponent_ng_template_15_Template, 1, 1, "ng-template", null, 8, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](17, LocalRuleAccessComponent_ng_template_17_Template, 1, 1, "ng-template", null, 9, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "sl-button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessComponent_Template_sl_button_click_19_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r17); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](23); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r8.show(ctx.state)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](22, "app-local-rule-access-modal", 11, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSave", function LocalRuleAccessComponent_Template_app_local_rule_access_modal_onSave_22_listener($event) { return ctx.update.emit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](24, "core-notify", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](26, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](27, "core-notify", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](29, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](16);
        const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 19, "entitiesTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.state !== ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.state !== ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](21, 21, "_$.access.add"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("dataset", ctx.dataset)("state", ctx.state)("globalRule", ctx.globalRule)("usersProvider", ctx.usersProvider)("groupsProvider", ctx.groupsProvider);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](26, 23, "ruleDeleteUser"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](29, 25, "ruleDeleteGroup"), "\n");
    } }, styles: [".label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-small);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.values[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  gap: 10px 11px;\n  overflow: hidden auto;\n  max-height: 240px;\n}\n.values[_ngcontent-%COMP%]:not(:empty) {\n  padding: var(--sl-spacing-small) 0;\n}\nsl-tag[_ngcontent-%COMP%] {\n  max-width: 100%;\n  background-color: var(--sl-color-neutral-0);\n  border-radius: 20px;\n}\nsl-tag[_ngcontent-%COMP%]::part(base) {\n  height: 26px;\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button) {\n  margin-left: var(--sl-spacing-x-small);\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button__base) {\n  height: 16px;\n  width: 16px;\n}\nsl-tag[_ngcontent-%COMP%]::part(content) {\n  display: flex;\n  overflow: hidden;\n}\n.tag-name[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-950);\n  font-size: 13px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalRuleAccessComponent.prototype, "users", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalRuleAccessComponent.prototype, "groups", void 0);


/***/ }),

/***/ 6127:
/*!**********************************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/rule-access/rule-access-modal/local-rule-access-modal.component.ts ***!
  \**********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleAccessModalComponent": () => (/* binding */ LocalRuleAccessModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../local-rule-access.component */ 7150);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_entities_local_entities_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../access/entities/local-entities.component */ 1893);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);








function LocalRuleAccessModalComponent_ng_template_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](0);
} if (rf & 2) {
    const group_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r6.name, " ");
} }
function LocalRuleAccessModalComponent_ng_template_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "core-avatar", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const user_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("user", user_r7)("size", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 3, user_r7), " ");
} }
class LocalRuleAccessModalComponent {
    constructor() {
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State;
        this.groupChanges = {
            added: [],
            removed: [],
        };
        this.userChanges = {
            added: [],
            removed: [],
        };
        this.loading = false;
        this.currentState = _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups;
        this.open = false;
    }
    selectUsers(event) {
        this.userChanges = event;
    }
    selectGroups(event) {
        this.groupChanges = event;
    }
    show(state = _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups) {
        this.userChanges = {
            added: [],
            removed: [],
        };
        this.groupChanges = {
            added: [],
            removed: [],
        };
        this.currentState = state;
        this.open = true;
    }
    hide() {
        this.open = false;
    }
    changeState(state) {
        this.currentState = state;
    }
    save() {
        const params = {
            add_groups: this.groupChanges.added.map((item) => item.id),
            remove_groups: this.groupChanges.removed.map((item) => item.id),
            add_users: this.userChanges.added.map((item) => item.id),
            remove_users: this.userChanges.removed.map((item) => item.id),
        };
        this.onSave.emit(params);
    }
    onShow(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = 'hidden';
    }
    onHide(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = '';
    }
}
LocalRuleAccessModalComponent.ɵfac = function LocalRuleAccessModalComponent_Factory(t) { return new (t || LocalRuleAccessModalComponent)(); };
LocalRuleAccessModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: LocalRuleAccessModalComponent, selectors: [["app-local-rule-access-modal"]], inputs: { usersProvider: "usersProvider", groupsProvider: "groupsProvider", state: "state", dataset: "dataset", globalRule: "globalRule" }, outputs: { onSave: "onSave" }, decls: 29, vars: 29, consts: [[3, "open", "label", "openChange", "sl-show", "sl-hide"], ["dialog", ""], [1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], ["clearable", "", 1, "search", 3, "placeholder"], ["searchInput", ""], ["slot", "clear-icon", "name", "x"], ["slot", "suffix", "library", "core", "name", "search-bold"], [1, "ents"], [1, "entities"], [3, "entitiesProvider", "entityTemplate", "searchInput", "changes", "onSelect"], ["groupEntityTemplate", ""], ["userEntityTemplate", ""], [3, "click"], ["variant", "primary", 3, "click"], [3, "user", "size"]], template: function LocalRuleAccessModalComponent_Template(rf, ctx) { if (rf & 1) {
        const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0, 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function LocalRuleAccessModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.open = $event; })("sl-show", function LocalRuleAccessModalComponent_Template_sl_dialog_sl_show_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onShow(_r0)); })("sl-hide", function LocalRuleAccessModalComponent_Template_sl_dialog_sl_hide_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onHide(_r0)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "div", 2)(4, "div")(5, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_5_listener() { return ctx.changeState(ctx.State.Groups); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_7_listener() { return ctx.changeState(ctx.State.Users); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](8, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "sl-input", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](12, "sl-icon", 8)(13, "sl-icon", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](14, "div", 10)(15, "div", 11)(16, "app-local-entities", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function LocalRuleAccessModalComponent_Template_app_local_entities_onSelect_16_listener($event) { return ctx.selectGroups($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](17, LocalRuleAccessModalComponent_ng_template_17_Template, 1, 1, "ng-template", null, 13, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "app-local-entities", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function LocalRuleAccessModalComponent_Template_app_local_entities_onSelect_19_listener($event) { return ctx.selectUsers($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](20, LocalRuleAccessModalComponent_ng_template_20_Template, 4, 5, "ng-template", null, 14, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](22, "footer")(23, "sl-button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_23_listener() { return ctx.open = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](25, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](26, "sl-button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_26_listener() { return ctx.save(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](10);
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](18);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("open", ctx.open)("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 21, "_$.access.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 23, "_$.access.search"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("entitiesProvider", ctx.groupsProvider)("entityTemplate", _r2)("searchInput", _r1)("changes", ctx.groupChanges);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("entitiesProvider", ctx.usersProvider)("entityTemplate", _r4)("searchInput", _r1)("changes", ctx.userChanges);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](25, 25, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](28, 27, "$.apply"), " ");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AvatarComponent, _access_entities_local_entities_component__WEBPACK_IMPORTED_MODULE_1__.LocalEntitiesComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipe], styles: ["sl-dialog[_ngcontent-%COMP%] {\n  --width: 730px;\n  visibility: visible;\n}\n.search[_ngcontent-%COMP%] {\n  width: 266px;\n}\n.label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-large);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.ents[_ngcontent-%COMP%] {\n  min-height: 420px;\n  height: 100%;\n}\ncore-avatar[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-small);\n  margin-bottom: var(--sl-spacing-2x-small);\n}\nsl-checkbox[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(base) {\n  width: 100%;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(label) {\n  display: flex;\n  overflow: hidden;\n}\n.spinner-container[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], LocalRuleAccessModalComponent.prototype, "groupChanges", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], LocalRuleAccessModalComponent.prototype, "userChanges", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], LocalRuleAccessModalComponent.prototype, "loading", void 0);


/***/ }),

/***/ 1275:
/*!****************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-rules/local-rule-form/local-rule-form.component.ts ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleFormComponent": () => (/* binding */ LocalRuleFormComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _local_rules_modal_local_rules_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../local-rules-modal/local-rules-modal.component */ 4263);








function LocalRuleFormComponent_sl_input_6_Template(rf, ctx) { if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-input", 15, 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-input", function LocalRuleFormComponent_sl_input_6_Template_sl_input_sl_input_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r7.search(_r6.value)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](3, "sl-icon", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "ruleSearch"));
} }
function LocalRuleFormComponent_div_7_div_1_sl_badge_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-badge", 26)(1, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](3, "sl-icon", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const rule_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", rule_r10.users_count, " ");
} }
function LocalRuleFormComponent_div_7_div_1_sl_badge_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-badge")(1, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](3, "sl-icon", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const rule_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", rule_r10.groups_count, " ");
} }
function LocalRuleFormComponent_div_7_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 20)(1, "div", 21)(2, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleFormComponent_div_7_div_1_Template_div_click_2_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r16); const rule_r10 = restoredCtx.$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r3.show(rule_r10)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, LocalRuleFormComponent_div_7_div_1_sl_badge_4_Template, 4, 1, "sl-badge", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, LocalRuleFormComponent_div_7_div_1_sl_badge_5_Template, 4, 1, "sl-badge", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "sl-icon-button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleFormComponent_div_7_div_1_Template_sl_icon_button_click_6_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r16); const rule_r10 = restoredCtx.$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](16); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r4.show(rule_r10.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const rule_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", rule_r10.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", rule_r10.users_count);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", rule_r10.groups_count);
} }
function LocalRuleFormComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, LocalRuleFormComponent_div_7_div_1_Template, 7, 3, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r1.showedLocaleRules);
} }
function LocalRuleFormComponent_sl_button_12_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-button", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleFormComponent_sl_button_12_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r19); _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](20); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r5.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "deleteRules"), "");
} }
class LocalRuleFormComponent {
    constructor(datasetRuleApiService, notifyService, responseErrorService) {
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.isAddButtonDisabled = false;
        this.GlobalRule = _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule;
        this.localRules = [];
        this.showedLocaleRules = [];
    }
    set globalRule(value) {
        if (!value)
            return;
        this._globalRule = value;
        this.getRules();
    }
    get globalRule() {
        return this._globalRule;
    }
    get hasLocalRules() {
        var _a;
        return Boolean((_a = this.localRules) === null || _a === void 0 ? void 0 : _a.length);
    }
    deleteRule(ruleId) {
        this.datasetRuleApiService
            .deleteLocalRules(this.dataset.id, this.globalRule, [ruleId])
            .subscribe({
            next: () => {
                this.notifyService.toastByName('deleteRule');
                this.localRules = this.showedLocaleRules =
                    this.localRules.filter((rule) => rule.id !== ruleId);
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteLocalRuleError',
                });
            },
        });
    }
    deleteAllRules() {
        this.datasetRuleApiService
            .deleteLocalRules(this.dataset.id, this.globalRule, this.localRules.map((rule) => rule.id))
            .subscribe({
            next: () => {
                this.notifyService.toastByName('deleteRules');
                this.localRules = [];
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteLocalRulesError',
                });
            },
        });
    }
    search(value) {
        this.datasetRuleApiService
            .getLocalRules(this.dataset.id, this.globalRule, { search: value })
            .subscribe((resp) => {
            this.showedLocaleRules = resp.rows;
        });
    }
    update() {
        this.getRules();
    }
    getRules() {
        this.datasetRuleApiService
            .getLocalRules(this.dataset.id, this.globalRule)
            .subscribe((resp) => {
            this.localRules = this.showedLocaleRules = resp.rows;
        });
    }
}
LocalRuleFormComponent.ɵfac = function LocalRuleFormComponent_Factory(t) { return new (t || LocalRuleFormComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ResponseErrorService)); };
LocalRuleFormComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: LocalRuleFormComponent, selectors: [["app-local-rule-form"]], inputs: { isAddButtonDisabled: "isAddButtonDisabled", dataset: "dataset", globalRule: "globalRule" }, decls: 29, vars: 35, consts: [[1, "container"], [1, "local-rules-label", "bold"], [1, "simple", 3, "innerHTML"], ["class", "search", "clearable", "", 3, "placeholder", "sl-input", 4, "ngIf"], ["class", "locale-rules-menu", 4, "ngIf"], [1, "local-rule-actions"], ["variant", "text", 3, "disabled", "click"], ["variant", "text", 3, "click", 4, "ngIf"], [3, "dataset", "globalRule", "onSave"], ["localRuleModal", ""], [3, "title", "description", "buttonOkText", "ok"], ["confirmRuleRemove", ""], ["confirmAllRulesRemove", ""], ["variant", "success", "name", "deleteRule"], ["variant", "success", "name", "deleteRules"], ["clearable", "", 1, "search", 3, "placeholder", "sl-input"], ["searchInput", ""], ["name", "search", "slot", "suffix"], [1, "locale-rules-menu"], ["class", "locale-rule", 4, "ngFor", "ngForOf"], [1, "locale-rule"], [1, "locale-rule-information"], ["tooltipify", "", 1, "rule-button", 3, "click"], ["class", "badge-users", 4, "ngIf"], [4, "ngIf"], ["name", "x", 3, "click"], [1, "badge-users"], [1, "badge-count"], ["name", "person", 1, "badge-icon"], ["name", "people", 1, "badge-icon"], ["variant", "text", 3, "click"]], template: function LocalRuleFormComponent_Template(rf, ctx) { if (rf & 1) {
        const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0)(1, "label", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](4, "span", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, LocalRuleFormComponent_sl_input_6_Template, 4, 3, "sl-input", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](7, LocalRuleFormComponent_div_7_Template, 2, 1, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](8, "div", 5)(9, "sl-button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleFormComponent_Template_sl_button_click_9_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r20); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r3.show()); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](12, LocalRuleFormComponent_sl_button_12_Template, 3, 3, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](13, "app-local-rules-modal", 8, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSave", function LocalRuleFormComponent_Template_app_local_rules_modal_onSave_13_listener() { return ctx.update(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](15, "core-confirm", 10, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("ok", function LocalRuleFormComponent_Template_core_confirm_ok_15_listener($event) { return ctx.deleteRule($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "core-confirm", 10, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("ok", function LocalRuleFormComponent_Template_core_confirm_ok_19_listener() { return ctx.deleteAllRules(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](23, "core-notify", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](25, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](26, "core-notify", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 17, "localeRuleLabel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("innerHTML", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](5, 19, "localRuleSubtitle." + ctx.globalRule), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵsanitizeHtml"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.hasLocalRules && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.hasLocalRules && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("disabled", ctx.isAddButtonDisabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 21, "addRule"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.hasLocalRules && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("dataset", ctx.dataset)("globalRule", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](17, 23, "ruleRemoveTitle"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](18, 25, "ruleRemoveDescription"))("buttonOkText", "$.delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](21, 27, "allRulesRemoveTitle"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](22, 29, "allRulesRemoveDescription"))("buttonOkText", "$.delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](25, 31, "ruleDelete"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](28, 33, "rulesDelete"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TooltipifyDirective, _local_rules_modal_local_rules_modal_component__WEBPACK_IMPORTED_MODULE_1__.LocalRulesModalComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: [".container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  padding: var(--sl-spacing-large) var(--sl-spacing-medium);\n  position: relative;\n  border: 1px dashed var(--sl-color-primary-500);\n  border-radius: var(--sl-border-radius-medium);\n  width: 100%;\n}\n.bold[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  line-height: 30px;\n}\n.simple[_ngcontent-%COMP%] {\n  color: var(--sl-color-info-500);\n  font-weight: var(--sl-font-weight-normal);\n  line-height: 19px;\n  font-size: var(--sl-font-size-small);\n}\n.locale-rules-menu[_ngcontent-%COMP%] {\n  max-height: 220px;\n  overflow: auto;\n  width: 100%;\n}\n.local-rules-label[_ngcontent-%COMP%] {\n  background: var(--sl-color-neutral-0);\n  padding: 0 var(--sl-spacing-2x-small);\n  left: 16px;\n  position: absolute;\n  top: -16px;\n}\n.locale-rule[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  margin-bottom: 6px;\n  justify-content: space-between;\n}\n.locale-rule[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%]::part(base) {\n  padding-right: 0;\n  padding-left: 0;\n}\n.locale-rule-information[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  width: 100%;\n  overflow-x: hidden;\n}\n.locale-rule-information[_ngcontent-%COMP%]   sl-badge[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n}\n.locale-rule-information[_ngcontent-%COMP%]   sl-badge[_ngcontent-%COMP%]::part(base) {\n  background-color: var(--sl-color-neutral-100);\n  padding-left: var(--sl-spacing-2x-small);\n  padding-right: var(--sl-spacing-2x-small);\n  border: none;\n}\n.locale-rule-information[_ngcontent-%COMP%]   .badge-count[_ngcontent-%COMP%] {\n  color: var(--sl-color-primary-600);\n  margin-right: var(--sl-spacing-2x-small);\n}\n.locale-rule-information[_ngcontent-%COMP%]   .badge-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n}\n.rule-button[_ngcontent-%COMP%] {\n  height: 24px;\n  max-width: 100%;\n  padding: 0 15px;\n  line-height: 180%;\n  color: var(--sl-color-secondary-900);\n  font-weight: 400;\n  font-size: 13px;\n  border: 1px solid var(--sl-color-secondary-900);\n  border-radius: var(--sl-border-radius-small);\n  margin-right: var(--sl-spacing-x-small);\n}\n.rule-button[_ngcontent-%COMP%]:hover {\n  cursor: pointer;\n  background-color: var(--sl-color-neutral-50);\n}\n.local-rule-actions[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  margin-top: var(--sl-spacing-medium);\n  flex-wrap: wrap;\n}\n.local-rule-actions[_ngcontent-%COMP%]   sl-button[disabled][_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-action-500);\n  opacity: 1;\n}\n.search[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-small) 0;\n}\n.search[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  padding-right: var(--sl-spacing-small);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.Debounce)(300)
], LocalRuleFormComponent.prototype, "search", null);


/***/ }),

/***/ 4263:
/*!********************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-rules/local-rules-modal/local-rules-modal.component.ts ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRulesModalComponent": () => (/* binding */ LocalRulesModalComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../components/rule-access/rule-access.component */ 8034);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 3158);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs */ 5474);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! plmt-core-library/filters */ 6866);
/* harmony import */ var _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../components/modal-actions/modal-actions.component */ 4335);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! shoelace-style-angular */ 5219);













function LocalRulesModalComponent_div_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "ruleModal#entityAlreadyUsed"), " ");
} }
const _c0 = function () { return []; };
class LocalRulesModalComponent {
    constructor(appService, datasetRuleApiService, notifyService, formService, responseErrorService) {
        this.appService = appService;
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.formService = formService;
        this.responseErrorService = responseErrorService;
        this.usersProvider = (payload) => {
            var _a;
            const params = Object.assign(Object.assign({}, payload), { exclude_ids: [this.appService.user.value.id] });
            return this.datasetRuleApiService.getLocalRulesAvailableUsers(this.dataset.id, this.globalRule, ((_a = this.rule) === null || _a === void 0 ? void 0 : _a.id)
                ? Object.assign(Object.assign({}, params), { exclude_rule_id: this.rule.id, order_by: 'last_name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Asc }) : params);
        };
        this.groupsProvider = (params) => {
            var _a;
            return this.datasetRuleApiService.getLocalRulesAvailableGroups(this.dataset.id, this.globalRule, ((_a = this.rule) === null || _a === void 0 ? void 0 : _a.id)
                ? Object.assign(Object.assign({}, params), { exclude_rule_id: this.rule.id, order_by: 'name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Asc }) : params);
        };
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.isOpen = false;
        this.users = [];
        this.groups = [];
        this.errorUserIds = new Set();
        this.errorGroupIds = new Set();
        this.form = this.formService
            .create({
            id: [null],
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.stringValidator)({ min: 1, max: 250 })]],
            filters: new _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormControl([]),
        })
            .setup({
            method: (rules) => {
                return this.datasetRuleApiService
                    .saveLocaleRule(this.dataset.id, this.globalRule, Object.assign(Object.assign({}, rules), { users: this.users.map((item) => item.id), groups: this.groups.map((item) => item.id) }))
                    .pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_6__.catchError)((responseError) => {
                    var _a, _b, _c, _d;
                    let duplicateError = false;
                    if ((_b = (_a = responseError.error) === null || _a === void 0 ? void 0 : _a.errors) === null || _b === void 0 ? void 0 : _b.duplicate_user_ids) {
                        responseError.error.errors.duplicate_user_ids.forEach(this.errorUserIds.add, this.errorUserIds);
                        duplicateError = true;
                    }
                    if ((_d = (_c = responseError.error) === null || _c === void 0 ? void 0 : _c.errors) === null || _d === void 0 ? void 0 : _d.duplicate_group_ids) {
                        responseError.error.errors.duplicate_group_ids.forEach(this.errorGroupIds.add, this.errorGroupIds);
                        duplicateError = true;
                    }
                    if (duplicateError) {
                        this.formService.showServerErrors(this.form, responseError.error);
                        return responseError;
                    }
                    else {
                        return (0,rxjs__WEBPACK_IMPORTED_MODULE_7__.throwError)(() => responseError);
                    }
                }));
            },
            methodContext: this.datasetRuleApiService,
            success: () => {
                this.onSave.emit();
                this.isOpen = false;
                this.ruleAccess.ruleAccessModal.hide();
                this.notifyService.toastByName('noteRule');
            },
            error: (responseError) => {
                const key = this.rule
                    ? 'localRules.error.edit'
                    : 'localRules.error.create';
                this.responseErrorService.show.emit({
                    responseError: responseError,
                    key,
                });
            },
        });
    }
    onFiltersChange(filters) {
        this.form.patchValue({ filters });
    }
    show(rule) {
        this.form.reset();
        this.form.patchValue({
            name: '',
            filters: [],
            id: null,
        });
        this.rule = undefined;
        this.ruleAccess.state = _components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups;
        this.users = [];
        this.groups = [];
        this.errorUserIds.clear();
        this.errorGroupIds.clear();
        if (rule) {
            this.rule = rule;
            const filters = rule.filter_rule.filter((filter) => Object.keys(filter).length);
            this.form.patchValue({
                name: rule.name,
                filters,
                id: rule.id,
            });
            this.datasetRuleApiService
                .getLocalRule(this.dataset.id, this.globalRule, this.rule.id)
                .subscribe({
                next: (res) => {
                    this.users = res.users || [];
                    this.groups = res.groups || [];
                    this.isOpen = true;
                },
                error: (response) => {
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: 'localRules.error.show',
                    });
                },
            });
        }
        else {
            this.isOpen = true;
        }
    }
    removeUser(userId) {
        this.users = this.users.filter((user) => user.id !== userId);
        this.errorUserIds.delete(userId);
    }
    removeGroup(groupId) {
        this.groups = this.groups.filter((group) => group.id !== groupId);
        this.errorGroupIds.delete(groupId);
    }
    update(event) {
        this.users = event.users;
        this.groups = event.groups;
        this.ruleAccess.ruleAccessModal.hide();
    }
    saveNotification() {
        let state = this.rule ? 'edit' : 'created';
        return `ruleModalNotification.${state}`;
    }
}
LocalRulesModalComponent.ɵfac = function LocalRulesModalComponent_Factory(t) { return new (t || LocalRulesModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_1__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService)); };
LocalRulesModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: LocalRulesModalComponent, selectors: [["app-local-rules-modal"]], viewQuery: function LocalRulesModalComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵviewQuery"](_components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵloadQuery"]()) && (ctx.ruleAccess = _t.first);
    } }, inputs: { dataset: "dataset", globalRule: "globalRule" }, outputs: { onSave: "onSave" }, decls: 18, vars: 26, consts: [[3, "data"], [3, "label", "open", "openChange"], ["name", "name", 3, "label"], [1, "filter"], [1, "bold"], [3, "dataset", "value", "change"], [3, "users", "groups", "errorUserIds", "errorGroupIds", "usersProvider", "groupsProvider", "dataset", "globalRule", "removeUser", "removeGroup", "update"], ["ruleAccess", ""], ["class", "error", 4, "ngIf"], ["slot", "footer", "okTitle", "$.save", 3, "onCancel"], ["variant", "success", "name", "noteRule"], [1, "error"]], template: function LocalRulesModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "core-form", 0)(1, "sl-dialog", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("openChange", function LocalRulesModalComponent_Template_sl_dialog_openChange_1_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](4, "sl-input", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "div", 3)(7, "span", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "core-filters", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("change", function LocalRulesModalComponent_Template_core_filters_change_10_listener($event) { return ctx.onFiltersChange($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "app-rule-access", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("removeUser", function LocalRulesModalComponent_Template_app_rule_access_removeUser_11_listener($event) { return ctx.removeUser($event); })("removeGroup", function LocalRulesModalComponent_Template_app_rule_access_removeGroup_11_listener($event) { return ctx.removeGroup($event); })("update", function LocalRulesModalComponent_Template_app_rule_access_update_11_listener($event) { return ctx.update($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](13, LocalRulesModalComponent_div_13_Template, 3, 3, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](14, "app-modal-actions", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onCancel", function LocalRulesModalComponent_Template_app_modal_actions_onCancel_14_listener() { return ctx.isOpen = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "core-notify", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        let tmp_6_0;
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 17, "ruleModalLabel"))("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 19, "ruleModalName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](9, 21, "ruleModalFilters"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("dataset", ctx.dataset)("value", ((tmp_6_0 = ctx.form.get("filters")) == null ? null : tmp_6_0.value) || _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](25, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("users", ctx.users)("groups", ctx.groups)("errorUserIds", ctx.errorUserIds)("errorGroupIds", ctx.errorGroupIds)("usersProvider", ctx.usersProvider)("groupsProvider", ctx.groupsProvider)("dataset", ctx.dataset)("globalRule", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.errorGroupIds.size || ctx.errorUserIds.size);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](17, 23, ctx.saveNotification()), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ValidateComponent, plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_9__.FiltersComponent, _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_2__.ModalActionsComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, _components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe], styles: ["sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  max-height: 702px;\n}\n.filter[_ngcontent-%COMP%] {\n  margin: 25px 0;\n}\n.bold[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  line-height: 29px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvY2FsLXJ1bGVzLW1vZGFsLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksaUJBQUE7QUFDSjtBQUVBO0VBQ0ksY0FBQTtBQUFKO0FBRUE7RUFDSSxvQ0FBQTtFQUNBLG9DQUFBO0VBQ0EsdUNBQUE7RUFDQSxpQkFBQTtBQUFKIiwiZmlsZSI6ImxvY2FsLXJ1bGVzLW1vZGFsLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsic2wtZGlhbG9nOjpwYXJ0KHBhbmVsKSB7XG4gICAgbWF4LWhlaWdodDogNzAycHg7XG59XG5cbi5maWx0ZXIge1xuICAgIG1hcmdpbjogMjVweCAwO1xufVxuLmJvbGQge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3Itc2Vjb25kYXJ5LTkwMCk7XG4gICAgZm9udC13ZWlnaHQ6IHZhcigtLXNsLWZvbnQtd2VpZ2h0LWJvbGQpO1xuICAgIGxpbmUtaGVpZ2h0OiAyOXB4O1xufVxuIl19 */"] });


/***/ }),

/***/ 6934:
/*!********************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-rules/local-rules.component.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChangedGlobalRuleEntities": () => (/* binding */ ChangedGlobalRuleEntities),
/* harmony export */   "LocalRulesComponent": () => (/* binding */ LocalRulesComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ts-enum-to-array */ 141);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./local-rule-form/local-rule-form.component */ 1275);
/* harmony import */ var _local_access_module_rule_access_local_rule_access_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../local-access-module/rule-access/local-rule-access.component */ 7150);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);













const _c0 = ["globalRuleSelect"];
function LocalRulesComponent_sl_menu_item_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-menu-item", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const rule_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("value", rule_r3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 2, "rule." + rule_r3), "");
} }
function LocalRulesComponent_div_13_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 13)(1, "app-local-rule-access", 14, 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("removedUser", function LocalRulesComponent_div_13_Template_app_local_rule_access_removedUser_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r5.removeUser()); })("removedGroup", function LocalRulesComponent_div_13_Template_app_local_rule_access_removedGroup_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r7.removeGroup()); })("update", function LocalRulesComponent_div_13_Template_app_local_rule_access_update_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r8.update($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("groupsProvider", ctx_r2.groupsProvider)("usersProvider", ctx_r2.usersProvider)("dataset", ctx_r2.dataset)("globalRule", ctx_r2.globalRule);
} }
var ChangedGlobalRuleEntities;
(function (ChangedGlobalRuleEntities) {
    ChangedGlobalRuleEntities[ChangedGlobalRuleEntities["Groups"] = 0] = "Groups";
    ChangedGlobalRuleEntities[ChangedGlobalRuleEntities["Users"] = 1] = "Users";
    ChangedGlobalRuleEntities[ChangedGlobalRuleEntities["GroupsAndUsers"] = 2] = "GroupsAndUsers";
})(ChangedGlobalRuleEntities || (ChangedGlobalRuleEntities = {}));
class LocalRulesComponent {
    constructor(datasetRuleApiService, notifyService, responseErrorService, appService) {
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.appService = appService;
        this.groupsProvider = (params) => this.datasetRuleApiService.getGlobalRulesGroups(this.dataset.id, this.globalRule, Object.assign({ order_by: 'name', include_not_selected: true, order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SortDirection.Asc }, params));
        this.usersProvider = (params) => this.datasetRuleApiService.getGlobalRulesUsers(this.dataset.id, this.globalRule, Object.assign({ order_by: 'last_name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SortDirection.Asc, include_not_selected: true, exclude_ids: [this.appService.user.value.id] }, params));
        this.GlobalRule = _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule;
        this.rulesArray = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_1__.enumToArray)(_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule);
        this.changedEntity = ChangedGlobalRuleEntities.Groups;
    }
    get isAddButtonDisabled() {
        if (this.globalRule === _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.RestrictAll)
            return true;
        if (this.globalRule === _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.AllowAll ||
            this.globalRule === _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.RestrictSelect)
            return false;
        if (!this.ruleAccess)
            return true;
        return !this.ruleAccess.users.length && !this.ruleAccess.groups.length;
    }
    ngOnInit() {
        this.globalRule = this.dataset.data_access_restriction;
    }
    changeRule(event) {
        if ((0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.valueOf)(event) === this.globalRule)
            return;
        const params = {
            data_access_restriction: (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.valueOf)(event),
        };
        this.updateGlobalRule(params);
    }
    updateGlobalRule(params, refresh = false) {
        this.setChangedEntities(params);
        this.datasetRuleApiService
            .saveGlobalRule(this.dataset.id, params)
            .subscribe({
            next: () => {
                this.globalRule = params.data_access_restriction;
                if (refresh) {
                    this.ruleAccess.refresh();
                    this.notifyService.toastByName('changeRuleList');
                }
                else {
                    this.notifyService.toastByName('changeRule');
                }
            },
            error: (error) => {
                const key = refresh
                    ? 'changeGlobalRuleListError.' + this.changedEntity
                    : 'changeGlobalRuleError';
                this.globalRuleSelect.nativeElement.value = this.globalRule;
                this.responseErrorService.show.emit({
                    responseError: error,
                    key,
                });
            },
        });
    }
    removeUser() {
        this.localeRuleForm.getRules();
    }
    removeGroup() {
        this.localeRuleForm.getRules();
    }
    update(payload) {
        const params = Object.assign({ data_access_restriction: this.globalRule }, payload);
        this.updateGlobalRule(params, true);
        this.ruleAccess.ruleAccessModal.hide();
    }
    setChangedEntities(params) {
        var _a, _b, _c, _d;
        const isGroupsChanged = Boolean(((_a = params.add_groups) === null || _a === void 0 ? void 0 : _a.length) || ((_b = params.remove_groups) === null || _b === void 0 ? void 0 : _b.length));
        const isUsersChanged = Boolean(((_c = params.add_users) === null || _c === void 0 ? void 0 : _c.length) || ((_d = params.remove_users) === null || _d === void 0 ? void 0 : _d.length));
        if (isGroupsChanged && isUsersChanged) {
            this.changedEntity = ChangedGlobalRuleEntities.GroupsAndUsers;
            return;
        }
        if (isGroupsChanged) {
            this.changedEntity = ChangedGlobalRuleEntities.Groups;
            return;
        }
        this.changedEntity = ChangedGlobalRuleEntities.Users;
    }
}
LocalRulesComponent.ɵfac = function LocalRulesComponent_Factory(t) { return new (t || LocalRulesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AppService)); };
LocalRulesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: LocalRulesComponent, selectors: [["app-local-rules"]], viewQuery: function LocalRulesComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_local_access_module_rule_access_local_rule_access_component__WEBPACK_IMPORTED_MODULE_3__.LocalRuleAccessComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_2__.LocalRuleFormComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.globalRuleSelect = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.ruleAccess = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.localeRuleForm = _t.first);
    } }, inputs: { dataset: "dataset" }, decls: 21, vars: 18, consts: [[1, "grid"], [1, "global-rules"], [1, "label"], [1, "bold"], [1, "simple"], ["hoist", "", 3, "value", "sl-select"], ["globalRuleSelect", ""], [3, "value", 4, "ngFor", "ngForOf"], ["class", "access", 4, "ngIf"], [3, "isAddButtonDisabled", "dataset", "globalRule"], ["variant", "success", "name", "changeRule"], ["variant", "success", "name", "changeRuleList"], [3, "value"], [1, "access"], [3, "groupsProvider", "usersProvider", "dataset", "globalRule", "removedUser", "removedGroup", "update"], ["ruleAccess", ""]], template: function LocalRulesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "div", 2)(3, "span", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](6, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](10, "sl-select", 5, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("sl-select", function LocalRulesComponent_Template_sl_select_sl_select_10_listener($event) { return ctx.changeRule($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](12, LocalRulesComponent_sl_menu_item_12_Template, 3, 4, "sl-menu-item", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, LocalRulesComponent_div_13_Template, 3, 4, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](14, "app-local-rule-form", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "core-notify", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "core-notify", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](5, 10, "ruleLabel"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 12, "ruleSubtitle." + ctx.globalRule), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("value", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx.rulesArray);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.globalRule !== ctx.GlobalRule.AllowAll && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("isAddButtonDisabled", ctx.isAddButtonDisabled)("dataset", ctx.dataset)("globalRule", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](17, 14, "changeGlobalRuleNotification"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](20, 16, "changeGlobalRuleListNotification." + ctx.changedEntity), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _local_access_module_rule_access_local_rule_access_component__WEBPACK_IMPORTED_MODULE_3__.LocalRuleAccessComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyComponent, _local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_2__.LocalRuleFormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: [".grid[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: 60% 30%;\n  grid-column-gap: calc(2 * var(--sl-spacing-small));\n}\n.bold[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  line-height: 30px;\n  font-size: var(--sl-font-size-small);\n}\n.simple[_ngcontent-%COMP%] {\n  color: var(--sl-color-info-500);\n  font-weight: var(--sl-font-weight-normal);\n  line-height: 14px;\n  font-size: var(--sl-font-size-small);\n}\n.label[_ngcontent-%COMP%] {\n  margin-bottom: calc(2 * var(--sl-spacing-small));\n}\nsl-select[_ngcontent-%COMP%] {\n  margin-bottom: calc(2 * var(--sl-spacing-small));\n}\nsl-select[_ngcontent-%COMP%]::part(base) {\n  width: 250px;\n}\n.access[_ngcontent-%COMP%] {\n  background-color: var(--sl-color-border-and-bg-50);\n  padding: var(--sl-spacing-medium);\n  border-radius: 4px;\n}\nsl-badge[_ngcontent-%COMP%] {\n  margin: 0 4px;\n}\nsl-badge[_ngcontent-%COMP%]::part(base) {\n  height: 20px;\n  min-width: 30px;\n  background-color: var(--sl-color-neutral-100);\n}\nsl-badge[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: 12px;\n  font-weight: var(--sl-font-weight-normal);\n  color: var(--sl-color-primary-600);\n}\nsl-badge[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: 9px;\n  color: var(--sl-color-secondary-900);\n  margin-left: 5px;\n}\nsl-button[disabled][_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-action-500);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalRulesComponent.prototype, "globalRule", void 0);


/***/ }),

/***/ 1992:
/*!***********************************************!*\
  !*** ./src/app/pipes/decline-numeral-word.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeclineWordPipe": () => (/* binding */ DeclineWordPipe),
/* harmony export */   "DeclineWordPipeModule": () => (/* binding */ DeclineWordPipeModule),
/* harmony export */   "WordEnding": () => (/* binding */ WordEnding)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);


var WordEnding;
(function (WordEnding) {
    WordEnding[WordEnding["One"] = 0] = "One";
    WordEnding[WordEnding["Few"] = 1] = "Few";
    WordEnding[WordEnding["Many"] = 2] = "Many";
})(WordEnding || (WordEnding = {}));
class DeclineWordPipe {
    constructor(translateService) {
        this.translateService = translateService;
    }
    transform(number) {
        number = Math.abs(number) % 100;
        const num = number % 10;
        if (number > 10 && number < 20)
            return WordEnding.Many;
        if (num > 1 && num < 5)
            return WordEnding.Few;
        if (num == 1)
            return WordEnding.One;
        return WordEnding.Many;
    }
}
DeclineWordPipe.ɵfac = function DeclineWordPipe_Factory(t) { return new (t || DeclineWordPipe)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.TranslateService, 16)); };
DeclineWordPipe.ɵpipe = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefinePipe"]({ name: "declineWord", type: DeclineWordPipe, pure: false });
class DeclineWordPipeModule {
}
DeclineWordPipeModule.ɵfac = function DeclineWordPipeModule_Factory(t) { return new (t || DeclineWordPipeModule)(); };
DeclineWordPipeModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({ type: DeclineWordPipeModule });
DeclineWordPipeModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({});
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](DeclineWordPipeModule, { declarations: [DeclineWordPipe], exports: [DeclineWordPipe] }); })();


/***/ })

}]);
//# sourceMappingURL=default-src_app_api_data-api_service_ts-src_app_enums_dataset_ts-src_app_enums_update-dataset-14c649.js.map