"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_pages_projects_projects_module_ts"],{

/***/ 86680:
/*!*******************************************************************************!*\
  !*** ./src/app/components/project-copy-modal/project-copy-modal.component.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectCopyModalComponent": () => (/* binding */ ProjectCopyModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_api_project_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/api/project-api.service */ 37444);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 39652);








class ProjectCopyModalComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__.SubscribableComponent {
    constructor(notifyService, projectApiService, responseErrorService) {
        super();
        this.notifyService = notifyService;
        this.projectApiService = projectApiService;
        this.responseErrorService = responseErrorService;
        this.onCopied = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.showModal = false;
        this.isLoading = false;
        this.projectId = null;
    }
    open(project) {
        this.showModal = true;
        this.projectId = project.id;
    }
    cancel() {
        this.showModal = false;
    }
    copy() {
        this.isLoading = true;
        this.subscriptions.push(this.projectApiService.copy(this.projectId).subscribe({
            next: () => {
                this.notifyService.toastByName('successInfo');
                this.onCopied.emit();
                this.finalizeAction();
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'copyModal#errorInfo',
                });
                this.finalizeAction();
            },
        }));
    }
    finalizeAction() {
        this.isLoading = false;
        this.showModal = false;
    }
}
ProjectCopyModalComponent.ɵfac = function ProjectCopyModalComponent_Factory(t) { return new (t || ProjectCopyModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](project_api_project_api_service__WEBPACK_IMPORTED_MODULE_0__.ProjectApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ResponseErrorService)); };
ProjectCopyModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: ProjectCopyModalComponent, selectors: [["app-project-copy-modal"]], outputs: { onCopied: "onCopied" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"]], decls: 15, vars: 19, consts: [[3, "label", "open", "openChange"], ["slot", "footer", 1, "footer"], ["variant", "default", 3, "disabled", "click"], ["variant", "primary", 3, "disabled", "loading", "click"], ["variant", "success", "name", "successInfo"]], template: function ProjectCopyModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function ProjectCopyModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.showModal = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "div", 1)(6, "sl-button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function ProjectCopyModalComponent_Template_sl_button_click_6_listener() { return ctx.cancel(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](8, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function ProjectCopyModalComponent_Template_sl_button_click_9_listener() { return ctx.copy(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "core-notify", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 9, "copyModal#label"))("open", ctx.showModal);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](4, 11, "copyModal#question"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("disabled", ctx.isLoading);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](8, 13, "copyModal#cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("disabled", ctx.isLoading)("loading", ctx.isLoading);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 15, "copyModal#copy"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](14, 17, "copyModal#successInfo"), "\n");
    } }, dependencies: [shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: [".footer[_ngcontent-%COMP%] {\n  display: flex;\n  gap: var(--sl-spacing-small);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByb2plY3QtY29weS1tb2RhbC5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSw0QkFBQTtBQUNKIiwiZmlsZSI6InByb2plY3QtY29weS1tb2RhbC5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5mb290ZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZ2FwOiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], ProjectCopyModalComponent.prototype, "showModal", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], ProjectCopyModalComponent.prototype, "isLoading", void 0);


/***/ }),

/***/ 5157:
/*!****************************************************************************!*\
  !*** ./src/app/components/project-copy-modal/project-copy-modal.module.ts ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectCopyModalModule": () => (/* binding */ ProjectCopyModalModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _project_copy_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./project-copy-modal.component */ 86680);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);





class ProjectCopyModalModule {
}
ProjectCopyModalModule.ɵfac = function ProjectCopyModalModule_Factory(t) { return new (t || ProjectCopyModalModule)(); };
ProjectCopyModalModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: ProjectCopyModalModule });
ProjectCopyModalModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](ProjectCopyModalModule, { declarations: [_project_copy_modal_component__WEBPACK_IMPORTED_MODULE_0__.ProjectCopyModalComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule], exports: [_project_copy_modal_component__WEBPACK_IMPORTED_MODULE_0__.ProjectCopyModalComponent] }); })();


/***/ }),

/***/ 66788:
/*!******************************************************!*\
  !*** ./src/app/pages/projects/projects.component.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectsComponent": () => (/* binding */ ProjectsComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_enums_module_rights__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/enums/module-rights */ 24475);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var project_api_project_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/api/project-api.service */ 37444);
/* harmony import */ var project_services_server_response_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/services/server-response.service */ 22429);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ng-track-by */ 61245);
/* harmony import */ var project_components_project_modal_project_modal_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/components/project-modal/project-modal.component */ 97654);
/* harmony import */ var _components_project_copy_modal_project_copy_modal_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/project-copy-modal/project-copy-modal.component */ 86680);
/* harmony import */ var project_pages_projects_select_select_item_directive__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! project/pages/projects/select/select-item.directive */ 80737);
/* harmony import */ var project_pages_projects_select_select_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! project/pages/projects/select/select.component */ 25316);
/* harmony import */ var project_pages_projects_tiles_view_tiles_view_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! project/pages/projects/tiles-view/tiles-view.component */ 56146);

















function ProjectsComponent_ng_container_5_projects_select_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](3, "core-sort-indicator", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 2, "sort.byDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("direction", ctx_r14.SortDirection.Asc);
} }
function ProjectsComponent_ng_container_5_projects_select_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](3, "core-sort-indicator", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 2, "sort.byDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("direction", ctx_r15.SortDirection.Desc);
} }
function ProjectsComponent_ng_container_5_projects_select_1_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](3, "core-sort-indicator", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 2, "sort.asc"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("direction", ctx_r16.SortDirection.Asc);
} }
function ProjectsComponent_ng_container_5_projects_select_1_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](3, "core-sort-indicator", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 2, "sort.desc"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("direction", ctx_r17.SortDirection.Desc);
} }
function ProjectsComponent_ng_container_5_projects_select_1_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "projects-select", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function ProjectsComponent_ng_container_5_projects_select_1_Template_projects_select_change_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r18.changeOrder($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](1, ProjectsComponent_ng_container_5_projects_select_1_ng_container_1_Template, 4, 4, "ng-container", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](2, ProjectsComponent_ng_container_5_projects_select_1_ng_container_2_Template, 4, 4, "ng-container", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](3, ProjectsComponent_ng_container_5_projects_select_1_ng_container_3_Template, 4, 4, "ng-container", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](4, ProjectsComponent_ng_container_5_projects_select_1_ng_container_4_Template, 4, 4, "ng-container", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("reset", false)("value", ctx_r12.sortBy);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("selectItemFor", ctx_r12.SortBy.DateAsc);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("selectItemFor", ctx_r12.SortBy.DateDesc);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("selectItemFor", ctx_r12.SortBy.NameAsc);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("selectItemFor", ctx_r12.SortBy.NameDesc);
} }
function ProjectsComponent_ng_container_5_sl_button_7_Template(rf, ctx) { if (rf & 1) {
    const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "sl-button", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_ng_container_5_sl_button_7_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r21); const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](22); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](_r10.show(ctx_r20.checkRows)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate2"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 2, "$.delete"), " ", ctx_r13.checkRows.length, " ");
} }
function ProjectsComponent_ng_container_5_Template(rf, ctx) { if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](1, ProjectsComponent_ng_container_5_projects_select_1_Template, 5, 6, "projects-select", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](2, "sl-button-group")(3, "sl-button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_ng_container_5_Template_sl_button_click_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r23); const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r22.setViewType(ctx_r22.ProjectsViewType.Tiles)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](4, "sl-icon", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](5, "sl-button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_ng_container_5_Template_sl_button_click_5_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r23); const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r24.setViewType(ctx_r24.ProjectsViewType.Table)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](6, "sl-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](7, ProjectsComponent_ng_container_5_sl_button_7_Template, 3, 4, "sl-button", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r0.viewType === ctx_r0.ProjectsViewType.Tiles);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("variant", ctx_r0.buttonTypeFor(ctx_r0.ProjectsViewType.Tiles));
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("variant", ctx_r0.buttonTypeFor(ctx_r0.ProjectsViewType.Table));
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r0.checkRows.length);
} }
function ProjectsComponent_core_table_filter_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "core-table-filter", 29);
} }
function ProjectsComponent_sl_button_7_Template(rf, ctx) { if (rf & 1) {
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "sl-button", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_sl_button_7_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r26); _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](_r7.open()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](3, "sl-icon", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 1, "addButton"), " ");
} }
function ProjectsComponent_app_tiles_view_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "app-tiles-view", 32);
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](14);
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](16);
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("projects", ctx_r3.projects)("users", ctx_r3.users)("projectsTotal", ctx_r3.projectsTotal)("projectModal", _r7)("projectCopyModal", _r8)("deleteConfirm", _r9);
} }
function ProjectsComponent_core_table_10_tr_28_core_table_checkbox_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "core-table-checkbox", 49);
} if (rf & 2) {
    const project_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("value", project_r28);
} }
function ProjectsComponent_core_table_10_tr_28_ng_container_19_Template(rf, ctx) { if (rf & 1) {
    const _r35 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](1, "core-action", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_core_table_10_tr_28_ng_container_19_Template_core_action_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r35); const project_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](16); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](_r8.open(project_r28)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](2, "core-action", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_core_table_10_tr_28_ng_container_19_Template_core_action_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r35); const project_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](_r7.open(project_r28)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
} }
function ProjectsComponent_core_table_10_tr_28_core_action_20_Template(rf, ctx) { if (rf & 1) {
    const _r40 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "core-action", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ProjectsComponent_core_table_10_tr_28_core_action_20_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r40); const project_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2); const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](18); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](_r9.show(project_r28.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} }
const _c0 = function (a0) { return [a0]; };
function ProjectsComponent_core_table_10_tr_28_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "tr", 41)(1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](2, ProjectsComponent_core_table_10_tr_28_core_table_checkbox_2_Template, 1, 1, "core-table-checkbox", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](3, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](4, "sl-icon", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](5, "td", 45)(6, "a", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](8, "td", 45)(9, "a", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](11, "td", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](12);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](13, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](14, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](15, "core-relative-time", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](16, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](17, "core-relative-time", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](18, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](19, ProjectsComponent_core_table_10_tr_28_ng_container_19_Template, 3, 0, "ng-container", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](20, ProjectsComponent_core_table_10_tr_28_core_action_20_Template, 1, 0, "core-action", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const project_r28 = ctx.$implicit;
    const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("hidden", ctx_r27.isHideCheckboxController());
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", project_r28.access_right === ctx_r27.AccessRight.Full);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("name", project_r28.icon);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpureFunction1"](17, _c0, project_r28.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", project_r28.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpureFunction1"](19, _c0, project_r28.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", project_r28.description, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](13, 15, ctx_r27.users[project_r28.owner_id]), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("date", project_r28.create_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("date", project_r28.update_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("hidden", ctx_r27.isShowActions());
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", project_r28.access_right !== ctx_r27.AccessRight.Read);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", project_r28.access_right === ctx_r27.AccessRight.Full);
} }
function ProjectsComponent_core_table_10_Template(rf, ctx) { if (rf & 1) {
    const _r42 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "core-table", 33)(1, "thead")(2, "tr")(3, "th")(4, "core-table-checkbox-controller", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function ProjectsComponent_core_table_10_Template_core_table_checkbox_controller_change_4_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r42); const ctx_r41 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r41.checkRows = $event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](5, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](6, "th", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](9, "core-table-sort", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](10, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](13, "th", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](15, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](16, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](18, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](19, "core-table-sort", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](20, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](23, "core-table-sort", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](24, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](25);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](26, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](27, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](28, ProjectsComponent_core_table_10_tr_28_Template, 21, 21, "tr", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("total", ctx_r4.projectsTotal);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("hidden", ctx_r4.isHideCheckboxController());
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](8, 12, "th.name"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](12, 14, "th.description"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](15, 16, "th.owner"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](18, 18, "$.createDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](22, 20, "$.updateDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("hidden", ctx_r4.isShowActions());
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](26, 22, "$.actions"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngForOf", ctx_r4.projects);
} }
function ProjectsComponent_core_empty_state_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "core-empty-state", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](1, 2, ctx_r5.EmptyStateTitle))("description", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 4, ctx_r5.EmptyStateDescription));
} }
function ProjectsComponent_core_error_state_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "core-error-state", 54);
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("code", ctx_r6.responseServerError);
} }
function ProjectsComponent_p_24_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} if (rf & 2) {
    const project_r43 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate"](project_r43.name);
} }
var ProjectsViewType;
(function (ProjectsViewType) {
    ProjectsViewType[ProjectsViewType["Tiles"] = 0] = "Tiles";
    ProjectsViewType[ProjectsViewType["Table"] = 1] = "Table";
})(ProjectsViewType || (ProjectsViewType = {}));
var Filter;
(function (Filter) {
    Filter["All"] = "all";
    Filter["My"] = "my";
})(Filter || (Filter = {}));
var SortBy;
(function (SortBy) {
    SortBy["DateAsc"] = "date-asc";
    SortBy["DateDesc"] = "date-desc";
    SortBy["NameAsc"] = "name-asc";
    SortBy["NameDesc"] = "name-desc";
    SortBy["NotSorted"] = "";
})(SortBy || (SortBy = {}));
const date = 'create_date';
const name = 'name';
class ProjectsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_9__.SubscribableComponent {
    constructor(accessRightsService, activatedRoute, pageService, appService, projectApiService, notifyService, responseErrorService, router, serverResponseService) {
        super();
        this.accessRightsService = accessRightsService;
        this.activatedRoute = activatedRoute;
        this.pageService = pageService;
        this.appService = appService;
        this.projectApiService = projectApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.router = router;
        this.serverResponseService = serverResponseService;
        this.ProjectsViewType = ProjectsViewType;
        this.Filter = Filter;
        this.SortBy = SortBy;
        this.SortDirection = plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection;
        this.ModuleRights = project_enums_module_rights__WEBPACK_IMPORTED_MODULE_0__.ModuleRights;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.AccessRight;
        this.onlySelf = false;
        this.projects = [];
        this.users = [];
        this.checkRows = [];
        this.projectsTotal = 0;
        this.projectsEmpty = false;
        this.viewType = ProjectsViewType.Tiles;
        this.sortBy = SortBy.DateDesc;
        this.responseServerError = null;
    }
    get EmptyStateTitle() {
        return this.isSearch ? 'emptyStateFilter.title' : 'emptyState.title';
    }
    get EmptyStateDescription() {
        return this.isSearch ? '' : 'emptyState.description';
    }
    get isSearch() {
        return this.activatedRoute.snapshot.queryParams.search;
    }
    ngOnInit() {
        this.applyDefaultSort();
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe(() => {
                this.checkOnlySelf();
                this.setSortBy();
                this.load();
            }),
        ];
    }
    checkOnlySelf() {
        const currentUserId = this.appService.user.value.id;
        const params = this.activatedRoute.snapshot.queryParams;
        if (Array.isArray(params.owners) &&
            params.owners.length === 1 &&
            params.owners.includes(currentUserId)) {
            this.onlySelf = true;
            return;
        }
        if (+params.owners === currentUserId) {
            this.onlySelf = true;
            return;
        }
        this.onlySelf = false;
    }
    changeOnlySelf(event) {
        this.onlySelf = event.target.checked;
        this.router.navigate([], {
            queryParams: {
                ...this.activatedRoute.snapshot.queryParams,
                owners: this.onlySelf ? [this.appService.user.value.id] : null,
                offset: null,
            },
        });
    }
    buttonTypeFor(viewType) {
        return this.viewType === viewType ? 'primary' : 'default';
    }
    changeOrder(value) {
        switch (value) {
            case SortBy.DateAsc:
                this.mergeQueryParams({
                    order_by: date,
                    order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Asc,
                });
                break;
            case SortBy.DateDesc:
                this.mergeQueryParams({
                    order_by: date,
                    order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Desc,
                });
                break;
            case SortBy.NameAsc:
                this.mergeQueryParams({
                    order_by: name,
                    order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Asc,
                });
                break;
            case SortBy.NameDesc:
                this.mergeQueryParams({
                    order_by: name,
                    order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Desc,
                });
                break;
            default:
                this.mergeQueryParams({
                    order_by: null,
                    order_direction: null,
                });
        }
    }
    onProjectCreate() {
        this.load();
    }
    onProjectCopied() {
        this.load();
    }
    onProjectUpdate(project) {
        const i = this.projects.findIndex(({ id }) => id === project.id);
        if (i !== -1) {
            this.projects[i] = project;
        }
        this.load();
    }
    deleteProject(id) {
        this.projectApiService.delete(id).subscribe({
            next: () => {
                this.load();
                this.notifyService.toastByName('deleteProjectNote');
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'modalProject#notification.remove.error',
                });
            },
        });
    }
    deleteChecked(project) {
        this.projectApiService
            .deleteList(project.map((item) => item.id))
            .subscribe({
            next: () => {
                this.checkRows = [];
                this.load();
                if (project.length === 1) {
                    this.notifyService.toastByName('deleteProjectNote');
                }
                else {
                    this.notifyService.toastByName('deleteProjectsNote');
                }
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: this.getKey(project.length),
                });
            },
        });
    }
    setViewType(value) {
        if (this.viewType === value)
            return;
        this.applyDefaultSort();
        if (this.viewType === ProjectsViewType.Tiles) {
            this.viewType = ProjectsViewType.Table;
        }
        else {
            this.viewType = ProjectsViewType.Tiles;
            this.checkRows = [];
        }
    }
    isHideCheckboxController() {
        return this.projects.every((project) => project.access_right !== plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.AccessRight.Full);
    }
    isShowActions() {
        return !this.projects.some((project) => project.access_right !== plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.AccessRight.Read);
    }
    applyDefaultSort() {
        this.mergeQueryParams({
            order_by: date,
            order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Desc,
        });
        this.sortBy = SortBy.DateDesc;
    }
    load() {
        this.pageService.loading = true;
        const query = {
            ...this.activatedRoute.snapshot.queryParams,
        };
        this.projectApiService
            .list(query)
            .subscribe({
            next: ({ rows, total, users }) => {
                this.projects = rows;
                this.users = users;
                this.projectsTotal = total;
                this.projectsEmpty = total === 0;
                this.responseServerError = null;
                this.pageService.loading = false;
            },
            error: (response) => {
                this.responseServerError = this.serverResponseService.getHttpErrorCodeOrNotify(response);
                this.pageService.loading = false;
            }
        });
    }
    mergeQueryParams(queryParams) {
        this.router.navigate([], { queryParams, queryParamsHandling: 'merge' });
    }
    setSortBy() {
        const { order_by, order_direction } = this.activatedRoute.snapshot
            .queryParams;
        switch (true) {
            case order_by === date && order_direction === plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Asc:
                this.sortBy = SortBy.DateAsc;
                break;
            case order_by === date && order_direction === plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Desc:
                this.sortBy = SortBy.DateDesc;
                break;
            case order_by === name && order_direction === plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Asc:
                this.sortBy = SortBy.NameAsc;
                break;
            case order_by === name && order_direction === plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortDirection.Desc:
                this.sortBy = SortBy.NameDesc;
                break;
            default:
                this.sortBy = SortBy.DateDesc;
        }
    }
    getKey(length) {
        let key = 'modalProject#notification.remove.';
        key += length === 1 ? 'error' : 'errorProjects';
        return key;
    }
}
ProjectsComponent.ɵfac = function ProjectsComponent_Factory(t) { return new (t || ProjectsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.AccessRightsService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_11__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.PageService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](project_api_project_api_service__WEBPACK_IMPORTED_MODULE_1__.ProjectApiService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_11__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](project_services_server_response_service__WEBPACK_IMPORTED_MODULE_2__.ServerResponseService)); };
ProjectsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineComponent"]({ type: ProjectsComponent, selectors: [["app-projects"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵInheritDefinitionFeature"]], decls: 31, vars: 31, consts: [[3, "title", "counter"], [3, "checked", "sl-change"], [4, "ngIf"], ["class", "adaptive-view", 4, "ngIf"], ["variant", "primary", "class", "add-button", 3, "click", 4, "accessRights"], [3, "projects", "users", "projectsTotal", "projectModal", "projectCopyModal", "deleteConfirm", 4, "ngIf"], [3, "total", 4, "ngIf"], ["imageSrc", "./assets/images/project-es.svg", 3, "title", "description", 4, "ngIf"], [3, "code", 4, "ngIf"], [3, "onCreate", "onUpdate"], ["projectModal", ""], [3, "onCopied"], ["projectCopyModal", ""], [3, "title", "description", "ok"], ["deleteConfirm", ""], [3, "title", "ok"], ["deleteCheckedConfirm", ""], [4, "ngFor", "ngForOf"], ["name", "deleteProjectNote"], ["name", "deleteProjectsNote"], [3, "reset", "value", "change", 4, "ngIf"], ["size", "medium", 3, "variant", "click"], ["library", "dashboard", "name", "projects-tiles"], ["library", "dashboard", "name", "projects-table"], ["variant", "danger", 3, "click", 4, "ngIf"], [3, "reset", "value", "change"], [4, "selectItemFor"], [3, "direction"], ["variant", "danger", 3, "click"], [1, "adaptive-view"], ["variant", "primary", 1, "add-button", 3, "click"], ["name", "plus", "slot", "suffix"], [3, "projects", "users", "projectsTotal", "projectModal", "projectCopyModal", "deleteConfirm"], [3, "total"], [3, "change"], ["width", "15vw"], ["routing", "", "by", "name"], ["width", "20vw"], ["routing", "", "by", "create_date"], ["routing", "", "by", "update_date"], ["trackById", "", 4, "ngFor", "ngForOf"], ["trackById", ""], [3, "value", 4, "ngIf"], [1, "table-icon-cell"], ["library", "dashboard", 1, "project-icon", 3, "name"], ["maxWidth", "15vw"], [3, "routerLink"], [3, "date"], ["type", "delete", 3, "click", 4, "ngIf"], [3, "value"], ["type", "copy", 3, "click"], ["type", "setup", 3, "click"], ["type", "delete", 3, "click"], ["imageSrc", "./assets/images/project-es.svg", 3, "title", "description"], [3, "code"]], template: function ProjectsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "core-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](2, "sl-checkbox", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("sl-change", function ProjectsComponent_Template_sl_checkbox_sl_change_2_listener($event) { return ctx.changeOnlySelf($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](5, ProjectsComponent_ng_container_5_Template, 8, 4, "ng-container", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](6, ProjectsComponent_core_table_filter_6_Template, 1, 0, "core-table-filter", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](7, ProjectsComponent_sl_button_7_Template, 4, 3, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](8, "core-content");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](9, ProjectsComponent_app_tiles_view_9_Template, 1, 6, "app-tiles-view", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](10, ProjectsComponent_core_table_10_Template, 29, 24, "core-table", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](11, ProjectsComponent_core_empty_state_11_Template, 3, 6, "core-empty-state", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](12, ProjectsComponent_core_error_state_12_Template, 1, 1, "core-error-state", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](13, "app-project-modal", 9, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("onCreate", function ProjectsComponent_Template_app_project_modal_onCreate_13_listener() { return ctx.onProjectCreate(); })("onUpdate", function ProjectsComponent_Template_app_project_modal_onUpdate_13_listener($event) { return ctx.onProjectUpdate($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](15, "app-project-copy-modal", 11, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("onCopied", function ProjectsComponent_Template_app_project_copy_modal_onCopied_15_listener() { return ctx.onProjectCopied(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](17, "core-confirm", 13, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("ok", function ProjectsComponent_Template_core_confirm_ok_17_listener($event) { return ctx.deleteProject($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](21, "core-confirm", 15, 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("ok", function ProjectsComponent_Template_core_confirm_ok_21_listener($event) { return ctx.deleteChecked($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](23, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](24, ProjectsComponent_p_24_Template, 2, 1, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](25, "core-notify", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](26);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](27, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](28, "core-notify", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](29);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](30, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](1, 17, "title"))("counter", ctx.projectsTotal);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("checked", ctx.onlySelf);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](4, 19, "onlySelf"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", !ctx.projectsEmpty);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.isSearch || !ctx.projectsEmpty);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("accessRights", ctx.ModuleRights.ProjectFullAccess);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.viewType === ctx.ProjectsViewType.Tiles && ctx.projects.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.viewType === ctx.ProjectsViewType.Table && ctx.projects.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", !ctx.responseServerError && ctx.projectsEmpty);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.responseServerError);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](19, 21, "deleteConfirm.title"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](20, 23, "deleteConfirm.description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](23, 25, "deleteConfirm.projects.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngForOf", ctx.checkRows);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](27, 27, "projectDelete"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](30, 29, "projectsDelete"), "\n");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ActionComponent, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ContentComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.EmptyStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ErrorStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.HeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.RelativeTimeComponent, _angular_router__WEBPACK_IMPORTED_MODULE_11__.RouterLinkWithHref, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SortIndicatorComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableCheckboxComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableCheckboxControllerComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableFilterComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableSortRoutingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.WidthDirective, ng_track_by__WEBPACK_IMPORTED_MODULE_13__.TrackByIdDirective, project_components_project_modal_project_modal_component__WEBPACK_IMPORTED_MODULE_3__.ProjectModalComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.AccessRightsDirective, _components_project_copy_modal_project_copy_modal_component__WEBPACK_IMPORTED_MODULE_4__.ProjectCopyModalComponent, project_pages_projects_select_select_item_directive__WEBPACK_IMPORTED_MODULE_5__.SelectItemDirective, project_pages_projects_select_select_component__WEBPACK_IMPORTED_MODULE_6__.SelectComponent, project_pages_projects_tiles_view_tiles_view_component__WEBPACK_IMPORTED_MODULE_7__.TilesViewComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.UsernamePipe], styles: [".project-icon[_ngcontent-%COMP%] {\n  font-size: 18px;\n}\n.table-icon-cell[_ngcontent-%COMP%] {\n  border-right: 1px solid #f1f1f2;\n}\ncore-sort-indicator[_ngcontent-%COMP%] {\n  top: -4px;\n  margin-left: 4px;\n}\ncore-header[_ngcontent-%COMP%] {\n  padding: 0;\n}\ncore-header[_ngcontent-%COMP%]   sl-button-group[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-medium);\n}\ncore-content[_ngcontent-%COMP%] {\n  padding: 0;\n}\n@media screen and (max-width: 960px) {\n  .add-button[_ngcontent-%COMP%]::part(label) {\n    display: none;\n  }\n  .add-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n    margin-left: var(--sl-spacing-small);\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByb2plY3RzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksZUFBQTtBQUNKO0FBRUE7RUFDSSwrQkFBQTtBQUFKO0FBR0E7RUFDSSxTQUFBO0VBQ0EsZ0JBQUE7QUFESjtBQUlBO0VBQ0ksVUFBQTtBQUZKO0FBQ0E7RUFJUSxxQ0FBQTtBQUZSO0FBTUE7RUFDSSxVQUFBO0FBSko7QUFPQTtFQUVRO0lBQ0ksYUFBQTtFQU5WO0VBSUU7SUFLUSxvQ0FBQTtFQU5WO0FBQ0YiLCJmaWxlIjoicHJvamVjdHMuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIucHJvamVjdC1pY29uIHtcbiAgICBmb250LXNpemU6IDE4cHg7XG59XG5cbi50YWJsZS1pY29uLWNlbGwge1xuICAgIGJvcmRlci1yaWdodDogMXB4IHNvbGlkICNmMWYxZjI7XG59XG5cbmNvcmUtc29ydC1pbmRpY2F0b3Ige1xuICAgIHRvcDogLTRweDtcbiAgICBtYXJnaW4tbGVmdDogNHB4O1xufVxuXG5jb3JlLWhlYWRlciB7XG4gICAgcGFkZGluZzogMDtcblxuICAgIHNsLWJ1dHRvbi1ncm91cCB7XG4gICAgICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLW1lZGl1bSk7XG4gICAgfVxufVxuXG5jb3JlLWNvbnRlbnQge1xuICAgIHBhZGRpbmc6IDA7XG59XG5cbkBtZWRpYSBzY3JlZW4gYW5kIChtYXgtd2lkdGg6IDk2MHB4KSB7XG4gICAgLmFkZC1idXR0b24ge1xuICAgICAgICAmOjpwYXJ0KGxhYmVsKSB7XG4gICAgICAgICAgICBkaXNwbGF5OiBub25lO1xuICAgICAgICB9XG4gICAgICAgIHNsLWljb24ge1xuICAgICAgICAgICAgbWFyZ2luLWxlZnQ6IHZhcigtLXNsLXNwYWNpbmctc21hbGwpO1xuICAgICAgICB9XG4gICAgfVxufVxuIl19 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_14__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_15__.WatchChanges)()
], ProjectsComponent.prototype, "projects", void 0);


/***/ }),

/***/ 43206:
/*!***************************************************!*\
  !*** ./src/app/pages/projects/projects.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectsModule": () => (/* binding */ ProjectsModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 48665);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ng-track-by */ 61245);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_components_project_modal_project_modal_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/components/project-modal/project-modal.module */ 75827);
/* harmony import */ var project_enums_module_rights__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/enums/module-rights */ 24475);
/* harmony import */ var project_pages_projects_projects_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/pages/projects/projects.component */ 66788);
/* harmony import */ var project_pages_projects_select_select_item_directive__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/pages/projects/select/select-item.directive */ 80737);
/* harmony import */ var project_pages_projects_select_select_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/pages/projects/select/select.component */ 25316);
/* harmony import */ var project_pages_projects_tiles_view_tiles_view_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! project/pages/projects/tiles-view/tiles-view.component */ 56146);
/* harmony import */ var _tiles_view_tiles_view_directive__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./tiles-view/tiles-view.directive */ 87800);
/* harmony import */ var project_components_project_copy_modal_project_copy_modal_module__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! project/components/project-copy-modal/project-copy-modal.module */ 5157);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 64565);
















class ProjectsModule {
}
ProjectsModule.ɵfac = function ProjectsModule_Factory(t) { return new (t || ProjectsModule)(); };
ProjectsModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineNgModule"]({ type: ProjectsModule });
ProjectsModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.providePageTranslations)({
            sources: ['assets/i18n/projects/'],
        }),
    ], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ActionModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_10__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ContentModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ErrorStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.FormModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.PaginationModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_11__.ReactiveFormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.RelativeTimeModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_12__.RouterModule.forChild([
            {
                path: '',
                children: [
                    {
                        path: '',
                        canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.PageTranslationsGuard, plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessRightsGuard],
                        data: (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.routeDate)({
                            accessRights: {
                                rights: [
                                    project_enums_module_rights__WEBPACK_IMPORTED_MODULE_1__.ModuleRights.ProjectView,
                                    project_enums_module_rights__WEBPACK_IMPORTED_MODULE_1__.ModuleRights.ProjectFullAccess,
                                ],
                            },
                        }),
                        component: project_pages_projects_projects_component__WEBPACK_IMPORTED_MODULE_2__.ProjectsComponent,
                    },
                    {
                        path: ':projectId',
                        loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("default-node_modules_devextreme-angular_fesm2015_devextreme-angular-ui-nested_js-node_modules-5c26f6"), __webpack_require__.e("default-src_app_pages_components_svg-map-container_svg-map-container_module_ts"), __webpack_require__.e("default-src_app_components_dashboard_dashboard_module_ts"), __webpack_require__.e("default-node_modules_devextreme-angular_fesm2015_devextreme-angular-ui-color-box_js"), __webpack_require__.e("default-src_app_api_project-share-api_service_ts-src_app_enums_shared_ts-node_modules_angular-676aa8"), __webpack_require__.e("default-src_app_components_widget-icon_widget-icon_module_ts-src_app_components_widget-setup_-9788d9"), __webpack_require__.e("default-node_modules_codemirror_mode_css_css_js-node_modules_codemirror_mode_javascript_javas-86e942"), __webpack_require__.e("default-src_app_components_project-header_project-header_module_ts"), __webpack_require__.e("common"), __webpack_require__.e("src_app_pages_project_project_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ../project/project.module */ 49174)).then((m) => m.ProjectModule),
                    },
                ],
            },
        ]),
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_13__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.SortIndicatorModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TableModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_14__.TrackByModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_14__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.UsernamePipeModule,
        project_components_project_modal_project_modal_module__WEBPACK_IMPORTED_MODULE_0__.ProjectModalModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessRightsDirectiveModule,
        project_components_project_copy_modal_project_copy_modal_module__WEBPACK_IMPORTED_MODULE_7__.ProjectCopyModalModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵsetNgModuleScope"](ProjectsModule, { declarations: [project_pages_projects_projects_component__WEBPACK_IMPORTED_MODULE_2__.ProjectsComponent,
        project_pages_projects_select_select_item_directive__WEBPACK_IMPORTED_MODULE_3__.SelectItemDirective,
        project_pages_projects_select_select_component__WEBPACK_IMPORTED_MODULE_4__.SelectComponent,
        project_pages_projects_tiles_view_tiles_view_component__WEBPACK_IMPORTED_MODULE_5__.TilesViewComponent,
        _tiles_view_tiles_view_directive__WEBPACK_IMPORTED_MODULE_6__.TilesViewDirective], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ActionModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_10__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ContentModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.ErrorStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.FormModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.PaginationModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_11__.ReactiveFormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.RelativeTimeModule, _angular_router__WEBPACK_IMPORTED_MODULE_12__.RouterModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_13__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.SortIndicatorModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TableModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_14__.TrackByModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_14__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.UsernamePipeModule,
        project_components_project_modal_project_modal_module__WEBPACK_IMPORTED_MODULE_0__.ProjectModalModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessRightsDirectiveModule,
        project_components_project_copy_modal_project_copy_modal_module__WEBPACK_IMPORTED_MODULE_7__.ProjectCopyModalModule] }); })();


/***/ }),

/***/ 80737:
/*!****************************************************************!*\
  !*** ./src/app/pages/projects/select/select-item.directive.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectItemDirective": () => (/* binding */ SelectItemDirective)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);


class SelectItemDirective {
    constructor(template) {
        this.template = template;
    }
    get value() {
        return this.selectItemFor;
    }
}
SelectItemDirective.ɵfac = function SelectItemDirective_Factory(t) { return new (t || SelectItemDirective)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef)); };
SelectItemDirective.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({ type: SelectItemDirective, selectors: [["", "selectItemFor", ""]], inputs: { selectItemFor: "selectItemFor" } });


/***/ }),

/***/ 25316:
/*!***********************************************************!*\
  !*** ./src/app/pages/projects/select/select.component.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectComponent": () => (/* binding */ SelectComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var project_pages_projects_select_select_item_directive__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/pages/projects/select/select-item.directive */ 80737);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ng-track-by */ 61245);






function SelectComponent_ng_container_2_div_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function SelectComponent_ng_container_2_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SelectComponent_ng_container_2_div_1_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", item_r2.template);
} }
function SelectComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, SelectComponent_ng_container_2_div_1_Template, 2, 1, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const item_r2 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", item_r2.value === ctx_r0.value);
} }
function SelectComponent_sl_menu_item_6_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function SelectComponent_sl_menu_item_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 9)(1, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, SelectComponent_sl_menu_item_6_ng_container_2_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const item_r6 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", item_r6.value)("checked", item_r6.value === ctx_r1.value);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", item_r6.template);
} }
class SelectComponent {
    constructor() {
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    }
    onSelect(event) {
        this.change.emit(event.detail.item.value);
    }
}
SelectComponent.ɵfac = function SelectComponent_Factory(t) { return new (t || SelectComponent)(); };
SelectComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: SelectComponent, selectors: [["projects-select"]], contentQueries: function SelectComponent_ContentQueries(rf, ctx, dirIndex) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵcontentQuery"](dirIndex, project_pages_projects_select_select_item_directive__WEBPACK_IMPORTED_MODULE_0__.SelectItemDirective, 4);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.items = _t);
    } }, inputs: { value: "value" }, outputs: { change: "change" }, decls: 7, vars: 2, consts: [["slot", "trigger", "size", "medium", "caret", "", 1, "high-size"], [4, "ngFor", "ngForOf"], ["slot", "trigger", 1, "hidden"], ["name", "sort-down"], [3, "sl-select"], ["trackBy", "value", 3, "value", "checked", 4, "ngFor", "ngForOf"], ["class", "item", 4, "ngIf"], [1, "item"], [4, "ngTemplateOutlet"], ["trackBy", "value", 3, "value", "checked"]], template: function SelectComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-dropdown")(1, "sl-button", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, SelectComponent_ng_container_2_Template, 2, 1, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "sl-button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "sl-icon", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "sl-menu", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-select", function SelectComponent_Template_sl_menu_sl_select_5_listener($event) { return ctx.onSelect($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, SelectComponent_sl_menu_item_6_Template, 3, 3, "sl-menu-item", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.items);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.items);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_2__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_2__.NgTemplateOutlet, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.OpenableDirective, ng_track_by__WEBPACK_IMPORTED_MODULE_4__.TrackByDirective], styles: ["[_nghost-%COMP%] {\n  margin-left: var(--sl-spacing-small);\n}\n.item[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.item[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: relative;\n  left: 4px;\n  color: var(--sl-color-secondary-600);\n}\n@media screen and (max-width: 960px) {\n  .high-size[_ngcontent-%COMP%] {\n    display: none;\n  }\n  .hidden[_ngcontent-%COMP%] {\n    display: block !important;\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlbGVjdC5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLG9DQUFBO0FBQ0o7QUFFQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtBQUFKO0FBRkE7RUFLUSxrQkFBQTtFQUNBLFNBQUE7RUFDQSxvQ0FBQTtBQUFSO0FBSUE7RUFDSTtJQUNJLGFBQUE7RUFGTjtFQUtFO0lBQ0kseUJBQUE7RUFITjtBQUNGIiwiZmlsZSI6InNlbGVjdC5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICBtYXJnaW4tbGVmdDogdmFyKC0tc2wtc3BhY2luZy1zbWFsbCk7XG59XG5cbi5pdGVtIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbiAgICBzbC1pY29uIHtcbiAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICBsZWZ0OiA0cHg7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktNjAwKTtcbiAgICB9XG59XG5cbkBtZWRpYSBzY3JlZW4gYW5kIChtYXgtd2lkdGg6IDk2MHB4KSB7XG4gICAgLmhpZ2gtc2l6ZSB7XG4gICAgICAgIGRpc3BsYXk6IG5vbmU7XG4gICAgfVxuXG4gICAgLmhpZGRlbiB7XG4gICAgICAgIGRpc3BsYXk6IGJsb2NrICFpbXBvcnRhbnQ7XG4gICAgfVxufVxuIl19 */"], changeDetection: 0 });


/***/ }),

/***/ 56146:
/*!*******************************************************************!*\
  !*** ./src/app/pages/projects/tiles-view/tiles-view.component.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TilesViewComponent": () => (/* binding */ TilesViewComponent)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ng-track-by */ 61245);
/* harmony import */ var _tiles_view_directive__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tiles-view.directive */ 87800);







function TilesViewComponent_ng_container_1_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
const _c0 = function (a0) { return [a0]; };
const _c1 = function (a0) { return { $implicit: a0 }; };
function TilesViewComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0, 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "sl-card", 5)(2, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, TilesViewComponent_ng_container_1_ng_container_3_Template, 1, 0, "ng-container", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const project_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](3, _c0, project_r3.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r1)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](5, _c1, project_r3));
} }
function TilesViewComponent_ng_template_2_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "core-action", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function TilesViewComponent_ng_template_2_ng_container_1_Template_core_action_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10); const project_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r8.projectCopyModal.open(project_r5)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "core-action", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function TilesViewComponent_ng_template_2_ng_container_1_Template_core_action_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10); const project_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.projectModal.open(project_r5)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} }
function TilesViewComponent_ng_template_2_core_action_2_Template(rf, ctx) { if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "core-action", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function TilesViewComponent_ng_template_2_core_action_2_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r15); const project_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.deleteConfirm.show(project_r5.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
function TilesViewComponent_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function TilesViewComponent_ng_template_2_Template_div_click_0_listener($event) { return $event.stopPropagation(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, TilesViewComponent_ng_template_2_ng_container_1_Template, 3, 0, "ng-container", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, TilesViewComponent_ng_template_2_core_action_2_Template, 1, 0, "core-action", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "sl-icon", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 12)(5, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](8, "core-relative-time", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "span", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](11, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const project_r5 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", project_r5.access_right !== ctx_r2.AccessRight.Read);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", project_r5.access_right === ctx_r2.AccessRight.Full);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", project_r5.icon);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("appTilesView", project_r5.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", project_r5.description, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("date", project_r5.create_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](11, 7, ctx_r2.users[project_r5.owner_id]));
} }
class TilesViewComponent {
    constructor() {
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.AccessRight;
    }
}
TilesViewComponent.ɵfac = function TilesViewComponent_Factory(t) { return new (t || TilesViewComponent)(); };
TilesViewComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: TilesViewComponent, selectors: [["app-tiles-view"]], inputs: { projects: "projects", users: "users", projectsTotal: "projectsTotal", projectModal: "projectModal", projectCopyModal: "projectCopyModal", deleteConfirm: "deleteConfirm" }, decls: 5, vars: 2, consts: [[1, "tiles"], ["trackBy", "name", 4, "ngFor", "ngForOf"], ["projectTile", ""], ["routing", "", 3, "total"], ["trackBy", "name"], [3, "routerLink"], [1, "project-tile"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [1, "actions", 3, "click"], [4, "ngIf"], ["type", "delete", 3, "click", 4, "ngIf"], ["library", "dashboard", 1, "project-icon", 3, "name"], [1, "content-box", 3, "appTilesView"], [1, "description"], [1, "footer"], [3, "date"], [1, "owner"], ["type", "copy", 3, "click"], ["type", "setup", 3, "click"], ["type", "delete", 3, "click"]], template: function TilesViewComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, TilesViewComponent_ng_container_1_Template, 4, 7, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, TilesViewComponent_ng_template_2_Template, 12, 9, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "core-pagination", 3);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.projects);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("total", ctx.projectsTotal);
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.ActionComponent, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.PaginationComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.RelativeTimeComponent, _angular_router__WEBPACK_IMPORTED_MODULE_4__.RouterLink, ng_track_by__WEBPACK_IMPORTED_MODULE_5__.TrackByDirective, _tiles_view_directive__WEBPACK_IMPORTED_MODULE_0__.TilesViewDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.UsernamePipe], styles: [".tiles[_ngcontent-%COMP%] {\n  display: grid;\n  grid-gap: var(--sl-spacing-large);\n}\n@media (min-width: 600px) {\n  .tiles[_ngcontent-%COMP%] {\n    grid-template-columns: repeat(2, 50%);\n    width: calc(100% - var(--sl-spacing-large));\n  }\n}\n@media (min-width: 1024px) {\n  .tiles[_ngcontent-%COMP%] {\n    grid-template-columns: repeat(3, 33%);\n    width: calc(100% - var(--sl-spacing-large));\n  }\n}\n@media (min-width: 1400px) {\n  .tiles[_ngcontent-%COMP%] {\n    grid-template-columns: repeat(4, 25%);\n    width: calc(100% - (var(--sl-spacing-large) * 3));\n  }\n}\n@media (min-width: 1701px) {\n  .tiles[_ngcontent-%COMP%] {\n    grid-template-columns: repeat(5, 20%);\n    width: calc(100% - var(--sl-spacing-large) * 4);\n  }\n}\nsl-card[_ngcontent-%COMP%] {\n  position: relative;\n  cursor: pointer;\n}\nsl-card[_ngcontent-%COMP%]::part(base) {\n  border: none;\n  transition: box-shadow 0.1s;\n}\nsl-card[_ngcontent-%COMP%]::part(base), sl-card[_ngcontent-%COMP%]::part(body) {\n  height: 100%;\n}\nsl-card[_ngcontent-%COMP%]:hover   .actions[_ngcontent-%COMP%] {\n  opacity: 1;\n}\nsl-card[_ngcontent-%COMP%]::part(base):hover {\n  box-shadow: 0 5px 16px 3px var(--sl-color-neutral-200);\n}\n.actions[_ngcontent-%COMP%] {\n  position: absolute;\n  opacity: 0;\n  right: var(--sl-spacing-large);\n  top: var(--sl-spacing-large);\n  transition: opacity 0.3s;\n}\n.actions[_ngcontent-%COMP%]   core-action[_ngcontent-%COMP%] {\n  --core-action-padding: 2px;\n}\n.project-tile[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n.content-box[_ngcontent-%COMP%] {\n  flex: 1;\n}\n.project-icon[_ngcontent-%COMP%] {\n  font-size: 36px;\n  margin-bottom: var(--sl-spacing-medium);\n}\n.name[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  font-weight: var(--sl-font-weight-normal);\n  max-width: 100%;\n  text-overflow: ellipsis;\n  word-break: break-all;\n  overflow: hidden;\n  display: -webkit-box;\n  -webkit-line-clamp: 3;\n  -webkit-box-orient: vertical;\n}\n.description[_ngcontent-%COMP%] {\n  margin-top: var(--sl-spacing-small);\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-neutral-600);\n  word-break: break-all;\n}\n.footer[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 12px;\n  padding-top: 5px;\n  border-top: 1px solid #f1f1f2;\n}\n.footer[_ngcontent-%COMP%]   core-relative-time[_ngcontent-%COMP%] {\n  display: block;\n  color: #767685;\n  font-size: 11px;\n}\n.footer[_ngcontent-%COMP%]   .owner[_ngcontent-%COMP%] {\n  font-size: 14px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRpbGVzLXZpZXcuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsaUNBQUE7QUFDSjtBQUNJO0VBQUE7SUFDSSxxQ0FBQTtJQUNBLDJDQUFBO0VBRU47QUFDRjtBQUFJO0VBQUE7SUFDSSxxQ0FBQTtJQUNBLDJDQUFBO0VBR047QUFDRjtBQURJO0VBQUE7SUFDSSxxQ0FBQTtJQUNBLGlEQUFBO0VBSU47QUFDRjtBQUZJO0VBQUE7SUFDSSxxQ0FBQTtJQUNBLCtDQUFBO0VBS047QUFDRjtBQUZBO0VBQ0ksa0JBQUE7RUFDQSxlQUFBO0FBSUo7QUFGSTtFQUNJLFlBQUE7RUFDQSwyQkFBQTtBQUlSO0FBREk7O0VBRUksWUFBQTtBQUdSO0FBQUk7RUFDSSxVQUFBO0FBRVI7QUFDSTtFQUNJLHNEQUFBO0FBQ1I7QUFHQTtFQUNJLGtCQUFBO0VBQ0EsVUFBQTtFQUNBLDhCQUFBO0VBQ0EsNEJBQUE7RUFDQSx3QkFBQTtBQURKO0FBSkE7RUFRUSwwQkFBQTtBQURSO0FBS0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxZQUFBO0FBSEo7QUFNQTtFQUNJLE9BQUE7QUFKSjtBQU9BO0VBQ0ksZUFBQTtFQUNBLHVDQUFBO0FBTEo7QUFRQTtFQUNJLHFDQUFBO0VBQ0EseUNBQUE7RUFFQSxlQUFBO0VBRUEsdUJBQUE7RUFDQSxxQkFBQTtFQUNBLGdCQUFBO0VBRUEsb0JBQUE7RUFDQSxxQkFBQTtFQUNBLDRCQUFBO0FBVEo7QUFZQTtFQUNJLG1DQUFBO0VBQ0Esb0NBQUE7RUFDQSxrQ0FBQTtFQUNBLHFCQUFBO0FBVko7QUFhQTtFQUNJLFdBQUE7RUFDQSxnQkFBQTtFQUNBLGdCQUFBO0VBQ0EsNkJBQUE7QUFYSjtBQU9BO0VBT1EsY0FBQTtFQUNBLGNBQUE7RUFDQSxlQUFBO0FBWFI7QUFFQTtFQWFRLGVBQUE7QUFaUiIsImZpbGUiOiJ0aWxlcy12aWV3LmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLnRpbGVzIHtcbiAgICBkaXNwbGF5OiBncmlkO1xuICAgIGdyaWQtZ2FwOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcblxuICAgIEBtZWRpYSAobWluLXdpZHRoOiA2MDBweCkge1xuICAgICAgICBncmlkLXRlbXBsYXRlLWNvbHVtbnM6IHJlcGVhdCgyLCA1MCUpO1xuICAgICAgICB3aWR0aDogY2FsYygxMDAlIC0gdmFyKC0tc2wtc3BhY2luZy1sYXJnZSkpO1xuICAgIH1cblxuICAgIEBtZWRpYSAobWluLXdpZHRoOiAxMDI0cHgpIHtcbiAgICAgICAgZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOiByZXBlYXQoMywgMzMlKTtcbiAgICAgICAgd2lkdGg6IGNhbGMoMTAwJSAtIHZhcigtLXNsLXNwYWNpbmctbGFyZ2UpKTtcbiAgICB9XG5cbiAgICBAbWVkaWEgKG1pbi13aWR0aDogMTQwMHB4KSB7XG4gICAgICAgIGdyaWQtdGVtcGxhdGUtY29sdW1uczogcmVwZWF0KDQsIDI1JSk7XG4gICAgICAgIHdpZHRoOiBjYWxjKDEwMCUgLSAodmFyKC0tc2wtc3BhY2luZy1sYXJnZSkgKiAzKSk7XG4gICAgfVxuXG4gICAgQG1lZGlhIChtaW4td2lkdGg6IDE3MDFweCkge1xuICAgICAgICBncmlkLXRlbXBsYXRlLWNvbHVtbnM6IHJlcGVhdCg1LCAyMCUpO1xuICAgICAgICB3aWR0aDogY2FsYygxMDAlIC0gdmFyKC0tc2wtc3BhY2luZy1sYXJnZSkgKiA0KTtcbiAgICB9XG59XG5cbnNsLWNhcmQge1xuICAgIHBvc2l0aW9uOiByZWxhdGl2ZTtcbiAgICBjdXJzb3I6IHBvaW50ZXI7XG5cbiAgICAmOjpwYXJ0KGJhc2UpIHtcbiAgICAgICAgYm9yZGVyOiBub25lO1xuICAgICAgICB0cmFuc2l0aW9uOiBib3gtc2hhZG93IDAuMXM7XG4gICAgfVxuXG4gICAgJjo6cGFydChiYXNlKSxcbiAgICAmOjpwYXJ0KGJvZHkpIHtcbiAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgIH1cblxuICAgICY6aG92ZXIgLmFjdGlvbnMge1xuICAgICAgICBvcGFjaXR5OiAxO1xuICAgIH1cblxuICAgICY6OnBhcnQoYmFzZSk6aG92ZXIge1xuICAgICAgICBib3gtc2hhZG93OiAwIDVweCAxNnB4IDNweCB2YXIoLS1zbC1jb2xvci1uZXV0cmFsLTIwMCk7XG4gICAgfVxufVxuXG4uYWN0aW9ucyB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIG9wYWNpdHk6IDA7XG4gICAgcmlnaHQ6IHZhcigtLXNsLXNwYWNpbmctbGFyZ2UpO1xuICAgIHRvcDogdmFyKC0tc2wtc3BhY2luZy1sYXJnZSk7XG4gICAgdHJhbnNpdGlvbjogb3BhY2l0eSAwLjNzO1xuXG4gICAgY29yZS1hY3Rpb24ge1xuICAgICAgICAtLWNvcmUtYWN0aW9uLXBhZGRpbmc6IDJweDtcbiAgICB9XG59XG5cbi5wcm9qZWN0LXRpbGUge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBoZWlnaHQ6IDEwMCU7XG59XG5cbi5jb250ZW50LWJveCB7XG4gICAgZmxleDogMTtcbn1cblxuLnByb2plY3QtaWNvbiB7XG4gICAgZm9udC1zaXplOiAzNnB4O1xuICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKTtcbn1cblxuLm5hbWUge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLW1lZGl1bSk7XG4gICAgZm9udC13ZWlnaHQ6IHZhcigtLXNsLWZvbnQtd2VpZ2h0LW5vcm1hbCk7XG5cbiAgICBtYXgtd2lkdGg6IDEwMCU7XG5cbiAgICB0ZXh0LW92ZXJmbG93OiBlbGxpcHNpcztcbiAgICB3b3JkLWJyZWFrOiBicmVhay1hbGw7XG4gICAgb3ZlcmZsb3c6IGhpZGRlbjtcblxuICAgIGRpc3BsYXk6IC13ZWJraXQtYm94O1xuICAgIC13ZWJraXQtbGluZS1jbGFtcDogMztcbiAgICAtd2Via2l0LWJveC1vcmllbnQ6IHZlcnRpY2FsO1xufVxuXG4uZGVzY3JpcHRpb24ge1xuICAgIG1hcmdpbi10b3A6IHZhcigtLXNsLXNwYWNpbmctc21hbGwpO1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3ItbmV1dHJhbC02MDApO1xuICAgIHdvcmQtYnJlYWs6IGJyZWFrLWFsbDtcbn1cblxuLmZvb3RlciB7XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgbWFyZ2luLXRvcDogMTJweDtcbiAgICBwYWRkaW5nLXRvcDogNXB4O1xuICAgIGJvcmRlci10b3A6IDFweCBzb2xpZCAjZjFmMWYyO1xuXG4gICAgY29yZS1yZWxhdGl2ZS10aW1lIHtcbiAgICAgICAgZGlzcGxheTogYmxvY2s7XG4gICAgICAgIGNvbG9yOiAjNzY3Njg1O1xuICAgICAgICBmb250LXNpemU6IDExcHg7XG4gICAgfVxuXG4gICAgLm93bmVyIHtcbiAgICAgICAgZm9udC1zaXplOiAxNHB4O1xuICAgIH1cbn1cbiJdfQ== */"] });


/***/ }),

/***/ 87800:
/*!*******************************************************************!*\
  !*** ./src/app/pages/projects/tiles-view/tiles-view.directive.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TilesViewDirective": () => (/* binding */ TilesViewDirective)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 14474);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 53399);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 39754);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 7048);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 64565);





class TilesViewDirective extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_0__.SubscribableDirective {
    constructor(host, renderer) {
        super();
        this.host = host;
        this.renderer = renderer;
    }
    ngAfterContentInit() {
        const contentBox = this.host.nativeElement;
        const tooltip = this.renderer.createElement('sl-tooltip');
        const positioner = this.renderer.createElement('div');
        this.setAttributesTooltip(tooltip);
        this.setAttributesPositioner(positioner);
        this.renderer.appendChild(tooltip, positioner);
        this.renderer.appendChild(contentBox, tooltip);
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.fromEvent)(positioner, 'mouseover')
                .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(({ target }) => target), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.filter)((element) => element.offsetHeight + 2 < element.scrollHeight), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.tap)(() => {
                tooltip.show();
            }))
                .subscribe(),
        ];
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.fromEvent)(positioner, 'mouseout')
                .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(({ target }) => target), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.filter)((element) => element.offsetHeight + 2 < element.scrollHeight), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.tap)(() => {
                tooltip.hide();
            }))
                .subscribe(),
        ];
    }
    setAttributesTooltip(tooltip) {
        this.renderer.setAttribute(tooltip, 'hoist', 'true');
        this.renderer.setAttribute(tooltip, 'placement', 'top-start');
        this.renderer.setAttribute(tooltip, 'word-break', 'break-word');
        this.renderer.setAttribute(tooltip, 'trigger', 'manual');
        if (this.text) {
            tooltip.setAttribute('content', this.text);
        }
    }
    setAttributesPositioner(positioner) {
        this.renderer.setAttribute(positioner, 'class', 'name');
        if (this.text) {
            const renderText = this.renderer.createText(this.text);
            this.renderer.appendChild(positioner, renderText);
        }
    }
}
TilesViewDirective.ɵfac = function TilesViewDirective_Factory(t) { return new (t || TilesViewDirective)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_5__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_5__.Renderer2)); };
TilesViewDirective.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineDirective"]({ type: TilesViewDirective, selectors: [["", "appTilesView", ""]], inputs: { text: ["appTilesView", "text"] }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵInheritDefinitionFeature"]] });


/***/ })

}]);
//# sourceMappingURL=src_app_pages_projects_projects_module_ts.js.map