"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["default-src_app_components_widget-icon_widget-icon_module_ts-src_app_components_widget-setup_-9788d9"],{

/***/ 52290:
/*!**********************************************!*\
  !*** ./src/app/api/component-api.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComponentApiService": () => (/* binding */ ComponentApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class ComponentApiService {
    constructor(restService) {
        this.restService = restService;
    }
    list(query = {}) {
        return this.restService.get('/component', query);
    }
    upload(file) {
        const formData = new FormData();
        formData.append('file', file);
        return this.restService.post(`/component/upload`, formData);
    }
    save(component) {
        if (component.id) {
            return this.restService.put(`/component/${component.id}`, component);
        }
        else {
            return this.restService.post('/component', component);
        }
    }
    get(id) {
        return this.restService.get(`/component/${id}`);
    }
    deleteList(ids) {
        return this.restService.delete(`/component`, { ids });
    }
}
ComponentApiService.ɵfac = function ComponentApiService_Factory(t) { return new (t || ComponentApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ComponentApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ComponentApiService, factory: ComponentApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 83901:
/*!*****************************************************************!*\
  !*** ./src/app/components/widget-icon/widget-icon.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetIconComponent": () => (/* binding */ WidgetIconComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class WidgetIconComponent {
    constructor(storageApiService) {
        this.storageApiService = storageApiService;
        this.root = '';
    }
    get imagePath() {
        return `${this.storageApiService.resolve(this.root)}/icon.svg`;
    }
}
WidgetIconComponent.ɵfac = function WidgetIconComponent_Factory(t) { return new (t || WidgetIconComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.StorageApiService)); };
WidgetIconComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: WidgetIconComponent, selectors: [["app-widget-icon"]], inputs: { root: "root" }, decls: 1, vars: 1, consts: [["onError", "this.src = 'assets/images/component-default.svg'", 3, "src"]], template: function WidgetIconComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "img", 0);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("src", ctx.imagePath, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeUrl"]);
    } }, styles: ["[_nghost-%COMP%] {\n  display: flex;\n  width: 16px;\n  height: 16px;\n}\nimg[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpZGdldC1pY29uLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBQ0o7QUFFQTtFQUNJLFdBQUE7RUFDQSxZQUFBO0FBQUoiLCJmaWxlIjoid2lkZ2V0LWljb24uY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyI6aG9zdCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICB3aWR0aDogMTZweDtcbiAgICBoZWlnaHQ6IDE2cHg7XG59XG5cbmltZyB7XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xufVxuIl19 */"] });


/***/ }),

/***/ 46076:
/*!**************************************************************!*\
  !*** ./src/app/components/widget-icon/widget-icon.module.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetIconModule": () => (/* binding */ WidgetIconModule)
/* harmony export */ });
/* harmony import */ var _widget_icon_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./widget-icon.component */ 83901);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);


class WidgetIconModule {
}
WidgetIconModule.ɵfac = function WidgetIconModule_Factory(t) { return new (t || WidgetIconModule)(); };
WidgetIconModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: WidgetIconModule });
WidgetIconModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({});
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](WidgetIconModule, { declarations: [_widget_icon_component__WEBPACK_IMPORTED_MODULE_0__.WidgetIconComponent], exports: [_widget_icon_component__WEBPACK_IMPORTED_MODULE_0__.WidgetIconComponent] }); })();


/***/ }),

/***/ 4953:
/*!********************************************************************************!*\
  !*** ./src/app/components/widget-setup/component-adapter/component-adapter.ts ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComponentAdapter": () => (/* binding */ ComponentAdapter)
/* harmony export */ });
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 53399);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! logical-not */ 47002);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var _adapter_legacy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./adapter.legacy */ 31332);




class ComponentAdapter {
    constructor(adapterLegacy) {
        this.adapterLegacy = adapterLegacy;
    }
    activate(component) {
        return this.adapterLegacy.activate(component).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(({ options, config }) => {
            const dataConfigs = this.getDataConfigs(config);
            let dataOptions = [];
            if (dataConfigs) {
                dataOptions = dataConfigs.map(({ key, method }) => ({
                    key,
                    dataset_id: 0,
                    method: method,
                    blocks: [],
                }));
            }
            return { options, config, dataConfigs, dataOptions };
        }));
    }
    getDataConfigs(widgetConfig) {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(widgetConfig) || (0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(widgetConfig.data))
            return [];
        return Array.isArray(widgetConfig.data.config)
            ? widgetConfig.data.config
            : [{ key: 'default', ...widgetConfig.data.config }];
    }
}
ComponentAdapter.ɵfac = function ComponentAdapter_Factory(t) { return new (t || ComponentAdapter)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵinject"](_adapter_legacy__WEBPACK_IMPORTED_MODULE_1__.AdapterLegacy)); };
ComponentAdapter.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjectable"]({ token: ComponentAdapter, factory: ComponentAdapter.ɵfac });


/***/ }),

/***/ 38024:
/*!***********************************************************************************!*\
  !*** ./src/app/components/widget-setup/services/dashboard-dataset-api.service.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DashboardDatasetApiService": () => (/* binding */ DashboardDatasetApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);



class DashboardDatasetApiService extends plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.DatasetApiService {
    constructor(restService, datasetRestService) {
        super(restService);
        this.datasetRestService = datasetRestService;
    }
    get(datasetId, params) {
        if (this.widgetId) {
            return this.datasetRestService.get(`/widget/${this.widgetId}/dataset/${datasetId}`);
        }
        return super.get(datasetId, params);
    }
}
DashboardDatasetApiService.ɵfac = function DashboardDatasetApiService_Factory(t) { return new (t || DashboardDatasetApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.CoreApi), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.RestService)); };
DashboardDatasetApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: DashboardDatasetApiService, factory: DashboardDatasetApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 57750:
/*!******************************************************************************************!*\
  !*** ./src/app/components/widget-setup/widget-setup-meta/widget-setup-meta.component.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetSetupMetaComponent": () => (/* binding */ WidgetSetupMetaComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


var FocusedElement;
(function (FocusedElement) {
    FocusedElement[FocusedElement["None"] = 0] = "None";
    FocusedElement[FocusedElement["Name"] = 1] = "Name";
    FocusedElement[FocusedElement["Description"] = 2] = "Description";
})(FocusedElement || (FocusedElement = {}));
class WidgetSetupMetaComponent {
    constructor() {
        this.focused = FocusedElement.None;
        this.FocusedElement = FocusedElement;
    }
    ngOnInit() { }
}
WidgetSetupMetaComponent.ɵfac = function WidgetSetupMetaComponent_Factory(t) { return new (t || WidgetSetupMetaComponent)(); };
WidgetSetupMetaComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: WidgetSetupMetaComponent, selectors: [["app-widget-setup-meta"]], inputs: { form: "form" }, decls: 15, vars: 11, consts: [[3, "data"], [1, "line"], ["name", "name", "size", "small", 3, "placeholder", "focus", "blur"], ["name", ""], ["variant", "default", "size", "small", 1, "control-btn", 3, "click"], ["name", "pencil", 1, "icon-pencil"], ["name", "description", "size", "small", 3, "placeholder", "focus", "blur"], ["description", ""]], template: function WidgetSetupMetaComponent_Template(rf, ctx) { if (rf & 1) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "core-form", 0)(1, "div", 1)(2, "core-validate")(3, "sl-input", 2, 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("focus", function WidgetSetupMetaComponent_Template_sl_input_focus_3_listener() { return ctx.focused = ctx.FocusedElement.Name; })("blur", function WidgetSetupMetaComponent_Template_sl_input_blur_3_listener() { return ctx.focused = ctx.FocusedElement.None; });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function WidgetSetupMetaComponent_Template_sl_button_click_6_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r2); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](4); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](_r0.focus()); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 1)(9, "core-validate")(10, "sl-input", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("focus", function WidgetSetupMetaComponent_Template_sl_input_focus_10_listener() { return ctx.focused = ctx.FocusedElement.Description; })("blur", function WidgetSetupMetaComponent_Template_sl_input_blur_10_listener() { return ctx.focused = ctx.FocusedElement.None; });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](12, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function WidgetSetupMetaComponent_Template_sl_button_click_13_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r2); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](11); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](_r1.focus()); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](14, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("focused", ctx.focused === ctx.FocusedElement.Name);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](5, 7, "#widget.name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("focused", ctx.focused === ctx.FocusedElement.Description);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](12, 9, "#widget.description"));
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.TranslatePipe], styles: ["sl-input[_ngcontent-%COMP%]:not(.focused)::part(base) {\n  background: none;\n  border: none;\n  font-size: var(--sl-font-size-medium);\n  opacity: 1;\n  cursor: pointer;\n}\nsl-input[_ngcontent-%COMP%]:not(.focused)::part(input) {\n  color: var(--sl-color-secondary-900);\n}\n.line[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: 1fr auto auto;\n  grid-column-gap: var(--sl-spacing-small);\n  margin-bottom: var(--sl-spacing-large);\n}\n.line[_ngcontent-%COMP%]   core-validate[_ngcontent-%COMP%] {\n  display: block;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpZGdldC1zZXR1cC1tZXRhLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNJO0VBQ0ksZ0JBQUE7RUFDQSxZQUFBO0VBQ0EscUNBQUE7RUFDQSxVQUFBO0VBQ0EsZUFBQTtBQUFSO0FBRUk7RUFDSSxvQ0FBQTtBQUFSO0FBSUE7RUFDSSxhQUFBO0VBQ0Esb0NBQUE7RUFDQSx3Q0FBQTtFQUNBLHNDQUFBO0FBRko7QUFGQTtFQU9RLGNBQUE7QUFGUiIsImZpbGUiOiJ3aWRnZXQtc2V0dXAtbWV0YS5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbInNsLWlucHV0Om5vdCguZm9jdXNlZCkge1xuICAgICY6OnBhcnQoYmFzZSkge1xuICAgICAgICBiYWNrZ3JvdW5kOiBub25lO1xuICAgICAgICBib3JkZXI6IG5vbmU7XG4gICAgICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLW1lZGl1bSk7XG4gICAgICAgIG9wYWNpdHk6IDE7XG4gICAgICAgIGN1cnNvcjogcG9pbnRlcjtcbiAgICB9XG4gICAgJjo6cGFydChpbnB1dCkge1xuICAgICAgICBjb2xvcjogdmFyKC0tc2wtY29sb3Itc2Vjb25kYXJ5LTkwMCk7XG4gICAgfVxufVxuXG4ubGluZSB7XG4gICAgZGlzcGxheTogZ3JpZDtcbiAgICBncmlkLXRlbXBsYXRlLWNvbHVtbnM6IDFmciBhdXRvIGF1dG87XG4gICAgZ3JpZC1jb2x1bW4tZ2FwOiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcblxuICAgIGNvcmUtdmFsaWRhdGUge1xuICAgICAgICBkaXNwbGF5OiBibG9jaztcbiAgICB9XG59XG4iXX0= */"] });


/***/ }),

/***/ 23857:
/*!**********************************************************************************************************!*\
  !*** ./src/app/components/widget-setup/widget-setup-view-options/widget-setup-view-options.component.ts ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetSetupViewOptionsComponent": () => (/* binding */ WidgetSetupViewOptionsComponent)
/* harmony export */ });
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var polymatica_widget_internal_widget_options__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! polymatica-widget/__internal__/widget-options */ 76441);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var devextreme_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! devextreme-angular */ 2601);






function WidgetSetupViewOptionsComponent_ng_container_6_h2_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "h2");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", config_r1.label, " ");
} }
function WidgetSetupViewOptionsComponent_ng_container_6_sl_input_3_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-input", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-input", function WidgetSetupViewOptionsComponent_ng_container_6_sl_input_3_Template_sl_input_sl_input_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11); const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.onChange(config_r1.key, $event.target.value)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", config_r1.label[ctx_r3.lang])("value", ctx_r3.valueByKey(config_r1.key) || "");
} }
function WidgetSetupViewOptionsComponent_ng_container_6_sl_checkbox_4_Template(rf, ctx) { if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-checkbox", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-change", function WidgetSetupViewOptionsComponent_ng_container_6_sl_checkbox_4_Template_sl_checkbox_sl_change_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r15); const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onChange(config_r1.key, $event.target.checked)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("checked", ctx_r4.valueByKey(config_r1.key));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", config_r1.label[ctx_r4.lang], " ");
} }
function WidgetSetupViewOptionsComponent_ng_container_6_sl_radio_5_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-radio", 10, 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-change", function WidgetSetupViewOptionsComponent_ng_container_6_sl_radio_5_Template_sl_radio_sl_change_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r19); const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](1); const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](_r17.checked && ctx_r18.onChange(config_r1.key, $event.target.checked)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("checked", ctx_r5.valueByKey(config_r1.key));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", config_r1.label[ctx_r5.lang], " ");
} }
function WidgetSetupViewOptionsComponent_ng_container_6_sl_select_6_sl_menu_item_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const option_r23 = ctx.$implicit;
    const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", option_r23.value);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", option_r23.label[ctx_r22.lang], " ");
} }
function WidgetSetupViewOptionsComponent_ng_container_6_sl_select_6_Template(rf, ctx) { if (rf & 1) {
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-select", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-change", function WidgetSetupViewOptionsComponent_ng_container_6_sl_select_6_Template_sl_select_sl_change_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r26); const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r24.onChange(config_r1.key, $event.target.value)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, WidgetSetupViewOptionsComponent_ng_container_6_sl_select_6_sl_menu_item_1_Template, 2, 2, "sl-menu-item", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", config_r1.label[ctx_r6.lang])("value", ctx_r6.valueByKey(config_r1.key) || "");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", config_r1.options);
} }
function WidgetSetupViewOptionsComponent_ng_container_6_dx_color_box_7_Template(rf, ctx) { if (rf & 1) {
    const _r30 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "dx-color-box", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onValueChanged", function WidgetSetupViewOptionsComponent_ng_container_6_dx_color_box_7_Template_dx_color_box_onValueChanged_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r30); const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r28.onChange(config_r1.key, $event.value)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("applyButtonText", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](1, 3, "$.save"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("cancelButtonText", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 5, "$.cancel"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", ctx_r7.valueByKey(config_r1.key) || "");
} }
function WidgetSetupViewOptionsComponent_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0, 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, WidgetSetupViewOptionsComponent_ng_container_6_h2_2_Template, 2, 1, "h2", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, WidgetSetupViewOptionsComponent_ng_container_6_sl_input_3_Template, 1, 2, "sl-input", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, WidgetSetupViewOptionsComponent_ng_container_6_sl_checkbox_4_Template, 2, 2, "sl-checkbox", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, WidgetSetupViewOptionsComponent_ng_container_6_sl_radio_5_Template, 3, 2, "sl-radio", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, WidgetSetupViewOptionsComponent_ng_container_6_sl_select_6_Template, 2, 3, "sl-select", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, WidgetSetupViewOptionsComponent_ng_container_6_dx_color_box_7_Template, 3, 7, "dx-color-box", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const config_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitch", config_r1.type);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx_r0.WidgetOptionType.Title);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx_r0.WidgetOptionType.Text);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx_r0.WidgetOptionType.Checkbox);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx_r0.WidgetOptionType.Radio);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx_r0.WidgetOptionType.Select);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx_r0.WidgetOptionType.ColorPicker);
} }
class WidgetSetupViewOptionsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__.SubscribableComponent {
    constructor(storageService) {
        super();
        this.storageService = storageService;
        this.options = [];
        this.WidgetOptionType = polymatica_widget_internal_widget_options__WEBPACK_IMPORTED_MODULE_0__.WidgetOptionType;
    }
    ngOnInit() {
        this.subscriptions = [
            this.storageService.lang.subscribe((lang) => {
                this.lang = lang;
            }),
        ];
    }
    onChange(key, value) {
        const options = {
            ...this.formViewOptions?.value,
            [key]: value,
        };
        this.formViewOptions.patchValue(options);
    }
    valueByKey(key) {
        return this.formViewOptions.value[key];
    }
}
WidgetSetupViewOptionsComponent.ɵfac = function WidgetSetupViewOptionsComponent_Factory(t) { return new (t || WidgetSetupViewOptionsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.StorageService)); };
WidgetSetupViewOptionsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: WidgetSetupViewOptionsComponent, selectors: [["app-widget-setup-view-options"]], inputs: { formViewOptions: "formViewOptions", options: "options" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 7, vars: 10, consts: [[1, "message"], ["trackBy", "key", 4, "ngFor", "ngForOf"], ["trackBy", "key"], [1, "option-item", 3, "ngSwitch"], [4, "ngSwitchCase"], [3, "label", "value", "sl-input", 4, "ngSwitchCase"], [3, "checked", "sl-change", 4, "ngSwitchCase"], [3, "label", "value", "sl-change", 4, "ngSwitchCase"], [3, "applyButtonText", "cancelButtonText", "value", "onValueChanged", 4, "ngSwitchCase"], [3, "label", "value", "sl-input"], [3, "checked", "sl-change"], ["radio", ""], [3, "label", "value", "sl-change"], [3, "value", 4, "ngFor", "ngForOf"], [3, "value"], [3, "applyButtonText", "cancelButtonText", "value", "onValueChanged"]], template: function WidgetSetupViewOptionsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0)(1, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, WidgetSetupViewOptionsComponent_ng_container_6_Template, 8, 7, "ng-container", 1);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate3"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 4, "widgetSetup#visual.text1"), "\u00A0 ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 6, "widgetSetup#visual.text2"), "\u00A0 ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](5, 8, "widgetSetup#visual.text3"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.options);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgSwitch, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgSwitchCase, devextreme_angular__WEBPACK_IMPORTED_MODULE_5__.DxColorBoxComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: [".option-item[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-small);\n}\nh2[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-large);\n}\ndx-color-box[_ngcontent-%COMP%] {\n  height: 38px;\n}\n.message[_ngcontent-%COMP%] {\n  margin-top: 0;\n  margin-bottom: 25px;\n  font-size: 14px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpZGdldC1zZXR1cC12aWV3LW9wdGlvbnMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxzQ0FBQTtBQUNKO0FBRUE7RUFDSSxvQ0FBQTtBQUFKO0FBR0E7RUFDSSxZQUFBO0FBREo7QUFJQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLGVBQUE7QUFGSiIsImZpbGUiOiJ3aWRnZXQtc2V0dXAtdmlldy1vcHRpb25zLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLm9wdGlvbi1pdGVtIHtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbn1cblxuaDIge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLWxhcmdlKTtcbn1cblxuZHgtY29sb3ItYm94IHtcbiAgICBoZWlnaHQ6IDM4cHg7XG59XG5cbi5tZXNzYWdlIHtcbiAgICBtYXJnaW4tdG9wOiAwO1xuICAgIG1hcmdpbi1ib3R0b206IDI1cHg7XG4gICAgZm9udC1zaXplOiAxNHB4O1xufSJdfQ== */"] });


/***/ }),

/***/ 45266:
/*!*******************************************************************!*\
  !*** ./src/app/components/widget-setup/widget-setup.component.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetSetupComponent": () => (/* binding */ WidgetSetupComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_enums_widget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/enums/widget */ 79982);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! logical-not */ 47002);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/forms */ 48665);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var project_enums_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/enums/common */ 65367);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs/operators */ 82426);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! rxjs/operators */ 21605);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! rxjs/operators */ 53399);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ 202);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! rxjs */ 75249);
/* harmony import */ var project_api_component_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/api/component-api.service */ 52290);
/* harmony import */ var project_services_project_project_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! project/services/project/project.service */ 64439);
/* harmony import */ var project_components_widget_setup_component_adapter_component_adapter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! project/components/widget-setup/component-adapter/component-adapter */ 4953);
/* harmony import */ var project_api_widget_api_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! project/api/widget-api.service */ 93142);
/* harmony import */ var project_pages_project_action_panel_widgets_select_widgets_select_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! project/pages/project/action-panel/widgets-select/widgets-select.service */ 96749);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var _widget_widget_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../widget/widget.component */ 50993);
/* harmony import */ var project_components_dashboard_component_view_actions_actions_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! project/components/dashboard/component-view/actions/actions.component */ 95741);
/* harmony import */ var plmt_aggregation_setup__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! plmt-aggregation-setup */ 40688);
/* harmony import */ var _widget_setup_meta_widget_setup_meta_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./widget-setup-meta/widget-setup-meta.component */ 57750);
/* harmony import */ var _widget_setup_view_options_widget_setup_view_options_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./widget-setup-view-options/widget-setup-view-options.component */ 23857);
/* harmony import */ var project_components_widget_setup_services_dashboard_dataset_api_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! project/components/widget-setup/services/dashboard-dataset-api.service */ 38024);



























function WidgetSetupComponent_app_actions_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelement"](0, "app-actions", 27);
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("dependence", ctx_r0.dependence)("editable", false);
} }
function WidgetSetupComponent_div_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelement"](1, "sl-icon", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](4, 1, "widgetSetup#requared.fields"), "");
} }
function WidgetSetupComponent_div_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelement"](1, "sl-spinner");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
} }
function WidgetSetupComponent_app_widget_13_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "app-widget", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("onDataResponse", function WidgetSetupComponent_app_widget_13_Template_app_widget_onDataResponse_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵrestoreView"](_r9); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵresetView"](ctx_r8.onDataResponse.emit($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("dependence", ctx_r3.dependence);
} }
const _c0 = function (a0) { return { error: a0 }; };
function WidgetSetupComponent_ng_container_20_p_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind2"](2, 1, "widgetSetup#loadComponentsError", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpureFunction1"](4, _c0, ctx_r10.responseServerError == null ? null : ctx_r10.responseServerError.error == null ? null : ctx_r10.responseServerError.error.message)));
} }
function WidgetSetupComponent_ng_container_20_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](2, 1, "#error#unknownError"));
} }
function WidgetSetupComponent_ng_container_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](1, WidgetSetupComponent_ng_container_20_p_1_Template, 3, 6, "p", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](2, WidgetSetupComponent_ng_container_20_ng_template_2_Template, 3, 3, "ng-template", null, 33, _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵreference"](3);
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx_r4.responseServerError.error == null ? null : ctx_r4.responseServerError.error.httpCode)("ngIfElse", _r11);
} }
function WidgetSetupComponent_plmt_aggregation_setup_21_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "plmt-aggregation-setup", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("change", function WidgetSetupComponent_plmt_aggregation_setup_21_Template_plmt_aggregation_setup_change_0_listener($event) { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵrestoreView"](_r16); const i_r14 = restoredCtx.index; const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵresetView"](ctx_r15.setDataOption($event, i_r14)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
} if (rf & 2) {
    const config_r13 = ctx.$implicit;
    const i_r14 = ctx.index;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("config", config_r13)("dataOption", ctx_r5.aggregationSetupDataOptions[i_r14]);
} }
function WidgetSetupComponent_sl_tab_27_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "sl-tab", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](2, 1, "widgetSetup#accessRights"), " ");
} }
function WidgetSetupComponent_sl_tab_panel_30_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "sl-tab-panel", 36)(1, "core-form", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelement"](2, "core-access", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("data", ctx_r7.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("settings", ctx_r7.accessSettings);
} }
const MAX_NAME_LENGTH = 250;
class WidgetSetupComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_15__.SubscribableComponent {
    constructor(dashboardDatasetApiService, componentApiService, projectService, componentAdapter, formService, widgetApiService, responseErrorService, widgetsSelectService) {
        super();
        this.dashboardDatasetApiService = dashboardDatasetApiService;
        this.componentApiService = componentApiService;
        this.projectService = projectService;
        this.componentAdapter = componentAdapter;
        this.formService = formService;
        this.widgetApiService = widgetApiService;
        this.responseErrorService = responseErrorService;
        this.widgetsSelectService = widgetsSelectService;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.AccessRight;
        this.save = new _angular_core__WEBPACK_IMPORTED_MODULE_14__.EventEmitter();
        this.onDataResponse = new _angular_core__WEBPACK_IMPORTED_MODULE_14__.EventEmitter();
        this.isOpen = false;
        this.accessSettings = {
            groups: [],
            users: [],
        };
        this.accessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.AccessRight.Full;
        this.aggregationSetupConfigs = [];
        this.aggregationSetupDataOptions = [];
        this.viewOptions = [];
        this.dependenceUid = '';
        this.datasetColumnMap = {};
        this.visibleViewOptions = false;
        this.changedFormFields = {};
        this.form = this.formService.form({
            id: [],
            name: [
                null,
                [plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.stringValidator)({ min: 1, max: MAX_NAME_LENGTH })],
            ],
            description: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_17__.Validators.maxLength(250)]],
            component_id: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.required]],
            data_options: new _angular_forms__WEBPACK_IMPORTED_MODULE_17__.UntypedFormControl([]),
            view_options: new _angular_forms__WEBPACK_IMPORTED_MODULE_17__.UntypedFormControl([]),
            users: new _angular_forms__WEBPACK_IMPORTED_MODULE_17__.UntypedFormArray([]),
            groups: new _angular_forms__WEBPACK_IMPORTED_MODULE_17__.UntypedFormArray([]),
        });
        this.formViewOptions = this.form.get('view_options');
        this.RequestState = project_enums_common__WEBPACK_IMPORTED_MODULE_2__.RequestState;
        this.responseServerError = null;
        this.saveButtonClicked = false;
        this.componentsProvider = (search, offset) => {
            this.clearErrors();
            return this.componentApiService.list({ search, offset }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_18__.catchError)((error) => {
                if (error?.status === 500 /* HttpStatusCode.InternalServerError */) {
                    this.responseServerError = error;
                    return (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.of)({ rows: [], total: 0, users: {} });
                }
                else {
                    this.responseErrorService.show.emit({
                        responseError: error,
                        key: 'widgets.notification.error.getComponents',
                    });
                    throw error;
                }
            }));
        };
    }
    get isSubmitDisabled() {
        if (this.saveButtonClicked)
            return true;
        const formValue = this.form.value;
        if (!formValue.component_id || !formValue.name) {
            return true;
        }
        const requiredFields = [];
        this.aggregationSetupConfigs.forEach((item) => {
            if (item.validation && item.validation.requiredEvery) {
                item.validation.requiredEvery.forEach((validationItem) => requiredFields.push(validationItem));
            }
        });
        if (requiredFields.length < 1) {
            return false;
        }
        if (!this.aggregationSetupDataOptions ||
            this.aggregationSetupDataOptions.length < 1) {
            return true;
        }
        let isValid = true;
        this.aggregationSetupDataOptions.forEach((option) => {
            option.blocks.forEach((block) => {
                const columnLength = block.columns?.length || 0;
                if (requiredFields.includes(block.key) && columnLength < 1) {
                    isValid = false;
                }
            });
        });
        if (!isValid) {
            return true;
        }
        return false;
    }
    ngOnInit() {
        this.subscriptions = [
            this.formViewOptions.valueChanges.subscribe(() => {
                if (!this.dependence) {
                    return;
                }
                const widget = this.dependence.model;
                if (widget) {
                    widget.view_options = this.formViewOptions.value;
                    this.dependence?.onChange?.emit();
                }
            }),
        ];
    }
    show(widget, uid) {
        this.reset();
        this.dependenceUid = uid || '';
        this.isOpen = true;
        if (widget) {
            this.dashboardDatasetApiService.widgetId = widget.id;
            this.loadWidget(widget.id);
        }
        else {
            this.accessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.AccessRight.Full;
            this.reset();
        }
    }
    hide() {
        this.widgetsSelectService.dependence.next(this.dependence);
        this.widgetsSelectService.showWidget();
        this.isOpen = false;
    }
    resetUnusedFields(option) {
        option.sort = option.sort || [];
        option.filters = option.filters || [];
        option.pivot_params = (option.pivot_params || null);
        option.payload = option.payload || {};
    }
    submit() {
        if (this.form.valid) {
            this.saveButtonClicked = true;
            // NOTE: скрываем виджет на странице только по сабмиту
            // Если при открытии скрывать виджет на странице, то почему-то (?) app-widget cсылается не на тот widgetRef
            // хоть сам компонент и был пересоздан
            // Учесть при переписывании флоу дашбордов
            this.widgetsSelectService.hideWidget();
            const params = (this.form.state === plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.FormState.Update
                ? this.getDirtyValues()
                : this.form.value);
            const changedDataOptions = this.aggregationSetupDataOptions.filter((option) => option.dataset_id !== 0);
            if (changedDataOptions.length) {
                params['data_options'] = changedDataOptions;
            }
            params['data_options'].forEach((option, index) => {
                this.resetUnusedFields(option);
                this.removeIncorrectColumnsFromOtherData(option);
            });
            if (this.form.controls['id'].value) {
                params['id'] = this.form.controls['id'].value;
            }
            this.widgetApiService.save(params).subscribe({
                next: ({ row }) => {
                    const dep = this.projectService.get(this.dependenceUid);
                    if (dep && this.dependence) {
                        dep.model = row;
                        this.projectService.loadData([dep]).subscribe();
                        this.projectService.updateLayerObjects(dep, this.dependence);
                    }
                    const created = this.form.state !== plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.FormState.Update;
                    this.save.emit({
                        widget: row,
                        created: created,
                    });
                    this.hide();
                    this.saveButtonClicked = false;
                },
                error: (error) => {
                    this.saveButtonClicked = false;
                    this.responseErrorService.show.emit({
                        responseError: error,
                        key: `widget#notification.error.${this.form.state}`,
                    });
                },
            });
        }
        else {
            this.formService.showLocalErrors(this.form);
        }
    }
    onComponentSelect(component) {
        if (component) {
            this.dependence = undefined;
            if (this.component)
                this.formViewOptions.patchValue({});
            this.form.patchValue({ component_id: component.id });
            this.aggregationSetupDataOptions.forEach((item) => {
                item.payload = {};
            });
        }
        this.component = component;
        this.loadWidgetConfigs();
    }
    setDataOption(dataOption, i) {
        const oldDatasetId = this.aggregationSetupDataOptions[i].dataset_id;
        this.aggregationSetupDataOptions[i] = dataOption;
        if (oldDatasetId && oldDatasetId !== dataOption.dataset_id) {
            this.aggregationSetupDataOptions[i].payload = {};
        }
        const widget = {
            data_options: (0,lodash__WEBPACK_IMPORTED_MODULE_3__.cloneDeep)(this.makeDataOptions()),
            view_options: this.formViewOptions.value,
            component: this.component,
            access_right: this.accessRight,
        };
        if (widget.data_options.length) {
            if (dataOption.dataset_id) {
                this.getDatasetColumns(widget.data_options);
            }
            let dep = this.projectService.makeDependence({
                uid: this.dependence?.uid,
                type: project_enums_widget__WEBPACK_IMPORTED_MODULE_0__.WidgetType.Widget,
                payload: {},
                gridster_settings: {
                    x: 0,
                    y: 0,
                    rows: 0,
                    cols: 0,
                },
            }, widget, this.dependence);
            this.projectService.loadData([dep]).subscribe();
            this.dependence = dep;
        }
    }
    getDirtyValues() {
        const dirtyValues = {};
        Object.keys(this.changedFormFields).forEach((key) => {
            dirtyValues[key] = this.form.controls[key].value;
        });
        return dirtyValues;
    }
    loadWidgetConfigs() {
        this.viewOptions = [];
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(this.component))
            return undefined;
        this.componentAdapter.activate(this.component).subscribe({
            next: ({ config, dataOptions, dataConfigs }) => {
                this.aggregationSetupConfigs = dataConfigs;
                this.aggregationSetupDataOptions = dataOptions;
                if (config.options) {
                    this.formViewOptions.patchValue({
                        ...config.options.default,
                        ...this.formViewOptions.value,
                    });
                    this.viewOptions = config.options.provider(this.formViewOptions.value);
                }
                if (this.form.value.data_options) {
                    if (this.form.value.data_options.length) {
                        this.setDataOption(this.form.value.data_options[0], 0);
                    }
                }
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'widget#notification.error.datasets',
                });
            },
        });
    }
    makeDataOptions() {
        const result = [];
        for (let i = 0, lim = this.aggregationSetupConfigs.length; i < lim; i++) {
            const dataConfig = this.aggregationSetupConfigs[i];
            const dataOption = this.aggregationSetupDataOptions.find(({ key }) => dataConfig.key === key);
            const { requiredEvery, requiredSome } = dataConfig.validation || {};
            if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(dataOption) && (requiredEvery || requiredSome))
                continue;
            if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(dataOption))
                continue;
            if (requiredEvery) {
                const valid = requiredEvery.every((key) => {
                    const block = dataOption.blocks.find((block) => block.key === key);
                    return block?.columns?.length || 0;
                });
                if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(valid))
                    return [];
            }
            if (requiredSome) {
                const valid = requiredSome.some((key) => {
                    const block = dataOption.blocks.find((block) => block.key === key);
                    return block?.columns.length;
                });
                if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(valid))
                    return [];
            }
            result.push(dataOption);
        }
        return result;
    }
    reset(widget) {
        this.dependence = undefined;
        this.component = undefined;
        this.aggregationSetupConfigs = [];
        this.aggregationSetupDataOptions = [];
        this.viewOptions = [];
        this.visibleViewOptions = false;
        this.form.reset(widget);
        if (widget && widget.component) {
            this.onComponentSelect(widget.component);
        }
        else {
            this.accessSettings = {
                groups: [],
                users: [],
            };
        }
        if (widget)
            this.subscribeToFormChanges();
    }
    subscribeToFormChanges() {
        this.form.valueChanges
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_20__.pairwise)(), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_21__.map)(([oldState, newState]) => {
            for (const key in newState) {
                if (oldState[key] !== undefined &&
                    !(0,lodash__WEBPACK_IMPORTED_MODULE_3__.isEqual)(oldState[key], newState[key])) {
                    this.changedFormFields[key] = newState[key];
                }
            }
            return this.changedFormFields;
        }))
            .subscribe();
    }
    loadWidget(id) {
        this.widgetApiService.get(id).subscribe({
            next: ({ row: widget }) => {
                this.accessRight = widget.access_right;
                this.accessSettings = widget;
                this.reset(widget);
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'widget#notification.error.widgetInformation',
                });
            },
        });
    }
    removeIncorrectColumnsFromOtherData(option) {
        const currentOptionColunms = this.datasetColumnMap[option.key];
        if (!currentOptionColunms)
            return;
        if (option.sort?.length) {
            option.sort = option.sort.filter((item) => currentOptionColunms.includes(item.column_id));
        }
        if (option.filters?.length) {
            option.filters = option.filters.filter((item) => currentOptionColunms.includes(item.column_id));
        }
        if (!option.payload?.drilldown) {
            return;
        }
        if (!currentOptionColunms.includes(option.payload.drilldown.source)) {
            // NOTE: надо отправить на сервер именно пустой drilldown, undefined не подойдет
            // @ts-ignore
            option.payload.drilldown = null;
            return;
        }
        if (option.payload.drilldown.levels) {
            option.payload.drilldown.levels =
                option.payload.drilldown.levels.filter((item) => currentOptionColunms.includes(item));
        }
    }
    getDatasetColumns(datasetOptions) {
        const options = datasetOptions.map((item) => ({
            dataset_id: item.dataset_id,
            key: item.key,
        }));
        this.dashboardDatasetApiService
            .list({
            include_ids: datasetOptions.map((item) => item.dataset_id),
            load_columns: true,
        })
            .subscribe((response) => {
            options.forEach((item) => {
                const column = response.rows.find((row) => row.id === item.dataset_id);
                if (column) {
                    this.datasetColumnMap[item.key] = column?.columns.map((column) => column.id);
                }
            });
        });
    }
    clearErrors() {
        this.responseServerError = null;
    }
}
WidgetSetupComponent.ɵfac = function WidgetSetupComponent_Factory(t) { return new (t || WidgetSetupComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](project_api_component_api_service__WEBPACK_IMPORTED_MODULE_4__.ComponentApiService), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](project_services_project_project_service__WEBPACK_IMPORTED_MODULE_5__.ProjectService), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](project_components_widget_setup_component_adapter_component_adapter__WEBPACK_IMPORTED_MODULE_6__.ComponentAdapter), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](project_api_widget_api_service__WEBPACK_IMPORTED_MODULE_7__.WidgetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdirectiveInject"](project_pages_project_action_panel_widgets_select_widgets_select_service__WEBPACK_IMPORTED_MODULE_8__.WidgetsSelectService)); };
WidgetSetupComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵdefineComponent"]({ type: WidgetSetupComponent, selectors: [["app-widget-setup"]], outputs: { save: "save", onDataResponse: "onDataResponse" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵInheritDefinitionFeature"]], decls: 38, vars: 35, consts: [["placement", "bottom", 3, "open", "openChange"], [1, "preview"], [3, "form"], [1, "preview-actions"], ["variant", "text", 1, "switch-btn", 3, "disabled", "click"], [1, "inner"], [1, "actions", 3, "mousedown", "touchstart"], [3, "dependence", "editable", 4, "ngIf"], [1, "widget-container"], ["class", "empty", 4, "ngIf"], ["class", "spinner-overlay", 4, "ngIf"], [3, "dependence", "onDataResponse", 4, "ngIf"], [1, "setting"], [1, "setting-inner"], [1, "setting-options"], ["name", "x-lg", 1, "close-btn", 3, "click"], ["viewKey", "name", 3, "label", "suggestionsProvider", "selected", "onSelect"], [4, "ngIf"], ["trackBy", "key", 3, "config", "dataOption", "change", 4, "ngFor", "ngForOf"], ["slot", "nav", "panel", "visual"], ["slot", "nav", "panel", "access", 4, "ngIf"], ["name", "visual"], [3, "options", "formViewOptions"], ["name", "access", 4, "ngIf"], [1, "settings-footer"], [1, "cancel", 3, "click"], ["variant", "primary", 3, "disabled", "click"], [3, "dependence", "editable"], [1, "empty"], ["name", "exclamation-square"], [1, "spinner-overlay"], [3, "dependence", "onDataResponse"], [4, "ngIf", "ngIfElse"], ["unknownError", ""], ["trackBy", "key", 3, "config", "dataOption", "change"], ["slot", "nav", "panel", "access"], ["name", "access"], [3, "data"], [3, "settings"]], template: function WidgetSetupComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](0, "sl-drawer", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("openChange", function WidgetSetupComponent_Template_sl_drawer_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelement"](2, "app-widget-setup-meta", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](3, "div", 3)(4, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("click", function WidgetSetupComponent_Template_sl_button_click_4_listener() { return ctx.visibleViewOptions = !ctx.visibleViewOptions; });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](7, "div", 5)(8, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("mousedown", function WidgetSetupComponent_Template_div_mousedown_8_listener($event) { return $event.stopPropagation(); })("touchstart", function WidgetSetupComponent_Template_div_touchstart_8_listener($event) { return $event.stopPropagation(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](9, WidgetSetupComponent_app_actions_9_Template, 1, 2, "app-actions", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](10, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](11, WidgetSetupComponent_div_11_Template, 5, 3, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](12, WidgetSetupComponent_div_12_Template, 2, 0, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](13, WidgetSetupComponent_app_widget_13_Template, 1, 1, "app-widget", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](14, "div", 12)(15, "div", 13)(16, "div", 14)(17, "sl-icon-button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("click", function WidgetSetupComponent_Template_sl_icon_button_click_17_listener() { return ctx.hide(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](18, "core-suggest", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("onSelect", function WidgetSetupComponent_Template_core_suggest_onSelect_18_listener($event) { return ctx.onComponentSelect($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](20, WidgetSetupComponent_ng_container_20_Template, 4, 2, "ng-container", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](21, WidgetSetupComponent_plmt_aggregation_setup_21_Template, 1, 2, "plmt-aggregation-setup", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](22, "div")(23, "sl-tab-group")(24, "sl-tab", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](26, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](27, WidgetSetupComponent_sl_tab_27_Template, 3, 3, "sl-tab", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](28, "sl-tab-panel", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelement"](29, "app-widget-setup-view-options", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtemplate"](30, WidgetSetupComponent_sl_tab_panel_30_Template, 3, 2, "sl-tab-panel", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](31, "div", 24)(32, "sl-button", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("click", function WidgetSetupComponent_Template_sl_button_click_32_listener() { return ctx.hide(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementStart"](35, "sl-button", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵlistener"]("click", function WidgetSetupComponent_Template_sl_button_click_35_listener() { return ctx.submit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtext"](36);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipe"](37, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵelementEnd"]()()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("disabled", !ctx.dependence);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](6, 25, ctx.visibleViewOptions ? "widgetSetup#back" : "widgetSetup#settings"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx.dependence);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", !ctx.dependence);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx.dependence && ctx.dependence.state === ctx.RequestState.Wait);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx.dependence);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵclassProp"]("hidden", ctx.visibleViewOptions);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](19, 27, "widgetSetup#component"))("suggestionsProvider", ctx.componentsProvider)("selected", ctx.component);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx.responseServerError);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngForOf", ctx.aggregationSetupConfigs);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵclassProp"]("hidden", !ctx.visibleViewOptions);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](26, 29, "widgetSetup#visualization"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx.accessRight === ctx.AccessRight.Full);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("options", ctx.viewOptions)("formViewOptions", ctx.formViewOptions);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("ngIf", ctx.accessRight === ctx.AccessRight.Full);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](34, 31, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵproperty"]("disabled", ctx.isSubmitDisabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_14__["ɵɵpipeBind1"](37, 33, "$.save"), " ");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_22__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_22__.NgIf, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_23__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_23__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_23__.OpenDirective, _widget_widget_component__WEBPACK_IMPORTED_MODULE_9__.WidgetComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.SuggestComponent, project_components_dashboard_component_view_actions_actions_component__WEBPACK_IMPORTED_MODULE_10__.ActionsComponent, plmt_aggregation_setup__WEBPACK_IMPORTED_MODULE_24__.AggregationSetupComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.AccessComponent, _widget_setup_meta_widget_setup_meta_component__WEBPACK_IMPORTED_MODULE_11__.WidgetSetupMetaComponent, _widget_setup_view_options_widget_setup_view_options_component__WEBPACK_IMPORTED_MODULE_12__.WidgetSetupViewOptionsComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_16__.TranslatePipe], styles: ["sl-drawer[_ngcontent-%COMP%] {\n  --size: 100vh;\n  --body-spacing: 0;\n}\nsl-drawer[_ngcontent-%COMP%]::part(header) {\n  display: none;\n}\nsl-drawer[_ngcontent-%COMP%]::part(body) {\n  display: grid;\n  grid-template-columns: repeat(2, 50%);\n  height: 100vh;\n  overflow: hidden;\n}\nsl-drawer[_ngcontent-%COMP%]::part(panel) {\n  height: 100vh;\n  overflow: hidden;\n}\n.preview[_ngcontent-%COMP%], .setting[_ngcontent-%COMP%] {\n  height: 100vh;\n  padding: 0 var(--sl-spacing-3x-large);\n  box-sizing: border-box;\n}\n.preview[_ngcontent-%COMP%] {\n  display: flex;\n  flex-grow: 1;\n  flex-direction: column;\n  padding: var(--sl-spacing-3x-large);\n  background: var(--sl-color-neutral-400);\n}\n.preview-actions[_ngcontent-%COMP%] {\n  text-align: right;\n  margin-top: var(--sl-spacing-x-large);\n  margin-bottom: var(--sl-spacing-medium);\n}\n.setting[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  padding-bottom: 0;\n  height: 100vh;\n  overflow: auto;\n}\n.setting[_ngcontent-%COMP%]   core-suggest[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: var(--sl-spacing-large);\n}\n.setting-inner[_ngcontent-%COMP%] {\n  position: relative;\n  flex-grow: 1;\n}\n.setting-options[_ngcontent-%COMP%] {\n  position: relative;\n  margin-top: var(--sl-spacing-large);\n  padding-top: var(--sl-spacing-3x-large);\n}\n.close-btn[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 20px;\n  right: -10px;\n}\n.close-btn[_ngcontent-%COMP%]::part(base) {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-900);\n}\n.settings-options[_ngcontent-%COMP%] {\n  height: 100%;\n}\n.settings-footer[_ngcontent-%COMP%] {\n  position: sticky;\n  bottom: 0;\n  padding-right: var(--sl-spacing-small);\n  padding-top: var(--sl-spacing-3x-large);\n  padding-bottom: var(--sl-spacing-3x-large);\n  text-align: right;\n  background: #ffffff;\n  z-index: 2;\n}\n.settings-footer[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-x-small);\n}\n.widget-container[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-grow: 1;\n  border: 1px dashed var(--sl-color-secondary-200);\n}\n.spinner-overlay[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 3;\n  width: 100%;\n  height: 100%;\n  left: 0;\n  top: 0;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n.empty[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  color: var(--sl-color-border-and-bg-500);\n}\n.empty[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-3x-large);\n  margin-bottom: var(--sl-spacing-large);\n}\n.empty[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  max-width: 305px;\n  text-align: center;\n}\nsl-tab-group[_ngcontent-%COMP%] {\n  padding-top: var(--sl-spacing-large);\n  color: var(--sl-color-border-and-bg-600);\n}\nsl-tab-group[_ngcontent-%COMP%]::part(nav) {\n  position: sticky;\n  top: 0;\n  z-index: 2;\n  background: var(--sl-color-neutral-0);\n}\nsl-tab-group[_ngcontent-%COMP%]::part(tabs) {\n  flex: 0;\n  border-bottom-color: var(--sl-color-border-and-bg-100);\n}\nsl-tab-group[_ngcontent-%COMP%]::part(active-tab-indicator) {\n  border-bottom-color: var(--sl-color-primary-500);\n}\nsl-tab-panel[_ngcontent-%COMP%] {\n  margin-top: calc(var(--sl-spacing-large) + var(--sl-spacing-2x-small));\n  padding-right: var(--sl-spacing-x-small);\n}\nsl-tab-panel[_ngcontent-%COMP%]::part(base) {\n  padding-top: 0;\n}\nsl-tab[_ngcontent-%COMP%]::part(base) {\n  padding: var(--sl-spacing-medium) var(--sl-spacing-large);\n  font-size: 14px;\n  line-height: 29px;\n}\nsl-tab[active][_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-primary-500);\n}\n.switch-btn[_ngcontent-%COMP%]::part(label) {\n  font-weight: var(--sl-font-weight-semibold);\n  font-size: calc(var(--sl-font-size-small) + 1px);\n  line-height: 28px;\n}\n.inner[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n  position: relative;\n  height: 100%;\n}\n.inner[_ngcontent-%COMP%]   .actions[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 3;\n  top: -200%;\n  right: var(--sl-spacing-2x-small);\n  transition: top 0.2s;\n  background: var(--sl-color-neutral-0);\n}\n.inner[_ngcontent-%COMP%]:hover   .actions[_ngcontent-%COMP%] {\n  top: var(--sl-spacing-2x-small);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_25__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_26__.WatchChanges)()
], WidgetSetupComponent.prototype, "isOpen", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_25__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_26__.WatchChanges)()
], WidgetSetupComponent.prototype, "dependence", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_25__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_26__.WatchChanges)()
], WidgetSetupComponent.prototype, "accessSettings", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_25__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_26__.WatchChanges)()
], WidgetSetupComponent.prototype, "accessRight", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_25__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_26__.WatchChanges)()
], WidgetSetupComponent.prototype, "aggregationSetupConfigs", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_25__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_26__.WatchChanges)()
], WidgetSetupComponent.prototype, "responseServerError", void 0);


/***/ }),

/***/ 86366:
/*!****************************************************************!*\
  !*** ./src/app/components/widget-setup/widget-setup.module.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetSetupModule": () => (/* binding */ WidgetSetupModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _widget_setup_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./widget-setup.component */ 45266);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/components/widget/widget.module */ 42975);
/* harmony import */ var plmt_aggregation_setup__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! plmt-aggregation-setup */ 40688);
/* harmony import */ var project_components_widget_setup_component_adapter_component_adapter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/components/widget-setup/component-adapter/component-adapter */ 4953);
/* harmony import */ var project_components_widget_setup_component_adapter_adapter_legacy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/components/widget-setup/component-adapter/adapter.legacy */ 31332);
/* harmony import */ var _widget_setup_meta_widget_setup_meta_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./widget-setup-meta/widget-setup-meta.component */ 57750);
/* harmony import */ var _widget_setup_view_options_widget_setup_view_options_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widget-setup-view-options/widget-setup-view-options.component */ 23857);
/* harmony import */ var project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! project/components/dashboard/dashboard.module */ 75649);
/* harmony import */ var devextreme_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! devextreme-angular */ 2601);
/* harmony import */ var project_components_widget_setup_services_dashboard_dataset_api_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! project/components/widget-setup/services/dashboard-dataset-api.service */ 38024);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 64565);














class WidgetSetupModule {
}
WidgetSetupModule.ɵfac = function WidgetSetupModule_Factory(t) { return new (t || WidgetSetupModule)(); };
WidgetSetupModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineNgModule"]({ type: WidgetSetupModule });
WidgetSetupModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineInjector"]({ providers: [
        project_components_widget_setup_component_adapter_component_adapter__WEBPACK_IMPORTED_MODULE_2__.ComponentAdapter,
        project_components_widget_setup_component_adapter_adapter_legacy__WEBPACK_IMPORTED_MODULE_3__.AdapterLegacy,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.providePageTranslations)({
            sources: ['assets/i18n/', 'assets/i18n/components/dashboard/'],
        }),
        {
            provide: plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.DatasetApiService,
            useClass: project_components_widget_setup_services_dashboard_dataset_api_service__WEBPACK_IMPORTED_MODULE_7__.DashboardDatasetApiService,
        },
    ], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_10__.CommonModule,
        devextreme_angular__WEBPACK_IMPORTED_MODULE_11__.DxColorBoxModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_12__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TranslateModule,
        project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_1__.WidgetModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.SuggestModule,
        project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_6__.DashboardModule,
        plmt_aggregation_setup__WEBPACK_IMPORTED_MODULE_13__.AggregationSetupModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.FormModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.NotifyModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵsetNgModuleScope"](WidgetSetupModule, { declarations: [_widget_setup_component__WEBPACK_IMPORTED_MODULE_0__.WidgetSetupComponent,
        _widget_setup_meta_widget_setup_meta_component__WEBPACK_IMPORTED_MODULE_4__.WidgetSetupMetaComponent,
        _widget_setup_view_options_widget_setup_view_options_component__WEBPACK_IMPORTED_MODULE_5__.WidgetSetupViewOptionsComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_10__.CommonModule,
        devextreme_angular__WEBPACK_IMPORTED_MODULE_11__.DxColorBoxModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_12__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TranslateModule,
        project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_1__.WidgetModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.SuggestModule,
        project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_6__.DashboardModule,
        plmt_aggregation_setup__WEBPACK_IMPORTED_MODULE_13__.AggregationSetupModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.FormModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.NotifyModule], exports: [_widget_setup_component__WEBPACK_IMPORTED_MODULE_0__.WidgetSetupComponent] }); })();


/***/ }),

/***/ 40688:
/*!*********************************************************************************!*\
  !*** ./node_modules/plmt-aggregation-setup/fesm2020/plmt-aggregation-setup.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AggregationSetupComponent": () => (/* binding */ AggregationSetupComponent),
/* harmony export */   "AggregationSetupErrorType": () => (/* binding */ AggregationSetupErrorType),
/* harmony export */   "AggregationSetupModule": () => (/* binding */ AggregationSetupModule),
/* harmony export */   "LIMIT_DEFAULT": () => (/* binding */ LIMIT_DEFAULT)
/* harmony export */ });
/* harmony import */ var _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/cdk/drag-drop */ 94862);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ng-track-by */ 61245);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! logical-not */ 47002);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 87554);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs */ 78603);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs */ 82426);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 34122);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs */ 53399);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! plmt-core-library/filters */ 57991);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var polymatica_widget_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! polymatica-widget/config */ 36606);




















function DropzoneHeaderComponent_span_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, "*");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}

function DropzoneHeaderComponent_small_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "small");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "$$.plmt.aggregationSetup.no.limit"), " ");
  }
}

const _c0 = function (a0) {
  return {
    limit: a0
  };
};

function DropzoneHeaderComponent_small_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "small");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind2"](2, 1, "$$.plmt.aggregationSetup.limit", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](4, _c0, ctx_r2.max)), " ");
  }
}

function DropzoneHeaderComponent_ng_container_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
  }
}

function ColumnItemComponent_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
  }
}

function ColumnItemComponent_sl_icon_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-icon-button", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function ColumnItemComponent_sl_icon_button_3_Template_sl_icon_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r2.remove.emit());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}

const _c1 = function (a0) {
  return {
    $implicit: a0
  };
};

const _c2 = ["*"];

function DropzoneComponent_lib_column_item_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-column-item", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("remove", function DropzoneComponent_lib_column_item_1_Template_lib_column_item_remove_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r3);
      const column_r1 = restoredCtx.$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r2.remove(column_r1));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("column", column_r1)("extraTemplate", ctx_r0.columnExtraTemplate);
  }
}

function SelectAggregateFnComponent_sl_menu_item_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-menu-item", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const fn_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", fn_r1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 2, "$$.plmt.aggregationSetup.aggrFn." + fn_r1), " ");
  }
}

function BlockDataComponent_ng_template_2_lib_select_aggregate_fn_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-select-aggregate-fn", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockDataComponent_ng_template_2_lib_select_aggregate_fn_0_Template_lib_select_aggregate_fn_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r6);
      const column_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r4.onAggrFnChange(column_r2.id, $event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("column", column_r2)("value", ctx_r3.getAggregateFunction(column_r2.id));
  }
}

function BlockDataComponent_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, BlockDataComponent_ng_template_2_lib_select_aggregate_fn_0_Template, 1, 2, "lib-select-aggregate-fn", 3);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r1.block.aggregation);
  }
}

function BlockDrilldownComponent_sl_menu_item_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-menu-item", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r2 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", column_r2.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", column_r2.name, " ");
  }
}

function BlockDrilldownComponent_ng_container_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](1, "lib-dropzone-header", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "lib-dropzone", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockDrilldownComponent_ng_container_4_Template_lib_dropzone_change_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r3.onLevelsChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("max", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("columnIds", ctx_r1.value.levels)("dropEnterPredicate", ctx_r1.dropzonePredicate);
  }
}

const _c3 = function () {
  return [];
};

function BlockFiltersComponent_core_filters_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "core-filters", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockFiltersComponent_core_filters_2_Template_core_filters_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r1.change.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("dataset", ctx_r0.dataset)("value", ctx_r0.value || _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction0"](2, _c3));
  }
}

function BlockHeatmapComponent_ng_template_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dropdown");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](1, "sl-icon-button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}

function BlockSortComponent_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-tooltip", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](2, "sl-icon", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("content", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 1, "$$.plmt.aggregationSetup.sort.tooltip"));
  }
}

function BlockSortComponent_ng_template_5_lib_select_aggregate_fn_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-select-aggregate-fn", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockSortComponent_ng_template_5_lib_select_aggregate_fn_0_Template_lib_select_aggregate_fn_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r9);
      const column_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r7.onChangeArrgegateFn(column_r4.id, $event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const fn_r6 = ctx.ngIf;
    const column_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("column", column_r4)("value", fn_r6);
  }
}

function BlockSortComponent_ng_template_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, BlockSortComponent_ng_template_5_lib_select_aggregate_fn_0_Template, 1, 2, "lib-select-aggregate-fn", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "sl-icon", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function BlockSortComponent_ng_template_5_Template_sl_icon_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r12);
      const column_r4 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r11.onChangeDirection(column_r4.id));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r4 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r3.getAggregateFn(column_r4.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("name", ctx_r3.getDirectionIcon(column_r4.id));
  }
}

function AggregationSetupComponent_sl_button_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-button", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "$$.plmt.aggregationSetup.dataset.add"), " ");
  }
}

function AggregationSetupComponent_lib_column_item_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-column-item", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("cdkDragStarted", function AggregationSetupComponent_lib_column_item_10_Template_lib_column_item_cdkDragStarted_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r4.onDragStart($event));
    })("cdkDragEnded", function AggregationSetupComponent_lib_column_item_10_Template_lib_column_item_cdkDragEnded_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r5);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r6.onDragEnd());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("cdkDragData", column_r3)("column", column_r3)("removable", false);
  }
}

function AggregationSetupComponent_div_11_lib_block_data_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-block-data", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function AggregationSetupComponent_div_11_lib_block_data_2_Template_lib_block_data_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r13);
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r12.onDataOptionBlockChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const block_r10 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("block", block_r10)("value", ctx_r7.getDataOptionBlock(block_r10))("required", ctx_r7.isDataOptionBlockRequired(block_r10));
  }
}

function AggregationSetupComponent_div_11_lib_block_drilldown_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-block-drilldown", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function AggregationSetupComponent_div_11_lib_block_drilldown_5_Template_lib_block_drilldown_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r15);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r14.onDrilldownChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", ctx_r8.getDrilldown())("sourceColumnIds", ctx_r8.getDrilldownColumnIds())("dataBlocks", ctx_r8.dataOption.blocks);
  }
}

function AggregationSetupComponent_div_11_lib_block_heatmap_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-block-heatmap", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function AggregationSetupComponent_div_11_lib_block_heatmap_6_Template_lib_block_heatmap_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r17);
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r16.onHeatmapChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("config", ctx_r9.config.heatmap)("items", ctx_r9.getHeatmap());
  }
}

function AggregationSetupComponent_div_11_Template(rf, ctx) {
  if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 10)(1, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, AggregationSetupComponent_div_11_lib_block_data_2_Template, 1, 3, "lib-block-data", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "lib-block-filters", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function AggregationSetupComponent_div_11_Template_lib_block_filters_change_3_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r19);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r18.onFiltersChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "lib-block-sort", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function AggregationSetupComponent_div_11_Template_lib_block_sort_change_4_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r19);
      const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r20.onSortChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, AggregationSetupComponent_div_11_lib_block_drilldown_5_Template, 1, 3, "lib-block-drilldown", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, AggregationSetupComponent_div_11_lib_block_heatmap_6_Template, 1, 2, "lib-block-heatmap", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "lib-block-limit", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("valueChange", function AggregationSetupComponent_div_11_Template_lib_block_limit_valueChange_7_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r19);
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r21.onLimitChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r2.blocks);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("dataset", ctx_r2.dataset)("value", ctx_r2.dataOption.filters || _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction0"](8, _c3));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", ctx_r2.dataOption.sort || _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction0"](9, _c3))("dataBlocks", ctx_r2.dataOption.blocks);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r2.config.drilldown);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r2.config.heatmap);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", ctx_r2.dataOption.limit);
  }
}

class DropzoneHeaderComponent {
  constructor() {
    this.required = false;
    this.extraTemplate = null;
  }

}

DropzoneHeaderComponent.ɵfac = function DropzoneHeaderComponent_Factory(t) {
  return new (t || DropzoneHeaderComponent)();
};

DropzoneHeaderComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: DropzoneHeaderComponent,
  selectors: [["lib-dropzone-header"]],
  inputs: {
    label: "label",
    required: "required",
    max: "max",
    extraTemplate: "extraTemplate"
  },
  decls: 7,
  vars: 5,
  consts: [[4, "ngIf"], [4, "ngTemplateOutlet"]],
  template: function DropzoneHeaderComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "h5")(1, "span");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, DropzoneHeaderComponent_span_3_Template, 2, 0, "span", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, DropzoneHeaderComponent_small_4_Template, 3, 3, "small", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, DropzoneHeaderComponent_small_5_Template, 3, 6, "small", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, DropzoneHeaderComponent_ng_container_6_Template, 1, 0, "ng-container", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", ctx.label, " ");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.required);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.max === 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.max > 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", ctx.extraTemplate);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]{display:block}h5[_ngcontent-%COMP%]{display:flex;justify-content:space-between;margin:0;font-size:var(--sl-font-size-small);font-weight:var(--sl-font-weight-semibold);margin-bottom:var(--sl-spacing-2x-small)}h5[_ngcontent-%COMP%]   small[_ngcontent-%COMP%]{color:var(--sl-color-info-500);font-size:var(--sl-font-size-x-small);font-weight:var(--sl-font-weight-normal)}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DropzoneHeaderComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-dropzone-header',
      template: "<h5>\n    <span>\n        {{ label }}\n        <span *ngIf=\"required\">*</span>\n    </span>\n\n    <small *ngIf=\"max === 0\">\n        {{ '$$.plmt.aggregationSetup.no.limit' | translate }}\n    </small>\n\n    <small *ngIf=\"max! > 0\">\n        {{ '$$.plmt.aggregationSetup.limit' | translate: { limit: max } }}\n    </small>\n\n    <ng-container *ngTemplateOutlet=\"extraTemplate\"></ng-container>\n</h5>\n",
      styles: [":host{display:block}h5{display:flex;justify-content:space-between;margin:0;font-size:var(--sl-font-size-small);font-weight:var(--sl-font-weight-semibold);margin-bottom:var(--sl-spacing-2x-small)}h5 small{color:var(--sl-color-info-500);font-size:var(--sl-font-size-x-small);font-weight:var(--sl-font-weight-normal)}\n"]
    }]
  }], null, {
    label: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    required: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    max: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    extraTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }]
  });
})();

class DropzoneHeaderModule {}

DropzoneHeaderModule.ɵfac = function DropzoneHeaderModule_Factory(t) {
  return new (t || DropzoneHeaderModule)();
};

DropzoneHeaderModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: DropzoneHeaderModule
});
DropzoneHeaderModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DropzoneHeaderModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [DropzoneHeaderComponent],
      declarations: [DropzoneHeaderComponent]
    }]
  }], null, null);
})();

class ColumnItemComponent {
  constructor() {
    this.removable = true;
    this.extraTemplate = null;
    this.remove = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

}

ColumnItemComponent.ɵfac = function ColumnItemComponent_Factory(t) {
  return new (t || ColumnItemComponent)();
};

ColumnItemComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: ColumnItemComponent,
  selectors: [["lib-column-item"]],
  inputs: {
    column: "column",
    removable: "removable",
    extraTemplate: "extraTemplate"
  },
  outputs: {
    remove: "remove"
  },
  decls: 4,
  vars: 6,
  consts: [["tooltipify", "", 3, "column"], [1, "actions"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["name", "x", 3, "click", 4, "ngIf"], ["name", "x", 3, "click"]],
  template: function ColumnItemComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "core-column-name", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, ColumnItemComponent_ng_container_2_Template, 1, 0, "ng-container", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, ColumnItemComponent_sl_icon_button_3_Template, 1, 0, "sl-icon-button", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("column", ctx.column);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", ctx.extraTemplate)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](4, _c1, ctx.column));
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.removable);
    }
  },
  dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnNameComponent, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyDirective],
  styles: ["[_nghost-%COMP%]{display:flex;align-items:center;justify-content:space-between;padding:var(--sl-spacing-x-small) var(--sl-spacing-small);font-size:var(--sl-font-size-small);cursor:pointer}.actions[_ngcontent-%COMP%]{display:flex;align-items:center;font-size:var(--sl-font-size-x-small);color:var(--sl-color-neutral-600)}sl-icon-button[name=x][_ngcontent-%COMP%]::part(base){padding:0;margin-left:var(--sl-spacing-x-small)}sl-icon-button[name=x][_ngcontent-%COMP%]::part(base):hover{color:inherit}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](ColumnItemComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-column-item',
      template: "<core-column-name tooltipify [column]=\"column\"></core-column-name>\n\n<div class=\"actions\">\n    <ng-container\n        *ngTemplateOutlet=\"extraTemplate; context: { $implicit: column }\"\n    >\n    </ng-container>\n\n    <sl-icon-button\n        *ngIf=\"removable\"\n        name=\"x\"\n        (click)=\"remove.emit()\"\n    ></sl-icon-button>\n</div>\n",
      styles: [":host{display:flex;align-items:center;justify-content:space-between;padding:var(--sl-spacing-x-small) var(--sl-spacing-small);font-size:var(--sl-font-size-small);cursor:pointer}.actions{display:flex;align-items:center;font-size:var(--sl-font-size-x-small);color:var(--sl-color-neutral-600)}sl-icon-button[name=x]::part(base){padding:0;margin-left:var(--sl-spacing-x-small)}sl-icon-button[name=x]::part(base):hover{color:inherit}\n"]
    }]
  }], null, {
    column: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    removable: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    extraTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    remove: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }]
  });
})();

class ColumnItemModule {}

ColumnItemModule.ɵfac = function ColumnItemModule_Factory(t) {
  return new (t || ColumnItemModule)();
};

ColumnItemModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: ColumnItemModule
});
ColumnItemModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnNameModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](ColumnItemModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnNameModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule],
      exports: [ColumnItemComponent],
      declarations: [ColumnItemComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

class DropzoneBodyComponent {}

DropzoneBodyComponent.ɵfac = function DropzoneBodyComponent_Factory(t) {
  return new (t || DropzoneBodyComponent)();
};

DropzoneBodyComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: DropzoneBodyComponent,
  selectors: [["lib-dropzone-body"]],
  ngContentSelectors: _c2,
  decls: 1,
  vars: 0,
  template: function DropzoneBodyComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵprojection"](0);
    }
  },
  styles: ["[_nghost-%COMP%]{display:block;border:var(--dropzone-body-border-width) var(--dropzone-body-border-style) var(--dropzone-body-border-color);box-sizing:border-box;border-radius:2px;min-height:34px;margin-bottom:var(--sl-spacing-medium);padding:var(--dropzone-body-padding)}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DropzoneBodyComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-dropzone-body',
      template: "<ng-content></ng-content>\n",
      styles: [":host{display:block;border:var(--dropzone-body-border-width) var(--dropzone-body-border-style) var(--dropzone-body-border-color);box-sizing:border-box;border-radius:2px;min-height:34px;margin-bottom:var(--sl-spacing-medium);padding:var(--dropzone-body-padding)}\n"]
    }]
  }], null, null);
})();

class DropzoneBodyModule {}

DropzoneBodyModule.ɵfac = function DropzoneBodyModule_Factory(t) {
  return new (t || DropzoneBodyModule)();
};

DropzoneBodyModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: DropzoneBodyModule
});
DropzoneBodyModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DropzoneBodyModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      exports: [DropzoneBodyComponent],
      declarations: [DropzoneBodyComponent]
    }]
  }], null, null);
})();

class DatasetService {
  constructor() {
    this.aggregateFunctions = [];
  }

  getColumns(ids) {
    const columns = [];
    const source = this.dataset?.columns || [];
    ids.forEach(id => {
      const column = source.find(item => item.id === id);
      if (column) columns.push(column);
    });
    return columns;
  }

}

DatasetService.ɵfac = function DatasetService_Factory(t) {
  return new (t || DatasetService)();
};

DatasetService.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
  token: DatasetService,
  factory: DatasetService.ɵfac,
  providedIn: 'root'
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DatasetService, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Injectable,
    args: [{
      providedIn: 'root'
    }]
  }], null, null);
})();

class DraggingService {
  constructor() {
    this.dragItem = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject(null);
  }

}

DraggingService.ɵfac = function DraggingService_Factory(t) {
  return new (t || DraggingService)();
};

DraggingService.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
  token: DraggingService,
  factory: DraggingService.ɵfac,
  providedIn: 'root'
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DraggingService, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Injectable,
    args: [{
      providedIn: 'root'
    }]
  }], null, null);
})();

class DropzoneComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__.SubscribableComponent {
  constructor(datasetService, draggingService) {
    super();
    this.datasetService = datasetService;
    this.draggingService = draggingService;
    this.columnIds = [];
    this.columnExtraTemplate = null;
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
    this.columns = [];
    this.highlight = false;

    this.enterPredicate = drag => {
      if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)('data' in drag)) return false;
      const column = drag.data;
      if (this.columnIds.includes(column.id)) return false;
      if (this.dropEnterPredicate && (0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.dropEnterPredicate(column))) return false;
      return true;
    };
  }

  ngOnInit() {
    this.subscriptions = [this.draggingService.dragItem.subscribe(column => {
      if (column) this.highlight = this.enterPredicate({
        data: column
      });else this.highlight = false;
    })];
  }

  ngOnChanges(changes) {
    if ('columnIds' in changes) {
      const {
        dataset
      } = this.datasetService;

      if (dataset) {
        this.columns = [];
        this.columnIds.forEach(id => {
          const column = dataset.columns.find(column => column.id === id);
          if (column) this.columns.push(column);
        });
      }
    }
  }

  drop(event) {
    const target = [...this.columns];
    if (event.previousContainer === event.container) (0,_angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.moveItemInArray)(target, event.previousIndex, event.currentIndex);else (0,_angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.transferArrayItem)([event.item.data], target, 0, event.currentIndex);
    this.change.emit(target);
  }

  remove(column) {
    this.columns.splice(this.columns.indexOf(column), 1);
    this.change.emit(this.columns);
  }

}

DropzoneComponent.ɵfac = function DropzoneComponent_Factory(t) {
  return new (t || DropzoneComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](DatasetService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](DraggingService));
};

DropzoneComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: DropzoneComponent,
  selectors: [["lib-dropzone"]],
  hostVars: 2,
  hostBindings: function DropzoneComponent_HostBindings(rf, ctx) {
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("highlight", ctx.highlight);
    }
  },
  inputs: {
    columnIds: "columnIds",
    columnExtraTemplate: "columnExtraTemplate",
    dropEnterPredicate: "dropEnterPredicate"
  },
  outputs: {
    change: "change"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵNgOnChangesFeature"]],
  decls: 2,
  vars: 2,
  consts: [["cdkDropList", "", 3, "cdkDropListEnterPredicate", "cdkDropListDropped"], ["cdkDrag", "", "trackById", "", 3, "column", "extraTemplate", "remove", 4, "ngFor", "ngForOf"], ["cdkDrag", "", "trackById", "", 3, "column", "extraTemplate", "remove"]],
  template: function DropzoneComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "lib-dropzone-body", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("cdkDropListDropped", function DropzoneComponent_Template_lib_dropzone_body_cdkDropListDropped_0_listener($event) {
        return ctx.drop($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, DropzoneComponent_lib_column_item_1_Template, 1, 2, "lib-column-item", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("cdkDropListEnterPredicate", ctx.enterPredicate);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.columns);
    }
  },
  dependencies: [ColumnItemComponent, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDropList, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDrag, DropzoneBodyComponent],
  styles: [".highlight[_nghost-%COMP%]{--dropzone-body-border-color: var(--sl-color-primary-500)}lib-column-item[_ngcontent-%COMP%]{background:var(--sl-color-neutral-50)}lib-column-item[_ngcontent-%COMP%]:not(:last-child){margin-bottom:var(--sl-spacing-2x-small)}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DropzoneComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-dropzone',
      template: "<lib-dropzone-body\n    cdkDropList\n    [cdkDropListEnterPredicate]=\"enterPredicate\"\n    (cdkDropListDropped)=\"drop($event)\"\n>\n    <lib-column-item\n        *ngFor=\"let column of columns\"\n        cdkDrag\n        trackById\n        [column]=\"column\"\n        [extraTemplate]=\"columnExtraTemplate\"\n        (remove)=\"remove(column)\"\n    ></lib-column-item>\n</lib-dropzone-body>\n",
      styles: [":host.highlight{--dropzone-body-border-color: var(--sl-color-primary-500)}lib-column-item{background:var(--sl-color-neutral-50)}lib-column-item:not(:last-child){margin-bottom:var(--sl-spacing-2x-small)}\n"]
    }]
  }], function () {
    return [{
      type: DatasetService
    }, {
      type: DraggingService
    }];
  }, {
    columnIds: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    columnExtraTemplate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    dropEnterPredicate: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }],
    highlight: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.HostBinding,
      args: ['class.highlight']
    }]
  });
})();

class DropzoneModule {}

DropzoneModule.ɵfac = function DropzoneModule_Factory(t) {
  return new (t || DropzoneModule)();
};

DropzoneModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: DropzoneModule
});
DropzoneModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [ColumnItemModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.DragDropModule, DropzoneBodyModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](DropzoneModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [ColumnItemModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.DragDropModule, DropzoneBodyModule],
      exports: [DropzoneComponent],
      declarations: [DropzoneComponent]
    }]
  }], null, null);
})();

const {
  Sum,
  Min,
  Max,
  Average,
  Median,
  Count,
  CountDistinct,
  Distinct
} = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataOptionAggregateFunction;
const aggregateFunctions = {
  [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType.Boolean]: [Count, CountDistinct],
  [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType.Date]: [Count, CountDistinct],
  [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType.Number]: [Sum, Min, Max, Average, Median, Count, CountDistinct, Distinct],
  [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType.String]: [Count, CountDistinct]
};

class SelectAggregateFnComponent {
  constructor(datasetService) {
    this.datasetService = datasetService;
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

  set column(column) {
    this.aggregateFunctions = aggregateFunctions[column.base_type].filter(aggregateFunction => this.datasetService.aggregateFunctions.includes(aggregateFunction));
    this.defaultValue = this.aggregateFunctions[0];
  }

  get current() {
    return this.value || this.defaultValue;
  }

  onAggrFnChange(event) {
    this.change.emit(event.detail.item.value);
  }

}

SelectAggregateFnComponent.ɵfac = function SelectAggregateFnComponent_Factory(t) {
  return new (t || SelectAggregateFnComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](DatasetService));
};

SelectAggregateFnComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: SelectAggregateFnComponent,
  selectors: [["lib-select-aggregate-fn"]],
  inputs: {
    column: "column",
    value: "value"
  },
  outputs: {
    change: "change"
  },
  decls: 6,
  vars: 4,
  consts: [["hoist", ""], ["slot", "trigger"], [3, "sl-select"], [3, "value", 4, "ngFor", "ngForOf"], [3, "value"]],
  template: function SelectAggregateFnComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dropdown", 0)(1, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "sl-menu", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-select", function SelectAggregateFnComponent_Template_sl_menu_sl_select_4_listener($event) {
        return ctx.onAggrFnChange($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, SelectAggregateFnComponent_sl_menu_item_5_Template, 3, 4, "sl-menu-item", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 2, "$$.plmt.aggregationSetup.aggrFn." + ctx.current), " ");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.aggregateFunctions);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](SelectAggregateFnComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-select-aggregate-fn',
      template: "<sl-dropdown hoist>\n    <div slot=\"trigger\">\n        {{ '$$.plmt.aggregationSetup.aggrFn.' + current | translate }}\n    </div>\n\n    <sl-menu (sl-select)=\"onAggrFnChange($event)\">\n        <sl-menu-item *ngFor=\"let fn of aggregateFunctions\" [value]=\"fn\">\n            {{ '$$.plmt.aggregationSetup.aggrFn.' + fn | translate }}\n        </sl-menu-item>\n    </sl-menu>\n</sl-dropdown>\n"
    }]
  }], function () {
    return [{
      type: DatasetService
    }];
  }, {
    column: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }]
  });
})();

class SelectAggregateFnModule {}

SelectAggregateFnModule.ɵfac = function SelectAggregateFnModule_Factory(t) {
  return new (t || SelectAggregateFnModule)();
};

SelectAggregateFnModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: SelectAggregateFnModule
});
SelectAggregateFnModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](SelectAggregateFnModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [SelectAggregateFnComponent],
      declarations: [SelectAggregateFnComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

class LocalizeService {
  constructor(storageService) {
    this.storageService = storageService;
  }

  localize(text) {
    const lang = this.storageService.lang.value;
    return text[lang];
  }

}

LocalizeService.ɵfac = function LocalizeService_Factory(t) {
  return new (t || LocalizeService)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.StorageService));
};

LocalizeService.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
  token: LocalizeService,
  factory: LocalizeService.ɵfac,
  providedIn: 'root'
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](LocalizeService, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Injectable,
    args: [{
      providedIn: 'root'
    }]
  }], function () {
    return [{
      type: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.StorageService
    }];
  }, null);
})();

class BlockDataComponent {
  constructor(localizeService) {
    this.localizeService = localizeService;
    this.required = false;
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

  get columnIds() {
    return this.value.columns.map(({
      column_id
    }) => column_id);
  }

  get isFull() {
    const {
      max
    } = this.block;
    if (max) return this.value.columns.length === max;
    return false;
  }

  ngOnChanges(changes) {
    if ('block' in changes) {
      const {
        max
      } = this.block;
      if (max && max > 0) this.dropzonePredicate = () => {
        return this.value.columns.length < max;
      };else this.dropzonePredicate = undefined;
    }
  }

  onColumnsChange(columns) {
    this.change.emit({ ...this.value,
      columns: columns.map(column => this.getColumnItem(column.id) || this.createColumnItem(column))
    });
  }

  getAggregateFunction(columnId) {
    return this.getColumnItem(columnId).agg_fn;
  }

  onAggrFnChange(columnId, value) {
    const column = this.getColumnItem(columnId);
    column.agg_fn = value;
    this.change.emit(this.value);
  }

  getColumnItem(columnId) {
    return this.value.columns.find(item => item.column_id === columnId);
  }

  createColumnItem(column) {
    return {
      column_id: column.id,
      agg_fn: this.block.aggregation ? aggregateFunctions[column.base_type][0] : plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataOptionAggregateFunction.Group
    };
  }

}

BlockDataComponent.ɵfac = function BlockDataComponent_Factory(t) {
  return new (t || BlockDataComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](LocalizeService));
};

BlockDataComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: BlockDataComponent,
  selectors: [["lib-block-data"]],
  hostVars: 2,
  hostBindings: function BlockDataComponent_HostBindings(rf, ctx) {
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("full", ctx.isFull);
    }
  },
  inputs: {
    block: "block",
    value: "value",
    required: "required"
  },
  outputs: {
    change: "change"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵNgOnChangesFeature"]],
  decls: 4,
  vars: 6,
  consts: [[3, "label", "required", "max"], [3, "columnIds", "columnExtraTemplate", "dropEnterPredicate", "change"], ["extra", ""], [3, "column", "value", "change", 4, "ngIf"], [3, "column", "value", "change"]],
  template: function BlockDataComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "lib-dropzone-header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "lib-dropzone", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockDataComponent_Template_lib_dropzone_change_1_listener($event) {
        return ctx.onColumnsChange($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, BlockDataComponent_ng_template_2_Template, 1, 1, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    }

    if (rf & 2) {
      const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](3);

      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", ctx.localizeService.localize(ctx.block.label))("required", ctx.required)("max", ctx.block.max || 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("columnIds", ctx.columnIds)("columnExtraTemplate", _r0)("dropEnterPredicate", ctx.dropzonePredicate);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, DropzoneComponent, DropzoneHeaderComponent, SelectAggregateFnComponent],
  styles: [".full[_nghost-%COMP%]{--dropzone-body-border-width: 0;--dropzone-body-padding: 0}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockDataComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-block-data',
      template: "<lib-dropzone-header\n    [label]=\"localizeService.localize(block.label)\"\n    [required]=\"required\"\n    [max]=\"block.max || 0\"\n></lib-dropzone-header>\n\n<lib-dropzone\n    [columnIds]=\"columnIds\"\n    [columnExtraTemplate]=\"extra\"\n    [dropEnterPredicate]=\"dropzonePredicate\"\n    (change)=\"onColumnsChange($event)\"\n></lib-dropzone>\n\n<ng-template #extra let-column>\n    <lib-select-aggregate-fn\n        *ngIf=\"block.aggregation\"\n        [column]=\"column\"\n        [value]=\"getAggregateFunction(column.id)\"\n        (change)=\"onAggrFnChange(column.id, $event)\"\n    ></lib-select-aggregate-fn>\n</ng-template>\n",
      styles: [":host.full{--dropzone-body-border-width: 0;--dropzone-body-padding: 0}\n"]
    }]
  }], function () {
    return [{
      type: LocalizeService
    }];
  }, {
    block: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    required: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }],
    isFull: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.HostBinding,
      args: ['class.full']
    }]
  });
})();

class BlockDataModule {}

BlockDataModule.ɵfac = function BlockDataModule_Factory(t) {
  return new (t || BlockDataModule)();
};

BlockDataModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: BlockDataModule
});
BlockDataModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule, SelectAggregateFnModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockDataModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule, SelectAggregateFnModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [BlockDataComponent],
      declarations: [BlockDataComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

class BlockDrilldownComponent {
  constructor(changeDetectorRef, datasetService) {
    this.changeDetectorRef = changeDetectorRef;
    this.datasetService = datasetService;
    this.sourceColumnIds = [];
    this.dataBlocks = [];
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
    this.sourceColumns = [];

    this.dropzonePredicate = ({
      id
    }) => {
      if (id === this.value.source) return false;
      return (0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.containsInBlocks(id));
    };
  }

  ngOnChanges(changes) {
    if ('sourceColumnIds' in changes) {
      this.sourceColumns = this.datasetService.getColumns(this.sourceColumnIds);

      if (this.value.source) {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.sourceColumnIds.includes(this.value.source))) this.onSourceChange(0);
      } else if (this.sourceColumns.length) {
        this.onSourceChange(this.sourceColumns[0].id);
        this.update();
      }
    }

    if ('dataBlocks' in changes) {
      const {
        levels
      } = this.value;
      const nextLevels = this.value.levels.filter(id => (0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.containsInBlocks(id)));

      if (nextLevels.length !== levels.length) {
        this.change.emit({ ...this.value,
          levels: nextLevels
        });
        this.update();
      }
    }
  }

  onSourceChange(columnId) {
    this.change.emit({ ...this.value,
      source: columnId
    });
  }

  onLevelsChange(columns) {
    this.change.emit({ ...this.value,
      levels: columns.map(plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.toIds)
    });
  }

  update() {
    this.changeDetectorRef.markForCheck();
  }

  containsInBlocks(columnId) {
    return this.dataBlocks.some(({
      columns
    }) => columns.some(({
      column_id
    }) => column_id === columnId));
  }

}

BlockDrilldownComponent.ɵfac = function BlockDrilldownComponent_Factory(t) {
  return new (t || BlockDrilldownComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](DatasetService));
};

BlockDrilldownComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: BlockDrilldownComponent,
  selectors: [["lib-block-drilldown"]],
  inputs: {
    value: "value",
    sourceColumnIds: "sourceColumnIds",
    dataBlocks: "dataBlocks"
  },
  outputs: {
    change: "change"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵNgOnChangesFeature"]],
  decls: 5,
  vars: 7,
  consts: [[3, "label"], ["hoist", "", "size", "small", 3, "value", "disabled", "change"], [3, "value", 4, "ngFor", "ngForOf"], [4, "ngIf"], [3, "value"], [3, "max"], [3, "columnIds", "dropEnterPredicate", "change"]],
  template: function BlockDrilldownComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "lib-dropzone-header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "sl-select", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockDrilldownComponent_Template_sl_select_change_2_listener($event) {
        return ctx.onSourceChange($event.target.value);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, BlockDrilldownComponent_sl_menu_item_3_Template, 2, 2, "sl-menu-item", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, BlockDrilldownComponent_ng_container_4_Template, 3, 3, "ng-container", 3);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 5, "$$.plmt.aggregationSetup.drilldown"));
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", ctx.value.source)("disabled", !ctx.value.source);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.sourceColumns);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.value.source || ctx.value.levels.length > 0);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, DropzoneComponent, DropzoneHeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["sl-select[_ngcontent-%COMP%]{margin-bottom:var(--sl-spacing-small)}"]
});

(0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.Debounce)(0)], BlockDrilldownComponent.prototype, "update", null);

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockDrilldownComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-block-drilldown',
      template: "<lib-dropzone-header\n    [label]=\"'$$.plmt.aggregationSetup.drilldown' | translate\"\n></lib-dropzone-header>\n\n<sl-select\n    hoist\n    size=\"small\"\n    [value]=\"value.source\"\n    [disabled]=\"!value.source\"\n    (change)=\"onSourceChange($any($event).target.value)\"\n>\n    <sl-menu-item *ngFor=\"let column of sourceColumns\" [value]=\"column.id\">\n        {{ column.name }}\n    </sl-menu-item>\n</sl-select>\n\n<ng-container *ngIf=\"value.source || value.levels.length > 0\">\n    <lib-dropzone-header [max]=\"0\"></lib-dropzone-header>\n\n    <lib-dropzone\n        [columnIds]=\"value.levels\"\n        [dropEnterPredicate]=\"dropzonePredicate\"\n        (change)=\"onLevelsChange($event)\"\n    ></lib-dropzone>\n</ng-container>\n",
      styles: ["sl-select{margin-bottom:var(--sl-spacing-small)}\n"]
    }]
  }], function () {
    return [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.ChangeDetectorRef
    }, {
      type: DatasetService
    }];
  }, {
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    sourceColumnIds: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    dataBlocks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }],
    update: []
  });
})();

class BlockDrilldownModule {}

BlockDrilldownModule.ɵfac = function BlockDrilldownModule_Factory(t) {
  return new (t || BlockDrilldownModule)();
};

BlockDrilldownModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: BlockDrilldownModule
});
BlockDrilldownModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockDrilldownModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [BlockDrilldownComponent],
      declarations: [BlockDrilldownComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

class BlockFiltersComponent {
  constructor() {
    this.value = [];
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

}

BlockFiltersComponent.ɵfac = function BlockFiltersComponent_Factory(t) {
  return new (t || BlockFiltersComponent)();
};

BlockFiltersComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: BlockFiltersComponent,
  selectors: [["lib-block-filters"]],
  hostVars: 2,
  hostBindings: function BlockFiltersComponent_HostBindings(rf, ctx) {
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("show", ctx.dataset);
    }
  },
  inputs: {
    dataset: "dataset",
    value: "value"
  },
  outputs: {
    change: "change"
  },
  decls: 3,
  vars: 4,
  consts: [[3, "label"], [3, "dataset", "value", "change", 4, "ngIf"], [3, "dataset", "value", "change"]],
  template: function BlockFiltersComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "lib-dropzone-header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, BlockFiltersComponent_core_filters_2_Template, 1, 3, "core-filters", 1);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 2, "$$.plmt.aggregationSetup.filters"));
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.dataset);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_10__.FiltersComponent, DropzoneHeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]:not(.show){display:none}core-filters[_ngcontent-%COMP%]{margin-bottom:var(--sl-spacing-x-small)}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockFiltersComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-block-filters',
      template: "<lib-dropzone-header\n    [label]=\"'$$.plmt.aggregationSetup.filters' | translate\"\n></lib-dropzone-header>\n\n<core-filters\n    *ngIf=\"dataset\"\n    [dataset]=\"dataset\"\n    [value]=\"value || []\"\n    (change)=\"change.emit($event)\"\n></core-filters>\n",
      styles: [":host:not(.show){display:none}core-filters{margin-bottom:var(--sl-spacing-x-small)}\n"]
    }]
  }], null, {
    dataset: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.HostBinding,
      args: ['class.show']
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }]
  });
})();

class BlockFiltersModule {}

BlockFiltersModule.ɵfac = function BlockFiltersModule_Factory(t) {
  return new (t || BlockFiltersModule)();
};

BlockFiltersModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: BlockFiltersModule
});
BlockFiltersModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_10__.FiltersModule, DropzoneBodyModule, DropzoneHeaderModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockFiltersModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_10__.FiltersModule, DropzoneBodyModule, DropzoneHeaderModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [BlockFiltersComponent],
      declarations: [BlockFiltersComponent]
    }]
  }], null, null);
})();

class BlockHeatmapComponent {
  constructor() {
    this.items = [];
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

  get columnIds() {
    return this.items.map(({
      column_id
    }) => column_id);
  }

  onColumnsChange(columns) {
    this.change.emit(columns.map(({
      id
    }) => this.getByColumnId(id) || this.createHeatmapItem(id)));
  }

  getByColumnId(id) {
    return this.items.find(({
      column_id
    }) => column_id === id);
  }

  createHeatmapItem(id) {
    return {
      column_id: id,
      aboveValue: 0,
      aboveColor: '',
      threshold: 0,
      belowValue: 0,
      belowColor: ''
    };
  }

}

BlockHeatmapComponent.ɵfac = function BlockHeatmapComponent_Factory(t) {
  return new (t || BlockHeatmapComponent)();
};

BlockHeatmapComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: BlockHeatmapComponent,
  selectors: [["lib-block-heatmap"]],
  inputs: {
    config: "config",
    items: "items"
  },
  outputs: {
    change: "change"
  },
  decls: 5,
  vars: 5,
  consts: [[3, "label"], [3, "columnIds", "columnExtraTemplate", "change"], ["extra", ""], ["slot", "trigger", "name", "gear"]],
  template: function BlockHeatmapComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "lib-dropzone-header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "lib-dropzone", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockHeatmapComponent_Template_lib_dropzone_change_2_listener($event) {
        return ctx.onColumnsChange($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, BlockHeatmapComponent_ng_template_3_Template, 2, 0, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    }

    if (rf & 2) {
      const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](4);

      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 3, "$$.plmt.aggregationSetup.heatmap"));
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("columnIds", ctx.columnIds)("columnExtraTemplate", _r0);
    }
  },
  dependencies: [DropzoneComponent, DropzoneHeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockHeatmapComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-block-heatmap',
      template: "<lib-dropzone-header\n    [label]=\"'$$.plmt.aggregationSetup.heatmap' | translate\"\n></lib-dropzone-header>\n\n<lib-dropzone\n    [columnIds]=\"columnIds\"\n    [columnExtraTemplate]=\"extra\"\n    (change)=\"onColumnsChange($event)\"\n></lib-dropzone>\n\n<ng-template #extra let-column>\n    <sl-dropdown>\n        <sl-icon-button slot=\"trigger\" name=\"gear\"></sl-icon-button>\n    </sl-dropdown>\n</ng-template>\n"
    }]
  }], null, {
    config: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    items: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }]
  });
})();

class BlockHeatmapModule {}

BlockHeatmapModule.ɵfac = function BlockHeatmapModule_Factory(t) {
  return new (t || BlockHeatmapModule)();
};

BlockHeatmapModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: BlockHeatmapModule
});
BlockHeatmapModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockHeatmapModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [BlockHeatmapComponent],
      declarations: [BlockHeatmapComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

class BlockLimitComponent {
  constructor() {
    this.value = 0;
    this.valueChange = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

}

BlockLimitComponent.ɵfac = function BlockLimitComponent_Factory(t) {
  return new (t || BlockLimitComponent)();
};

BlockLimitComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: BlockLimitComponent,
  selectors: [["lib-block-limit"]],
  inputs: {
    value: "value"
  },
  outputs: {
    valueChange: "valueChange"
  },
  decls: 4,
  vars: 4,
  consts: [[3, "label"], ["type", "number", "size", "small", 3, "value", "sl-change"], ["input", ""]],
  template: function BlockLimitComponent_Template(rf, ctx) {
    if (rf & 1) {
      const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();

      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "lib-dropzone-header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "sl-input", 1, 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-change", function BlockLimitComponent_Template_sl_input_sl_change_2_listener() {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r1);

        const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](3);

        return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.valueChange.emit(+_r0.value || 0));
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 2, "$$.plmt.aggregationSetup.dataOptionLimit"));
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", ctx.value || "");
    }
  },
  dependencies: [DropzoneHeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["sl-input[_ngcontent-%COMP%]{margin:var(--sl-focus-ring-width) 0}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockLimitComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-block-limit',
      template: "<lib-dropzone-header\n    [label]=\"'$$.plmt.aggregationSetup.dataOptionLimit' | translate\"\n></lib-dropzone-header>\n\n<sl-input\n    #input\n    type=\"number\"\n    size=\"small\"\n    [value]=\"value || ''\"\n    (sl-change)=\"valueChange.emit(+input.value || 0)\"\n></sl-input>\n",
      styles: ["sl-input{margin:var(--sl-focus-ring-width) 0}\n"]
    }]
  }], null, {
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    valueChange: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }]
  });
})();

class BlockLimitModule {}

BlockLimitModule.ɵfac = function BlockLimitModule_Factory(t) {
  return new (t || BlockLimitModule)();
};

BlockLimitModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: BlockLimitModule
});
BlockLimitModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [DropzoneHeaderModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockLimitModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [DropzoneHeaderModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [BlockLimitComponent],
      declarations: [BlockLimitComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

const {
  Group
} = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataOptionAggregateFunction;

class BlockSortComponent {
  constructor() {
    this.value = [];
    this.dataBlocks = [];
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
  }

  get columnIds() {
    return this.value.map(({
      column_id
    }) => column_id);
  }

  ngOnChanges(changes) {
    if ('dataBlocks' in changes) this.onDataBlocksChanged(changes['dataBlocks']);
  }

  onColumnsChange(columns) {
    this.change.emit(columns.map(column => {
      const exists = this.value.find(({
        column_id
      }) => column_id === column.id);
      return exists ? exists : this.createSortItem(column);
    }));
  }

  onChangeDirection(columnId) {
    const item = this.getSortItem(columnId);
    item.direction = item.direction === plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Desc ? plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Asc : plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Desc;
    this.change.emit(this.value);
  }

  onChangeArrgegateFn(columnId, value) {
    const item = this.getSortItem(columnId);
    item.agg_fn = value;
    this.change.emit(this.value);
  }

  getDirectionIcon(columnId) {
    return this.getSortItem(columnId).direction === plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Desc ? 'caret-down-fill' : 'caret-up-fill';
  }

  getAggregateFn(columnId) {
    const fn = this.getSortItem(columnId).agg_fn;
    if (fn === Group) return;
    return fn;
  }

  getSortItem(columnId) {
    return this.value.find(({
      column_id
    }) => column_id === columnId);
  }

  createSortItem(column) {
    const item = {
      column_id: column.id,
      direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Desc
    };
    const block = this.fromDataBlocks(column.id);
    item.agg_fn = block ? block.agg_fn : aggregateFunctions[column.base_type][0];
    return item;
  }

  fromDataBlocks(columnId) {
    for (let {
      columns
    } of this.dataBlocks) for (let block of columns) if (block.column_id === columnId) return block;

    return null;
  }

  onDataBlocksChanged({
    firstChange,
    previousValue,
    currentValue
  }) {
    if (firstChange) return;
    const dataBlocksRemovedIds = this.getDataBlocksRemovedIds(previousValue, currentValue);
    const nextSortItems = this.value.filter(({
      column_id
    }) => (0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(dataBlocksRemovedIds.includes(column_id)));
    if (nextSortItems.length === this.value.length) return;
    this.change.emit(nextSortItems);
    this.value = nextSortItems;
  }

  getDataBlocksRemovedIds(prev, next) {
    const ids = [];
    prev.forEach(({
      key,
      columns
    }) => {
      const nextBlock = next.find(block => block.key === key);
      if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(nextBlock)) return;
      const nextIds = nextBlock.columns.map(toIds);
      const removed = columns.map(toIds).filter(id => (0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(nextIds.includes(id)));
      ids.push(...removed);
    });
    return ids;
  }

}

BlockSortComponent.ɵfac = function BlockSortComponent_Factory(t) {
  return new (t || BlockSortComponent)();
};

BlockSortComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: BlockSortComponent,
  selectors: [["lib-block-sort"]],
  inputs: {
    value: "value",
    dataBlocks: "dataBlocks"
  },
  outputs: {
    change: "change"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵNgOnChangesFeature"]],
  decls: 7,
  vars: 6,
  consts: [[3, "label", "extraTemplate"], ["headerExtra", ""], [3, "columnIds", "columnExtraTemplate", "change"], ["extra", ""], ["placement", "left", 3, "content"], ["name", "question-circle"], [3, "column", "value", "change", 4, "ngIf"], [3, "name", "click"], [3, "column", "value", "change"]],
  template: function BlockSortComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "lib-dropzone-header", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, BlockSortComponent_ng_template_2_Template, 3, 3, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "lib-dropzone", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function BlockSortComponent_Template_lib_dropzone_change_4_listener($event) {
        return ctx.onColumnsChange($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](5, BlockSortComponent_ng_template_5_Template, 2, 2, "ng-template", null, 3, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    }

    if (rf & 2) {
      const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](3);

      const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](6);

      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 4, "$$.plmt.aggregationSetup.sort"))("extraTemplate", _r0);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("columnIds", ctx.columnIds)("columnExtraTemplate", _r2);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, DropzoneComponent, DropzoneHeaderComponent, SelectAggregateFnComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["lib-select-aggregate-fn[_ngcontent-%COMP%]{margin-right:var(--sl-spacing-2x-small)}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockSortComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'lib-block-sort',
      template: "<lib-dropzone-header\n    [label]=\"'$$.plmt.aggregationSetup.sort' | translate\"\n    [extraTemplate]=\"headerExtra\"\n></lib-dropzone-header>\n\n<ng-template #headerExtra>\n    <sl-tooltip\n        placement=\"left\"\n        [content]=\"'$$.plmt.aggregationSetup.sort.tooltip' | translate\"\n    >\n        <sl-icon name=\"question-circle\"></sl-icon>\n    </sl-tooltip>\n</ng-template>\n\n<lib-dropzone\n    [columnIds]=\"columnIds\"\n    [columnExtraTemplate]=\"extra\"\n    (change)=\"onColumnsChange($event)\"\n></lib-dropzone>\n\n<ng-template #extra let-column>\n    <lib-select-aggregate-fn\n        *ngIf=\"getAggregateFn(column.id) as fn\"\n        [column]=\"column\"\n        [value]=\"fn\"\n        (change)=\"onChangeArrgegateFn(column.id, $event)\"\n    ></lib-select-aggregate-fn>\n\n    <sl-icon\n        [name]=\"getDirectionIcon(column.id)\"\n        (click)=\"onChangeDirection(column.id)\"\n    ></sl-icon>\n</ng-template>\n",
      styles: ["lib-select-aggregate-fn{margin-right:var(--sl-spacing-2x-small)}\n"]
    }]
  }], null, {
    value: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    dataBlocks: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }]
  });
})();

function toIds(item) {
  return item.column_id;
}

class BlockSortModule {}

BlockSortModule.ɵfac = function BlockSortModule_Factory(t) {
  return new (t || BlockSortModule)();
};

BlockSortModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: BlockSortModule
});
BlockSortModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, SelectAggregateFnModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](BlockSortModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, DropzoneModule, DropzoneHeaderModule, SelectAggregateFnModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [BlockSortComponent],
      declarations: [BlockSortComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

const pivotTableBlocks = [{
  key: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PivotBlockKey.Columns,
  label: {
    ru: 'Столбцы',
    en: 'Columns'
  }
}, {
  key: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PivotBlockKey.Rows,
  label: {
    ru: 'Строки',
    en: 'Rows'
  }
}, {
  key: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PivotBlockKey.Values,
  aggregation: true,
  label: {
    ru: 'Показатели',
    en: 'Values'
  }
}];

class ConfigService {
  constructor() {
    this.config = new rxjs__WEBPACK_IMPORTED_MODULE_11__.ReplaySubject(1);
  }

}

ConfigService.ɵfac = function ConfigService_Factory(t) {
  return new (t || ConfigService)();
};

ConfigService.ɵprov = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
  token: ConfigService,
  factory: ConfigService.ɵfac,
  providedIn: 'root'
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](ConfigService, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Injectable,
    args: [{
      providedIn: 'root'
    }]
  }], null, null);
})();

var AggregationSetupErrorType;

(function (AggregationSetupErrorType) {
  AggregationSetupErrorType["DatasetListRequest"] = "dataset-list";
  AggregationSetupErrorType["DatasetRequest"] = "dataset";
})(AggregationSetupErrorType || (AggregationSetupErrorType = {}));

const LIMIT_DEFAULT = 1000;

class AggregationSetupComponent {
  constructor(configService, datasetService, dataApiService, datasetApiService, draggingService) {
    this.configService = configService;
    this.datasetService = datasetService;
    this.dataApiService = dataApiService;
    this.datasetApiService = datasetApiService;
    this.draggingService = draggingService;
    this.repeatable = false;
    this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
    this.error = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
    this.columns = [];
    this.dataOptionReady = false;

    this.datasetsProvider = (search, offset) => this.datasetApiService.list({
      name: search,
      offset,
      state: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DatasetState.Done
    }).pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_12__.catchError)(error => {
      this.error.emit({
        type: AggregationSetupErrorType.DatasetListRequest,
        payload: error
      });
      throw error;
    }));
  }

  get datasetReady() {
    return Boolean(this.datasetService.dataset);
  }

  get blocks() {
    return this.config.method === polymatica_widget_config__WEBPACK_IMPORTED_MODULE_1__.Method.PivotTable ? pivotTableBlocks : this.config.blocks;
  }

  ngOnChanges(changes) {
    if ('config' in changes) {
      this.configService.config.next(this.config);
      if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(changes['config'].firstChange)) this.dataOption = {
        key: this.dataOption.key,
        dataset_id: this.dataOption.dataset_id,
        method: mapMethod(this.config.method),
        blocks: [],
        limit: this.dataOption.limit || LIMIT_DEFAULT
      };
    }

    if ('dataOption' in changes) {
      this.fixAggregateFunctions();
      const id = this.dataOption.dataset_id;
      if (id && id !== this.dataset?.id) this.changeDataset(id);
      this.dataOptionReady = this.isDataOptionReady();
    }
  }

  changeDataset(id) {
    if (this.dataset?.id === id) return;
    (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.forkJoin)({
      dataset: this.datasetApiService.get(id).pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_12__.catchError)(error => {
        this.reset();
        this.error.emit({
          type: AggregationSetupErrorType.DatasetRequest,
          payload: error
        });
        throw null;
      }), (0,rxjs__WEBPACK_IMPORTED_MODULE_14__.map)(({
        row
      }) => row)),
      aggregateFunctions: this.dataApiService.getAggregateFunctions(id)
    }).subscribe(({
      dataset,
      aggregateFunctions
    }) => {
      this.datasetService.dataset = this.dataset = dataset;
      this.datasetService.aggregateFunctions = aggregateFunctions;
      this.updateColumns();
      if (this.dataOption.dataset_id !== dataset.id) this.reset(id);
    });
  }

  getDataOptionBlock(block) {
    return this.dataOption.blocks.find(({
      key
    }) => key === block.key);
  }

  isDataOptionBlockRequired(block) {
    if (this.config.method === polymatica_widget_config__WEBPACK_IMPORTED_MODULE_1__.Method.PivotTable) return block.key === plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PivotBlockKey.Values;
    if (this.config.validation?.requiredEvery) return this.config.validation.requiredEvery.some(key => key === block.key);
    return false;
  }

  getDrilldown() {
    return this.dataOption.payload?.drilldown || {
      source: 0,
      levels: []
    };
  }

  getDrilldownColumnIds() {
    const columnIds = new Set();
    this.config.drilldown.sources.forEach(blockKey => {
      const dataOptionBlock = this.dataOption.blocks.find(({
        key
      }) => key === blockKey);
      dataOptionBlock?.columns.forEach(({
        column_id
      }) => {
        columnIds.add(column_id);
      });
    });
    return [...columnIds];
  }

  getHeatmap() {
    return this.dataOption.payload?.heatmap || [];
  }

  onDataOptionBlockChange(next) {
    const blocks = [...this.dataOption.blocks];
    const i = blocks.findIndex(({
      key
    }) => next.key === key);
    blocks[i] = next;
    this.change.emit({ ...this.dataOption,
      blocks
    });
  }

  onFiltersChange(filters) {
    this.change.emit({ ...this.dataOption,
      filters
    });
  }

  onSortChange(sort) {
    this.change.emit({ ...this.dataOption,
      sort
    });
  }

  onDrilldownChange(value) {
    this.change.emit({ ...this.dataOption,
      payload: { ...this.dataOption.payload,
        drilldown: value
      }
    });
  }

  onHeatmapChange(items) {
    this.change.emit({ ...this.dataOption,
      payload: { ...this.dataOption.payload,
        heatmap: items
      }
    });
  }

  onLimitChange(value) {
    this.change.emit({ ...this.dataOption,
      limit: value
    });
  }

  onDragStart(event) {
    this.draggingService.dragItem.next(event.source.data);
  }

  onDragEnd() {
    this.draggingService.dragItem.next(null);
  }

  isDataOptionReady() {
    const {
      dataOption
    } = this;
    const exists = [];
    const next = [];
    this.blocks.forEach(({
      key
    }) => {
      const block = dataOption.blocks.find(block => block.key === key);
      if (block) exists.push(block);else next.push({
        key,
        columns: []
      });
    });
    if (next.length === 0 && exists.length === dataOption.blocks.length) return true;
    setTimeout(() => {
      this.change.emit({ ...dataOption,
        blocks: exists.concat(next)
      });
    });
    return false;
  }

  updateColumns() {
    const dataset = this.dataset;
    this.columns = dataset.relations?.length ? dataset.relations.map(({
      columns
    }) => columns).flat() : dataset.columns;
  }

  reset(dataset_id = 0) {
    this.change.emit({
      key: this.dataOption.key,
      dataset_id,
      method: this.dataOption.method,
      blocks: this.blocks.map(({
        key
      }) => ({
        key,
        columns: []
      })),
      limit: this.dataOption.limit || LIMIT_DEFAULT,
      sort: [],
      filters: []
    });
  } // костыль созданныx до изменения enum DataOptionAggregateFunction


  fixAggregateFunctions() {
    for (let block of this.dataOption.blocks) block.columns.forEach(fixAggregateFunctions);

    this.dataOption.sort?.forEach(fixAggregateFunctions);
  }

}

AggregationSetupComponent.ɵfac = function AggregationSetupComponent_Factory(t) {
  return new (t || AggregationSetupComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](ConfigService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](DatasetService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](DraggingService));
};

AggregationSetupComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
  type: AggregationSetupComponent,
  selectors: [["plmt-aggregation-setup"]],
  inputs: {
    config: "config",
    dataOption: "dataOption",
    repeatable: "repeatable"
  },
  outputs: {
    change: "change",
    error: "error"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵNgOnChangesFeature"]],
  decls: 12,
  vars: 9,
  consts: [["cdkDropListGroup", "", 1, "grid"], [1, "dataset"], ["type", "text", 4, "ngIf"], ["viewKey", "name", 3, "selected", "suggestionsProvider", "onSelect"], [1, "scroll-group"], ["cdkDropList", "", "cdkDropListSortingDisabled", "", 1, "column-group", 3, "cdkDropListData"], ["trackById", "", "cdkDrag", "", 3, "cdkDragData", "column", "removable", "cdkDragStarted", "cdkDragEnded", 4, "ngFor", "ngForOf"], ["class", "settings", 4, "ngIf"], ["type", "text"], ["trackById", "", "cdkDrag", "", 3, "cdkDragData", "column", "removable", "cdkDragStarted", "cdkDragEnded"], [1, "settings"], [3, "block", "value", "required", "change", 4, "ngFor", "ngForOf"], [3, "dataset", "value", "change"], [3, "value", "dataBlocks", "change"], [3, "value", "sourceColumnIds", "dataBlocks", "change", 4, "ngIf"], [3, "config", "items", "change", 4, "ngIf"], [3, "value", "valueChange"], [3, "block", "value", "required", "change"], [3, "value", "sourceColumnIds", "dataBlocks", "change"], [3, "config", "items", "change"]],
  template: function AggregationSetupComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "header")(3, "h3");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](5, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, AggregationSetupComponent_sl_button_6_Template, 3, 3, "sl-button", 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "core-suggest", 3);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function AggregationSetupComponent_Template_core_suggest_onSelect_7_listener($event) {
        return ctx.changeDataset($event.id);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](8, "div", 4)(9, "div", 5);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](10, AggregationSetupComponent_lib_column_item_10_Template, 1, 3, "lib-column-item", 6);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](11, AggregationSetupComponent_div_11_Template, 8, 10, "div", 7);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](5, 7, "$$.plmt.aggregationSetup.dataset.title"), " ");
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.repeatable);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("selected", ctx.dataset)("suggestionsProvider", ctx.datasetsProvider);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("cdkDropListData", ctx.columns);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.columns);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.datasetReady && ctx.dataOptionReady);
    }
  },
  dependencies: [BlockDataComponent, BlockDrilldownComponent, BlockFiltersComponent, BlockHeatmapComponent, BlockLimitComponent, BlockSortComponent, ColumnItemComponent, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDropList, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDropListGroup, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDrag, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SuggestComponent, ng_track_by__WEBPACK_IMPORTED_MODULE_15__.TrackByIdDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]{--dropzone-body-border-width: 1px;--dropzone-body-border-style: dashed;--dropzone-body-border-color: #abb4ba;--dropzone-body-padding: var(--sl-spacing-3x-small);display:block}.grid[_ngcontent-%COMP%]{display:grid;height:100%;width:calc(100% - var(--sl-spacing-medium));grid-template-columns:50% 50%;grid-column-gap:var(--sl-spacing-medium)}h3[_ngcontent-%COMP%]{margin:0;font-size:var(--sl-font-size-medium);font-weight:var(--sl-font-weight-semibold)}header[_ngcontent-%COMP%]{display:flex;align-items:center;justify-content:space-between;margin-bottom:var(--sl-spacing-2x-small)}.scroll-group[_ngcontent-%COMP%]{overflow:auto;flex:1;padding:0 var(--sl-focus-ring-width)}.dataset[_ngcontent-%COMP%], .settings[_ngcontent-%COMP%]{height:100%;display:flex;flex-direction:column}.dataset[_ngcontent-%COMP%]{max-height:320px}lib-column-item[_ngcontent-%COMP%]:hover{background:var(--sl-color-primary-50)}"]
});

(0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()], AggregationSetupComponent.prototype, "dataset", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()], AggregationSetupComponent.prototype, "columns", void 0);

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](AggregationSetupComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Component,
    args: [{
      selector: 'plmt-aggregation-setup',
      template: "<div cdkDropListGroup class=\"grid\">\n    <div class=\"dataset\">\n        <header>\n            <h3>\n                {{ '$$.plmt.aggregationSetup.dataset.title' | translate }}\n            </h3>\n\n            <sl-button *ngIf=\"repeatable\" type=\"text\">\n                {{ '$$.plmt.aggregationSetup.dataset.add' | translate }}\n            </sl-button>\n        </header>\n\n        <core-suggest\n            viewKey=\"name\"\n            [selected]=\"dataset\"\n            [suggestionsProvider]=\"datasetsProvider\"\n            (onSelect)=\"changeDataset($any($event).id)\"\n        >\n        </core-suggest>\n\n        <div class=\"scroll-group\">\n            <div\n                class=\"column-group\"\n                cdkDropList\n                cdkDropListSortingDisabled\n                [cdkDropListData]=\"columns\"\n            >\n                <lib-column-item\n                    *ngFor=\"let column of columns\"\n                    trackById\n                    cdkDrag\n                    [cdkDragData]=\"column\"\n                    [column]=\"column\"\n                    [removable]=\"false\"\n                    (cdkDragStarted)=\"onDragStart($event)\"\n                    (cdkDragEnded)=\"onDragEnd()\"\n                ></lib-column-item>\n            </div>\n        </div>\n    </div>\n\n    <div *ngIf=\"datasetReady && dataOptionReady\" class=\"settings\">\n        <div class=\"scroll-group\">\n            <lib-block-data\n                *ngFor=\"let block of blocks; index as i\"\n                [block]=\"block\"\n                [value]=\"getDataOptionBlock(block)\"\n                [required]=\"isDataOptionBlockRequired(block)\"\n                (change)=\"onDataOptionBlockChange($event)\"\n            ></lib-block-data>\n\n            <lib-block-filters\n                [dataset]=\"dataset\"\n                [value]=\"dataOption.filters || []\"\n                (change)=\"onFiltersChange($event)\"\n            ></lib-block-filters>\n\n            <lib-block-sort\n                [value]=\"dataOption.sort || []\"\n                [dataBlocks]=\"dataOption.blocks\"\n                (change)=\"onSortChange($event)\"\n            ></lib-block-sort>\n\n            <lib-block-drilldown\n                *ngIf=\"config.drilldown\"\n                [value]=\"getDrilldown()\"\n                [sourceColumnIds]=\"getDrilldownColumnIds()\"\n                [dataBlocks]=\"dataOption.blocks\"\n                (change)=\"onDrilldownChange($event)\"\n            ></lib-block-drilldown>\n\n            <lib-block-heatmap\n                *ngIf=\"config.heatmap\"\n                [config]=\"config.heatmap\"\n                [items]=\"getHeatmap()\"\n                (change)=\"onHeatmapChange($event)\"\n            ></lib-block-heatmap>\n\n            <lib-block-limit\n                [value]=\"dataOption.limit!\"\n                (valueChange)=\"onLimitChange($event)\"\n            ></lib-block-limit>\n        </div>\n    </div>\n</div>\n",
      styles: [":host{--dropzone-body-border-width: 1px;--dropzone-body-border-style: dashed;--dropzone-body-border-color: #abb4ba;--dropzone-body-padding: var(--sl-spacing-3x-small);display:block}.grid{display:grid;height:100%;width:calc(100% - var(--sl-spacing-medium));grid-template-columns:50% 50%;grid-column-gap:var(--sl-spacing-medium)}h3{margin:0;font-size:var(--sl-font-size-medium);font-weight:var(--sl-font-weight-semibold)}header{display:flex;align-items:center;justify-content:space-between;margin-bottom:var(--sl-spacing-2x-small)}.scroll-group{overflow:auto;flex:1;padding:0 var(--sl-focus-ring-width)}.dataset,.settings{height:100%;display:flex;flex-direction:column}.dataset{max-height:320px}lib-column-item:hover{background:var(--sl-color-primary-50)}\n"]
    }]
  }], function () {
    return [{
      type: ConfigService
    }, {
      type: DatasetService
    }, {
      type: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataApiService
    }, {
      type: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DatasetApiService
    }, {
      type: DraggingService
    }];
  }, {
    config: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    dataOption: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    repeatable: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
    }],
    change: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }],
    error: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Output
    }],
    dataset: [],
    columns: []
  });
})();

function mapMethod(source) {
  switch (source) {
    case polymatica_widget_config__WEBPACK_IMPORTED_MODULE_1__.Method.Aggregate:
      return plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataOptionMethod.Aggregate;

    case polymatica_widget_config__WEBPACK_IMPORTED_MODULE_1__.Method.PivotTable:
      return plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataOptionMethod.PivotTable;

    case polymatica_widget_config__WEBPACK_IMPORTED_MODULE_1__.Method.Table:
      return plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.DataOptionMethod.Table;
  }
}

function fixAggregateFunctions(target) {
  if (typeof target.agg_fn === 'string') target.agg_fn = target.agg_fn.toUpperCase();
}

class AggregationSetupModule {}

AggregationSetupModule.ɵfac = function AggregationSetupModule_Factory(t) {
  return new (t || AggregationSetupModule)();
};

AggregationSetupModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({
  type: AggregationSetupModule
});
AggregationSetupModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({
  imports: [BlockDataModule, BlockDrilldownModule, BlockFiltersModule, BlockHeatmapModule, BlockLimitModule, BlockSortModule, ColumnItemModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.DragDropModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SuggestModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule, ng_track_by__WEBPACK_IMPORTED_MODULE_15__.TrackByIdModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵsetClassMetadata"](AggregationSetupModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule,
    args: [{
      imports: [BlockDataModule, BlockDrilldownModule, BlockFiltersModule, BlockHeatmapModule, BlockLimitModule, BlockSortModule, ColumnItemModule, _angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.DragDropModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SuggestModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule, ng_track_by__WEBPACK_IMPORTED_MODULE_15__.TrackByIdModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [AggregationSetupComponent],
      declarations: [AggregationSetupComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_2__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})(); /// <reference types="shoelace-style-angular/events" />

/**
 * Generated bundle index. Do not edit.
 */




/***/ })

}]);
//# sourceMappingURL=default-src_app_components_widget-icon_widget-icon_module_ts-src_app_components_widget-setup_-9788d9.js.map