"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["default-src_app_components_access_access_module_ts"],{

/***/ 8024:
/*!******************************************!*\
  !*** ./src/app/api/group-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GroupApiService": () => (/* binding */ GroupApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);


class GroupApiService {
    constructor(rest) {
        this.rest = rest;
    }
    get(id) {
        return this.rest.get(`/group/${id}`);
    }
    list(params) {
        return this.rest.get('/group', params);
    }
    save(data) {
        if (data.id) {
            return this.rest.put(`/group/${data.id}`, data);
        }
        else {
            return this.rest.post('/group', data);
        }
    }
    delete(id) {
        return this.rest.delete(`/group/${id}`);
    }
    deleteList(ids) {
        return this.rest.delete(`/group`, {
            ids,
        });
    }
}
GroupApiService.ɵfac = function GroupApiService_Factory(t) { return new (t || GroupApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
GroupApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: GroupApiService, factory: GroupApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 1908:
/*!*******************************************************!*\
  !*** ./src/app/components/access/access.component.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccessComponent": () => (/* binding */ AccessComponent),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ 9295);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access.service */ 652);
/* harmony import */ var _api_group_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../api/group-api.service */ 8024);











function AccessComponent_app_entities_13_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](0);
} if (rf & 2) {
    const group_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r5.name, " ");
} }
function AccessComponent_app_entities_13_Template(rf, ctx) { if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "app-entities", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function AccessComponent_app_entities_13_Template_app_entities_onSelect_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r6.select($event)); })("errorResponse", function AccessComponent_app_entities_13_Template_app_entities_errorResponse_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r7); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r8.errorShow($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, AccessComponent_app_entities_13_ng_template_1_Template, 1, 1, "ng-template", null, 12, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](2);
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("entitiesProvider", ctx_r1.groupsProvider)("entityTemplate", _r3)("searchInput", _r0)("selected", ctx_r1.groups);
} }
function AccessComponent_app_entities_14_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "core-avatar", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const user_r11 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("user", user_r11)("size", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 3, user_r11), " ");
} }
function AccessComponent_app_entities_14_Template(rf, ctx) { if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "app-entities", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function AccessComponent_app_entities_14_Template_app_entities_onSelect_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r12.select($event)); })("errorResponse", function AccessComponent_app_entities_14_Template_app_entities_errorResponse_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r13); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r14.errorShow($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, AccessComponent_app_entities_14_ng_template_1_Template, 4, 5, "ng-template", null, 14, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](2);
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("isUser", true)("entitiesProvider", ctx_r2.usersProvider)("entityTemplate", _r9)("searchInput", _r0)("selected", ctx_r2.users);
} }
const _c0 = function (a0, a1) { return { count: a0, total: a1 }; };
var State;
(function (State) {
    State[State["Users"] = 0] = "Users";
    State[State["Groups"] = 1] = "Groups";
})(State || (State = {}));
class AccessComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__.SubscribableComponent {
    constructor(accessService, groupApiService, userApiService, responseErrorService) {
        super();
        this.accessService = accessService;
        this.groupApiService = groupApiService;
        this.userApiService = userApiService;
        this.responseErrorService = responseErrorService;
        this.groups = [];
        this.users = [];
        this.onApply = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.onError = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = State;
        this.groupsProvider = (params) => this.groupApiService.list(Object.assign({ order_by: 'name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Asc }, params));
        this.usersProvider = (params) => this.userApiService.list(Object.assign({ order_by: 'last_name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SortDirection.Asc }, params));
        this.selected = [];
        this.total = 0;
    }
    get title() {
        const title = this.state === State.Groups ? 'groups' : 'users';
        return `access#${title}`;
    }
    get state() {
        return this.accessService.state.value;
    }
    get iconName() {
        return this.state === State.Groups ? 'people' : 'person';
    }
    ngOnChanges() {
        this.selected =
            this.state === State.Groups ? [...this.groups] : [...this.users];
    }
    ngOnInit() {
        this.subscriptions = [
            this.accessService.total.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.take)(1)).subscribe((total) => {
                this.total = total;
            }),
        ];
    }
    apply() {
        this.onApply.emit(this.selected);
    }
    select(entities) {
        this.selected = entities;
    }
    errorShow(response) {
        const key = this.state === State.Groups
            ? 'access#faildGetListGroup'
            : 'access#faildGetListUsers';
        if ((response === null || response === void 0 ? void 0 : response.status) === 500 /* HttpStatusCode.InternalServerError */) {
            this.onError.emit(response);
        }
        else {
            this.responseErrorService.show.emit({
                responseError: response,
                key,
            });
        }
    }
}
AccessComponent.ɵfac = function AccessComponent_Factory(t) { return new (t || AccessComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_access_service__WEBPACK_IMPORTED_MODULE_0__.AccessService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_api_group_api_service__WEBPACK_IMPORTED_MODULE_1__.GroupApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UserApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService)); };
AccessComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: AccessComponent, selectors: [["app-access"]], inputs: { groups: "groups", users: "users", form: "form" }, outputs: { onApply: "onApply", onError: "onError" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵNgOnChangesFeature"]], decls: 18, vars: 16, consts: [[1, "access"], [1, "header"], [1, "title"], [3, "name"], ["size", "medium", "clearable", "", 1, "search-input", 3, "placeholder"], ["searchInput", ""], ["name", "search-bold", "library", "core", "slot", "suffix"], ["name", "x", "slot", "clear-icon"], [3, "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse", 4, "ngIf"], [3, "isUser", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse", 4, "ngIf"], ["variant", "text", 1, "access-btn", 3, "click"], [3, "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse"], ["groupEntityTemplate", ""], [3, "isUser", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect", "errorResponse"], ["userEntityTemplate", ""], [3, "user", "size"]], template: function AccessComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](3, "sl-icon", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-input", 4, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](10, "sl-icon", 6)(11, "sl-icon-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](13, AccessComponent_app_entities_13_Template, 3, 4, "app-entities", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](14, AccessComponent_app_entities_14_Template, 3, 5, "app-entities", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](15, "sl-button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function AccessComponent_Template_sl_button_click_15_listener() { return ctx.apply(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("name", ctx.iconName);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind2"](6, 6, ctx.title, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction2"](13, _c0, ctx.selected.length || "0", ctx.total)), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](9, 9, "access#search"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](17, 11, "$.back"), "\n");
    } }, styles: ["[_nghost-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  flex: 1;\n}\n.access[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  flex: 1;\n}\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-large);\n}\n.title[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  font-weight: var(--sl-font-weight-semibold);\n  font-size: var(--sl-font-size-small);\n  line-height: 29px;\n  color: var(--sl-color-secondary-900);\n}\n.title[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-small);\n  font-size: var(--sl-font-size-x-large);\n}\n.title[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin: 0;\n}\n.search-input[_ngcontent-%COMP%] {\n  width: 266px;\n}\n.search-input[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%]::part(base) {\n  padding: 0;\n}\n.access-btn[_ngcontent-%COMP%] {\n  position: absolute;\n  left: var(--sl-spacing-x-large);\n  bottom: calc(var(--sl-spacing-x-large) + var(--sl-spacing-2x-small));\n}\n.access-btn[_ngcontent-%COMP%]::part(base) {\n  padding: var(--sl-spacing-2x-small) var(--sl-spacing-x-small);\n  height: auto;\n  background: transparent;\n  border: none;\n}\n.access-btn[_ngcontent-%COMP%]::part(label) {\n  padding: 0;\n  font-weight: var(--sl-font-weight-normal);\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], AccessComponent.prototype, "selected", void 0);


/***/ }),

/***/ 3864:
/*!****************************************************!*\
  !*** ./src/app/components/access/access.module.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccessModule": () => (/* binding */ AccessModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-track-by */ 1050);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access.component */ 1908);
/* harmony import */ var _entities_entities_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./entities/entities.component */ 1405);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);









class AccessModule {
}
AccessModule.ɵfac = function AccessModule_Factory(t) { return new (t || AccessModule)(); };
AccessModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({ type: AccessModule });
AccessModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PaginationModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_6__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TooltipifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UsernamePipeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AvatarModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵsetNgModuleScope"](AccessModule, { declarations: [_access_component__WEBPACK_IMPORTED_MODULE_0__.AccessComponent, _entities_entities_component__WEBPACK_IMPORTED_MODULE_1__.EntitiesComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PaginationModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_6__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TooltipifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UsernamePipeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AvatarModule], exports: [_access_component__WEBPACK_IMPORTED_MODULE_0__.AccessComponent, _entities_entities_component__WEBPACK_IMPORTED_MODULE_1__.EntitiesComponent] }); })();
_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵsetComponentScope"](_access_component__WEBPACK_IMPORTED_MODULE_0__.AccessComponent, [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AvatarComponent, _entities_entities_component__WEBPACK_IMPORTED_MODULE_1__.EntitiesComponent], [plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UsernamePipe]);


/***/ }),

/***/ 652:
/*!*****************************************************!*\
  !*** ./src/app/components/access/access.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccessService": () => (/* binding */ AccessService)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 228);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 6317);
/* harmony import */ var _access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./access.component */ 1908);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);



class AccessService {
    constructor() {
        this.total = new rxjs__WEBPACK_IMPORTED_MODULE_1__.Subject();
        this.state = new rxjs__WEBPACK_IMPORTED_MODULE_2__.BehaviorSubject(_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups);
    }
}
AccessService.ɵfac = function AccessService_Factory(t) { return new (t || AccessService)(); };
AccessService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjectable"]({ token: AccessService, factory: AccessService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 1405:
/*!******************************************************************!*\
  !*** ./src/app/components/access/entities/entities.component.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EntitiesComponent": () => (/* binding */ EntitiesComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! logical-not */ 2905);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../access.service */ 652);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-track-by */ 1050);












function EntitiesComponent_ng_container_0_p_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "access#noSearchResults"));
} }
function EntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
const _c0 = function (a0) { return { $implicit: a0 }; };
function EntitiesComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0, 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, EntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const entity_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](2, _c0, entity_r7));
} }
function EntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function EntitiesComponent_ng_container_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-checkbox", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-change", function EntitiesComponent_ng_container_0_ng_template_4_Template_sl_checkbox_sl_change_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r12); const entity_r9 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r11.onToggle(entity_r9)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, EntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const entity_r9 = ctx.$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("checked", ctx_r6.isSelected(entity_r9.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", ctx_r6.entityTemplate)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction1"](3, _c0, entity_r9));
} }
function EntitiesComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, EntitiesComponent_ng_container_0_p_2_Template, 3, 3, "p", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, EntitiesComponent_ng_container_0_ng_container_3_Template, 2, 4, "ng-container", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, EntitiesComponent_ng_container_0_ng_template_4_Template, 2, 5, "ng-template", null, 5, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "core-pagination", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onPageChange", function EntitiesComponent_ng_container_0_Template_core_pagination_onPageChange_6_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r13.onPageChange($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r0.isEmpty);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r0.entities);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("total", ctx_r0.total)("limit", ctx_r0.params.limit)("page", ctx_r0.page);
} }
function EntitiesComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "sl-spinner", 10);
} }
class EntitiesComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__.SubscribableComponent {
    constructor(accessService, hostRef, responseErrorService) {
        super();
        this.accessService = accessService;
        this.hostRef = hostRef;
        this.responseErrorService = responseErrorService;
        this.isUser = false;
        this.onSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.errorResponse = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.entities = [];
        this.params = {};
        this.total = 0;
        this.page = 1;
        this.isEmpty = false;
        this.loading = false;
        this.inited = false;
    }
    ngOnInit() {
        this.dialog = this.hostRef.nativeElement.closest('sl-dialog');
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_4__.fromEvent)(this.dialog, 'sl-show').subscribe((event) => {
                if (event.target === this.dialog) {
                    this.inited = false;
                    this.init();
                }
            }),
            (0,rxjs__WEBPACK_IMPORTED_MODULE_4__.fromEvent)(this.searchInput, 'sl-input').subscribe(() => {
                this.onSearch(this.searchInput.value);
            }),
        ];
    }
    onSearch(search) {
        this.params.search = search;
        this.params.offset = 0;
        this.page = 1;
        this.load();
    }
    isSelected(id) {
        var _a;
        return (_a = this.selected) === null || _a === void 0 ? void 0 : _a.find((item) => item.id === id);
    }
    onToggle(entity) {
        const idx = this.selected.findIndex((item) => item.id === entity.id);
        if (idx >= 0) {
            this.selected.splice(idx, 1);
        }
        else {
            this.selected.push(entity);
        }
        this.onSelect.emit(this.selected);
    }
    onPageChange(page) {
        this.page = page;
        this.params.offset = (page - 1) * this.params.limit;
        this.load();
    }
    init() {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.inited)) {
            this.inited = true;
            this.params = {
                search: '',
                limit: 20,
                offset: 0,
            };
            this.page = 1;
            this.searchInput.value = '';
            this.load();
        }
        else {
            this.searchInput.value = this.params.search || '';
        }
    }
    load() {
        this.entities = [];
        this.loading = true;
        this.entitiesProvider(this.params).subscribe({
            next: ({ rows, total }) => {
                this.entities = rows;
                this.total = total;
                this.isEmpty = total === 0;
                this.loading = false;
                this.accessService.total.next(this.total);
            },
            error: (response) => {
                this.loading = false;
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: this.isUser
                        ? 'getUsersGlobalRuleError'
                        : 'getGroupsGlobalRuleError',
                });
                this.errorResponse.emit(response);
            },
        });
    }
}
EntitiesComponent.ɵfac = function EntitiesComponent_Factory(t) { return new (t || EntitiesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_access_service__WEBPACK_IMPORTED_MODULE_1__.AccessService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService)); };
EntitiesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: EntitiesComponent, selectors: [["app-entities"]], inputs: { entitiesProvider: "entitiesProvider", entityTemplate: "entityTemplate", searchInput: "searchInput", selected: "selected", isUser: "isUser" }, outputs: { onSelect: "onSelect", errorResponse: "errorResponse" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"]], decls: 3, vars: 2, consts: [[4, "ngIf", "ngIfElse"], ["loader", ""], [1, "content"], [4, "ngIf"], ["trackById", "", 4, "ngFor", "ngForOf"], ["rowTemplate", ""], [3, "total", "limit", "page", "onPageChange"], ["trackById", ""], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["tooltipify", "", 1, "checkbox", 3, "checked", "sl-change"], [1, "spinner"]], template: function EntitiesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, EntitiesComponent_ng_container_0_Template, 7, 5, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, EntitiesComponent_ng_template_1_Template, 1, 0, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", !ctx.loading)("ngIfElse", _r1);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PaginationComponent, ng_track_by__WEBPACK_IMPORTED_MODULE_7__.TrackByIdDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TooltipifyDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  position: relative;\n  flex: 1;\n}\n.content[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-rows: repeat(10, 32px);\n  grid-auto-flow: column;\n  grid-template-columns: repeat(2, 50%);\n  grid-row-gap: 4px;\n  margin-bottom: var(--sl-spacing-large);\n}\n.checkbox[_ngcontent-%COMP%]::part(base) {\n  display: initial;\n}\n.checkbox[_ngcontent-%COMP%]::part(label) {\n  margin-left: var(--sl-spacing-x-small);\n}\n.checkbox[_ngcontent-%COMP%]::part(control) {\n  position: relative;\n  top: 3px;\n}\n.spinner[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  font-size: 1rem;\n  background: rgba(255, 255, 255, 0.5);\n}\ncore-pagination[_ngcontent-%COMP%] {\n  margin-top: calc(0px - var(--sl-spacing-small));\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVudGl0aWVzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksa0JBQUE7RUFDQSxPQUFBO0FBQ0o7QUFFQTtFQUNJLGFBQUE7RUFDQSxvQ0FBQTtFQUNBLHNCQUFBO0VBQ0EscUNBQUE7RUFDQSxpQkFBQTtFQUNBLHNDQUFBO0FBQUo7QUFJSTtFQUNJLGdCQUFBO0FBRlI7QUFLSTtFQUNJLHNDQUFBO0FBSFI7QUFNSTtFQUNJLGtCQUFBO0VBQ0EsUUFBQTtBQUpSO0FBUUE7RUFDSSxrQkFBQTtFQUNBLFFBQUE7RUFDQSxTQUFBO0VBQ0EsZ0NBQUE7RUFDQSxlQUFBO0VBQ0Esb0NBQUE7QUFOSjtBQVNBO0VBQ0ksK0NBQUE7QUFQSiIsImZpbGUiOiJlbnRpdGllcy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgZmxleDogMTtcbn1cblxuLmNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGdyaWQ7XG4gICAgZ3JpZC10ZW1wbGF0ZS1yb3dzOiByZXBlYXQoMTAsIDMycHgpO1xuICAgIGdyaWQtYXV0by1mbG93OiBjb2x1bW47XG4gICAgZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOiByZXBlYXQoMiwgNTAlKTtcbiAgICBncmlkLXJvdy1nYXA6IDRweDtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcbn1cblxuLmNoZWNrYm94IHtcbiAgICAmOjpwYXJ0KGJhc2UpIHtcbiAgICAgICAgZGlzcGxheTogaW5pdGlhbDtcbiAgICB9XG5cbiAgICAmOjpwYXJ0KGxhYmVsKSB7XG4gICAgICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXgtc21hbGwpO1xuICAgIH1cblxuICAgICY6OnBhcnQoY29udHJvbCkge1xuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgIHRvcDogM3B4O1xuICAgIH1cbn1cblxuLnNwaW5uZXIge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB0b3A6IDUwJTtcbiAgICBsZWZ0OiA1MCU7XG4gICAgdHJhbnNmb3JtOiB0cmFuc2xhdGUoLTUwJSwgLTUwJSk7XG4gICAgZm9udC1zaXplOiAxcmVtO1xuICAgIGJhY2tncm91bmQ6IHJnYmEoMjU1LCAyNTUsIDI1NSwgMC41KTtcbn1cblxuY29yZS1wYWdpbmF0aW9uIHtcbiAgICBtYXJnaW4tdG9wOiBjYWxjKDBweCAtIHZhcigtLXNsLXNwYWNpbmctc21hbGwpKTtcbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], EntitiesComponent.prototype, "entities", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.Debounce)(300)
], EntitiesComponent.prototype, "onSearch", null);


/***/ })

}]);
//# sourceMappingURL=default-src_app_components_access_access_module_ts.js.map