"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_api_project-api_service_ts-src_app_api_theme-api_service_ts-src_app_interfaces_projec-2c43d9"],{

/***/ 37444:
/*!********************************************!*\
  !*** ./src/app/api/project-api.service.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectApiService": () => (/* binding */ ProjectApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);



class ProjectApiService {
    constructor(restService, coreRestService) {
        this.restService = restService;
        this.coreRestService = coreRestService;
    }
    get(id) {
        return this.restService.get(`/project/${id}`);
    }
    list(query) {
        return this.restService.get('/project', query);
    }
    save(project) {
        if (project.id) {
            return this.restService.put(`/project/${project.id}`, project);
        }
        else {
            return this.restService.post('/project', project);
        }
    }
    delete(id) {
        return this.restService.delete(`/project`, { ids: id });
    }
    deleteList(ids) {
        return this.restService.delete(`/project`, {
            ids,
        });
    }
    copy(id) {
        return this.restService.post(`/project/${id}/copy`);
    }
    getAnalyticsRedirect(url) {
        return this.coreRestService.get(url);
    }
}
ProjectApiService.ɵfac = function ProjectApiService_Factory(t) { return new (t || ProjectApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.CoreApi)); };
ProjectApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ProjectApiService, factory: ProjectApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 13745:
/*!******************************************!*\
  !*** ./src/app/api/theme-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeApiService": () => (/* binding */ ThemeApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class ThemeApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(id) {
        return this.restService.get(`/theme/${id}`);
    }
    list(params) {
        return this.restService.get('/theme', params);
    }
    save(theme) {
        if (theme.id) {
            return this.restService.put(`/theme/${theme.id}`, theme);
        }
        else {
            return this.restService.post('/theme', theme);
        }
    }
    deleteList(ids) {
        return this.restService.delete(`/theme`, { ids });
    }
}
ThemeApiService.ɵfac = function ThemeApiService_Factory(t) { return new (t || ThemeApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ThemeApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ThemeApiService, factory: ThemeApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 16847:
/*!***************************************!*\
  !*** ./src/app/interfaces/project.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DashboardPostMessageEvent": () => (/* binding */ DashboardPostMessageEvent),
/* harmony export */   "ProjectIcon": () => (/* binding */ ProjectIcon),
/* harmony export */   "ThemeColor": () => (/* binding */ ThemeColor)
/* harmony export */ });
var DashboardPostMessageEvent;
(function (DashboardPostMessageEvent) {
    DashboardPostMessageEvent["Interact"] = "interact";
    DashboardPostMessageEvent["GoTo"] = "goTo";
    DashboardPostMessageEvent["TriggerValue"] = "triggerValue";
    DashboardPostMessageEvent["SetFilter"] = "setFilter";
    DashboardPostMessageEvent["Resize"] = "resize";
    DashboardPostMessageEvent["ChangeFilter"] = "changeFilter";
    DashboardPostMessageEvent["ChangeProjectState"] = "changeProjectState";
})(DashboardPostMessageEvent || (DashboardPostMessageEvent = {}));
var ThemeColor;
(function (ThemeColor) {
    ThemeColor["Polymatica"] = "polymatica";
    ThemeColor["C1"] = "c1";
    ThemeColor["C2"] = "c2";
    ThemeColor["Grey"] = "grey";
    ThemeColor["Green"] = "green";
    ThemeColor["Pink"] = "pink";
    ThemeColor["Blue"] = "blue";
    ThemeColor["Yellow"] = "yellow";
    ThemeColor["Red"] = "red";
    ThemeColor["Mixed"] = "mixed";
    ThemeColor["Circus"] = "circus";
    ThemeColor["Custom1"] = "custom1";
})(ThemeColor || (ThemeColor = {}));
var ProjectIcon;
(function (ProjectIcon) {
    ProjectIcon["Antique"] = "antique";
    ProjectIcon["Atom"] = "atom";
    ProjectIcon["Box"] = "box";
    ProjectIcon["Briefcase"] = "briefcase";
    ProjectIcon["ChartDonut"] = "chart-donut";
    ProjectIcon["Chip"] = "chip";
    ProjectIcon["Clock"] = "clock";
    ProjectIcon["Construction"] = "construction";
    ProjectIcon["CubeEdges"] = "cube-edges";
    ProjectIcon["Cube"] = "cube";
    ProjectIcon["Document"] = "document";
    ProjectIcon["Factory"] = "factory";
    ProjectIcon["Figure3d"] = "figure-3d";
    ProjectIcon["Flag"] = "flag";
    ProjectIcon["GroceryTrolley"] = "grocery-trolley";
    ProjectIcon["Lab"] = "lab";
    ProjectIcon["Lifebuoy"] = "lifebuoy";
    ProjectIcon["Lightning"] = "lightning";
    ProjectIcon["Moneybag"] = "moneybag";
    ProjectIcon["Moon"] = "moon";
    ProjectIcon["Plane"] = "plane";
    ProjectIcon["Planet"] = "planet";
    ProjectIcon["Plus"] = "plus";
    ProjectIcon["Pumpjack"] = "pumpjack";
    ProjectIcon["Truck"] = "truck";
})(ProjectIcon || (ProjectIcon = {}));


/***/ }),

/***/ 35579:
/*!****************************************************!*\
  !*** ./src/app/pages/widgets/widgets.component.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetsComponent": () => (/* binding */ WidgetsComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 14474);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs/operators */ 54366);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs/operators */ 65613);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs/operators */ 7048);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs/operators */ 94850);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_enums_module_rights__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/enums/module-rights */ 24475);
/* harmony import */ var project_enums_widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/enums/widget */ 79982);
/* harmony import */ var project_enums_http_error_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/enums/http-error-state */ 14780);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var project_api_widget_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/api/widget-api.service */ 93142);
/* harmony import */ var project_services_project_project_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/services/project/project.service */ 64439);
/* harmony import */ var project_pages_project_action_panel_widgets_select_widgets_select_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! project/pages/project/action-panel/widgets-select/widgets-select.service */ 96749);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _components_datasets_last_update_datasets_last_update_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/datasets-last-update/datasets-last-update.component */ 82314);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ng-track-by */ 61245);
/* harmony import */ var _components_widget_icon_widget_icon_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/widget-icon/widget-icon.component */ 83901);
/* harmony import */ var _components_widget_widget_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/widget/widget.component */ 50993);
/* harmony import */ var _components_widget_setup_widget_setup_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../components/widget-setup/widget-setup.component */ 45266);























const _c0 = ["drawer"];
const _c1 = ["thumb"];
function WidgetsComponent_sl_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_sl_button_2_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](68); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](_r15.show(ctx_r18.selected)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    const count_r17 = ctx.ngIf;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate2"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 2, "$.delete"), " ", count_r17, " ");
} }
function WidgetsComponent_sl_button_4_Template(rf, ctx) { if (rf & 1) {
    const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_sl_button_4_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r21); _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](62); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](_r13.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](3, "sl-icon", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 1, "addButton"), " ");
} }
function WidgetsComponent_core_error_state_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "core-error-state", 33);
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("code", 500);
} }
function WidgetsComponent_core_table_8_tr_29_core_table_checkbox_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "core-table-checkbox", 50);
} if (rf & 2) {
    const widget_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("value", widget_r23);
} }
function WidgetsComponent_core_table_8_tr_29_app_widget_icon_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "app-widget-icon", 51);
} if (rf & 2) {
    const widget_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]().$implicit;
    const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("root", ctx_r25.components[widget_r23.component_id].path);
} }
function WidgetsComponent_core_table_8_tr_29_sl_tooltip_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-tooltip", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](2, "sl-icon", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("content", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](1, 1, "widgetVersionChanged"));
} }
function WidgetsComponent_core_table_8_tr_29_core_action_18_Template(rf, ctx) { if (rf & 1) {
    const _r33 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "core-action", 54);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_core_table_8_tr_29_core_action_18_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r33); const widget_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]().$implicit; const ctx_r31 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2); const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](62); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](_r13.show(ctx_r31.getWidget(widget_r23))); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} }
function WidgetsComponent_core_table_8_tr_29_core_action_19_Template(rf, ctx) { if (rf & 1) {
    const _r36 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "core-action", 55);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_core_table_8_tr_29_core_action_19_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r36); const widget_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2); const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](64); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](_r14.show(widget_r23)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} }
function WidgetsComponent_core_table_8_tr_29_Template(rf, ctx) { if (rf & 1) {
    const _r38 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "tr", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_core_table_8_tr_29_Template_tr_click_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r38); const widget_r23 = restoredCtx.$implicit; const ctx_r37 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r37.showDetails(widget_r23, ctx_r37.components[widget_r23.component_id])); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](2, WidgetsComponent_core_table_8_tr_29_core_table_checkbox_2_Template, 1, 1, "core-table-checkbox", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](4, WidgetsComponent_core_table_8_tr_29_app_widget_icon_4_Template, 1, 1, "app-widget-icon", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](5, "td", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](7, "td", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](9, "td", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](11, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](12, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](13, "core-relative-time", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](14, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](15, "core-relative-time", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](16, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_core_table_8_tr_29_Template_td_click_16_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r38); const ctx_r39 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r39.stopDetailsPropagation($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](17, WidgetsComponent_core_table_8_tr_29_sl_tooltip_17_Template, 3, 3, "sl-tooltip", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](18, WidgetsComponent_core_table_8_tr_29_core_action_18_Template, 1, 0, "core-action", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](19, WidgetsComponent_core_table_8_tr_29_core_action_19_Template, 1, 0, "core-action", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const widget_r23 = ctx.$implicit;
    const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵclassProp"]("hidden", ctx_r22.isHideCheckboxController());
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", widget_r23.access_right === ctx_r22.AccessRight.Full);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", widget_r23.component_id);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", widget_r23.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", widget_r23.description, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](11, 14, ctx_r22.users[widget_r23.owner_id]));
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("date", widget_r23.create_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("date", widget_r23.update_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵclassProp"]("hidden", ctx_r22.isShowActions());
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", widget_r23.component_changed);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", widget_r23.access_right !== ctx_r22.AccessRight.Read);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", widget_r23.access_right === ctx_r22.AccessRight.Full);
} }
function WidgetsComponent_core_table_8_Template(rf, ctx) { if (rf & 1) {
    const _r41 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "core-table", 34)(1, "thead")(2, "tr")(3, "th")(4, "core-table-checkbox-controller", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("change", function WidgetsComponent_core_table_8_Template_core_table_checkbox_controller_change_4_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r41); const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r40.selected = $event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](5, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](6, "th", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](9, "core-table-sort", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](10, "th", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](13, "core-table-sort", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](14, "th", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](16, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](17, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](19, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](20, "core-table-sort", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](21, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](23, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](24, "core-table-sort", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](25, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](26);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](27, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](28, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](29, WidgetsComponent_core_table_8_tr_29_Template, 20, 16, "tr", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("total", ctx_r3.widgetsTotal);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵclassProp"]("hidden", ctx_r3.isHideCheckboxController());
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](8, 12, "$.name"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](12, 14, "description"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](16, 16, "#owner"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](19, 18, "$.createDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](23, 20, "$.updateDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵclassProp"]("hidden", ctx_r3.isShowActions());
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](27, 22, "$.actions"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngForOf", ctx_r3.widgets);
} }
function WidgetsComponent_core_empty_state_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "core-empty-state", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](1, 2, "emptyState.title"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 4, "emptyState.description"));
} }
function WidgetsComponent_sl_button_16_Template(rf, ctx) { if (rf & 1) {
    const _r43 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_sl_button_16_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r43); const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](64); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](_r14.show(ctx_r42.details.widget)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](3, "sl-icon", 57);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 1, "$.delete"), " ");
} }
function WidgetsComponent_sl_button_17_Template(rf, ctx) { if (rf & 1) {
    const _r45 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function WidgetsComponent_sl_button_17_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r45); const ctx_r44 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](62); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](_r13.show(ctx_r44.details.widget)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](3, "sl-icon", 58);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 1, "$.edit"), " ");
} }
function WidgetsComponent_app_widget_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "app-widget", 59);
} if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("dependence", ctx_r9.dep);
} }
function WidgetsComponent_ng_container_36_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](1, "a", 62);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const dataset_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]().$implicit;
    const ctx_r47 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpropertyInterpolate2"]("href", "", ctx_r47.url, "dataset/", dataset_r46.id, "", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", dataset_r46.name, " ");
} }
function WidgetsComponent_ng_container_36_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](0);
} if (rf & 2) {
    const dataset_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](dataset_r46.name);
} }
function WidgetsComponent_ng_container_36_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](1, WidgetsComponent_ng_container_36_ng_container_1_Template, 3, 3, "ng-container", 60);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](2, WidgetsComponent_ng_container_36_ng_template_2_Template, 1, 1, "ng-template", null, 61, _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const dataset_r46 = ctx.$implicit;
    const _r48 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](3);
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", dataset_r46.access_right !== ctx_r10.AccessRight.NotAllowed)("ngIfElse", _r48);
} }
function WidgetsComponent_div_37_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 15)(1, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](4, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](3, 2, "component"));
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](ctx_r11.details.widget.component == null ? null : ctx_r11.details.widget.component.name);
} }
function WidgetsComponent_div_42_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 1, ctx_r12.users[ctx_r12.details.widget.owner_id]), " ");
} }
function WidgetsComponent_div_70_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    const widget_r52 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](widget_r52.name);
} }
class WidgetsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_11__.SubscribableComponent {
    constructor(accessRightsService, activatedRoute, appService, notifyService, pageService, widgetApiService, projectService, responseErrorService, widgetsSelectService) {
        super();
        this.accessRightsService = accessRightsService;
        this.activatedRoute = activatedRoute;
        this.appService = appService;
        this.notifyService = notifyService;
        this.pageService = pageService;
        this.widgetApiService = widgetApiService;
        this.projectService = projectService;
        this.responseErrorService = responseErrorService;
        this.widgetsSelectService = widgetsSelectService;
        this.ModuleRights = project_enums_module_rights__WEBPACK_IMPORTED_MODULE_0__.ModuleRights;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.AccessRight;
        this.widgets = [];
        this.datasetInfoArray = [];
        this.show = true;
        this.widgetsTotal = 0;
        this.isEmpty = false;
        this.selected = [];
        this.url = this.appService.managerUrl;
        this.details = {
            show: false,
        };
        this.mapDefs = new Map();
        this.HTTPErrorStates = project_enums_http_error_state__WEBPACK_IMPORTED_MODULE_2__.HttPErrorState;
        this.responseServerError = null;
    }
    ngOnInit() {
        this.projectService.setDefaultTheme();
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe(() => this.load()),
            this.widgetsSelectService.dependence.subscribe((dependence) => {
                if (dependence) {
                    this.dep = dependence;
                }
            }),
            this.widgetsSelectService.show.subscribe((show) => {
                this.show = show;
            }),
        ];
    }
    getWidget(widget) {
        widget.component = this.components[widget.component_id];
        return widget;
    }
    onWidgetSave(created) {
        this.notifyService.toastByName(`widget-${created ? 'created' : 'edited'}`);
        this.load();
    }
    showDetails(widget, component) {
        widget.component = component;
        Object.assign(this.details, {
            show: true,
            widget,
        });
        this.widgetApiService
            .widgetInformation(widget.id.toString())
            .subscribe(({ row }) => {
            this.datasetInfoArray = row.datasets;
        });
        this.dep = this.mapDefs.get(widget.id);
        if (!this.dep) {
            this.dep = this.projectService.makeDependence({
                type: project_enums_widget__WEBPACK_IMPORTED_MODULE_1__.WidgetType.Widget,
                payload: null,
                gridster_settings: {
                    x: 0,
                    y: 0,
                    rows: 0,
                    cols: 0,
                },
            }, widget);
            this.mapDefs.set(widget.id, this.dep);
        }
        this.projectService.loadData([this.dep]).subscribe();
        const drawer = this.drawer.nativeElement;
        const thumb = this.thumb.nativeElement;
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.fromEvent)(thumb, 'mousedown')
                .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_14__.switchMap)(() => {
                const mouseUp = (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.fromEvent)(document, 'mouseup');
                drawer.style.transition = '0ms';
                return (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.fromEvent)(document, 'mousemove').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.takeUntil)(mouseUp), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.tap)((event) => {
                    event.preventDefault();
                    this.drawerWidth =
                        (window.innerWidth - event.pageX).toString() + 'px';
                }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.finalize)(() => {
                    drawer.style.transition = 'width 0.4s';
                }));
            }))
                .subscribe(),
        ];
    }
    stopDetailsPropagation(event) {
        event.stopPropagation();
    }
    deleteWidget(widget) {
        this.deleteWidgets([widget]);
    }
    deleteWidgets(widgets) {
        this.pageService.loading = true;
        this.widgetApiService
            .deleteList(widgets.map((widget) => widget.id))
            .subscribe({
            next: () => {
                this.selected = [];
                this.load();
                if (widgets.length === 1) {
                    this.notifyService.toastByName('widgetDelete');
                }
                else {
                    this.notifyService.toastByName('widgetsDelete');
                }
                this.hideDetails();
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: this.getKey(widgets),
                });
            },
        });
    }
    isHideCheckboxController() {
        return this.widgets.every((widgets) => widgets.access_right !== plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.AccessRight.Full);
    }
    isShowActions() {
        return !this.widgets.some((widgets) => widgets.access_right !== plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.AccessRight.Read);
    }
    load() {
        this.pageService.loading = true;
        const params = this.activatedRoute.snapshot.queryParams;
        this.widgetApiService.list(params).subscribe({
            next: ({ rows, total, users, components }) => {
                this.widgets = rows;
                this.components = components;
                this.widgetsTotal = total;
                this.users = users;
                this.isEmpty = total === 0;
                this.pageService.loading = false;
            },
            error: (response) => {
                if (response?.status === 500 /* HttpStatusCode.InternalServerError */) {
                    this.responseServerError = project_enums_http_error_state__WEBPACK_IMPORTED_MODULE_2__.HttPErrorState.HTTPError500;
                }
                else {
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: 'widget#notification.error.getWidgets',
                    });
                }
                this.pageService.loading = false;
            },
        });
    }
    getKey(widgets) {
        const key = widgets.length > 1 ? 'deleteWidgets' : 'deleteWidget';
        return 'widget#notification.error.' + key;
    }
    hideDetails() {
        this.details = { ...this.details, widget: undefined, show: false };
    }
}
WidgetsComponent.ɵfac = function WidgetsComponent_Factory(t) { return new (t || WidgetsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.AccessRightsService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_18__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.PageService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_api_widget_api_service__WEBPACK_IMPORTED_MODULE_3__.WidgetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_services_project_project_service__WEBPACK_IMPORTED_MODULE_4__.ProjectService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_pages_project_action_panel_widgets_select_widgets_select_service__WEBPACK_IMPORTED_MODULE_5__.WidgetsSelectService)); };
WidgetsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineComponent"]({ type: WidgetsComponent, selectors: [["app-widgets"]], viewQuery: function WidgetsComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵviewQuery"](_c1, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵloadQuery"]()) && (ctx.drawer = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵloadQuery"]()) && (ctx.thumb = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵInheritDefinitionFeature"]], decls: 77, vars: 61, consts: [[3, "title", "counter"], ["variant", "danger", 3, "click", 4, "ngIf"], ["variant", "primary", 3, "click", 4, "accessRights"], [3, "ngSwitch"], [3, "code", 4, "ngSwitchCase"], [3, "total", 4, "ngIf"], ["imageSrc", "assets/empty-state/widgets.svg", 3, "title", "description", 4, "ngIf"], [3, "open", "openChange", "hide"], ["drawer", ""], [1, "thumb"], ["thumb", ""], ["name", "grip-vertical"], [1, "controls"], ["variant", "primary", 3, "click", 4, "ngIf"], [3, "dependence", 4, "ngIf"], [1, "info"], ["tooltipify", ""], [4, "ngFor", "ngForOf"], ["class", "info", 4, "ngIf"], [4, "ngIf"], [3, "date"], [3, "datasetInfoArray"], [3, "save"], ["widgetSetup", ""], [3, "title", "description", "ok"], ["deleteConfirm", ""], [3, "title", "ok"], ["multiDeleteConfirm", ""], ["variant", "success", "name", "widgetDelete"], ["variant", "success", "name", "widgetsDelete"], ["variant", "danger", 3, "click"], ["variant", "primary", 3, "click"], ["name", "plus", "slot", "suffix"], [3, "code"], [3, "total"], [3, "change"], ["width", "10vw"], ["routing", "", "by", "name"], ["routing", "", "by", "description"], ["routing", "", "by", "create_date"], ["routing", "", "by", "update_date"], [3, "click", 4, "ngFor", "ngForOf"], [3, "click"], [3, "value", 4, "ngIf"], [3, "root", 4, "ngIf"], ["maxWidth", "20vw"], ["maxWidth", "10vw"], ["placement", "top-end", 3, "content", 4, "ngIf"], ["type", "setup", 3, "click", 4, "ngIf"], ["type", "delete", 3, "click", 4, "ngIf"], [3, "value"], [3, "root"], ["placement", "top-end", 3, "content"], ["name", "exclamation-triangle-fill", 1, "change-control-icon"], ["type", "setup", 3, "click"], ["type", "delete", 3, "click"], ["imageSrc", "assets/empty-state/widgets.svg", 3, "title", "description"], ["slot", "suffix", "name", "trash"], ["slot", "suffix", "name", "pencil"], [3, "dependence"], [4, "ngIf", "ngIfElse"], ["readOnlyDataset", ""], ["target", "_blank", "trackById", "", 1, "content", 3, "href"]], template: function WidgetsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "core-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](2, WidgetsComponent_sl_button_2_Template, 3, 4, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](3, "core-table-filter");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](4, WidgetsComponent_sl_button_4_Template, 4, 3, "sl-button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](5, 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](6, WidgetsComponent_core_error_state_6_Template, 1, 1, "core-error-state", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](7, "core-content");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](8, WidgetsComponent_core_table_8_Template, 30, 24, "core-table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](9, WidgetsComponent_core_empty_state_9_Template, 3, 6, "core-empty-state", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](10, "sl-drawer", 7, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("openChange", function WidgetsComponent_Template_sl_drawer_openChange_10_listener($event) { return ctx.details.show = $event; })("hide", function WidgetsComponent_Template_sl_drawer_hide_10_listener() { return ctx.dep = undefined; });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](12, "div", 9, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](14, "sl-icon", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](15, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](16, WidgetsComponent_sl_button_16_Template, 4, 3, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](17, WidgetsComponent_sl_button_17_Template, 4, 3, "sl-button", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](18, WidgetsComponent_app_widget_18_Template, 1, 1, "app-widget", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](19, "div", 15)(20, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](23, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](25, "div", 15)(26, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](29, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](30);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](31, "div", 15)(32, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](35, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](36, WidgetsComponent_ng_container_36_Template, 4, 2, "ng-container", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](37, WidgetsComponent_div_37_Template, 6, 4, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](38, "div", 15)(39, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](40);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](41, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](42, WidgetsComponent_div_42_Template, 3, 3, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](43, "div", 15)(44, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](45);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](46, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](47, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](48, "core-relative-time", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](49, "div", 15)(50, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](51);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](52, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](53, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](54, "core-relative-time", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](55, "div", 15)(56, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](57);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](58, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](59, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](60, "app-datasets-last-update", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](61, "app-widget-setup", 22, 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("save", function WidgetsComponent_Template_app_widget_setup_save_61_listener($event) { return ctx.onWidgetSave($event.created); });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](63, "core-confirm", 24, 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("ok", function WidgetsComponent_Template_core_confirm_ok_63_listener($event) { return ctx.deleteWidget($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](65, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](66, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](67, "core-confirm", 26, 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("ok", function WidgetsComponent_Template_core_confirm_ok_67_listener($event) { return ctx.deleteWidgets($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](69, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](70, WidgetsComponent_div_70_Template, 2, 1, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](71, "core-notify", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](72);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](73, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](74, "core-notify", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](75);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](76, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](1, 35, "title"))("counter", ctx.widgetsTotal);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.selected.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("accessRights", ctx.ModuleRights.WidgetFullAccess);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngSwitch", ctx.responseServerError);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngSwitchCase", ctx.HTTPErrorStates.HTTPError500);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.widgets.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.isEmpty);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵstyleProp"]("--size", ctx.drawerWidth);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("open", ctx.details.show);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", (ctx.details.widget == null ? null : ctx.details.widget.access_right) === ctx.AccessRight.Full);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", (ctx.details.widget == null ? null : ctx.details.widget.access_right) !== ctx.AccessRight.Read);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.dep && ctx.show);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](22, 37, "$.name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", ctx.details.widget == null ? null : ctx.details.widget.name, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](28, 39, "description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", ctx.details.widget == null ? null : ctx.details.widget.description, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](34, 41, "dataset"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngForOf", ctx.datasetInfoArray);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.details.widget);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](41, 43, "owner"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.details.widget);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](46, 45, "createDate"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("date", ctx.details.widget == null ? null : ctx.details.widget.create_date);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](52, 47, "updateDate"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("date", ctx.details.widget == null ? null : ctx.details.widget.update_date);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](58, 49, "dateLastUpdate"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("datasetInfoArray", ctx.datasetInfoArray);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](65, 51, "deleteConfirm.title"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](66, 53, "deleteConfirm.description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](69, 55, "multiDeleteConfirm.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngForOf", ctx.selected);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](73, 57, "widgetDelete"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](76, 59, "widgetsDelete"), "\n");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.ActionComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.ConfirmComponent, _angular_common__WEBPACK_IMPORTED_MODULE_19__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_19__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_19__.NgSwitch, _angular_common__WEBPACK_IMPORTED_MODULE_19__.NgSwitchCase, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.ContentComponent, _components_datasets_last_update_datasets_last_update_component__WEBPACK_IMPORTED_MODULE_6__.DatasetsLastUpdateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.EmptyStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.ErrorStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.HeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.RelativeTimeComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_20__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_20__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_20__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableCheckboxComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableCheckboxControllerComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableFilterComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableSortRoutingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.WidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TooltipifyDirective, ng_track_by__WEBPACK_IMPORTED_MODULE_21__.TrackByIdDirective, _components_widget_icon_widget_icon_component__WEBPACK_IMPORTED_MODULE_7__.WidgetIconComponent, _components_widget_widget_component__WEBPACK_IMPORTED_MODULE_8__.WidgetComponent, _components_widget_setup_widget_setup_component__WEBPACK_IMPORTED_MODULE_9__.WidgetSetupComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.AccessRightsDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.UsernamePipe], styles: ["tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\ncore-header[_ngcontent-%COMP%], core-content[_ngcontent-%COMP%] {\n  padding: 0;\n}\n.controls[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  margin-bottom: var(--sl-spacing-2x-large);\n}\n.controls[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-medium);\n}\n.info[_ngcontent-%COMP%] {\n  display: flex;\n  margin-bottom: var(--sl-spacing-small);\n  padding: 0 var(--sl-spacing-medium);\n}\n.info[_ngcontent-%COMP%]    > [_ngcontent-%COMP%]:first-child {\n  font-weight: bold;\n  margin-right: var(--sl-spacing-2x-small);\n}\n.info[_ngcontent-%COMP%]    > [_ngcontent-%COMP%]:last-child {\n  flex: 1;\n}\n.change-control-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-warning-400);\n}\n.content[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n  position: relative;\n  display: inline-block;\n}\n.content[_ngcontent-%COMP%]::after {\n  position: absolute;\n  content: ';';\n  right: -5px;\n}\n.content[_ngcontent-%COMP%]:last-child::after {\n  content: none;\n}\nsl-drawer[_ngcontent-%COMP%] {\n  position: relative;\n}\nsl-drawer[_ngcontent-%COMP%]   .thumb[_ngcontent-%COMP%] {\n  position: absolute;\n  display: flex;\n  align-items: center;\n  height: 100vh;\n  cursor: col-resize;\n  z-index: 10;\n  top: 0;\n  left: 0;\n  background-color: var(--sl-color-secondary-100);\n}\nsl-drawer[_ngcontent-%COMP%]   .thumb[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-x-large);\n  top: 50%;\n}\nsl-drawer[_ngcontent-%COMP%]   app-widget[_ngcontent-%COMP%] {\n  max-height: 50%;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "widgets", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "drawerWidth", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "users", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "components", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "datasetInfoArray", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "show", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_23__.WatchChanges)()
], WidgetsComponent.prototype, "dep", void 0);


/***/ }),

/***/ 64334:
/*!*************************************************!*\
  !*** ./src/app/pages/widgets/widgets.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetsModule": () => (/* binding */ WidgetsModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ng-track-by */ 61245);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_components_datasets_last_update_datasets_last_update_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/components/datasets-last-update/datasets-last-update.module */ 85488);
/* harmony import */ var project_components_widget_icon_widget_icon_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/components/widget-icon/widget-icon.module */ 46076);
/* harmony import */ var project_components_widget_setup_widget_setup_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/components/widget-setup/widget-setup.module */ 86366);
/* harmony import */ var project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/components/widget/widget.module */ 42975);
/* harmony import */ var project_enums_module_rights__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/enums/module-rights */ 24475);
/* harmony import */ var _widgets_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widgets.component */ 35579);
/* harmony import */ var plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! plmt-core-library/filters */ 57991);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 64565);














class WidgetsModule {
}
WidgetsModule.ɵfac = function WidgetsModule_Factory(t) { return new (t || WidgetsModule)(); };
WidgetsModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineNgModule"]({ type: WidgetsModule });
WidgetsModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.providePageTranslations)({
            sources: [
                'assets/i18n/widgets/',
                'assets/i18n/components/widget-setup/',
                'assets/aggregation-setup/i18n/',
                'assets/i18n/components/datasets-last-update/',
                'assets/core-library/i18n/filters/',
                'assets/i18n/components/widget/',
                'assets/i18n/components/dashboard/',
            ],
            keyInterpolation: {
                ...plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_8__.filtersInterpolationKeys,
            },
        }),
    ], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ActionModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ConfirmModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ContentModule,
        project_components_datasets_last_update_datasets_last_update_module__WEBPACK_IMPORTED_MODULE_0__.DatasetsLastUpdateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ErrorStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.RelativeTimeModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_10__.RouterModule.forChild([
            {
                path: '',
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.PageTranslationsGuard, plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.AccessRightsGuard],
                data: (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.routeDate)({
                    accessRights: {
                        rights: [
                            project_enums_module_rights__WEBPACK_IMPORTED_MODULE_4__.ModuleRights.WidgetView,
                            project_enums_module_rights__WEBPACK_IMPORTED_MODULE_4__.ModuleRights.WidgetFullAccess,
                        ],
                    },
                }),
                component: _widgets_component__WEBPACK_IMPORTED_MODULE_5__.WidgetsComponent,
            },
        ]),
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_11__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TableModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TooltipifyModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_12__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.UsernamePipeModule,
        project_components_widget_icon_widget_icon_module__WEBPACK_IMPORTED_MODULE_1__.WidgetIconModule,
        project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_3__.WidgetModule,
        project_components_widget_setup_widget_setup_module__WEBPACK_IMPORTED_MODULE_2__.WidgetSetupModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.AccessRightsDirectiveModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵsetNgModuleScope"](WidgetsModule, { declarations: [_widgets_component__WEBPACK_IMPORTED_MODULE_5__.WidgetsComponent], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ActionModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ConfirmModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ContentModule,
        project_components_datasets_last_update_datasets_last_update_module__WEBPACK_IMPORTED_MODULE_0__.DatasetsLastUpdateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ErrorStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.RelativeTimeModule, _angular_router__WEBPACK_IMPORTED_MODULE_10__.RouterModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_11__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TableModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TooltipifyModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_12__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.UsernamePipeModule,
        project_components_widget_icon_widget_icon_module__WEBPACK_IMPORTED_MODULE_1__.WidgetIconModule,
        project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_3__.WidgetModule,
        project_components_widget_setup_widget_setup_module__WEBPACK_IMPORTED_MODULE_2__.WidgetSetupModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.AccessRightsDirectiveModule] }); })();


/***/ })

}]);
//# sourceMappingURL=src_app_api_project-api_service_ts-src_app_api_theme-api_service_ts-src_app_interfaces_projec-2c43d9.js.map