const tagName = 'core-page-loading';

class AppLoading extends HTMLElement {
    constructor() {
        super();

        const shadowDOM = this.attachShadow({ mode: 'open' });

        const spinner = document.createElement('div');

        spinner.setAttribute('class', 'spinner');

        const style = document.createElement('style');

        style.textContent = `
            :host {
                position: fixed;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                z-index: 1;
                
                --track-color: var(--sl-color-secondary-900) / 20%;
                --indicator-color: var(--sl-color-primary-600);
            }

            .spinner {
                width: 3em;
                height: 3em;
                border-radius: 50%;
                border: 5px solid;
                border-top-color: var(--indicator-color);
                border-right-color: var(--indicator-color);
                border-bottom-color: var(--track-color);
                border-left-color: var(--track-color);
                animation: 1s linear infinite spin;
            }

            @keyframes spin {
                0% {
                    transform: rotate(0deg);
                }

                100% {
                    transform: rotate(360deg);
                }
            }
        `;

        shadowDOM.appendChild(spinner);
        shadowDOM.appendChild(style);
    }
}

customElements.define(tagName, AppLoading);

const body = document.querySelector('body');

if (body) {
    const appLoading = document.createElement(tagName);

    body.appendChild(appLoading);
} else {
    const message = `
        Append in <BODY>:
        <script type="module" src="assets/core-library/page-loading/component.js"></script>
    `.trim();

    throw new Error(message);
}
