"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_pages_components_widgets_widgets_module_ts"],{

/***/ 52290:
/*!**********************************************!*\
  !*** ./src/app/api/component-api.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComponentApiService": () => (/* binding */ ComponentApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class ComponentApiService {
    constructor(restService) {
        this.restService = restService;
    }
    list(query = {}) {
        return this.restService.get('/component', query);
    }
    upload(file) {
        const formData = new FormData();
        formData.append('file', file);
        return this.restService.post(`/component/upload`, formData);
    }
    save(component) {
        if (component.id) {
            return this.restService.put(`/component/${component.id}`, component);
        }
        else {
            return this.restService.post('/component', component);
        }
    }
    get(id) {
        return this.restService.get(`/component/${id}`);
    }
    deleteList(ids) {
        return this.restService.delete(`/component`, { ids });
    }
}
ComponentApiService.ɵfac = function ComponentApiService_Factory(t) { return new (t || ComponentApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ComponentApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ComponentApiService, factory: ComponentApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 90129:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/components/component-modal/component-modal.component.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComponentModalComponent": () => (/* binding */ ComponentModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 48665);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_api_component_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/api/component-api.service */ 52290);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! shoelace-style-angular */ 39652);










function ComponentModalComponent_div_6_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div")(1, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "sl-icon", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "componentModal#upload-file-success"), " ");
} }
function ComponentModalComponent_div_6_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div")(1, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "sl-icon", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "componentModal#upload-file-error"), " ");
} }
function ComponentModalComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, ComponentModalComponent_div_6_div_1_Template, 5, 3, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, ComponentModalComponent_div_6_div_2_Template, 5, 3, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.loadStatus === ctx_r0.LoadingStatus.Success);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.loadStatus === ctx_r0.LoadingStatus.Fail);
} }
function ComponentModalComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ComponentModalComponent_div_7_Template_div_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r9.download($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "sl-icon", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r1.fileName, " ");
} }
function ComponentModalComponent_p_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "componentModal#chooseZip"), " ");
} }
function ComponentModalComponent_sl_button_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-button", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "componentModal#load"), " ");
} }
function ComponentModalComponent_core_file_item_11_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "core-file-item", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("cancel", function ComponentModalComponent_core_file_item_11_Template_core_file_item_cancel_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r12); const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.cancel()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r4.fileName)("loading", ctx_r4.loadStatus === ctx_r4.LoadingStatus.Loading);
} }
function ComponentModalComponent_core_access_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "core-access", 26);
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("settings", ctx_r5.accessSettings);
} }
function ComponentModalComponent_sl_button_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-button", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "$.save"), " ");
} }
var LoadingStatus;
(function (LoadingStatus) {
    LoadingStatus[LoadingStatus["Default"] = 0] = "Default";
    LoadingStatus[LoadingStatus["Success"] = 1] = "Success";
    LoadingStatus[LoadingStatus["Fail"] = 2] = "Fail";
    LoadingStatus[LoadingStatus["Loading"] = 3] = "Loading";
    LoadingStatus[LoadingStatus["Edit"] = 4] = "Edit";
})(LoadingStatus || (LoadingStatus = {}));
class ComponentModalComponent {
    constructor(componentApiService, formService, notifyService, storageService, storageApiService, responseErrorService) {
        this.componentApiService = componentApiService;
        this.formService = formService;
        this.notifyService = notifyService;
        this.storageService = storageService;
        this.storageApiService = storageApiService;
        this.responseErrorService = responseErrorService;
        this.onUpdate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.onCreate = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.LoadingStatus = LoadingStatus;
        this.loadStatus = LoadingStatus.Default;
        this.isOpen = false;
        this.isEdit = false;
        this.fileName = '';
        this.accessSettings = {
            groups: [],
            users: [],
        };
        this.accessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.AccessRight.NotAllowed;
        this.versionServerErrorsHandler = (serverError) => {
            return serverError.key === 'version'
                ? { key: `componentModal#validate.version` }
                : null;
        };
        this.form = this.formService
            .create({
            id: [],
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.stringValidator)({ min: 1, max: 250 })]],
            path: [],
            zip_path: [],
            users: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormArray([]),
            groups: new _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormArray([]),
        })
            .setup({
            method: this.componentApiService.save,
            methodContext: this.componentApiService,
            success: ({ row }) => {
                if (this.isEdit) {
                    this.onUpdate.emit(row);
                }
                else {
                    this.onCreate.emit(row);
                }
                this.isOpen = false;
                this.notifyService.toastByName('noteComponent');
                this.form.reset();
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: `componentModal#notification.error.${this.form.state}`,
                });
            },
        });
    }
    get title() {
        return `componentModal#component.${this.form.state}`;
    }
    get saveNotification() {
        return `modalComponent#notification.${this.form.state}`;
    }
    get shouldSHowAccessBlock() {
        return this.accessRight === plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.AccessRight.Full;
    }
    open(component) {
        this.isOpen = true;
        this.isEdit = Boolean(component);
        if (component) {
            this.form.patchValue(component);
            this.fileName = component.file_name;
            this.loadStatus = this.isEdit
                ? LoadingStatus.Edit
                : LoadingStatus.Success;
            this.getComponentAndFillAccessRights(component.id);
            this.isDefaultComponent = component.is_default_component;
        }
        else {
            this.form.reset();
            this.loadStatus = LoadingStatus.Default;
        }
    }
    upload(file) {
        this.loadStatus = LoadingStatus.Loading;
        this.fileName = file.name;
        this.componentApiService.upload(file).subscribe({
            next: ({ row: { label, path, zip_path } }) => {
                const name = label[this.storageService.lang.value];
                this.form.patchValue({
                    name,
                    path,
                    zip_path,
                });
                this.loadStatus = LoadingStatus.Success;
            },
            error: () => {
                this.loadStatus = LoadingStatus.Fail;
            },
        });
    }
    cancel() {
        this.loadStatus = LoadingStatus.Default;
    }
    download(event) {
        event.stopPropagation();
        event.preventDefault();
        this.storageApiService
            .download(this.form.value.zip_path, this.fileName)
            .subscribe();
    }
    getComponentAndFillAccessRights(id) {
        this.componentApiService.get(id).subscribe({
            next: (res) => {
                this.accessRight = res.access_right;
                this.accessSettings = {
                    users: res.users,
                    groups: res.groups,
                };
            },
        });
    }
}
ComponentModalComponent.ɵfac = function ComponentModalComponent_Factory(t) { return new (t || ComponentModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](project_api_component_api_service__WEBPACK_IMPORTED_MODULE_0__.ComponentApiService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.StorageService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.StorageApiService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.ResponseErrorService)); };
ComponentModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ComponentModalComponent, selectors: [["app-component-modal"]], outputs: { onUpdate: "onUpdate", onCreate: "onCreate" }, decls: 22, vars: 22, consts: [[3, "label", "open", "openChange"], [3, "data"], [3, "control", "serverErrorsHandler"], ["accept", ".zip", 3, "pick"], ["class", "uploaded-file-wrapper", 4, "ngIf"], ["class", "file-link", 3, "click", 4, "ngIf"], [1, "loadButton"], ["class", "choose-zip", 4, "ngIf"], ["variant", "primary", "outline", "", 4, "ngIf"], [3, "name", "loading", "cancel", 4, "ngIf"], [1, "name"], ["name", "name", 1, "primary", "required", "component-name", 3, "label"], [3, "settings", 4, "ngIf"], ["type", "submit", "variant", "primary", 4, "ngIf"], ["name", "noteComponent"], [1, "uploaded-file-wrapper"], [4, "ngIf"], [1, "upload-file-success"], ["name", "check2-circle"], [1, "upload-file-error"], ["name", "exclamation-octagon"], [1, "file-link", 3, "click"], ["name", "box-arrow-down"], [1, "choose-zip"], ["variant", "primary", "outline", ""], [3, "name", "loading", "cancel"], [3, "settings"], ["type", "submit", "variant", "primary"]], template: function ComponentModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("openChange", function ComponentModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "core-form", 1)(3, "core-validate", 2)(4, "core-file")(5, "core-file-source", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("pick", function ComponentModalComponent_Template_core_file_source_pick_5_listener($event) { return ctx.upload($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, ComponentModalComponent_div_6_Template, 3, 2, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, ComponentModalComponent_div_7_Template, 3, 1, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, ComponentModalComponent_p_9_Template, 3, 3, "p", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, ComponentModalComponent_sl_button_10_Template, 3, 3, "sl-button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, ComponentModalComponent_core_file_item_11_Template, 1, 2, "core-file-item", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 10)(13, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "sl-input", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](16, ComponentModalComponent_core_access_16_Template, 1, 1, "core-access", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "footer");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](18, ComponentModalComponent_sl_button_18_Template, 3, 3, "sl-button", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "core-notify", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](1, 16, ctx.title))("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("control", ctx.form.get("path"))("serverErrorsHandler", ctx.versionServerErrorsHandler);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.loadStatus !== ctx.LoadingStatus.Default);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.loadStatus === ctx.LoadingStatus.Edit);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.isEdit && ctx.loadStatus !== ctx.LoadingStatus.Success);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.loadStatus === ctx.LoadingStatus.Default || ctx.loadStatus === ctx.LoadingStatus.Fail || ctx.loadStatus === ctx.LoadingStatus.Edit);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.loadStatus !== ctx.LoadingStatus.Default && ctx.loadStatus !== ctx.LoadingStatus.Fail && ctx.loadStatus !== ctx.LoadingStatus.Edit);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("hidden", ctx.loadStatus !== ctx.LoadingStatus.Success && ctx.loadStatus !== ctx.LoadingStatus.Edit);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](15, 18, "componentModal#componentName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.isDefaultComponent && ctx.shouldSHowAccessBlock);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.loadStatus === ctx.LoadingStatus.Success || ctx.loadStatus === ctx.LoadingStatus.Edit);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](21, 20, ctx.saveNotification), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.FileComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.FileItemComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.FileSourceComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.AccessComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.TranslatePipe], styles: ["sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  width: 730px;\n}\nsl-dialog[_ngcontent-%COMP%]::part(title) {\n  font-size: var(--sl-font-size-large);\n  font-weight: var(--sl-font-weight-bold);\n  white-space: nowrap;\n}\ncore-file-item[_ngcontent-%COMP%] {\n  grid-column: 2;\n  justify-content: center;\n}\n.name[_ngcontent-%COMP%] {\n  margin-top: var(--sl-spacing-medium);\n}\n.upload-file-success[_ngcontent-%COMP%] {\n  display: flex;\n  align-content: center;\n}\n.upload-file-success[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-success-300);\n  font-size: var(--sl-font-size-x-large);\n  margin-left: 5px;\n}\n.upload-file-error[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-danger-400);\n  bottom: -7px;\n  font-size: var(--sl-font-size-x-large);\n}\n.upload-file-error[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-top: var(--sl-spacing-medium);\n}\n.loadButton[_ngcontent-%COMP%] {\n  display: flex;\n  flex-flow: column;\n  align-content: center;\n}\n.loadButton[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  width: calc(3 * var(--sl-spacing-3x-large));\n}\n.choose-zip[_ngcontent-%COMP%] {\n  margin: 0 0 var(--sl-spacing-large);\n}\n.file-link[_ngcontent-%COMP%] {\n  text-align: center;\n  text-decoration: underline;\n  color: var(--sl-color-neutral-700);\n  margin-bottom: var(--sl-spacing-large);\n}\n.file-link[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  top: 5px;\n}\n.file-link[_ngcontent-%COMP%]:hover {\n  cursor: pointer;\n  color: var(--sl-color-secondary-600);\n}\n.component-name[_ngcontent-%COMP%] {\n  margin-bottom: 24px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], ComponentModalComponent.prototype, "loadStatus", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], ComponentModalComponent.prototype, "isOpen", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], ComponentModalComponent.prototype, "isEdit", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], ComponentModalComponent.prototype, "accessSettings", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], ComponentModalComponent.prototype, "accessRight", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.WatchChanges)()
], ComponentModalComponent.prototype, "isDefaultComponent", void 0);


/***/ }),

/***/ 25532:
/*!***************************************************************!*\
  !*** ./src/app/pages/components/widgets/widgets.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetsComponent": () => (/* binding */ WidgetsComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var project_api_component_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/api/component-api.service */ 52290);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var project_pages_components_component_modal_component_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/pages/components/component-modal/component-modal.component */ 90129);










const _c0 = ["componentModal"];
function WidgetsComponent_sl_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-button", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function WidgetsComponent_sl_button_2_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](17); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r8.show(ctx_r10.checkRows)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate2"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 2, "$.delete"), " ", ctx_r0.checkRows.length, " ");
} }
function WidgetsComponent_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function WidgetsComponent_core_empty_state_6_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function WidgetsComponent_core_empty_state_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "core-empty-state", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, WidgetsComponent_core_empty_state_6_ng_container_3_Template, 1, 0, "ng-container", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 3, "noComponentList"));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("description", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 5, "noComponentListDescription"));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5);
} }
function WidgetsComponent_core_table_7_tr_31_ng_container_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "systemic"), " ");
} }
function WidgetsComponent_core_table_7_tr_31_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const component_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, ctx_r16.users[component_r14.owner_id]), " ");
} }
function WidgetsComponent_core_table_7_tr_31_core_action_19_Template(rf, ctx) { if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "core-action", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function WidgetsComponent_core_table_7_tr_31_core_action_19_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r22); const component_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](9); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r4.open(component_r14)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} }
function WidgetsComponent_core_table_7_tr_31_core_action_20_Template(rf, ctx) { if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "core-action", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function WidgetsComponent_core_table_7_tr_31_core_action_20_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r25); const component_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](13); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r7.show(component_r14)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} }
function WidgetsComponent_core_table_7_tr_31_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "tr")(1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](2, "core-table-checkbox", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](4, "app-widget-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](10, WidgetsComponent_core_table_7_tr_31_ng_container_10_Template, 3, 3, "ng-container", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](11, WidgetsComponent_core_table_7_tr_31_ng_container_11_Template, 3, 3, "ng-container", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](13, "core-relative-time", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](14, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](15, "core-relative-time", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](16, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](18, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](19, WidgetsComponent_core_table_7_tr_31_core_action_19_Template, 1, 0, "core-action", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](20, WidgetsComponent_core_table_7_tr_31_core_action_20_Template, 1, 0, "core-action", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const component_r14 = ctx.$implicit;
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("value", component_r14);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("root", component_r14.path);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngClass", component_r14.is_default_component ? "check-icon" : "x-icon")("name", component_r14.is_default_component ? "check-lg" : "x-lg");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](component_r14.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", component_r14.is_default_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", !component_r14.is_default_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("date", component_r14.create_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("date", component_r14.update_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", "V." + (component_r14.settings.version || "0.0.0"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", component_r14.access_right >= ctx_r13.AccessRight.Edit);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", component_r14.access_right >= ctx_r13.AccessRight.Full);
} }
function WidgetsComponent_core_table_7_Template(rf, ctx) { if (rf & 1) {
    const _r27 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "core-table", 16)(1, "thead")(2, "tr")(3, "th")(4, "core-table-checkbox-controller", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function WidgetsComponent_core_table_7_Template_core_table_checkbox_controller_change_4_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r27); const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r26.checkRows = $event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](5, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](12, "core-table-sort", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](13, "th", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](15, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](16, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](18, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](19, "core-table-sort", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](20, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](23, "core-table-sort", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](24, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](25);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](26, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](27, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](28);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](29, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](30, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](31, WidgetsComponent_core_table_7_tr_31_Template, 21, 12, "tr", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("total", ctx_r3.componentsTotal);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](8, 9, "basic"));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 11, "$.name"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](15, 13, "author"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](18, 15, "$.createDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](22, 17, "$.updateDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](26, 19, "version"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](29, 21, "$.actions"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r3.components);
} }
function WidgetsComponent_ng_template_10_Template(rf, ctx) { if (rf & 1) {
    const _r29 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-button", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function WidgetsComponent_ng_template_10_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r29); _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](9); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r4.open()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](3, "sl-icon", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "addContent"), " ");
} }
function WidgetsComponent_p_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const component_r30 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](component_r30.name);
} }
class WidgetsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_3__.SubscribableComponent {
    constructor(componentApiService, pageService, activatedRoute, notifyService, responseErrorService) {
        super();
        this.componentApiService = componentApiService;
        this.pageService = pageService;
        this.activatedRoute = activatedRoute;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.components = [];
        this.users = [];
        this.checkRows = [];
        this.componentsTotal = 0;
        this.isEmptyState = false;
        this.keyWhenDeleting = '';
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AccessRight;
    }
    ngOnInit() {
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe(() => {
                this.load();
            }),
        ];
    }
    load() {
        this.pageService.loading = true;
        this.componentApiService
            .list(this.activatedRoute.snapshot.queryParams)
            .subscribe({
            next: ({ rows, total, users }) => {
                this.components = rows;
                this.users = users;
                this.componentsTotal = total;
                this.isEmptyState = total === 0;
                this.pageService.loading = false;
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: `widgets.notification.error.getComponents`,
                });
            },
        });
    }
    deleteComponents(components) {
        if (components.length === 1) {
            this.keyWhenDeleting = 'deleteComponent';
        }
        else {
            this.keyWhenDeleting = 'deleteComponents';
        }
        this.componentApiService
            .deleteList(components.map((item) => item.id))
            .subscribe({
            next: () => {
                this.checkRows = [];
                this.load();
                this.notifyService.toastByName('componentsDelete');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: `componentModal#notification.error.${this.keyWhenDeleting}`,
                });
            },
        });
    }
    onComponentCreate() {
        this.load();
    }
    onComponentUpdate(component) {
        const i = this.components.findIndex(({ id }) => id === component.id);
        if (i !== -1) {
            this.components[i] = component;
        }
    }
}
WidgetsComponent.ɵfac = function WidgetsComponent_Factory(t) { return new (t || WidgetsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](project_api_component_api_service__WEBPACK_IMPORTED_MODULE_0__.ComponentApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PageService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService)); };
WidgetsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: WidgetsComponent, selectors: [["app-widgets"]], viewQuery: function WidgetsComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_c0, 7);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.componentModalComponent = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"]], decls: 23, vars: 21, consts: [[3, "title", "counter"], ["variant", "danger", 3, "click", 4, "ngIf"], [4, "ngTemplateOutlet"], ["imageSrc", "assets/images/data-default.svg", 3, "title", "description", 4, "ngIf"], [3, "total", 4, "ngIf"], [3, "onCreate", "onUpdate"], ["componentModal", ""], ["addButton", ""], [3, "title", "description", "ok"], ["deleteConfirm", ""], [3, "title", "ok"], ["deleteCheckedConfirm", ""], [4, "ngFor", "ngForOf"], ["name", "componentsDelete"], ["variant", "danger", 3, "click"], ["imageSrc", "assets/images/data-default.svg", 3, "title", "description"], [3, "total"], [3, "change"], ["width", "20vw"], ["routing", "", "by", "name"], ["width", "10vw"], ["routing", "", "by", "create_date"], ["routing", "", "by", "update_date"], [3, "value"], [3, "root"], [3, "ngClass", "name"], ["maxWidth", "20vw"], ["maxWidth", "10vw"], [4, "ngIf"], [3, "date"], ["type", "setup", 3, "click", 4, "ngIf"], ["type", "delete", 3, "click", 4, "ngIf"], ["type", "setup", 3, "click"], ["type", "delete", 3, "click"], ["variant", "primary", 3, "click"], ["name", "plus", "slot", "suffix"]], template: function WidgetsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "core-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](2, WidgetsComponent_sl_button_2_Template, 3, 4, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](3, "core-table-filter");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, WidgetsComponent_ng_container_4_Template, 1, 0, "ng-container", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "core-content");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, WidgetsComponent_core_empty_state_6_Template, 4, 7, "core-empty-state", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](7, WidgetsComponent_core_table_7_Template, 32, 23, "core-table", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](8, "app-component-modal", 5, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onCreate", function WidgetsComponent_Template_app_component_modal_onCreate_8_listener() { return ctx.onComponentCreate(); })("onUpdate", function WidgetsComponent_Template_app_component_modal_onUpdate_8_listener($event) { return ctx.onComponentUpdate($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](10, WidgetsComponent_ng_template_10_Template, 4, 3, "ng-template", null, 7, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "core-confirm", 8, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("ok", function WidgetsComponent_Template_core_confirm_ok_12_listener($event) { return ctx.deleteComponents([$event]); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](16, "core-confirm", 10, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("ok", function WidgetsComponent_Template_core_confirm_ok_16_listener($event) { return ctx.deleteComponents($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](19, WidgetsComponent_p_19_Template, 2, 1, "p", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](20, "core-notify", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](1, 11, "componentTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("counter", ctx.componentsTotal);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.checkRows.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.isEmptyState);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.components.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](14, 13, "deleteConfirm.title"))("description", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](15, 15, "deleteConfirm.description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](18, 17, "deleteConfirms.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.checkRows);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](22, 19, ctx.keyWhenDeleting), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgClass, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.HeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableCheckboxComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableCheckboxControllerComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableFilterComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableSortRoutingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.WidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ContentComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.EmptyStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.RelativeTimeComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ActionComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, project_pages_components_component_modal_component_modal_component__WEBPACK_IMPORTED_MODULE_1__.ComponentModalComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipe], styles: [".check-icon[_ngcontent-%COMP%] {\n  font-size: 16px;\n  color: var(--sl-color-success-500);\n}\n.x-icon[_ngcontent-%COMP%] {\n  font-size: 14px;\n  color: var(--sl-color-secondary-600);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpZGdldHMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxlQUFBO0VBQ0Esa0NBQUE7QUFDSjtBQUVBO0VBQ0ksZUFBQTtFQUNBLG9DQUFBO0FBQUoiLCJmaWxlIjoid2lkZ2V0cy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5jaGVjay1pY29uIHtcbiAgICBmb250LXNpemU6IDE2cHg7XG4gICAgY29sb3I6IHZhcigtLXNsLWNvbG9yLXN1Y2Nlc3MtNTAwKTtcbn1cblxuLngtaWNvbiB7XG4gICAgZm9udC1zaXplOiAxNHB4O1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktNjAwKTtcbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], WidgetsComponent.prototype, "components", void 0);


/***/ }),

/***/ 99769:
/*!************************************************************!*\
  !*** ./src/app/pages/components/widgets/widgets.module.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WidgetsModule": () => (/* binding */ WidgetsModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_pages_components_widgets_widgets_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/pages/components/widgets/widgets.component */ 25532);
/* harmony import */ var project_pages_components_component_modal_component_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/pages/components/component-modal/component-modal.component */ 90129);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 64565);








class WidgetsModule {
}
WidgetsModule.ɵfac = function WidgetsModule_Factory(t) { return new (t || WidgetsModule)(); };
WidgetsModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({ type: WidgetsModule });
WidgetsModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.providePageTranslations)({
            sources: [
                'assets/core-library/i18n/',
                'assets/i18n/components/',
                'assets/aggregation-setup/i18n/',
                'assets/i18n/widgets/',
            ],
        }),
    ], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.HeaderModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_5__.RouterModule.forChild([
            {
                path: '',
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.PageTranslationsGuard],
                component: project_pages_components_widgets_widgets_component__WEBPACK_IMPORTED_MODULE_0__.WidgetsComponent,
            },
        ]),
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TableModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ContentModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.RelativeTimeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ActionModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FileModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AccessModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵsetNgModuleScope"](WidgetsModule, { declarations: [project_pages_components_widgets_widgets_component__WEBPACK_IMPORTED_MODULE_0__.WidgetsComponent, project_pages_components_component_modal_component_modal_component__WEBPACK_IMPORTED_MODULE_1__.ComponentModalComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.HeaderModule, _angular_router__WEBPACK_IMPORTED_MODULE_5__.RouterModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TableModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ContentModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.RelativeTimeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ActionModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FileModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AccessModule] }); })();


/***/ })

}]);
//# sourceMappingURL=src_app_pages_components_widgets_widgets_module_ts.js.map