"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_api_project-api_service_ts-src_app_api_theme-api_service_ts-src_app_interfaces_projec-d7f279"],{

/***/ 37444:
/*!********************************************!*\
  !*** ./src/app/api/project-api.service.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectApiService": () => (/* binding */ ProjectApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);



class ProjectApiService {
    constructor(restService, coreRestService) {
        this.restService = restService;
        this.coreRestService = coreRestService;
    }
    get(id) {
        return this.restService.get(`/project/${id}`);
    }
    list(query) {
        return this.restService.get('/project', query);
    }
    save(project) {
        if (project.id) {
            return this.restService.put(`/project/${project.id}`, project);
        }
        else {
            return this.restService.post('/project', project);
        }
    }
    delete(id) {
        return this.restService.delete(`/project`, { ids: id });
    }
    deleteList(ids) {
        return this.restService.delete(`/project`, {
            ids,
        });
    }
    copy(id) {
        return this.restService.post(`/project/${id}/copy`);
    }
    getAnalyticsRedirect(url) {
        return this.coreRestService.get(url);
    }
}
ProjectApiService.ɵfac = function ProjectApiService_Factory(t) { return new (t || ProjectApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.CoreApi)); };
ProjectApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ProjectApiService, factory: ProjectApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 30999:
/*!*******************************************!*\
  !*** ./src/app/api/shared-api.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SharedApiService": () => (/* binding */ SharedApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);



class SharedApiService {
    constructor(restService) {
        this.restService = restService;
    }
    getSharedHash(uid) {
        return this.restService.get(`/shared/${uid}`);
    }
    sharedAuth(params, hash) {
        return this.restService.post(`/shared/${hash}/auth`, params);
    }
}
SharedApiService.ɵfac = function SharedApiService_Factory(t) { return new (t || SharedApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.CoreApi)); };
SharedApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: SharedApiService, factory: SharedApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 13745:
/*!******************************************!*\
  !*** ./src/app/api/theme-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeApiService": () => (/* binding */ ThemeApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class ThemeApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(id) {
        return this.restService.get(`/theme/${id}`);
    }
    list(params) {
        return this.restService.get('/theme', params);
    }
    save(theme) {
        if (theme.id) {
            return this.restService.put(`/theme/${theme.id}`, theme);
        }
        else {
            return this.restService.post('/theme', theme);
        }
    }
    deleteList(ids) {
        return this.restService.delete(`/theme`, { ids });
    }
}
ThemeApiService.ɵfac = function ThemeApiService_Factory(t) { return new (t || ThemeApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ThemeApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ThemeApiService, factory: ThemeApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 71511:
/*!***************************************************!*\
  !*** ./src/app/helpers/get-shared-auth-header.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getSharedAuthHeader": () => (/* binding */ getSharedAuthHeader)
/* harmony export */ });
function getSharedAuthHeader(token) {
    return { 'Shared-Authorization': `Bearer ${token}` };
}


/***/ }),

/***/ 16847:
/*!***************************************!*\
  !*** ./src/app/interfaces/project.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DashboardPostMessageEvent": () => (/* binding */ DashboardPostMessageEvent),
/* harmony export */   "ProjectIcon": () => (/* binding */ ProjectIcon),
/* harmony export */   "ThemeColor": () => (/* binding */ ThemeColor)
/* harmony export */ });
var DashboardPostMessageEvent;
(function (DashboardPostMessageEvent) {
    DashboardPostMessageEvent["Interact"] = "interact";
    DashboardPostMessageEvent["GoTo"] = "goTo";
    DashboardPostMessageEvent["TriggerValue"] = "triggerValue";
    DashboardPostMessageEvent["SetFilter"] = "setFilter";
    DashboardPostMessageEvent["Resize"] = "resize";
    DashboardPostMessageEvent["ChangeFilter"] = "changeFilter";
    DashboardPostMessageEvent["ChangeProjectState"] = "changeProjectState";
})(DashboardPostMessageEvent || (DashboardPostMessageEvent = {}));
var ThemeColor;
(function (ThemeColor) {
    ThemeColor["Polymatica"] = "polymatica";
    ThemeColor["C1"] = "c1";
    ThemeColor["C2"] = "c2";
    ThemeColor["Grey"] = "grey";
    ThemeColor["Green"] = "green";
    ThemeColor["Pink"] = "pink";
    ThemeColor["Blue"] = "blue";
    ThemeColor["Yellow"] = "yellow";
    ThemeColor["Red"] = "red";
    ThemeColor["Mixed"] = "mixed";
    ThemeColor["Circus"] = "circus";
    ThemeColor["Custom1"] = "custom1";
})(ThemeColor || (ThemeColor = {}));
var ProjectIcon;
(function (ProjectIcon) {
    ProjectIcon["Antique"] = "antique";
    ProjectIcon["Atom"] = "atom";
    ProjectIcon["Box"] = "box";
    ProjectIcon["Briefcase"] = "briefcase";
    ProjectIcon["ChartDonut"] = "chart-donut";
    ProjectIcon["Chip"] = "chip";
    ProjectIcon["Clock"] = "clock";
    ProjectIcon["Construction"] = "construction";
    ProjectIcon["CubeEdges"] = "cube-edges";
    ProjectIcon["Cube"] = "cube";
    ProjectIcon["Document"] = "document";
    ProjectIcon["Factory"] = "factory";
    ProjectIcon["Figure3d"] = "figure-3d";
    ProjectIcon["Flag"] = "flag";
    ProjectIcon["GroceryTrolley"] = "grocery-trolley";
    ProjectIcon["Lab"] = "lab";
    ProjectIcon["Lifebuoy"] = "lifebuoy";
    ProjectIcon["Lightning"] = "lightning";
    ProjectIcon["Moneybag"] = "moneybag";
    ProjectIcon["Moon"] = "moon";
    ProjectIcon["Plane"] = "plane";
    ProjectIcon["Planet"] = "planet";
    ProjectIcon["Plus"] = "plus";
    ProjectIcon["Pumpjack"] = "pumpjack";
    ProjectIcon["Truck"] = "truck";
})(ProjectIcon || (ProjectIcon = {}));


/***/ }),

/***/ 3441:
/*!****************************************************************************!*\
  !*** ./src/app/pages/shared/components/error-page/error-page.component.ts ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ErrorPageComponent": () => (/* binding */ ErrorPageComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var project_enums_shared__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/enums/shared */ 56193);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 92299);






class ErrorPageComponent {
    constructor() {
        this.open = false;
        this.errorCode = project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.ErrorCode;
        this.message = '';
    }
    preventDefault(event) {
        event.preventDefault();
    }
    ngOnInit() {
        if (this.errorData.code === this.errorCode.linkExpired) {
            this.message = 'errorTimeLink';
        }
        else {
            this.message = 'errorLink';
        }
    }
}
ErrorPageComponent.ɵfac = function ErrorPageComponent_Factory(t) { return new (t || ErrorPageComponent)(); };
ErrorPageComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ErrorPageComponent, selectors: [["app-error-page"]], hostBindings: function ErrorPageComponent_HostBindings(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-request-close", function ErrorPageComponent_sl_request_close_HostBindingHandler($event) { return ctx.preventDefault($event); });
    } }, inputs: { errorData: "errorData" }, decls: 21, vars: 13, consts: [[1, "logo"], ["library", "core", "name", "polymatica-logo-medium"], [1, "logo-description"], [1, "image"], ["src", "./assets/images/sharing-bg-grey.svg", "alt", "\u041F\u043E\u043B\u0438\u043C\u0430\u0442\u0438\u043A\u0430"], [1, "footer"], [1, "footer-item"], [1, "copyright"], [1, "dialog-overview", 3, "label", "open"]], template: function ErrorPageComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "sl-icon", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "footer")(6, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](7, "img", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 5)(9, "div", 6)(10, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11, "En");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13, " \u00A9 2011-2022, ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "sl-dialog", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 5, "passwordLogoDescription"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](16, 7, "polymatica"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](18, 9, "accessNotPossible"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("open", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](20, 11, ctx.message), "\n");
    } }, dependencies: [shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100vh;\n}\n[_nghost-%COMP%]   .logo[_ngcontent-%COMP%] {\n  margin: 170px auto 0 auto;\n  max-width: 312px;\n}\n[_nghost-%COMP%]   .logo[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  width: 269px;\n  height: 35px;\n  margin-bottom: 11px;\n}\n[_nghost-%COMP%]   .logo[_ngcontent-%COMP%]   .logo-description[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-x-small);\n  text-transform: uppercase;\n  font-weight: var(--sl-font-weight-normal);\n}\n[_nghost-%COMP%]   .image[_ngcontent-%COMP%] {\n  margin-bottom: 75px;\n}\n[_nghost-%COMP%]   .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: right;\n  margin-bottom: var(--sl-spacing-3x-large);\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%]   .footer-item[_ngcontent-%COMP%] {\n  display: flex;\n  margin-right: var(--sl-spacing-3x-large);\n  font-size: var(--sl-font-size-x-small);\n  line-height: var(--sl-font-size-medium);\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%]   .footer-item[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%] {\n  margin-left: 24px;\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%]   .footer-item[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  color: var(--sl-color-primary-500);\n  text-decoration: underline;\n}\nsl-dialog[_ngcontent-%COMP%] {\n  --width: 620px;\n}\nsl-dialog[_ngcontent-%COMP%]::part(close-button) {\n  display: none;\n}\nsl-dialog[_ngcontent-%COMP%]::part(title) {\n  font-size: var(--sl-font-size-x-large);\n}\nsl-dialog[_ngcontent-%COMP%]::part(body) {\n  font-size: var(--sl-font-size-medium);\n  line-height: var(--sl-line-height-dense);\n  padding-bottom: var(--sl-spacing-4x-large);\n}\nsl-dialog[_ngcontent-%COMP%]::part(overlay) {\n  opacity: 0.3;\n  background: var(--sl-color-neutral-500);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_5__.WatchChanges)()
], ErrorPageComponent.prototype, "open", void 0);


/***/ }),

/***/ 50064:
/*!************************************************************************!*\
  !*** ./src/app/pages/shared/components/password/password.component.ts ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PasswordComponent": () => (/* binding */ PasswordComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_api_shared_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/api/shared-api.service */ 30999);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 78298);







const _c0 = function () { return { unauthorized: "password#unauthorized" }; };
class PasswordComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__.SubscribableComponent {
    constructor(sharedApiService, activatedRoute, formService) {
        super();
        this.sharedApiService = sharedApiService;
        this.activatedRoute = activatedRoute;
        this.formService = formService;
        this.token = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.hash = '';
        this.passForm = this.formService
            .create({
            password: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required]],
        })
            .setup({
            method: this.sharedApiService.sharedAuth,
            methodContext: this.sharedApiService,
            methodArguments: () => [this.hash],
            success: ({ token }) => {
                this.token.emit(token);
            },
        });
    }
    ngOnInit() {
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe((params) => {
                this.hash = params.uid;
            }),
        ];
    }
}
PasswordComponent.ɵfac = function PasswordComponent_Factory(t) { return new (t || PasswordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](project_api_shared_api_service__WEBPACK_IMPORTED_MODULE_0__.SharedApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService)); };
PasswordComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: PasswordComponent, selectors: [["app-password"]], outputs: { token: "token" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"]], decls: 21, vars: 15, consts: [[1, "form"], ["library", "core", "name", "polymatica-logo-medium"], [1, "logo-description"], [1, "input-password", 3, "data"], [3, "serverErrorsMap"], ["type", "password", "name", "password", "size", "medium", "password-toggle", "", 3, "placeholder"], ["type", "submit", "variant", "primary"], [1, "image"], ["src", "./assets/images/sharing-bg.svg", "alt", "\u041F\u043E\u043B\u0438\u043C\u0430\u0442\u0438\u043A\u0430"], [1, "footer"], [1, "footer-item"], [1, "copyright"], ["target", "_blank", "href", "https://www.polymatica.ru/"]], template: function PasswordComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](1, "sl-icon", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "core-form", 3)(6, "core-validate", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](7, "sl-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](8, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "sl-button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](13, "img", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](14, "div", 9)(15, "div", 10)(16, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17, " \u00A9 2011-2022, ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](18, "a", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](4, 6, "passwordLogoDescription"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("data", ctx.passForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("serverErrorsMap", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction0"](14, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](8, 8, "enterPassword"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 10, "toComeIn"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](20, 12, "polymatica"));
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  height: 100vh;\n}\n[_nghost-%COMP%]   .form[_ngcontent-%COMP%] {\n  max-width: 312px;\n  width: 100%;\n  margin: 170px auto 0 auto;\n}\n[_nghost-%COMP%]   .form[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  width: 269px;\n  height: 35px;\n  margin-bottom: 11px;\n}\n[_nghost-%COMP%]   .form[_ngcontent-%COMP%]   .logo-description[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-x-small);\n  text-transform: uppercase;\n  font-weight: var(--sl-font-weight-semibold);\n  color: var(--sl-color-secondary-950);\n}\n[_nghost-%COMP%]   .form[_ngcontent-%COMP%]   .input-password[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  margin-top: 76px;\n}\n[_nghost-%COMP%]   .form[_ngcontent-%COMP%]   .input-password[_ngcontent-%COMP%]   sl-input[_ngcontent-%COMP%] {\n  max-width: 312px;\n  height: 38px;\n}\n[_nghost-%COMP%]   .form[_ngcontent-%COMP%]   .input-password[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-top: var(--sl-spacing-large);\n  max-width: 95px;\n  width: 100%;\n  max-height: 38px;\n  height: 100%;\n  border-radius: 2px;\n}\n[_nghost-%COMP%]   .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: right;\n  margin-bottom: var(--sl-spacing-3x-large);\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%]   .footer-item[_ngcontent-%COMP%] {\n  display: flex;\n  margin-right: var(--sl-spacing-3x-large);\n  font-size: var(--sl-font-size-x-small);\n  line-height: var(--sl-font-size-medium);\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%]   .footer-item[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%] {\n  margin-left: 24px;\n  line-height: 18px;\n}\n[_nghost-%COMP%]   .footer[_ngcontent-%COMP%]   .footer-item[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: var(--sl-color-primary-500);\n  text-decoration: underline;\n}\n.message[_ngcontent-%COMP%] {\n  margin: var(--sl-spacing-3x-small);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 9773:
/*!**************************************************************!*\
  !*** ./src/app/pages/shared/services/shared-auth.service.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SharedAuthService": () => (/* binding */ SharedAuthService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_enums_shared__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/enums/shared */ 56193);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);




class SharedAuthService {
    constructor(restService, storageService, appService, coreRestService) {
        this.restService = restService;
        this.storageService = storageService;
        this.appService = appService;
        this.coreRestService = coreRestService;
    }
    authorizationDefinition(uid) {
        if (this.appService.hasUser()) {
            this.setAuthorized(uid, project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.AuthorizationBackendType.Authorized);
        }
        else
            this.setAuthorized(uid, project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.AuthorizationBackendType.NotAuthorized);
    }
    setHeader(headers) {
        for (let key in headers) {
            this.restService.headers[key] = headers[key];
            this.coreRestService.headers[key] = headers[key];
        }
    }
    setAuthorized(uid, value) {
        this.setHeader({
            'Shared-Hash': uid,
            'Authorization-Backend': value,
        });
    }
}
SharedAuthService.ɵfac = function SharedAuthService_Factory(t) { return new (t || SharedAuthService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.RestService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.StorageService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.CoreApi)); };
SharedAuthService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: SharedAuthService, factory: SharedAuthService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 44319:
/*!**************************************************!*\
  !*** ./src/app/pages/shared/shared.component.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SharedComponent": () => (/* binding */ SharedComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var project_enums_shared__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/enums/shared */ 56193);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ngx-subscribable */ 43977);
/* harmony import */ var project_helpers_get_shared_auth_header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/helpers/get-shared-auth-header */ 71511);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var project_api_shared_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/api/shared-api.service */ 30999);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_pages_shared_services_shared_auth_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/pages/shared/services/shared-auth.service */ 9773);
/* harmony import */ var project_services_project_project_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/services/project/project.service */ 64439);
/* harmony import */ var project_components_dashboard_dashboard_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! project/components/dashboard/dashboard.service */ 24339);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var project_components_dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! project/components/dashboard/dashboard.component */ 619);
/* harmony import */ var _components_project_header_project_header_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/project-header/project-header.component */ 37142);
/* harmony import */ var _components_password_password_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/password/password.component */ 50064);
/* harmony import */ var _components_error_page_error_page_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/error-page/error-page.component */ 3441);

















function SharedComponent_app_project_header_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "app-project-header", 4);
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("project", ctx_r0.project)("shared", true);
} }
function SharedComponent_app_dashboard_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "app-dashboard");
} }
function SharedComponent_app_password_2_Template(rf, ctx) { if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "app-password", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("token", function SharedComponent_app_password_2_Template_app_password_token_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r5); const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r4.setToken($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} }
function SharedComponent_app_error_page_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "app-error-page", 6);
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("errorData", ctx_r3.error);
} }
const storage = window.sessionStorage;
const sharedSessionToken = 'at-s';
class SharedComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_11__.SubscribableComponent {
    constructor(sharedApiService, activatedRoute, pageService, sharedAuthService, projectService, dashboardService) {
        super();
        this.sharedApiService = sharedApiService;
        this.activatedRoute = activatedRoute;
        this.pageService = pageService;
        this.sharedAuthService = sharedAuthService;
        this.projectService = projectService;
        this.dashboardService = dashboardService;
        this.activatePasswordWindow = false;
        this.activateErrorPageWindow = false;
        this.activateDashboard = false;
        this.AuthorizationBackendType = project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.AuthorizationBackendType;
    }
    ngOnInit() {
        this.dashboardService.isShared = true;
        this.subscriptions = [
            this.activatedRoute.paramMap.subscribe(() => {
                const queryParams = this.activatedRoute.snapshot.queryParams;
                this.load(queryParams);
            }),
            this.projectService.project.subscribe((project) => {
                this.project = project;
            }),
        ];
    }
    load(params) {
        this.pageService.loading = true;
        this.sharedApiService.getSharedHash(params.uid).subscribe({
            next: ({ row }) => {
                this.sharedAuthService.authorizationDefinition(params.uid);
                if (row.shared_type === project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.SharedAccessType.TimeLimit ||
                    row.shared_type === project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.SharedAccessType.Unlimited) {
                    this.activateDashboard = true;
                }
                else if (row.shared_type === project_enums_shared__WEBPACK_IMPORTED_MODULE_0__.SharedAccessType.ByPassword) {
                    const token = storage.getItem(sharedSessionToken);
                    if (token) {
                        this.sharedAuthService.setHeader((0,project_helpers_get_shared_auth_header__WEBPACK_IMPORTED_MODULE_1__.getSharedAuthHeader)(token));
                        this.activateDashboard = true;
                    }
                    else {
                        this.activatePasswordWindow = true;
                    }
                }
                this.sourceId = row.source_id;
                this.pageService.loading = false;
            },
            error: ({ error }) => {
                this.error = error;
                this.activateDashboard = false;
                this.project = undefined;
                this.activateErrorPageWindow = true;
                this.pageService.loading = false;
            },
        });
    }
    setToken(token) {
        this.sharedAuthService.setHeader((0,project_helpers_get_shared_auth_header__WEBPACK_IMPORTED_MODULE_1__.getSharedAuthHeader)(token));
        this.activatePasswordWindow = false;
        this.activateDashboard = true;
        storage.setItem(sharedSessionToken, token);
    }
}
SharedComponent.ɵfac = function SharedComponent_Factory(t) { return new (t || SharedComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_api_shared_api_service__WEBPACK_IMPORTED_MODULE_2__.SharedApiService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_12__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_13__.PageService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_pages_shared_services_shared_auth_service__WEBPACK_IMPORTED_MODULE_3__.SharedAuthService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_services_project_project_service__WEBPACK_IMPORTED_MODULE_4__.ProjectService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](project_components_dashboard_dashboard_service__WEBPACK_IMPORTED_MODULE_5__.DashboardService)); };
SharedComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineComponent"]({ type: SharedComponent, selectors: [["app-shared"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵInheritDefinitionFeature"]], decls: 4, vars: 4, consts: [[3, "project", "shared", 4, "ngIf"], [4, "ngIf"], [3, "token", 4, "ngIf"], [3, "errorData", 4, "ngIf"], [3, "project", "shared"], [3, "token"], [3, "errorData"]], template: function SharedComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](0, SharedComponent_app_project_header_0_Template, 1, 2, "app-project-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](1, SharedComponent_app_dashboard_1_Template, 1, 0, "app-dashboard", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](2, SharedComponent_app_password_2_Template, 1, 0, "app-password", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](3, SharedComponent_app_error_page_3_Template, 1, 1, "app-error-page", 3);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.project);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.activateDashboard);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.activatePasswordWindow);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.activateErrorPageWindow);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_14__.NgIf, project_components_dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_6__.DashboardComponent, _components_project_header_project_header_component__WEBPACK_IMPORTED_MODULE_7__.ProjectHeaderComponent, _components_password_password_component__WEBPACK_IMPORTED_MODULE_8__.PasswordComponent, _components_error_page_error_page_component__WEBPACK_IMPORTED_MODULE_9__.ErrorPageComponent], styles: ["[_nghost-%COMP%] {\n  --height-header: 40px;\n}\napp-dashboard[_ngcontent-%COMP%] {\n  height: calc(100vh - var(--height-header));\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNoYXJlZC5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLHFCQUFBO0FBQ0o7QUFFQTtFQUNJLDBDQUFBO0FBQUoiLCJmaWxlIjoic2hhcmVkLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3Qge1xuICAgIC0taGVpZ2h0LWhlYWRlcjogNDBweDtcbn1cblxuYXBwLWRhc2hib2FyZCB7XG4gICAgaGVpZ2h0OiBjYWxjKDEwMHZoIC0gdmFyKC0taGVpZ2h0LWhlYWRlcikpO1xufVxuIl19 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()
], SharedComponent.prototype, "activatePasswordWindow", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()
], SharedComponent.prototype, "activateErrorPageWindow", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()
], SharedComponent.prototype, "activateDashboard", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()
], SharedComponent.prototype, "sourceId", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_16__.WatchChanges)()
], SharedComponent.prototype, "project", void 0);


/***/ }),

/***/ 40950:
/*!***********************************************!*\
  !*** ./src/app/pages/shared/shared.module.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SharedModule": () => (/* binding */ SharedModule)
/* harmony export */ });
/* harmony import */ var project_pages_shared_shared_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/pages/shared/shared.component */ 44319);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var _components_password_password_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/password/password.component */ 50064);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var _components_error_page_error_page_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/error-page/error-page.component */ 3441);
/* harmony import */ var project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/components/dashboard/dashboard.module */ 75649);
/* harmony import */ var project_components_project_header_project_header_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/components/project-header/project-header.module */ 59743);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 64565);











class SharedModule {
}
SharedModule.ɵfac = function SharedModule_Factory(t) { return new (t || SharedModule)(); };
SharedModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineNgModule"]({ type: SharedModule });
SharedModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.providePageTranslations)({
            sources: [
                'assets/i18n/',
                'assets/i18n/components/embed-video/',
                'assets/i18n/components/dashboard/',
                'assets/i18n/components/widget/',
                'assets/i18n/components/modal-analytics-scenario/',
                'assets/i18n/components/widget-setup/',
                'assets/i18n/project/',
                'assets/i18n/shared/',
                'assets/core-library/i18n/filters/',
                'assets/core-library/i18n/',
            ],
        }),
    ], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.NavigationModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_9__.RouterModule.forChild([
            {
                path: '',
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.PageTranslationsGuard],
                component: project_pages_shared_shared_component__WEBPACK_IMPORTED_MODULE_0__.SharedComponent,
            },
            {
                path: ':layerId',
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.PageTranslationsGuard],
                component: project_pages_shared_shared_component__WEBPACK_IMPORTED_MODULE_0__.SharedComponent,
            },
        ]),
        project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_3__.DashboardModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ContentModule,
        project_components_project_header_project_header_module__WEBPACK_IMPORTED_MODULE_4__.ProjectHeaderModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵsetNgModuleScope"](SharedModule, { declarations: [project_pages_shared_shared_component__WEBPACK_IMPORTED_MODULE_0__.SharedComponent, _components_password_password_component__WEBPACK_IMPORTED_MODULE_1__.PasswordComponent, _components_error_page_error_page_component__WEBPACK_IMPORTED_MODULE_2__.ErrorPageComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.NavigationModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormModule, _angular_router__WEBPACK_IMPORTED_MODULE_9__.RouterModule, project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_3__.DashboardModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ContentModule,
        project_components_project_header_project_header_module__WEBPACK_IMPORTED_MODULE_4__.ProjectHeaderModule], exports: [project_pages_shared_shared_component__WEBPACK_IMPORTED_MODULE_0__.SharedComponent] }); })();


/***/ })

}]);
//# sourceMappingURL=src_app_api_project-api_service_ts-src_app_api_theme-api_service_ts-src_app_interfaces_projec-d7f279.js.map