"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_pages_source-list_source-list_module_ts"],{

/***/ 4819:
/*!*******************************************!*\
  !*** ./src/app/api/plugin-api.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PluginApiService": () => (/* binding */ PluginApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);



class PluginApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(name) {
        return this.restService.get(`/plugin/${name}`);
    }
    list(params) {
        return this.restService.get('/plugin', params);
    }
    datasetList(name, body) {
        return this.restService.post(`/plugin/${name}/dataset-list`, body);
    }
    checkConnection(name, fields) {
        return this.restService.post(`/plugin/${name}/check-connection`, {
            fields,
        });
    }
    getColumns(name, body) {
        return this.restService.post(`/plugin/${name}/get-columns`, body);
    }
}
PluginApiService.ɵfac = function PluginApiService_Factory(t) { return new (t || PluginApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
PluginApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: PluginApiService, factory: PluginApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 8916:
/*!*******************************************!*\
  !*** ./src/app/api/source-api.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SourceApiService": () => (/* binding */ SourceApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);



class SourceApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(id) {
        return this.restService.get(`/data-source/${id}`);
    }
    list(params) {
        return this.restService.get('/data-source', params);
    }
    sqlList(params) {
        return this.restService.get('/data-source', params);
    }
    save(data) {
        if (data.id) {
            return this.restService.put(`/data-source/${data.id}`, data);
        }
        else {
            return this.restService.post('/data-source', data);
        }
    }
    deleteSource(id) {
        return this.restService.delete(`/data-source/${id}`);
    }
    deleteList(ids) {
        return this.restService.delete(`/data-source`, {
            ids,
        });
    }
    getConectionFields(id) {
        return this.restService.get(`/data-source/${id}/connect-fields`);
    }
    checkConectionInEditableSource(id, fields) {
        return this.restService.post(`/data-source/${id}/check-connection`, {
            fields,
        });
    }
}
SourceApiService.ɵfac = function SourceApiService_Factory(t) { return new (t || SourceApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
SourceApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: SourceApiService, factory: SourceApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 9877:
/*!***********************************************************************!*\
  !*** ./src/app/components/input-material/input-material.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputMaterialComponent": () => (/* binding */ InputMaterialComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);

const _c0 = ["inputComponent"];
class InputMaterialComponent {
    constructor() {
        this.label = '';
        this.name = '';
        this.type = '';
        this.togglePassword = false;
        this.hasExistValue = false;
        this.onChange = () => {
            var _a;
            this.hasExistValue = !!((_a = this.inputComponent.nativeElement) === null || _a === void 0 ? void 0 : _a.value);
        };
    }
    ngAfterViewInit() {
        var _a, _b, _c;
        (_a = this.inputComponent.nativeElement) === null || _a === void 0 ? void 0 : _a.addEventListener('sl-focus', () => (this.hasExistValue = true));
        (_b = this.inputComponent.nativeElement) === null || _b === void 0 ? void 0 : _b.addEventListener('sl-blur', this.onChange);
        (_c = this.inputComponent.nativeElement) === null || _c === void 0 ? void 0 : _c.addEventListener('sl-change', this.onChange);
    }
}
InputMaterialComponent.ɵfac = function InputMaterialComponent_Factory(t) { return new (t || InputMaterialComponent)(); };
InputMaterialComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: InputMaterialComponent, selectors: [["app-input-material"]], viewQuery: function InputMaterialComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c0, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.inputComponent = _t.first);
    } }, inputs: { label: "label", name: "name", type: "type", togglePassword: "togglePassword" }, decls: 2, vars: 6, consts: [[3, "label", "name"], ["inputComponent", ""]], template: function InputMaterialComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "sl-input", 0, 1);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("_exist-value", ctx.hasExistValue);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("label", ctx.label)("name", ctx.name);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("type", ctx.type)("toggle-password", ctx.togglePassword);
    } }, styles: ["[_nghost-%COMP%] {\n  display: block;\n}\nsl-input[_ngcontent-%COMP%]::part(base) {\n  border-right: transparent;\n  border-left: transparent;\n  border-top: transparent;\n  border-radius: 0;\n  --focus-ring: none;\n}\nsl-input[_ngcontent-%COMP%]::part(label) {\n  transform: translateY(1.9em);\n  transition: transform 0.3s ease;\n  color: var(--sl-color-secondary-600);\n  font-size: 14px;\n  position: relative;\n  z-index: 2;\n}\nsl-input[_ngcontent-%COMP%]::part(input) {\n  margin-left: 0;\n}\nsl-input._exist-value[_ngcontent-%COMP%]::part(label) {\n  transform: translateY(0);\n  font-size: 12px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlucHV0LW1hdGVyaWFsLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksY0FBQTtBQUNKO0FBR0k7RUFDSSx5QkFBQTtFQUNBLHdCQUFBO0VBQ0EsdUJBQUE7RUFDQSxnQkFBQTtFQUVBLGtCQUFBO0FBRlI7QUFLSTtFQUNJLDRCQUFBO0VBQ0EsK0JBQUE7RUFDQSxvQ0FBQTtFQUNBLGVBQUE7RUFDQSxrQkFBQTtFQUNBLFVBQUE7QUFIUjtBQU1JO0VBQ0ksY0FBQTtBQUpSO0FBUUE7RUFDSSx3QkFBQTtFQUNBLGVBQUE7QUFOSiIsImZpbGUiOiJpbnB1dC1tYXRlcmlhbC5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICBkaXNwbGF5OiBibG9jaztcbn1cblxuc2wtaW5wdXQge1xuICAgICY6OnBhcnQoYmFzZSkge1xuICAgICAgICBib3JkZXItcmlnaHQ6IHRyYW5zcGFyZW50O1xuICAgICAgICBib3JkZXItbGVmdDogdHJhbnNwYXJlbnQ7XG4gICAgICAgIGJvcmRlci10b3A6IHRyYW5zcGFyZW50O1xuICAgICAgICBib3JkZXItcmFkaXVzOiAwO1xuXG4gICAgICAgIC0tZm9jdXMtcmluZzogbm9uZTtcbiAgICB9XG5cbiAgICAmOjpwYXJ0KGxhYmVsKSB7XG4gICAgICAgIHRyYW5zZm9ybTogdHJhbnNsYXRlWSgxLjllbSk7XG4gICAgICAgIHRyYW5zaXRpb246IHRyYW5zZm9ybSAwLjNzIGVhc2U7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktNjAwKTtcbiAgICAgICAgZm9udC1zaXplOiAxNHB4O1xuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgIHotaW5kZXg6IDI7XG4gICAgfVxuXG4gICAgJjo6cGFydChpbnB1dCkge1xuICAgICAgICBtYXJnaW4tbGVmdDogMDtcbiAgICB9XG59XG5cbnNsLWlucHV0Ll9leGlzdC12YWx1ZTo6cGFydChsYWJlbCkge1xuICAgIHRyYW5zZm9ybTogdHJhbnNsYXRlWSgwKTtcbiAgICBmb250LXNpemU6IDEycHg7XG59XG4iXX0= */"] });


/***/ }),

/***/ 5068:
/*!********************************************************************!*\
  !*** ./src/app/components/input-material/input-material.module.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputMaterialModule": () => (/* binding */ InputMaterialModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _input_material_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./input-material.component */ 9877);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);




class InputMaterialModule {
}
InputMaterialModule.ɵfac = function InputMaterialModule_Factory(t) { return new (t || InputMaterialModule)(); };
InputMaterialModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: InputMaterialModule });
InputMaterialModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](InputMaterialModule, { declarations: [_input_material_component__WEBPACK_IMPORTED_MODULE_0__.InputMaterialComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule], exports: [_input_material_component__WEBPACK_IMPORTED_MODULE_0__.InputMaterialComponent] }); })();


/***/ }),

/***/ 4335:
/*!*********************************************************************!*\
  !*** ./src/app/components/modal-actions/modal-actions.component.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalActionsComponent": () => (/* binding */ ModalActionsComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);




function ModalActionsComponent_sl_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalActionsComponent_sl_button_1_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r4); const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r3.onBack.emit()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r0.backTitle), " ");
} }
function ModalActionsComponent_sl_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalActionsComponent_sl_button_3_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.onCancel.emit()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r1.cancelTitle), " ");
} }
function ModalActionsComponent_sl_button_4_Template(rf, ctx) { if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalActionsComponent_sl_button_4_Template_sl_button_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r8); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r7.onOk.emit($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("loading", ctx_r2.loading);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 2, ctx_r2.okTitle), " ");
} }
const _c0 = ["*"];
class ModalActionsComponent {
    constructor() {
        this.hasCancel = true;
        this.hasOk = true;
        this.hasBack = true;
        this.okTitle = '$.save';
        this.cancelTitle = '$.cancel';
        this.backTitle = '$.back';
        this.loading = false;
        this.onOk = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onBack = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }
}
ModalActionsComponent.ɵfac = function ModalActionsComponent_Factory(t) { return new (t || ModalActionsComponent)(); };
ModalActionsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ModalActionsComponent, selectors: [["app-modal-actions"]], inputs: { hasCancel: "hasCancel", hasOk: "hasOk", hasBack: "hasBack", okTitle: "okTitle", cancelTitle: "cancelTitle", backTitle: "backTitle", loading: "loading" }, outputs: { onOk: "onOk", onCancel: "onCancel", onBack: "onBack" }, ngContentSelectors: _c0, decls: 6, vars: 5, consts: [[1, "actions"], ["variant", "text", 3, "click", 4, "ngIf"], [1, "right-panel"], ["variant", "primary", "outline", "", 3, "click", 4, "ngIf"], ["variant", "primary", "type", "submit", 3, "loading", "click", 4, "ngIf"], ["variant", "text", 3, "click"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", "type", "submit", 3, "loading", "click"]], template: function ModalActionsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, ModalActionsComponent_sl_button_1_Template, 3, 3, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, ModalActionsComponent_sl_button_3_Template, 3, 3, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, ModalActionsComponent_sl_button_4_Template, 3, 4, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("has-back-button", ctx.hasBack);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.hasBack);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.hasCancel);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.hasOk);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_1__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.TranslatePipe], styles: [".actions[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  margin-top: var(--sl-spacing-x-large);\n}\n.actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:not([variant='text']) {\n  margin-left: var(--sl-spacing-small);\n}\n.actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:not([variant='text'])::part(base) {\n  border-radius: 2px;\n  height: auto;\n}\n.actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:not([variant='text'])::part(label) {\n  padding: calc(var(--sl-spacing-2x-small) - 1px) calc(var(--sl-spacing-medium) - 1px);\n  line-height: 28px;\n}\n.has-back-button[_ngcontent-%COMP%] {\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vZGFsLWFjdGlvbnMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSx5QkFBQTtFQUNBLHFDQUFBO0FBQ0o7QUFMQTtFQU9RLG9DQUFBO0FBQ1I7QUFDUTtFQUNJLGtCQUFBO0VBQ0EsWUFBQTtBQUNaO0FBRVE7RUFDSSxvRkFBQTtFQUVBLGlCQUFBO0FBRFo7QUFNQTtFQUNJLDhCQUFBO0FBSkoiLCJmaWxlIjoibW9kYWwtYWN0aW9ucy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5hY3Rpb25zIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gICAganVzdGlmeS1jb250ZW50OiBmbGV4LWVuZDtcbiAgICBtYXJnaW4tdG9wOiB2YXIoLS1zbC1zcGFjaW5nLXgtbGFyZ2UpO1xuXG4gICAgc2wtYnV0dG9uOm5vdChbdmFyaWFudD0ndGV4dCddKSB7XG4gICAgICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcblxuICAgICAgICAmOjpwYXJ0KGJhc2UpIHtcbiAgICAgICAgICAgIGJvcmRlci1yYWRpdXM6IDJweDtcbiAgICAgICAgICAgIGhlaWdodDogYXV0bztcbiAgICAgICAgfVxuXG4gICAgICAgICY6OnBhcnQobGFiZWwpIHtcbiAgICAgICAgICAgIHBhZGRpbmc6IGNhbGModmFyKC0tc2wtc3BhY2luZy0yeC1zbWFsbCkgLSAxcHgpXG4gICAgICAgICAgICAgICAgY2FsYyh2YXIoLS1zbC1zcGFjaW5nLW1lZGl1bSkgLSAxcHgpO1xuICAgICAgICAgICAgbGluZS1oZWlnaHQ6IDI4cHg7XG4gICAgICAgIH1cbiAgICB9XG59XG5cbi5oYXMtYmFjay1idXR0b24ge1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 4108:
/*!******************************************************************!*\
  !*** ./src/app/components/modal-actions/modal-actions.module.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalActionsModule": () => (/* binding */ ModalActionsModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modal_actions_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modal-actions.component */ 4335);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);




class ModalActionsModule {
}
ModalActionsModule.ɵfac = function ModalActionsModule_Factory(t) { return new (t || ModalActionsModule)(); };
ModalActionsModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: ModalActionsModule });
ModalActionsModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](ModalActionsModule, { declarations: [_modal_actions_component__WEBPACK_IMPORTED_MODULE_0__.ModalActionsComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule], exports: [_modal_actions_component__WEBPACK_IMPORTED_MODULE_0__.ModalActionsComponent] }); })();


/***/ }),

/***/ 3762:
/*!*********************************!*\
  !*** ./src/app/enums/plugin.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PluginConnectView": () => (/* binding */ PluginConnectView),
/* harmony export */   "PluginFieldTypeEnum": () => (/* binding */ PluginFieldTypeEnum),
/* harmony export */   "PluginFileType": () => (/* binding */ PluginFileType),
/* harmony export */   "PluginHandler": () => (/* binding */ PluginHandler),
/* harmony export */   "PluginQueryView": () => (/* binding */ PluginQueryView),
/* harmony export */   "PluginType": () => (/* binding */ PluginType)
/* harmony export */ });
var PluginType;
(function (PluginType) {
    PluginType[PluginType["Source"] = 0] = "Source";
    PluginType[PluginType["Dataset"] = 1] = "Dataset";
    PluginType[PluginType["OnlyDataset"] = 2] = "OnlyDataset";
})(PluginType || (PluginType = {}));
var PluginHandler;
(function (PluginHandler) {
    PluginHandler[PluginHandler["CheckConnect"] = 0] = "CheckConnect";
})(PluginHandler || (PluginHandler = {}));
var PluginQueryView;
(function (PluginQueryView) {
    PluginQueryView[PluginQueryView["Fields"] = 0] = "Fields";
    PluginQueryView[PluginQueryView["File"] = 1] = "File";
    PluginQueryView[PluginQueryView["List"] = 2] = "List";
    PluginQueryView[PluginQueryView["MultiList"] = 3] = "MultiList";
})(PluginQueryView || (PluginQueryView = {}));
var PluginConnectView;
(function (PluginConnectView) {
    PluginConnectView[PluginConnectView["Fields"] = 0] = "Fields";
})(PluginConnectView || (PluginConnectView = {}));
var PluginFileType;
(function (PluginFileType) {
    PluginFileType["Csv"] = "file-csv";
    PluginFileType["Json"] = "file-json";
    PluginFileType["Xls"] = "file-xls";
    PluginFileType["Xml"] = "file-xml";
})(PluginFileType || (PluginFileType = {}));
var PluginFieldTypeEnum;
(function (PluginFieldTypeEnum) {
    PluginFieldTypeEnum["string"] = "string";
    PluginFieldTypeEnum["password"] = "password";
    PluginFieldTypeEnum["stringFormat"] = "stringFormat";
    PluginFieldTypeEnum["text"] = "text";
})(PluginFieldTypeEnum || (PluginFieldTypeEnum = {}));


/***/ }),

/***/ 5228:
/*!*********************************!*\
  !*** ./src/app/enums/source.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EConnectStatus": () => (/* binding */ EConnectStatus),
/* harmony export */   "EServiceHandler": () => (/* binding */ EServiceHandler),
/* harmony export */   "EServiceType": () => (/* binding */ EServiceType),
/* harmony export */   "ESourceType": () => (/* binding */ ESourceType)
/* harmony export */ });
var EServiceHandler;
(function (EServiceHandler) {
    EServiceHandler[EServiceHandler["ServiceHandlerCheckConnect"] = 0] = "ServiceHandlerCheckConnect";
})(EServiceHandler || (EServiceHandler = {}));
var EServiceType;
(function (EServiceType) {
    EServiceType[EServiceType["ServiceTypeDB"] = 0] = "ServiceTypeDB";
    EServiceType[EServiceType["ServiceTypeFile"] = 1] = "ServiceTypeFile";
})(EServiceType || (EServiceType = {}));
var ESourceType;
(function (ESourceType) {
    ESourceType[ESourceType["SourceTypeXLS"] = 0] = "SourceTypeXLS";
    ESourceType[ESourceType["SourceTypeXML"] = 1] = "SourceTypeXML";
    ESourceType[ESourceType["SourceTypeCSV"] = 2] = "SourceTypeCSV";
    ESourceType[ESourceType["SourceTypeJSON"] = 3] = "SourceTypeJSON";
    ESourceType[ESourceType["SourceTypeMongo"] = 4] = "SourceTypeMongo";
    ESourceType[ESourceType["SourceTypeClickHouse"] = 5] = "SourceTypeClickHouse";
    ESourceType[ESourceType["SourceTypePostgres"] = 6] = "SourceTypePostgres";
    ESourceType[ESourceType["SourceTypeSqlite"] = 7] = "SourceTypeSqlite";
    ESourceType[ESourceType["SourceTypeMySql"] = 8] = "SourceTypeMySql";
    ESourceType[ESourceType["SourceTypeSqlServer"] = 9] = "SourceTypeSqlServer";
    ESourceType[ESourceType["SourceTypeBigQuery"] = 10] = "SourceTypeBigQuery";
})(ESourceType || (ESourceType = {}));
var EConnectStatus;
(function (EConnectStatus) {
    EConnectStatus[EConnectStatus["Undefined"] = 0] = "Undefined";
    EConnectStatus[EConnectStatus["Wait"] = 1] = "Wait";
    EConnectStatus[EConnectStatus["Success"] = 2] = "Success";
    EConnectStatus[EConnectStatus["Reject"] = 3] = "Reject";
})(EConnectStatus || (EConnectStatus = {}));


/***/ }),

/***/ 4517:
/*!***************************************!*\
  !*** ./src/app/helpers/clone-deep.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cloneDeep": () => (/* binding */ cloneDeep)
/* harmony export */ });
function cloneDeep(item) {
    return Object.assign(Object.create(item), item);
}


/***/ }),

/***/ 8268:
/*!*****************************************************!*\
  !*** ./src/app/modals/confirm/confirm.component.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConfirmComponent": () => (/* binding */ ConfirmComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);





function ConfirmComponent_p_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r0.description), " ");
} }
const _c0 = ["*"];
class ConfirmComponent {
    constructor() {
        this.title = 'modalConfirm#actionConfirm';
        this.description = '';
        this.onOk = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.isOpen = false;
    }
    show(data) {
        this.data = data;
        this.isOpen = true;
    }
    cancel() {
        this.isOpen = false;
        this.onCancel.emit(this.data);
    }
    ok() {
        this.isOpen = false;
        this.onOk.emit(this.data);
    }
}
ConfirmComponent.ɵfac = function ConfirmComponent_Factory(t) { return new (t || ConfirmComponent)(); };
ConfirmComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ConfirmComponent, selectors: [["app-confirm"]], inputs: { title: "title", description: "description" }, outputs: { onOk: "onOk", onCancel: "onCancel" }, ngContentSelectors: _c0, decls: 15, vars: 11, consts: [[3, "open", "openChange"], [1, "content"], [4, "ngIf"], [1, "content-wrapper"], [1, "buttons"], [3, "click"], ["variant", "danger", 3, "click"]], template: function ConfirmComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("openChange", function ConfirmComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1)(2, "h1");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, ConfirmComponent_p_5_Template, 3, 3, "p", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 4)(9, "sl-button", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ConfirmComponent_Template_sl_button_click_9_listener() { return ctx.cancel(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "sl-button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ConfirmComponent_Template_sl_button_click_12_listener() { return ctx.ok(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](4, 5, ctx.title));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.description);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](11, 7, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](14, 9, "$.apply"), " ");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_1__.NgIf, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: [".buttons[_ngcontent-%COMP%] {\n  margin-top: var(--sl-spacing-3x-large);\n  display: flex;\n  justify-content: center;\n}\n.buttons[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-small);\n}\n.content[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-x-large) 0 0;\n  text-align: center;\n}\n.content[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  margin: 0;\n  font-size: var(--sl-font-size-x-large);\n}\n.content[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n  font-size: var(--sl-font-size-medium);\n}\nsl-dialog[_ngcontent-%COMP%]::part(header) {\n  display: none;\n}\n.content-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  overflow-y: auto;\n  overflow-x: hidden;\n  max-height: calc(100vh - 320px);\n  margin: 20px 0;\n  padding: 0 20px;\n  word-break: break-word;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbmZpcm0uY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxzQ0FBQTtFQUNBLGFBQUE7RUFDQSx1QkFBQTtBQUNKO0FBSkE7RUFNUSxvQ0FBQTtBQUNSO0FBR0E7RUFDSSxzQ0FBQTtFQUNBLGtCQUFBO0FBREo7QUFEQTtFQUtRLFNBQUE7RUFDQSxzQ0FBQTtBQURSO0FBTEE7RUFVUSxvQ0FBQTtFQUNBLHFDQUFBO0FBRlI7QUFNQTtFQUNJLGFBQUE7QUFKSjtBQU9BO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsZ0JBQUE7RUFDQSxrQkFBQTtFQUNBLCtCQUFBO0VBQ0EsY0FBQTtFQUNBLGVBQUE7RUFDQSxzQkFBQTtBQUxKIiwiZmlsZSI6ImNvbmZpcm0uY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnV0dG9ucyB7XG4gICAgbWFyZ2luLXRvcDogdmFyKC0tc2wtc3BhY2luZy0zeC1sYXJnZSk7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcblxuICAgIHNsLWJ1dHRvbiB7XG4gICAgICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbiAgICB9XG59XG5cbi5jb250ZW50IHtcbiAgICBwYWRkaW5nOiB2YXIoLS1zbC1zcGFjaW5nLXgtbGFyZ2UpIDAgMDtcbiAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG5cbiAgICBoMSB7XG4gICAgICAgIG1hcmdpbjogMDtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUteC1sYXJnZSk7XG4gICAgfVxuXG4gICAgcCB7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktOTAwKTtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUtbWVkaXVtKTtcbiAgICB9XG59XG5cbnNsLWRpYWxvZzo6cGFydChoZWFkZXIpIHtcbiAgICBkaXNwbGF5OiBub25lO1xufVxuXG4uY29udGVudC13cmFwcGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgb3ZlcmZsb3cteTogYXV0bztcbiAgICBvdmVyZmxvdy14OiBoaWRkZW47XG4gICAgbWF4LWhlaWdodDogY2FsYygxMDB2aCAtIDMyMHB4KTtcbiAgICBtYXJnaW46IDIwcHggMDtcbiAgICBwYWRkaW5nOiAwIDIwcHg7XG4gICAgd29yZC1icmVhazogYnJlYWstd29yZDtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 5254:
/*!**************************************************!*\
  !*** ./src/app/modals/confirm/confirm.module.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConfirmModule": () => (/* binding */ ConfirmModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _confirm_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./confirm.component */ 8268);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);





class ConfirmModule {
}
ConfirmModule.ɵfac = function ConfirmModule_Factory(t) { return new (t || ConfirmModule)(); };
ConfirmModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: ConfirmModule });
ConfirmModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](ConfirmModule, { declarations: [_confirm_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule], exports: [_confirm_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmComponent] }); })();


/***/ }),

/***/ 9489:
/*!**************************************************************************************!*\
  !*** ./src/app/modals/source-modal/connection-fields/connection-fields.component.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConnectionFieldsComponent": () => (/* binding */ ConnectionFieldsComponent)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../enums/state */ 3755);
/* harmony import */ var _enums_source__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../enums/source */ 5228);
/* harmony import */ var _source_modal_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../source-modal.service */ 4565);
/* harmony import */ var src_app_helpers_clone_deep__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/helpers/clone-deep */ 4517);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/enums/plugin */ 3762);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! logical-not */ 2905);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _api_plugin_api_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../api/plugin-api.service */ 4819);
/* harmony import */ var _api_source_api_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../api/source-api.service */ 8916);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _components_modal_header_modal_header_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/modal-header/modal-header.component */ 4057);
/* harmony import */ var _components_plugin_field_plugin_field_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/plugin-field/plugin-field.component */ 7567);
















function ConnectionFieldsComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 9)(1, "app-plugin-field", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("changes", function ConnectionFieldsComponent_div_3_Template_app_plugin_field_changes_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r6.getFieldChanges()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const item_r4 = ctx.$implicit;
    const i_r5 = ctx.index;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("field", item_r4)("control", ctx_r0.fieldsControl.at(i_r5).get("value"));
} }
function ConnectionFieldsComponent_sl_button_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](1, "sl-icon", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](3, 1, "modalSource#checkConnectionFail"), " ");
} }
function ConnectionFieldsComponent_sl_button_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](1, "sl-icon", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](3, 1, "modalSource#checkConnectionSuccess"), " ");
} }
function ConnectionFieldsComponent_sl_button_7_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "sl-button", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function ConnectionFieldsComponent_sl_button_7_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r9); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r8.checkConnection()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("loading", ctx_r3.checkConnectionLoading === ctx_r3.ELoadingState.Wait);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 2, "modalSource#checkConnection"), " ");
} }
const PASWORD_FIELD = 'password';
class MaskProcessor {
    constructor(source) {
        this.context = {};
        const template = source.replace(/\{(.+?)\}/g, (_, name) => {
            this.context[name] = this.createDefault(name);
            return '${this.context.' + name + '}';
        });
        this.compiler = new Function('return `' + template + '`').bind(this);
    }
    get value() {
        return this.compiler();
    }
    has(name) {
        return name in this.context;
    }
    set(name, value) {
        this.context[name] = value || this.createDefault(name);
    }
    createDefault(name) {
        return name === PASWORD_FIELD ? '' : '{' + name + '}';
    }
}
class ConnectionFieldsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_11__.SubscribableComponent {
    constructor(sourceModalService, pluginApiService, sourceApiService, formService) {
        super();
        this.sourceModalService = sourceModalService;
        this.pluginApiService = pluginApiService;
        this.sourceApiService = sourceApiService;
        this.formService = formService;
        this.plugin = this.sourceModalService.plugin;
        this.fieldsControl = this.sourceModalService.form.get('fields');
        this.checkConnectionLoading = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Default;
        this.connectStatus = _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Undefined;
        this.displayCheckConnectionBtn = true;
        this.FormState = plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.FormState;
        this.EConnectStatus = _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus;
        this.ELoadingState = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState;
    }
    get formatState() {
        return this.sourceModalService.form.state;
    }
    ngOnInit() {
        this.initialFields = (0,src_app_helpers_clone_deep__WEBPACK_IMPORTED_MODULE_3__.cloneDeep)(this.sourceModalService.form.value);
        this.initStringFormatParameters();
    }
    getFieldsValue() {
        this.sourceApiService
            .getConectionFields(this.sourceModalService.form.value.id)
            .subscribe(({ fields }) => {
            this.fieldsControl.controls.forEach((control) => {
                const fieldName = control.value.name;
                const foundField = fields.find((field) => field.name === fieldName);
                if (foundField) {
                    control.patchValue(foundField);
                }
            });
        });
    }
    next() {
        if (this.fieldsControl.invalid) {
            this.formService.showLocalErrors(this.sourceModalService.form);
            return;
        }
        if (this.connectStatus === _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Reject) {
            this.checkConnection(true);
        }
        this.sourceModalService.state.next(_source_modal_service__WEBPACK_IMPORTED_MODULE_2__.SourceModalState.ModelForm);
    }
    checkConnection(next = false) {
        if (this.fieldsControl.invalid) {
            this.formService.showLocalErrors(this.sourceModalService.form);
            return;
        }
        this.displayCheckConnectionBtn = false;
        if (this.plugin.sys_name) {
            this.checkConnectionLoading = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Wait;
            const fieldsValue = this.fieldsControl.value;
            if (this.sourceModalService.form.value.id) {
                this.sourceApiService
                    .checkConectionInEditableSource(this.sourceModalService.form.value.id, fieldsValue)
                    .subscribe({
                    next: (response) => {
                        this.connectStatus = response.status
                            ? _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Success
                            : _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Reject;
                        this.checkConnectionLoading = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Success;
                        if (this.connectStatus === _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Success &&
                            next) {
                            this.next();
                        }
                    },
                    error: () => {
                        this.checkConnectionLoading = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Reject;
                    },
                });
            }
            else {
                this.pluginApiService
                    .checkConnection(this.plugin.sys_name, fieldsValue)
                    .subscribe({
                    next: (response) => {
                        this.connectStatus = response.status
                            ? _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Success
                            : _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Reject;
                        this.checkConnectionLoading = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Success;
                        if (this.connectStatus === _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Success &&
                            next) {
                            this.next();
                        }
                    },
                    error: () => {
                        this.checkConnectionLoading = _enums_state__WEBPACK_IMPORTED_MODULE_0__.ELoadingState.Reject;
                    },
                });
            }
        }
    }
    back() {
        if (this.formatState === plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.FormState.Create) {
            this.sourceModalService.form.reset();
            this.sourceModalService.state.next(_source_modal_service__WEBPACK_IMPORTED_MODULE_2__.SourceModalState.PluginList);
        }
        else {
            this.sourceModalService.form.reset(this.initialFields);
            this.sourceModalService.state.next(_source_modal_service__WEBPACK_IMPORTED_MODULE_2__.SourceModalState.ModelForm);
        }
    }
    getFieldChanges() {
        this.connectStatus = _enums_source__WEBPACK_IMPORTED_MODULE_1__.EConnectStatus.Undefined;
        this.displayCheckConnectionBtn = true;
    }
    initStringFormatParameters() {
        var _a;
        (_a = this.plugin.connect_fields) === null || _a === void 0 ? void 0 : _a.forEach((config) => {
            if (config.type !== src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_4__.PluginFieldTypeEnum.stringFormat)
                return;
            const pluginField = this.getFieldsControl(config.name);
            if ((0,logical_not__WEBPACK_IMPORTED_MODULE_5__.not)(pluginField))
                return;
            const target = pluginField.get('value');
            if ((0,logical_not__WEBPACK_IMPORTED_MODULE_5__.not)(target))
                return;
            const maskProcessor = new MaskProcessor(target.value); // config.mask?
            const stringFormatParameters = config.string_format_parameters || [];
            this.fieldsControl.controls.forEach((control) => {
                if (control === pluginField)
                    return;
                const { name } = control.value;
                const stringFormatParameter = stringFormatParameters.find((item) => item.name === name);
                if (stringFormatParameter) {
                    const { name, output } = stringFormatParameter;
                    const fieldsControl = this.getFieldsControl(name);
                    if ((0,logical_not__WEBPACK_IMPORTED_MODULE_5__.not)(fieldsControl))
                        return;
                    const control = fieldsControl.get('value');
                    if ((0,logical_not__WEBPACK_IMPORTED_MODULE_5__.not)(control))
                        return;
                    maskProcessor.set(name, control.value);
                    const outputFn = new Function(`return (${output})`)();
                    this.subscriptions.push(control.valueChanges.subscribe((value) => {
                        maskProcessor.set(name, outputFn(value));
                        target.patchValue(maskProcessor.value);
                    }));
                }
                else {
                    if ((0,logical_not__WEBPACK_IMPORTED_MODULE_5__.not)(maskProcessor.has(name)))
                        return;
                    const valueControl = control.get('value');
                    if ((0,logical_not__WEBPACK_IMPORTED_MODULE_5__.not)(valueControl))
                        return;
                    maskProcessor.set(name, valueControl.value);
                    this.subscriptions.push(valueControl.valueChanges.subscribe((value) => {
                        maskProcessor.set(name, value);
                        target.patchValue(maskProcessor.value);
                    }));
                    target.patchValue(maskProcessor.value);
                }
            });
        });
    }
    getFieldsControl(name) {
        return this.fieldsControl.controls.find(({ value }) => value.name === name);
    }
}
ConnectionFieldsComponent.ɵfac = function ConnectionFieldsComponent_Factory(t) { return new (t || ConnectionFieldsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_source_modal_service__WEBPACK_IMPORTED_MODULE_2__.SourceModalService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_api_plugin_api_service__WEBPACK_IMPORTED_MODULE_6__.PluginApiService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_api_source_api_service__WEBPACK_IMPORTED_MODULE_7__.SourceApiService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.FormService)); };
ConnectionFieldsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineComponent"]({ type: ConnectionFieldsComponent, selectors: [["app-connection-fields"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵInheritDefinitionFeature"]], decls: 15, vars: 17, consts: [[3, "title", "subTitle"], ["class", "item", 4, "ngFor", "ngForOf"], [1, "check-conection-btn"], ["class", "ml-0 not-hover", "variant", "danger", "outline", "", 4, "ngIf"], ["class", "ml-0 not-hover", "variant", "success", "outline", "", 4, "ngIf"], ["class", "ml-0", "variant", "default", 3, "loading", "click", 4, "ngIf"], [1, "between"], ["variant", "text", 3, "click"], ["variant", "primary", 1, "ml-0", 3, "loading", "click"], [1, "item"], [3, "field", "control", "changes"], ["variant", "danger", "outline", "", 1, "ml-0", "not-hover"], ["slot", "prefix", "name", "x"], ["variant", "success", "outline", "", 1, "ml-0", "not-hover"], ["slot", "prefix", "name", "check2-circle"], ["variant", "default", 1, "ml-0", 3, "loading", "click"]], template: function ConnectionFieldsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "app-modal-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](3, ConnectionFieldsComponent_div_3_Template, 2, 2, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](4, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](5, ConnectionFieldsComponent_sl_button_5_Template, 4, 3, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](6, ConnectionFieldsComponent_sl_button_6_Template, 4, 3, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](7, ConnectionFieldsComponent_sl_button_7_Template, 3, 4, "sl-button", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](8, "footer", 6)(9, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function ConnectionFieldsComponent_Template_sl_button_click_9_listener() { return ctx.back(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](12, "sl-button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function ConnectionFieldsComponent_Template_sl_button_click_12_listener() { return ctx.next(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](1, 9, "modalSource.source." + ctx.formatState))("subTitle", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](2, 11, "modalSource#conectionSettings"));
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngForOf", ctx.plugin.connect_fields);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.connectStatus == ctx.EConnectStatus.Reject && !ctx.displayCheckConnectionBtn);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.connectStatus == ctx.EConnectStatus.Success && !ctx.displayCheckConnectionBtn);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.connectStatus == ctx.EConnectStatus.Undefined || ctx.connectStatus == ctx.EConnectStatus.Wait || ctx.displayCheckConnectionBtn);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](11, 13, "modalSource#back"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("loading", ctx.checkConnectionLoading === ctx.ELoadingState.Wait);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵpipeBind1"](14, 15, "modalSource.nextButton." + ctx.formatState), " ");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_13__.NgIf, _components_modal_header_modal_header_component__WEBPACK_IMPORTED_MODULE_8__.ModalHeaderComponent, _components_plugin_field_plugin_field_component__WEBPACK_IMPORTED_MODULE_9__.PluginFieldComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_12__.TranslatePipe], styles: [".item[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-medium);\n}\nfooter[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: right;\n  align-items: center;\n}\nsl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n}\n.success[_ngcontent-%COMP%] {\n  color: var(--sl-color-success-600);\n  font-size: 20px;\n}\n.reject[_ngcontent-%COMP%] {\n  color: var(--sl-color-danger-400);\n}\n.between[_ngcontent-%COMP%] {\n  justify-content: space-between;\n}\n.ml-0[_ngcontent-%COMP%] {\n  margin-left: 0;\n}\n.not-hover[_ngcontent-%COMP%]:hover {\n  cursor: initial;\n}\n.check-conection-btn[_ngcontent-%COMP%] {\n  margin: var(--sl-spacing-x-large) 0;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbm5lY3Rpb24tZmllbGRzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksdUNBQUE7QUFDSjtBQUVBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsbUJBQUE7QUFBSjtBQUdBO0VBQ0ksaUJBQUE7QUFESjtBQUlBO0VBQ0ksa0NBQUE7RUFDQSxlQUFBO0FBRko7QUFLQTtFQUNJLGlDQUFBO0FBSEo7QUFNQTtFQUNJLDhCQUFBO0FBSko7QUFPQTtFQUNJLGNBQUE7QUFMSjtBQVFBO0VBQ0ksZUFBQTtBQU5KO0FBU0E7RUFDSSxtQ0FBQTtBQVBKIiwiZmlsZSI6ImNvbm5lY3Rpb24tZmllbGRzLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLml0ZW0ge1xuICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKTtcbn1cblxuZm9vdGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbn1cblxuc2wtYnV0dG9uIHtcbiAgICBtYXJnaW4tbGVmdDogMTBweDtcbn1cblxuLnN1Y2Nlc3Mge1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zdWNjZXNzLTYwMCk7XG4gICAgZm9udC1zaXplOiAyMHB4O1xufVxuXG4ucmVqZWN0IHtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3ItZGFuZ2VyLTQwMCk7XG59XG5cbi5iZXR3ZWVuIHtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG5cbi5tbC0wIHtcbiAgICBtYXJnaW4tbGVmdDogMDtcbn1cblxuLm5vdC1ob3Zlcjpob3ZlciB7XG4gICAgY3Vyc29yOiBpbml0aWFsO1xufVxuXG4uY2hlY2stY29uZWN0aW9uLWJ0biB7XG4gICAgbWFyZ2luOiB2YXIoLS1zbC1zcGFjaW5nLXgtbGFyZ2UpIDA7XG59XG4iXX0= */"] });


/***/ }),

/***/ 6335:
/*!************************************************************************!*\
  !*** ./src/app/modals/source-modal/model-form/model-form.component.ts ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModelFormComponent": () => (/* binding */ ModelFormComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _source_modal_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../source-modal.service */ 4565);
/* harmony import */ var src_app_api_source_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/api/source-api.service */ 8916);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _components_modal_header_modal_header_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/modal-header/modal-header.component */ 4057);










function ModelFormComponent_core_access_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-access", 10);
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("settings", ctx_r0.source);
} }
class ModelFormComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_4__.SubscribableComponent {
    constructor(formService, sourceModalService, sourceApiService, notifyService, responseErrorService) {
        super();
        this.formService = formService;
        this.sourceModalService = sourceModalService;
        this.sourceApiService = sourceApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AccessRight;
        this.onComplete = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.sourceForm = this.sourceModalService.form;
        this.modelNameControl = this.sourceModalService.form.get('name');
        this.modelCommentControl = this.sourceModalService.form.get('comment');
        this.FormState = plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.FormState;
    }
    get conectionBtn() {
        return this.sourceForm.value.id
            ? 'modalSource#conectionSettingsBtn'
            : 'modalSource#back';
    }
    get saveBtn() {
        return this.sourceForm.state === plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.FormState.Create
            ? '$.create'
            : '$.save';
    }
    submit() {
        if (this.modelNameControl.invalid || this.modelCommentControl.invalid) {
            this.formService.showLocalErrors(this.sourceForm);
            return;
        }
        this.sourceApiService.save(this.sourceForm.value).subscribe({
            next: () => {
                this.onComplete.emit();
                this.notifyService.toastByName('noteSource');
            },
            error: (response) => {
                this.formService.showServerErrors(this.sourceForm, response.error);
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: `modelForm#notification.${this.sourceForm.state}.danger`,
                });
            },
        });
    }
    back() {
        this.sourceModalService.state.next(_source_modal_service__WEBPACK_IMPORTED_MODULE_0__.SourceModalState.ConnectionForm);
    }
}
ModelFormComponent.ɵfac = function ModelFormComponent_Factory(t) { return new (t || ModelFormComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_source_modal_service__WEBPACK_IMPORTED_MODULE_0__.SourceModalService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_api_source_api_service__WEBPACK_IMPORTED_MODULE_1__.SourceApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService)); };
ModelFormComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: ModelFormComponent, selectors: [["app-model-form"]], inputs: { source: "source" }, outputs: { onComplete: "onComplete", onCancel: "onCancel" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵInheritDefinitionFeature"]], decls: 25, vars: 26, consts: [[3, "title", "subTitle"], [3, "data"], ["name", "name", 3, "label"], ["rows", "1", "name", "comment", "resize", "auto", 3, "label"], [3, "settings", 4, "ngIf"], ["variant", "text", 3, "click"], [1, "actions-button"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", 3, "click"], ["variant", "success", "name", "noteSource"], [3, "settings"]], template: function ModelFormComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "app-modal-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "core-form", 1)(4, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](5, "sl-input", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](8, "sl-textarea", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](10, ModelFormComponent_core_access_10_Template, 1, 1, "core-access", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](11, "footer")(12, "sl-button", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ModelFormComponent_Template_sl_button_click_12_listener() { return ctx.back(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "div", 6)(16, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ModelFormComponent_Template_sl_button_click_16_listener() { return ctx.onCancel.emit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](19, "sl-button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ModelFormComponent_Template_sl_button_click_19_listener() { return ctx.submit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](22, "core-notify", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](1, 10, "modalSource.source." + ctx.sourceForm.state))("subTitle", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 12, "modalSource#nameAndAccess"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("data", ctx.sourceForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 14, "modalSource#name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](9, 16, "modalSource#description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.source.access_right === ctx.AccessRight.Full);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](14, 18, ctx.conectionBtn), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](18, 20, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](21, 22, ctx.saveBtn), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](24, 24, "modelForm#notification." + ctx.sourceForm.state), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _components_modal_header_modal_header_component__WEBPACK_IMPORTED_MODULE_2__.ModalHeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AccessComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: ["sl-input[_ngcontent-%COMP%], sl-textarea[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: var(--sl-spacing-medium);\n}\nfooter[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n}\n.error[_ngcontent-%COMP%] {\n  color: var(--sl-color-danger-400);\n}\nsl-button[variant='text'][_ngcontent-%COMP%] {\n  margin-left: 0;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vZGVsLWZvcm0uY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7O0VBRUksY0FBQTtFQUNBLHVDQUFBO0FBQ0o7QUFFQTtFQUNJLGFBQUE7RUFDQSw4QkFBQTtFQUNBLG1CQUFBO0FBQUo7QUFHQTtFQUNJLGlDQUFBO0FBREo7QUFJQTtFQUNJLGNBQUE7QUFGSiIsImZpbGUiOiJtb2RlbC1mb3JtLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsic2wtaW5wdXQsXG5zbC10ZXh0YXJlYSB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luLWJvdHRvbTogdmFyKC0tc2wtc3BhY2luZy1tZWRpdW0pO1xufVxuXG5mb290ZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG59XG5cbi5lcnJvciB7XG4gICAgY29sb3I6IHZhcigtLXNsLWNvbG9yLWRhbmdlci00MDApO1xufVxuXG5zbC1idXR0b25bdmFyaWFudD0ndGV4dCddIHtcbiAgICBtYXJnaW4tbGVmdDogMDtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 6596:
/*!**************************************************************************!*\
  !*** ./src/app/modals/source-modal/plugin-list/plugin-list.component.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PluginListComponent": () => (/* binding */ PluginListComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _enums_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../enums/plugin */ 3762);
/* harmony import */ var _source_modal_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../source-modal.service */ 4565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _api_plugin_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../api/plugin-api.service */ 4819);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _components_modal_header_modal_header_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/modal-header/modal-header.component */ 4057);
/* harmony import */ var _pipes_service_info_label__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../pipes/service-info-label */ 6226);











const _c0 = ["slInput"];
function PluginListComponent_sl_radio_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "sl-radio", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](2, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r2 = ctx.$implicit;
    const index_r3 = ctx.index;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", index_r3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](2, 2, item_r2.name), " ");
} }
class PluginListComponent {
    constructor(formService, pluginApiService, sourceModalService) {
        this.formService = formService;
        this.pluginApiService = pluginApiService;
        this.sourceModalService = sourceModalService;
        this.query = {
            type: _enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginType.Source,
        };
        this.loading = false;
        this.FormState = plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormState;
        this.pluginNameControl =
            this.sourceModalService.form.get('plugin_name');
    }
    ngOnInit() {
        this.load();
    }
    search() {
        this.query.search = this.slInput.nativeElement.value;
        this.load();
    }
    deleteValue() {
        this.query.search = '';
        this.slInput.nativeElement.value = '';
        this.load();
    }
    show() {
        this.query.search = '';
        this.slInput.nativeElement.value = '';
    }
    next() {
        if (this.pluginNameControl.invalid) {
            this.formService.showLocalErrors(this.sourceModalService.form);
        }
        else {
            this.sourceModalService.initFormData().subscribe(() => {
                this.sourceModalService.state.next(_source_modal_service__WEBPACK_IMPORTED_MODULE_1__.SourceModalState.ConnectionForm);
            });
        }
    }
    onPluginChange(event) {
        if (this.plugins[event.target.value]) {
            this.sourceModalService.plugin = this.plugins[event.target.value];
            this.pluginNameControl.patchValue(this.plugins[event.target.value].sys_name);
        }
    }
    load() {
        this.loading = true;
        this.pluginApiService.list(this.query).subscribe(({ rows, total }) => {
            this.plugins = rows;
            this.total = total;
            this.loading = false;
        });
    }
}
PluginListComponent.ɵfac = function PluginListComponent_Factory(t) { return new (t || PluginListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_api_plugin_api_service__WEBPACK_IMPORTED_MODULE_2__.PluginApiService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_source_modal_service__WEBPACK_IMPORTED_MODULE_1__.SourceModalService)); };
PluginListComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({ type: PluginListComponent, selectors: [["app-plugin-list"]], viewQuery: function PluginListComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_c0, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.slInput = _t.first);
    } }, decls: 17, vars: 14, consts: [[1, "main-wrap"], [3, "title", "subTitle"], ["clearable", "", 1, "search-source", 3, "placeholder", "sl-input"], ["slInput", ""], ["library", "platform", "name", "search", "slot", "prefix"], [1, "body-wrap"], ["no-fieldset", "", 3, "sl-change"], [3, "value", 4, "ngFor", "ngForOf"], [1, "hidden", 3, "control"], ["variant", "primary", 3, "click"], [3, "value"]], template: function PluginListComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](1, "app-modal-header", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "sl-input", 2, 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-input", function PluginListComponent_Template_sl_input_sl_input_4_listener() { return ctx.search(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](7, "sl-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 5)(9, "sl-radio-group", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-change", function PluginListComponent_Template_sl_radio_group_sl_change_9_listener($event) { return ctx.onPluginChange($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, PluginListComponent_sl_radio_10_Template, 3, 4, "sl-radio", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](12, "sl-input", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](13, "footer")(14, "sl-button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PluginListComponent_Template_sl_button_click_14_listener() { return ctx.next(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](2, 6, "modalSource.source." + ctx.FormState.Create))("subTitle", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](3, 8, "modalSource#sourceType"));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](6, 10, "modalSource#searchPlaceholder"));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngForOf", ctx.plugins);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("control", ctx.pluginNameControl);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](16, 12, "modalSource.nextButton"), " ");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.NgForOf, _components_modal_header_modal_header_component__WEBPACK_IMPORTED_MODULE_3__.ModalHeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.SlControlDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ValidateComponent, _pipes_service_info_label__WEBPACK_IMPORTED_MODULE_4__.ServiceInfoLabelPipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslatePipe], styles: ["sl-input[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-small);\n}\nsl-radio[_ngcontent-%COMP%] {\n  display: block;\n  padding: var(--sl-spacing-small) var(--sl-input-spacing-medium);\n}\nsl-radio[_ngcontent-%COMP%]::part(label) {\n  padding-left: var(--sl-spacing-small);\n  font-size: var(--sl-input-font-size-medium);\n}\nsl-radio-group[_ngcontent-%COMP%] {\n  max-height: 32vh;\n  overflow: auto;\n  margin-bottom: var(--sl-input-spacing-medium);\n}\nfooter[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  margin-top: auto;\n}\n.body-wrap[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1;\n  align-content: space-between;\n}\n.main-wrap[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBsdWdpbi1saXN0LmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksc0NBQUE7QUFDSjtBQUVBO0VBQ0ksY0FBQTtFQUNBLCtEQUFBO0FBQUo7QUFFSTtFQUNJLHFDQUFBO0VBQ0EsMkNBQUE7QUFBUjtBQUlBO0VBQ0ksZ0JBQUE7RUFDQSxjQUFBO0VBQ0EsNkNBQUE7QUFGSjtBQUtBO0VBQ0ksYUFBQTtFQUNBLHlCQUFBO0VBQ0EsZ0JBQUE7QUFISjtBQU1BO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsWUFBQTtFQUNBLDRCQUFBO0FBSko7QUFPQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFlBQUE7QUFMSiIsImZpbGUiOiJwbHVnaW4tbGlzdC5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbInNsLWlucHV0IHtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbn1cblxuc2wtcmFkaW8ge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIHBhZGRpbmc6IHZhcigtLXNsLXNwYWNpbmctc21hbGwpIHZhcigtLXNsLWlucHV0LXNwYWNpbmctbWVkaXVtKTtcblxuICAgICY6OnBhcnQobGFiZWwpIHtcbiAgICAgICAgcGFkZGluZy1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1pbnB1dC1mb250LXNpemUtbWVkaXVtKTtcbiAgICB9XG59XG5cbnNsLXJhZGlvLWdyb3VwIHtcbiAgICBtYXgtaGVpZ2h0OiAzMnZoO1xuICAgIG92ZXJmbG93OiBhdXRvO1xuICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLWlucHV0LXNwYWNpbmctbWVkaXVtKTtcbn1cblxuZm9vdGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZmxleC1lbmQ7XG4gICAgbWFyZ2luLXRvcDogYXV0bztcbn1cblxuLmJvZHktd3JhcCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGZsZXgtZ3JvdzogMTtcbiAgICBhbGlnbi1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ubWFpbi13cmFwIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgaGVpZ2h0OiAxMDAlO1xufVxuIl19 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.Debounce)(300)
], PluginListComponent.prototype, "search", null);


/***/ }),

/***/ 8011:
/*!***************************************************************!*\
  !*** ./src/app/modals/source-modal/source-modal.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SourceModalComponent": () => (/* binding */ SourceModalComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _source_modal_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./source-modal.service */ 4565);
/* harmony import */ var _plugin_list_plugin_list_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin-list/plugin-list.component */ 6596);
/* harmony import */ var _api_source_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../api/source-api.service */ 8916);
/* harmony import */ var _components_modal_header_modal_header_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/modal-header/modal-header.service */ 1053);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _connection_fields_connection_fields_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./connection-fields/connection-fields.component */ 9489);
/* harmony import */ var _model_form_model_form_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./model-form/model-form.component */ 6335);















function SourceModalComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](1, "app-plugin-list");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerEnd"]();
} }
function SourceModalComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](1, "app-connection-fields");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerEnd"]();
} }
function SourceModalComponent_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](1, "app-model-form", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("onComplete", function SourceModalComponent_ng_container_3_Template_app_model_form_onComplete_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r4); const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r3.onComplete()); })("onCancel", function SourceModalComponent_ng_container_3_Template_app_model_form_onCancel_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r4); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r5.isOpen = false); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("source", ctx_r2.source);
} }
class SourceModalComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_7__.SubscribableComponent {
    constructor(sourceModalService, sourceApiService, responseErrorService, modalHeaderService) {
        super();
        this.sourceModalService = sourceModalService;
        this.sourceApiService = sourceApiService;
        this.responseErrorService = responseErrorService;
        this.modalHeaderService = modalHeaderService;
        this.SourceModalState = _source_modal_service__WEBPACK_IMPORTED_MODULE_0__.SourceModalState;
        this.onSaved = new _angular_core__WEBPACK_IMPORTED_MODULE_6__.EventEmitter();
        this.isOpen = false;
    }
    ngOnInit() {
        this.subscriptions = [
            this.modalHeaderService.eventClose.subscribe(({ isOpen }) => {
                this.isOpen = isOpen;
            }),
        ];
    }
    show(source) {
        var _a;
        this.subscriptions = [
            this.sourceModalService.state.subscribe((state) => {
                this.state = state;
            }),
        ];
        if (source) {
            this.sourceApiService.get(source.id).subscribe({
                next: ({ row: data }) => {
                    this.isOpen = true;
                    this.state = _source_modal_service__WEBPACK_IMPORTED_MODULE_0__.SourceModalState.ModelForm;
                    this.source = data;
                    this.sourceModalService.form.patchValue(source);
                    this.sourceModalService
                        .initFormData()
                        .subscribe((response) => {
                        if (response === null || response === void 0 ? void 0 : response.fields) {
                            this.sourceModalService.setFieldsValues(response === null || response === void 0 ? void 0 : response.fields);
                        }
                    });
                },
                error: (response) => {
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: `modalSource.notification.${plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.FormState.Update}.danger`,
                    });
                },
            });
        }
        else {
            this.isOpen = true;
            this.sourceModalService.clearForm();
            (_a = this.pluginListComponent) === null || _a === void 0 ? void 0 : _a.deleteValue();
            this.source = this.sourceModalService.form.value;
            this.source.access_right = plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AccessRight.Full;
            this.state = _source_modal_service__WEBPACK_IMPORTED_MODULE_0__.SourceModalState.PluginList;
        }
    }
    onComplete() {
        this.isOpen = false;
        this.onSaved.emit();
    }
}
SourceModalComponent.ɵfac = function SourceModalComponent_Factory(t) { return new (t || SourceModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_source_modal_service__WEBPACK_IMPORTED_MODULE_0__.SourceModalService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_api_source_api_service__WEBPACK_IMPORTED_MODULE_2__.SourceApiService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_components_modal_header_modal_header_service__WEBPACK_IMPORTED_MODULE_3__.ModalHeaderService)); };
SourceModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineComponent"]({ type: SourceModalComponent, selectors: [["app-source-modal"]], viewQuery: function SourceModalComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵviewQuery"](_plugin_list_plugin_list_component__WEBPACK_IMPORTED_MODULE_1__.PluginListComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵloadQuery"]()) && (ctx.pluginListComponent = _t.first);
    } }, outputs: { onSaved: "onSaved" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵInheritDefinitionFeature"]], decls: 4, vars: 6, consts: [["no-header", "", 3, "open", "openChange"], [4, "ngIf"], [3, "source", "onComplete", "onCancel"]], template: function SourceModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("openChange", function SourceModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](1, SourceModalComponent_ng_container_1_Template, 2, 0, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](2, SourceModalComponent_ng_container_2_Template, 2, 0, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](3, SourceModalComponent_ng_container_3_Template, 2, 1, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("list", ctx.state === ctx.SourceModalState.PluginList);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx.state === ctx.SourceModalState.PluginList);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx.state === ctx.SourceModalState.ConnectionForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx.state === ctx.SourceModalState.ModelForm);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_10__.OpenDirective, _connection_fields_connection_fields_component__WEBPACK_IMPORTED_MODULE_4__.ConnectionFieldsComponent, _model_form_model_form_component__WEBPACK_IMPORTED_MODULE_5__.ModelFormComponent, _plugin_list_plugin_list_component__WEBPACK_IMPORTED_MODULE_1__.PluginListComponent], styles: ["sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  min-height: 400px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNvdXJjZS1tb2RhbC5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGlCQUFBO0FBQ0oiLCJmaWxlIjoic291cmNlLW1vZGFsLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsic2wtZGlhbG9nOjpwYXJ0KHBhbmVsKSB7XG4gICAgbWluLWhlaWdodDogNDAwcHg7XG59XG4iXX0= */"] });


/***/ }),

/***/ 2823:
/*!************************************************************!*\
  !*** ./src/app/modals/source-modal/source-modal.module.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SourceModalModule": () => (/* binding */ SourceModalModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _source_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./source-modal.component */ 8011);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _pipes_service_info_label__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../pipes/service-info-label */ 6226);
/* harmony import */ var _components_input_material_input_material_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/input-material/input-material.module */ 5068);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _components_modal_header_modal_header_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/modal-header/modal-header.module */ 9843);
/* harmony import */ var _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/modal-actions/modal-actions.module */ 4108);
/* harmony import */ var _connection_fields_connection_fields_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./connection-fields/connection-fields.component */ 9489);
/* harmony import */ var _model_form_model_form_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./model-form/model-form.component */ 6335);
/* harmony import */ var _plugin_list_plugin_list_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./plugin-list/plugin-list.component */ 6596);
/* harmony import */ var _components_plugin_field_plugin_field_module__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/plugin-field/plugin-field.module */ 387);
/* harmony import */ var _source_modal_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./source-modal.service */ 4565);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 3184);














class SourceModalModule {
}
SourceModalModule.ɵfac = function SourceModalModule_Factory(t) { return new (t || SourceModalModule)(); };
SourceModalModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineNgModule"]({ type: SourceModalModule });
SourceModalModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineInjector"]({ providers: [_source_modal_service__WEBPACK_IMPORTED_MODULE_9__.SourceModalService, plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.UsernamePipe], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_13__.ShoelaceModule,
        _pipes_service_info_label__WEBPACK_IMPORTED_MODULE_1__.ServiceInfoLabelPipeModule,
        _components_input_material_input_material_module__WEBPACK_IMPORTED_MODULE_2__.InputMaterialModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.TableModule,
        _components_modal_header_modal_header_module__WEBPACK_IMPORTED_MODULE_3__.ModalHeaderModule,
        _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_4__.ModalActionsModule,
        _components_plugin_field_plugin_field_module__WEBPACK_IMPORTED_MODULE_8__.PluginFieldModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.UsernamePipeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.FormModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵsetNgModuleScope"](SourceModalModule, { declarations: [_source_modal_component__WEBPACK_IMPORTED_MODULE_0__.SourceModalComponent,
        _connection_fields_connection_fields_component__WEBPACK_IMPORTED_MODULE_5__.ConnectionFieldsComponent,
        _model_form_model_form_component__WEBPACK_IMPORTED_MODULE_6__.ModelFormComponent,
        _plugin_list_plugin_list_component__WEBPACK_IMPORTED_MODULE_7__.PluginListComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_13__.ShoelaceModule,
        _pipes_service_info_label__WEBPACK_IMPORTED_MODULE_1__.ServiceInfoLabelPipeModule,
        _components_input_material_input_material_module__WEBPACK_IMPORTED_MODULE_2__.InputMaterialModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.TableModule,
        _components_modal_header_modal_header_module__WEBPACK_IMPORTED_MODULE_3__.ModalHeaderModule,
        _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_4__.ModalActionsModule,
        _components_plugin_field_plugin_field_module__WEBPACK_IMPORTED_MODULE_8__.PluginFieldModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.UsernamePipeModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_11__.FormModule], exports: [_source_modal_component__WEBPACK_IMPORTED_MODULE_0__.SourceModalComponent] }); })();


/***/ }),

/***/ 4565:
/*!*************************************************************!*\
  !*** ./src/app/modals/source-modal/source-modal.service.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SourceModalService": () => (/* binding */ SourceModalService),
/* harmony export */   "SourceModalState": () => (/* binding */ SourceModalState)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 6317);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 9337);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs */ 2673);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 745);
/* harmony import */ var src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/enums/plugin */ 3762);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var src_app_api_plugin_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/api/plugin-api.service */ 4819);
/* harmony import */ var src_app_api_source_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/api/source-api.service */ 8916);








var SourceModalState;
(function (SourceModalState) {
    SourceModalState[SourceModalState["PluginList"] = 0] = "PluginList";
    SourceModalState[SourceModalState["ConnectionForm"] = 1] = "ConnectionForm";
    SourceModalState[SourceModalState["ModelForm"] = 2] = "ModelForm";
})(SourceModalState || (SourceModalState = {}));
class SourceModalService {
    constructor(formService, pluginApiService, sourceApiService) {
        this.formService = formService;
        this.pluginApiService = pluginApiService;
        this.sourceApiService = sourceApiService;
        this.myValidator = (control) => {
            return control.value
                ? null
                : {
                    'modalSource#chooseValue': null,
                };
        };
        this.form = this.formService.form({
            id: [],
            name: ['', [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.stringValidator)({ max: 250, min: 1 })]],
            comment: [null, [(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.stringValidator)({ max: 250 })]],
            users: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__.FormArray([]),
            groups: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__.FormArray([]),
            fields: new _angular_forms__WEBPACK_IMPORTED_MODULE_4__.FormArray([]),
            plugin_name: ['', [this.myValidator]],
        });
        this.state = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject(SourceModalState.PluginList);
        this.fieldsControls = this.form.controls['fields'];
    }
    clearForm() {
        const controls = this.form.controls;
        controls.users.clear();
        controls.groups.clear();
        controls.fields.clear();
        this.form.reset();
    }
    initFormData() {
        return this.pluginApiService.get(this.form.value.plugin_name).pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_6__.tap)(({ row }) => {
            this.plugin = row;
        }), (0,rxjs__WEBPACK_IMPORTED_MODULE_7__.switchMap)(() => {
            return this.initFieldsForm();
        }));
    }
    loadFields() {
        return this.sourceApiService.getConectionFields(this.form.value.id);
    }
    initFieldsForm() {
        var _a, _b;
        this.fieldsControls.clear();
        (_b = (_a = this.plugin) === null || _a === void 0 ? void 0 : _a.connect_fields) === null || _b === void 0 ? void 0 : _b.forEach((item) => {
            const validators = [];
            if (item.keep_secure && this.form.value.id) {
            }
            else {
                if (item.validation) {
                    item.validation.forEach((config) => {
                        switch (config.type) {
                            case 'required':
                                validators.push(plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required);
                                break;
                            default:
                                break;
                        }
                    });
                }
            }
            const formItem = this.formService.form({
                id: [],
                name: [item.name],
                value: [this.getItemValue(item), validators],
            });
            this.fieldsControls.push(formItem);
        });
        if (this.form.value.id) {
            return this.loadFields();
        }
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.of)(null);
    }
    setFieldsValues(fields) {
        this.fieldsControls.controls.forEach((control) => {
            const fieldName = control.value.name;
            const foundField = fields.find((field) => field.name === fieldName);
            if (foundField) {
                control.patchValue(foundField);
            }
        });
    }
    getItemValue(item) {
        return item.type === src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFieldTypeEnum.stringFormat
            ? item === null || item === void 0 ? void 0 : item.value
            : null;
    }
}
SourceModalService.ɵfac = function SourceModalService_Factory(t) { return new (t || SourceModalService)(_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵinject"](src_app_api_plugin_api_service__WEBPACK_IMPORTED_MODULE_1__.PluginApiService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵinject"](src_app_api_source_api_service__WEBPACK_IMPORTED_MODULE_2__.SourceApiService)); };
SourceModalService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdefineInjectable"]({ token: SourceModalService, factory: SourceModalService.ɵfac });


/***/ }),

/***/ 3689:
/*!************************************************************!*\
  !*** ./src/app/pages/source-list/source-list.component.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SourceListComponent": () => (/* binding */ SourceListComponent)
/* harmony export */ });
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_module_rights__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../enums/module-rights */ 4475);
/* harmony import */ var _enums_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../enums/state */ 3755);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _api_source_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../api/source-api.service */ 8916);
/* harmony import */ var _services_page_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/page.service */ 9450);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../modals/confirm/confirm.component */ 8268);
/* harmony import */ var _modals_source_modal_source_modal_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../modals/source-modal/source-modal.component */ 8011);












function SourceListComponent_core_header_0_sl_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "sl-button", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function SourceListComponent_core_header_0_sl_button_2_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r12); const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](8); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](_r5.show(ctx_r11.checkRows)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate2"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](2, 2, "$.delete"), " ", ctx_r9.checkRows.length, " ");
} }
function SourceListComponent_core_header_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainer"](0);
} }
function SourceListComponent_core_header_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "core-header", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](2, SourceListComponent_core_header_0_sl_button_2_Template, 3, 4, "sl-button", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](3, SourceListComponent_core_header_0_ng_container_3_Template, 1, 0, "ng-container", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]();
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](1, 4, "title"));
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("counter", ctx_r0.sourceTotal);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx_r0.checkRows.length);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngTemplateOutlet", _r7);
} }
function SourceListComponent_core_empty_state_1_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainer"](0);
} }
function SourceListComponent_core_empty_state_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "core-empty-state", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](1, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](3, SourceListComponent_core_empty_state_1_ng_container_3_Template, 1, 0, "ng-container", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]();
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](1, 3, "noSourceList"));
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpropertyInterpolate"]("description", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](2, 5, "noSourceListDescription"));
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngTemplateOutlet", _r7);
} }
function SourceListComponent_core_table_2_tr_32_core_table_checkbox_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](0, "core-table-checkbox", 34);
} if (rf & 2) {
    const source_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("value", source_r15);
} }
function SourceListComponent_core_table_2_tr_32_core_action_17_Template(rf, ctx) { if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "core-action", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function SourceListComponent_core_table_2_tr_32_core_action_17_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r22); const source_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](4); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](_r3.show(source_r15)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} }
function SourceListComponent_core_table_2_tr_32_core_action_18_Template(rf, ctx) { if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "core-action", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function SourceListComponent_core_table_2_tr_32_core_action_18_Template_core_action_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r25); const source_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]().$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](6); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](_r4.show(source_r15)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} }
function SourceListComponent_core_table_2_tr_32_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "tr")(1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](2, SourceListComponent_core_table_2_tr_32_core_table_checkbox_2_Template, 1, 1, "core-table-checkbox", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](3, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](5, "td", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](7, "td", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](9, "td", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](11, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](12, "td", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](13, "core-relative-time", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](14, "td", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](15, "core-relative-time", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](16, "td", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](17, SourceListComponent_core_table_2_tr_32_core_action_17_Template, 1, 0, "core-action", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](18, SourceListComponent_core_table_2_tr_32_core_action_18_Template, 1, 0, "core-action", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const source_r15 = ctx.$implicit;
    const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("hidden", ctx_r14.isHideCheckboxController());
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", source_r15.access_right === ctx_r14.AccessRight.Full);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate"](source_r15.plugin_name);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate"](source_r15.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate"](source_r15.comment);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](11, 13, source_r15.owner));
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("date", source_r15.create_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("date", source_r15.update_date);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("hidden", ctx_r14.isShowActions());
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", source_r15.access_right !== ctx_r14.AccessRight.Read);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx_r14.hasDeleteButton(source_r15));
} }
function SourceListComponent_core_table_2_Template(rf, ctx) { if (rf & 1) {
    const _r27 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "core-table", 18)(1, "thead")(2, "tr")(3, "th")(4, "core-table-checkbox-controller", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("change", function SourceListComponent_core_table_2_Template_core_table_checkbox_controller_change_4_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r27); const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r26.checkRows = $event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](5, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](8, "core-table-sort", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](9, "th", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](12, "core-table-sort", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](13, "th", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](15, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](16, "th", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](18, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](19, "core-table-sort", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](20, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](23, "core-table-sort", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](24, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](25);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](26, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](27, "core-table-sort", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](28, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](29);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](30, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](31, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](32, SourceListComponent_core_table_2_tr_32_Template, 19, 15, "tr", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("loading", ctx_r2.loadingState === ctx_r2.ELoadingState.Wait)("total", ctx_r2.sourceTotal);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("hidden", ctx_r2.isHideCheckboxController());
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](7, 14, "type"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](11, 16, "$.name"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](15, 18, "description"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](18, 20, "owner"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](22, 22, "$.createDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](26, 24, "$.updateDate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("hidden", ctx_r2.isShowActions());
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](30, 26, "$.actions"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngForOf", ctx_r2.rows);
} }
function SourceListComponent_p_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r28 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate"](item_r28.name);
} }
function SourceListComponent_ng_template_10_sl_button_0_sl_icon_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](0, "sl-icon", 40);
} }
function SourceListComponent_ng_template_10_sl_button_0_Template(rf, ctx) { if (rf & 1) {
    const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "sl-button", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function SourceListComponent_ng_template_10_sl_button_0_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r32); _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](4); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](_r3.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](3, SourceListComponent_ng_template_10_sl_button_0_sl_icon_3_Template, 1, 0, "sl-icon", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](2, 2, "addSource"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx_r29.rows.length);
} }
function SourceListComponent_ng_template_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](0, SourceListComponent_ng_template_10_sl_button_0_Template, 4, 4, "sl-button", 37);
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("accessRights", ctx_r8.ModuleRights.DatasourceFullAccess);
} }
class SourceListComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_7__.SubscribableComponent {
    constructor(sourceApiService, pageService, activatedRoute, notifyService, responseErrorService, appService) {
        super();
        this.sourceApiService = sourceApiService;
        this.pageService = pageService;
        this.activatedRoute = activatedRoute;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.appService = appService;
        this.ELoadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState;
        this.ModuleRights = _enums_module_rights__WEBPACK_IMPORTED_MODULE_0__.ModuleRights;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AccessRight;
        this.rows = [];
        this.checkRows = [];
        this.sourceTotal = 0;
        this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState.Default;
    }
    get user() {
        return this.appService.user.value;
    }
    ngOnInit() {
        this.pageService.isLoading.next(true);
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe(() => {
                this.load();
            }),
        ];
    }
    load() {
        this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState.Wait;
        this.sourceApiService
            .list(this.activatedRoute.snapshot.queryParams)
            .subscribe({
            next: ({ rows, total }) => {
                this.rows = rows;
                this.sourceTotal = total;
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState.Success;
                this.pageService.isLoading.next(false);
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'sourceListDanger',
                });
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState.Reject;
                this.pageService.isLoading.next(false);
            },
        });
    }
    delete(row) {
        this.sourceApiService.deleteSource(row.id).subscribe({
            next: () => {
                this.load();
                this.notifyService.toastByName('deleteSource');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'sourceDeletedDanger',
                });
            },
        });
    }
    deleteChecked(rows) {
        this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState.Wait;
        this.sourceApiService
            .deleteList(rows.map((item) => item.id))
            .subscribe({
            next: () => {
                this.checkRows = [];
                this.load();
                this.notifyService.toastByName(rows.length === 1 ? 'deleteSource' : 'deleteSources');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: rows.length === 1
                        ? 'sourceDeletedDanger'
                        : 'sourcesDeletedDanger',
                });
                this.loadingState = _enums_state__WEBPACK_IMPORTED_MODULE_1__.ELoadingState.Reject;
            },
        });
    }
    isHideCheckboxController() {
        return this.rows.every((source) => source.access_right !== plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AccessRight.Full);
    }
    isShowActions() {
        return !this.rows.some((source) => source.access_right !== plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AccessRight.Read);
    }
    hasDeleteButton(source) {
        return (source.access_right === plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AccessRight.Full ||
            source.owner.id === this.user.id);
    }
}
SourceListComponent.ɵfac = function SourceListComponent_Factory(t) { return new (t || SourceListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_api_source_api_service__WEBPACK_IMPORTED_MODULE_2__.SourceApiService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_services_page_service__WEBPACK_IMPORTED_MODULE_3__.PageService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AppService)); };
SourceListComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineComponent"]({ type: SourceListComponent, selectors: [["app-source-list"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵInheritDefinitionFeature"]], decls: 18, vars: 10, consts: [[3, "title", "counter", 4, "ngIf"], ["imageSrc", "/assets/images/data-default.svg", 3, "title", "description", 4, "ngIf"], [3, "loading", "total", 4, "ngIf"], [3, "onSaved"], ["sourceModalComponent", ""], ["title", "deleteSource", "description", "deleteSourceDescription", 3, "onOk"], ["deleteConfirm", ""], ["title", "deleteSources", 3, "onOk"], ["deleteCheckedConfirm", ""], [4, "ngFor", "ngForOf"], ["addButton", ""], ["name", "deleteSource"], ["name", "deleteSources"], [3, "title", "counter"], ["variant", "danger", 3, "click", 4, "ngIf"], [4, "ngTemplateOutlet"], ["variant", "danger", 3, "click"], ["imageSrc", "/assets/images/data-default.svg", 3, "title", "description"], [3, "loading", "total"], [3, "change"], ["routing", "", "by", "plugin_name"], ["width", "15vw"], ["routing", "", "by", "name"], ["routing", "", "by", "author"], ["routing", "", "by", "create_date"], ["routing", "", "by", "update_date"], [3, "value", 4, "ngIf"], [1, "type"], ["maxWidth", "15vw"], [1, "date"], [3, "date"], [1, "actions"], ["type", "setup", 3, "click", 4, "ngIf"], ["type", "delete", 3, "click", 4, "ngIf"], [3, "value"], ["type", "setup", 3, "click"], ["type", "delete", 3, "click"], ["variant", "primary", 3, "click", 4, "accessRights"], ["variant", "primary", 3, "click"], ["name", "plus", "slot", "suffix", 4, "ngIf"], ["name", "plus", "slot", "suffix"]], template: function SourceListComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](0, SourceListComponent_core_header_0_Template, 4, 6, "core-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](1, SourceListComponent_core_empty_state_1_Template, 4, 7, "core-empty-state", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](2, SourceListComponent_core_table_2_Template, 33, 28, "core-table", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](3, "app-source-modal", 3, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("onSaved", function SourceListComponent_Template_app_source_modal_onSaved_3_listener() { return ctx.load(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](5, "app-confirm", 5, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("onOk", function SourceListComponent_Template_app_confirm_onOk_5_listener($event) { return ctx.delete($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](7, "app-confirm", 7, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("onOk", function SourceListComponent_Template_app_confirm_onOk_7_listener($event) { return ctx.deleteChecked($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](9, SourceListComponent_p_9_Template, 2, 1, "p", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](10, SourceListComponent_ng_template_10_Template, 1, 1, "ng-template", null, 10, _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](12, "core-notify", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](15, "core-notify", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx.sourceTotal);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", !ctx.rows.length && ctx.loadingState !== ctx.ELoadingState.Wait);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx.sourceTotal);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngForOf", ctx.checkRows);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](14, 6, "sourceDeleted"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](17, 8, "sourcesDeleted"), "\n");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.AccessRightsDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.ActionComponent, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgTemplateOutlet, _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_4__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.EmptyStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.HeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.RelativeTimeComponent, _modals_source_modal_source_modal_component__WEBPACK_IMPORTED_MODULE_5__.SourceModalComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TableCheckboxComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TableCheckboxControllerComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TableSortRoutingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.WidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.UsernamePipe], styles: ["core-header[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-medium);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNvdXJjZS1saXN0LmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0kscUNBQUE7QUFDSiIsImZpbGUiOiJzb3VyY2UtbGlzdC5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbImNvcmUtaGVhZGVyIHNsLWJ1dHRvbiB7XG4gICAgbWFyZ2luLWxlZnQ6IHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKTtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 807:
/*!*********************************************************!*\
  !*** ./src/app/pages/source-list/source-list.module.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SourceListModule": () => (/* binding */ SourceListModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_module_rights__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../enums/module-rights */ 4475);
/* harmony import */ var _modals_confirm_confirm_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../modals/confirm/confirm.module */ 5254);
/* harmony import */ var _modals_source_modal_source_modal_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../modals/source-modal/source-modal.module */ 2823);
/* harmony import */ var _source_list_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./source-list.component */ 3689);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);










class SourceListModule {
}
SourceListModule.ɵfac = function SourceListModule_Factory(t) { return new (t || SourceListModule)(); };
SourceListModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineNgModule"]({ type: SourceListModule });
SourceListModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.providePageTranslations)({
            sources: [
                'assets/i18n/sources/',
                'assets/i18n/modals/source-modal/',
                'assets/i18n/components/model-form/',
            ],
        }),
    ], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AccessRightsDirectiveModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ActionModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule,
        _modals_confirm_confirm_module__WEBPACK_IMPORTED_MODULE_1__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.RelativeTimeModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_7__.RouterModule.forChild([
            {
                path: '',
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PageTranslationsGuard, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AccessRightsGuard],
                data: (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.routeDate)({
                    accessRights: {
                        rights: [
                            _enums_module_rights__WEBPACK_IMPORTED_MODULE_0__.ModuleRights.DatasourceView,
                            _enums_module_rights__WEBPACK_IMPORTED_MODULE_0__.ModuleRights.DatasourceFullAccess,
                        ],
                    },
                }),
                component: _source_list_component__WEBPACK_IMPORTED_MODULE_3__.SourceListComponent,
            },
        ]),
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule,
        _modals_source_modal_source_modal_module__WEBPACK_IMPORTED_MODULE_2__.SourceModalModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UsernamePipeModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵsetNgModuleScope"](SourceListModule, { declarations: [_source_list_component__WEBPACK_IMPORTED_MODULE_3__.SourceListComponent], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AccessRightsDirectiveModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ActionModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule,
        _modals_confirm_confirm_module__WEBPACK_IMPORTED_MODULE_1__.ConfirmModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.EmptyStateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.RelativeTimeModule, _angular_router__WEBPACK_IMPORTED_MODULE_7__.RouterModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule,
        _modals_source_modal_source_modal_module__WEBPACK_IMPORTED_MODULE_2__.SourceModalModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.UsernamePipeModule] }); })();


/***/ })

}]);
//# sourceMappingURL=src_app_pages_source-list_source-list_module_ts.js.map