"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_api_project-api_service_ts-src_app_api_theme-api_service_ts-src_app_interfaces_projec-417bfe"],{

/***/ 37444:
/*!********************************************!*\
  !*** ./src/app/api/project-api.service.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectApiService": () => (/* binding */ ProjectApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);



class ProjectApiService {
    constructor(restService, coreRestService) {
        this.restService = restService;
        this.coreRestService = coreRestService;
    }
    get(id) {
        return this.restService.get(`/project/${id}`);
    }
    list(query) {
        return this.restService.get('/project', query);
    }
    save(project) {
        if (project.id) {
            return this.restService.put(`/project/${project.id}`, project);
        }
        else {
            return this.restService.post('/project', project);
        }
    }
    delete(id) {
        return this.restService.delete(`/project`, { ids: id });
    }
    deleteList(ids) {
        return this.restService.delete(`/project`, {
            ids,
        });
    }
    copy(id) {
        return this.restService.post(`/project/${id}/copy`);
    }
    getAnalyticsRedirect(url) {
        return this.coreRestService.get(url);
    }
}
ProjectApiService.ɵfac = function ProjectApiService_Factory(t) { return new (t || ProjectApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.CoreApi)); };
ProjectApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ProjectApiService, factory: ProjectApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 13745:
/*!******************************************!*\
  !*** ./src/app/api/theme-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeApiService": () => (/* binding */ ThemeApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class ThemeApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(id) {
        return this.restService.get(`/theme/${id}`);
    }
    list(params) {
        return this.restService.get('/theme', params);
    }
    save(theme) {
        if (theme.id) {
            return this.restService.put(`/theme/${theme.id}`, theme);
        }
        else {
            return this.restService.post('/theme', theme);
        }
    }
    deleteList(ids) {
        return this.restService.delete(`/theme`, { ids });
    }
}
ThemeApiService.ɵfac = function ThemeApiService_Factory(t) { return new (t || ThemeApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ThemeApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ThemeApiService, factory: ThemeApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 16847:
/*!***************************************!*\
  !*** ./src/app/interfaces/project.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DashboardPostMessageEvent": () => (/* binding */ DashboardPostMessageEvent),
/* harmony export */   "ProjectIcon": () => (/* binding */ ProjectIcon),
/* harmony export */   "ThemeColor": () => (/* binding */ ThemeColor)
/* harmony export */ });
var DashboardPostMessageEvent;
(function (DashboardPostMessageEvent) {
    DashboardPostMessageEvent["Interact"] = "interact";
    DashboardPostMessageEvent["GoTo"] = "goTo";
    DashboardPostMessageEvent["TriggerValue"] = "triggerValue";
    DashboardPostMessageEvent["SetFilter"] = "setFilter";
    DashboardPostMessageEvent["Resize"] = "resize";
    DashboardPostMessageEvent["ChangeFilter"] = "changeFilter";
    DashboardPostMessageEvent["ChangeProjectState"] = "changeProjectState";
})(DashboardPostMessageEvent || (DashboardPostMessageEvent = {}));
var ThemeColor;
(function (ThemeColor) {
    ThemeColor["Polymatica"] = "polymatica";
    ThemeColor["C1"] = "c1";
    ThemeColor["C2"] = "c2";
    ThemeColor["Grey"] = "grey";
    ThemeColor["Green"] = "green";
    ThemeColor["Pink"] = "pink";
    ThemeColor["Blue"] = "blue";
    ThemeColor["Yellow"] = "yellow";
    ThemeColor["Red"] = "red";
    ThemeColor["Mixed"] = "mixed";
    ThemeColor["Circus"] = "circus";
    ThemeColor["Custom1"] = "custom1";
})(ThemeColor || (ThemeColor = {}));
var ProjectIcon;
(function (ProjectIcon) {
    ProjectIcon["Antique"] = "antique";
    ProjectIcon["Atom"] = "atom";
    ProjectIcon["Box"] = "box";
    ProjectIcon["Briefcase"] = "briefcase";
    ProjectIcon["ChartDonut"] = "chart-donut";
    ProjectIcon["Chip"] = "chip";
    ProjectIcon["Clock"] = "clock";
    ProjectIcon["Construction"] = "construction";
    ProjectIcon["CubeEdges"] = "cube-edges";
    ProjectIcon["Cube"] = "cube";
    ProjectIcon["Document"] = "document";
    ProjectIcon["Factory"] = "factory";
    ProjectIcon["Figure3d"] = "figure-3d";
    ProjectIcon["Flag"] = "flag";
    ProjectIcon["GroceryTrolley"] = "grocery-trolley";
    ProjectIcon["Lab"] = "lab";
    ProjectIcon["Lifebuoy"] = "lifebuoy";
    ProjectIcon["Lightning"] = "lightning";
    ProjectIcon["Moneybag"] = "moneybag";
    ProjectIcon["Moon"] = "moon";
    ProjectIcon["Plane"] = "plane";
    ProjectIcon["Planet"] = "planet";
    ProjectIcon["Plus"] = "plus";
    ProjectIcon["Pumpjack"] = "pumpjack";
    ProjectIcon["Truck"] = "truck";
})(ProjectIcon || (ProjectIcon = {}));


/***/ }),

/***/ 97089:
/*!******************************************************!*\
  !*** ./src/app/pages/export-widget/export.module.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExportModule": () => (/* binding */ ExportModule)
/* harmony export */ });
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/router */ 78298);
/* harmony import */ var devextreme_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! devextreme-angular */ 49966);
/* harmony import */ var devextreme_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! devextreme-angular */ 90113);
/* harmony import */ var _export_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./export.component */ 14179);
/* harmony import */ var _components_export_table_export_table_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/export-table/export-table.component */ 17592);
/* harmony import */ var project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/components/widget/widget.module */ 42975);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var project_components_html_renderer_html_renderer_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! project/components/html-renderer/html-renderer.module */ 11064);
/* harmony import */ var angular_gridster2__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! angular-gridster2 */ 39950);
/* harmony import */ var project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! project/components/dashboard/dashboard.module */ 75649);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var plmt_core_library_filter_template__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! plmt-core-library/filter-template */ 55255);
/* harmony import */ var _components_export_pivot_export_pivot_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/export-pivot/export-pivot.component */ 63751);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 64565);














class ExportModule {
}
ExportModule.ɵfac = function ExportModule_Factory(t) { return new (t || ExportModule)(); };
ExportModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineNgModule"]({ type: ExportModule });
ExportModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.providePageTranslations)({
            sources: [
                'assets/i18n/',
                'assets/i18n/projects/',
                'assets/i18n/project/',
                'assets/i18n/components/chart-filter/',
                'assets/i18n/components/filter-list/',
                'assets/i18n/components/modal-video/',
                'assets/i18n/components/embed-video/',
                'assets/i18n/components/modal-analytics-scenario/',
                'assets/i18n/components/dashboard/',
                'assets/i18n/components/modal-link/',
                'assets/i18n/components/modal-group/',
                'assets/i18n/components/modal-text/',
                'assets/i18n/components/modal-filter/',
                'assets/i18n/components/widget-setup/',
                'assets/aggregation-setup/i18n/',
                'assets/i18n/widgets/',
                'assets/i18n/components/datasets-last-update/',
                'assets/i18n/components/widget/',
                'assets/core-library/i18n/',
                'assets/core-library/i18n/filters/',
                'assets/core-library/i18n/filter-template/',
            ],
            keyInterpolation: {
                ...plmt_core_library_filter_template__WEBPACK_IMPORTED_MODULE_8__.filterTemplateInterpolationKeys,
            },
        }),
    ], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule,
        angular_gridster2__WEBPACK_IMPORTED_MODULE_10__.GridsterModule,
        project_components_html_renderer_html_renderer_module__WEBPACK_IMPORTED_MODULE_3__.HtmlRendererModule,
        project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_4__.DashboardModule,
        devextreme_angular__WEBPACK_IMPORTED_MODULE_11__.DxDataGridModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_12__.RouterModule.forChild([
            {
                path: '',
                component: _export_component__WEBPACK_IMPORTED_MODULE_0__.ExportComponent,
            },
        ]),
        project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_2__.WidgetModule,
        devextreme_angular__WEBPACK_IMPORTED_MODULE_13__.DxPivotGridModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵsetNgModuleScope"](ExportModule, { declarations: [_export_component__WEBPACK_IMPORTED_MODULE_0__.ExportComponent, _components_export_table_export_table_component__WEBPACK_IMPORTED_MODULE_1__.ExportTableComponent, _components_export_pivot_export_pivot_component__WEBPACK_IMPORTED_MODULE_5__.ExportPivotComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule,
        angular_gridster2__WEBPACK_IMPORTED_MODULE_10__.GridsterModule,
        project_components_html_renderer_html_renderer_module__WEBPACK_IMPORTED_MODULE_3__.HtmlRendererModule,
        project_components_dashboard_dashboard_module__WEBPACK_IMPORTED_MODULE_4__.DashboardModule,
        devextreme_angular__WEBPACK_IMPORTED_MODULE_11__.DxDataGridModule, _angular_router__WEBPACK_IMPORTED_MODULE_12__.RouterModule, project_components_widget_widget_module__WEBPACK_IMPORTED_MODULE_2__.WidgetModule,
        devextreme_angular__WEBPACK_IMPORTED_MODULE_13__.DxPivotGridModule] }); })();


/***/ })

}]);
//# sourceMappingURL=src_app_api_project-api_service_ts-src_app_api_theme-api_service_ts-src_app_interfaces_projec-417bfe.js.map