"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["default-src_app_components_project-modal_project-modal_module_ts"],{

/***/ 37444:
/*!********************************************!*\
  !*** ./src/app/api/project-api.service.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectApiService": () => (/* binding */ ProjectApiService)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);



class ProjectApiService {
    constructor(restService, coreRestService) {
        this.restService = restService;
        this.coreRestService = coreRestService;
    }
    get(id) {
        return this.restService.get(`/project/${id}`);
    }
    list(query) {
        return this.restService.get('/project', query);
    }
    save(project) {
        if (project.id) {
            return this.restService.put(`/project/${project.id}`, project);
        }
        else {
            return this.restService.post('/project', project);
        }
    }
    delete(id) {
        return this.restService.delete(`/project`, { ids: id });
    }
    deleteList(ids) {
        return this.restService.delete(`/project`, {
            ids,
        });
    }
    copy(id) {
        return this.restService.post(`/project/${id}/copy`);
    }
    getAnalyticsRedirect(url) {
        return this.coreRestService.get(url);
    }
}
ProjectApiService.ɵfac = function ProjectApiService_Factory(t) { return new (t || ProjectApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.CoreApi)); };
ProjectApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ProjectApiService, factory: ProjectApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 13745:
/*!******************************************!*\
  !*** ./src/app/api/theme-api.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeApiService": () => (/* binding */ ThemeApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 92299);


class ThemeApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(id) {
        return this.restService.get(`/theme/${id}`);
    }
    list(params) {
        return this.restService.get('/theme', params);
    }
    save(theme) {
        if (theme.id) {
            return this.restService.put(`/theme/${theme.id}`, theme);
        }
        else {
            return this.restService.post('/theme', theme);
        }
    }
    deleteList(ids) {
        return this.restService.delete(`/theme`, { ids });
    }
}
ThemeApiService.ɵfac = function ThemeApiService_Factory(t) { return new (t || ThemeApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ThemeApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ThemeApiService, factory: ThemeApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 97654:
/*!*********************************************************************!*\
  !*** ./src/app/components/project-modal/project-modal.component.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectModalComponent": () => (/* binding */ ProjectModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 3786);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 64565);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 48665);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ng-onpush */ 97318);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var project_interfaces_project__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/interfaces/project */ 16847);
/* harmony import */ var project_api_project_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! project/api/project-api.service */ 37444);
/* harmony import */ var project_api_theme_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! project/api/theme-api.service */ 13745);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! shoelace-style-angular */ 39652);












function ProjectModalComponent_ng_container_11_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainer"](0);
} }
const _c0 = function (a0) { return { $implicit: a0 }; };
function ProjectModalComponent_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, ProjectModalComponent_ng_container_11_ng_container_1_Template, 1, 0, "ng-container", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](52);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngTemplateOutlet", _r11)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](2, _c0, ctx_r1.getSelectedTheme()));
} }
function ProjectModalComponent_ng_template_12_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainer"](0);
} }
function ProjectModalComponent_ng_template_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](0, ProjectModalComponent_ng_template_12_ng_container_0_Template, 1, 0, "ng-container", 29);
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](54);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngTemplateOutlet", _r13)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](2, _c0, ctx_r3.getSelectedCustomTheme()));
} }
function ProjectModalComponent_sl_button_19_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainer"](0);
} }
function ProjectModalComponent_sl_button_19_Template(rf, ctx) { if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-button", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ProjectModalComponent_sl_button_19_Template_sl_button_click_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r20); const theme_r17 = restoredCtx.$implicit; const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](9); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r19.setTheme(theme_r17, _r0)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, ProjectModalComponent_sl_button_19_ng_container_1_Template, 1, 0, "ng-container", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const theme_r17 = ctx.$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](52);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("selected", ctx_r4.isSelectedTheme(theme_r17));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngTemplateOutlet", _r11)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](4, _c0, theme_r17));
} }
function ProjectModalComponent_ng_container_26_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainer"](0);
} }
function ProjectModalComponent_ng_container_26_Template(rf, ctx) { if (rf & 1) {
    const _r24 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "sl-tooltip", 31)(2, "sl-button", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ProjectModalComponent_ng_container_26_Template_sl_button_click_2_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r24); const theme_r21 = restoredCtx.$implicit; const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](9); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r23.setTheme(theme_r21.id, _r0)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, ProjectModalComponent_ng_container_26_ng_container_3_Template, 1, 0, "ng-container", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const theme_r21 = ctx.$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](54);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("content", theme_r21.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("selected", ctx_r6.isSelectedTheme(theme_r21.id));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngTemplateOutlet", _r13)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](5, _c0, theme_r21.pallets));
} }
function ProjectModalComponent_sl_spinner_27_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "sl-spinner");
} }
function ProjectModalComponent_sl_button_37_Template(rf, ctx) { if (rf & 1) {
    const _r27 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-button", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ProjectModalComponent_sl_button_37_Template_sl_button_click_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r27); const icon_r25 = restoredCtx.$implicit; const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](29); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r26.setIcon(icon_r25, _r8)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "sl-icon", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const icon_r25 = ctx.$implicit;
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("selected", ctx_r9.isSelectedIcon(icon_r25));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("name", icon_r25);
} }
function ProjectModalComponent_core_access_46_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "core-access", 33);
} if (rf & 2) {
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("settings", ctx_r10.accessSettings);
} }
function ProjectModalComponent_ng_template_51_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "div");
} if (rf & 2) {
    const i_r30 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵstylePropInterpolate1"]("background", "var(--theme-color-", i_r30, ")");
} }
const _c1 = function () { return [0, 1, 2, 3]; };
function ProjectModalComponent_ng_template_51_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, ProjectModalComponent_ng_template_51_div_1_Template, 1, 3, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const theme_r28 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassMapInterpolate1"]("theme-icon theme-", theme_r28, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction0"](4, _c1));
} }
function ProjectModalComponent_ng_template_53_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "div");
} if (rf & 2) {
    const pallet_r33 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵstyleProp"]("background", pallet_r33.name);
} }
function ProjectModalComponent_ng_template_53_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, ProjectModalComponent_ng_template_53_div_1_Template, 1, 3, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const pallets_r31 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassMapInterpolate1"]("theme-icon theme-icon--", pallets_r31 == null ? null : pallets_r31.length, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", pallets_r31 == null ? null : pallets_r31.slice(0, 4));
} }
const _c2 = function (a0) { return { "0": a0 }; };
const THRESHOLD = 150;
class ProjectModalComponent {
    constructor(appService, formService, notifyService, projectApiService, responseErrorService, themeApiService) {
        this.appService = appService;
        this.formService = formService;
        this.notifyService = notifyService;
        this.projectApiService = projectApiService;
        this.responseErrorService = responseErrorService;
        this.themeApiService = themeApiService;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AccessRight;
        this.onCreate = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.onUpdate = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.icons = getIcons();
        this.themes = getThemes();
        this.customThemes = [];
        this.total = 0;
        this.showModal = false;
        this.projectForm = this.formService
            .create({
            id: [],
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.stringValidator)({ min: 1, max: 250 })]],
            description: [null, [(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.stringValidator)({ min: -1, max: 250 })]],
            icon: [],
            theme: [],
            theme_id: [],
            users: new _angular_forms__WEBPACK_IMPORTED_MODULE_5__.UntypedFormArray([]),
            groups: new _angular_forms__WEBPACK_IMPORTED_MODULE_5__.UntypedFormArray([]),
        })
            .setup({
            method: this.projectApiService.save,
            methodContext: this.projectApiService,
            success: ({ row: project }) => {
                const isEdit = Boolean(this.projectForm.value.id);
                if (isEdit) {
                    this.onUpdate.emit(project);
                }
                else {
                    this.onCreate.emit(project);
                }
                this.notifyService.toastByName('noteProject');
                this.showModal = false;
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'modalProject#notification.create.error',
                });
            },
        });
        this.accessSettings = {
            groups: [],
            users: [],
        };
        this.accessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AccessRight.Full;
        this.loading = false;
        this.loadingMore = false;
        this.currentTheme = null;
    }
    get saveButton() {
        return this.projectForm.state === plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormState.Update
            ? '$.save'
            : '$.create';
    }
    getSelectedIcon() {
        return this.projectForm.get('icon')?.value;
    }
    isSelectedIcon(icon) {
        return this.projectForm.get('icon')?.value === icon;
    }
    setIcon(icon, dropdown) {
        this.projectForm.get('icon')?.patchValue(icon);
        dropdown.hide();
    }
    getSelectedTheme() {
        return this.projectForm.get('theme')?.value;
    }
    getSelectedCustomTheme() {
        if (this.currentTheme)
            return this.currentTheme.pallets;
        else
            return [];
    }
    isSelectedTheme(theme) {
        if (typeof theme === 'string') {
            return this.projectForm.get('theme')?.value === theme;
        }
        else {
            return this.projectForm.get('theme_id')?.value === theme;
        }
    }
    setTheme(theme, dropdown) {
        if (typeof theme === 'string') {
            this.projectForm.get('theme')?.patchValue(theme);
            this.projectForm.get('theme_id')?.patchValue(null);
            this.currentTheme = null;
        }
        else {
            this.projectForm.get('theme')?.patchValue('');
            this.projectForm.get('theme_id')?.patchValue(theme);
            this.currentTheme = this.customThemes.find((item) => item.id === theme);
        }
        dropdown.hide();
    }
    open(project) {
        if (project) {
            this.projectForm.patchValue(project);
            this.projectApiService
                .get(project.id)
                .subscribe(({ row: project }) => {
                this.accessRight = project.access_right;
                this.owner = project.owner;
                this.accessSettings = {
                    groups: project.groups,
                    users: project.users,
                };
            });
            if (project.theme_id)
                this.getCurrentTheme(project.theme_id);
        }
        else {
            this.accessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AccessRight.Full;
            this.owner = this.appService.user.value;
            this.projectForm.reset({
                icon: this.icons[0],
                theme: this.themes[0],
                users_id: [],
                groups_id: [],
            });
            this.accessSettings = {
                groups: [],
                users: [],
            };
        }
        this.loadThemes();
        this.showModal = true;
    }
    onContentScroll(container) {
        if (this.customThemes.length === this.total) {
            this.loading = false;
            return;
        }
        if (this.loadingMore)
            return;
        const { clientHeight, scrollHeight, scrollTop } = container;
        const threshold = scrollHeight - clientHeight - THRESHOLD;
        if (scrollTop > threshold) {
            this.loadingMore = true;
            this.loadThemes();
        }
    }
    getCurrentTheme(themeId) {
        this.themeApiService.get(themeId).subscribe(({ row: theme }) => {
            this.currentTheme = theme;
        });
    }
    loadThemes() {
        this.loading = true;
        this.themeApiService
            .list({ offset: this.customThemes.length, limit: 20 })
            .subscribe(({ rows: themes, total }) => {
            this.customThemes.push(...themes);
            this.total = total;
            this.loading = false;
            this.loadingMore = false;
        });
    }
}
ProjectModalComponent.ɵfac = function ProjectModalComponent_Factory(t) { return new (t || ProjectModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](project_api_project_api_service__WEBPACK_IMPORTED_MODULE_1__.ProjectApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](project_api_theme_api_service__WEBPACK_IMPORTED_MODULE_2__.ThemeApiService)); };
ProjectModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: ProjectModalComponent, selectors: [["app-project-modal"]], outputs: { onCreate: "onCreate", onUpdate: "onUpdate" }, decls: 58, vars: 48, consts: [[3, "label", "open", "openChange"], [3, "data"], [1, "common-block"], [1, "name"], ["name", "name", 1, "primary", "required", 3, "label", "placeholder"], ["placement", "bottom-end"], ["themeDropdown", ""], ["slot", "trigger", 1, "theme-button"], [4, "ngIf", "ngIfElse"], ["customTheme", ""], [1, "select-item"], [1, "select-item-label"], [1, "select-item-content"], ["class", "theme-button", 3, "selected", "click", 4, "ngFor", "ngForOf"], [1, "select-item-content", 3, "scroll"], ["themesContainer", ""], [4, "ngFor", "ngForOf"], [4, "ngIf"], ["iconDropdown", ""], ["slot", "trigger", 1, "icon-button"], ["library", "dashboard", 3, "name"], ["class", "icon-button", 3, "selected", "click", 4, "ngFor", "ngForOf"], ["name", "description", "rows", "1", "resize", "auto", 1, "primary", 3, "label", "placeholder"], [1, "owner"], [3, "settings", 4, "ngIf"], ["type", "submit", "variant", "primary"], ["themeIcon", ""], ["customThemeIcon", ""], ["name", "noteProject"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [1, "theme-button", 3, "click"], [3, "content"], [1, "icon-button", 3, "click"], [3, "settings"], [3, "background", 4, "ngFor", "ngForOf"]], template: function ProjectModalComponent_Template(rf, ctx) { if (rf & 1) {
        const _r34 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("openChange", function ProjectModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.showModal = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "core-form", 1)(3, "div", 2)(4, "core-validate", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](5, "sl-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](7, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "sl-dropdown", 5, 6)(10, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](11, ProjectModalComponent_ng_container_11_Template, 2, 4, "ng-container", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](12, ProjectModalComponent_ng_template_12_Template, 1, 4, "ng-template", null, 9, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](14, "div", 10)(15, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](18, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](19, ProjectModalComponent_sl_button_19_Template, 2, 6, "sl-button", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](20, "sl-divider");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](21, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](22);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](23, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](24, "div", 14, 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("scroll", function ProjectModalComponent_Template_div_scroll_24_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r34); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](25); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx.onContentScroll(_r5)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](26, ProjectModalComponent_ng_container_26_Template, 4, 7, "ng-container", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](27, ProjectModalComponent_sl_spinner_27_Template, 1, 0, "sl-spinner", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](28, "sl-dropdown", 5, 18)(30, "sl-button", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](31, "sl-icon", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](32, "div", 10)(33, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](34);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](35, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](36, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](37, ProjectModalComponent_sl_button_37_Template, 2, 3, "sl-button", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](38, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](39, "sl-textarea", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](40, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](41, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](42, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](43);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](44, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](45, "username");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](46, ProjectModalComponent_core_access_46_Template, 1, 1, "core-access", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](47, "footer")(48, "sl-button", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](49);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](50, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](51, ProjectModalComponent_ng_template_51_Template, 2, 5, "ng-template", null, 26, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](53, ProjectModalComponent_ng_template_53_Template, 2, 4, "ng-template", null, 27, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](55, "core-notify", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](56);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](57, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](1, 21, "modal.title." + ctx.projectForm.state))("open", ctx.showModal);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("data", ctx.projectForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 23, "modal.name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](7, 25, "modal.name.placeholder"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.projectForm.get("theme").value)("ngIfElse", _r2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](17, 27, "modal.selectTheme"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx.themes);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](23, 29, "modal.selectCustomTheme"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx.customThemes);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("name", ctx.getSelectedIcon());
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](35, 31, "modal.selectIcon"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx.icons);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](40, 33, "modal.description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](41, 35, "modal.description.placeholder"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind2"](44, 37, "modal.owner", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpureFunction1"](46, _c2, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](45, 40, ctx.owner))), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.accessRight === ctx.AccessRight.Full);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](50, 42, ctx.saveButton), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](57, 44, "modalProject#notification." + ctx.projectForm.state), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ValidateComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AccessComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipe], styles: [".common-block[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  margin-bottom: var(--sl-spacing-medium);\n}\n.common-block[_ngcontent-%COMP%]   .name[_ngcontent-%COMP%] {\n  flex: 1;\n  display: block;\n  margin-right: var(--sl-spacing-small);\n}\n.common-block[_ngcontent-%COMP%]   sl-dropdown[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-small);\n}\n.select-item[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-medium);\n  padding-right: calc(var(--sl-spacing-medium) - var(--sl-spacing-2x-small));\n}\n.select-item-label[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-600);\n  margin-bottom: var(--sl-spacing-small);\n}\n.select-item-content[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: repeat(5, 1fr);\n  gap: var(--sl-spacing-small);\n  padding-right: var(--sl-spacing-2x-small);\n  max-height: 144px;\n  overflow-y: auto;\n  scrollbar-gutter: stable;\n}\nsl-button.selected[_ngcontent-%COMP%]::part(base) {\n  background-color: #404053;\n}\n.theme-button[_ngcontent-%COMP%]::part(label) {\n  padding: 0 var(--sl-spacing-x-small);\n}\n.theme-icon[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: repeat(2, 1fr);\n  width: 24px;\n  height: 24px;\n  margin-top: 7px;\n}\n.theme-icon--1[_ngcontent-%COMP%] {\n  grid-template-columns: 1fr;\n}\n.theme-icon--3[_ngcontent-%COMP%] {\n  grid-template-rows: repeat(2, 1fr);\n}\n.theme-icon--3[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(2) {\n  grid-row: 1/3;\n}\n.icon-button[_ngcontent-%COMP%]::part(label) {\n  padding: 0;\n}\n.icon-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  width: 36px;\n  height: 36px;\n}\n.owner[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  margin: var(--sl-spacing-medium) 0 var(--sl-spacing-medium);\n}\nsl-textarea[_ngcontent-%COMP%]::part(textarea) {\n  padding: calc(var(--sl-spacing-x-small) + 0.04rem) var(--sl-spacing-medium);\n  overflow: hidden;\n}\nsl-dropdown[_ngcontent-%COMP%] {\n  margin-top: calc(var(--sl-spacing-large) + var(--sl-spacing-2x-small));\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], ProjectModalComponent.prototype, "customThemes", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], ProjectModalComponent.prototype, "owner", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], ProjectModalComponent.prototype, "accessSettings", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], ProjectModalComponent.prototype, "accessRight", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], ProjectModalComponent.prototype, "loading", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], ProjectModalComponent.prototype, "loadingMore", void 0);
function getIcons() {
    const icons = Object.values(project_interfaces_project__WEBPACK_IMPORTED_MODULE_0__.ProjectIcon);
    return icons.map((icon) => `project-icon/${icon}`);
}
function getThemes() {
    return Object.values(project_interfaces_project__WEBPACK_IMPORTED_MODULE_0__.ThemeColor);
}


/***/ }),

/***/ 75827:
/*!******************************************************************!*\
  !*** ./src/app/components/project-modal/project-modal.module.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProjectModalModule": () => (/* binding */ ProjectModalModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 7073);
/* harmony import */ var project_components_project_modal_project_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! project/components/project-modal/project-modal.component */ 97654);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! shoelace-style-angular */ 39652);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 92299);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ 48665);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 64565);






class ProjectModalModule {
}
ProjectModalModule.ɵfac = function ProjectModalModule_Factory(t) { return new (t || ProjectModalModule)(); };
ProjectModalModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: ProjectModalModule });
ProjectModalModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_4__.ReactiveFormsModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipeModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](ProjectModalModule, { declarations: [project_components_project_modal_project_modal_component__WEBPACK_IMPORTED_MODULE_0__.ProjectModalComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_4__.ReactiveFormsModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_5__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipeModule], exports: [project_components_project_modal_project_modal_component__WEBPACK_IMPORTED_MODULE_0__.ProjectModalComponent] }); })();


/***/ }),

/***/ 16847:
/*!***************************************!*\
  !*** ./src/app/interfaces/project.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DashboardPostMessageEvent": () => (/* binding */ DashboardPostMessageEvent),
/* harmony export */   "ProjectIcon": () => (/* binding */ ProjectIcon),
/* harmony export */   "ThemeColor": () => (/* binding */ ThemeColor)
/* harmony export */ });
var DashboardPostMessageEvent;
(function (DashboardPostMessageEvent) {
    DashboardPostMessageEvent["Interact"] = "interact";
    DashboardPostMessageEvent["GoTo"] = "goTo";
    DashboardPostMessageEvent["TriggerValue"] = "triggerValue";
    DashboardPostMessageEvent["SetFilter"] = "setFilter";
    DashboardPostMessageEvent["Resize"] = "resize";
    DashboardPostMessageEvent["ChangeFilter"] = "changeFilter";
    DashboardPostMessageEvent["ChangeProjectState"] = "changeProjectState";
})(DashboardPostMessageEvent || (DashboardPostMessageEvent = {}));
var ThemeColor;
(function (ThemeColor) {
    ThemeColor["Polymatica"] = "polymatica";
    ThemeColor["C1"] = "c1";
    ThemeColor["C2"] = "c2";
    ThemeColor["Grey"] = "grey";
    ThemeColor["Green"] = "green";
    ThemeColor["Pink"] = "pink";
    ThemeColor["Blue"] = "blue";
    ThemeColor["Yellow"] = "yellow";
    ThemeColor["Red"] = "red";
    ThemeColor["Mixed"] = "mixed";
    ThemeColor["Circus"] = "circus";
    ThemeColor["Custom1"] = "custom1";
})(ThemeColor || (ThemeColor = {}));
var ProjectIcon;
(function (ProjectIcon) {
    ProjectIcon["Antique"] = "antique";
    ProjectIcon["Atom"] = "atom";
    ProjectIcon["Box"] = "box";
    ProjectIcon["Briefcase"] = "briefcase";
    ProjectIcon["ChartDonut"] = "chart-donut";
    ProjectIcon["Chip"] = "chip";
    ProjectIcon["Clock"] = "clock";
    ProjectIcon["Construction"] = "construction";
    ProjectIcon["CubeEdges"] = "cube-edges";
    ProjectIcon["Cube"] = "cube";
    ProjectIcon["Document"] = "document";
    ProjectIcon["Factory"] = "factory";
    ProjectIcon["Figure3d"] = "figure-3d";
    ProjectIcon["Flag"] = "flag";
    ProjectIcon["GroceryTrolley"] = "grocery-trolley";
    ProjectIcon["Lab"] = "lab";
    ProjectIcon["Lifebuoy"] = "lifebuoy";
    ProjectIcon["Lightning"] = "lightning";
    ProjectIcon["Moneybag"] = "moneybag";
    ProjectIcon["Moon"] = "moon";
    ProjectIcon["Plane"] = "plane";
    ProjectIcon["Planet"] = "planet";
    ProjectIcon["Plus"] = "plus";
    ProjectIcon["Pumpjack"] = "pumpjack";
    ProjectIcon["Truck"] = "truck";
})(ProjectIcon || (ProjectIcon = {}));


/***/ })

}]);
//# sourceMappingURL=default-src_app_components_project-modal_project-modal_module_ts.js.map