"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["main"],{

/***/ 9613:
/*!*****************************************!*\
  !*** ./src/app/api/data-api.service.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataApiService": () => (/* binding */ DataApiService)
/* harmony export */ });
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs/operators */ 635);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);



class DataApiService {
    constructor(restService) {
        this.restService = restService;
    }
    page() {
        return this.restService.get('/data/page');
    }
    dataset(data) {
        return this.restService.post('/data/dataset', data);
    }
    merge(data) {
        return this.restService.post('/data/merge', data);
    }
    formula(data) {
        return this.restService.post('/data/formula', data);
    }
    ping(datasetId) {
        return this.restService
            .get(`/dataset/ping`, {
            ids: [datasetId],
        })
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)((progressMap) => progressMap[datasetId]));
    }
}
DataApiService.ɵfac = function DataApiService_Factory(t) { return new (t || DataApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.RestService)); };
DataApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: DataApiService, factory: DataApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 158:
/*!***************************************!*\
  !*** ./src/app/app-routing.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppRoutingModule": () => (/* binding */ AppRoutingModule)
/* harmony export */ });
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _guards_auth_guard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./guards/auth.guard */ 5107);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);





const routes = [
    {
        path: plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.authPath,
        canActivate: [_guards_auth_guard__WEBPACK_IMPORTED_MODULE_0__.AuthGuard],
        loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("common"), __webpack_require__.e("src_app_pages_auth_auth_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/auth/auth.module */ 6621)).then((m) => m.AuthModule),
    },
    {
        path: plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.authTokenPath,
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! plmt-core-library */ 9543)).then((m) => m.AuthTokenPageModule),
    },
    {
        path: '',
        loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("common"), __webpack_require__.e("src_app_pages_pages_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/pages.module */ 8950)).then((m) => m.PagesModule),
    },
];
class AppRoutingModule {
}
AppRoutingModule.ɵfac = function AppRoutingModule_Factory(t) { return new (t || AppRoutingModule)(); };
AppRoutingModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineNgModule"]({ type: AppRoutingModule });
AppRoutingModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjector"]({ imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forRoot(routes), _angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵsetNgModuleScope"](AppRoutingModule, { imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule], exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule] }); })();


/***/ }),

/***/ 5041:
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppComponent": () => (/* binding */ AppComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);




class AppComponent {
    constructor(changeDetectorRef, changeDetectionService) {
        this.changeDetectorRef = changeDetectorRef;
        this.changeDetectionService = changeDetectionService;
    }
    ngOnInit() {
        this.changeDetectionService.provideRootChangeDetectorRef(this.changeDetectorRef);
    }
}
AppComponent.ɵfac = function AppComponent_Factory(t) { return new (t || AppComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](ng_onpush__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectionService)); };
AppComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AppComponent, selectors: [["app-root"]], decls: 3, vars: 0, template: function AppComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "router-outlet")(1, "core-response-error")(2, "core-license-notification");
    } }, dependencies: [_angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ResponseErrorComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.LicenseNotificationComponent], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJhcHAuY29tcG9uZW50Lmxlc3MifQ== */"] });


/***/ }),

/***/ 6747:
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppModule": () => (/* binding */ AppModule)
/* harmony export */ });
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/platform-browser */ 318);
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app-routing.module */ 158);
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app.component */ 5041);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../environments/environment */ 2340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);






class AppModule {
}
AppModule.ɵfac = function AppModule_Factory(t) { return new (t || AppModule)(); };
AppModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({ type: AppModule, bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_1__.AppComponent] });
AppModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({ providers: [
        {
            provide: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.API_BASE_URLS,
            useValue: _environments_environment__WEBPACK_IMPORTED_MODULE_2__.environment.apiBaseUrls,
        },
        {
            provide: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ENVIRONMENT,
            useValue: _environments_environment__WEBPACK_IMPORTED_MODULE_2__.environment.production
                ? plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.Environment.Production
                : plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.Environment.Development,
        },
    ], imports: [_angular_platform_browser__WEBPACK_IMPORTED_MODULE_5__.BrowserModule,
        _app_routing_module__WEBPACK_IMPORTED_MODULE_0__.AppRoutingModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.RestServiceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyMainModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.LicenseNotificationModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetNgModuleScope"](AppModule, { declarations: [_app_component__WEBPACK_IMPORTED_MODULE_1__.AppComponent], imports: [_angular_platform_browser__WEBPACK_IMPORTED_MODULE_5__.BrowserModule,
        _app_routing_module__WEBPACK_IMPORTED_MODULE_0__.AppRoutingModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.RestServiceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyMainModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.LicenseNotificationModule] }); })();


/***/ }),

/***/ 5107:
/*!**************************************!*\
  !*** ./src/app/guards/auth.guard.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AuthGuard": () => (/* binding */ AuthGuard)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs/operators */ 635);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _api_data_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../api/data-api.service */ 9613);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 2816);






class AuthGuard {
    constructor(dataApiService, router, storageService) {
        this.dataApiService = dataApiService;
        this.router = router;
        this.storageService = storageService;
    }
    canActivate(route) {
        const token = this.storageService.authToken.value;
        if (!token)
            return true;
        return this.dataApiService.page().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_1__.map)(({ row: page }) => {
            if (!page.user)
                return true;
            const redirect = route.queryParams.redirect;
            if (redirect) {
                (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.authRedirect)(redirect, token);
            }
            else {
                this.router.navigate(['/']);
            }
            return false;
        }));
    }
}
AuthGuard.ɵfac = function AuthGuard_Factory(t) { return new (t || AuthGuard)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵinject"](_api_data_api_service__WEBPACK_IMPORTED_MODULE_0__.DataApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵinject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.StorageService)); };
AuthGuard.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjectable"]({ token: AuthGuard, factory: AuthGuard.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 2340:
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "environment": () => (/* binding */ environment)
/* harmony export */ });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
const environment = {
    production: false,
    apiBaseUrls: {
        core: '/api/v1',
        project: '/api/v1',
    },
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/plugins/zone-error';  // Included with Angular CLI.


/***/ }),

/***/ 4431:
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/platform-browser */ 318);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _app_app_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app/app.module */ 6747);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./environments/environment */ 2340);
/* harmony import */ var _shoelace_style_shoelace__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @shoelace-style/shoelace */ 3004);
/// <reference types="shoelace-style-angular/events" />





(0,_shoelace_style_shoelace__WEBPACK_IMPORTED_MODULE_2__.setBasePath)('assets/shoelace');
if (_environments_environment__WEBPACK_IMPORTED_MODULE_1__.environment.production) {
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.enableProdMode)();
}
(0,_shoelace_style_shoelace__WEBPACK_IMPORTED_MODULE_2__.registerIconLibrary)('platform', {
    resolver: (name) => `/assets/icons/${name}.svg`,
});
(0,_shoelace_style_shoelace__WEBPACK_IMPORTED_MODULE_2__.registerIconLibrary)('core', {
    resolver: (name) => `/assets/core-library/icons/${name}.svg`,
});
_angular_platform_browser__WEBPACK_IMPORTED_MODULE_4__.platformBrowser()
    .bootstrapModule(_app_app_module__WEBPACK_IMPORTED_MODULE_0__.AppModule)
    .catch((err) => console.error(err));


/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendor"], () => (__webpack_exec__(4431)));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=main.js.map