"use strict";
(self["webpackChunkfrontend"] = self["webpackChunkfrontend"] || []).push([["src_app_pages_dataset_dataset-settings_dataset-settings_module_ts"],{

/***/ 9719:
/*!*******************************************!*\
  !*** ./src/app/api/column-api.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnApiService": () => (/* binding */ ColumnApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);


class ColumnApiService {
    constructor(restService) {
        this.restService = restService;
    }
    get(datasetId, id) {
        return this.restService.get(`/dataset/${datasetId}/column/${id}`);
    }
    getConversionPreview(datasetId, id, params) {
        return this.restService.post(`/dataset/${datasetId}/column/${id}/get-conversion-preview/`, params);
    }
    update(data, datasetId) {
        return this.restService.put(`/dataset/${datasetId}/column/${data.id}`, data);
    }
}
ColumnApiService.ɵfac = function ColumnApiService_Factory(t) { return new (t || ColumnApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
ColumnApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ColumnApiService, factory: ColumnApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 3967:
/*!************************************************!*\
  !*** ./src/app/api/dataset-sql-api.service.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetSqlApiService": () => (/* binding */ DatasetSqlApiService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);



class DatasetSqlApiService {
    constructor(restService) {
        this.restService = restService;
    }
    getDependencies(sourcetId) {
        //Todo когда на бэке появится межсервисная связь
        return this.restService.get(`/entity/dataset-local/${sourcetId}/dependencies`);
    }
    saveSqlResponse(datasetId, params) {
        return this.restService.put(`/dataset/${datasetId}/replace-sql`, Object.assign({}, params));
    }
    getSqlPrewiev(datasetId, params) {
        return this.restService.post(`/dataset/${datasetId}/replace-sql/preview/`, Object.assign({}, params));
    }
}
DatasetSqlApiService.ɵfac = function DatasetSqlApiService_Factory(t) { return new (t || DatasetSqlApiService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.RestService)); };
DatasetSqlApiService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: DatasetSqlApiService, factory: DatasetSqlApiService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 2197:
/*!*****************************************************************!*\
  !*** ./src/app/components/input-token/input-token.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ETokenType": () => (/* binding */ ETokenType),
/* harmony export */   "InputTokenComponent": () => (/* binding */ InputTokenComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);


const _c0 = ["inputElement"];
var ETokenType;
(function (ETokenType) {
    ETokenType[ETokenType["Id"] = 0] = "Id";
    ETokenType[ETokenType["Token"] = 1] = "Token";
})(ETokenType || (ETokenType = {}));
class InputTokenComponent {
    constructor() {
        this.onChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }
    get value() {
        return this.inputElement.nativeElement.innerText;
    }
    set value(value) {
        this.inputElement.nativeElement.innerHTML = value;
    }
    put(item) {
        const element = this.inputElement.nativeElement;
        const position = this.getCaretIndex(element);
        setTimeout(() => {
            this.value = this.tokenize(this.value + item.name + '&nbsp;');
            this.setCursor(position, element);
            this.change();
        });
    }
    putText(value) {
        const element = this.inputElement.nativeElement;
        const position = this.getCaretIndex(element);
        setTimeout(() => {
            this.value = this.tokenize(this.value + value + '&nbsp;');
            this.setCursor(position, element);
            this.change();
        });
    }
    onInput(event) {
        const position = this.getCaretIndex(event.target);
        setTimeout(() => {
            this.value = this.tokenize(this.value);
            this.setCursor(position, event.target);
            this.change();
        });
    }
    onKeyDown(event) {
        if (event.keyCode === 13) {
            event.preventDefault();
            event.stopPropagation();
        }
    }
    change() {
        const rows = [];
        this.inputElement.nativeElement.childNodes.forEach((item) => {
            let type = ETokenType.Token;
            let columnId;
            let value;
            if (item.nodeName === 'SPAN') {
                const text = item.innerText;
                const data = this.tokenList.find((t) => t.name === text);
                if (data) {
                    type = ETokenType.Id;
                    columnId = data.id;
                }
                else {
                    value = text;
                }
            }
            else {
                value = item.nodeValue.trim();
            }
            if (value || columnId) {
                rows.push({ type, value, column_id: Number(columnId) });
            }
        });
        this.onChange.emit(rows);
    }
    createToken(item) {
        return `<span>${item.name}</span>`;
    }
    tokenize(value) {
        var _a;
        (_a = this.tokenList) === null || _a === void 0 ? void 0 : _a.forEach((item) => {
            value = value.replaceAll(item.name, this.createToken(item));
        });
        return value;
    }
    setCursor(position, element) {
        if (position >= 0) {
            const selection = window.getSelection();
            const range = this.createRange(element.parentNode, {
                count: position,
            });
            if (range) {
                range.selectNodeContents(element);
                range.collapse(false);
                selection.removeAllRanges();
                selection.addRange(range);
            }
        }
    }
    createRange(node, chars, range) {
        if (!node)
            return range;
        if (!range) {
            range = document.createRange();
            range.selectNode(node);
            range.setStart(node, 0);
        }
        else {
            if (chars.count === 0) {
                range.setEnd(node, chars.count);
            }
            else if (node && chars.count > 0) {
                if (node.nodeType === Node.TEXT_NODE) {
                    if (node.textContent &&
                        node.textContent.length < chars.count) {
                        chars.count -= node.textContent.length;
                    }
                    else {
                        range.setEnd(node, chars.count);
                        chars.count = 0;
                    }
                }
                else {
                    for (const item of node.childNodes) {
                        range = this.createRange(item, chars, range);
                        if (chars.count === 0) {
                            break;
                        }
                    }
                }
            }
        }
        return range;
    }
    getCaretIndex(element) {
        const isSupported = typeof window.getSelection !== 'undefined';
        let position = 0;
        if (isSupported) {
            const selection = window.getSelection();
            if (selection.rangeCount !== 0) {
                const range = window.getSelection().getRangeAt(0);
                const preCaretRange = range.cloneRange();
                preCaretRange.selectNodeContents(element);
                preCaretRange.setEnd(range.endContainer, range.endOffset);
                position = preCaretRange.toString().length;
            }
        }
        return position;
    }
}
InputTokenComponent.ɵfac = function InputTokenComponent_Factory(t) { return new (t || InputTokenComponent)(); };
InputTokenComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: InputTokenComponent, selectors: [["app-input-token"]], viewQuery: function InputTokenComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c0, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.inputElement = _t.first);
    } }, inputs: { tokenList: "tokenList", placeholder: "placeholder" }, outputs: { onChange: "onChange" }, decls: 2, vars: 1, consts: [["contenteditable", "true", 1, "input", 3, "keydown", "input"], ["inputElement", ""]], template: function InputTokenComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0, 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown", function InputTokenComponent_Template_div_keydown_0_listener($event) { return ctx.onKeyDown($event); })("input", function InputTokenComponent_Template_div_input_0_listener($event) { return ctx.onInput($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("data-placeholder", ctx.placeholder);
    } }, styles: ["app-input-token .input {\n  line-height: 2em;\n  padding: var(--sl-spacing-3x-small) var(--sl-spacing-small);\n  border: 1px solid var(--sl-color-info-300);\n  border-radius: var(--sl-border-radius-medium);\n}\napp-input-token .input:focus {\n  outline: none;\n  box-shadow: 0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary);\n}\napp-input-token .input:empty:after {\n  content: attr(data-placeholder);\n  color: var(--sl-color-secondary-600);\n}\napp-input-token .input span {\n  padding: 1px 5px;\n  background: var(--sl-color-info-200);\n  border-radius: var(--sl-border-radius-medium);\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlucHV0LXRva2VuLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRVEsZ0JBQUE7RUFDQSwyREFBQTtFQUNBLDBDQUFBO0VBQ0EsNkNBQUE7QUFBUjtBQUVRO0VBQ0ksYUFBQTtFQUNBLCtFQUFBO0FBQVo7QUFJUTtFQUNJLCtCQUFBO0VBQ0Esb0NBQUE7QUFGWjtBQWJBO0VBbUJZLGdCQUFBO0VBQ0Esb0NBQUE7RUFDQSw2Q0FBQTtBQUhaIiwiZmlsZSI6ImlucHV0LXRva2VuLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiYXBwLWlucHV0LXRva2VuIHtcbiAgICAuaW5wdXQge1xuICAgICAgICBsaW5lLWhlaWdodDogMmVtO1xuICAgICAgICBwYWRkaW5nOiB2YXIoLS1zbC1zcGFjaW5nLTN4LXNtYWxsKSB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKTtcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQgdmFyKC0tc2wtY29sb3ItaW5mby0zMDApO1xuICAgICAgICBib3JkZXItcmFkaXVzOiB2YXIoLS1zbC1ib3JkZXItcmFkaXVzLW1lZGl1bSk7XG5cbiAgICAgICAgJjpmb2N1cyB7XG4gICAgICAgICAgICBvdXRsaW5lOiBub25lO1xuICAgICAgICAgICAgYm94LXNoYWRvdzogMCAwIDAgdmFyKC0tc2wtZm9jdXMtcmluZy13aWR0aClcbiAgICAgICAgICAgICAgICB2YXIoLS1zbC1mb2N1cy1yaW5nLWNvbG9yLXByaW1hcnkpO1xuICAgICAgICB9XG5cbiAgICAgICAgJjplbXB0eTphZnRlciB7XG4gICAgICAgICAgICBjb250ZW50OiBhdHRyKGRhdGEtcGxhY2Vob2xkZXIpO1xuICAgICAgICAgICAgY29sb3I6IHZhcigtLXNsLWNvbG9yLXNlY29uZGFyeS02MDApO1xuICAgICAgICB9XG5cbiAgICAgICAgc3BhbiB7XG4gICAgICAgICAgICBwYWRkaW5nOiAxcHggNXB4O1xuICAgICAgICAgICAgYmFja2dyb3VuZDogdmFyKC0tc2wtY29sb3ItaW5mby0yMDApO1xuICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogdmFyKC0tc2wtYm9yZGVyLXJhZGl1cy1tZWRpdW0pO1xuICAgICAgICB9XG4gICAgfVxufVxuIl19 */"], encapsulation: 2 });


/***/ }),

/***/ 294:
/*!**************************************************************!*\
  !*** ./src/app/components/input-token/input-token.module.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputTokenModule": () => (/* binding */ InputTokenModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _input_token_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./input-token.component */ 2197);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);



class InputTokenModule {
}
InputTokenModule.ɵfac = function InputTokenModule_Factory(t) { return new (t || InputTokenModule)(); };
InputTokenModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: InputTokenModule });
InputTokenModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](InputTokenModule, { declarations: [_input_token_component__WEBPACK_IMPORTED_MODULE_0__.InputTokenComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule], exports: [_input_token_component__WEBPACK_IMPORTED_MODULE_0__.InputTokenComponent] }); })();


/***/ }),

/***/ 8283:
/*!*****************************************************************************************!*\
  !*** ./src/app/components/rule-access/rule-access-modal/rule-access-modal.component.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RuleAccessModalComponent": () => (/* binding */ RuleAccessModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../rule-access.component */ 8034);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _access_entities_entities_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../access/entities/entities.component */ 1405);








function RuleAccessModalComponent_ng_template_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](0);
} if (rf & 2) {
    const group_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r6.name, " ");
} }
function RuleAccessModalComponent_ng_template_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "core-avatar", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const user_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("user", user_r7)("size", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 3, user_r7), " ");
} }
class RuleAccessModalComponent {
    constructor() {
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = _rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State;
        this.isEmpty = false;
        this.loading = false;
        this.currentState = _rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups;
        this.open = false;
        this.selectedGroups = [];
        this.selectedUsers = [];
    }
    selectUsers(event) {
        this.selectedUsers = event;
    }
    selectGroups(event) {
        this.selectedGroups = event;
    }
    show(users, groups, state = _rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups) {
        this.selectedUsers = [...users];
        this.selectedGroups = [...groups];
        this.currentState = state;
        this.open = true;
    }
    hide() {
        this.open = false;
    }
    changeState(state) {
        this.currentState = state;
    }
    save() {
        const params = {
            users: this.selectedUsers,
            groups: this.selectedGroups,
        };
        this.onSave.emit(params);
    }
    onShow(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = 'hidden';
    }
    onHide(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = '';
    }
}
RuleAccessModalComponent.ɵfac = function RuleAccessModalComponent_Factory(t) { return new (t || RuleAccessModalComponent)(); };
RuleAccessModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: RuleAccessModalComponent, selectors: [["app-rule-access-modal"]], inputs: { usersProvider: "usersProvider", groupsProvider: "groupsProvider", state: "state", dataset: "dataset", globalRule: "globalRule" }, outputs: { onSave: "onSave" }, decls: 29, vars: 30, consts: [[3, "open", "label", "openChange", "sl-show", "sl-hide"], ["dialog", ""], [1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], ["clearable", "", 1, "search", 3, "placeholder"], ["searchInput", ""], ["slot", "clear-icon", "name", "x"], ["slot", "suffix", "library", "core", "name", "search-bold"], [1, "ents"], [1, "entities"], [3, "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect"], ["groupEntityTemplate", ""], [3, "isUser", "entitiesProvider", "entityTemplate", "searchInput", "selected", "onSelect"], ["userEntityTemplate", ""], [3, "click"], ["variant", "primary", 3, "click"], [3, "user", "size"]], template: function RuleAccessModalComponent_Template(rf, ctx) { if (rf & 1) {
        const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0, 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function RuleAccessModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.open = $event; })("sl-show", function RuleAccessModalComponent_Template_sl_dialog_sl_show_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onShow(_r0)); })("sl-hide", function RuleAccessModalComponent_Template_sl_dialog_sl_hide_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onHide(_r0)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "div", 2)(4, "div")(5, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_5_listener() { return ctx.changeState(ctx.State.Groups); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_7_listener() { return ctx.changeState(ctx.State.Users); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](8, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "sl-input", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](12, "sl-icon", 8)(13, "sl-icon", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](14, "div", 10)(15, "div", 11)(16, "app-entities", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function RuleAccessModalComponent_Template_app_entities_onSelect_16_listener($event) { return ctx.selectGroups($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](17, RuleAccessModalComponent_ng_template_17_Template, 1, 1, "ng-template", null, 13, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "app-entities", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function RuleAccessModalComponent_Template_app_entities_onSelect_19_listener($event) { return ctx.selectUsers($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](20, RuleAccessModalComponent_ng_template_20_Template, 4, 5, "ng-template", null, 15, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](22, "footer")(23, "sl-button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_23_listener() { return ctx.open = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](25, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](26, "sl-button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function RuleAccessModalComponent_Template_sl_button_click_26_listener() { return ctx.save(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](10);
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](18);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("open", ctx.open)("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 22, "_$.access.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 24, "_$.access.search"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("entitiesProvider", ctx.groupsProvider)("entityTemplate", _r2)("searchInput", _r1)("selected", ctx.selectedGroups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("isUser", true)("entitiesProvider", ctx.usersProvider)("entityTemplate", _r4)("searchInput", _r1)("selected", ctx.selectedUsers);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](25, 26, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](28, 28, "$.apply"), " ");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AvatarComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, _access_entities_entities_component__WEBPACK_IMPORTED_MODULE_1__.EntitiesComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipe], styles: ["sl-dialog[_ngcontent-%COMP%] {\n  --width: 730px;\n  visibility: visible;\n}\n.search[_ngcontent-%COMP%] {\n  width: 266px;\n}\n.label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-large);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.ents[_ngcontent-%COMP%] {\n  min-height: 420px;\n  height: 100%;\n}\ncore-avatar[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-small);\n  margin-bottom: var(--sl-spacing-2x-small);\n}\nsl-checkbox[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(base) {\n  width: 100%;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(label) {\n  display: flex;\n  overflow: hidden;\n}\n.spinner-container[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], RuleAccessModalComponent.prototype, "loading", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], RuleAccessModalComponent.prototype, "selectedGroups", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], RuleAccessModalComponent.prototype, "selectedUsers", void 0);


/***/ }),

/***/ 8034:
/*!*****************************************************************!*\
  !*** ./src/app/components/rule-access/rule-access.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RuleAccessComponent": () => (/* binding */ RuleAccessComponent),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_to_parent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ng-to-parent */ 5468);
/* harmony import */ var _rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rule-access-modal/rule-access-modal.component */ 8283);




function RuleAccessComponent_ng_container_10_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function RuleAccessComponent_ng_container_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, RuleAccessComponent_ng_container_10_ng_container_1_Template, 1, 0, "ng-container", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r2);
} }
function RuleAccessComponent_ng_container_11_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function RuleAccessComponent_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, RuleAccessComponent_ng_container_11_ng_container_1_Template, 1, 0, "ng-container", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r4);
} }
function RuleAccessComponent_ng_template_12_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-tag", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-remove", function RuleAccessComponent_ng_template_12_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r12); const group_r10 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.removeGroup.emit(group_r10.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const group_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", group_r10.name, " ");
} }
function RuleAccessComponent_ng_template_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, RuleAccessComponent_ng_template_12_sl_tag_0_Template, 3, 1, "sl-tag", 12);
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r3.groups);
} }
function RuleAccessComponent_ng_template_14_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-tag", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-remove", function RuleAccessComponent_ng_template_14_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r16); const user_r14 = restoredCtx.$implicit; const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r15.removeUser.emit(user_r14.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const user_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, user_r14), " ");
} }
function RuleAccessComponent_ng_template_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, RuleAccessComponent_ng_template_14_sl_tag_0_Template, 4, 3, "sl-tag", 12);
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r5.users);
} }
var State;
(function (State) {
    State[State["Users"] = 0] = "Users";
    State[State["Groups"] = 1] = "Groups";
})(State || (State = {}));
class RuleAccessComponent {
    constructor() {
        this.users = [];
        this.groups = [];
        this.removeUser = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.removeGroup = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.State = State;
        this.state = State.Groups;
    }
    set globalRule(value) {
        this._globalRule = value;
        if (!this._globalRule || !this.dataset)
            return;
    }
    get globalRule() {
        return this._globalRule;
    }
}
RuleAccessComponent.ɵfac = function RuleAccessComponent_Factory(t) { return new (t || RuleAccessComponent)(); };
RuleAccessComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: RuleAccessComponent, selectors: [["app-rule-access"]], viewQuery: function RuleAccessComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵviewQuery"](_rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessModalComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵloadQuery"]()) && (ctx.ruleAccessModal = _t.first);
    } }, inputs: { users: "users", groups: "groups", usersProvider: "usersProvider", groupsProvider: "groupsProvider", dataset: "dataset", globalRule: "globalRule" }, outputs: { removeUser: "removeUser", removeGroup: "removeGroup", update: "update" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵProvidersFeature"]([ng_to_parent__WEBPACK_IMPORTED_MODULE_2__.ToParent])], decls: 21, vars: 17, consts: [[1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], [1, "values"], [4, "ngIf"], ["groupTemplate", ""], ["userTemplate", ""], ["variant", "text", 3, "click"], [3, "dataset", "state", "globalRule", "usersProvider", "groupsProvider", "onSave"], ["ruleAccesModal", ""], [4, "ngTemplateOutlet"], ["pill", "", "removable", "", 3, "sl-remove", 4, "ngFor", "ngForOf"], ["pill", "", "removable", "", 3, "sl-remove"], ["tooltipify", "", 1, "tag-name"]], template: function RuleAccessComponent_Template(rf, ctx) { if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0)(1, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div")(5, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function RuleAccessComponent_Template_sl_button_click_5_listener() { return ctx.state = ctx.State.Groups; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](6, "sl-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function RuleAccessComponent_Template_sl_button_click_7_listener() { return ctx.state = ctx.State.Users; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](8, "sl-icon", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, RuleAccessComponent_ng_container_10_Template, 2, 1, "ng-container", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, RuleAccessComponent_ng_container_11_Template, 2, 1, "ng-container", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, RuleAccessComponent_ng_template_12_Template, 1, 1, "ng-template", null, 6, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](14, RuleAccessComponent_ng_template_14_Template, 1, 1, "ng-template", null, 7, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "sl-button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function RuleAccessComponent_Template_sl_button_click_16_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](20); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](_r6.show(ctx.users, ctx.groups, ctx.state)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "app-rule-access-modal", 9, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onSave", function RuleAccessComponent_Template_app_rule_access_modal_onSave_19_listener($event) { return ctx.update.emit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 13, "entitiesTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("active", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](18, 15, "_$.access.add"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("dataset", ctx.dataset)("state", ctx.state)("globalRule", ctx.globalRule)("usersProvider", ctx.usersProvider)("groupsProvider", ctx.groupsProvider);
    } }, styles: [".label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-small);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.values[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  gap: 10px 11px;\n  overflow: hidden auto;\n  max-height: 240px;\n}\n.values[_ngcontent-%COMP%]:not(:empty) {\n  padding: var(--sl-spacing-small) 0;\n}\nsl-tag[_ngcontent-%COMP%] {\n  max-width: 100%;\n  background-color: var(--sl-color-neutral-0);\n  border-radius: 20px;\n}\nsl-tag[_ngcontent-%COMP%]::part(base) {\n  height: 26px;\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button) {\n  margin-left: var(--sl-spacing-x-small);\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button__base) {\n  height: 16px;\n  width: 16px;\n}\nsl-tag[_ngcontent-%COMP%]::part(content) {\n  display: flex;\n  overflow: hidden;\n}\n.tag-name[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-950);\n  font-size: 13px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 8723:
/*!**************************************************************!*\
  !*** ./src/app/components/rule-access/rule-access.module.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RuleAccessModule": () => (/* binding */ RuleAccessModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rule-access.component */ 8034);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-track-by */ 1050);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rule-access-modal/rule-access-modal.component */ 8283);
/* harmony import */ var _access_access_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../access/access.module */ 3864);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);










class RuleAccessModule {
}
RuleAccessModule.ɵfac = function RuleAccessModule_Factory(t) { return new (t || RuleAccessModule)(); };
RuleAccessModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({ type: RuleAccessModule });
RuleAccessModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({ providers: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipe], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AvatarModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PaginationModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_7__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipeModule,
        _access_access_module__WEBPACK_IMPORTED_MODULE_2__.AccessModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetNgModuleScope"](RuleAccessModule, { declarations: [_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent, _rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__.RuleAccessModalComponent], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AvatarModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PaginationModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_7__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipeModule,
        _access_access_module__WEBPACK_IMPORTED_MODULE_2__.AccessModule], exports: [_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent] }); })();
_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetComponentScope"](_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent, [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyDirective, _rule_access_modal_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__.RuleAccessModalComponent], [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipe]);


/***/ }),

/***/ 8183:
/*!*****************************************!*\
  !*** ./src/app/constants/time-zones.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "timesZones": () => (/* binding */ timesZones)
/* harmony export */ });
const timesZones = [
    0, -60, -120, -180, -240, -300, -360, -420, -480, -540, -600, -660, -720,
    720, 660, 600, 540, 480, 420, 360, 300, 240, 180, 120, 60,
];


/***/ }),

/***/ 3916:
/*!***************************************************************************************************************************!*\
  !*** ./src/app/modals/add-repeat-data/add-repeat-data-conformation-modal/add-repeat-data-conformation-modal.component.ts ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddRepeatDataConformationModalComponent": () => (/* binding */ AddRepeatDataConformationModalComponent),
/* harmony export */   "ChangeDataRule": () => (/* binding */ ChangeDataRule),
/* harmony export */   "copyChangeRuleItem": () => (/* binding */ copyChangeRuleItem),
/* harmony export */   "copyDataColumn": () => (/* binding */ copyDataColumn)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 1640);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _add_repeat_data_conformation_rules_modal_add_repeat_data_conformation_rules_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../add-repeat-data-conformation-rules-modal/add-repeat-data-conformation-rules-modal.component */ 8015);
/* harmony import */ var _add_repeat_data_conformation_question_modal_add_repeat_data_conformation_question_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../add-repeat-data-conformation-question-modal/add-repeat-data-conformation-question-modal.component */ 5259);
/* harmony import */ var src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/enums/plugin */ 3762);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var src_app_api_data_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/api/data-api.service */ 9613);
/* harmony import */ var src_app_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/api/dataset-api.service */ 5640);













function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 20)(1, "div", 10)(2, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](5, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 22)(9, "sl-select", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-select", function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_1_Template_sl_select_sl_select_9_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r6.onRuleSelect($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](10, "sl-menu-item", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](13, "sl-menu-item", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](15, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](16, "sl-icon-button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_1_Template_sl_icon_button_click_16_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r7); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r8.onGearClick()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](4, 8, "rulesDataTitle"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](7, 10, "rulesDataText"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx_r4.changeDataRule);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx_r4.ChangeDataRule.FromLeftToRight);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](12, 12, "ruleSelect#leftright"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx_r4.ChangeDataRule.WithColumns);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](15, 14, "ruleSelect#columns"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx_r4.isGearDisabled);
} }
function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_tr_18_sl_icon_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "sl-icon", 11);
} if (rf & 2) {
    const columnData_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]().$implicit;
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("name", ctx_r12.getColumnTypeIcon(columnData_r11.typeInCurrent));
} }
function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_tr_18_sl_icon_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "sl-icon", 11);
} if (rf & 2) {
    const columnData_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]().$implicit;
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("name", ctx_r13.getColumnTypeIcon(columnData_r11.typeInTmp));
} }
function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_tr_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "tr")(1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](4, AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_tr_18_sl_icon_4_Template, 1, 1, "sl-icon", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](5, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](9, AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_tr_18_sl_icon_9_Template, 1, 1, "sl-icon", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](10, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const columnData_r11 = ctx.$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", columnData_r11.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", !!ctx_r10.getColumnTypeIcon(columnData_r11.typeInCurrent));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](7, 5, ctx_r10.getColumnTypeName(columnData_r11.typeInCurrent)));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", !!ctx_r10.getColumnTypeIcon(columnData_r11.typeInTmp));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](12, 7, ctx_r10.getColumnTypeName(columnData_r11.typeInTmp)));
} }
function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 31)(1, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 33)(5, "core-table", 34)(6, "thead")(7, "tr")(8, "th", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "th", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](13, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "th", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](16, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](17, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](18, AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_tr_18_Template, 13, 9, "tr", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
} if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](3, 5, "conformExplanation"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](10, 7, "conformFieldName"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](13, 9, "conformFieldDatasetType"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](16, 11, "conformFieldFileType"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngForOf", ctx_r9.columnsConformityData.columnsData);
} }
function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 26)(1, "sl-card")(2, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_Template_div_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r17); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r16.onCollapseConformClick()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](3, "sl-icon", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](7, "sl-icon", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](8, AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_div_8_Template, 19, 13, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](6, 3, "conformityDataWarning"));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("name", ctx_r5.expandIcon);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", !ctx_r5.isConformBlockCollapsed);
} }
function AddRepeatDataConformationModalComponent_ng_container_1_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](1, AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_1_Template, 17, 16, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](2, AddRepeatDataConformationModalComponent_ng_container_1_div_1_div_2_Template, 9, 5, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "div", 9)(4, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](5, "sl-icon", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](6, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "div", 13)(13, "app-add-repeat-data-conformation-table", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onDragDrop", function AddRepeatDataConformationModalComponent_ng_container_1_div_1_Template_app_add_repeat_data_conformation_table_onDragDrop_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r18.onDragDropColumn($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "div", 15)(15, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](16, "sl-icon", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](17, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](19, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](20, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](23, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](24, "app-add-repeat-data-conformation-table", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](25, "div", 17)(26, "sl-button", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddRepeatDataConformationModalComponent_ng_container_1_div_1_Template_sl_button_click_26_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r19); const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r20.onCancelClick()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](27);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](28, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](29, "sl-button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddRepeatDataConformationModalComponent_ng_container_1_div_1_Template_sl_button_click_29_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r19); const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r21.onNextClick()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](30);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](31, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", !ctx_r3.isAdding);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx_r3.needToShowConformBlock);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("name", ctx_r3.fileIcon);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](8, 26, "fileDataTitle"));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](11, 28, "firstRowsShown"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("isDragDrop", true)("columns", ctx_r3.tmpColumns)("rows", ctx_r3.tmpRows)("columnKeys", ctx_r3.tmpColumnKeys)("selectedColumnKeys", ctx_r3.tmpSelectedColumnKeys)("emptyState", ctx_r3.tmpEmptyState)("error", ctx_r3.tmpError);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("name", "hdd-stack");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](19, 30, "datasetDataTitle"));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](22, 32, "firstRowsShown"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("isDragDrop", false)("columns", ctx_r3.currentColumns)("rows", ctx_r3.currentRows)("columnKeys", ctx_r3.currentColumnKeys)("selectedColumnKeys", ctx_r3.currentSelectedColumnKeys)("emptyState", ctx_r3.currentEmptyState)("error", ctx_r3.currentError);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](28, 34, "cancelButtonLabel"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx_r3.isNextDisabled)("loading", ctx_r3.isNextLoading);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](31, 36, "nextButtonLabel"), " ");
} }
function AddRepeatDataConformationModalComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](1, AddRepeatDataConformationModalComponent_ng_container_1_div_1_Template, 32, 38, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", !ctx_r0.isLoading)("ngIfElse", _r1);
} }
function AddRepeatDataConformationModalComponent_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](1, "sl-spinner");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} }
var ChangeDataRule;
(function (ChangeDataRule) {
    ChangeDataRule[ChangeDataRule["FromLeftToRight"] = 0] = "FromLeftToRight";
    ChangeDataRule[ChangeDataRule["WithColumns"] = 1] = "WithColumns";
})(ChangeDataRule || (ChangeDataRule = {}));
const LIMIT = 15;
const DEFAULT_KEY = 'default';
class AddRepeatDataConformationModalComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__.SubscribableComponent {
    constructor(activatedRoute, dataApiService, datasetApiService, responseErrorService) {
        super();
        this.activatedRoute = activatedRoute;
        this.dataApiService = dataApiService;
        this.datasetApiService = datasetApiService;
        this.responseErrorService = responseErrorService;
        this.defaultKey = DEFAULT_KEY;
        this.ChangeDataRule = ChangeDataRule;
        this.onAddData = new _angular_core__WEBPACK_IMPORTED_MODULE_5__.EventEmitter();
        this.onEditData = new _angular_core__WEBPACK_IMPORTED_MODULE_5__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_5__.EventEmitter();
        this.isLoading = false;
        this.isNextLoading = false;
        this.isAdding = false;
        this.isOpen = false;
        this.datasetIds = { tmp: 0, current: 0 };
        this.fileType = '';
        this.changeDataRule = ChangeDataRule.FromLeftToRight;
        this.tmpRows = [];
        this.currentRows = [];
        this.prevTmpColumns = [];
        this.tmpColumns = [];
        this.prevCurrentColumns = [];
        this.currentColumns = [];
        this.tmpColumnKeys = [];
        this.currentColumnKeys = [];
        this.tmpSelectedColumnKeys = new Set();
        this.currentSelectedColumnKeys = new Set();
        this.tmpEmptyState = false;
        this.currentEmptyState = false;
        this.isMoreColumnsInFile = false;
        this.isMoreColumnsInDataset = false;
        this.dragDropCortage = [];
        this.changeRuleList = [];
        this.columnsConformityData = {
            isConform: true,
            columnsData: [],
        };
        this.isConformBlockCollapsed = true;
        this.total = 0;
        this.offset = 0;
        this.httpError = (response) => {
            this.isLoading = false;
            this.isNextLoading = false;
            this.responseErrorService.show.emit({
                responseError: response,
                key: 'datasetLoadError',
            });
        };
    }
    get expandIcon() {
        return this.isConformBlockCollapsed ? 'chevron-right' : 'chevron-down';
    }
    get fileIcon() {
        switch (this.fileType) {
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_2__.PluginFileType.Csv:
            default:
                return 'filetype-csv';
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_2__.PluginFileType.Xls:
                return 'filetype-xls';
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_2__.PluginFileType.Json:
                return 'filetype-json';
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_2__.PluginFileType.Xml:
                return 'filetype-xml';
        }
    }
    get isNextDisabled() {
        return !this.columnsConformityData.isConform;
    }
    get isGearDisabled() {
        return this.changeDataRule !== ChangeDataRule.WithColumns;
    }
    get needToShowConformBlock() {
        return (!this.columnsConformityData.isConform &&
            this.columnsConformityData.columnsData.length > 0);
    }
    ngOnInit() {
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe((params) => {
                this.offset = Number(params.offset);
                if (this.fileType && params.limit) {
                    this.onNextClick();
                }
            }),
        ];
    }
    show(isAdding, datasetIds, fileType) {
        this.isAdding = isAdding;
        this.datasetIds = datasetIds;
        this.fileType = fileType;
        this.isOpen = true;
        this.dragDropCortage = [];
        this.loadData();
    }
    hide() {
        this.isOpen = false;
    }
    getColumnTypeIcon(type) {
        switch (type) {
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Boolean:
                return 'toggles';
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.String:
                return 'type';
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Number:
                return 'hash';
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Date:
                return 'calendar3';
            default:
                return '';
        }
    }
    getColumnTypeName(type) {
        switch (type) {
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Boolean:
                return 'conformBooleanName';
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.String:
                return 'conformStringName';
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Number:
                return 'conformNumberName';
            case plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Date:
                return 'conformDateName';
            default:
                return 'conformEmptyName';
        }
    }
    onRuleSelect(event) {
        this.changeDataRule = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.valueOf)(event);
        if (this.changeDataRule === ChangeDataRule.WithColumns) {
            this.rulesModal.show();
        }
        this.checkColumnsConformity();
    }
    onGearClick() {
        this.rulesModal.show();
    }
    onCollapseConformClick() {
        this.isConformBlockCollapsed = !this.isConformBlockCollapsed;
    }
    onCancelClick() {
        this.isOpen = false;
        this.onCancel.emit();
    }
    onNextClick() {
        if (this.isAdding) {
            this.preAddData();
        }
        else {
            this.preChangeData();
        }
    }
    onApplyChangeRules(data) {
        this.changeRuleList = data.map((item) => copyChangeRuleItem(item));
        this.checkColumnsConformity();
    }
    onAnswerHandler(keepColumns) {
        this.preChangeDataRequest(true, keepColumns);
    }
    loadData() {
        this.isLoading = true;
        let observables = [
            this.getDatasetLoadObservable(this.datasetIds.tmp),
            this.getDatasetLoadObservable(this.datasetIds.current),
        ];
        (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.forkJoin)(observables).subscribe({
            next: (data) => {
                this.isLoading = false;
                const tmpResponse = data[0];
                const currentResponse = data[1];
                this.setTmpData(tmpResponse);
                this.setCurrentData(currentResponse);
                this.checkColumnsConformity();
                this.setIsMoreColumns();
            },
            error: this.httpError,
        });
    }
    getDatasetLoadObservable(datasetId) {
        return this.dataApiService.dataset({
            data_options: [
                {
                    key: this.defaultKey,
                    dataset_id: datasetId,
                    method: 'table',
                    offset: 0,
                    limit: LIMIT,
                },
            ],
            get_columns: true,
            get_dataset: false,
        });
    }
    preAddData() {
        const datasetId = this.datasetIds.current;
        const requestParams = {
            internal_dataset_id: this.datasetIds.tmp,
            get_columns: true,
            permutation_list: this.dragDropCortage,
            limit: 100,
            offset: this.offset,
        };
        this.isNextLoading = true;
        this.datasetApiService
            .preInsertData(datasetId, requestParams)
            .subscribe({
            next: ({ total, rows, columns }) => {
                this.isNextLoading = false;
                this.onAddData.emit({
                    request: requestParams,
                    rows: rows,
                    columns: columns,
                    total: total,
                });
            },
            error: this.httpError,
        });
    }
    preChangeData() {
        if (this.changeDataRule === ChangeDataRule.FromLeftToRight &&
            (this.isMoreColumnsInDataset || this.isMoreColumnsInFile)) {
            this.questionModal.show();
        }
        else {
            this.preChangeDataRequest(false);
        }
    }
    preChangeDataRequest(needToSetKeepColumns, keepColumns = false) {
        const datasetId = this.datasetIds.current;
        const requestParams = {
            internal_dataset_id: this.datasetIds.tmp,
            get_columns: true,
            permutation_list: this.dragDropCortage,
            limit: 100,
            offset: this.offset,
        };
        if (needToSetKeepColumns) {
            requestParams.keep_columns = keepColumns;
        }
        if (this.changeDataRule === ChangeDataRule.WithColumns &&
            this.changeRuleList.length > 0) {
            requestParams.columns_to_override = this.prepareColumnsToOverride();
        }
        this.isNextLoading = true;
        this.datasetApiService
            .preOverrideData(datasetId, requestParams)
            .subscribe({
            next: ({ total, rows, columns }) => {
                this.isNextLoading = false;
                this.onEditData.emit({
                    request: requestParams,
                    rows: rows,
                    columns: columns,
                    total: total,
                });
            },
            error: this.httpError,
        });
    }
    setTmpData(response) {
        this.setResponseData(response, true);
        this.prevTmpColumns = this.tmpColumns.map((item) => copyDataColumn(item));
    }
    setCurrentData(response) {
        this.setResponseData(response, false);
        this.prevCurrentColumns = this.currentColumns.map((item) => copyDataColumn(item));
    }
    setResponseData(response, isTmp) {
        const errorKey = isTmp ? 'tmpError' : 'currentError';
        const emptyStateKey = isTmp ? 'tmpEmptyState' : 'currentEmptyState';
        const rowsKey = isTmp ? 'tmpRows' : 'currentRows';
        const columnsKey = isTmp ? 'tmpColumns' : 'currentColumns';
        const columnKeysKey = isTmp ? 'tmpColumnKeys' : 'currentColumnKeys';
        const selectedColumnKeysKey = isTmp
            ? 'tmpSelectedColumnKeys'
            : 'currentSelectedColumnKeys';
        if ('httpCode' in response[this.defaultKey]) {
            this[errorKey] = this.getErrorMessage(response[this.defaultKey].httpCode);
            this.isLoading = false;
            this[emptyStateKey] = false;
            return;
        }
        const { rows, columns } = response[this.defaultKey];
        this[rowsKey] = rows;
        this[columnsKey] = columns;
        for (let i in columns) {
            this[columnKeysKey].push(columns[i].key);
        }
        this[selectedColumnKeysKey] = new Set(Object.values(this[columnKeysKey]));
        this.isLoading = false;
    }
    prepareColumnsToOverride() {
        const fileColumnIds = (this.prevTmpColumns || []).map((item) => item.column.id);
        const datasetColumnIds = (this.prevCurrentColumns || []).map((item) => item.column.id);
        let result = {};
        this.changeRuleList.forEach((item) => {
            const fileColumnId = item.fileColumn.column.id;
            const datasetColumnId = item.datasetColumn.column.id;
            const fileColumnIndex = fileColumnIds.indexOf(fileColumnId);
            const datasetColumnIndex = datasetColumnIds.indexOf(datasetColumnId);
            result[String(datasetColumnIndex)] = fileColumnIndex;
        });
        return result;
    }
    onDragDropColumn(data) {
        this.dragDropCortage.push(data);
        this.checkColumnsConformity();
    }
    checkColumnsConformity() {
        const datasetColumnIdsInChangeRules = (this.changeRuleList || []).map((item) => item.datasetColumn.column.id);
        let isConform = true;
        let columnsData = [];
        this.prevCurrentColumns.forEach((column, index) => {
            var _a;
            const currentColumnData = column.column;
            const tmpColumnData = (_a = this.tmpColumns[index]) === null || _a === void 0 ? void 0 : _a.column;
            const tmpType = tmpColumnData === null || tmpColumnData === void 0 ? void 0 : tmpColumnData.base_type;
            const currentType = currentColumnData.base_type;
            const leftRightCondition = this.isAdding ||
                this.changeDataRule === ChangeDataRule.FromLeftToRight;
            const withColumnsCondition = leftRightCondition
                ? true
                : datasetColumnIdsInChangeRules.includes(currentColumnData.id);
            if (withColumnsCondition &&
                !!tmpType &&
                currentType !== tmpType &&
                this.changeDataRule !== ChangeDataRule.WithColumns) {
                isConform = false;
                columnsData.push({
                    name: currentColumnData.name,
                    typeInTmp: tmpType,
                    typeInCurrent: currentType,
                });
            }
        });
        this.columnsConformityData = { isConform, columnsData };
    }
    setIsMoreColumns() {
        this.isMoreColumnsInFile =
            this.tmpColumns.length > this.currentColumns.length;
        this.isMoreColumnsInDataset =
            this.tmpColumns.length < this.currentColumns.length;
    }
    getErrorMessage(code) {
        if (code === 403 /* HttpStatusCode.Forbidden */) {
            return `dataset.error.forbidden`;
        }
        return '';
    }
}
AddRepeatDataConformationModalComponent.ɵfac = function AddRepeatDataConformationModalComponent_Factory(t) { return new (t || AddRepeatDataConformationModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](src_app_api_data_api_service__WEBPACK_IMPORTED_MODULE_3__.DataApiService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](src_app_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ResponseErrorService)); };
AddRepeatDataConformationModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({ type: AddRepeatDataConformationModalComponent, selectors: [["app-add-repeat-data-conformation-modal"]], viewQuery: function AddRepeatDataConformationModalComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_add_repeat_data_conformation_rules_modal_add_repeat_data_conformation_rules_modal_component__WEBPACK_IMPORTED_MODULE_0__.AddRepeatDataConformationRulesModalComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_add_repeat_data_conformation_question_modal_add_repeat_data_conformation_question_modal_component__WEBPACK_IMPORTED_MODULE_1__.AddRepeatDataConformationQuestionModalComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.rulesModal = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.questionModal = _t.first);
    } }, outputs: { onAddData: "onAddData", onEditData: "onEditData", onCancel: "onCancel" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵInheritDefinitionFeature"]], decls: 6, vars: 7, consts: [[1, "main-dialog", 3, "open", "openChange"], [4, "ngIf"], [3, "fileIcon", "fileColumns", "datasetColumns", "data", "onApply"], [3, "isMore", "onAnswer"], ["loadingBlock", ""], ["class", "common-container", 4, "ngIf", "ngIfElse"], [1, "common-container"], ["class", "container rules-data", 4, "ngIf"], ["class", "container conform-data", 4, "ngIf"], [1, "container", "file-data"], [1, "title"], [3, "name"], [1, "sub-title"], [1, "table"], [3, "isDragDrop", "columns", "rows", "columnKeys", "selectedColumnKeys", "emptyState", "error", "onDragDrop"], [1, "container", "dataset-data"], [3, "isDragDrop", "columns", "rows", "columnKeys", "selectedColumnKeys", "emptyState", "error"], [1, "cancel"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", 1, "next", 3, "disabled", "loading", "click"], [1, "container", "rules-data"], [1, "main-title"], [1, "select"], ["hoist", "", 3, "value", "sl-select"], [3, "value"], ["name", "gear", 3, "disabled", "click"], [1, "container", "conform-data"], [1, "header", 3, "click"], ["name", "exclamation-circle"], [1, "expand", 3, "name"], ["class", "content", 4, "ngIf"], [1, "content"], [1, "explanation"], [1, "fields"], ["tableMaxHeight", "20vh", "inSlDialog", "true"], ["width", "30vw"], ["width", "5vw"], [4, "ngFor", "ngForOf"], [3, "name", 4, "ngIf"], [1, "spinner-container"]], template: function AddRepeatDataConformationModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("openChange", function AddRepeatDataConformationModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](1, AddRepeatDataConformationModalComponent_ng_container_1_Template, 2, 2, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "app-add-repeat-data-conformation-rules-modal", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onApply", function AddRepeatDataConformationModalComponent_Template_app_add_repeat_data_conformation_rules_modal_onApply_2_listener($event) { return ctx.onApplyChangeRules($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "app-add-repeat-data-conformation-question-modal", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onAnswer", function AddRepeatDataConformationModalComponent_Template_app_add_repeat_data_conformation_question_modal_onAnswer_3_listener($event) { return ctx.onAnswerHandler($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](4, AddRepeatDataConformationModalComponent_ng_template_4_Template, 2, 0, "ng-template", null, 4, _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("fileIcon", ctx.fileIcon)("fileColumns", ctx.prevTmpColumns)("datasetColumns", ctx.prevCurrentColumns)("data", ctx.changeRuleList);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("isMore", ctx.isMoreColumnsInFile);
    } }, styles: ["[_nghost-%COMP%]   sl-dialog.main-dialog[_ngcontent-%COMP%]::part(panel) {\n  width: 100%;\n  background-color: var(--core-background);\n}\n[_nghost-%COMP%]   sl-dialog.main-dialog[_ngcontent-%COMP%]::part(base) {\n  padding: 0;\n}\n[_nghost-%COMP%]   sl-dialog.main-dialog[_ngcontent-%COMP%]::part(panel) {\n  min-height: 100%;\n  width: 100%;\n  max-width: 100%;\n  border-radius: 0;\n  background-color: var(--core-background);\n}\n[_nghost-%COMP%]   sl-dialog.main-dialog[_ngcontent-%COMP%]::part(header) {\n  display: none;\n}\n.common-container[_ngcontent-%COMP%]   .container.rules-data[_ngcontent-%COMP%] {\n  margin-top: 25px;\n  margin-bottom: 40px;\n}\n.common-container[_ngcontent-%COMP%]   .container.rules-data[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   .main-title[_ngcontent-%COMP%] {\n  font-weight: bold;\n  font-size: var(--sl-font-size-small);\n  padding-left: 0;\n  color: var(--sl-color-neutral-1000);\n}\n.common-container[_ngcontent-%COMP%]   .container.rules-data[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   .sub-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n}\n.common-container[_ngcontent-%COMP%]   .container.rules-data[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%] {\n  margin-top: 10px;\n  width: 50%;\n  display: flex;\n  justify-content: flex-start;\n}\n.common-container[_ngcontent-%COMP%]   .container.rules-data[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%] {\n  width: 93%;\n}\n.common-container[_ngcontent-%COMP%]   .container.rules-data[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%] {\n  margin-left: auto;\n  font-size: var(--sl-font-size-large);\n  margin-top: 2px;\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%] {\n  margin-top: 25px;\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: flex;\n  justify-content: flex-start;\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  vertical-align: middle;\n  color: var(--sl-color-danger-600);\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   sl-icon.expand[_ngcontent-%COMP%] {\n  margin-left: auto;\n  color: var(--sl-color-neutral-1000);\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  color: var(--sl-color-danger-600);\n  padding-left: 10px;\n  font-size: var(--sl-font-size-small);\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%] {\n  margin-top: 10px;\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]   .explanation[_ngcontent-%COMP%] {\n  color: var(--sl-color-gray-400);\n  font-size: var(--sl-font-size-small);\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%] {\n  margin-top: 15px;\n}\n.common-container[_ngcontent-%COMP%]   .container.conform-data[_ngcontent-%COMP%]   sl-card[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   td[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  padding-left: 10px;\n}\n.common-container[_ngcontent-%COMP%]   .container.file-data[_ngcontent-%COMP%] {\n  margin-top: 25px;\n}\n.common-container[_ngcontent-%COMP%]   .container.dataset-data[_ngcontent-%COMP%] {\n  margin-top: 50px;\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-x-large);\n  vertical-align: text-bottom;\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  padding-left: 10px;\n  font-size: var(--sl-font-size-large);\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   div[_ngcontent-%COMP%] {\n  color: var(--sl-color-gray-400);\n  font-size: var(--sl-font-size-small);\n  margin-top: 10px;\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%] {\n  margin-top: 10px;\n  border-radius: 10px;\n}\n.common-container[_ngcontent-%COMP%]   .cancel[_ngcontent-%COMP%] {\n  margin-top: 25px;\n  display: flex;\n  justify-content: flex-end;\n}\n.common-container[_ngcontent-%COMP%]   .cancel[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:last-child {\n  margin-left: 10px;\n}\n.spinner-container[_ngcontent-%COMP%] {\n  padding-top: 90px;\n  text-align: center;\n}\n.spinner-container[_ngcontent-%COMP%]   sl-spinner[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-3x-large);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
function copyChangeRuleItem(item) {
    const fileColumn = Object.assign(Object.assign({}, item.fileColumn), { column: Object.assign({}, item.fileColumn.column) });
    const datasetColumn = Object.assign(Object.assign({}, item.datasetColumn), { column: Object.assign({}, item.datasetColumn.column) });
    return { fileColumn, datasetColumn };
}
function copyDataColumn(item) {
    return Object.assign(Object.assign({}, item), { column: Object.assign({}, item.column) });
}


/***/ }),

/***/ 60:
/*!*************************************************************************************************************************************************************************!*\
  !*** ./src/app/modals/add-repeat-data/add-repeat-data-conformation-modal/components/add-repeat-data-conformation-table/add-repeat-data-conformation-table.component.ts ***!
  \*************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddRepeatDataConformationTableComponent": () => (/* binding */ AddRepeatDataConformationTableComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/cdk/drag-drop */ 4941);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/cdk/scrolling */ 5752);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);







function AddRepeatDataConformationTableComponent_div_0_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "th", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "core-column-name", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const column_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("column", column_r5.column);
} }
function AddRepeatDataConformationTableComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div")(1, "core-table")(2, "thead")(3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, AddRepeatDataConformationTableComponent_div_0_ng_container_4_Template, 3, 1, "ng-container", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "tbody")(6, "tr")(7, "td", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()()()();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r0.columns);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("colspan", ctx_r0.columns.length);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](9, 3, ctx_r0.error), " ");
} }
const _c0 = function (a0) { return { hidden: a0 }; };
function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_ng_container_3_th_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "div", 12)(2, "core-column-name", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const indexedColumn_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("cdkDragData", indexedColumn_r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](3, _c0, !ctx_r10.isDragDrop));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("column", indexedColumn_r9.column);
} }
function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_ng_container_3_th_1_Template, 3, 5, "th", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const indexedColumn_r9 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r7.selectedColumnKeys.has(indexedColumn_r9.key));
} }
function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_tr_5_ng_container_1_td_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const indexedColumn_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const row_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", row_r12[ctx_r15.getIndexedColumnKey(indexedColumn_r14.key)], " ");
} }
function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_tr_5_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_tr_5_ng_container_1_td_1_Template, 2, 1, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const indexedColumn_r14 = ctx.$implicit;
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r13.selectedColumnKeys.has(indexedColumn_r14.key));
} }
function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_tr_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_tr_5_ng_container_1_Template, 2, 1, "ng-container", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r8.columns);
} }
function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "core-table", 8)(1, "thead")(2, "tr", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("cdkDropListDropped", function AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_Template_tr_cdkDropListDropped_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r18.onDrop($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_ng_container_3_Template, 2, 1, "ng-container", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_tr_5_Template, 2, 1, "tr", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("max-height", ctx_r6.tableHeight);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("total", ctx_r6.total)("limit", ctx_r6.limit);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("cdkDropListData", ctx_r6.columns);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r6.columns);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r6.rows);
} }
function AddRepeatDataConformationTableComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, AddRepeatDataConformationTableComponent_ng_template_1_core_table_0_Template, 6, 7, "core-table", 7);
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r2.emptyState);
} }
function AddRepeatDataConformationTableComponent_core_empty_state_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "core-empty-state", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "translate");
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](1, 1, "noData"));
} }
const BIG_TABLE_HEIGHT = '70vh';
const SMALL_TABLE_HEIGHT = '30vh';
class AddRepeatDataConformationTableComponent {
    constructor() {
        this.isBigTable = false;
        this.isDragDrop = false;
        this.columns = [];
        this.rows = [];
        this.total = 0;
        this.columnKeys = [];
        this.selectedColumnKeys = new Set();
        this.emptyState = false;
        this.onDragDrop = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.limit = 100;
    }
    get tableHeight() {
        return this.isBigTable ? BIG_TABLE_HEIGHT : SMALL_TABLE_HEIGHT;
    }
    getIndexedColumnKey(key) {
        if (this.isBigTable) {
            return 'col_' + String(key);
        }
        else {
            return String(key);
        }
    }
    onDrop(event) {
        if (event.previousContainer === event.container) {
            (0,_angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_1__.moveItemInArray)(event.container.data, event.previousIndex, event.currentIndex);
        }
        else {
            (0,_angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_1__.transferArrayItem)(event.previousContainer.data, event.container.data, event.previousIndex, event.currentIndex);
        }
        this.onDragDrop.emit([event.previousIndex, event.currentIndex]);
    }
}
AddRepeatDataConformationTableComponent.ɵfac = function AddRepeatDataConformationTableComponent_Factory(t) { return new (t || AddRepeatDataConformationTableComponent)(); };
AddRepeatDataConformationTableComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AddRepeatDataConformationTableComponent, selectors: [["app-add-repeat-data-conformation-table"]], inputs: { isBigTable: "isBigTable", isDragDrop: "isDragDrop", columns: "columns", rows: "rows", total: "total", columnKeys: "columnKeys", selectedColumnKeys: "selectedColumnKeys", emptyState: "emptyState", error: "error" }, outputs: { onDragDrop: "onDragDrop" }, decls: 4, vars: 3, consts: [[4, "ngIf", "ngIfElse"], ["table", ""], ["imageSrc", "/assets/images/home-default.svg", 3, "title", 4, "ngIf"], [4, "ngFor", "ngForOf"], [1, "error-text"], ["width", "10vw"], [3, "column"], ["cdkScrollable", "", 3, "total", "limit", "max-height", 4, "ngIf"], ["cdkScrollable", "", 3, "total", "limit"], ["cdkDropList", "", "cdkDropListOrientation", "horizontal", 3, "cdkDropListData", "cdkDropListDropped"], ["width", "10vw", "cdkDrag", "", 3, "cdkDragData", 4, "ngIf"], ["width", "10vw", "cdkDrag", "", 3, "cdkDragData"], ["cdkDragHandle", "", 1, "drag-drop-handler", 3, "ngClass"], ["maxWidth", "20vw", 4, "ngIf"], ["maxWidth", "20vw"], ["imageSrc", "/assets/images/home-default.svg", 3, "title"]], template: function AddRepeatDataConformationTableComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, AddRepeatDataConformationTableComponent_div_0_Template, 10, 5, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, AddRepeatDataConformationTableComponent_ng_template_1_Template, 1, 1, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, AddRepeatDataConformationTableComponent_core_empty_state_3_Template, 2, 3, "core-empty-state", 2);
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.error)("ngIfElse", _r1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.emptyState);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.NgClass, _angular_common__WEBPACK_IMPORTED_MODULE_2__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_2__.NgIf, _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_3__.CdkScrollable, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_1__.CdkDropList, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_1__.CdkDrag, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_1__.CdkDragHandle, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnNameComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.WidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.EmptyStateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  position: relative;\n}\n.column-type[_ngcontent-%COMP%] {\n  display: block;\n  color: var(--sl-color-gray-400);\n}\n.error-text[_ngcontent-%COMP%] {\n  color: var(--sl-color-info-500);\n  text-align: center;\n  padding: 24px 0;\n}\ncore-table[_ngcontent-%COMP%] {\n  display: block;\n  background-color: var(--sl-panel-background-color);\n  box-shadow: 0 5px 16px 3px #e5e6eb;\n  border: solid 1px var(--sl-color-neutral-200);\n  border-radius: 10px;\n  overflow: auto;\n}\ncore-table[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  position: relative;\n}\ncore-table[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]   .drag-drop-handler[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 12px;\n  left: 8px;\n  cursor: move;\n  width: 4px;\n  height: 11px;\n  background: url('/assets/images/dataset/dragdrop.png');\n}\ncore-table[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]   .drag-drop-handler.hidden[_ngcontent-%COMP%] {\n  display: none;\n}\ncore-table[_ngcontent-%COMP%]     .card {\n  display: contents;\n}\ncore-table[_ngcontent-%COMP%]     core-pagination {\n  position: absolute;\n  right: 0;\n  bottom: -38px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 5259:
/*!*********************************************************************************************************************************************!*\
  !*** ./src/app/modals/add-repeat-data/add-repeat-data-conformation-question-modal/add-repeat-data-conformation-question-modal.component.ts ***!
  \*********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddRepeatDataConformationQuestionModalComponent": () => (/* binding */ AddRepeatDataConformationQuestionModalComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);




class AddRepeatDataConformationQuestionModalComponent {
    constructor() {
        this.isMore = true;
        this.onAnswer = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.isOpen = false;
    }
    show() {
        this.isOpen = true;
    }
    getQuestionText() {
        return this.isMore
            ? 'numColumnsQuestion#more'
            : 'numColumnsQuestion#less';
    }
    getCancelText() {
        return this.isMore
            ? 'numColumnsQuestion#cancel-more'
            : 'numColumnsQuestion#cancel-less';
    }
    getApplyText() {
        return this.isMore
            ? 'numColumnsQuestion#apply-more'
            : 'numColumnsQuestion#apply-less';
    }
    onCancelClick() {
        this.isOpen = false;
        this.onAnswer.emit(false);
    }
    onApplyClick() {
        this.isOpen = false;
        this.onAnswer.emit(true);
    }
}
AddRepeatDataConformationQuestionModalComponent.ɵfac = function AddRepeatDataConformationQuestionModalComponent_Factory(t) { return new (t || AddRepeatDataConformationQuestionModalComponent)(); };
AddRepeatDataConformationQuestionModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AddRepeatDataConformationQuestionModalComponent, selectors: [["app-add-repeat-data-conformation-question-modal"]], inputs: { isMore: "isMore" }, outputs: { onAnswer: "onAnswer" }, decls: 12, vars: 13, consts: [[3, "label", "open", "openChange"], [1, "container"], [1, "buttons"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", 3, "click"]], template: function AddRepeatDataConformationQuestionModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("openChange", function AddRepeatDataConformationQuestionModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 2)(6, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function AddRepeatDataConformationQuestionModalComponent_Template_sl_button_click_6_listener() { return ctx.onCancelClick(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](8, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function AddRepeatDataConformationQuestionModalComponent_Template_sl_button_click_9_listener() { return ctx.onApplyClick(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](1, 5, "numColumnsQuestion#title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](4, 7, ctx.getQuestionText()), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](8, 9, ctx.getCancelText()), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](11, 11, ctx.getApplyText()), " ");
    } }, dependencies: [shoelace_style_angular__WEBPACK_IMPORTED_MODULE_1__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_1__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_1__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.TranslatePipe], styles: [".buttons[_ngcontent-%COMP%] {\n  margin-top: 25px;\n  display: flex;\n  justify-content: flex-end;\n}\n.buttons[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:last-child {\n  margin-left: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1yZXBlYXQtZGF0YS1jb25mb3JtYXRpb24tcXVlc3Rpb24tbW9kYWwuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxnQkFBQTtFQUNBLGFBQUE7RUFDQSx5QkFBQTtBQUNKO0FBQ0k7RUFDSSxpQkFBQTtBQUNSIiwiZmlsZSI6ImFkZC1yZXBlYXQtZGF0YS1jb25mb3JtYXRpb24tcXVlc3Rpb24tbW9kYWwuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnV0dG9ucyB7XG4gICAgbWFyZ2luLXRvcDogMjVweDtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZmxleC1lbmQ7XG5cbiAgICAmIHNsLWJ1dHRvbjpsYXN0LWNoaWxkIHtcbiAgICAgICAgbWFyZ2luLWxlZnQ6IDEwcHg7XG4gICAgfVxufVxuIl19 */"] });


/***/ }),

/***/ 8015:
/*!***************************************************************************************************************************************!*\
  !*** ./src/app/modals/add-repeat-data/add-repeat-data-conformation-rules-modal/add-repeat-data-conformation-rules-modal.component.ts ***!
  \***************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddRepeatDataConformationRulesModalComponent": () => (/* binding */ AddRepeatDataConformationRulesModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../add-repeat-data-conformation-modal/add-repeat-data-conformation-modal.component */ 3916);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);









function AddRepeatDataConformationRulesModalComponent_div_19_sl_menu_item_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "core-column-type-icon", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const fileColumn_r6 = ctx.$implicit;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", fileColumn_r6.column.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r4.getColumnName(fileColumn_r6.column), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("column", fileColumn_r6.column);
} }
function AddRepeatDataConformationRulesModalComponent_div_19_sl_menu_item_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](2, "core-column-type-icon", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const datasetColumn_r7 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", datasetColumn_r7.column.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r5.getColumnName(datasetColumn_r7.column), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("column", datasetColumn_r7.column);
} }
function AddRepeatDataConformationRulesModalComponent_div_19_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 15)(1, "div", 5)(2, "sl-select", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-select", function AddRepeatDataConformationRulesModalComponent_div_19_Template_sl_select_sl_select_2_listener($event) { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9); const i_r3 = restoredCtx.index; const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r8.onChangeItem($event, i_r3, true)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "core-column-type-icon", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, AddRepeatDataConformationRulesModalComponent_div_19_sl_menu_item_5_Template, 3, 3, "sl-menu-item", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](6, "sl-icon", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 7)(8, "sl-select", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-select", function AddRepeatDataConformationRulesModalComponent_div_19_Template_sl_select_sl_select_8_listener($event) { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9); const i_r3 = restoredCtx.index; const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r10.onChangeItem($event, i_r3, false)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "core-column-type-icon", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, AddRepeatDataConformationRulesModalComponent_div_19_sl_menu_item_11_Template, 3, 3, "sl-menu-item", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "sl-icon-button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function AddRepeatDataConformationRulesModalComponent_div_19_Template_sl_icon_button_click_12_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r9); const i_r3 = restoredCtx.index; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onDeleteItem(i_r3)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const item_r2 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", ctx_r0.getFileColumn(item_r2)["id"])("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 8, "rulesDataSelectColumn"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("column", ctx_r0.getFileColumn(item_r2));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r0.fileColumns);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", ctx_r0.getDatasetColumn(item_r2)["id"])("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 10, "rulesDataSelectColumn"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("column", ctx_r0.getDatasetColumn(item_r2));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r0.datasetColumns);
} }
function AddRepeatDataConformationRulesModalComponent_div_24_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "sl-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 1, "conformityDataWarning"));
} }
class AddRepeatDataConformationRulesModalComponent {
    constructor(translateService) {
        this.translateService = translateService;
        this.fileIcon = 'filetype-csv';
        this.fileColumns = [];
        this.datasetColumns = [];
        this.data = [];
        this.onApply = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.tmpData = [];
        this.isOpen = false;
        this.showError = false;
    }
    get isApplyDisabled() {
        return this.tmpData.length < 1;
    }
    show() {
        this.setData();
        this.isOpen = true;
    }
    getFileColumn(rule) {
        return rule.fileColumn.column;
    }
    getDatasetColumn(rule) {
        return rule.datasetColumn.column;
    }
    onAddItem() {
        if (this.fileColumns.length < 0 || this.datasetColumns.length < 0) {
            return;
        }
        this.tmpData.push((0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)({
            fileColumn: this.fileColumns[0],
            datasetColumn: this.datasetColumns[0],
        }));
    }
    onDeleteItem(index) {
        let result = [];
        this.tmpData.forEach((item, num) => {
            if (index !== num) {
                result.push((0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)(item));
            }
        });
        this.tmpData = result;
    }
    onChangeItem(event, index, isFile) {
        const currentItem = this.tmpData[index];
        if (!currentItem) {
            return;
        }
        const columnId = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.valueOf)(event);
        const columns = (isFile ? this.fileColumns : this.datasetColumns) || [];
        const column = columns.find((item) => columnId === item.column.id);
        if (!column) {
            return;
        }
        let result = [];
        this.tmpData.forEach((item, num) => {
            if (index !== num) {
                result.push((0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)(item));
            }
            else {
                const ruleKey = isFile ? 'fileColumn' : 'datasetColumn';
                const changedRule = Object.assign(Object.assign({}, item), { [ruleKey]: column });
                result.push((0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)(changedRule));
            }
        });
        this.tmpData = result;
        const data = result.map((item) => (0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)(item));
        this.showError = data.some((value) => value.datasetColumn.column.base_type !==
            value.fileColumn.column.base_type);
    }
    onCancelClick() {
        this.isOpen = false;
    }
    onApplyClick() {
        const data = this.tmpData.map((item) => (0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)(item));
        this.showError = data.some((value) => value.datasetColumn.column.base_type !==
            value.fileColumn.column.base_type);
        if (!this.showError) {
            this.isOpen = false;
            this.onApply.emit(data);
        }
    }
    setData() {
        if (this.fileColumns.length < 0 || this.datasetColumns.length < 0) {
            return;
        }
        const dataLength = this.data.length;
        if (dataLength < 1) {
            this.tmpData = [
                (0,_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_0__.copyChangeRuleItem)({
                    fileColumn: this.fileColumns[0],
                    datasetColumn: this.datasetColumns[0],
                }),
            ];
            return;
        }
        this.tmpData = [...this.data];
    }
    getColumnName(column) {
        return column.name.split(' ').join('')
            ? column.name
            : this.translateService.getTranslation('rulesEmptyColumn', {
                number: column.source_path,
            });
    }
}
AddRepeatDataConformationRulesModalComponent.ɵfac = function AddRepeatDataConformationRulesModalComponent_Factory(t) { return new (t || AddRepeatDataConformationRulesModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.TranslateService)); };
AddRepeatDataConformationRulesModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: AddRepeatDataConformationRulesModalComponent, selectors: [["app-add-repeat-data-conformation-rules-modal"]], inputs: { fileIcon: "fileIcon", fileColumns: "fileColumns", datasetColumns: "datasetColumns", data: "data" }, outputs: { onApply: "onApply" }, decls: 32, vars: 29, consts: [[3, "label", "open", "openChange"], [1, "sub-header"], [1, "container"], [1, "table"], [1, "title"], [1, "file"], [3, "name"], [1, "dataset"], [1, "data"], ["class", "item", 4, "ngFor", "ngForOf"], [1, "add-item", 3, "click"], ["class", "error", 4, "ngIf"], [1, "buttons"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", 3, "disabled", "click"], [1, "item"], ["hoist", "", 3, "value", "placeholder", "sl-select"], ["slot", "prefix", 3, "column"], [3, "value", 4, "ngFor", "ngForOf"], ["name", "arrow-bar-right"], ["name", "x", 3, "click"], [3, "value"], [1, "error"], ["name", "exclamation-circle"]], template: function AddRepeatDataConformationRulesModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("openChange", function AddRepeatDataConformationRulesModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 2)(6, "div", 3)(7, "div", 4)(8, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](9, "sl-icon", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](12, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "sl-icon", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](19, AddRepeatDataConformationRulesModalComponent_div_19_Template, 13, 12, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function AddRepeatDataConformationRulesModalComponent_Template_div_click_20_listener() { return ctx.onAddItem(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](23, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](24, AddRepeatDataConformationRulesModalComponent_div_24_Template, 5, 3, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "div", 12)(26, "sl-button", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function AddRepeatDataConformationRulesModalComponent_Template_sl_button_click_26_listener() { return ctx.onCancelClick(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "sl-button", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function AddRepeatDataConformationRulesModalComponent_Template_sl_button_click_29_listener() { return ctx.onApplyClick(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](30);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](31, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](1, 15, "repeatChangeRules#title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 17, "rulesDataSubHeader"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("type-error", ctx.showError);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx.fileIcon);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](12, 19, "rulesDataFile"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", "hdd-stack");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 21, "rulesDataDataset"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.tmpData);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](23, 23, "rulesDataAdd"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.showError);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](28, 25, "cancelButtonLabel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx.isApplyDisabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](31, 27, "applyButtonLabel"), " ");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_3__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_3__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.ColumnTypeIconComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_2__.TranslatePipe], styles: ["[_nghost-%COMP%]   sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  width: 60%;\n  min-width: 700px;\n}\n.sub-header[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-600);\n  padding-bottom: 10px;\n}\n.container[_ngcontent-%COMP%] {\n  min-width: 500px;\n  padding: var(--sl-spacing-large) var(--sl-spacing-medium);\n  border: 1px dashed var(--sl-color-secondary-500);\n  border-radius: var(--sl-border-radius-medium);\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%] {\n  display: flex;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%] {\n  width: 50%;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  vertical-align: top;\n  margin-right: 5px;\n  font-size: 1.1rem;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%] {\n  margin-top: 20px;\n  max-height: 200px;\n  padding: 0 2px;\n  overflow-y: auto;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%] {\n  margin-top: 5px;\n  display: flex;\n  justify-content: space-between;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%] {\n  width: 50%;\n  display: flex;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%] {\n  width: 90%;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-top: 5px;\n}\n.container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .file[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%], .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%]   .data[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]   .dataset[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-top: 11px;\n  margin-right: 5px;\n}\n.container[_ngcontent-%COMP%]   .add-item[_ngcontent-%COMP%] {\n  margin-top: 20px;\n  font-size: var(--sl-font-size-medium);\n  color: var(--sl-color-primary-600);\n}\n.container[_ngcontent-%COMP%]   .add-item[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n.buttons[_ngcontent-%COMP%] {\n  margin-top: 25px;\n  display: flex;\n  justify-content: flex-end;\n}\n.buttons[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:last-child {\n  margin-left: 10px;\n}\n.type-error[_ngcontent-%COMP%] {\n  border-color: var(--sl-color-danger-500);\n}\n.error[_ngcontent-%COMP%] {\n  display: flex;\n  margin-top: var(--sl-spacing-x-small);\n}\n.error[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n  font-size: var(--sl-font-size-medium);\n}\n.error[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], AddRepeatDataConformationRulesModalComponent.prototype, "showError", void 0);


/***/ }),

/***/ 5175:
/*!*************************************************************************************************************!*\
  !*** ./src/app/modals/add-repeat-data/add-repeat-data-final-modal/add-repeat-data-final-modal.component.ts ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddRepeatDataFinalModalComponent": () => (/* binding */ AddRepeatDataFinalModalComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var src_app_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/api/dataset-api.service */ 5640);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_components_add_repeat_data_conformation_table_add_repeat_data_conformation_table_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/modals/add-repeat-data/add-repeat-data-conformation-modal/components/add-repeat-data-conformation-table/add-repeat-data-conformation-table.component */ 60);








function AddRepeatDataFinalModalComponent_ng_container_1_span_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "span", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 1, "linesDisplayed"), " ");
} }
function AddRepeatDataFinalModalComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 3)(2, "div", 4)(3, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](4, "sl-icon", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](8, AddRepeatDataFinalModalComponent_ng_container_1_span_8_Template, 3, 3, "span", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](10, "app-add-repeat-data-conformation-table", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](11, "div", 10)(12, "sl-button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function AddRepeatDataFinalModalComponent_ng_container_1_Template_sl_button_click_12_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r3); const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r2.backToSettings()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](14, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](15, "div")(16, "sl-button", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function AddRepeatDataFinalModalComponent_ng_container_1_Template_sl_button_click_16_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r3); const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r4.onCancelClick()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](18, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "sl-button", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function AddRepeatDataFinalModalComponent_ng_container_1_Template_sl_button_click_19_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r3); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r5.onNextClick()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](21, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("name", "hdd-stack");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](7, 16, "datasetDataTitle"));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r0.total > ctx_r0.limit);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("isBigTable", true)("isDragDrop", false)("columns", ctx_r0.columns)("rows", ctx_r0.rows)("total", ctx_r0.total)("columnKeys", ctx_r0.columnKeys)("selectedColumnKeys", ctx_r0.selectedColumnKeys)("emptyState", ctx_r0.emptyState)("error", ctx_r0.error);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](14, 18, "backSettings"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](18, 20, "cancelButtonLabel"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("loading", ctx_r0.isNextLoading);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](21, 22, "loadButtonLabel"), " ");
} }
const LIMIT = 100;
class AddRepeatDataFinalModalComponent {
    constructor(datasetApiService, responseErrorService, notifyService, activatedRoute, router) {
        this.datasetApiService = datasetApiService;
        this.responseErrorService = responseErrorService;
        this.notifyService = notifyService;
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.onBackToSettings = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.isAdding = false;
        this.isOpen = false;
        this.isNextLoading = false;
        this.datasetIds = { tmp: 0, current: 0 };
        this.rows = [];
        this.columns = [];
        this.columnKeys = [];
        this.selectedColumnKeys = new Set();
        this.emptyState = false;
        this.total = 0;
        this.limit = LIMIT;
        this.httpError = (response) => {
            this.isNextLoading = false;
            this.responseErrorService.show.emit({
                responseError: response,
                key: 'datasetLoadError',
            });
        };
    }
    show(isAdding, datasetIds, request, columns, rows, total) {
        this.isAdding = isAdding;
        this.datasetIds = datasetIds;
        this.request = request;
        this.rows = rows;
        this.columns = columns;
        this.total = total;
        this.isOpen = true;
        this.prepareData();
    }
    getNotifyData() {
        return this.isAdding ? 'datasetAddSuccess' : 'datasetEditSuccess';
    }
    backToSettings() {
        this.isOpen = false;
        this.onBackToSettings.emit(this.isAdding);
    }
    onCancelClick() {
        this.isOpen = false;
        this.onCancel.emit();
    }
    onNextClick() {
        const datasetId = this.datasetIds.current;
        const requestParams = this.request;
        const methodName = this.isAdding ? 'insertData' : 'overrideData';
        this.isNextLoading = true;
        this.datasetApiService[methodName](datasetId, requestParams).subscribe({
            next: () => {
                this.isNextLoading = false;
                this.isOpen = false;
                this.notifyService.toastByName('notifyDatasetChange');
            },
            error: this.httpError,
        });
    }
    cleanQueryParams() {
        this.router.navigate(['.'], {
            relativeTo: this.activatedRoute,
            queryParams: {},
        });
    }
    prepareData() {
        let columnKeys = [];
        for (let i in this.columns) {
            columnKeys.push(this.columns[i].key);
        }
        const correctSelectedColumnKeys = new Set(Object.values(columnKeys));
        this.columnKeys = columnKeys;
        this.selectedColumnKeys = correctSelectedColumnKeys;
    }
}
AddRepeatDataFinalModalComponent.ɵfac = function AddRepeatDataFinalModalComponent_Factory(t) { return new (t || AddRepeatDataFinalModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](src_app_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__.Router)); };
AddRepeatDataFinalModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: AddRepeatDataFinalModalComponent, selectors: [["app-add-repeat-data-final-modal"]], outputs: { onCancel: "onCancel", onBackToSettings: "onBackToSettings" }, decls: 5, vars: 5, consts: [[1, "final-dialog", 3, "open", "openChange", "hide"], [4, "ngIf"], ["variant", "success", "name", "notifyDatasetChange"], [1, "common-container"], [1, "container", "dataset-data"], [1, "title"], [3, "name"], ["class", "hint", 4, "ngIf"], [1, "table"], [3, "isBigTable", "isDragDrop", "columns", "rows", "total", "columnKeys", "selectedColumnKeys", "emptyState", "error"], [1, "buttons"], ["variant", "text", 3, "click"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", 1, "next", 3, "loading", "click"], [1, "hint"]], template: function AddRepeatDataFinalModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function AddRepeatDataFinalModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; })("hide", function AddRepeatDataFinalModalComponent_Template_sl_dialog_hide_0_listener() { return ctx.cleanQueryParams(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, AddRepeatDataFinalModalComponent_ng_container_1_Template, 22, 24, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "core-notify", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](4, 3, ctx.getNotifyData()), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenDirective, src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_components_add_repeat_data_conformation_table_add_repeat_data_conformation_table_component__WEBPACK_IMPORTED_MODULE_1__.AddRepeatDataConformationTableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["[_nghost-%COMP%]   sl-dialog.final-dialog[_ngcontent-%COMP%]::part(panel) {\n  width: 100%;\n  background-color: var(--core-background);\n}\n[_nghost-%COMP%]   sl-dialog.final-dialog[_ngcontent-%COMP%]::part(base) {\n  padding: 0;\n}\n[_nghost-%COMP%]   sl-dialog.final-dialog[_ngcontent-%COMP%]::part(panel) {\n  min-height: 100%;\n  width: 100%;\n  max-width: 100%;\n  border-radius: 0;\n  background-color: var(--core-background);\n}\n[_nghost-%COMP%]   sl-dialog.final-dialog[_ngcontent-%COMP%]::part(header) {\n  display: none;\n}\n.common-container[_ngcontent-%COMP%]   .container.dataset-data[_ngcontent-%COMP%] {\n  margin-top: 50px;\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-x-large);\n  vertical-align: text-bottom;\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  padding-left: 10px;\n  font-size: var(--sl-font-size-large);\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .title[_ngcontent-%COMP%]   div[_ngcontent-%COMP%] {\n  color: var(--sl-color-gray-400);\n  font-size: var(--sl-font-size-small);\n  margin-top: 10px;\n}\n.common-container[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .table[_ngcontent-%COMP%] {\n  margin-top: 15px;\n  border-radius: 10px;\n}\n.common-container[_ngcontent-%COMP%]   .buttons[_ngcontent-%COMP%] {\n  margin-top: 60px;\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n}\n.common-container[_ngcontent-%COMP%]   .buttons[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:last-child {\n  margin-left: 10px;\n}\n.hint[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-x-small);\n  line-height: 140%;\n  color: var(--sl-color-info-500);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 3807:
/*!************************************************************************!*\
  !*** ./src/app/modals/column-modal/calculated/calculated.component.ts ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CalculatedComponent": () => (/* binding */ CalculatedComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _components_input_token_input_token_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../components/input-token/input-token.component */ 2197);
/* harmony import */ var _api_data_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../api/data-api.service */ 9613);
/* harmony import */ var _api_dataset_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../api/dataset-api.service */ 5640);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/modal-actions/modal-actions.component */ 4335);










function CalculatedComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainer"](0);
} }
function CalculatedComponent_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainer"](0);
} }
function CalculatedComponent_ng_template_5_sl_tag_10_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-tag", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function CalculatedComponent_ng_template_5_sl_tag_10_Template_sl_tag_click_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r11); const item_r9 = restoredCtx.$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r8.put(item_r9)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r9 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", item_r9.name, " ");
} }
function CalculatedComponent_ng_template_5_sl_tag_12_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-tag", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function CalculatedComponent_ng_template_5_sl_tag_12_Template_sl_tag_click_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r14); const item_r12 = restoredCtx.$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r8.putText(item_r12)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", item_r12, " ");
} }
function CalculatedComponent_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "core-form", 6)(1, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](2, "sl-input", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "h4")(6, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, CalculatedComponent_ng_template_5_sl_tag_10_Template, 2, 1, "sl-tag", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](12, CalculatedComponent_ng_template_5_sl_tag_12_Template, 2, 1, "sl-tag", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](13, "app-input-token", 12, 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onChange", function CalculatedComponent_ng_template_5_Template_app_input_token_onChange_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r16); const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r15.changeView($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](15, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](16, "app-modal-actions", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onCancel", function CalculatedComponent_ng_template_5_Template_app_modal_actions_onCancel_16_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r16); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r17.onCancel.emit()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("data", ctx_r3.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 9, "modalColumn#calculatedLabel"));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 11, "modalColumn#calculatedColumnName"));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](8, 13, "modalColumn#formula"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r3.columns);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r3.operators);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](15, 15, "modalColumn#enterFormula"));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("tokenList", ctx_r3.columns);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("hasBack", false);
} }
function CalculatedComponent_ng_template_7_core_table_0_th_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r21 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassProp"]("value", item_r21.id == 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", item_r21.translate ? _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 3, item_r21.translate) : item_r21.name, " ");
} }
function CalculatedComponent_ng_template_7_core_table_0_tr_5_td_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const column_r24 = ctx.$implicit;
    const item_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassProp"]("value", column_r24.id == 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", item_r22[column_r24.id], " ");
} }
function CalculatedComponent_ng_template_7_core_table_0_tr_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](1, CalculatedComponent_ng_template_7_core_table_0_tr_5_td_1_Template, 2, 3, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r20.viewColumns);
} }
function CalculatedComponent_ng_template_7_core_table_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "core-table", 17)(1, "thead")(2, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](3, CalculatedComponent_ng_template_7_core_table_0_th_3_Template, 3, 5, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](5, CalculatedComponent_ng_template_7_core_table_0_tr_5_Template, 2, 1, "tr", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r18.viewColumns);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r18.viewRows);
} }
function CalculatedComponent_ng_template_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](0, CalculatedComponent_ng_template_7_core_table_0_Template, 6, 2, "core-table", 16);
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx_r5.viewRows == null ? null : ctx_r5.viewRows.length);
} }
class CalculatedComponent {
    constructor(formService, dataApiService, datasetApiService) {
        this.formService = formService;
        this.dataApiService = dataApiService;
        this.datasetApiService = datasetApiService;
        this.onOk = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        this.columnsById = {};
        this.isOpen = false;
        this.formula = [];
        this.viewRows = [];
        this.viewColumns = [];
        this.form = this.formService
            .create({
            name: [''],
            base_type: [plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ColumnType.String],
            formula: [],
        })
            .setup({
            method: (form) => this.datasetApiService.createColumn(this.dataset.id, Object.assign(Object.assign({}, form), { formula: this.formula })),
            success: () => {
                this.onOk.emit();
            },
        });
        this.operators = [
            '!',
            '&&',
            '||',
            '+',
            '-',
            '*',
            '**',
            '%',
            '/',
            '==',
            '!=',
            '=~',
            '!~',
            '<',
            '>',
            '<=',
            '>=',
            '<<',
            '>>',
        ];
    }
    get columns() {
        var _a;
        return (_a = this.dataset) === null || _a === void 0 ? void 0 : _a.columns;
    }
    ngOnInit() {
        this.columnsById = {};
        this.columns.forEach((item) => {
            this.columnsById[item.id] = item;
        });
    }
    changeView(data) {
        this.formula = data;
        if (data.length) {
            clearTimeout(this.timer);
            this.timer = setTimeout(() => {
                this.dataApiService
                    .formula({
                    name: '',
                    dataset_id: this.dataset.id,
                    formula: this.formula,
                })
                    .subscribe(({ rows, base_type }) => {
                    this.viewRows = rows;
                    this.form.patchValue({
                        base_type,
                    });
                    this.makeViewColumns();
                });
            }, 300);
        }
    }
    makeViewColumns() {
        const appended = [];
        this.viewColumns = [];
        this.formula
            .filter((item) => item.type === _components_input_token_input_token_component__WEBPACK_IMPORTED_MODULE_0__.ETokenType.Id)
            .forEach((item) => {
            if (!appended.includes(item.column_id)) {
                this.viewColumns.push({
                    id: item.column_id,
                    name: this.columnsById[item.column_id].name,
                });
                appended.push(item.column_id);
            }
        });
        this.viewColumns.push({
            id: 0,
            name: '',
            translate: 'modalColumn#Value',
        });
    }
}
CalculatedComponent.ɵfac = function CalculatedComponent_Factory(t) { return new (t || CalculatedComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_data_api_service__WEBPACK_IMPORTED_MODULE_1__.DataApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_2__.DatasetApiService)); };
CalculatedComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: CalculatedComponent, selectors: [["app-calculated"]], inputs: { dataset: "dataset" }, outputs: { onOk: "onOk", onCancel: "onCancel" }, decls: 9, vars: 2, consts: [[1, "grid"], [1, "view"], [4, "ngTemplateOutlet"], [1, "form"], ["templateForm", ""], ["templateView", ""], [3, "data"], [1, "inputs"], ["name", "name", 3, "label", "placeholder"], ["slot", "help-text"], [1, "variants"], ["size", "small", "type", "info", 3, "click", 4, "ngFor", "ngForOf"], [3, "placeholder", "tokenList", "onChange"], ["inputTokenComponent", ""], [3, "hasBack", "onCancel"], ["size", "small", "type", "info", 3, "click"], ["nested", "", 4, "ngIf"], ["nested", ""], [3, "value", 4, "ngFor", "ngForOf"], [4, "ngFor", "ngForOf"]], template: function CalculatedComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](2, CalculatedComponent_ng_container_2_Template, 1, 0, "ng-container", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](4, CalculatedComponent_ng_container_4_Template, 1, 0, "ng-container", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](5, CalculatedComponent_ng_template_5_Template, 17, 17, "ng-template", null, 4, _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](7, CalculatedComponent_ng_template_7_Template, 1, 1, "ng-template", null, 5, _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](6);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngTemplateOutlet", _r4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngTemplateOutlet", _r2);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgTemplateOutlet, _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_3__.ModalActionsComponent, _components_input_token_input_token_component__WEBPACK_IMPORTED_MODULE_0__.InputTokenComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: [".grid[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: 50% 50%;\n}\n.view[_ngcontent-%COMP%] {\n  padding: 0 var(--sl-spacing-medium) 0 0;\n}\n.inputs[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-3x-large);\n}\nh4[_ngcontent-%COMP%] {\n  font-weight: normal;\n  color: var(--sl-color-secondary-900);\n}\n.variants[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-medium);\n}\n.variants[_ngcontent-%COMP%]   sl-tag[_ngcontent-%COMP%] {\n  margin: 0 var(--sl-spacing-2x-small) var(--sl-spacing-2x-small) 0;\n}\n.variants[_ngcontent-%COMP%]   sl-tag[_ngcontent-%COMP%]::part(base) {\n  cursor: pointer;\n}\ncore-table[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  background: var(--sl-color-primary-50);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNhbGN1bGF0ZWQuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsOEJBQUE7QUFDSjtBQUVBO0VBQ0ksdUNBQUE7QUFBSjtBQUdBO0VBQ0kseUNBQUE7QUFESjtBQUlBO0VBQ0ksbUJBQUE7RUFDQSxvQ0FBQTtBQUZKO0FBS0E7RUFDSSx1Q0FBQTtBQUhKO0FBRUE7RUFHUSxpRUFBQTtBQUZSO0FBSVE7RUFDSSxlQUFBO0FBRlo7QUFPQTtFQUNJLHNDQUFBO0FBTEoiLCJmaWxlIjoiY2FsY3VsYXRlZC5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5ncmlkIHtcbiAgICBkaXNwbGF5OiBncmlkO1xuICAgIGdyaWQtdGVtcGxhdGUtY29sdW1uczogNTAlIDUwJTtcbn1cblxuLnZpZXcge1xuICAgIHBhZGRpbmc6IDAgdmFyKC0tc2wtc3BhY2luZy1tZWRpdW0pIDAgMDtcbn1cblxuLmlucHV0cyB7XG4gICAgbWFyZ2luLWJvdHRvbTogdmFyKC0tc2wtc3BhY2luZy0zeC1sYXJnZSk7XG59XG5cbmg0IHtcbiAgICBmb250LXdlaWdodDogbm9ybWFsO1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktOTAwKTtcbn1cblxuLnZhcmlhbnRzIHtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLW1lZGl1bSk7XG4gICAgc2wtdGFnIHtcbiAgICAgICAgbWFyZ2luOiAwIHZhcigtLXNsLXNwYWNpbmctMngtc21hbGwpIHZhcigtLXNsLXNwYWNpbmctMngtc21hbGwpIDA7XG5cbiAgICAgICAgJjo6cGFydChiYXNlKSB7XG4gICAgICAgICAgICBjdXJzb3I6IHBvaW50ZXI7XG4gICAgICAgIH1cbiAgICB9XG59XG5cbmNvcmUtdGFibGUgLnZhbHVlIHtcbiAgICBiYWNrZ3JvdW5kOiB2YXIoLS1zbC1jb2xvci1wcmltYXJ5LTUwKTtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 7582:
/*!***************************************************************!*\
  !*** ./src/app/modals/column-modal/column-modal.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnModalComponent": () => (/* binding */ ColumnModalComponent),
/* harmony export */   "EState": () => (/* binding */ EState)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _pages_dataset_dataset_settings_dataset_settings_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../pages/dataset/dataset-settings/dataset-settings.service */ 714);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _components_select_card_grid_select_card_grid_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components/select-card-grid/select-card-grid.component */ 444);
/* harmony import */ var _default_default_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./default/default.component */ 4695);
/* harmony import */ var _calculated_calculated_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./calculated/calculated.component */ 3807);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! plmt-core-library */ 9543);









function ColumnModalComponent_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "app-select-card-grid", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onSelect", function ColumnModalComponent_ng_container_2_Template_app_select_card_grid_onSelect_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r4); const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r3.state = $event.payload); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("rows", ctx_r0.selectRows);
} }
function ColumnModalComponent_app_default_3_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "app-default", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onCancel", function ColumnModalComponent_app_default_3_Template_app_default_onCancel_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r5.isOpen = false); })("onOk", function ColumnModalComponent_app_default_3_Template_app_default_onOk_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r7.onOk()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataset", ctx_r1.dataset);
} }
function ColumnModalComponent_app_calculated_4_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "app-calculated", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onCancel", function ColumnModalComponent_app_calculated_4_Template_app_calculated_onCancel_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r9); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r8.isOpen = false); })("onOk", function ColumnModalComponent_app_calculated_4_Template_app_calculated_onOk_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r9); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r10.onOk()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataset", ctx_r2.dataset);
} }
var EState;
(function (EState) {
    EState[EState["Menu"] = 0] = "Menu";
    EState[EState["Default"] = 1] = "Default";
    EState[EState["Calculated"] = 2] = "Calculated";
})(EState || (EState = {}));
class ColumnModalComponent {
    constructor(datasetSettingsService) {
        this.datasetSettingsService = datasetSettingsService;
        this.onCreate = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        this.isOpen = false;
        this.state = EState.Menu;
        this.selectRows = [
            {
                name: 'modalColumn#simpleColumn',
                help: 'modalColumn#addNewColumn',
                iconName: 'column-default',
                payload: EState.Default,
            },
            {
                name: 'modalColumn#calculatedColumn',
                help: 'modalColumn#addNewCalculatedColumn',
                iconName: 'column-calculated',
                payload: EState.Calculated,
            },
        ];
        this.EState = EState;
    }
    get isSizeLarge() {
        return this.state === EState.Calculated;
    }
    show() {
        this.state = EState.Default;
        this.isOpen = true;
    }
    onOk() {
        this.datasetSettingsService.onChangeColumn.emit();
        this.onCreate.emit();
        this.isOpen = false;
    }
}
ColumnModalComponent.ɵfac = function ColumnModalComponent_Factory(t) { return new (t || ColumnModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_pages_dataset_dataset_settings_dataset_settings_service__WEBPACK_IMPORTED_MODULE_0__.DatasetSettingsService)); };
ColumnModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: ColumnModalComponent, selectors: [["app-column-modal"]], hostVars: 2, hostBindings: function ColumnModalComponent_HostBindings(rf, ctx) { if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassProp"]("size-large", ctx.isSizeLarge);
    } }, inputs: { dataset: "dataset" }, outputs: { onCreate: "onCreate" }, decls: 5, vars: 7, consts: [[3, "label", "open", "openChange"], [4, "ngIf"], [3, "dataset", "onCancel", "onOk", 4, "ngIf"], [3, "rows", "onSelect"], [3, "dataset", "onCancel", "onOk"]], template: function ColumnModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("openChange", function ColumnModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](2, ColumnModalComponent_ng_container_2_Template, 2, 1, "ng-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](3, ColumnModalComponent_app_default_3_Template, 1, 1, "app-default", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](4, ColumnModalComponent_app_calculated_4_Template, 1, 1, "app-calculated", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](1, 5, "modalColumn#createColumn"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.state === ctx.EState.Menu);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.state === ctx.EState.Default);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.state === ctx.EState.Calculated);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenDirective, _components_select_card_grid_select_card_grid_component__WEBPACK_IMPORTED_MODULE_1__.SelectCardGridComponent, _default_default_component__WEBPACK_IMPORTED_MODULE_2__.DefaultComponent, _calculated_calculated_component__WEBPACK_IMPORTED_MODULE_3__.CalculatedComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TranslatePipe], styles: [".size-large[_nghost-%COMP%]   sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  width: 100%;\n  max-width: 62rem;\n}\n.grid[_ngcontent-%COMP%] {\n  display: flex;\n}\n.grid__item[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-start;\n  flex-direction: column;\n  width: 50%;\n  margin-right: var(--sl-spacing-medium);\n  padding: var(--sl-spacing-x-large) var(--sl-spacing-medium);\n  border: 1px solid var(--sl-color-neutral-100);\n  border-radius: var(--sl-border-radius-medium);\n  cursor: pointer;\n  text-align: center;\n}\n.grid__item[_ngcontent-%COMP%]:last-child {\n  margin-right: 0;\n}\n.grid__item[_ngcontent-%COMP%]:hover {\n  border-color: var(--sl-color-primary-300);\n}\n.icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-600);\n}\n.icon[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  width: 59px;\n  height: 59px;\n}\nh3[_ngcontent-%COMP%] {\n  margin: var(--sl-spacing-large) 0 var(--sl-spacing-small) 0;\n  font-size: var(--sl-font-size-small);\n  line-height: var(--sl-line-height-dense);\n  color: var(--sl-color-secondary-600);\n}\np[_ngcontent-%COMP%] {\n  margin: 0;\n  font-size: var(--sl-font-size-x-small);\n  line-height: var(--sl-line-height-dense);\n  color: var(--sl-color-secondary-600);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 2448:
/*!************************************************************!*\
  !*** ./src/app/modals/column-modal/column-modal.module.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnModalModule": () => (/* binding */ ColumnModalModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _column_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./column-modal.component */ 7582);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components/modal-actions/modal-actions.module */ 4108);
/* harmony import */ var _default_default_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./default/default.component */ 4695);
/* harmony import */ var _calculated_calculated_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./calculated/calculated.component */ 3807);
/* harmony import */ var _components_input_token_input_token_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-token/input-token.module */ 294);
/* harmony import */ var _components_select_card_grid_select_card_grid_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../components/select-card-grid/select-card-grid.module */ 1438);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);










class ColumnModalModule {
}
ColumnModalModule.ɵfac = function ColumnModalModule_Factory(t) { return new (t || ColumnModalModule)(); };
ColumnModalModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineNgModule"]({ type: ColumnModalModule });
ColumnModalModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule,
        _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_1__.ModalActionsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.NotifyModule,
        _components_input_token_input_token_module__WEBPACK_IMPORTED_MODULE_4__.InputTokenModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TableModule,
        _components_select_card_grid_select_card_grid_module__WEBPACK_IMPORTED_MODULE_5__.SelectCardGridModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.FormModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵsetNgModuleScope"](ColumnModalModule, { declarations: [_column_modal_component__WEBPACK_IMPORTED_MODULE_0__.ColumnModalComponent, _default_default_component__WEBPACK_IMPORTED_MODULE_2__.DefaultComponent, _calculated_calculated_component__WEBPACK_IMPORTED_MODULE_3__.CalculatedComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_8__.ShoelaceModule,
        _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_1__.ModalActionsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.NotifyModule,
        _components_input_token_input_token_module__WEBPACK_IMPORTED_MODULE_4__.InputTokenModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TableModule,
        _components_select_card_grid_select_card_grid_module__WEBPACK_IMPORTED_MODULE_5__.SelectCardGridModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_9__.FormModule], exports: [_column_modal_component__WEBPACK_IMPORTED_MODULE_0__.ColumnModalComponent] }); })();


/***/ }),

/***/ 4695:
/*!******************************************************************!*\
  !*** ./src/app/modals/column-modal/default/default.component.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DefaultComponent": () => (/* binding */ DefaultComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ts-enum-to-array */ 141);
/* harmony import */ var _api_dataset_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../api/dataset-api.service */ 5640);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/modal-actions/modal-actions.component */ 4335);









function DefaultComponent_sl_menu_item_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-menu-item", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("value", item_r1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 2, "modalColumn#Type." + item_r1), " ");
} }
class DefaultComponent {
    constructor(formService, datasetApiService, notifyService, responseErrorService) {
        this.formService = formService;
        this.datasetApiService = datasetApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.onOk = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
        this.types = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__.enumToArray)(plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType);
        this.form = this.formService
            .create({
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.max(250)]],
            path: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.max(250)]],
            source_path: [null],
            base_type: ['' + plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType.String, [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required]],
        })
            .setup({
            method: (form) => {
                return this.datasetApiService.createColumn(this.dataset.id, Object.assign(Object.assign({}, form), { base_type: parseInt(this.form.value.base_type) }));
            },
            success: () => {
                this.onOk.emit();
                this.form.reset({ base_type: '' + plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType.String });
                this.notifyService.toastByName('notificateColumn');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'modalColumn#columnCreatedDanger',
                });
            },
        });
    }
}
DefaultComponent.ɵfac = function DefaultComponent_Factory(t) { return new (t || DefaultComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_1__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService)); };
DefaultComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: DefaultComponent, selectors: [["app-default"]], inputs: { dataset: "dataset" }, outputs: { onOk: "onOk", onCancel: "onCancel" }, decls: 24, vars: 24, consts: [[3, "data"], ["name", "name", 3, "label"], ["name", "path", 3, "label"], ["slot", "help-text"], ["name", "source_path", 3, "label"], ["name", "base_type", 3, "label"], [3, "value", 4, "ngFor", "ngForOf"], [3, "hasBack", "onCancel"], ["variant", "success", "name", "notificateColumn"], [3, "value"]], template: function DefaultComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "core-form", 0)(1, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](2, "sl-input", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "core-validate")(5, "sl-input", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](7, "small", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "core-validate")(11, "sl-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](12, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](13, "small", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](14);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](16, "core-validate")(17, "sl-select", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](19, DefaultComponent_sl_menu_item_19_Template, 3, 4, "sl-menu-item", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](20, "app-modal-actions", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onCancel", function DefaultComponent_Template_app_modal_actions_onCancel_20_listener() { return ctx.onCancel.emit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](21, "core-notify", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](22);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](23, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 10, "modalColumn#columnName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 12, "modalColumn#columnLatinName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](9, 14, "modalColumn#underInputColumnLatinName"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](12, 16, "modalColumn#sourcePath"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](15, 18, "modalColumn#underInputsourcePath"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](18, 20, "modalColumn#Type"));
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx.types);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("hasBack", false);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](23, 22, "modalColumn#columnCreated"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_2__.ModalActionsComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe], styles: ["sl-input[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-medium);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRlZmF1bHQuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSx1Q0FBQTtBQUNKIiwiZmlsZSI6ImRlZmF1bHQuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyJzbC1pbnB1dCB7XG4gICAgbWFyZ2luLWJvdHRvbTogdmFyKC0tc2wtc3BhY2luZy1tZWRpdW0pO1xufVxuIl19 */"] });


/***/ }),

/***/ 3262:
/*!***************************************************************!*\
  !*** ./src/app/modals/save-confirm/save-confirm.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SaveConfirmComponent": () => (/* binding */ SaveConfirmComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);





function SaveConfirmComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r0.description), " ");
} }
const _c0 = ["*"];
class SaveConfirmComponent {
    constructor() {
        this.title = 'modalConfirm#actionConfirm';
        this.description = '';
        this.okButton = { variant: 'primary', text: '$.save' };
        this.cancelButton = { variant: 'primary', text: '$.cancel' };
        this.onOk = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.isOpen = false;
    }
    show(data) {
        this.data = data;
        this.isOpen = true;
    }
    cancel() {
        this.isOpen = false;
        this.onCancel.emit(this.data);
    }
    ok() {
        this.isOpen = false;
        this.onOk.emit(this.data);
    }
}
SaveConfirmComponent.ɵfac = function SaveConfirmComponent_Factory(t) { return new (t || SaveConfirmComponent)(); };
SaveConfirmComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: SaveConfirmComponent, selectors: [["app-save-confirm"]], inputs: { title: "title", description: "description", okButton: "okButton", cancelButton: "cancelButton" }, outputs: { onOk: "onOk", onCancel: "onCancel" }, ngContentSelectors: _c0, decls: 15, vars: 13, consts: [[3, "open", "openChange"], [1, "content"], [1, "header"], ["class", "description", 4, "ngIf"], [1, "content-wrapper"], [1, "buttons"], ["outline", "", 3, "variant", "click"], [3, "variant", "click"], [1, "description"]], template: function SaveConfirmComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("openChange", function SaveConfirmComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1)(2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, SaveConfirmComponent_div_5_Template, 3, 3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 5)(9, "sl-button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SaveConfirmComponent_Template_sl_button_click_9_listener() { return ctx.cancel(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SaveConfirmComponent_Template_sl_button_click_12_listener() { return ctx.ok(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](4, 7, ctx.title));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.description);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("variant", ctx.cancelButton.variant);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](11, 9, ctx.cancelButton.text), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("variant", ctx.okButton.variant);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](14, 11, ctx.okButton.text), " ");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_1__.NgIf, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_2__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  border-radius: var(--sl-spacing-2x-small);\n  box-shadow: 0px 4px 16px rgba(0, 0, 0, 0.1);\n}\nsl-dialog[_ngcontent-%COMP%]::part(header) {\n  display: none;\n}\n.buttons[_ngcontent-%COMP%] {\n  margin-top: 24px;\n  display: flex;\n  justify-content: flex-end;\n}\n.buttons[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: var(--sl-spacing-small);\n}\n.content[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-x-large) 0 0;\n  color: var(--sl-color-secondary-900);\n}\n.content[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%] {\n  margin: 0 0 24px 0;\n  font-weight: 600;\n  font-size: var(--sl-font-size-large);\n  line-height: 120%;\n}\n.content[_ngcontent-%COMP%]   .description[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n}\n.content-wrapper[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-900);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNhdmUtY29uZmlybS5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDSTtFQUNJLHlDQUFBO0VBQ0EsMkNBQUE7QUFBUjtBQUVJO0VBQ0ksYUFBQTtBQUFSO0FBSUE7RUFDSSxnQkFBQTtFQUNBLGFBQUE7RUFDQSx5QkFBQTtBQUZKO0FBREE7RUFNUSxvQ0FBQTtBQUZSO0FBTUE7RUFDSSxzQ0FBQTtFQUNBLG9DQUFBO0FBSko7QUFFQTtFQUtRLGtCQUFBO0VBQ0EsZ0JBQUE7RUFDQSxvQ0FBQTtFQUNBLGlCQUFBO0FBSlI7QUFKQTtFQVlRLHFDQUFBO0VBQ0Esb0NBQUE7RUFDQSxpQkFBQTtBQUxSO0FBU0E7RUFDSSxvQ0FBQTtFQUNBLG9DQUFBO0FBUEoiLCJmaWxlIjoic2F2ZS1jb25maXJtLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsic2wtZGlhbG9nIHtcbiAgICAmOjpwYXJ0KHBhbmVsKSB7XG4gICAgICAgIGJvcmRlci1yYWRpdXM6IHZhcigtLXNsLXNwYWNpbmctMngtc21hbGwpO1xuICAgICAgICBib3gtc2hhZG93OiAwcHggNHB4IDE2cHggcmdiYSgwLCAwLCAwLCAwLjEpO1xuICAgIH1cbiAgICAmOjpwYXJ0KGhlYWRlcikge1xuICAgICAgICBkaXNwbGF5OiBub25lO1xuICAgIH1cbn1cblxuLmJ1dHRvbnMge1xuICAgIG1hcmdpbi10b3A6IDI0cHg7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGZsZXgtZW5kO1xuXG4gICAgc2wtYnV0dG9uIHtcbiAgICAgICAgbWFyZ2luLWxlZnQ6IHZhcigtLXNsLXNwYWNpbmctc21hbGwpO1xuICAgIH1cbn1cblxuLmNvbnRlbnQge1xuICAgIHBhZGRpbmc6IHZhcigtLXNsLXNwYWNpbmcteC1sYXJnZSkgMCAwO1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktOTAwKTtcblxuICAgIC5oZWFkZXIge1xuICAgICAgICBtYXJnaW46IDAgMCAyNHB4IDA7XG4gICAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7XG4gICAgICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLWxhcmdlKTtcbiAgICAgICAgbGluZS1oZWlnaHQ6IDEyMCU7XG4gICAgfVxuXG4gICAgLmRlc2NyaXB0aW9uIHtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUtbWVkaXVtKTtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUtc21hbGwpO1xuICAgICAgICBsaW5lLWhlaWdodDogMTlweDtcbiAgICB9XG59XG5cbi5jb250ZW50LXdyYXBwZXIge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3Itc2Vjb25kYXJ5LTkwMCk7XG59XG4iXX0= */"] });


/***/ }),

/***/ 3422:
/*!************************************************************!*\
  !*** ./src/app/modals/save-confirm/save-confirm.module.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SaveConfirmModule": () => (/* binding */ SaveConfirmModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _save_confirm_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./save-confirm.component */ 3262);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);





class SaveConfirmModule {
}
SaveConfirmModule.ɵfac = function SaveConfirmModule_Factory(t) { return new (t || SaveConfirmModule)(); };
SaveConfirmModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: SaveConfirmModule });
SaveConfirmModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](SaveConfirmModule, { declarations: [_save_confirm_component__WEBPACK_IMPORTED_MODULE_0__.SaveConfirmComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule], exports: [_save_confirm_component__WEBPACK_IMPORTED_MODULE_0__.SaveConfirmComponent] }); })();


/***/ }),

/***/ 1814:
/*!*********************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/add-repeat-data/add-repeat-data.component.ts ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddRepeatDataComponent": () => (/* binding */ AddRepeatDataComponent),
/* harmony export */   "DEFAULT_DELIMITER": () => (/* binding */ DEFAULT_DELIMITER),
/* harmony export */   "ENCODING_LABEL": () => (/* binding */ ENCODING_LABEL),
/* harmony export */   "ENCODING_UTF8": () => (/* binding */ ENCODING_UTF8),
/* harmony export */   "READY_STATE": () => (/* binding */ READY_STATE)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs */ 116);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 3853);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 745);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var _services_ws_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../services/ws.service */ 4885);
/* harmony import */ var src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/enums/plugin */ 3762);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _dataset_settings_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../dataset-settings.service */ 714);
/* harmony import */ var src_app_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/api/dataset-api.service */ 5640);
/* harmony import */ var src_app_api_plugin_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/api/plugin-api.service */ 4819);














const _c0 = ["conformationModal"];
const _c1 = ["finalModal"];
const _c2 = ["fileUploadComponent"];
function AddRepeatDataComponent_div_23_sl_menu_item_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "sl-menu-item", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} if (rf & 2) {
    const charset_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", charset_r7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", charset_r7, " ");
} }
function AddRepeatDataComponent_div_23_div_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](2, 1, "errorMessage"), " ");
} }
const _c3 = function (a0) { return { error: a0 }; };
function AddRepeatDataComponent_div_23_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 17)(1, "div", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "div", 18)(8, "div", 19)(9, "sl-select", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-select", function AddRepeatDataComponent_div_23_Template_sl_select_sl_select_9_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r9); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r8.changeEncoding($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](12, AddRepeatDataComponent_div_23_sl_menu_item_12_Template, 2, 2, "sl-menu-item", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](13, "div", 19)(14, "sl-input", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-change", function AddRepeatDataComponent_div_23_Template_sl_input_sl_change_14_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r9); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r10.changeDelimiter($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](15, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](16, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, AddRepeatDataComponent_div_23_div_17_Template, 3, 3, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](3, 14, "csvTextSettingsTitle"));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](6, 16, "csvTextSettingsText"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx_r0.isAddWaiting || ctx_r0.isRepeatWaiting)("value", ctx_r0.csvTextEncoding)("label", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](10, 18, "encodingLabel"))("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](11, 20, "encodingPlaceholder"));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngForOf", ctx_r0.charsets);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx_r0.isAddWaiting || ctx_r0.isRepeatWaiting)("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction1"](26, _c3, ctx_r0.isDelimiterError))("required", true)("label", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](15, 22, "delimiterLabel"))("value", ctx_r0.csvEncodingDelimiter)("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](16, 24, "delimiterPlaceholder"));
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx_r0.isDelimiterError);
} }
const _c4 = function () { return { icon: "arrow-counterclockwise", label: "changeButtonLabel", title: "changeDataTitle", text: "changeData", isMargin: true }; };
const _c5 = function () { return { icon: "plus-circle", label: "addButtonLabel", title: "addDataTitle", text: "addData", isMargin: false }; };
const DEFAULT_DELIMITER = ';';
const ENCODING_LABEL = 'Encoding';
const ENCODING_UTF8 = 'utf-8';
const READY_STATE = 1;
class AddRepeatDataComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__.SubscribableComponent {
    constructor(router, notifyService, datasetSettingsService, datasetApiService, pluginApiService, responseErrorService, wsService) {
        super();
        this.router = router;
        this.notifyService = notifyService;
        this.datasetSettingsService = datasetSettingsService;
        this.datasetApiService = datasetApiService;
        this.pluginApiService = pluginApiService;
        this.responseErrorService = responseErrorService;
        this.wsService = wsService;
        this.FileType = src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__.PluginFileType;
        this.charsets = [];
        this.csvTextEncoding = '';
        this.csvEncodingDelimiter = DEFAULT_DELIMITER;
        this.datasetIds = { tmp: 0, current: 0 };
        this.isAddWaiting = false;
        this.isRepeatWaiting = false;
        this.isConformationModalOpen = false;
        this.error = '';
        this.msFilterOnlyChangeDataset = (item) => {
            return item.code === _services_ws_service__WEBPACK_IMPORTED_MODULE_0__.MessageCode.ChangeDatasetState;
        };
    }
    get isDisabled() {
        if (!this.fileTypeValue || this.isAddWaiting || this.isRepeatWaiting) {
            return true;
        }
        if (this.fileTypeValue === src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__.PluginFileType.Csv) {
            return !this.csvTextEncoding || !this.csvEncodingDelimiter;
        }
        return false;
    }
    get isCsvText() {
        return (!!this.fileTypeValue && this.fileTypeValue === src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__.PluginFileType.Csv);
    }
    get isDelimiterError() {
        return !this.csvEncodingDelimiter;
    }
    ngOnInit() {
        this.setEncodingList();
        this.subscriptions = [
            this.wsService.message
                .pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_7__.filter)(this.msFilterOnlyChangeDataset))
                .subscribe((message) => {
                if (!this.datasetIds.tmp) {
                    return;
                }
                const payload = message.payload;
                if (Number(payload.id) === Number(this.datasetIds.tmp) &&
                    Number(payload.state) === READY_STATE) {
                    const isAdd = this.isAddWaiting;
                    this.openConformationModal(isAdd);
                }
            }),
        ];
    }
    getFileType() {
        return this.fileTypeValue || '';
    }
    changeFileType(event) {
        this.fileTypeValue = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.valueOf)(event);
        this.fileUploadComponent.reset();
    }
    changeEncoding(event) {
        this.csvTextEncoding = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.valueOf)(event);
    }
    changeDelimiter(event) {
        this.csvEncodingDelimiter = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.valueOf)(event);
    }
    onChangeDataUpload(fileData) {
        this.onDataUpload(fileData, false);
    }
    onAddDataUpload(fileData) {
        this.onDataUpload(fileData, true);
    }
    onCancelClick() {
        this.router.navigate([
            `/dataset/${this.datasetSettingsService.datasetId}/settings`,
        ]);
    }
    onAddDataFromModal(data) {
        this.conformationModal.hide();
        this.finalModal.show(true, this.datasetIds, data.request, data.columns, data.rows, data.total);
    }
    onEditDataFromModal(data) {
        this.conformationModal.hide();
        this.finalModal.show(false, this.datasetIds, data.request, data.columns, data.rows, data.total);
    }
    openConformationModal(isAdding) {
        this[isAdding ? 'isAddWaiting' : 'isRepeatWaiting'] = false;
        this.conformationModal.show(isAdding, this.datasetIds, this.fileTypeValue || src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__.PluginFileType.Csv);
    }
    setEncodingList() {
        this.pluginApiService
            .list({ type: src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__.PluginType.OnlyDataset })
            .subscribe(({ rows }) => {
            rows.forEach((plugin) => {
                if (plugin.sys_name !== src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_1__.PluginFileType.Csv) {
                    return;
                }
                const queryFields = plugin.query_fields || [];
                queryFields.forEach((field) => {
                    const labels = field.labels || [];
                    labels.forEach((label) => {
                        if (label.value !== ENCODING_LABEL) {
                            return;
                        }
                        const encodings = this.prepareEncodingList(field.multi_value || []);
                        this.charsets = encodings;
                        this.csvTextEncoding = this.charsets[0];
                    });
                });
            });
        });
    }
    onDataUpload(fileData, isAdd) {
        const name = this.fileTypeValue;
        const params = {
            query_fields: [{ name: 'file', value: fileData.path }],
        };
        const waitingKey = isAdd ? 'isAddWaiting' : 'isRepeatWaiting';
        this[waitingKey] = true;
        this.pluginApiService
            .getColumns(name, params)
            .pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_9__.concatMap)(({ rows }) => {
            if (isAdd) {
                const dataset = this.datasetSettingsService.currentDataset.value;
                const datasetColumns = dataset.columns || [];
                const fileColumns = rows;
                if (datasetColumns.length !== fileColumns.length) {
                    this.isAddWaiting = false;
                    this.notify('datasetColumnsLength');
                    return (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.of)(null);
                }
            }
            return this.getDatasetLocalObservable(rows, fileData);
        }))
            .subscribe({
            next: (response) => {
                const tmpDataset = response.row;
                this.datasetIds = {
                    tmp: tmpDataset.id,
                    current: Number(this.datasetSettingsService.datasetId),
                };
            },
            error: (error) => {
                if (error.status === 400 /* HttpStatusCode.BadRequest */) {
                    this.error = error.error.error;
                    this.notify('fileError');
                }
                else {
                    this.responseErrorService.show.emit({
                        responseError: error,
                        key: 'fileError',
                    });
                }
                this.isAddWaiting = false;
                this.isRepeatWaiting = false;
            },
        });
    }
    getDatasetLocalObservable(data = [], fileData) {
        const currentDataset = this.datasetSettingsService.currentDataset.value;
        const columns = data || [];
        const name = currentDataset.name + this.getDatasetNameExtension();
        const fields = [{ name: 'file', value: fileData.path }];
        const requestParams = {
            name: name,
            plugin_name: this.fileTypeValue,
            columns: columns,
            fields: fields,
            users: currentDataset.users,
            groups: currentDataset.groups,
            internal: true,
            comment: '',
        };
        return this.datasetApiService.createLocal(requestParams);
    }
    prepareEncodingList(encodings) {
        let result = [];
        if (encodings.includes(ENCODING_UTF8)) {
            result.push(ENCODING_UTF8);
        }
        encodings.forEach((encoding) => {
            if (encoding !== ENCODING_UTF8) {
                result.push(encoding);
            }
        });
        return result;
    }
    getDatasetNameExtension() {
        return new Date().getTime().toString();
    }
    notify(name) {
        this.notifyService.toastByName(name);
    }
}
AddRepeatDataComponent.ɵfac = function AddRepeatDataComponent_Factory(t) { return new (t || AddRepeatDataComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_11__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_dataset_settings_service__WEBPACK_IMPORTED_MODULE_2__.DatasetSettingsService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](src_app_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_3__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](src_app_api_plugin_api_service__WEBPACK_IMPORTED_MODULE_4__.PluginApiService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_services_ws_service__WEBPACK_IMPORTED_MODULE_0__.WsService)); };
AddRepeatDataComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({ type: AddRepeatDataComponent, selectors: [["app-add-repeat-data"]], viewQuery: function AddRepeatDataComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_c1, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_c2, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.conformationModal = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.finalModal = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.fileUploadComponent = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵInheritDefinitionFeature"]], decls: 42, vars: 49, consts: [[1, "file-type"], [1, "header"], [1, "sub-header"], [1, "select"], ["hoist", "", 3, "value", "placeholder", "sl-select"], [3, "value"], ["class", "csv-text-settings", 4, "ngIf"], [3, "fileType", "disabled", "loading", "viewData", "uploadFile"], ["fileUploadComponent", ""], [1, "cancel"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "danger", "name", "fileError"], [3, "onAddData", "onEditData", "onCancel"], ["conformationModal", ""], [3, "onCancel", "onBackToSettings"], ["finalModal", ""], ["variant", "warning", "name", "datasetColumnsLength"], [1, "csv-text-settings"], [1, "form"], [1, "item"], ["hoist", "", 3, "disabled", "value", "label", "placeholder", "sl-select"], [3, "value", 4, "ngFor", "ngForOf"], [3, "disabled", "ngClass", "required", "label", "value", "placeholder", "sl-change"], ["class", "error-message", 4, "ngIf"], [1, "error-message"]], template: function AddRepeatDataComponent_Template(rf, ctx) { if (rf & 1) {
        const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "sl-card")(1, "div", 0)(2, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](5, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](7, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 3)(9, "sl-select", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-select", function AddRepeatDataComponent_Template_sl_select_sl_select_9_listener($event) { return ctx.changeFileType($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](10, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "sl-menu-item", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "sl-menu-item", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](17, "sl-menu-item", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](20, "sl-menu-item", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](23, AddRepeatDataComponent_div_23_Template, 18, 28, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](24, "app-file-upload", 7, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("uploadFile", function AddRepeatDataComponent_Template_app_file_upload_uploadFile_24_listener($event) { return ctx.onChangeDataUpload($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](26, "app-file-upload", 7, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("uploadFile", function AddRepeatDataComponent_Template_app_file_upload_uploadFile_26_listener($event) { return ctx.onAddDataUpload($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](28, "div", 9)(29, "sl-button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddRepeatDataComponent_Template_sl_button_click_29_listener() { return ctx.onCancelClick(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](30);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](31, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](32, "core-notify", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](35, "app-add-repeat-data-conformation-modal", 12, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onAddData", function AddRepeatDataComponent_Template_app_add_repeat_data_conformation_modal_onAddData_35_listener($event) { return ctx.onAddDataFromModal($event); })("onEditData", function AddRepeatDataComponent_Template_app_add_repeat_data_conformation_modal_onEditData_35_listener($event) { return ctx.onEditDataFromModal($event); })("onCancel", function AddRepeatDataComponent_Template_app_add_repeat_data_conformation_modal_onCancel_35_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r11); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](25); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](_r1.reset()); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](37, "app-add-repeat-data-final-modal", 14, 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onCancel", function AddRepeatDataComponent_Template_app_add_repeat_data_final_modal_onCancel_37_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r11); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](25); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](_r1.reset()); })("onBackToSettings", function AddRepeatDataComponent_Template_app_add_repeat_data_final_modal_onBackToSettings_37_listener($event) { return ctx.openConformationModal($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](39, "core-notify", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](40);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](41, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](4, 24, "fileType"));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](7, 26, "chooseFileType"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx.fileTypeValue)("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](10, 28, "fileTypePlaceholder"));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx.FileType.Xls);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](13, 30, "fileType#" + ctx.FileType.Xls), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx.FileType.Csv);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](16, 32, "fileType#" + ctx.FileType.Csv), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx.FileType.Json);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](19, 34, "fileType#" + ctx.FileType.Json), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx.FileType.Xml);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](22, 36, "fileType#" + ctx.FileType.Xml), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.isCsvText);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("fileType", ctx.getFileType())("disabled", ctx.isDisabled)("loading", ctx.isRepeatWaiting)("viewData", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](45, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("fileType", ctx.getFileType())("disabled", ctx.isDisabled)("loading", ctx.isAddWaiting)("viewData", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](46, _c5));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](31, 38, "cancelButtonLabel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind2"](34, 40, "fileError", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction1"](47, _c3, ctx.error)), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](41, 43, "fileDatasetColumnsWarning"), "\n");
    } }, styles: ["sl-card[_ngcontent-%COMP%] {\n  width: 100%;\n}\nsl-card[_ngcontent-%COMP%]::part(base) {\n  border-radius: 4px;\n}\n.header[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  font-weight: var(--sl-font-weight-semibold);\n}\n.sub-header[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-600);\n  padding-top: 15px;\n  padding-bottom: 15px;\n}\n.file-type[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%] {\n  padding-top: 5px;\n}\n.file-type[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%] {\n  width: 50%;\n}\n.csv-text-settings[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-large) var(--sl-spacing-medium);\n  border: 1px dashed var(--sl-color-primary-500);\n  border-radius: var(--sl-border-radius-medium);\n  margin-top: 25px;\n}\n.csv-text-settings[_ngcontent-%COMP%]   .form[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  justify-content: space-between;\n}\n.csv-text-settings[_ngcontent-%COMP%]   .form[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]:first-child {\n  width: 35%;\n}\n.csv-text-settings[_ngcontent-%COMP%]   .form[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]:last-child {\n  width: 63%;\n}\n.csv-text-settings[_ngcontent-%COMP%]   .form[_ngcontent-%COMP%]   sl-input.error[_ngcontent-%COMP%]::part(base) {\n  border: 1px solid var(--sl-color-danger-600);\n  box-shadow: 0 0 0 2px var(--sl-color-shadows-error-500);\n}\n.csv-text-settings[_ngcontent-%COMP%]   .form[_ngcontent-%COMP%]   .error-message[_ngcontent-%COMP%] {\n  color: var(--sl-color-danger-600);\n  font-size: var(--sl-font-size-x-small);\n  margin-top: 5px;\n}\n.repeat-data[_ngcontent-%COMP%] {\n  margin-top: 35px;\n}\n.cancel[_ngcontent-%COMP%] {\n  margin-top: 25px;\n  display: flex;\n  justify-content: flex-end;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.Debounce)(0)
], AddRepeatDataComponent.prototype, "notify", null);


/***/ }),

/***/ 9111:
/*!****************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/add-repeat-data/components/file-upload/file-upload.component.ts ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileUploadComponent": () => (/* binding */ FileUploadComponent),
/* harmony export */   "LoadingStatus": () => (/* binding */ LoadingStatus)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/enums/plugin */ 3762);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);







function FileUploadComponent_ng_container_9_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function FileUploadComponent_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, FileUploadComponent_ng_container_9_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r3);
} }
function FileUploadComponent_ng_container_10_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function FileUploadComponent_ng_container_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, FileUploadComponent_ng_container_10_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r3);
} }
function FileUploadComponent_ng_container_11_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function FileUploadComponent_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, FileUploadComponent_ng_container_11_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r3);
} }
function FileUploadComponent_ng_template_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "sl-icon", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx_r4.disabled && !ctx_r4.loading)("loading", ctx_r4.loading);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("name", ctx_r4.viewData.icon);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 4, ctx_r4.viewData.label), " ");
} }
const _c0 = function (a0) { return { margin: a0 }; };
const _c1 = function (a0) { return { format: a0 }; };
var LoadingStatus;
(function (LoadingStatus) {
    LoadingStatus[LoadingStatus["Default"] = 0] = "Default";
    LoadingStatus[LoadingStatus["Loading"] = 1] = "Loading";
    LoadingStatus[LoadingStatus["Success"] = 2] = "Success";
    LoadingStatus[LoadingStatus["Fail"] = 3] = "Fail";
})(LoadingStatus || (LoadingStatus = {}));
class FileUploadComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__.SubscribableComponent {
    constructor(storageApiService, responseErrorService, notifyService) {
        super();
        this.storageApiService = storageApiService;
        this.responseErrorService = responseErrorService;
        this.notifyService = notifyService;
        this.LoadingStatus = LoadingStatus;
        this.fileType = '';
        this.viewData = {
            icon: '',
            label: '',
            title: '',
            text: '',
            isMargin: false,
        };
        this.disabled = false;
        this.loading = false;
        this.uploadFile = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.loadStatus = LoadingStatus.Default;
        this.fileData = { name: '', path: '' };
    }
    get typeOfFile() {
        switch (this.fileType) {
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Xls:
                return '.xls, .xlsx';
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Json:
                return '.json';
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Csv:
                return '.txt, .csv';
            case src_app_enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Xml:
                return '.xml';
            default:
                return '';
        }
    }
    ngOnChanges() {
        if (this.fileType) {
            this.subscriptions = [
                (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(window, 'dragover').subscribe((event) => {
                    event.preventDefault();
                }),
                (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(window, 'dragleave').subscribe((event) => {
                    event.preventDefault();
                }),
                (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(window, 'drop').subscribe((event) => {
                    event.preventDefault();
                }),
            ];
        }
    }
    upload(file) {
        this.loadStatus = LoadingStatus.Loading;
        this.storageApiService.upload('dataset', file).subscribe({
            next: ({ row }) => {
                this.fileData = { name: file.name, path: row };
                this.loadStatus = LoadingStatus.Success;
                this.onFileUpload(file);
            },
            error: (response) => {
                this.loadStatus = LoadingStatus.Fail;
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'fileError',
                });
            },
        });
    }
    onDrop(event) {
        var _a;
        const file = (_a = event.dataTransfer) === null || _a === void 0 ? void 0 : _a.files[0];
        if (file)
            this.upload(file);
    }
    reset() {
        this.loadStatus = LoadingStatus.Default;
        this.fileData = { name: '', path: '' };
    }
    onFileUpload(file) {
        const type = file.name.split('.').pop();
        if (this.typeOfFile.includes(type))
            this.uploadFile.emit(this.fileData);
        else
            this.notifyService.toastByName('fileFormatError');
    }
}
FileUploadComponent.ɵfac = function FileUploadComponent_Factory(t) { return new (t || FileUploadComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.StorageApiService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyService)); };
FileUploadComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: FileUploadComponent, selectors: [["app-file-upload"]], inputs: { fileType: "fileType", viewData: "viewData", disabled: "disabled", loading: "loading" }, outputs: { uploadFile: "uploadFile" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"], _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵNgOnChangesFeature"]], decls: 17, vars: 20, consts: [[1, "container", 3, "ngClass", "drop"], [1, "header"], [1, "sub-header"], [3, "accept", "pick"], [3, "ngSwitch"], [4, "ngSwitchCase"], ["uploadButton", ""], ["variant", "danger", "name", "fileFormatError"], [4, "ngTemplateOutlet"], ["outline", "", "size", "small", "variant", "primary", 1, "upload-button", 3, "disabled", "loading"], ["slot", "prefix", 3, "name"]], template: function FileUploadComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("drop", function FileUploadComponent_Template_div_drop_0_listener($event) { return ctx.onDrop($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "core-file-source", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("pick", function FileUploadComponent_Template_core_file_source_pick_7_listener($event) { return ctx.upload($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](8, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, FileUploadComponent_ng_container_9_Template, 2, 1, "ng-container", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, FileUploadComponent_ng_container_10_Template, 2, 1, "ng-container", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, FileUploadComponent_ng_container_11_Template, 2, 1, "ng-container", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, FileUploadComponent_ng_template_12_Template, 4, 6, "ng-template", null, 6, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "core-notify", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](16, _c0, ctx.viewData.isMargin));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 9, ctx.viewData.title));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](6, 11, ctx.viewData.text), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("accept", ctx.typeOfFile);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitch", ctx.loadStatus);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx.LoadingStatus.Default);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx.LoadingStatus.Loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngSwitchCase", ctx.LoadingStatus.Success);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](16, 13, "fileFormatError", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](18, _c1, ctx.typeOfFile)), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgClass, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgTemplateOutlet, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgSwitch, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgSwitchCase, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FileSourceComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe], styles: [".container[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-large) var(--sl-spacing-medium);\n  border: 1px dashed var(--sl-color-primary-500);\n  border-radius: var(--sl-border-radius-medium);\n  margin-top: 25px;\n}\n.container.margin[_ngcontent-%COMP%] {\n  margin-top: 35px;\n}\n.header[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  font-weight: var(--sl-font-weight-semibold);\n}\n.sub-header[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-600);\n  padding-top: 15px;\n  padding-bottom: 15px;\n}\n.uploaded-file[_ngcontent-%COMP%] {\n  width: 100%;\n  display: flex;\n  justify-content: center;\n  margin-bottom: var(--sl-spacing-small);\n}\ncore-file-item[_ngcontent-%COMP%] {\n  grid-column: 2;\n  justify-content: center;\n}\ncore-file-source[_ngcontent-%COMP%] {\n  margin-left: 0 !important;\n}\ncore-file[_ngcontent-%COMP%]     .drop-zone {\n  position: relative;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGUtdXBsb2FkLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0kseURBQUE7RUFDQSw4Q0FBQTtFQUNBLDZDQUFBO0VBQ0EsZ0JBQUE7QUFDSjtBQUNJO0VBQ0ksZ0JBQUE7QUFDUjtBQUdBO0VBQ0kscUNBQUE7RUFDQSwyQ0FBQTtBQURKO0FBSUE7RUFDSSxvQ0FBQTtFQUNBLG9DQUFBO0VBQ0EsaUJBQUE7RUFDQSxvQkFBQTtBQUZKO0FBS0E7RUFDSSxXQUFBO0VBQ0EsYUFBQTtFQUNBLHVCQUFBO0VBQ0Esc0NBQUE7QUFISjtBQU1BO0VBQ0ksY0FBQTtFQUNBLHVCQUFBO0FBSko7QUFPQTtFQUNJLHlCQUFBO0FBTEo7QUFRQTtFQUVRLGtCQUFBO0FBUFIiLCJmaWxlIjoiZmlsZS11cGxvYWQuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuY29udGFpbmVyIHtcbiAgICBwYWRkaW5nOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKSB2YXIoLS1zbC1zcGFjaW5nLW1lZGl1bSk7XG4gICAgYm9yZGVyOiAxcHggZGFzaGVkIHZhcigtLXNsLWNvbG9yLXByaW1hcnktNTAwKTtcbiAgICBib3JkZXItcmFkaXVzOiB2YXIoLS1zbC1ib3JkZXItcmFkaXVzLW1lZGl1bSk7XG4gICAgbWFyZ2luLXRvcDogMjVweDtcblxuICAgICYubWFyZ2luIHtcbiAgICAgICAgbWFyZ2luLXRvcDogMzVweDtcbiAgICB9XG59XG5cbi5oZWFkZXIge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLW1lZGl1bSk7XG4gICAgZm9udC13ZWlnaHQ6IHZhcigtLXNsLWZvbnQtd2VpZ2h0LXNlbWlib2xkKTtcbn1cblxuLnN1Yi1oZWFkZXIge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3Itc2Vjb25kYXJ5LTYwMCk7XG4gICAgcGFkZGluZy10b3A6IDE1cHg7XG4gICAgcGFkZGluZy1ib3R0b206IDE1cHg7XG59XG5cbi51cGxvYWRlZC1maWxlIHtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLXNwYWNpbmctc21hbGwpO1xufVxuXG5jb3JlLWZpbGUtaXRlbSB7XG4gICAgZ3JpZC1jb2x1bW46IDI7XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG59XG5cbmNvcmUtZmlsZS1zb3VyY2Uge1xuICAgIG1hcmdpbi1sZWZ0OiAwICFpbXBvcnRhbnQ7XG59XG5cbmNvcmUtZmlsZSB7XG4gICAgOjpuZy1kZWVwIC5kcm9wLXpvbmUge1xuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgfVxufVxuIl19 */"] });


/***/ }),

/***/ 7227:
/*!***************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/column/column.component.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnComponent": () => (/* binding */ ColumnComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ts-enum-to-array */ 141);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./storage */ 6563);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _dataset_settings_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dataset-settings.service */ 714);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _api_column_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../api/column-api.service */ 9719);
/* harmony import */ var _api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../api/dataset-api.service */ 5640);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../modals/confirm/confirm.component */ 8268);
/* harmony import */ var _components_column_formatting_column_formatting_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/column-formatting/column-formatting.component */ 4091);
/* harmony import */ var _components_conversion_result_column_conversion_result_column_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/conversion-result-column/conversion-result-column.component */ 8208);

















function ColumnComponent_sl_menu_item_10_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "sl-menu-item", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ColumnComponent_sl_menu_item_10_Template_sl_menu_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r5.hideParameterColumnFormatting = false); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} if (rf & 2) {
    const type_r4 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("disabled", type_r4.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("value", type_r4.columnType)("disabled", type_r4.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](2, 5, "optionType." + type_r4.columnType), " ");
} }
function ColumnComponent_app_column_formatting_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "app-column-formatting", 16);
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("column", ctx_r1.row)("formattingControl", ctx_r1.formattingControl);
} }
function ColumnComponent_app_conversion_result_column_12_Template(rf, ctx) { if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "app-conversion-result-column", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("onCancel", function ColumnComponent_app_conversion_result_column_12_Template_app_conversion_result_column_onCancel_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r8); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r7.undoTypeChange()); })("onSetMask", function ColumnComponent_app_conversion_result_column_12_Template_app_conversion_result_column_onSetMask_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r8); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r9.setMask($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("form", ctx_r2.form)("baseType", ctx_r2.baseType);
} }
class ColumnComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_9__.SubscribableComponent {
    constructor(datasetSettingsService, activatedRoute, router, columnApiService, datasetApiService, notifyService, formService, responseErrorService) {
        super();
        this.datasetSettingsService = datasetSettingsService;
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.columnApiService = columnApiService;
        this.datasetApiService = datasetApiService;
        this.notifyService = notifyService;
        this.formService = formService;
        this.responseErrorService = responseErrorService;
        this.MenuItemStates = _storage__WEBPACK_IMPORTED_MODULE_1__.MenuItemStates;
        this.datasetType = plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.DatasetType.Local;
        this.baseType = plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ColumnType.String;
        this.columnData = [];
        this.hideParameterColumnFormatting = true;
        this.columnTypes = [];
        this.form = this.formService
            .create({
            id: [],
            name: [],
            base_type: [],
            formatter: new _angular_forms__WEBPACK_IMPORTED_MODULE_11__.UntypedFormControl(),
            conversion: this.createConversionForm(),
        })
            .setup({
            method: this.columnApiService.update,
            methodContext: this.columnApiService,
            methodArguments: () => [this.datasetSettingsService.datasetId],
            success: () => {
                this.datasetSettingsService.onChangeColumn.emit();
                this.notifyService.toastByName('editColumn');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'editColumnNotifyDanger',
                });
            },
        });
        this.formattingControl = this.form.get('formatter');
        this.conversionControl = this.form.get('conversion');
    }
    get disabled() {
        return this.datasetType === plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.DatasetType.Joined;
    }
    ngOnInit() {
        this.subscriptions = [
            this.activatedRoute.params.subscribe(() => {
                this.hideParameterColumnFormatting = true;
                this.load();
            }),
            this.activatedRoute.queryParams.subscribe(({ type }) => {
                this.datasetType = type;
            }),
        ];
    }
    delete() {
        var _a;
        if (this.datasetSettingsService.currentDataset.value) {
            this.datasetApiService
                .deleteColumn((_a = this.datasetSettingsService.currentDataset.value) === null || _a === void 0 ? void 0 : _a.id, this.row.id)
                .subscribe({
                next: () => {
                    this.datasetSettingsService.onChangeColumn.emit();
                    this.router.navigate(['../../'], {
                        relativeTo: this.activatedRoute,
                    });
                    this.notifyService.toastByName('deleteColumn');
                },
                error: (response) => {
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: 'deleteColumnNotifyDanger',
                    });
                },
            });
        }
    }
    undoTypeChange() {
        this.hideParameterColumnFormatting = true;
        this.form.reset(this.row, { emitEvent: false });
    }
    setMask(dateFormat) {
        this.formattingControl.patchValue({
            date_format: dateFormat,
        });
    }
    changeBaseType(event) {
        this.form.patchValue({
            base_type: (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.valueOf)(event),
        });
    }
    load() {
        this.columnApiService
            .get(this.datasetSettingsService.datasetId, this.activatedRoute.snapshot.params.column_id)
            .subscribe((row) => {
            this.row = row;
            this.baseType = row.base_type;
            this.form.patchValue(row);
            this.conversionControl.patchValue({
                need_convert: false,
                to_type: null,
            });
            this.createMenuItems();
        });
    }
    createMenuItems() {
        let arrayItem = this.MenuItemStates[this.row.base_type];
        this.columnTypes = [];
        (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__.enumToArray)(plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ColumnType).forEach((columnType) => {
            this.columnTypes.push({
                disabled: arrayItem[columnType],
                columnType: columnType,
            });
        });
    }
    createConversionForm() {
        return this.formService.form({
            need_convert: [false],
            to_type: [],
            date_mask: new _angular_forms__WEBPACK_IMPORTED_MODULE_11__.UntypedFormControl(),
        });
    }
}
ColumnComponent.ɵfac = function ColumnComponent_Factory(t) { return new (t || ColumnComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_dataset_settings_service__WEBPACK_IMPORTED_MODULE_2__.DatasetSettingsService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_12__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_12__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_api_column_api_service__WEBPACK_IMPORTED_MODULE_3__.ColumnApiService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.ResponseErrorService)); };
ColumnComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineComponent"]({ type: ColumnComponent, selectors: [["app-column"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵInheritDefinitionFeature"]], decls: 28, vars: 27, consts: [[3, "data"], [1, "header"], [1, "inputs-container"], ["name", "name", 3, "label"], [1, "select-type", 3, "label", "disabled", "value", "sl-change"], [3, "disabled", "value", "click", 4, "ngFor", "ngForOf"], [3, "column", "formattingControl", 4, "ngIf"], [3, "form", "baseType", "onCancel", "onSetMask", 4, "ngIf"], [1, "actions"], ["outline", "", "variant", "primary", 3, "click"], ["variant", "primary", "type", "submit"], ["title", "deleteColumn", "description", "deleteColumnDescription", 3, "onOk"], ["confirmComponent", ""], ["variant", "success", "name", "editColumn"], ["variant", "success", "name", "deleteColumn"], [3, "value", "disabled", "click"], [3, "column", "formattingControl"], [3, "form", "baseType", "onCancel", "onSetMask"]], template: function ColumnComponent_Template(rf, ctx) { if (rf & 1) {
        const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "core-form", 0)(1, "sl-card")(2, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](5, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](6, "sl-input", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](7, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](8, "sl-select", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("sl-change", function ColumnComponent_Template_sl_select_sl_change_8_listener($event) { return ctx.changeBaseType($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](10, ColumnComponent_sl_menu_item_10_Template, 3, 7, "sl-menu-item", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](11, ColumnComponent_app_column_formatting_11_Template, 1, 2, "app-column-formatting", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](12, ColumnComponent_app_conversion_result_column_12_Template, 1, 2, "app-conversion-result-column", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](13, "div", 8)(14, "sl-button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function ColumnComponent_Template_sl_button_click_14_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r10); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](21); return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](_r3.show()); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](17, "sl-button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](20, "app-confirm", 11, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("onOk", function ColumnComponent_Template_app_confirm_onOk_20_listener() { return ctx.delete(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](22, "core-notify", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](25, "core-notify", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](26);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](27, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](4, 13, "columnHeader"));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](7, 15, "columnTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](9, 17, "typeTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("disabled", ctx.disabled)("value", ctx.form.value.base_type);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngForOf", ctx.columnTypes);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.hideParameterColumnFormatting);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", !ctx.hideParameterColumnFormatting);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](16, 19, "deleteButton"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](19, 21, "$.save"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](24, 23, "editColumnNotify"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind1"](27, 25, "deleteColumnNotify"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_13__.NgIf, _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_5__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.NotifyComponent, _components_column_formatting_column_formatting_component__WEBPACK_IMPORTED_MODULE_6__.ColumnFormattingComponent, _components_conversion_result_column_conversion_result_column_component__WEBPACK_IMPORTED_MODULE_7__.ConversionResultColumnComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_10__.TranslatePipe], styles: [".header[_ngcontent-%COMP%] {\n  padding-bottom: var(--sl-spacing-medium);\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  font-size: var(--sl-font-size-small);\n  line-height: 29px;\n}\nsl-card[_ngcontent-%COMP%] {\n  --padding: 16px 24px 32px 24px;\n  display: block;\n}\n.inputs-container[_ngcontent-%COMP%] {\n  display: flex;\n  gap: 10px;\n}\nsl-input[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-bottom: var(--sl-spacing-medium);\n}\nsl-input[_ngcontent-%COMP%]:first-child {\n  min-width: 438px;\n}\n.select-type[_ngcontent-%COMP%] {\n  width: 100%;\n  max-width: 200px;\n}\n.select-type[_ngcontent-%COMP%]   sl-menu-item.disabled[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n.actions[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  gap: var(--sl-spacing-medium);\n  margin-top: var(--sl-spacing-x-large);\n}\n.format-toggler[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-large);\n}\n.format-toggler[_ngcontent-%COMP%]::part(base) {\n  -webkit-text-decoration: underline dashed var(--sl-color-primary-500);\n          text-decoration: underline dashed var(--sl-color-primary-500);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbHVtbi5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLHdDQUFBO0VBQ0Esb0NBQUE7RUFDQSx1Q0FBQTtFQUNBLG9DQUFBO0VBQ0EsaUJBQUE7QUFDSjtBQUVBO0VBQ0ksOEJBQUE7RUFDQSxjQUFBO0FBQUo7QUFHQTtFQUNJLGFBQUE7RUFDQSxTQUFBO0FBREo7QUFJQTtFQUNJLFdBQUE7RUFDQSx1Q0FBQTtBQUZKO0FBS0E7RUFDSSxnQkFBQTtBQUhKO0FBTUE7RUFDSSxXQUFBO0VBQ0EsZ0JBQUE7QUFKSjtBQU1JO0VBQ0ksb0JBQUE7QUFKUjtBQVFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EseUJBQUE7RUFDQSw2QkFBQTtFQUNBLHFDQUFBO0FBTko7QUFTQTtFQUNJLHNDQUFBO0FBUEo7QUFTSTtFQUNJLHFFQUFBO1VBQUEsNkRBQUE7QUFQUiIsImZpbGUiOiJjb2x1bW4uY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuaGVhZGVyIHtcbiAgICBwYWRkaW5nLWJvdHRvbTogdmFyKC0tc2wtc3BhY2luZy1tZWRpdW0pO1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktOTAwKTtcbiAgICBmb250LXdlaWdodDogdmFyKC0tc2wtZm9udC13ZWlnaHQtYm9sZCk7XG4gICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUtc21hbGwpO1xuICAgIGxpbmUtaGVpZ2h0OiAyOXB4O1xufVxuXG5zbC1jYXJkIHtcbiAgICAtLXBhZGRpbmc6IDE2cHggMjRweCAzMnB4IDI0cHg7XG4gICAgZGlzcGxheTogYmxvY2s7XG59XG5cbi5pbnB1dHMtY29udGFpbmVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGdhcDogMTBweDtcbn1cblxuc2wtaW5wdXQge1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKTtcbn1cblxuc2wtaW5wdXQ6Zmlyc3QtY2hpbGQge1xuICAgIG1pbi13aWR0aDogNDM4cHg7XG59XG5cbi5zZWxlY3QtdHlwZSB7XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgbWF4LXdpZHRoOiAyMDBweDtcblxuICAgICYgc2wtbWVudS1pdGVtLmRpc2FibGVkIHtcbiAgICAgICAgcG9pbnRlci1ldmVudHM6IG5vbmU7XG4gICAgfVxufVxuXG4uYWN0aW9ucyB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBhbGlnbi1pdGVtczogY2VudGVyO1xuICAgIGp1c3RpZnktY29udGVudDogZmxleC1lbmQ7XG4gICAgZ2FwOiB2YXIoLS1zbC1zcGFjaW5nLW1lZGl1bSk7XG4gICAgbWFyZ2luLXRvcDogdmFyKC0tc2wtc3BhY2luZy14LWxhcmdlKTtcbn1cblxuLmZvcm1hdC10b2dnbGVyIHtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcblxuICAgICY6OnBhcnQoYmFzZSkge1xuICAgICAgICB0ZXh0LWRlY29yYXRpb246IHVuZGVybGluZSBkYXNoZWQgdmFyKC0tc2wtY29sb3ItcHJpbWFyeS01MDApO1xuICAgIH1cbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_14__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_15__.WatchChanges)()
], ColumnComponent.prototype, "columnData", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_14__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_15__.WatchChanges)()
], ColumnComponent.prototype, "hideParameterColumnFormatting", void 0);


/***/ }),

/***/ 4091:
/*!*******************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/column/components/column-formatting/column-formatting.component.ts ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnFormattingComponent": () => (/* binding */ ColumnFormattingComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library/column-formatting */ 418);








function ColumnFormattingComponent_core_column_formatting_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "core-column-formatting", 2);
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("columnType", ctx_r0.column.base_type)("control", ctx_r0.form);
} }
class ColumnFormattingComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__.SubscribableComponent {
    constructor(formatService, formService) {
        super();
        this.formatService = formatService;
        this.formService = formService;
        this.columnFormattingVisible = false;
        this.form = this.formService.form({
            bool_false_format: [],
            bool_true_format: [],
            date_format: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl(),
            digit_capacity: [],
            digits_separate_type: [],
            prefix: [],
            separate_digits: [],
            suffix: [],
        });
    }
    set column(column) {
        if (!column)
            return;
        this._column = column;
        this.form.patchValue(column.formatter || this.formatService.getDefault(column.base_type));
    }
    get column() {
        return this._column;
    }
    ngOnInit() {
        this.subscriptions = [
            this.form.valueChanges.subscribe((value) => {
                this.formattingControl.patchValue(value, {
                    emitEvent: false,
                });
            }),
        ];
    }
    toggleVisibility() {
        this.columnFormattingVisible = !this.columnFormattingVisible;
    }
}
ColumnFormattingComponent.ɵfac = function ColumnFormattingComponent_Factory(t) { return new (t || ColumnFormattingComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormatService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService)); };
ColumnFormattingComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ColumnFormattingComponent, selectors: [["app-column-formatting"]], inputs: { column: "column", formattingControl: "formattingControl" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]], decls: 4, vars: 4, consts: [["variant", "text", "size", "medium", 1, "format-toggler", 3, "click"], [3, "columnType", "control", 4, "ngIf"], [3, "columnType", "control"]], template: function ColumnFormattingComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-button", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ColumnFormattingComponent_Template_sl_button_click_0_listener() { return ctx.toggleVisibility(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, ColumnFormattingComponent_core_column_formatting_3_Template, 1, 2, "core-column-formatting", 1);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 2, "formatting"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.columnFormattingVisible);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_5__.ColumnFormattingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: [".format-toggler[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-large);\n}\n.format-toggler[_ngcontent-%COMP%]::part(base) {\n  -webkit-text-decoration: underline dashed var(--sl-color-primary-500);\n          text-decoration: underline dashed var(--sl-color-primary-500);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbHVtbi1mb3JtYXR0aW5nLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksc0NBQUE7QUFDSjtBQUNJO0VBQ0kscUVBQUE7VUFBQSw2REFBQTtBQUNSIiwiZmlsZSI6ImNvbHVtbi1mb3JtYXR0aW5nLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLmZvcm1hdC10b2dnbGVyIHtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcblxuICAgICY6OnBhcnQoYmFzZSkge1xuICAgICAgICB0ZXh0LWRlY29yYXRpb246IHVuZGVybGluZSBkYXNoZWQgdmFyKC0tc2wtY29sb3ItcHJpbWFyeS01MDApO1xuICAgIH1cbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_7__.UpdateImmediately)()
], ColumnFormattingComponent.prototype, "columnFormattingVisible", void 0);


/***/ }),

/***/ 8208:
/*!*********************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/column/components/conversion-result-column/conversion-result-column.component.ts ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConversionResultColumnComponent": () => (/* binding */ ConversionResultColumnComponent),
/* harmony export */   "ListSize": () => (/* binding */ ListSize)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ts-enum-to-array */ 141);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../storage */ 6563);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _dataset_settings_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../dataset-settings.service */ 714);
/* harmony import */ var _api_column_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../../api/column-api.service */ 9719);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modal_mask_modal_mask_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modal-mask/modal-mask.component */ 2852);














const _c0 = ["modalMaskComponent"];
function ConversionResultColumnComponent_sl_button_0_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "sl-button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function ConversionResultColumnComponent_sl_button_0_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r6); _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](17); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](_r4.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](2, 1, "modalMaskComponent.mask"), "\n");
} }
function ConversionResultColumnComponent_sl_menu_item_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "sl-menu-item", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} if (rf & 2) {
    const size_r7 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", size_r7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", ctx_r1.getItem(size_r7), " ");
} }
function ConversionResultColumnComponent_tr_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "tr")(1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const item_r8 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](item_r8);
} }
function ConversionResultColumnComponent_core_pagination_12_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "core-pagination", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onPageChange", function ConversionResultColumnComponent_core_pagination_12_Template_core_pagination_onPageChange_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r10); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r9.onPageChange($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("total", ctx_r3.dataset.metadata.count)("limit", ctx_r3.ListSize.Hundred)("page", ctx_r3.page);
} }
var ListSize;
(function (ListSize) {
    ListSize[ListSize["Default"] = 10] = "Default";
    ListSize[ListSize["Fifty"] = 50] = "Fifty";
    ListSize[ListSize["Hundred"] = 100] = "Hundred";
    ListSize["All"] = "all";
})(ListSize || (ListSize = {}));
class ConversionResultColumnComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_6__.SubscribableComponent {
    constructor(activatedRoute, datasetSettingsService, translateService, columnApiService, responseErrorService) {
        super();
        this.activatedRoute = activatedRoute;
        this.datasetSettingsService = datasetSettingsService;
        this.translateService = translateService;
        this.columnApiService = columnApiService;
        this.responseErrorService = responseErrorService;
        this.baseType = plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.String;
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_5__.EventEmitter();
        this.onSetMask = new _angular_core__WEBPACK_IMPORTED_MODULE_5__.EventEmitter();
        this.listSizeArray = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__.enumToArray)(ListSize);
        this.ListSize = ListSize;
        this.limit = ListSize.Default;
        this.previewData = [];
        this.page = 1;
        this.params = {
            limit: Number(ListSize.Default),
            offset: 0,
            date_mask: [],
            to_type: '',
        };
    }
    get isShowDateMask() {
        const baseType = this.form.get('base_type').value;
        return (baseType === plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Date && this.baseType !== plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Number);
    }
    get dataset() {
        return this.datasetSettingsService.currentDataset.value;
    }
    get defaultDateFormat() {
        const mask = plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.DateFormatSettings.getEmpty().date_format;
        mask.forEach((item) => {
            if (item.type === plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.FormatDateUnitType.Year)
                item.value = plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.FormatDateUnitValue.XL;
        });
        return mask;
    }
    ngOnInit() {
        this.conversionControl = this.form.get('conversion');
        this.subscriptions = [
            this.form.get('base_type').valueChanges.subscribe((type) => {
                if (type === plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ColumnType.Date) {
                    if (this.isShowDateMask)
                        this.modalMaskComponent.show();
                    else
                        this.setMask(this.defaultDateFormat);
                }
                this.setArgument(_storage__WEBPACK_IMPORTED_MODULE_1__.ColumnTypeString[type]);
            }),
        ];
    }
    getItem(listSize) {
        if (listSize === ListSize.All) {
            return this.translateService.getTranslation(`listSize.${ListSize.All}`);
        }
        else
            return listSize;
    }
    onPageChange(page) {
        this.page = page;
        this.params.offset = (page - 1) * this.params.limit;
        this.getPreviewData();
    }
    setMask(dateMask) {
        this.params.date_mask = dateMask;
        this.conversionControl.patchValue({
            date_mask: dateMask,
        });
        this.onSetMask.emit(dateMask);
        if (this.isShowDateMask)
            this.getPreviewData();
    }
    changeCountPreview(event) {
        let limit = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.valueOf)(event);
        if (limit === 'all') {
            this.limit = this.params.limit = ListSize.Hundred;
            this.listSize = ListSize.All;
            this.page = 1;
        }
        else {
            this.limit = this.params.limit = Number(limit);
            this.params.offset = 0;
            this.listSize = undefined;
        }
        this.getPreviewData();
    }
    getPreviewData() {
        this.columnApiService
            .getConversionPreview(this.datasetSettingsService.datasetId, this.activatedRoute.snapshot.params.column_id, this.params)
            .subscribe({
            next: (previewData) => {
                this.previewData = [...previewData];
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'conversionResultColumn.error.preload',
                });
            },
        });
    }
    setArgument(toType) {
        this.params.to_type = toType;
        this.conversionControl.patchValue({
            need_convert: true,
            to_type: toType,
        });
        this.getPreviewData();
    }
}
ConversionResultColumnComponent.ɵfac = function ConversionResultColumnComponent_Factory(t) { return new (t || ConversionResultColumnComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_8__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_dataset_settings_service__WEBPACK_IMPORTED_MODULE_2__.DatasetSettingsService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TranslateService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_api_column_api_service__WEBPACK_IMPORTED_MODULE_3__.ColumnApiService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.ResponseErrorService)); };
ConversionResultColumnComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({ type: ConversionResultColumnComponent, selectors: [["app-conversion-result-column"]], viewQuery: function ConversionResultColumnComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_c0, 7);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.modalMaskComponent = _t.first);
    } }, inputs: { form: "form", baseType: "baseType" }, outputs: { onCancel: "onCancel", onSetMask: "onSetMask" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵInheritDefinitionFeature"]], decls: 18, vars: 14, consts: [["class", "format-toggler", "variant", "text", "size", "medium", 3, "click", 4, "ngIf"], [3, "value", "label", "sl-change"], [3, "value", 4, "ngFor", "ngForOf"], [1, "pagination"], [1, "table"], [4, "ngFor", "ngForOf"], [3, "total", "limit", "page", "onPageChange", 4, "ngIf"], ["outline", "", "variant", "primary", 3, "click"], [3, "onSetMask"], ["modalMaskComponent", ""], ["variant", "text", "size", "medium", 1, "format-toggler", 3, "click"], [3, "value"], [3, "total", "limit", "page", "onPageChange"]], template: function ConversionResultColumnComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](0, ConversionResultColumnComponent_sl_button_0_Template, 3, 3, "sl-button", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "sl-select", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("sl-change", function ConversionResultColumnComponent_Template_sl_select_sl_change_4_listener($event) { return ctx.changeCountPreview($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](6, ConversionResultColumnComponent_sl_menu_item_6_Template, 2, 2, "sl-menu-item", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "div", 3)(8, "div", 4)(9, "table")(10, "tbody");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, ConversionResultColumnComponent_tr_11_Template, 3, 1, "tr", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](12, ConversionResultColumnComponent_core_pagination_12_Template, 1, 3, "core-pagination", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](13, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function ConversionResultColumnComponent_Template_sl_button_click_13_listener() { return ctx.onCancel.emit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](14);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](16, "app-modal-mask", 8, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSetMask", function ConversionResultColumnComponent_Template_app_modal_mask_onSetMask_16_listener($event) { return ctx.setMask($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.isShowDateMask);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](3, 8, "columnComponent.warning"));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("value", ctx.ListSize.Default)("label", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](5, 10, "conversionResultColumn.numberOfLines"));
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngForOf", ctx.listSizeArray);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngForOf", ctx.previewData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.listSize === ctx.ListSize.All && ctx.dataset.metadata.count > ctx.ListSize.Hundred);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpipeBind1"](15, 12, "$.cancel"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.PaginationComponent, _modal_mask_modal_mask_component__WEBPACK_IMPORTED_MODULE_4__.ModalMaskComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_7__.TranslatePipe], styles: ["p[_ngcontent-%COMP%] {\n  margin: var(--sl-spacing-medium) 0;\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n  color: var(--sl-color-info-500);\n}\n.pagination[_ngcontent-%COMP%] {\n  width: 50%;\n  border: 1px solid var(--sl-color-neutral-50);\n}\n.table[_ngcontent-%COMP%] {\n  max-height: 410px;\n  overflow: scroll;\n  padding: var(--sl-spacing-medium);\n}\ntable[_ngcontent-%COMP%] {\n  width: 100%;\n}\ntable[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: 600;\n  line-height: 29px;\n  padding-bottom: var(--sl-spacing-medium);\n}\ntable[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]:nth-child(odd) {\n  background-color: var(--sl-color-neutral-50);\n}\ntable[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]:nth-child(odd) {\n  background-color: var(--sl-color-neutral-50);\n}\ntable[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n  min-height: 34px;\n  padding: var(--sl-spacing-x-small) var(--sl-spacing-medium);\n  font-size: 13px;\n  line-height: 18px;\n}\nsl-button[_ngcontent-%COMP%]:not(.format-toggler) {\n  margin-top: var(--sl-spacing-medium);\n}\nsl-button[_ngcontent-%COMP%]:not(.format-toggler)::part(base) {\n  max-width: 94px;\n  max-height: 26px;\n  font-size: 13px;\n  line-height: 25px;\n}\nsl-select[_ngcontent-%COMP%] {\n  max-width: 140px;\n  margin-bottom: var(--sl-spacing-medium);\n}\ncore-pagination[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-medium);\n  margin-bottom: var(--sl-spacing-medium);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_11__.WatchChanges)()
], ConversionResultColumnComponent.prototype, "previewData", void 0);


/***/ }),

/***/ 2852:
/*!******************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/column/components/conversion-result-column/modal-mask/modal-mask.component.ts ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalMaskComponent": () => (/* binding */ ModalMaskComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library/column-formatting */ 418);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);







const _c0 = function (a0, a1, a2) { return [a0, a1, a2]; };
class ModalMaskComponent {
    constructor(formService, translateService) {
        this.formService = formService;
        this.translateService = translateService;
        this.onSetMask = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.FormatDateUnitType = plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.FormatDateUnitType;
        this.ColumnType = plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.ColumnType;
        this.isOpen = false;
        this.form = this.formService.form({
            date_format: new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl(),
        });
    }
    get placeholder() {
        const mask = this.dateFormat.filter((date) => !date.disabled);
        return this.setPlaceholder(mask);
    }
    get dateFormat() {
        return this.form.get('date_format').value;
    }
    ngOnInit() {
        this.form.reset(plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.DateFormatSettings.getEmpty());
    }
    setMask() {
        this.onSetMask.emit(this.dateFormat);
        this.isOpen = false;
    }
    show() {
        this.isOpen = true;
    }
    setPlaceholder(dateMask) {
        const result = [];
        dateMask.forEach((item) => {
            result.push(this.translateService.getTranslation('_$$.columnFormatting.dateFormatting.value.' +
                item.type +
                item.value), item.suffix);
        });
        return result.join('');
    }
}
ModalMaskComponent.ɵfac = function ModalMaskComponent_Factory(t) { return new (t || ModalMaskComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.TranslateService)); };
ModalMaskComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ModalMaskComponent, selectors: [["app-modal-mask"]], outputs: { onSetMask: "onSetMask" }, decls: 15, vars: 20, consts: [[3, "label", "open", "openChange", "hide"], ["disabled", "", 3, "value"], [3, "data"], ["name", "date_format", 3, "disableChechboxes"], ["variant", "primary", 1, "button", 3, "click"]], template: function ModalMaskComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("openChange", function ModalMaskComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; })("hide", function ModalMaskComponent_Template_sl_dialog_hide_0_listener() { return ctx.isOpen = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "section")(3, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "sl-input", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "core-form", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](11, "plmt-date-formatting", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "sl-button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function ModalMaskComponent_Template_sl_button_click_12_listener() { return ctx.setMask(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](1, 8, "modalMaskComponent.dateMask"))("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](5, 10, "modalMaskComponent.maskPreview"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("value", ctx.placeholder);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](9, 12, "modalMaskComponent.instruction"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disableChechboxes", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction3"](16, _c0, ctx.FormatDateUnitType.Year, ctx.FormatDateUnitType.Month, ctx.FormatDateUnitType.Day));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](14, 14, "$.save"), " ");
    } }, dependencies: [plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_3__.DateFormattingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.FormComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.TranslatePipe], styles: ["sl-dialog[_ngcontent-%COMP%] {\n  --width: 898px;\n}\nsection[_ngcontent-%COMP%] {\n  margin-top: 9px;\n  margin-bottom: 67px;\n}\nsection[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-950);\n  font-size: var(--sl-font-size-small);\n  line-height: 29px;\n  margin: 0 auto;\n}\nsection[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--sl-color-info-500);\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n  margin: 24px auto var(--sl-spacing-medium);\n}\nsection[_ngcontent-%COMP%]   sl-input[_ngcontent-%COMP%] {\n  max-width: 282px;\n  margin-top: var(--sl-spacing-2x-small);\n}\nsection[_ngcontent-%COMP%]   sl-input[_ngcontent-%COMP%]::part(input) {\n  color: var(--sl-color-info-500);\n}\n.button[_ngcontent-%COMP%] {\n  float: right;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vZGFsLW1hc2suY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxjQUFBO0FBQ0o7QUFFQTtFQUNJLGVBQUE7RUFDQSxtQkFBQTtBQUFKO0FBRkE7RUFLUSxvQ0FBQTtFQUNBLG9DQUFBO0VBQ0EsaUJBQUE7RUFDQSxjQUFBO0FBQVI7QUFSQTtFQVlRLCtCQUFBO0VBQ0Esb0NBQUE7RUFDQSxpQkFBQTtFQUNBLDBDQUFBO0FBRFI7QUFkQTtFQW1CUSxnQkFBQTtFQUNBLHNDQUFBO0FBRlI7QUFJUTtFQUNJLCtCQUFBO0FBRlo7QUFPQTtFQUNJLFlBQUE7QUFMSiIsImZpbGUiOiJtb2RhbC1tYXNrLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsic2wtZGlhbG9nIHtcbiAgICAtLXdpZHRoOiA4OThweDtcbn1cblxuc2VjdGlvbiB7XG4gICAgbWFyZ2luLXRvcDogOXB4O1xuICAgIG1hcmdpbi1ib3R0b206IDY3cHg7XG5cbiAgICBoMyB7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktOTUwKTtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUtc21hbGwpO1xuICAgICAgICBsaW5lLWhlaWdodDogMjlweDtcbiAgICAgICAgbWFyZ2luOiAwIGF1dG87XG4gICAgfVxuXG4gICAgcCB7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1pbmZvLTUwMCk7XG4gICAgICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICAgICAgbGluZS1oZWlnaHQ6IDE5cHg7XG4gICAgICAgIG1hcmdpbjogMjRweCBhdXRvIHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKTtcbiAgICB9XG5cbiAgICBzbC1pbnB1dCB7XG4gICAgICAgIG1heC13aWR0aDogMjgycHg7XG4gICAgICAgIG1hcmdpbi10b3A6IHZhcigtLXNsLXNwYWNpbmctMngtc21hbGwpO1xuXG4gICAgICAgICY6OnBhcnQoaW5wdXQpIHtcbiAgICAgICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1pbmZvLTUwMCk7XG4gICAgICAgIH1cbiAgICB9XG59XG5cbi5idXR0b24ge1xuICAgIGZsb2F0OiByaWdodDtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 6563:
/*!******************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/column/storage.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnTypeString": () => (/* binding */ ColumnTypeString),
/* harmony export */   "MenuItemStates": () => (/* binding */ MenuItemStates)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! plmt-core-library */ 9543);

const MenuItemStates = {
    [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.String]: {
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.String]: true,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Number]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Date]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Boolean]: true,
    },
    [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Number]: {
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.String]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Number]: true,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Date]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Boolean]: true,
    },
    [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Date]: {
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.String]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Number]: true,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Date]: true,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Boolean]: true,
    },
    [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Boolean]: {
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.String]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Number]: false,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Date]: true,
        [plmt_core_library__WEBPACK_IMPORTED_MODULE_0__.ColumnType.Boolean]: true,
    },
};
var ColumnTypeString;
(function (ColumnTypeString) {
    ColumnTypeString[ColumnTypeString["string"] = 0] = "string";
    ColumnTypeString[ColumnTypeString["number"] = 1] = "number";
    ColumnTypeString[ColumnTypeString["date"] = 2] = "date";
    ColumnTypeString[ColumnTypeString["boolean"] = 3] = "boolean";
})(ColumnTypeString || (ColumnTypeString = {}));


/***/ }),

/***/ 9603:
/*!***************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/common.component.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CommonComponent": () => (/* binding */ CommonComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../enums/plugin */ 3762);
/* harmony import */ var _modals_save_confirm_save_confirm_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../modals/save-confirm/save-confirm.component */ 3262);
/* harmony import */ var _sql_request_sql_request_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sql-request/sql-request.component */ 7455);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _dataset_settings_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dataset-settings.service */ 714);
/* harmony import */ var _api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../api/dataset-api.service */ 5640);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _dataset_update_dataset_update_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dataset-update/dataset-update.service */ 5845);
/* harmony import */ var _api_dataset_sql_api_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../api/dataset-sql-api.service */ 3967);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../modals/confirm/confirm.component */ 8268);
/* harmony import */ var _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../components/modal-actions/modal-actions.component */ 4335);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _local_rules_local_rules_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./local-rules/local-rules.component */ 6934);
/* harmony import */ var _params_params_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./params/params.component */ 8666);
/* harmony import */ var _dataset_update_dataset_update_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./dataset-update/dataset-update.component */ 3878);























const _c0 = ["tabGroup"];
const _c1 = ["lockDatasetConfirm"];
function CommonComponent_core_form_0_sl_tab_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "sl-tab", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](2, 1, "rulesTabLabel"));
} }
function CommonComponent_core_form_0_sl_tab_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "sl-tab", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](2, 1, "updateDataset"), " ");
} }
function CommonComponent_core_form_0_sl_tab_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "sl-tab", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](2, 1, "datasetSqlRequest#sqlRequest"), " ");
} }
function CommonComponent_core_form_0_app_dataset_update_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](0, "app-dataset-update", 22, 31);
} if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("dataset", ctx_r9.dataset);
} }
function CommonComponent_core_form_0_app_sql_request_17_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "app-sql-request", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("onSave", function CommonComponent_core_form_0_app_sql_request_17_Template_app_sql_request_onSave_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r13.checkOrSaveSqlResponse($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("dataset", ctx_r10.dataset);
} }
function CommonComponent_core_form_0_div_18_ng_container_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](1, "sl-tooltip", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](3, "sl-button", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("click", function CommonComponent_core_form_0_div_18_ng_container_1_ng_container_1_Template_sl_button_click_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r20); const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](4); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵreference"](7); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](_r3.show(ctx_r19.dataset)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](4, "sl-icon", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpropertyInterpolate"]("content", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](2, 2, "datasetLockTooltip"));
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](6, 4, "datasetLock"), " ");
} }
function CommonComponent_core_form_0_div_18_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](1, CommonComponent_core_form_0_div_18_ng_container_1_ng_container_1_Template, 7, 6, "ng-container", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r15.user.super_user || ctx_r15.dataset.owner.id === ctx_r15.user.id);
} }
function CommonComponent_core_form_0_div_18_ng_template_2_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](1, "sl-button", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("click", function CommonComponent_core_form_0_div_18_ng_template_2_ng_container_0_Template_sl_button_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r23); const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](4); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵreference"](7); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](_r3.show(ctx_r22.dataset)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](2, "sl-icon", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](4, 1, "datasetUnlock"), " ");
} }
function CommonComponent_core_form_0_div_18_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](0, CommonComponent_core_form_0_div_18_ng_template_2_ng_container_0_Template, 5, 3, "ng-container", 1);
} if (rf & 2) {
    const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r17.user.super_user || ctx_r17.form.get("lock").value.owner_id === ctx_r17.user.id);
} }
function CommonComponent_core_form_0_div_18_Template(rf, ctx) { if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](1, CommonComponent_core_form_0_div_18_ng_container_1_Template, 2, 1, "ng-container", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](2, CommonComponent_core_form_0_div_18_ng_template_2_Template, 1, 1, "ng-template", null, 35, _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](4, "div", 36)(5, "sl-button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("click", function CommonComponent_core_form_0_div_18_Template_sl_button_click_5_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r25); const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r24.onCancel()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](8, "sl-button", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵreference"](3);
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", !ctx_r11.isDatasetLock)("ngIfElse", _r16);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](7, 4, "$.cancel"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](10, 6, "$.apply"), " ");
} }
function CommonComponent_core_form_0_Template(rf, ctx) { if (rf & 1) {
    const _r27 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "core-form", 12)(1, "sl-card")(2, "sl-tab-group", 13, 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("sl-tab-show", function CommonComponent_core_form_0_Template_sl_tab_group_sl_tab_show_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r27); const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r26.setActiveTab($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](4, "sl-tab", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](7, CommonComponent_core_form_0_sl_tab_7_Template, 3, 3, "sl-tab", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](8, CommonComponent_core_form_0_sl_tab_8_Template, 3, 3, "sl-tab", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](9, CommonComponent_core_form_0_sl_tab_9_Template, 3, 3, "sl-tab", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](10, "sl-tab-panel", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](11, "app-params", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](12, "sl-tab-panel", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](13, "app-local-rules", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](14, "sl-tab-panel", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](15, CommonComponent_core_form_0_app_dataset_update_15_Template, 2, 1, "app-dataset-update", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](16, "sl-tab-panel", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](17, CommonComponent_core_form_0_app_sql_request_17_Template, 1, 1, "app-sql-request", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](18, CommonComponent_core_form_0_div_18_Template, 11, 8, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("data", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](6, 11, "paramsTabLabel"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r0.dataset.access_right === ctx_r0.AccessRight.Edit || ctx_r0.dataset.access_right === ctx_r0.AccessRight.Full);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r0.needToShowUpdateTab);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("beta", true);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("form", ctx_r0.form)("dataset", ctx_r0.dataset);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("dataset", ctx_r0.dataset);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r0.activeTab === ctx_r0.ActiveTabEnum.Update);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r0.activeTab === ctx_r0.ActiveTabEnum.Sql);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx_r0.activeTab === ctx_r0.ActiveTabEnum.Params);
} }
function CommonComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r29 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div")(1, "app-modal-actions", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("onCancel", function CommonComponent_div_1_Template_app_modal_actions_onCancel_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r29); const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r28.cancelUpdate()); })("onOk", function CommonComponent_div_1_Template_app_modal_actions_onOk_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r29); const ctx_r30 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r30.saveUpdate()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("hasBack", false);
} }
function CommonComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div")(1, "app-modal-actions", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("onCancel", function CommonComponent_div_2_Template_app_modal_actions_onCancel_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r32); const ctx_r31 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r31.onCancel()); })("onOk", function CommonComponent_div_2_Template_app_modal_actions_onOk_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r32); const ctx_r33 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r33.sqlRequestComponent.submit()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("hasBack", false);
} }
function CommonComponent_li_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "li");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
} if (rf & 2) {
    const dependence_r34 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", dependence_r34.name, " ");
} }
const _c2 = function (a0) { return { count: a0 }; };
var ActiveTabEnum;
(function (ActiveTabEnum) {
    ActiveTabEnum["Rules"] = "rules";
    ActiveTabEnum["Params"] = "params";
    ActiveTabEnum["Update"] = "update";
    ActiveTabEnum["Sql"] = "sql";
})(ActiveTabEnum || (ActiveTabEnum = {}));
class CommonComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_13__.SubscribableComponent {
    constructor(appService, formService, datasetSettingsService, datasetApiService, notifyService, router, responseErrorService, activatedRoute, changeDetectorRef, datasetUpdateService, datasetSqlApiService) {
        super();
        this.appService = appService;
        this.formService = formService;
        this.datasetSettingsService = datasetSettingsService;
        this.datasetApiService = datasetApiService;
        this.notifyService = notifyService;
        this.router = router;
        this.responseErrorService = responseErrorService;
        this.activatedRoute = activatedRoute;
        this.changeDetectorRef = changeDetectorRef;
        this.datasetUpdateService = datasetUpdateService;
        this.datasetSqlApiService = datasetSqlApiService;
        this.dependenciesList = [];
        this.dataset = null;
        this.activeTab = ActiveTabEnum.Params;
        this.isDatasetLock = false;
        this.lockNotification = '';
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.AccessRight;
        this.ActiveTabEnum = ActiveTabEnum;
        this.form = this.formService
            .create({
            id: [],
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.stringValidator)({ min: 1, max: 250 })]],
            comment: [null, [(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.stringValidator)({ max: 250 })]],
            users: new _angular_forms__WEBPACK_IMPORTED_MODULE_15__.FormArray([]),
            groups: new _angular_forms__WEBPACK_IMPORTED_MODULE_15__.FormArray([]),
            lock: new _angular_forms__WEBPACK_IMPORTED_MODULE_15__.UntypedFormControl(),
        })
            .setup({
            method: this.datasetApiService.edit,
            methodContext: this.datasetApiService,
            success: (response) => {
                this.datasetSettingsService.currentDataset.next(Object.assign(Object.assign({}, this.dataset), response.row));
                this.notifyService.toastByName('editDataset');
                this.router.navigate(['/dataset']);
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'notification.edit.danger',
                });
            },
        });
        this.passwordForm = this.formService.form({
            password: ['', [plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.required]],
        });
    }
    get user() {
        return this.appService.user.value;
    }
    get confirmTitle() {
        return this.isDatasetLock
            ? 'confirm.datasetUnlock'
            : 'confirm.datasetLock';
    }
    get needToShowSqlTab() {
        if (!this.dataset)
            return false;
        return this.dataset.fields.some((item) => item.name === 'sql');
    }
    get needToShowUpdateTab() {
        if (!this.dataset) {
            return false;
        }
        const datasetType = this.dataset.type;
        const datasetSourceType = this.dataset.datasource_type;
        if (!datasetType || !datasetSourceType) {
            return false;
        }
        if (datasetType === plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.DatasetType.Joined) {
            return false;
        }
        if (datasetSourceType === _enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Csv ||
            datasetSourceType === _enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Xls ||
            datasetSourceType === _enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Json ||
            datasetSourceType === _enums_plugin__WEBPACK_IMPORTED_MODULE_0__.PluginFileType.Xml) {
            return false;
        }
        return true;
    }
    ngOnInit() {
        this.subscriptions = [
            this.datasetSettingsService.currentDataset.subscribe((dataset) => {
                this.dataset = dataset;
                if (dataset) {
                    this.form.patchValue(dataset);
                    if (dataset.lock)
                        this.isDatasetLock = true;
                }
            }),
            this.form.get('lock').valueChanges.subscribe((value) => {
                this.isDatasetLock = !!value;
                this.datasetSettingsService.onLockDataset.emit(this.isDatasetLock);
            }),
        ];
    }
    ngAfterViewInit() {
        const params = this.activatedRoute.snapshot.queryParams;
        this.activeTab = [ActiveTabEnum.Params, ActiveTabEnum.Rules].includes(params.tab)
            ? params.tab
            : ActiveTabEnum.Params;
        this.tabGroup.nativeElement.show(this.activeTab);
        this.changeDetectorRef.detectChanges();
    }
    onCancel() {
        this.router.navigate(['/dataset']);
    }
    setActiveTab(event) {
        this.activeTab = event.detail.name;
        this.router.navigate(['.'], {
            relativeTo: this.activatedRoute,
            queryParams: { tab: this.activeTab },
        });
    }
    cancelLock() {
        this.passwordForm.reset();
    }
    cancelUpdate() {
        this.datasetUpdateService.cancel();
    }
    lockDataset(dataset) {
        var _a;
        if (this.passwordForm.invalid) {
            this.formService.showLocalErrors(this.passwordForm);
            this.lockDatasetConfirm.isOpen = true;
            return;
        }
        const password = (_a = this.passwordForm.get('password')) === null || _a === void 0 ? void 0 : _a.value;
        const lock = this.form.get('lock').value;
        const handler = lock
            ? this.datasetApiService.unlock(dataset.id, password)
            : this.datasetApiService.lock(dataset.id, password);
        handler.subscribe({
            next: () => {
                if (lock)
                    this.form.patchValue({
                        lock: null,
                    });
                else
                    this.form.patchValue({
                        lock: {
                            dataset_id: dataset.id,
                            owner_id: this.user.id,
                        },
                    });
                this.lockNotification = lock
                    ? 'notification.unlock'
                    : 'notification.lock';
                this.notifyService.toastByName('lockSuccess');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: lock
                        ? 'notification.unlock.danger'
                        : 'notification.lock.danger',
                });
            },
        });
        this.passwordForm.reset();
    }
    saveUpdate() {
        this.datasetUpdateService.submit();
    }
    saveSqlResponse(params) {
        const { datasource, sqlString } = params;
        this.datasetSqlApiService
            .saveSqlResponse(this.dataset.id, {
            sqlString,
            datasourceId: datasource.id,
        })
            .subscribe({
            next: () => {
                this.notifyService.toastByName('sqlResponseSuccess');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'notification.sqlResponse.danger',
                });
            },
        });
    }
    checkOrSaveSqlResponse(params) {
        this.datasetSqlApiService
            .getDependencies(this.dataset.datasource.id)
            .subscribe((response) => {
            if (response) {
                this.dependenciesList = response.rows;
                this.saveConfirm.show(params);
            }
            else {
                this.saveSqlResponse(params);
            }
        });
    }
}
CommonComponent.ɵfac = function CommonComponent_Factory(t) { return new (t || CommonComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_dataset_settings_service__WEBPACK_IMPORTED_MODULE_3__.DatasetSettingsService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_16__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_16__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_12__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_dataset_update_dataset_update_service__WEBPACK_IMPORTED_MODULE_5__.DatasetUpdateService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_api_dataset_sql_api_service__WEBPACK_IMPORTED_MODULE_6__.DatasetSqlApiService)); };
CommonComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdefineComponent"]({ type: CommonComponent, selectors: [["app-common"]], viewQuery: function CommonComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵviewQuery"](_modals_save_confirm_save_confirm_component__WEBPACK_IMPORTED_MODULE_1__.SaveConfirmComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵviewQuery"](_c1, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵviewQuery"](_sql_request_sql_request_component__WEBPACK_IMPORTED_MODULE_2__.SqlRequestComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵloadQuery"]()) && (ctx.saveConfirm = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵloadQuery"]()) && (ctx.tabGroup = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵloadQuery"]()) && (ctx.lockDatasetConfirm = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵloadQuery"]()) && (ctx.sqlRequestComponent = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵInheritDefinitionFeature"]], decls: 26, vars: 24, consts: [[3, "data", 4, "ngIf"], [4, "ngIf"], ["variant", "success", "name", "editDataset"], ["description", "confirm.enterPassword", 3, "title", "onOk", "onCancel"], ["lockDatasetConfirm", ""], [1, "password-form", 3, "data"], ["name", "password", "type", "password"], ["title", "datasetSqlRequest#saveDataset", 3, "onOk"], [1, "save-confirm"], [4, "ngFor", "ngForOf"], ["variant", "success", "name", "lockSuccess"], ["variant", "success", "name", "sqlResponseSuccess"], [3, "data"], [3, "sl-tab-show"], ["tabGroup", ""], ["slot", "nav", "panel", "params"], ["slot", "nav", "panel", "rules", 4, "ngIf"], ["slot", "nav", "panel", "update", 4, "ngIf"], ["slot", "nav", "panel", "sql", 4, "beta"], ["name", "params"], [3, "form", "dataset"], ["name", "rules"], [3, "dataset"], ["name", "update"], [3, "dataset", 4, "ngIf"], ["name", "sql"], [3, "dataset", "onSave", 4, "ngIf"], ["class", "actions", 4, "ngIf"], ["slot", "nav", "panel", "rules"], ["slot", "nav", "panel", "update"], ["slot", "nav", "panel", "sql"], ["datasetUpdate", ""], [3, "dataset", "onSave"], [1, "actions"], [4, "ngIf", "ngIfElse"], ["unlock", ""], [1, "actions-btns"], ["variant", "primary", "outline", "", 3, "click"], ["variant", "primary", "type", "submit"], [3, "content"], ["variant", "text", 1, "btn-lock", 3, "click"], ["name", "unlock"], ["name", "lock"], [3, "hasBack", "onCancel", "onOk"]], template: function CommonComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](0, CommonComponent_core_form_0_Template, 19, 13, "core-form", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](1, CommonComponent_div_1_Template, 2, 1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](2, CommonComponent_div_2_Template, 2, 1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](3, "core-notify", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](6, "app-confirm", 3, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("onOk", function CommonComponent_Template_app_confirm_onOk_6_listener() { return ctx.lockDataset(ctx.dataset); })("onCancel", function CommonComponent_Template_app_confirm_onCancel_6_listener() { return ctx.cancelLock(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](8, "core-form", 5)(9, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](10, "sl-input", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](11, "app-save-confirm", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("onOk", function CommonComponent_Template_app_save_confirm_onOk_11_listener($event) { return ctx.saveSqlResponse($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](12, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](15, "ul", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](16, CommonComponent_li_16_Template, 2, 1, "li", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](17, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](20, "core-notify", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](23, "core-notify", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](25, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.dataset);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.activeTab === ctx.ActiveTabEnum.Update);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.activeTab === ctx.ActiveTabEnum.Sql);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](5, 11, "notification.edit"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("title", ctx.confirmTitle);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("data", ctx.passwordForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind2"](14, 13, "datasetSqlRequest#saveConfirmSubTitle", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpureFunction1"](22, _c2, ctx.dependenciesList.length)), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngForOf", ctx.dependenciesList);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](19, 16, "datasetSqlRequest#saveDatasetDescription"));
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](22, 18, ctx.lockNotification), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](25, 20, "notification.sqlResponseSuccess"), "\n");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.BetaDirective, _angular_common__WEBPACK_IMPORTED_MODULE_17__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_17__.NgIf, _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_7__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.ValidateComponent, _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_8__.ModalActionsComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.NotifyComponent, _modals_save_confirm_save_confirm_component__WEBPACK_IMPORTED_MODULE_1__.SaveConfirmComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_18__.OpenableDirective, _local_rules_local_rules_component__WEBPACK_IMPORTED_MODULE_9__.LocalRulesComponent, _params_params_component__WEBPACK_IMPORTED_MODULE_10__.ParamsComponent, _dataset_update_dataset_update_component__WEBPACK_IMPORTED_MODULE_11__.DatasetUpdateComponent, _sql_request_sql_request_component__WEBPACK_IMPORTED_MODULE_2__.SqlRequestComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.TranslatePipe], styles: ["sl-card[_ngcontent-%COMP%] {\n  display: block;\n}\nsl-card[_ngcontent-%COMP%]::part(body) {\n  min-height: 400px;\n}\nsl-tab-group[_ngcontent-%COMP%] {\n  --indicator-color: var(--sl-color-primary-500);\n}\nsl-tab-group[_ngcontent-%COMP%]::part(tabs) {\n  border-bottom: solid 2px var(--sl-color-neutral-0);\n}\nsl-tab-group[_ngcontent-%COMP%]   sl-tab[active][_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-primary-500);\n}\nsl-tab-group[_ngcontent-%COMP%]   sl-tab[_ngcontent-%COMP%] {\n  box-shadow: 0 5px var(--sl-color-neutral-200);\n}\n.actions[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-top: calc(2 * var(--sl-spacing-small));\n}\n.actions[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]:first-child {\n  margin-right: var(--sl-spacing-medium);\n}\n.actions-btns[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  width: 100%;\n}\n.btn-lock[_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-secondary-900);\n}\n.btn-lock[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n  font-size: var(--sl-font-size-medium);\n  color: var(--sl-color-secondary-900);\n}\n.password-form[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-2x-small) 0;\n}\n.save-confirm[_ngcontent-%COMP%] {\n  padding-left: 24px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_19__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_14__.Debounce)(0)
], CommonComponent.prototype, "ngAfterViewInit", null);


/***/ }),

/***/ 8358:
/*!******************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/dataset-update/components/interval-inputs/interval-inputs.component.ts ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntervalInputsComponent": () => (/* binding */ IntervalInputsComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);







function IntervalInputsComponent_div_22_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "sl-icon", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](4, 1, "datasetUpdate.inputs.intervalError"));
} }
const MinuteDivider = 60;
const HourDivider = 60 * MinuteDivider;
const DayDivider = 24 * HourDivider;
const WeekDivier = 7 * DayDivider;
class IntervalInputsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_1__.SubscribableComponent {
    constructor(formService) {
        super();
        this.formService = formService;
        this.interval = 0;
        this.disabled = false;
        this.showError = false;
        this.form = this.formService.form({
            weeks: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.min(1)]],
            days: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.min(1)]],
            hours: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.min(1)]],
            minutes: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.min(1)]],
        });
    }
    ngOnInit() {
        this.patchValue();
        this.subscriptions = [
            this.form.valueChanges.subscribe(() => {
                this.showError = false;
            }),
        ];
    }
    getInterval() {
        let hasSomeValue = false;
        const value = this.form.value;
        for (let key in value) {
            if (value[key]) {
                hasSomeValue = true;
                break;
            }
        }
        if (this.form.invalid) {
            this.formService.showLocalErrors(this.form);
            return null;
        }
        else if (!hasSomeValue) {
            this.showError = true;
            return null;
        }
        else {
            return (value.weeks * WeekDivier +
                value.days * DayDivider +
                value.hours * HourDivider +
                value.minutes * MinuteDivider);
        }
    }
    patchValue() {
        let seconds = this.interval;
        const weeks = Math.trunc(seconds / WeekDivier);
        seconds -= weeks * WeekDivier;
        const days = Math.trunc(seconds / DayDivider);
        seconds -= days * DayDivider;
        const hours = Math.trunc(seconds / HourDivider);
        seconds -= hours * HourDivider;
        const minutes = Math.trunc(seconds / MinuteDivider);
        this.form.patchValue({
            weeks: weeks || null,
            days: days || null,
            hours: hours || null,
            minutes: minutes || null,
        });
    }
}
IntervalInputsComponent.ɵfac = function IntervalInputsComponent_Factory(t) { return new (t || IntervalInputsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService)); };
IntervalInputsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: IntervalInputsComponent, selectors: [["app-interval-inputs"]], inputs: { interval: "interval", disabled: "disabled" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]], decls: 23, vars: 34, consts: [[3, "data"], [1, "intervals"], [1, "input"], ["clearable", "", "name", "weeks", "type", "number", 3, "min", "disabled", "placeholder", "label"], ["clearable", "", "name", "days", "type", "number", 3, "min", "disabled", "placeholder", "label"], ["clearable", "", "name", "hours", "type", "number", 3, "min", "disabled", "placeholder", "label"], ["clearable", "", "type", "number", "name", "minutes", 3, "min", "disabled", "placeholder", "label"], ["class", "error", 4, "ngIf"], [1, "error"], ["name", "exclamation-octagon"]], template: function IntervalInputsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "core-form", 0)(1, "div", 1)(2, "div", 2)(3, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "sl-input", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 2)(8, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](9, "sl-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](10, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "div", 2)(13, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](14, "sl-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "div", 2)(18, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](19, "sl-input", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](22, IntervalInputsComponent_div_22_Template, 5, 3, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("min", 1)("disabled", ctx.disabled)("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](5, 18, "datasetUpdate.enterValue"))("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](6, 20, "datasetUpdate.inputs.weeks"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("min", 1)("disabled", ctx.disabled)("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](10, 22, "datasetUpdate.enterValue"))("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](11, 24, "datasetUpdate.inputs.days"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("min", 1)("disabled", ctx.disabled)("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](15, 26, "datasetUpdate.enterValue"))("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](16, 28, "datasetUpdate.inputs.hours"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("min", 1)("disabled", ctx.disabled)("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](20, 30, "datasetUpdate.enterValue"))("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](21, 32, "datasetUpdate.inputs.minutes"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showError);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SlInputNumberDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["core-form[_ngcontent-%COMP%] {\n  height: 120px;\n}\n.intervals[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  height: 70px;\n  margin-bottom: var(--sl-spacing-large);\n}\n.input[_ngcontent-%COMP%] {\n  width: 190px;\n  margin-right: var(--sl-spacing-large);\n}\n.error[_ngcontent-%COMP%] {\n  display: flex;\n}\n.error[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  margin: auto 0;\n}\n.error[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-large);\n  margin-right: var(--sl-spacing-x-small);\n}\nsl-input[disabled][_ngcontent-%COMP%]::part(form-control-label), sl-select[disabled][_ngcontent-%COMP%]::part(form-control-label) {\n  color: var(--sl-color-action-400);\n}\nsl-input[_ngcontent-%COMP%]::part(input) {\n  padding: 0 var(--sl-input-spacing-small);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImludGVydmFsLWlucHV0cy5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7QUFDSjtBQUNBO0VBQ0ksYUFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0VBQ0Esc0NBQUE7QUFDSjtBQUVBO0VBQ0ksWUFBQTtFQUNBLHFDQUFBO0FBQUo7QUFHQTtFQUNJLGFBQUE7QUFESjtBQUFBO0VBR1Esb0NBQUE7RUFDQSxjQUFBO0FBQVI7QUFKQTtFQU9RLG9DQUFBO0VBQ0EsdUNBQUE7QUFBUjtBQUtJOztFQUNJLGlDQUFBO0FBRlI7QUFNQTtFQUNJLHdDQUFBO0FBSkoiLCJmaWxlIjoiaW50ZXJ2YWwtaW5wdXRzLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiY29yZS1mb3JtIHtcbiAgICBoZWlnaHQ6IDEyMHB4O1xufVxuLmludGVydmFscyB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDcwcHg7XG4gICAgbWFyZ2luLWJvdHRvbTogdmFyKC0tc2wtc3BhY2luZy1sYXJnZSk7XG59XG5cbi5pbnB1dCB7XG4gICAgd2lkdGg6IDE5MHB4O1xuICAgIG1hcmdpbi1yaWdodDogdmFyKC0tc2wtc3BhY2luZy1sYXJnZSk7XG59XG5cbi5lcnJvciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBzcGFuIHtcbiAgICAgICAgZm9udC1zaXplOiB2YXIoLS1zbC1mb250LXNpemUtc21hbGwpO1xuICAgICAgICBtYXJnaW46IGF1dG8gMDtcbiAgICB9XG4gICAgc2wtaWNvbiB7XG4gICAgICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLWxhcmdlKTtcbiAgICAgICAgbWFyZ2luLXJpZ2h0OiB2YXIoLS1zbC1zcGFjaW5nLXgtc21hbGwpO1xuICAgIH1cbn1cbnNsLWlucHV0W2Rpc2FibGVkXSxcbnNsLXNlbGVjdFtkaXNhYmxlZF0ge1xuICAgICY6OnBhcnQoZm9ybS1jb250cm9sLWxhYmVsKSB7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1hY3Rpb24tNDAwKTtcbiAgICB9XG59XG5cbnNsLWlucHV0OjpwYXJ0KGlucHV0KSB7XG4gICAgcGFkZGluZzogMCB2YXIoLS1zbC1pbnB1dC1zcGFjaW5nLXNtYWxsKTtcbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], IntervalInputsComponent.prototype, "showError", void 0);


/***/ }),

/***/ 2687:
/*!**************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/dataset-update/components/period-inputs/period-inputs.component.ts ***!
  \**************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PeriodInputsComponent": () => (/* binding */ PeriodInputsComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../enums/update-dataset */ 8278);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shoelace-style-angular */ 5219);









function PeriodInputsComponent_sl_menu_item_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const type_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", type_r6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 2, "datasetUpdate.inputs." + type_r6), " ");
} }
function PeriodInputsComponent_div_11_sl_menu_item_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const i_r10 = ctx.index;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", i_r10 + 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 2, "datasetUpdate.month." + (i_r10 + 1)), " ");
} }
function PeriodInputsComponent_div_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 4)(1, "core-validate")(2, "sl-select", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, PeriodInputsComponent_div_11_sl_menu_item_4_Template, 3, 4, "sl-menu-item", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx_r1.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 3, "datasetUpdate.inputs." + ctx_r1.InputsType.Month));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r1.MonthInYear);
} }
function PeriodInputsComponent_div_12_sl_menu_item_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const i_r13 = ctx.index;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", i_r13 + 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", i_r13 + 1, " ");
} }
const _c0 = function () { return []; };
function PeriodInputsComponent_div_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 4)(1, "core-validate")(2, "sl-select", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, PeriodInputsComponent_div_12_sl_menu_item_4_Template, 2, 2, "sl-menu-item", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx_r2.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 3, "datasetUpdate.inputs.days"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](5, _c0).constructor(ctx_r2.getDayMaxValue()));
} }
function PeriodInputsComponent_div_13_sl_menu_item_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const i_r16 = ctx.index;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", i_r16 + 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 2, "datasetUpdate.day." + (i_r16 + 1)), " ");
} }
function PeriodInputsComponent_div_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 4)(1, "core-validate")(2, "sl-select", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, PeriodInputsComponent_div_13_sl_menu_item_4_Template, 3, 4, "sl-menu-item", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx_r3.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 3, "datasetUpdate.inputs.dayWeek"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r3.daysInWeek);
} }
function PeriodInputsComponent_div_14_Template(rf, ctx) { if (rf & 1) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 15)(1, "core-validate")(2, "sl-input", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-input", function PeriodInputsComponent_div_14_Template_sl_input_sl_input_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r18); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r17.patchTime($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx_r4.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 2, "datasetUpdate.inputs.time"));
} }
function PeriodInputsComponent_div_15_sl_menu_item_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const i_r21 = ctx.index;
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", i_r21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx_r19.getMinutes(i_r21), " ");
} }
function PeriodInputsComponent_div_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 17)(1, "core-validate")(2, "sl-select", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "sl-tooltip", 19)(5, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](8, "sl-icon", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, PeriodInputsComponent_div_15_sl_menu_item_9_Template, 2, 2, "sl-menu-item", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx_r5.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 4, "datasetUpdate.inputs.minute"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 6, "datasetUpdate.inputs.helpText"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r5.Minutes);
} }
const minutesValidator = (control) => {
    return control.value === null ? { required: true } : null;
};
class PeriodInputsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__.SubscribableComponent {
    constructor(formService) {
        super();
        this.formService = formService;
        this.onDelete = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.disabled = false;
        this.index = 0;
        this.daysInWeek = Array(7);
        this.MonthInYear = Array(12);
        this.Types = [
            _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Year,
            _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Month,
            _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.WeekDay,
            _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Day,
            _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Hour,
        ];
        this.Minutes = Array(60);
        this.InputsType = _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType;
        this.ScheduleType = _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.ScheduleType;
        this.Month = _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.Month;
        this.form = this.formService.form({
            minutes: [0],
            time: [],
            day: [],
            month: [],
            dayOfWeek: [],
            hour: [],
            interval: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_3__.Validators.min(1), plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required]],
            type: [],
        });
    }
    ngOnInit() {
        this.patchValueInForm();
        this.subscriptions = [
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.validate)({
                control: this.form.get('time'),
                depends: [this.form.get('type')],
                translateKey: '',
                error(_, { value }) {
                    if (value !== _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Hour)
                        return [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required];
                    return false;
                },
            }),
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.validate)({
                control: this.form.get('minutes'),
                depends: [this.form.get('type')],
                translateKey: '',
                error(_, { value }) {
                    if (value === _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Hour)
                        return [minutesValidator];
                    return false;
                },
            }),
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.validate)({
                control: this.form.get('month'),
                depends: [this.form.get('type')],
                translateKey: '',
                error(_, { value }) {
                    if (value === _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Year)
                        return [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required];
                    return false;
                },
            }),
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.validate)({
                control: this.form.get('dayOfWeek'),
                depends: [this.form.get('type')],
                translateKey: '',
                error(_, { value }) {
                    if (value === _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.WeekDay)
                        return [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required];
                    return false;
                },
            }),
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.validate)({
                control: this.form.get('day'),
                depends: [this.form.get('type')],
                translateKey: '',
                error(_, { value }) {
                    if (value === _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Year || value === _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Month)
                        return [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.required];
                    return false;
                },
            }),
        ];
    }
    patchTime(event) {
        const value = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.valueOf)(event).split(':');
        this.form.patchValue({ hour: +value[0], minutes: +value[1] });
    }
    changeType(event) {
        const type = +(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.valueOf)(event);
        this.form.reset();
        this.form.patchValue({
            type,
            time: this.getTime(),
            interval: 1,
            minutes: 0,
            hour: 0,
        });
        switch (type) {
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.WeekDay:
                this.form.patchValue({ dayOfWeek: 1 });
                break;
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Year:
                this.form.patchValue({ day: 1, month: 1 });
                break;
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Month:
                this.form.patchValue({ day: 1 });
                break;
        }
    }
    getMinutes(minute) {
        const value = (minute === null || minute === void 0 ? void 0 : minute.toString().length) < 2 ? `:0${minute}` : `:${minute}`;
        return value;
    }
    getFormValue() {
        if (this.form.invalid) {
            this.formService.showLocalErrors(this.form);
            return null;
        }
        return {
            cron_step: +this.form.value.interval,
            cron_expression: this.convertToCrone(),
        };
    }
    getDayMaxValue() {
        switch (this.form.value.month) {
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.Month.February:
                return 28;
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.Month.April:
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.Month.June:
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.Month.September:
            case _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.Month.November:
                return 30;
            default:
                return 31;
        }
    }
    patchValueInForm() {
        this.form.patchValue({ interval: this.shedule.cron_step });
        this.shedule.cron_expression.split(' ').forEach((item, index) => {
            const value = parseInt(item);
            if (value) {
                switch (index) {
                    case 0:
                        this.form.patchValue({ minutes: value });
                        break;
                    case 1:
                        this.form.patchValue({ hour: value });
                        break;
                    case 2:
                        this.form.patchValue({ day: value });
                        break;
                    case 3:
                        this.form.patchValue({ month: value });
                        break;
                    case 4:
                        this.form.patchValue({ dayOfWeek: value });
                        break;
                }
            }
        });
        this.form.patchValue({ time: this.getTime(), type: this.getType() });
    }
    getTime() {
        var _a, _b;
        const hour = ((_a = this.form.value.hour) === null || _a === void 0 ? void 0 : _a.toString().padStart(2, '0')) || '00';
        const minutes = ((_b = this.form.value.minutes) === null || _b === void 0 ? void 0 : _b.toString().padStart(2, '0')) || '00';
        return `${hour}:${minutes}`;
    }
    getType() {
        const value = this.form.value;
        if (value.month) {
            return _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Year;
        }
        if (value.dayOfWeek) {
            return _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.WeekDay;
        }
        if (value.day) {
            return _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Month;
        }
        if (value.hour) {
            return _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Day;
        }
        return _enums_update_dataset__WEBPACK_IMPORTED_MODULE_0__.InputsType.Hour;
    }
    convertToCrone() {
        const value = this.form.value;
        let arr = [
            value.minutes,
            value.hour || '*',
            value.day || '*',
            value.month || '*',
            value.dayOfWeek || '*',
        ];
        return arr.join(' ');
    }
}
PeriodInputsComponent.ɵfac = function PeriodInputsComponent_Factory(t) { return new (t || PeriodInputsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormService)); };
PeriodInputsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: PeriodInputsComponent, selectors: [["app-period-inputs"]], inputs: { disabled: "disabled", shedule: "shedule", index: "index" }, outputs: { onDelete: "onDelete" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 17, vars: 17, consts: [[3, "data"], [1, "container"], [1, "interval"], ["type", "number", "name", "interval", 3, "min", "disabled", "label"], [1, "period"], ["name", "type", 3, "disabled", "label", "sl-change"], [3, "value", 4, "ngFor", "ngForOf"], ["class", "period", 4, "ngIf"], ["class", "time", 4, "ngIf"], ["class", "minute", 4, "ngIf"], ["name", "x", 3, "disabled", "click"], [3, "value"], ["name", "month", 3, "disabled", "label"], ["name", "day", 3, "disabled", "label"], ["hoist", "", "name", "dayOfWeek", 3, "disabled", "label"], [1, "time"], ["type", "time", "name", "time", 3, "disabled", "label", "sl-input"], [1, "minute"], ["hoist", "", "name", "minutes", 3, "disabled", "label"], ["slot", "prefix", "content", "top-start", "hoist", ""], ["slot", "content"], ["name", "info-circle"], ["class", "minutes", 3, "value", 4, "ngFor", "ngForOf"], [1, "minutes", 3, "value"]], template: function PeriodInputsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "core-form", 0)(1, "div", 1)(2, "div", 2)(3, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "sl-input", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 4)(7, "core-validate")(8, "sl-select", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-change", function PeriodInputsComponent_Template_sl_select_sl_change_8_listener($event) { return ctx.changeType($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, PeriodInputsComponent_sl_menu_item_10_Template, 3, 4, "sl-menu-item", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, PeriodInputsComponent_div_11_Template, 5, 5, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, PeriodInputsComponent_div_12_Template, 5, 6, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](13, PeriodInputsComponent_div_13_Template, 5, 5, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](14, PeriodInputsComponent_div_14_Template, 4, 4, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](15, PeriodInputsComponent_div_15_Template, 10, 8, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "sl-icon-button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function PeriodInputsComponent_Template_sl_icon_button_click_16_listener() { return ctx.onDelete.emit(ctx.index); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("min", 1)("disabled", ctx.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](5, 13, "datasetUpdate.inputs.every"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 15, "datasetUpdate.inputs.choosePeriod"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.Types);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.form.value.type == ctx.InputsType.Year);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.form.value.type == ctx.InputsType.Month || ctx.form.value.type == ctx.InputsType.Year);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.form.value.type == ctx.InputsType.WeekDay);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.form.value.type !== ctx.InputsType.Hour);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.form.value.type == ctx.InputsType.Hour);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx.disabled);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlInputNumberDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ValidateComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.OpenableDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe], styles: [".container[_ngcontent-%COMP%] {\n  display: inline-flex;\n  margin-bottom: var(--sl-spacing-large);\n}\n.interval[_ngcontent-%COMP%] {\n  width: 80px;\n}\n.period[_ngcontent-%COMP%] {\n  width: 200px;\n}\n.time[_ngcontent-%COMP%], .minute[_ngcontent-%COMP%] {\n  width: 100px;\n}\n.minute[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%]::part(display-label) {\n  margin: 0 var(--sl-spacing-x-small);\n}\n.time[_ngcontent-%COMP%]   sl-input[_ngcontent-%COMP%]::part(input) {\n  padding: 0 var(--sl-spacing-small);\n}\n.interval[_ngcontent-%COMP%], .time[_ngcontent-%COMP%], .period[_ngcontent-%COMP%], .minute[_ngcontent-%COMP%] {\n  min-height: 60px;\n  margin-right: var(--sl-spacing-large);\n}\n.minutes[_ngcontent-%COMP%]::part(base) {\n  padding: var(--sl-spacing-2x-small) var(--sl-spacing-4x-small);\n}\nsl-icon-button[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  padding-top: 36px;\n}\nsl-icon-button[_ngcontent-%COMP%]::part(base) {\n  padding: 0;\n}\nsl-icon[name='info-circle'][_ngcontent-%COMP%] {\n  margin-inline-start: var(--sl-spacing-small);\n}\nsl-input[disabled][_ngcontent-%COMP%]::part(form-control-label), sl-select[disabled][_ngcontent-%COMP%]::part(form-control-label) {\n  color: var(--sl-color-action-400);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBlcmlvZC1pbnB1dHMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxvQkFBQTtFQUNBLHNDQUFBO0FBQ0o7QUFDQTtFQUNJLFdBQUE7QUFDSjtBQUNBO0VBQ0ksWUFBQTtBQUNKO0FBQ0E7O0VBRUksWUFBQTtBQUNKO0FBQ0E7RUFDSSxtQ0FBQTtBQUNKO0FBQ0E7RUFDSSxrQ0FBQTtBQUNKO0FBQ0E7Ozs7RUFJSSxnQkFBQTtFQUNBLHFDQUFBO0FBQ0o7QUFFQTtFQUNJLDhEQUFBO0FBQUo7QUFFQTtFQUNJLHFDQUFBO0VBQ0EsaUJBQUE7QUFBSjtBQUNJO0VBQ0ksVUFBQTtBQUNSO0FBRUE7RUFDSSw0Q0FBQTtBQUFKO0FBSUk7O0VBQ0ksaUNBQUE7QUFEUiIsImZpbGUiOiJwZXJpb2QtaW5wdXRzLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLmNvbnRhaW5lciB7XG4gICAgZGlzcGxheTogaW5saW5lLWZsZXg7XG4gICAgbWFyZ2luLWJvdHRvbTogdmFyKC0tc2wtc3BhY2luZy1sYXJnZSk7XG59XG4uaW50ZXJ2YWwge1xuICAgIHdpZHRoOiA4MHB4O1xufVxuLnBlcmlvZCB7XG4gICAgd2lkdGg6IDIwMHB4O1xufVxuLnRpbWUsXG4ubWludXRlIHtcbiAgICB3aWR0aDogMTAwcHg7XG59XG4ubWludXRlIHNsLXNlbGVjdDo6cGFydChkaXNwbGF5LWxhYmVsKSB7XG4gICAgbWFyZ2luOiAwIHZhcigtLXNsLXNwYWNpbmcteC1zbWFsbCk7XG59XG4udGltZSBzbC1pbnB1dDo6cGFydChpbnB1dCkge1xuICAgIHBhZGRpbmc6IDAgdmFyKC0tc2wtc3BhY2luZy1zbWFsbCk7XG59XG4uaW50ZXJ2YWwsXG4udGltZSxcbi5wZXJpb2QsXG4ubWludXRlIHtcbiAgICBtaW4taGVpZ2h0OiA2MHB4O1xuICAgIG1hcmdpbi1yaWdodDogdmFyKC0tc2wtc3BhY2luZy1sYXJnZSk7XG59XG5cbi5taW51dGVzOjpwYXJ0KGJhc2UpIHtcbiAgICBwYWRkaW5nOiB2YXIoLS1zbC1zcGFjaW5nLTJ4LXNtYWxsKSB2YXIoLS1zbC1zcGFjaW5nLTR4LXNtYWxsKTtcbn1cbnNsLWljb24tYnV0dG9uIHtcbiAgICBmb250LXNpemU6IHZhcigtLXNsLWZvbnQtc2l6ZS1tZWRpdW0pO1xuICAgIHBhZGRpbmctdG9wOiAzNnB4O1xuICAgICY6OnBhcnQoYmFzZSkge1xuICAgICAgICBwYWRkaW5nOiAwO1xuICAgIH1cbn1cbnNsLWljb25bbmFtZT0naW5mby1jaXJjbGUnXSB7XG4gICAgbWFyZ2luLWlubGluZS1zdGFydDogdmFyKC0tc2wtc3BhY2luZy1zbWFsbCk7XG59XG5zbC1pbnB1dFtkaXNhYmxlZF0sXG5zbC1zZWxlY3RbZGlzYWJsZWRdIHtcbiAgICAmOjpwYXJ0KGZvcm0tY29udHJvbC1sYWJlbCkge1xuICAgICAgICBjb2xvcjogdmFyKC0tc2wtY29sb3ItYWN0aW9uLTQwMCk7XG4gICAgfVxufVxuIl19 */"] });


/***/ }),

/***/ 9247:
/*!**************************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/dataset-update/components/start-update-inputs/start-update-inputs.component.ts ***!
  \**************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_TIMEZONE": () => (/* binding */ DEFAULT_TIMEZONE),
/* harmony export */   "StartUpdateInputsComponent": () => (/* binding */ StartUpdateInputsComponent)
/* harmony export */ });
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _constants_time_zones__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../constants/time-zones */ 8183);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);






function StartUpdateInputsComponent_sl_menu_item_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-menu-item", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const zone_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("value", zone_r1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 2, "datasetUpdate.timeZone." + zone_r1), " ");
} }
const DEFAULT_TIMEZONE = -180;
class StartUpdateInputsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__.SubscribableComponent {
    constructor(formService) {
        super();
        this.formService = formService;
        this.disabled = false;
        this.timeZones = _constants_time_zones__WEBPACK_IMPORTED_MODULE_0__.timesZones;
        this.form = this.formService.form({
            date: [],
            time: [],
            timezone: [],
        });
    }
    ngOnInit() {
        if (this.timeZone === undefined || this.timeZone === null) {
            this.timeZone = DEFAULT_TIMEZONE;
        }
        this.form.patchValue({
            date: this.date || null,
            time: this.time || null,
            timezone: this.timeZone,
        });
        this.subscriptions = [
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.validate)({
                control: this.form.get('time'),
                depends: [this.form.get('date')],
                translateKey: '',
                error(_, { value }) {
                    if (value)
                        return [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required];
                    return false;
                },
            }),
            (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.validate)({
                control: this.form.get('date'),
                depends: [this.form.get('time')],
                translateKey: '',
                error(_, { value }) {
                    if (value)
                        return [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required];
                    return false;
                },
            }),
        ];
    }
    getStartTime() {
        if (this.form.invalid) {
            this.formService.showLocalErrors(this.form);
            return null;
        }
        else {
            if (!this.form.value.time) {
                return {
                    time: '',
                    date: '',
                    timezone: this.form.value.timezone,
                };
            }
            return this.form.value;
        }
    }
}
StartUpdateInputsComponent.ɵfac = function StartUpdateInputsComponent_Factory(t) { return new (t || StartUpdateInputsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService)); };
StartUpdateInputsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: StartUpdateInputsComponent, selectors: [["app-start-update-inputs"]], inputs: { date: "date", time: "time", timeZone: "timeZone", disabled: "disabled" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 19, vars: 19, consts: [[3, "data"], [1, "start-container"], [1, "start-inputs"], ["type", "date", "name", "date", "clearable", "", 1, "date", 3, "disabled", "label"], ["name", "time", "type", "time", "clearable", "", 1, "start-time-input", 3, "disabled", "label"], ["name", "timezone", 1, "timezone", 3, "disabled", "label"], [3, "value", 4, "ngFor", "ngForOf"], [3, "value"]], template: function StartUpdateInputsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "core-form", 0)(1, "div", 1)(2, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 2)(6, "div")(7, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](8, "sl-input", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "div")(11, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](12, "sl-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "div")(15, "core-validate")(16, "sl-select", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](18, StartUpdateInputsComponent_sl_menu_item_18_Template, 3, 4, "sl-menu-item", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]()()()()()();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵclassProp"]("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 11, "datasetUpdate.inputs.start"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 13, "datasetUpdate.inputs.date"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 15, "datasetUpdate.inputs.time"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("disabled", ctx.disabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 17, "datasetUpdate.inputs.timezone"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.timeZones);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgForOf, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: [".start-container[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.start-container[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-weight: 600;\n  color: var(--sl-color-secondary-900);\n  line-height: 24px;\n  margin-bottom: 10px;\n  margin-top: 0;\n}\n.start-inputs[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  height: 100px;\n}\n.timezone[_ngcontent-%COMP%], .date[_ngcontent-%COMP%], .start-time-input[_ngcontent-%COMP%] {\n  margin-right: 10px;\n  width: 190px;\n}\n.disabled[_ngcontent-%COMP%] {\n  color: var(--sl-color-action-500) !important;\n}\nsl-input[disabled][_ngcontent-%COMP%]::part(form-control-label), sl-select[disabled][_ngcontent-%COMP%]::part(form-control-label) {\n  color: var(--sl-color-action-400);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0YXJ0LXVwZGF0ZS1pbnB1dHMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxXQUFBO0FBQ0o7QUFGQTtFQUdRLGdCQUFBO0VBQ0Esb0NBQUE7RUFDQSxpQkFBQTtFQUNBLG1CQUFBO0VBQ0EsYUFBQTtBQUVSO0FBRUE7RUFDSSxhQUFBO0VBQ0EsV0FBQTtFQUNBLGFBQUE7QUFBSjtBQUVBOzs7RUFHSSxrQkFBQTtFQUNBLFlBQUE7QUFBSjtBQUVBO0VBQ0ksNENBQUE7QUFBSjtBQUlJOztFQUNJLGlDQUFBO0FBRFIiLCJmaWxlIjoic3RhcnQtdXBkYXRlLWlucHV0cy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5zdGFydC1jb250YWluZXIge1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGg0IHtcbiAgICAgICAgZm9udC13ZWlnaHQ6IDYwMDtcbiAgICAgICAgY29sb3I6IHZhcigtLXNsLWNvbG9yLXNlY29uZGFyeS05MDApO1xuICAgICAgICBsaW5lLWhlaWdodDogMjRweDtcbiAgICAgICAgbWFyZ2luLWJvdHRvbTogMTBweDtcbiAgICAgICAgbWFyZ2luLXRvcDogMDtcbiAgICB9XG59XG5cbi5zdGFydC1pbnB1dHMge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDBweDtcbn1cbi50aW1lem9uZSxcbi5kYXRlLFxuLnN0YXJ0LXRpbWUtaW5wdXQge1xuICAgIG1hcmdpbi1yaWdodDogMTBweDtcbiAgICB3aWR0aDogMTkwcHg7XG59XG4uZGlzYWJsZWQge1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1hY3Rpb24tNTAwKSAhaW1wb3J0YW50O1xufVxuc2wtaW5wdXRbZGlzYWJsZWRdLFxuc2wtc2VsZWN0W2Rpc2FibGVkXSB7XG4gICAgJjo6cGFydChmb3JtLWNvbnRyb2wtbGFiZWwpIHtcbiAgICAgICAgY29sb3I6IHZhcigtLXNsLWNvbG9yLWFjdGlvbi00MDApO1xuICAgIH1cbn1cbiJdfQ== */"] });


/***/ }),

/***/ 3878:
/*!**************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/dataset-update/dataset-update.component.ts ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetUpdateComponent": () => (/* binding */ DatasetUpdateComponent)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var _components_start_update_inputs_start_update_inputs_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/start-update-inputs/start-update-inputs.component */ 9247);
/* harmony import */ var _components_interval_inputs_interval_inputs_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/interval-inputs/interval-inputs.component */ 8358);
/* harmony import */ var _enums_update_dataset__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../enums/update-dataset */ 8278);
/* harmony import */ var _components_period_inputs_period_inputs_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/period-inputs/period-inputs.component */ 2687);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../api/dataset-api.service */ 5640);
/* harmony import */ var _dataset_update_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dataset-update.service */ 5845);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6362);














function DatasetUpdateComponent_ng_container_0_span_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "span", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](3, "sl-format-date", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](6, "sl-format-date", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](2, 5, "datasetUpdate.nextUpdate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("date", ctx_r1.datasetUpdates.next_fire_time);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](5, 7, "datasetUpdate.in"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("date", ctx_r1.datasetUpdates.next_fire_time);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", ctx_r1.getTimeZone(), " ");
} }
function DatasetUpdateComponent_ng_container_0_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](1, "p", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](4, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](3, 2, "datasetUpdate.firstLine"), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](6, 4, "datasetUpdate.secondLine"), " ");
} }
function DatasetUpdateComponent_ng_container_0_ng_template_7_sl_button_14_Template(rf, ctx) { if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "sl-button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function DatasetUpdateComponent_ng_container_0_ng_template_7_sl_button_14_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r9); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r8.addPeriod()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](3, "sl-icon", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("disabled", !ctx_r5.enabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](2, 2, "datasetUpdate.inputs.addPeriod"), " ");
} }
function DatasetUpdateComponent_ng_container_0_ng_template_7_div_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](1, "sl-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](4, 1, "datasetUpdate.inputs.periodError"), " ");
} }
function DatasetUpdateComponent_ng_container_0_ng_template_7_ng_container_17_Template(rf, ctx) { if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](1, "app-period-inputs", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("onDelete", function DatasetUpdateComponent_ng_container_0_ng_template_7_ng_container_17_Template_app_period_inputs_onDelete_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](3); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r12.datasetUpdates.schedules == null ? null : ctx_r12.datasetUpdates.schedules.splice($event, 1)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const shedule_r10 = ctx.$implicit;
    const i_r11 = ctx.index;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("disabled", !ctx_r7.enabled)("shedule", shedule_r10)("index", i_r11);
} }
function DatasetUpdateComponent_ng_container_0_ng_template_7_Template(rf, ctx) { if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](0, "app-start-update-inputs", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](1, "div", 12)(2, "h4");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](5, "div", 13)(6, "sl-select", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("sl-change", function DatasetUpdateComponent_ng_container_0_ng_template_7_Template_sl_select_sl_change_6_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r14.changeType($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](8, "sl-menu-item", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](11, "sl-menu-item", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](12);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](13, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](14, DatasetUpdateComponent_ng_container_0_ng_template_7_sl_button_14_Template, 4, 4, "sl-button", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](15, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](16, DatasetUpdateComponent_ng_container_0_ng_template_7_div_16_Template, 5, 3, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](17, DatasetUpdateComponent_ng_container_0_ng_template_7_ng_container_17_Template, 2, 3, "ng-container", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](18, "app-interval-inputs", 19);
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("disabled", !ctx_r4.enabled)("date", ctx_r4.datasetUpdates.start_from == null ? null : ctx_r4.datasetUpdates.start_from.date)("time", ctx_r4.datasetUpdates.start_from == null ? null : ctx_r4.datasetUpdates.start_from.time)("timeZone", ctx_r4.datasetUpdates.timezone_offset_minutes);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("disabled", !ctx_r4.enabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](4, 23, "datasetUpdate.inputs.params"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("disabled", !ctx_r4.enabled)("label", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](7, 25, "datasetUpdate.inputs.periodType"))("value", ctx_r4.scheduleType);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("value", ctx_r4.ScheduleType.Period);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](10, 27, "datasetUpdate.inputs.period"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("value", ctx_r4.ScheduleType.Interval);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](13, 29, "datasetUpdate.inputs.interval"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx_r4.scheduleType === ctx_r4.ScheduleType.Period);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("hidden", ctx_r4.scheduleType === ctx_r4.ScheduleType.Interval);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx_r4.showPeriodError);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngForOf", ctx_r4.datasetUpdates.schedules);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("hidden", ctx_r4.scheduleType === ctx_r4.ScheduleType.Period);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("disabled", !ctx_r4.enabled)("interval", ctx_r4.datasetUpdates.interval);
} }
function DatasetUpdateComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](1, "div", 2)(2, "sl-switch", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("sl-change", function DatasetUpdateComponent_ng_container_0_Template_sl_switch_sl_change_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵrestoreView"](_r17); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵresetView"](ctx_r16.slChangeSwitch()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](5, DatasetUpdateComponent_ng_container_0_span_5_Template, 8, 9, "span", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](6, DatasetUpdateComponent_ng_container_0_ng_container_6_Template, 7, 6, "ng-container", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](7, DatasetUpdateComponent_ng_container_0_ng_template_7_Template, 19, 31, "ng-template", null, 6, _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵreference"](8);
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("checked", ctx_r0.enabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](4, 5, "datasetUpdate.autoUpdate"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", ctx_r0.datasetUpdates.next_fire_time && ctx_r0.enabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", !ctx_r0.enabled && ctx_r0.isEmpty)("ngIfElse", _r3);
} }
const DefaultPeriod = {
    cron_expression: '0 0 1 * *',
    cron_step: 1,
};
class DatasetUpdateComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_7__.SubscribableComponent {
    constructor(datasetApiService, datasetUpdateService, notifyService, responseErrorService, translateService) {
        super();
        this.datasetApiService = datasetApiService;
        this.datasetUpdateService = datasetUpdateService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.translateService = translateService;
        this.scheduleType = _enums_update_dataset__WEBPACK_IMPORTED_MODULE_2__.ScheduleType.Period;
        this.ScheduleType = _enums_update_dataset__WEBPACK_IMPORTED_MODULE_2__.ScheduleType;
        this.enabled = false;
        this.isLoading = false;
        this.showPeriodError = false;
    }
    get isEmpty() {
        var _a;
        return this.datasetUpdates.interval ||
            ((_a = this.datasetUpdates.schedules) === null || _a === void 0 ? void 0 : _a.length)
            ? false
            : true;
    }
    ngOnInit() {
        this.load();
        this.subscriptions = [
            this.datasetUpdateService.onSubmit.subscribe(() => {
                this.submit();
            }),
            this.datasetUpdateService.onCancel.subscribe(() => {
                this.load();
            }),
        ];
    }
    changeType(event) {
        this.showPeriodError = false;
        this.scheduleType = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.valueOf)(event);
    }
    addPeriod() {
        var _a;
        this.showPeriodError = false;
        (_a = this.datasetUpdates.schedules) === null || _a === void 0 ? void 0 : _a.push(DefaultPeriod);
    }
    slChangeSwitch() {
        this.showPeriodError = false;
        this.enabled = !this.enabled;
    }
    getTimeZone() {
        if (this.datasetUpdates.next_fire_time) {
            const offset = new Date(this.datasetUpdates.next_fire_time).getTimezoneOffset();
            const zone = this.translateService.getTranslation(`datasetUpdate.timeZone.${offset}`);
            return `(${zone})`;
        }
        return '';
    }
    submit() {
        var _a, _b;
        let hasInvalidInputs = false;
        const start = (_a = this.startUpdateInputsComponent) === null || _a === void 0 ? void 0 : _a.getStartTime();
        const start_from = (start === null || start === void 0 ? void 0 : start.date)
            ? { date: start.date, time: start.time }
            : null;
        const timezone_offset_minutes = start === null || start === void 0 ? void 0 : start.timezone;
        let request;
        if (this.scheduleType === _enums_update_dataset__WEBPACK_IMPORTED_MODULE_2__.ScheduleType.Interval) {
            const interval = (_b = this.intervalInputsComponent) === null || _b === void 0 ? void 0 : _b.getInterval();
            hasInvalidInputs = !interval;
            request = {
                enabled: this.enabled,
                start_from,
                interval,
                timezone_offset_minutes,
            };
        }
        else {
            const schedules = this.getSchedules();
            hasInvalidInputs = !schedules;
            request = {
                enabled: this.enabled,
                start_from,
                schedules,
                timezone_offset_minutes,
            };
            if (schedules && !schedules.length) {
                this.showPeriodError = true;
            }
        }
        if (!hasInvalidInputs && !this.showPeriodError) {
            this.saveRequest(request);
        }
        else if (!this.enabled) {
            this.saveRequest({
                enabled: this.enabled,
                timezone_offset_minutes,
                schedules: [],
            });
        }
    }
    saveRequest(request) {
        this.datasetApiService
            .scheduledUpdates(request, this.dataset.id)
            .subscribe({
            next: () => {
                this.load();
                this.notifyService.toastByName('notifySuccess');
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'datasetUpdate.notification.error.update',
                });
            },
        });
    }
    load() {
        this.isLoading = true;
        this.datasetApiService.getScheduledUpdates(this.dataset.id).subscribe({
            next: (scheduledUpdate) => {
                this.showPeriodError = false;
                this.enabled = scheduledUpdate.enabled;
                this.scheduleType = scheduledUpdate.interval
                    ? _enums_update_dataset__WEBPACK_IMPORTED_MODULE_2__.ScheduleType.Interval
                    : _enums_update_dataset__WEBPACK_IMPORTED_MODULE_2__.ScheduleType.Period;
                this.datasetUpdates = scheduledUpdate;
                this.isLoading = false;
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'datasetUpdate.notification.error',
                });
            },
        });
    }
    getSchedules() {
        var _a;
        let hasInvalidInputs = false;
        const schedules = [];
        (_a = this.periodInputs) === null || _a === void 0 ? void 0 : _a.forEach((inputComponent) => {
            const schedule = inputComponent.getFormValue();
            if (!schedule) {
                return (hasInvalidInputs = true);
            }
            else {
                schedules.push(schedule);
            }
        });
        return hasInvalidInputs ? null : schedules;
    }
}
DatasetUpdateComponent.ɵfac = function DatasetUpdateComponent_Factory(t) { return new (t || DatasetUpdateComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_4__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_dataset_update_service__WEBPACK_IMPORTED_MODULE_5__.DatasetUpdateService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TranslateService)); };
DatasetUpdateComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineComponent"]({ type: DatasetUpdateComponent, selectors: [["app-dataset-update"]], viewQuery: function DatasetUpdateComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵviewQuery"](_components_start_update_inputs_start_update_inputs_component__WEBPACK_IMPORTED_MODULE_0__.StartUpdateInputsComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵviewQuery"](_components_interval_inputs_interval_inputs_component__WEBPACK_IMPORTED_MODULE_1__.IntervalInputsComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵviewQuery"](_components_period_inputs_period_inputs_component__WEBPACK_IMPORTED_MODULE_3__.PeriodInputsComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵloadQuery"]()) && (ctx.startUpdateInputsComponent = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵloadQuery"]()) && (ctx.intervalInputsComponent = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵloadQuery"]()) && (ctx.periodInputs = _t);
    } }, inputs: { dataset: "dataset" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵInheritDefinitionFeature"]], decls: 4, vars: 4, consts: [[4, "ngIf"], ["variant", "success", "name", "notifySuccess"], [1, "header-container"], [3, "checked", "sl-change"], ["class", "next-update", 4, "ngIf"], [4, "ngIf", "ngIfElse"], ["updateOn", ""], [1, "next-update"], ["day", "numeric", "month", "short", "year", "numeric", "lang", "ru", 3, "date"], ["hour", "numeric", "minute", "numeric", "hour-format", "24", 3, "date"], [1, "warning"], [3, "disabled", "date", "time", "timeZone"], [1, "params-container"], [1, "params-header-input"], [3, "disabled", "label", "value", "sl-change"], [3, "value"], ["variant", "primary", "outline", "", 3, "disabled", "click", 4, "ngIf"], ["class", "error", 4, "ngIf"], [4, "ngFor", "ngForTrackById", "ngForOf"], [3, "disabled", "interval"], ["variant", "primary", "outline", "", 3, "disabled", "click"], ["slot", "prefix", "name", "plus-circle"], [1, "error"], ["name", "exclamation-octagon"], [3, "disabled", "shedule", "index", "onDelete"]], template: function DatasetUpdateComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtemplate"](0, DatasetUpdateComponent_ng_container_0_Template, 9, 7, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](1, "core-notify", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("ngIf", !ctx.isLoading);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵpipeBind1"](3, 2, "datasetUpdate.notification.success"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.NotifyComponent, _components_interval_inputs_interval_inputs_component__WEBPACK_IMPORTED_MODULE_1__.IntervalInputsComponent, _components_period_inputs_period_inputs_component__WEBPACK_IMPORTED_MODULE_3__.PeriodInputsComponent, _components_start_update_inputs_start_update_inputs_component__WEBPACK_IMPORTED_MODULE_0__.StartUpdateInputsComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_8__.TranslatePipe], styles: ["sl-switch[_ngcontent-%COMP%] {\n  --height: 16px;\n  --thumb-size: 18px;\n  margin-right: 20px;\n}\nsl-input[disabled][_ngcontent-%COMP%]::part(form-control-label), sl-select[disabled][_ngcontent-%COMP%]::part(form-control-label) {\n  color: var(--sl-color-action-400);\n}\n.header-container[_ngcontent-%COMP%] {\n  display: flex;\n  line-height: 24px;\n  margin-bottom: 40px;\n}\n.next-update[_ngcontent-%COMP%] {\n  font-size: 16px;\n  font-weight: 400;\n  color: var(--sl-color-secondary-600);\n  margin-top: 2px;\n}\n.params-container[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.params-container[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-weight: 600;\n  color: var(--sl-color-secondary-900);\n  line-height: 24px;\n  margin-top: 0;\n  margin-bottom: 10px;\n}\n.params-container[_ngcontent-%COMP%] {\n  margin-bottom: 40px;\n}\n.params-header-input[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  align-items: flex-end;\n}\n.params-header-input[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%] {\n  width: 310px;\n  margin-right: var(--sl-spacing-large);\n}\n.disabled[_ngcontent-%COMP%] {\n  color: var(--sl-color-action-500) !important;\n}\n.error[_ngcontent-%COMP%] {\n  display: flex;\n}\n.error[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  margin: auto 0;\n}\n.error[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-large);\n  margin-right: var(--sl-spacing-x-small);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRhdGFzZXQtdXBkYXRlLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksY0FBQTtFQUNBLGtCQUFBO0VBQ0Esa0JBQUE7QUFDSjtBQUdJOztFQUNJLGlDQUFBO0FBQVI7QUFJQTtFQUNJLGFBQUE7RUFDQSxpQkFBQTtFQUNBLG1CQUFBO0FBRko7QUFLQTtFQUNJLGVBQUE7RUFDQSxnQkFBQTtFQUNBLG9DQUFBO0VBQ0EsZUFBQTtBQUhKO0FBTUE7RUFDSSxXQUFBO0FBSko7QUFHQTtFQUdRLGdCQUFBO0VBQ0Esb0NBQUE7RUFDQSxpQkFBQTtFQUNBLGFBQUE7RUFDQSxtQkFBQTtBQUhSO0FBTUE7RUFDSSxtQkFBQTtBQUpKO0FBT0E7RUFDSSxhQUFBO0VBQ0EsV0FBQTtFQUNBLHFCQUFBO0FBTEo7QUFFQTtFQUtRLFlBQUE7RUFDQSxxQ0FBQTtBQUpSO0FBUUE7RUFDSSw0Q0FBQTtBQU5KO0FBU0E7RUFDSSxhQUFBO0FBUEo7QUFNQTtFQUdRLG9DQUFBO0VBQ0EsY0FBQTtBQU5SO0FBRUE7RUFPUSxvQ0FBQTtFQUNBLHVDQUFBO0FBTlIiLCJmaWxlIjoiZGF0YXNldC11cGRhdGUuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyJzbC1zd2l0Y2gge1xuICAgIC0taGVpZ2h0OiAxNnB4O1xuICAgIC0tdGh1bWItc2l6ZTogMThweDtcbiAgICBtYXJnaW4tcmlnaHQ6IDIwcHg7XG59XG5zbC1pbnB1dFtkaXNhYmxlZF0sXG5zbC1zZWxlY3RbZGlzYWJsZWRdIHtcbiAgICAmOjpwYXJ0KGZvcm0tY29udHJvbC1sYWJlbCkge1xuICAgICAgICBjb2xvcjogdmFyKC0tc2wtY29sb3ItYWN0aW9uLTQwMCk7XG4gICAgfVxufVxuXG4uaGVhZGVyLWNvbnRhaW5lciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBsaW5lLWhlaWdodDogMjRweDtcbiAgICBtYXJnaW4tYm90dG9tOiA0MHB4O1xufVxuXG4ubmV4dC11cGRhdGUge1xuICAgIGZvbnQtc2l6ZTogMTZweDtcbiAgICBmb250LXdlaWdodDogNDAwO1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktNjAwKTtcbiAgICBtYXJnaW4tdG9wOiAycHg7XG59XG5cbi5wYXJhbXMtY29udGFpbmVyIHtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoNCB7XG4gICAgICAgIGZvbnQtd2VpZ2h0OiA2MDA7XG4gICAgICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktOTAwKTtcbiAgICAgICAgbGluZS1oZWlnaHQ6IDI0cHg7XG4gICAgICAgIG1hcmdpbi10b3A6IDA7XG4gICAgICAgIG1hcmdpbi1ib3R0b206IDEwcHg7XG4gICAgfVxufVxuLnBhcmFtcy1jb250YWluZXIge1xuICAgIG1hcmdpbi1ib3R0b206IDQwcHg7XG59XG5cbi5wYXJhbXMtaGVhZGVyLWlucHV0IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGFsaWduLWl0ZW1zOiBmbGV4LWVuZDtcbiAgICBzbC1zZWxlY3Qge1xuICAgICAgICB3aWR0aDogMzEwcHg7XG4gICAgICAgIG1hcmdpbi1yaWdodDogdmFyKC0tc2wtc3BhY2luZy1sYXJnZSk7XG4gICAgfVxufVxuXG4uZGlzYWJsZWQge1xuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1hY3Rpb24tNTAwKSAhaW1wb3J0YW50O1xufVxuXG4uZXJyb3Ige1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgc3BhbiB7XG4gICAgICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICAgICAgbWFyZ2luOiBhdXRvIDA7XG4gICAgfVxuICAgIHNsLWljb24ge1xuICAgICAgICBmb250LXNpemU6IHZhcigtLXNsLWZvbnQtc2l6ZS1sYXJnZSk7XG4gICAgICAgIG1hcmdpbi1yaWdodDogdmFyKC0tc2wtc3BhY2luZy14LXNtYWxsKTtcbiAgICB9XG59XG4iXX0= */"] });


/***/ }),

/***/ 5845:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/dataset-update/dataset-update.service.ts ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetUpdateService": () => (/* binding */ DatasetUpdateService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);


class DatasetUpdateService {
    constructor() {
        this.onSubmit = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onCancel = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }
    submit() {
        this.onSubmit.emit();
    }
    cancel() {
        this.onCancel.emit();
    }
}
DatasetUpdateService.ɵfac = function DatasetUpdateService_Factory(t) { return new (t || DatasetUpdateService)(); };
DatasetUpdateService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: DatasetUpdateService, factory: DatasetUpdateService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 1893:
/*!***********************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/access/entities/local-entities.component.ts ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalEntitiesComponent": () => (/* binding */ LocalEntitiesComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! logical-not */ 2905);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(logical_not__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-track-by */ 1050);











function LocalEntitiesComponent_ng_container_0_p_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "access#noSearchResults"));
} }
function LocalEntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
const _c0 = function (a0) { return { $implicit: a0 }; };
function LocalEntitiesComponent_ng_container_0_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0, 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LocalEntitiesComponent_ng_container_0_ng_container_3_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const entity_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", _r5)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](2, _c0, entity_r7));
} }
function LocalEntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainer"](0);
} }
function LocalEntitiesComponent_ng_container_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "sl-checkbox", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("sl-change", function LocalEntitiesComponent_ng_container_0_ng_template_4_Template_sl_checkbox_sl_change_0_listener($event) { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r12); const entity_r9 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r11.onToggle(entity_r9, $event.target.checked)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LocalEntitiesComponent_ng_container_0_ng_template_4_ng_container_1_Template, 1, 0, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const entity_r9 = ctx.$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("checked", ctx_r6.isSelected(entity_r9));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngTemplateOutlet", ctx_r6.entityTemplate)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](3, _c0, entity_r9));
} }
function LocalEntitiesComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, LocalEntitiesComponent_ng_container_0_p_2_Template, 3, 3, "p", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, LocalEntitiesComponent_ng_container_0_ng_container_3_Template, 2, 4, "ng-container", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, LocalEntitiesComponent_ng_container_0_ng_template_4_Template, 2, 5, "ng-template", null, 5, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "core-pagination", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("onPageChange", function LocalEntitiesComponent_ng_container_0_Template_core_pagination_onPageChange_6_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵresetView"](ctx_r13.onPageChange($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r0.isEmpty);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r0.entities);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("total", ctx_r0.total)("limit", ctx_r0.params.limit)("page", ctx_r0.page);
} }
function LocalEntitiesComponent_ng_template_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "sl-spinner", 10);
} }
class LocalEntitiesComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_2__.SubscribableComponent {
    constructor(hostRef) {
        super();
        this.hostRef = hostRef;
        this.onSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.errorResponse = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
        this.entities = [];
        this.params = {};
        this.total = 0;
        this.page = 1;
        this.isEmpty = false;
        this.loading = false;
        this.inited = false;
    }
    ngOnInit() {
        this.dialog = this.hostRef.nativeElement.closest('sl-dialog');
        this.subscriptions = [
            (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.dialog, 'sl-show').subscribe((event) => {
                if (event.target === this.dialog) {
                    this.inited = false;
                    this.init();
                }
            }),
            (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.searchInput, 'sl-input').subscribe(() => {
                this.onSearch(this.searchInput.value);
            }),
        ];
    }
    onSearch(search) {
        this.params.search = search;
        this.params.offset = 0;
        this.page = 1;
        this.load();
    }
    isSelected(entity) {
        const isAddedItem = this.changes.added.some((item) => item.id === entity.id);
        const isRemovedItem = this.changes.removed.some((item) => item.id === entity.id);
        return (entity.selected || isAddedItem) && !isRemovedItem;
    }
    onToggle(entity, flag) {
        this.changes.removed = this.changes.removed.filter((item) => item.id !== entity.id);
        this.changes.added = this.changes.added.filter((item) => item.id !== entity.id);
        if (entity.selected !== flag) {
            flag
                ? this.changes.added.push(entity)
                : this.changes.removed.push(entity);
        }
        this.onSelect.emit({
            added: this.changes.added,
            removed: this.changes.removed,
        });
    }
    onPageChange(page) {
        this.page = page;
        this.params.offset = (page - 1) * this.params.limit;
        this.load();
    }
    init() {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_0__.not)(this.inited)) {
            this.inited = true;
            this.params = {
                search: '',
                limit: 20,
                offset: 0,
            };
            this.page = 1;
            this.searchInput.value = '';
            this.load();
        }
        else {
            this.searchInput.value = this.params.search || '';
        }
    }
    load() {
        this.entities = [];
        this.loading = true;
        this.entitiesProvider(this.params).subscribe({
            next: ({ rows, total }) => {
                this.entities = rows;
                this.total = total;
                this.isEmpty = total === 0;
                this.loading = false;
            },
            error: (response) => {
                this.errorResponse.emit(response);
            },
        });
    }
}
LocalEntitiesComponent.ɵfac = function LocalEntitiesComponent_Factory(t) { return new (t || LocalEntitiesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef)); };
LocalEntitiesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: LocalEntitiesComponent, selectors: [["app-local-entities"]], inputs: { entitiesProvider: "entitiesProvider", entityTemplate: "entityTemplate", searchInput: "searchInput", changes: "changes" }, outputs: { onSelect: "onSelect", errorResponse: "errorResponse" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 3, vars: 2, consts: [[4, "ngIf", "ngIfElse"], ["loader", ""], [1, "content"], [4, "ngIf"], ["trackById", "", 4, "ngFor", "ngForOf"], ["rowTemplate", ""], [3, "total", "limit", "page", "onPageChange"], ["trackById", ""], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["tooltipify", "", 1, "checkbox", 3, "checked", "sl-change"], [1, "spinner"]], template: function LocalEntitiesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](0, LocalEntitiesComponent_ng_container_0_Template, 7, 5, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, LocalEntitiesComponent_ng_template_1_Template, 1, 0, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.loading)("ngIfElse", _r1);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_4__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.PaginationComponent, ng_track_by__WEBPACK_IMPORTED_MODULE_6__.TrackByIdDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: ["[_nghost-%COMP%] {\n  position: relative;\n  flex: 1;\n}\n.content[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-rows: repeat(10, 32px);\n  grid-auto-flow: column;\n  grid-template-columns: repeat(2, 50%);\n  grid-row-gap: 4px;\n  margin-bottom: var(--sl-spacing-large);\n}\n.checkbox[_ngcontent-%COMP%]::part(base) {\n  display: initial;\n}\n.checkbox[_ngcontent-%COMP%]::part(label) {\n  margin-left: var(--sl-spacing-x-small);\n}\n.checkbox[_ngcontent-%COMP%]::part(control) {\n  position: relative;\n  top: 3px;\n}\n.spinner[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  font-size: 1rem;\n  background: rgba(255, 255, 255, 0.5);\n}\ncore-pagination[_ngcontent-%COMP%] {\n  margin-top: calc(0px - var(--sl-spacing-small));\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvY2FsLWVudGl0aWVzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksa0JBQUE7RUFDQSxPQUFBO0FBQ0o7QUFFQTtFQUNJLGFBQUE7RUFDQSxvQ0FBQTtFQUNBLHNCQUFBO0VBQ0EscUNBQUE7RUFDQSxpQkFBQTtFQUNBLHNDQUFBO0FBQUo7QUFJSTtFQUNJLGdCQUFBO0FBRlI7QUFLSTtFQUNJLHNDQUFBO0FBSFI7QUFNSTtFQUNJLGtCQUFBO0VBQ0EsUUFBQTtBQUpSO0FBUUE7RUFDSSxrQkFBQTtFQUNBLFFBQUE7RUFDQSxTQUFBO0VBQ0EsZ0NBQUE7RUFDQSxlQUFBO0VBQ0Esb0NBQUE7QUFOSjtBQVNBO0VBQ0ksK0NBQUE7QUFQSiIsImZpbGUiOiJsb2NhbC1lbnRpdGllcy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgZmxleDogMTtcbn1cblxuLmNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGdyaWQ7XG4gICAgZ3JpZC10ZW1wbGF0ZS1yb3dzOiByZXBlYXQoMTAsIDMycHgpO1xuICAgIGdyaWQtYXV0by1mbG93OiBjb2x1bW47XG4gICAgZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOiByZXBlYXQoMiwgNTAlKTtcbiAgICBncmlkLXJvdy1nYXA6IDRweDtcbiAgICBtYXJnaW4tYm90dG9tOiB2YXIoLS1zbC1zcGFjaW5nLWxhcmdlKTtcbn1cblxuLmNoZWNrYm94IHtcbiAgICAmOjpwYXJ0KGJhc2UpIHtcbiAgICAgICAgZGlzcGxheTogaW5pdGlhbDtcbiAgICB9XG5cbiAgICAmOjpwYXJ0KGxhYmVsKSB7XG4gICAgICAgIG1hcmdpbi1sZWZ0OiB2YXIoLS1zbC1zcGFjaW5nLXgtc21hbGwpO1xuICAgIH1cblxuICAgICY6OnBhcnQoY29udHJvbCkge1xuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgIHRvcDogM3B4O1xuICAgIH1cbn1cblxuLnNwaW5uZXIge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB0b3A6IDUwJTtcbiAgICBsZWZ0OiA1MCU7XG4gICAgdHJhbnNmb3JtOiB0cmFuc2xhdGUoLTUwJSwgLTUwJSk7XG4gICAgZm9udC1zaXplOiAxcmVtO1xuICAgIGJhY2tncm91bmQ6IHJnYmEoMjU1LCAyNTUsIDI1NSwgMC41KTtcbn1cblxuY29yZS1wYWdpbmF0aW9uIHtcbiAgICBtYXJnaW4tdG9wOiBjYWxjKDBweCAtIHZhcigtLXNsLXNwYWNpbmctc21hbGwpKTtcbn1cbiJdfQ== */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalEntitiesComponent.prototype, "entities", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.Debounce)(300)
], LocalEntitiesComponent.prototype, "onSearch", null);


/***/ }),

/***/ 6591:
/*!*********************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/access/local-access.module.ts ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalAccessModule": () => (/* binding */ LocalAccessModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ng-track-by */ 1050);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _entities_local_entities_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./entities/local-entities.component */ 1893);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);






class LocalAccessModule {
}
LocalAccessModule.ɵfac = function LocalAccessModule_Factory(t) { return new (t || LocalAccessModule)(); };
LocalAccessModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: LocalAccessModule });
LocalAccessModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PaginationModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_5__.TrackByIdModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](LocalAccessModule, { declarations: [_entities_local_entities_component__WEBPACK_IMPORTED_MODULE_0__.LocalEntitiesComponent], imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__.CommonModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_3__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PaginationModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_5__.TrackByIdModule], exports: [_entities_local_entities_component__WEBPACK_IMPORTED_MODULE_0__.LocalEntitiesComponent] }); })();


/***/ }),

/***/ 7150:
/*!**********************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/rule-access/local-rule-access.component.ts ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleAccessComponent": () => (/* binding */ LocalRuleAccessComponent),
/* harmony export */   "State": () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ng_to_parent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-to-parent */ 5468);
/* harmony import */ var src_app_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/api/dataset-rule-api.service */ 6119);
/* harmony import */ var _rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rule-access-modal/local-rule-access-modal.component */ 6127);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 3280);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 1989);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);











const _c0 = ["groupsContainer"];
const _c1 = ["usersContainer"];
function LocalRuleAccessComponent_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function LocalRuleAccessComponent_ng_container_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainer"](0);
} }
function LocalRuleAccessComponent_ng_template_15_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-tag", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-remove", function LocalRuleAccessComponent_ng_template_15_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r12); const group_r10 = restoredCtx.$implicit; const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r11.removeGroup(group_r10.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const group_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r10.name, " ");
} }
function LocalRuleAccessComponent_ng_template_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, LocalRuleAccessComponent_ng_template_15_sl_tag_0_Template, 3, 1, "sl-tag", 15);
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r5.groups);
} }
function LocalRuleAccessComponent_ng_template_17_sl_tag_0_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-tag", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("sl-remove", function LocalRuleAccessComponent_ng_template_17_sl_tag_0_Template_sl_tag_sl_remove_0_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r16); const user_r14 = restoredCtx.$implicit; const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"](2); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r15.removeUser(user_r14.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const user_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 1, user_r14), " ");
} }
function LocalRuleAccessComponent_ng_template_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](0, LocalRuleAccessComponent_ng_template_17_sl_tag_0_Template, 4, 3, "sl-tag", 15);
} if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx_r7.users);
} }
var State;
(function (State) {
    State[State["Users"] = 0] = "Users";
    State[State["Groups"] = 1] = "Groups";
})(State || (State = {}));
const MAX_LIMIT = 150;
const EPSILON = 1;
class LocalRuleAccessComponent {
    constructor(datasetRuleApiService, notifyService, responseErrorService) {
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.users = [];
        this.groups = [];
        this.removedUser = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.removedGroup = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = State;
        this.state = State.Groups;
        this.userTotal = Number.MAX_SAFE_INTEGER;
        this.userParams = this.getDefaultConfig();
        this.groupTotal = Number.MAX_SAFE_INTEGER;
        this.groupParams = this.getDefaultConfig();
    }
    set globalRule(value) {
        this._globalRule = value;
        if (this._globalRule &&
            this.dataset &&
            this._globalRule !== src_app_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.AllowAll)
            this.refresh();
    }
    get globalRule() {
        return this._globalRule;
    }
    ngAfterViewInit() {
        (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.groupsContainer.nativeElement, 'scroll')
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.debounceTime)(500))
            .subscribe(() => {
            if (!this.isScrollEnd(this.groupsContainer.nativeElement)) {
                return;
            }
            this.groupParams.offset += this.groupParams.limit;
            if (this.groupParams.offset >= this.groupTotal) {
                return;
            }
            this.getGroups();
        });
        (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.fromEvent)(this.usersContainer.nativeElement, 'scroll')
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.debounceTime)(500))
            .subscribe(() => {
            if (!this.isScrollEnd(this.usersContainer.nativeElement)) {
                return;
            }
            this.userParams.offset += this.userParams.limit;
            if (this.userParams.offset >= this.userTotal) {
                return;
            }
            this.getUsers();
        });
    }
    isScrollEnd(element) {
        return (element.scrollHeight - element.scrollTop - element.clientHeight <
            EPSILON);
    }
    resetParams() {
        this.users = [];
        this.userTotal = Number.MAX_SAFE_INTEGER;
        this.userParams = this.getDefaultConfig();
        this.groups = [];
        this.groupTotal = Number.MAX_SAFE_INTEGER;
        this.groupParams = this.getDefaultConfig();
    }
    getUsers() {
        this.usersProvider({
            include_not_selected: false,
            search: '',
            limit: this.userParams.limit,
            offset: this.userParams.offset,
        }).subscribe({
            next: (res) => {
                this.userTotal = res.total;
                this.users = [...this.users, ...(res.rows || [])];
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'getUsersGlobalRuleError',
                });
            },
        });
    }
    getGroups() {
        this.groupsProvider({
            include_not_selected: false,
            search: '',
            limit: this.groupParams.limit,
            offset: this.groupParams.offset,
        }).subscribe({
            next: (res) => {
                this.groupTotal = res.total;
                this.groups = [...this.groups, ...(res.rows || [])];
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'getGroupsGlobalRuleError',
                });
            },
        });
    }
    removeUser(userId) {
        this.datasetRuleApiService
            .saveGlobalRule(this.dataset.id, {
            data_access_restriction: this.globalRule,
            remove_users: [userId],
        })
            .subscribe({
            next: () => {
                this.users = this.users.filter((user) => user.id !== userId);
                this.removedUser.emit(userId);
                this.notifyService.toastByName('deleteUser');
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteUserGlobalRuleError',
                });
            },
        });
    }
    removeGroup(groupId) {
        this.datasetRuleApiService
            .saveGlobalRule(this.dataset.id, {
            data_access_restriction: this.globalRule,
            remove_groups: [groupId],
        })
            .subscribe({
            next: () => {
                this.groups = this.groups.filter((group) => group.id !== groupId);
                this.removedGroup.emit(groupId);
                this.notifyService.toastByName('deleteGroup');
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteGroupGlobalRuleError',
                });
            },
        });
    }
    refresh() {
        this.resetParams();
        this.getUsers();
        this.getGroups();
    }
    getDefaultConfig() {
        return {
            limit: MAX_LIMIT,
            offset: 0,
        };
    }
}
LocalRuleAccessComponent.ɵfac = function LocalRuleAccessComponent_Factory(t) { return new (t || LocalRuleAccessComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](src_app_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService)); };
LocalRuleAccessComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: LocalRuleAccessComponent, selectors: [["app-local-rule-access"]], viewQuery: function LocalRuleAccessComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__.LocalRuleAccessModalComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_c1, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.ruleAccessModal = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.groupsContainer = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.usersContainer = _t.first);
    } }, inputs: { usersProvider: "usersProvider", groupsProvider: "groupsProvider", dataset: "dataset", globalRule: "globalRule" }, outputs: { removedUser: "removedUser", removedGroup: "removedGroup", update: "update" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵProvidersFeature"]([ng_to_parent__WEBPACK_IMPORTED_MODULE_6__.ToParent])], decls: 30, vars: 27, consts: [[1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], [1, "values"], ["groupsContainer", ""], [4, "ngTemplateOutlet"], ["usersContainer", ""], ["groupTemplate", ""], ["userTemplate", ""], ["variant", "text", 3, "click"], [3, "dataset", "state", "globalRule", "usersProvider", "groupsProvider", "onSave"], ["ruleAccesModal", ""], ["variant", "success", "name", "deleteUser"], ["variant", "success", "name", "deleteGroup"], ["pill", "", "removable", "", 3, "sl-remove", 4, "ngFor", "ngForOf"], ["pill", "", "removable", "", 3, "sl-remove"], ["tooltipify", "", 1, "tag-name"]], template: function LocalRuleAccessComponent_Template(rf, ctx) { if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0)(1, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "div")(5, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessComponent_Template_sl_button_click_5_listener() { return ctx.state = ctx.State.Groups; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessComponent_Template_sl_button_click_7_listener() { return ctx.state = ctx.State.Users; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](8, "sl-icon", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "div", 4, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](11, LocalRuleAccessComponent_ng_container_11_Template, 1, 0, "ng-container", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "div", 4, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](14, LocalRuleAccessComponent_ng_container_14_Template, 1, 0, "ng-container", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](15, LocalRuleAccessComponent_ng_template_15_Template, 1, 1, "ng-template", null, 8, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](17, LocalRuleAccessComponent_ng_template_17_Template, 1, 1, "ng-template", null, 9, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "sl-button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessComponent_Template_sl_button_click_19_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r17); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](23); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](_r8.show(ctx.state)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](22, "app-local-rule-access-modal", 11, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSave", function LocalRuleAccessComponent_Template_app_local_rule_access_modal_onSave_22_listener($event) { return ctx.update.emit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](24, "core-notify", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](26, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](27, "core-notify", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](29, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](16);
        const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 19, "entitiesTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.state === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.state === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.state !== ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.state !== ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngTemplateOutlet", _r6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](21, 21, "_$.access.add"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("dataset", ctx.dataset)("state", ctx.state)("globalRule", ctx.globalRule)("usersProvider", ctx.usersProvider)("groupsProvider", ctx.groupsProvider);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](26, 23, "ruleDeleteUser"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](29, 25, "ruleDeleteGroup"), "\n");
    } }, styles: [".label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-small);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.values[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  gap: 10px 11px;\n  overflow: hidden auto;\n  max-height: 240px;\n}\n.values[_ngcontent-%COMP%]:not(:empty) {\n  padding: var(--sl-spacing-small) 0;\n}\nsl-tag[_ngcontent-%COMP%] {\n  max-width: 100%;\n  background-color: var(--sl-color-neutral-0);\n  border-radius: 20px;\n}\nsl-tag[_ngcontent-%COMP%]::part(base) {\n  height: 26px;\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button) {\n  margin-left: var(--sl-spacing-x-small);\n}\nsl-tag[_ngcontent-%COMP%]::part(remove-button__base) {\n  height: 16px;\n  width: 16px;\n}\nsl-tag[_ngcontent-%COMP%]::part(content) {\n  display: flex;\n  overflow: hidden;\n}\n.tag-name[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-950);\n  font-size: 13px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalRuleAccessComponent.prototype, "users", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalRuleAccessComponent.prototype, "groups", void 0);


/***/ }),

/***/ 9244:
/*!*******************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/rule-access/local-rule-access.module.ts ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleAccessModule": () => (/* binding */ LocalRuleAccessModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./local-rule-access.component */ 7150);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-track-by */ 1050);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rule-access-modal/local-rule-access-modal.component */ 6127);
/* harmony import */ var _access_local_access_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../access/local-access.module */ 6591);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);










class LocalRuleAccessModule {
}
LocalRuleAccessModule.ɵfac = function LocalRuleAccessModule_Factory(t) { return new (t || LocalRuleAccessModule)(); };
LocalRuleAccessModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({ type: LocalRuleAccessModule });
LocalRuleAccessModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({ providers: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipe], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AvatarModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule,
        _access_local_access_module__WEBPACK_IMPORTED_MODULE_2__.LocalAccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PaginationModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_7__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipeModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetNgModuleScope"](LocalRuleAccessModule, { declarations: [_local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.LocalRuleAccessComponent, _rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__.LocalRuleAccessModalComponent], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.AvatarModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule,
        _access_local_access_module__WEBPACK_IMPORTED_MODULE_2__.LocalAccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.PaginationModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_6__.ShoelaceModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_7__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipeModule], exports: [_local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.LocalRuleAccessComponent] }); })();
_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetComponentScope"](_local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.LocalRuleAccessComponent, [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgTemplateOutlet, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyDirective, _rule_access_modal_local_rule_access_modal_component__WEBPACK_IMPORTED_MODULE_1__.LocalRuleAccessModalComponent], [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.UsernamePipe]);


/***/ }),

/***/ 6127:
/*!**********************************************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-access-module/rule-access/rule-access-modal/local-rule-access-modal.component.ts ***!
  \**********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleAccessModalComponent": () => (/* binding */ LocalRuleAccessModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../local-rule-access.component */ 7150);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _access_entities_local_entities_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../access/entities/local-entities.component */ 1893);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! shoelace-style-angular */ 5219);








function LocalRuleAccessModalComponent_ng_template_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](0);
} if (rf & 2) {
    const group_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", group_r6.name, " ");
} }
function LocalRuleAccessModalComponent_ng_template_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "core-avatar", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](3, "username");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const user_r7 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("user", user_r7)("size", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](3, 3, user_r7), " ");
} }
class LocalRuleAccessModalComponent {
    constructor() {
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_2__.EventEmitter();
        this.State = _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State;
        this.groupChanges = {
            added: [],
            removed: [],
        };
        this.userChanges = {
            added: [],
            removed: [],
        };
        this.loading = false;
        this.currentState = _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups;
        this.open = false;
    }
    selectUsers(event) {
        this.userChanges = event;
    }
    selectGroups(event) {
        this.groupChanges = event;
    }
    show(state = _local_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups) {
        this.userChanges = {
            added: [],
            removed: [],
        };
        this.groupChanges = {
            added: [],
            removed: [],
        };
        this.currentState = state;
        this.open = true;
    }
    hide() {
        this.open = false;
    }
    changeState(state) {
        this.currentState = state;
    }
    save() {
        const params = {
            add_groups: this.groupChanges.added.map((item) => item.id),
            remove_groups: this.groupChanges.removed.map((item) => item.id),
            add_users: this.userChanges.added.map((item) => item.id),
            remove_users: this.userChanges.removed.map((item) => item.id),
        };
        this.onSave.emit(params);
    }
    onShow(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = 'hidden';
    }
    onHide(dialog) {
        var _a;
        const parentDialog = (_a = dialog.parentElement) === null || _a === void 0 ? void 0 : _a.closest('sl-dialog');
        if (parentDialog)
            parentDialog.style.visibility = '';
    }
}
LocalRuleAccessModalComponent.ɵfac = function LocalRuleAccessModalComponent_Factory(t) { return new (t || LocalRuleAccessModalComponent)(); };
LocalRuleAccessModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: LocalRuleAccessModalComponent, selectors: [["app-local-rule-access-modal"]], inputs: { usersProvider: "usersProvider", groupsProvider: "groupsProvider", state: "state", dataset: "dataset", globalRule: "globalRule" }, outputs: { onSave: "onSave" }, decls: 29, vars: 29, consts: [[3, "open", "label", "openChange", "sl-show", "sl-hide"], ["dialog", ""], [1, "label"], ["size", "small", "circle", "", 3, "click"], ["name", "people"], ["name", "person"], ["clearable", "", 1, "search", 3, "placeholder"], ["searchInput", ""], ["slot", "clear-icon", "name", "x"], ["slot", "suffix", "library", "core", "name", "search-bold"], [1, "ents"], [1, "entities"], [3, "entitiesProvider", "entityTemplate", "searchInput", "changes", "onSelect"], ["groupEntityTemplate", ""], ["userEntityTemplate", ""], [3, "click"], ["variant", "primary", 3, "click"], [3, "user", "size"]], template: function LocalRuleAccessModalComponent_Template(rf, ctx) { if (rf & 1) {
        const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "sl-dialog", 0, 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("openChange", function LocalRuleAccessModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.open = $event; })("sl-show", function LocalRuleAccessModalComponent_Template_sl_dialog_sl_show_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onShow(_r0)); })("sl-hide", function LocalRuleAccessModalComponent_Template_sl_dialog_sl_hide_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r8); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](1); return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx.onHide(_r0)); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "div", 2)(4, "div")(5, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_5_listener() { return ctx.changeState(ctx.State.Groups); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](6, "sl-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "sl-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_7_listener() { return ctx.changeState(ctx.State.Users); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](8, "sl-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](9, "sl-input", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](12, "sl-icon", 8)(13, "sl-icon", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](14, "div", 10)(15, "div", 11)(16, "app-local-entities", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function LocalRuleAccessModalComponent_Template_app_local_entities_onSelect_16_listener($event) { return ctx.selectGroups($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](17, LocalRuleAccessModalComponent_ng_template_17_Template, 1, 1, "ng-template", null, 13, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "app-local-entities", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("onSelect", function LocalRuleAccessModalComponent_Template_app_local_entities_onSelect_19_listener($event) { return ctx.selectUsers($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](20, LocalRuleAccessModalComponent_ng_template_20_Template, 4, 5, "ng-template", null, 14, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](22, "footer")(23, "sl-button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_23_listener() { return ctx.open = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](24);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](25, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](26, "sl-button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function LocalRuleAccessModalComponent_Template_sl_button_click_26_listener() { return ctx.save(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](10);
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](18);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵreference"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("open", ctx.open)("label", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](2, 21, "_$.access.title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("active", ctx.currentState === ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](11, 23, "_$.access.search"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Groups);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("entitiesProvider", ctx.groupsProvider)("entityTemplate", _r2)("searchInput", _r1)("changes", ctx.groupChanges);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵclassProp"]("hidden", ctx.currentState !== ctx.State.Users);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("entitiesProvider", ctx.usersProvider)("entityTemplate", _r4)("searchInput", _r1)("changes", ctx.userChanges);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](25, 25, "$.cancel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](28, 27, "$.apply"), " ");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AvatarComponent, _access_entities_local_entities_component__WEBPACK_IMPORTED_MODULE_1__.LocalEntitiesComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_4__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.UsernamePipe], styles: ["sl-dialog[_ngcontent-%COMP%] {\n  --width: 730px;\n  visibility: visible;\n}\n.search[_ngcontent-%COMP%] {\n  width: 266px;\n}\n.label[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: var(--sl-spacing-large);\n}\n.label[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  font-weight: var(--sl-font-weight-bold);\n  color: var(--sl-color-secondary-900);\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-left: 10px;\n  position: relative;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]::part(base) {\n  border-color: var(--sl-color-primary-400);\n  height: 32px;\n  width: 32px;\n}\n.label[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  font-size: 18px;\n  color: var(--sl-color-primary-400);\n  transform: translate(-50%, -50%);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]::part(base) {\n  background: var(--sl-color-primary-400);\n}\n.label[_ngcontent-%COMP%]   sl-button.active[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-neutral-0);\n}\n.ents[_ngcontent-%COMP%] {\n  min-height: 420px;\n  height: 100%;\n}\ncore-avatar[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-small);\n  margin-bottom: var(--sl-spacing-2x-small);\n}\nsl-checkbox[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(base) {\n  width: 100%;\n}\nsl-checkbox[_ngcontent-%COMP%]::part(label) {\n  display: flex;\n  overflow: hidden;\n}\n.spinner-container[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], LocalRuleAccessModalComponent.prototype, "groupChanges", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], LocalRuleAccessModalComponent.prototype, "userChanges", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_6__.WatchChanges)()
], LocalRuleAccessModalComponent.prototype, "loading", void 0);


/***/ }),

/***/ 1275:
/*!****************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-rules/local-rule-form/local-rule-form.component.ts ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRuleFormComponent": () => (/* binding */ LocalRuleFormComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../../modals/confirm/confirm.component */ 8268);
/* harmony import */ var _local_rules_modal_local_rules_modal_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../local-rules-modal/local-rules-modal.component */ 4263);









function LocalRuleFormComponent_sl_input_6_Template(rf, ctx) { if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-input", 16, 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("sl-input", function LocalRuleFormComponent_sl_input_6_Template_sl_input_sl_input_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r8); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](1); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r7.search(_r6.value)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](3, "sl-icon", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "ruleSearch"));
} }
function LocalRuleFormComponent_div_7_div_1_sl_badge_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-badge", 27)(1, "span", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](3, "sl-icon", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const rule_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", rule_r10.users_count, " ");
} }
function LocalRuleFormComponent_div_7_div_1_sl_badge_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-badge")(1, "span", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](3, "sl-icon", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const rule_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", rule_r10.groups_count, " ");
} }
function LocalRuleFormComponent_div_7_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 21)(1, "div", 22)(2, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function LocalRuleFormComponent_div_7_div_1_Template_div_click_2_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r16); const rule_r10 = restoredCtx.$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](_r3.show(rule_r10)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](4, LocalRuleFormComponent_div_7_div_1_sl_badge_4_Template, 4, 1, "sl-badge", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](5, LocalRuleFormComponent_div_7_div_1_sl_badge_5_Template, 4, 1, "sl-badge", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "sl-icon-button", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function LocalRuleFormComponent_div_7_div_1_Template_sl_icon_button_click_6_listener() { const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r16); const rule_r10 = restoredCtx.$implicit; _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](16); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](_r4.show(rule_r10.id)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const rule_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", rule_r10.name, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", rule_r10.users_count);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", rule_r10.groups_count);
} }
function LocalRuleFormComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, LocalRuleFormComponent_div_7_div_1_Template, 7, 3, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx_r1.showedLocaleRules);
} }
function LocalRuleFormComponent_sl_button_12_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-button", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function LocalRuleFormComponent_sl_button_12_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r19); _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](18); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](_r5.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 1, "deleteRules"), "");
} }
class LocalRuleFormComponent {
    constructor(datasetRuleApiService, notifyService, responseErrorService) {
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.isAddButtonDisabled = false;
        this.GlobalRule = _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule;
        this.localRules = [];
        this.showedLocaleRules = [];
    }
    set globalRule(value) {
        if (!value)
            return;
        this._globalRule = value;
        this.getRules();
    }
    get globalRule() {
        return this._globalRule;
    }
    get hasLocalRules() {
        var _a;
        return Boolean((_a = this.localRules) === null || _a === void 0 ? void 0 : _a.length);
    }
    deleteRule(ruleId) {
        this.datasetRuleApiService
            .deleteLocalRules(this.dataset.id, this.globalRule, [ruleId])
            .subscribe({
            next: () => {
                this.notifyService.toastByName('deleteRule');
                this.localRules = this.showedLocaleRules =
                    this.localRules.filter((rule) => rule.id !== ruleId);
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteLocalRuleError',
                });
            },
        });
    }
    deleteAllRules() {
        this.datasetRuleApiService
            .deleteLocalRules(this.dataset.id, this.globalRule, this.localRules.map((rule) => rule.id))
            .subscribe({
            next: () => {
                this.notifyService.toastByName('deleteRules');
                this.localRules = [];
            },
            error: (error) => {
                this.responseErrorService.show.emit({
                    responseError: error,
                    key: 'deleteLocalRulesError',
                });
            },
        });
    }
    search(value) {
        this.datasetRuleApiService
            .getLocalRules(this.dataset.id, this.globalRule, { search: value })
            .subscribe((resp) => {
            this.showedLocaleRules = resp.rows;
        });
    }
    update() {
        this.getRules();
    }
    getRules() {
        this.datasetRuleApiService
            .getLocalRules(this.dataset.id, this.globalRule)
            .subscribe((resp) => {
            this.localRules = this.showedLocaleRules = resp.rows;
        });
    }
}
LocalRuleFormComponent.ɵfac = function LocalRuleFormComponent_Factory(t) { return new (t || LocalRuleFormComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ResponseErrorService)); };
LocalRuleFormComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({ type: LocalRuleFormComponent, selectors: [["app-local-rule-form"]], inputs: { isAddButtonDisabled: "isAddButtonDisabled", dataset: "dataset", globalRule: "globalRule" }, decls: 25, vars: 21, consts: [[1, "container"], [1, "local-rules-label", "bold"], [1, "simple", 3, "innerHTML"], ["class", "search", "clearable", "", 3, "placeholder", "sl-input", 4, "ngIf"], ["class", "locale-rules-menu", 4, "ngIf"], [1, "local-rule-actions"], ["variant", "text", 3, "disabled", "click"], ["variant", "text", 3, "click", 4, "ngIf"], [3, "dataset", "globalRule", "onSave"], ["localRuleModal", ""], ["title", "ruleRemoveTitle", "description", "ruleRemoveDescription", 3, "onOk"], ["confirmRuleRemove", ""], ["title", "allRulesRemoveTitle", "description", "allRulesRemoveDescription", 3, "onOk"], ["confirmAllRulesRemove", ""], ["variant", "success", "name", "deleteRule"], ["variant", "success", "name", "deleteRules"], ["clearable", "", 1, "search", 3, "placeholder", "sl-input"], ["searchInput", ""], ["name", "search", "slot", "suffix"], [1, "locale-rules-menu"], ["class", "locale-rule", 4, "ngFor", "ngForOf"], [1, "locale-rule"], [1, "locale-rule-information"], ["tooltipify", "", 1, "rule-button", 3, "click"], ["class", "badge-users", 4, "ngIf"], [4, "ngIf"], ["name", "x", 3, "click"], [1, "badge-users"], [1, "badge-count"], ["name", "person", 1, "badge-icon"], ["name", "people", 1, "badge-icon"], ["variant", "text", 3, "click"]], template: function LocalRuleFormComponent_Template(rf, ctx) { if (rf & 1) {
        const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 0)(1, "label", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](4, "span", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](6, LocalRuleFormComponent_sl_input_6_Template, 4, 3, "sl-input", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](7, LocalRuleFormComponent_div_7_Template, 2, 1, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "div", 5)(9, "sl-button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function LocalRuleFormComponent_Template_sl_button_click_9_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r20); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](14); return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](_r3.show()); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](12, LocalRuleFormComponent_sl_button_12_Template, 3, 3, "sl-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](13, "app-local-rules-modal", 8, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onSave", function LocalRuleFormComponent_Template_app_local_rules_modal_onSave_13_listener() { return ctx.update(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "app-confirm", 10, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onOk", function LocalRuleFormComponent_Template_app_confirm_onOk_15_listener($event) { return ctx.deleteRule($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](17, "app-confirm", 12, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("onOk", function LocalRuleFormComponent_Template_app_confirm_onOk_17_listener() { return ctx.deleteAllRules(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](19, "core-notify", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](22, "core-notify", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 11, "localeRuleLabel"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpropertyInterpolate"]("innerHTML", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 13, "localRuleSubtitle." + ctx.globalRule), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsanitizeHtml"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.hasLocalRules && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.hasLocalRules && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("disabled", ctx.isAddButtonDisabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](11, 15, "addRule"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.hasLocalRules && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("dataset", ctx.dataset)("globalRule", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](21, 17, "ruleDelete"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](24, 19, "rulesDelete"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_1__.ConfirmComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.NotifyComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TooltipifyDirective, _local_rules_modal_local_rules_modal_component__WEBPACK_IMPORTED_MODULE_2__.LocalRulesModalComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe], styles: [".container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  padding: var(--sl-spacing-large) var(--sl-spacing-medium);\n  position: relative;\n  border: 1px dashed var(--sl-color-primary-500);\n  border-radius: var(--sl-border-radius-medium);\n  width: 100%;\n}\n.bold[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  line-height: 30px;\n}\n.simple[_ngcontent-%COMP%] {\n  color: var(--sl-color-info-500);\n  font-weight: var(--sl-font-weight-normal);\n  line-height: 19px;\n  font-size: var(--sl-font-size-small);\n}\n.locale-rules-menu[_ngcontent-%COMP%] {\n  max-height: 220px;\n  overflow: auto;\n  width: 100%;\n}\n.local-rules-label[_ngcontent-%COMP%] {\n  background: var(--sl-color-neutral-0);\n  padding: 0 var(--sl-spacing-2x-small);\n  left: 16px;\n  position: absolute;\n  top: -16px;\n}\n.locale-rule[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  margin-bottom: 6px;\n  justify-content: space-between;\n}\n.locale-rule[_ngcontent-%COMP%]   sl-icon-button[_ngcontent-%COMP%]::part(base) {\n  padding-right: 0;\n  padding-left: 0;\n}\n.locale-rule-information[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  width: 100%;\n  overflow-x: hidden;\n}\n.locale-rule-information[_ngcontent-%COMP%]   sl-badge[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n}\n.locale-rule-information[_ngcontent-%COMP%]   sl-badge[_ngcontent-%COMP%]::part(base) {\n  background-color: var(--sl-color-neutral-100);\n  padding-left: var(--sl-spacing-2x-small);\n  padding-right: var(--sl-spacing-2x-small);\n  border: none;\n}\n.locale-rule-information[_ngcontent-%COMP%]   .badge-count[_ngcontent-%COMP%] {\n  color: var(--sl-color-primary-600);\n  margin-right: var(--sl-spacing-2x-small);\n}\n.locale-rule-information[_ngcontent-%COMP%]   .badge-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n}\n.rule-button[_ngcontent-%COMP%] {\n  height: 24px;\n  max-width: 100%;\n  padding: 0 15px;\n  line-height: 180%;\n  color: var(--sl-color-secondary-900);\n  font-weight: 400;\n  font-size: 13px;\n  border: 1px solid var(--sl-color-secondary-900);\n  border-radius: var(--sl-border-radius-small);\n  margin-right: var(--sl-spacing-x-small);\n}\n.rule-button[_ngcontent-%COMP%]:hover {\n  cursor: pointer;\n  background-color: var(--sl-color-neutral-50);\n}\n.local-rule-actions[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  margin-top: var(--sl-spacing-medium);\n  flex-wrap: wrap;\n}\n.local-rule-actions[_ngcontent-%COMP%]   sl-button[disabled][_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-action-500);\n  opacity: 1;\n}\n.search[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-small) 0;\n}\n.search[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  padding-right: var(--sl-spacing-small);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.Debounce)(300)
], LocalRuleFormComponent.prototype, "search", null);


/***/ }),

/***/ 4263:
/*!********************************************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-rules/local-rules-modal/local-rules-modal.component.ts ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRulesModalComponent": () => (/* binding */ LocalRulesModalComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../components/rule-access/rule-access.component */ 8034);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library/filters */ 6866);
/* harmony import */ var _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../components/modal-actions/modal-actions.component */ 4335);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! shoelace-style-angular */ 5219);













const _c0 = function () { return []; };
class LocalRulesModalComponent {
    constructor(appService, datasetRuleApiService, notifyService, formService, responseErrorService) {
        this.appService = appService;
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.formService = formService;
        this.responseErrorService = responseErrorService;
        this.usersProvider = (payload) => {
            var _a;
            const params = Object.assign(Object.assign({}, payload), { exclude_ids: [this.appService.user.value.id] });
            return this.datasetRuleApiService.getLocalRulesAvailableUsers(this.dataset.id, this.globalRule, ((_a = this.rule) === null || _a === void 0 ? void 0 : _a.id)
                ? Object.assign(Object.assign({}, params), { exclude_rule_id: this.rule.id, order_by: 'last_name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SortDirection.Asc }) : params);
        };
        this.groupsProvider = (params) => {
            var _a;
            return this.datasetRuleApiService.getLocalRulesAvailableGroups(this.dataset.id, this.globalRule, ((_a = this.rule) === null || _a === void 0 ? void 0 : _a.id)
                ? Object.assign(Object.assign({}, params), { exclude_rule_id: this.rule.id, order_by: 'name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SortDirection.Asc }) : params);
        };
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        this.isOpen = false;
        this.users = [];
        this.groups = [];
        this.form = this.formService
            .create({
            name: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.required, (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.stringValidator)({ min: 1, max: 250 })]],
            filters: new _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormControl([]),
            id: [null],
        })
            .setup({
            method: (rules) => {
                return this.datasetRuleApiService.saveLocaleRule(this.dataset.id, this.globalRule, Object.assign(Object.assign({}, rules), { users: this.users.map((item) => item.id), groups: this.groups.map((item) => item.id) }));
            },
            methodContext: this.datasetRuleApiService,
            success: () => {
                this.onSave.emit();
                this.isOpen = false;
                this.ruleAccess.ruleAccessModal.hide();
                this.notifyService.toastByName('noteRule');
            },
            error: (response) => {
                const key = this.rule
                    ? 'localRules.error.edit'
                    : 'localRules.error.create';
                this.responseErrorService.show.emit({
                    responseError: response,
                    key,
                });
            },
        });
    }
    onFiltersChange(filters) {
        this.form.patchValue({ filters });
    }
    show(rule) {
        this.form.reset();
        this.form.patchValue({
            name: '',
            filters: [],
            id: null,
        });
        this.rule = undefined;
        this.ruleAccess.state = _components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.State.Groups;
        this.users = [];
        this.groups = [];
        if (rule) {
            this.rule = rule;
            this.form.patchValue({
                name: rule.name,
                filters: rule.filter_rule || [],
                id: rule.id,
            });
            this.datasetRuleApiService
                .getLocalRule(this.dataset.id, this.globalRule, this.rule.id)
                .subscribe({
                next: (res) => {
                    this.users = res.users || [];
                    this.groups = res.groups || [];
                    this.isOpen = true;
                },
                error: (response) => {
                    this.responseErrorService.show.emit({
                        responseError: response,
                        key: 'localRules.error.show',
                    });
                },
            });
        }
        else {
            this.isOpen = true;
        }
    }
    removeUser(userId) {
        this.users = this.users.filter((user) => user.id !== userId);
    }
    removeGroup(groupId) {
        this.groups = this.groups.filter((group) => group.id !== groupId);
    }
    update(event) {
        this.users = event.users;
        this.groups = event.groups;
        this.ruleAccess.ruleAccessModal.hide();
    }
    saveNotification() {
        let state = this.rule ? 'edit' : 'created';
        return `ruleModalNotification.${state}`;
    }
}
LocalRulesModalComponent.ɵfac = function LocalRulesModalComponent_Factory(t) { return new (t || LocalRulesModalComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_1__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ResponseErrorService)); };
LocalRulesModalComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: LocalRulesModalComponent, selectors: [["app-local-rules-modal"]], viewQuery: function LocalRulesModalComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.ruleAccess = _t.first);
    } }, inputs: { dataset: "dataset", globalRule: "globalRule" }, outputs: { onSave: "onSave" }, decls: 17, vars: 24, consts: [[3, "label", "open", "openChange"], [3, "data"], ["name", "name", 3, "label"], [1, "filter"], [1, "bold"], [3, "dataset", "value", "change"], [3, "users", "groups", "usersProvider", "groupsProvider", "dataset", "globalRule", "removeUser", "removeGroup", "update"], ["ruleAccess", ""], ["okTitle", "$.save", 3, "hasBack", "onCancel"], ["variant", "success", "name", "noteRule"]], template: function LocalRulesModalComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-dialog", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("openChange", function LocalRulesModalComponent_Template_sl_dialog_openChange_0_listener($event) { return ctx.isOpen = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "core-form", 1)(3, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](4, "sl-input", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "span", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](10, "core-filters", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("change", function LocalRulesModalComponent_Template_core_filters_change_10_listener($event) { return ctx.onFiltersChange($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "app-rule-access", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("removeUser", function LocalRulesModalComponent_Template_app_rule_access_removeUser_11_listener($event) { return ctx.removeUser($event); })("removeGroup", function LocalRulesModalComponent_Template_app_rule_access_removeGroup_11_listener($event) { return ctx.removeGroup($event); })("update", function LocalRulesModalComponent_Template_app_rule_access_update_11_listener($event) { return ctx.update($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](13, "app-modal-actions", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onCancel", function LocalRulesModalComponent_Template_app_modal_actions_onCancel_13_listener() { return ctx.isOpen = false; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "core-notify", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](16, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        let tmp_6_0;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](1, 15, "ruleModalLabel"))("open", ctx.isOpen);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](5, 17, "ruleModalName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 19, "ruleModalFilters"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataset", ctx.dataset)("value", ((tmp_6_0 = ctx.form.get("filters")) == null ? null : tmp_6_0.value) || _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](23, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("users", ctx.users)("groups", ctx.groups)("usersProvider", ctx.usersProvider)("groupsProvider", ctx.groupsProvider)("dataset", ctx.dataset)("globalRule", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("hasBack", false);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](16, 21, ctx.saveNotification()), "\n");
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.ValidateComponent, plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_6__.FiltersComponent, _components_modal_actions_modal_actions_component__WEBPACK_IMPORTED_MODULE_2__.ModalActionsComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.NotifyComponent, _components_rule_access_rule_access_component__WEBPACK_IMPORTED_MODULE_0__.RuleAccessComponent, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_7__.OpenDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_3__.TranslatePipe], styles: ["sl-dialog[_ngcontent-%COMP%]::part(panel) {\n  max-height: 702px;\n}\n.filter[_ngcontent-%COMP%] {\n  margin: 25px 0;\n}\n.bold[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  line-height: 29px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvY2FsLXJ1bGVzLW1vZGFsLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksaUJBQUE7QUFDSjtBQUVBO0VBQ0ksY0FBQTtBQUFKO0FBRUE7RUFDSSxvQ0FBQTtFQUNBLG9DQUFBO0VBQ0EsdUNBQUE7RUFDQSxpQkFBQTtBQUFKIiwiZmlsZSI6ImxvY2FsLXJ1bGVzLW1vZGFsLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsic2wtZGlhbG9nOjpwYXJ0KHBhbmVsKSB7XG4gICAgbWF4LWhlaWdodDogNzAycHg7XG59XG5cbi5maWx0ZXIge1xuICAgIG1hcmdpbjogMjVweCAwO1xufVxuLmJvbGQge1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3Itc2Vjb25kYXJ5LTkwMCk7XG4gICAgZm9udC13ZWlnaHQ6IHZhcigtLXNsLWZvbnQtd2VpZ2h0LWJvbGQpO1xuICAgIGxpbmUtaGVpZ2h0OiAyOXB4O1xufVxuIl19 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], LocalRulesModalComponent.prototype, "users", void 0);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_9__.WatchChanges)()
], LocalRulesModalComponent.prototype, "groups", void 0);


/***/ }),

/***/ 6934:
/*!********************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/local-rules/local-rules.component.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LocalRulesComponent": () => (/* binding */ LocalRulesComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ts-enum-to-array */ 141);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var _local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./local-rule-form/local-rule-form.component */ 1275);
/* harmony import */ var _local_access_module_rule_access_local_rule_access_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../local-access-module/rule-access/local-rule-access.component */ 7150);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6362);













const _c0 = ["globalRuleSelect"];
function LocalRulesComponent_sl_menu_item_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-menu-item", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const rule_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("value", rule_r3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 2, "rule." + rule_r3), "");
} }
function LocalRulesComponent_div_13_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 13)(1, "app-local-rule-access", 14, 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("removedUser", function LocalRulesComponent_div_13_Template_app_local_rule_access_removedUser_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r5.removeUser()); })("removedGroup", function LocalRulesComponent_div_13_Template_app_local_rule_access_removedGroup_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r7.removeGroup()); })("update", function LocalRulesComponent_div_13_Template_app_local_rule_access_update_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r8.update($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("groupsProvider", ctx_r2.groupsProvider)("usersProvider", ctx_r2.usersProvider)("dataset", ctx_r2.dataset)("globalRule", ctx_r2.globalRule);
} }
const MAX_LIMIT = 250;
class LocalRulesComponent {
    constructor(datasetRuleApiService, notifyService, responseErrorService, appService) {
        this.datasetRuleApiService = datasetRuleApiService;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.appService = appService;
        this.groupsProvider = (params) => this.datasetRuleApiService.getGlobalRulesGroups(this.dataset.id, this.globalRule, Object.assign({ order_by: 'name', include_not_selected: true, order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SortDirection.Asc }, params));
        this.usersProvider = (params) => this.datasetRuleApiService.getGlobalRulesUsers(this.dataset.id, this.globalRule, Object.assign({ order_by: 'last_name', order_direction: plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.SortDirection.Asc, include_not_selected: true, exclude_ids: [this.appService.user.value.id] }, params));
        this.GlobalRule = _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule;
        this.rulesArray = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_1__.enumToArray)(_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule);
    }
    get isAddButtonDisabled() {
        if (this.globalRule === _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.RestrictAll)
            return true;
        if (this.globalRule === _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.AllowAll ||
            this.globalRule === _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.GlobalRule.RestrictSelect)
            return false;
        if (!this.ruleAccess)
            return true;
        return !this.ruleAccess.users.length && !this.ruleAccess.groups.length;
    }
    ngOnInit() {
        this.globalRule = this.dataset.data_access_restriction;
    }
    changeRule(event) {
        if ((0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.valueOf)(event) === this.globalRule)
            return;
        const params = {
            data_access_restriction: (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.valueOf)(event),
        };
        this.updateGlobalRule(params);
    }
    updateGlobalRule(params, refresh = false) {
        this.datasetRuleApiService
            .saveGlobalRule(this.dataset.id, params)
            .subscribe({
            next: () => {
                this.globalRule = params.data_access_restriction;
                if (refresh) {
                    this.ruleAccess.refresh();
                    this.notifyService.toastByName('changeRuleList');
                }
                else {
                    this.notifyService.toastByName('changeRule');
                }
            },
            error: (error) => {
                const key = refresh
                    ? 'changeGlobalRuleListError'
                    : 'changeGlobalRuleError';
                this.globalRuleSelect.nativeElement.value = this.globalRule;
                this.responseErrorService.show.emit({
                    responseError: error,
                    key,
                });
            },
        });
    }
    removeUser() {
        this.localeRuleForm.getRules();
    }
    removeGroup() {
        this.localeRuleForm.getRules();
    }
    update(payload) {
        const params = Object.assign({ data_access_restriction: this.globalRule }, payload);
        this.updateGlobalRule(params, true);
        this.ruleAccess.ruleAccessModal.hide();
    }
}
LocalRulesComponent.ɵfac = function LocalRulesComponent_Factory(t) { return new (t || LocalRulesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetRuleApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.AppService)); };
LocalRulesComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: LocalRulesComponent, selectors: [["app-local-rules"]], viewQuery: function LocalRulesComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_local_access_module_rule_access_local_rule_access_component__WEBPACK_IMPORTED_MODULE_3__.LocalRuleAccessComponent, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_2__.LocalRuleFormComponent, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.globalRuleSelect = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.ruleAccess = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.localeRuleForm = _t.first);
    } }, inputs: { dataset: "dataset" }, decls: 21, vars: 18, consts: [[1, "grid"], [1, "global-rules"], [1, "label"], [1, "bold"], [1, "simple"], ["hoist", "", 3, "value", "sl-select"], ["globalRuleSelect", ""], [3, "value", 4, "ngFor", "ngForOf"], ["class", "access", 4, "ngIf"], [3, "isAddButtonDisabled", "dataset", "globalRule"], ["variant", "success", "name", "changeRule"], ["variant", "success", "name", "changeRuleList"], [3, "value"], [1, "access"], [3, "groupsProvider", "usersProvider", "dataset", "globalRule", "removedUser", "removedGroup", "update"], ["ruleAccess", ""]], template: function LocalRulesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "div", 2)(3, "span", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](6, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](10, "sl-select", 5, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("sl-select", function LocalRulesComponent_Template_sl_select_sl_select_10_listener($event) { return ctx.changeRule($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](12, LocalRulesComponent_sl_menu_item_12_Template, 3, 4, "sl-menu-item", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, LocalRulesComponent_div_13_Template, 3, 4, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](14, "app-local-rule-form", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "core-notify", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "core-notify", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](5, 10, "ruleLabel"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 12, "ruleSubtitle." + ctx.globalRule), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("value", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx.rulesArray);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.globalRule !== ctx.GlobalRule.AllowAll && ctx.globalRule !== ctx.GlobalRule.RestrictAll);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("isAddButtonDisabled", ctx.isAddButtonDisabled)("dataset", ctx.dataset)("globalRule", ctx.globalRule);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](17, 14, "changeGlobalRuleNotification"), "\n");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](20, 16, "changeGlobalRuleListNotification"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _local_access_module_rule_access_local_rule_access_component__WEBPACK_IMPORTED_MODULE_3__.LocalRuleAccessComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.NotifyComponent, _local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_2__.LocalRuleFormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_5__.TranslatePipe], styles: [".grid[_ngcontent-%COMP%] {\n  display: grid;\n  grid-template-columns: 60% 30%;\n  grid-column-gap: calc(2 * var(--sl-spacing-small));\n}\n.bold[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-900);\n  font-weight: var(--sl-font-weight-bold);\n  line-height: 30px;\n  font-size: var(--sl-font-size-small);\n}\n.simple[_ngcontent-%COMP%] {\n  color: var(--sl-color-info-500);\n  font-weight: var(--sl-font-weight-normal);\n  line-height: 14px;\n  font-size: var(--sl-font-size-small);\n}\n.label[_ngcontent-%COMP%] {\n  margin-bottom: calc(2 * var(--sl-spacing-small));\n}\nsl-select[_ngcontent-%COMP%] {\n  margin-bottom: calc(2 * var(--sl-spacing-small));\n}\nsl-select[_ngcontent-%COMP%]::part(base) {\n  width: 250px;\n}\n.access[_ngcontent-%COMP%] {\n  background-color: var(--sl-color-border-and-bg-50);\n  padding: var(--sl-spacing-medium);\n  border-radius: 4px;\n}\nsl-badge[_ngcontent-%COMP%] {\n  margin: 0 4px;\n}\nsl-badge[_ngcontent-%COMP%]::part(base) {\n  height: 20px;\n  min-width: 30px;\n  background-color: var(--sl-color-neutral-100);\n}\nsl-badge[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-size: 12px;\n  font-weight: var(--sl-font-weight-normal);\n  color: var(--sl-color-primary-600);\n}\nsl-badge[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: 9px;\n  color: var(--sl-color-secondary-900);\n  margin-left: 5px;\n}\nsl-button[disabled][_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-action-500);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
(0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([
    (0,ng_onpush__WEBPACK_IMPORTED_MODULE_8__.WatchChanges)()
], LocalRulesComponent.prototype, "globalRule", void 0);


/***/ }),

/***/ 8666:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/params/params.component.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ParamsComponent": () => (/* binding */ ParamsComponent)
/* harmony export */ });
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 6362);




function ParamsComponent_core_access_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "core-access", 4);
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("settings", ctx_r0.dataset);
} }
class ParamsComponent {
    constructor() {
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.AccessRight;
    }
}
ParamsComponent.ɵfac = function ParamsComponent_Factory(t) { return new (t || ParamsComponent)(); };
ParamsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ParamsComponent, selectors: [["app-params"]], inputs: { dataset: "dataset", form: "form" }, decls: 8, vars: 8, consts: [[3, "data"], ["name", "name", 3, "label"], ["name", "comment", 3, "label"], [3, "settings", 4, "ngIf"], [3, "settings"]], template: function ParamsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "core-form", 0)(1, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "sl-input", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](5, "sl-textarea", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, ParamsComponent_core_access_7_Template, 1, 1, "core-access", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](3, 4, "commonName"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](6, 6, "commonDescription"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dataset.access_right === ctx.AccessRight.Full);
    } }, dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.AccessComponent, _angular_common__WEBPACK_IMPORTED_MODULE_2__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_1__.TranslatePipe], styles: ["sl-input[_ngcontent-%COMP%], sl-textarea[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-medium);\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhcmFtcy5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7RUFFSSx1Q0FBQTtBQUNKIiwiZmlsZSI6InBhcmFtcy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbInNsLWlucHV0LFxuc2wtdGV4dGFyZWEge1xuICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKTtcbn1cbiJdfQ== */"] });


/***/ }),

/***/ 7455:
/*!********************************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/common/sql-request/sql-request.component.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SqlRequestComponent": () => (/* binding */ SqlRequestComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ts-enum-to-array */ 141);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs */ 3158);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 745);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _enums_dataset__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../enums/dataset */ 163);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _api_dataset_sql_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../api/dataset-sql-api.service */ 3967);
/* harmony import */ var _api_source_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../api/source-api.service */ 8916);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! shoelace-style-angular */ 5219);













function SqlRequestComponent_ng_container_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainer"](0);
} }
function SqlRequestComponent_ng_container_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "sl-spinner");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 1, "datasetSqlRequest#loading"), " ");
} }
const _c0 = function (a0) { return { total: a0 }; };
function SqlRequestComponent_ng_container_21_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "sl-icon", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind2"](4, 1, "datasetSqlRequest#rowTotal", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction1"](4, _c0, ctx_r2.total)), " ");
} }
function SqlRequestComponent_ng_container_22_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "sl-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 1, ctx_r3.error), " ");
} }
function SqlRequestComponent_div_33_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "sl-icon", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const type_r9 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassMap"]("column-type-" + type_r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 3, "datasetSqlRequest#columnType." + type_r9), " ");
} }
function SqlRequestComponent_div_35_sl_menu_item_5_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "listSize.All"), " ");
} }
function SqlRequestComponent_div_35_sl_menu_item_5_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](0);
} if (rf & 2) {
    const limit_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](limit_r11);
} }
function SqlRequestComponent_div_35_sl_menu_item_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-menu-item", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](1, SqlRequestComponent_div_35_sl_menu_item_5_ng_container_1_Template, 3, 3, "ng-container", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](2, SqlRequestComponent_div_35_sl_menu_item_5_ng_template_2_Template, 1, 1, "ng-template", null, 32, _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const limit_r11 = ctx.$implicit;
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](3);
    const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("value", limit_r11);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", limit_r11 === ctx_r10.RowLimit.All)("ngIfElse", _r13);
} }
function SqlRequestComponent_div_35_Template(rf, ctx) { if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 26)(1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "sl-select", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("sl-change", function SqlRequestComponent_div_35_Template_sl_select_sl_change_4_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r16.changeLimit($event)); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](5, SqlRequestComponent_div_35_sl_menu_item_5_Template, 4, 3, "sl-menu-item", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](6, "core-pagination", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 5, "datasetSqlRequest#rowCount"));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("value", ctx_r5.currentRowLimit);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r5.rowLimits);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("limit", ctx_r5.getLimit())("total", ctx_r5.rows.length);
} }
function SqlRequestComponent_div_36_ng_container_1_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "th", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](2, "core-column-name", 37)(3, "core-table-sort", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const indexedColumn_r21 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassMap"]("column-type-" + indexedColumn_r21.status || 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("column", indexedColumn_r21.column);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("by", indexedColumn_r21.column.name);
} }
function SqlRequestComponent_div_36_ng_container_1_tr_6_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "td", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const indexedColumn_r24 = ctx.$implicit;
    const row_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", row_r22[indexedColumn_r24.key], " ");
} }
function SqlRequestComponent_div_36_ng_container_1_tr_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](1, SqlRequestComponent_div_36_ng_container_1_tr_6_ng_container_1_Template, 3, 1, "ng-container", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r20.columns);
} }
function SqlRequestComponent_div_36_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "core-table", 34)(2, "thead")(3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](4, SqlRequestComponent_div_36_ng_container_1_ng_container_4_Template, 4, 4, "ng-container", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](6, SqlRequestComponent_div_36_ng_container_1_tr_6_Template, 2, 1, "tr", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("total", ctx_r18.rows.length)("limit", ctx_r18.getLimit());
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r18.columns);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r18.rows);
} }
function SqlRequestComponent_div_36_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](1, SqlRequestComponent_div_36_ng_container_1_Template, 7, 4, "ng-container", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](38);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx_r6.total)("ngIfElse", _r7);
} }
function SqlRequestComponent_ng_template_37_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "sl-icon", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "div", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 1, "datasetSqlRequest#emptyPreview"), " ");
} }
const BIG_TEXTAREA_ROWS = 18;
const SMALL_TEXTAREA_ROWS = 8;
const limit = 'limit';
const offset = 'offset';
class SqlRequestComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__.SubscribableComponent {
    constructor(activatedRoute, datasetSqlApiService, formService, responseErrorService, router, sourceApiService) {
        super();
        this.activatedRoute = activatedRoute;
        this.datasetSqlApiService = datasetSqlApiService;
        this.formService = formService;
        this.responseErrorService = responseErrorService;
        this.router = router;
        this.sourceApiService = sourceApiService;
        this.onSave = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
        this.rows = [];
        this.columns = [];
        this.currentRowLimit = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.RowLimit.Ten;
        this.rowLimits = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__.enumToArray)(_enums_dataset__WEBPACK_IMPORTED_MODULE_1__.RowLimit);
        this.columnType = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_0__.enumToArray)(_enums_dataset__WEBPACK_IMPORTED_MODULE_1__.SqlColumnType);
        this.state = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.State.Default;
        this.showResult = false;
        this.query = {};
        this.total = 0;
        this.error = '';
        this.RowLimit = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.RowLimit;
        this.SqlColumnType = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.SqlColumnType;
        this.State = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.State;
        this.form = this.formService.form({
            datasource: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.required]],
            sqlString: [null, [plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.required]],
        });
        this.sourceProvider = (search, offset) => this.sourceApiService.sqlList({ sql: true, search, offset }).pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_7__.catchError)((responseError) => {
            this.responseErrorService.show.emit({
                responseError,
                key: 'datasetSqlRequest#dataSourceDanger',
            });
            return (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.of)({ rows: [], total: 0 });
        }));
    }
    get textAreaRows() {
        return this.showResult ? SMALL_TEXTAREA_ROWS : BIG_TEXTAREA_ROWS;
    }
    ngOnInit() {
        var _a;
        this.form.patchValue({
            datasource: this.dataset.datasource,
            sqlString: (_a = this.dataset.fields.find((item) => item.name === 'sql')) === null || _a === void 0 ? void 0 : _a.value,
        });
        this.subscriptions = [
            this.activatedRoute.queryParams.subscribe((params) => {
                let newParams = Object.assign({}, params);
                delete newParams['tab'];
                this.query = newParams;
                if (Object.keys(newParams).length)
                    this.loadPreview();
            }),
        ];
    }
    getLimit() {
        return this.currentRowLimit === _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.RowLimit.All
            ? 100
            : this.currentRowLimit;
    }
    changeLimit(event) {
        this.currentRowLimit = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.valueOf)(event);
        this.router.navigate([], {
            queryParams: {
                [limit]: this.getLimit(),
                [offset]: 0,
            },
            queryParamsHandling: 'merge',
        });
    }
    complyRequest() {
        if (this.form.invalid) {
            this.formService.showLocalErrors(this.form);
        }
        else {
            this.state = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.State.Wait;
            this.loadPreview();
        }
    }
    loadPreview() {
        const { datasource, sqlString } = this.form.value;
        const { limit, offset } = this.query;
        this.datasetSqlApiService
            .getSqlPrewiev(this.dataset.id, Object.assign(Object.assign({}, this.query), { offset: Number(offset) || 0, limit: Number(limit) || this.getLimit(), datasourceId: datasource.id, sqlString }))
            .subscribe({
            next: ({ columns, rows, total }) => {
                this.columns = columns;
                this.rows = rows;
                this.total = total;
                this.state = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.State.Done;
            },
            error: (response) => {
                this.error = `datasetSqlRequest#error.${response.status}`;
                this.state = _enums_dataset__WEBPACK_IMPORTED_MODULE_1__.State.Reject;
            },
        });
    }
    submit() {
        if (this.form.invalid) {
            this.formService.showLocalErrors(this.form);
        }
        else {
            this.onSave.emit(this.form.value);
        }
    }
}
SqlRequestComponent.ɵfac = function SqlRequestComponent_Factory(t) { return new (t || SqlRequestComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_dataset_sql_api_service__WEBPACK_IMPORTED_MODULE_2__.DatasetSqlApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ResponseErrorService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_source_api_service__WEBPACK_IMPORTED_MODULE_3__.SourceApiService)); };
SqlRequestComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: SqlRequestComponent, selectors: [["app-sql-request"]], inputs: { dataset: "dataset" }, outputs: { onSave: "onSave" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 39, vars: 34, consts: [[1, "container"], [1, "title"], [1, "sub-title"], [3, "data"], [1, "control-block"], [1, "suggest"], ["viewKey", "name", 3, "label", "placeholder", "control", "selected", "suggestionsProvider"], [1, "source-info"], ["variant", "primary", "outline", "", 3, "click"], [3, "ngSwitch"], [4, "ngSwitchCase"], ["name", "sqlString", 3, "rows"], [1, "controlers"], [1, "result-controler", 3, "click"], [1, "chevron", 3, "name"], [1, "result-text"], ["slot", "content"], ["class", "columnType", 4, "ngFor", "ngForOf"], ["name", "info-circle", 1, "info-icon"], ["class", "limit-controler", 4, "ngIf"], ["class", "result", 4, "ngIf"], ["emptyPreview", ""], ["name", "check-lg"], ["name", "exclamation-octagon"], [1, "columnType"], ["name", "square-fill"], [1, "limit-controler"], [3, "value", "sl-change"], [3, "value", 4, "ngFor", "ngForOf"], ["routing", "", 3, "limit", "total"], [3, "value"], [4, "ngIf", "ngIfElse"], ["noTranslate", ""], [1, "result"], ["tableMaxHeight", "200px", 3, "total", "limit"], [4, "ngFor", "ngForOf"], ["width", "10vw"], [3, "column"], ["routing", "", 3, "by"], ["maxWidth", "20vw"], [1, "empty-preview"], ["library", "platform", "name", "data-base"], [1, "empty-preview-subtitle"]], template: function SqlRequestComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](6, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "core-form", 3)(8, "div", 4)(9, "div", 5)(10, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](11, "core-suggest", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](12, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "div", 7)(15, "sl-button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function SqlRequestComponent_Template_sl_button_click_15_listener() { return ctx.complyRequest(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](18, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](19, SqlRequestComponent_ng_container_19_Template, 1, 0, "ng-container", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](20, SqlRequestComponent_ng_container_20_Template, 5, 3, "ng-container", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](21, SqlRequestComponent_ng_container_21_Template, 5, 6, "ng-container", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](22, SqlRequestComponent_ng_container_22_Template, 5, 3, "ng-container", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](23, "core-validate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](24, "sl-textarea", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](25, "div", 12)(26, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function SqlRequestComponent_Template_div_click_26_listener() { return ctx.showResult = !ctx.showResult; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](27, "sl-icon", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](28, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](29);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](30, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](31, "sl-tooltip")(32, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](33, SqlRequestComponent_div_33_Template, 5, 5, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](34, "sl-icon", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](35, SqlRequestComponent_div_35_Template, 7, 7, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](36, SqlRequestComponent_div_36_Template, 2, 2, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](37, SqlRequestComponent_ng_template_37_Template, 5, 3, "ng-template", null, 21, _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 22, "datasetSqlRequest#sqlSettings"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](6, 24, "datasetSqlRequest#chooseSource"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("data", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](12, 26, "datasetSqlRequest#source"))("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](13, 28, "datasetSqlRequest#sourceName"))("control", ctx.form.controls["datasourceId"])("selected", ctx.dataset.datasource || null)("suggestionsProvider", ctx.sourceProvider);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassProp"]("error", ctx.state === ctx.State.Reject);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](17, 30, "datasetSqlRequest#complyRequest"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngSwitch", ctx.state);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngSwitchCase", ctx.State.Default);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngSwitchCase", ctx.State.Wait);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngSwitchCase", ctx.State.Done);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngSwitchCase", ctx.State.Reject);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("rows", ctx.textAreaRows);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("name", ctx.showResult ? "chevron-down" : "chevron-right");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](30, 32, "datasetSqlRequest#result"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx.columnType);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.showResult && ctx.columns.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.showResult);
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_10__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgSwitch, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgSwitchCase, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ColumnNameComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.PaginationComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.MaxWidthDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TableSortRoutingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.WidthDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_11__.OpenableDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.SuggestComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.SuggestControlDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslatePipe], styles: [".container[_ngcontent-%COMP%] {\n  height: 100%;\n}\n.title[_ngcontent-%COMP%] {\n  font-weight: 600;\n  font-size: var(--sl-font-size-large);\n  line-height: 120%;\n  color: var(--sl-color-secondary-900);\n  margin-bottom: var(--sl-spacing-x-small);\n}\n.sub-title[_ngcontent-%COMP%] {\n  font-size: 13px;\n  line-height: 140%;\n  color: rgba(0, 0, 0, 0.54);\n  margin-bottom: var(--sl-spacing-medium);\n}\n.control-block[_ngcontent-%COMP%] {\n  display: flex;\n  margin-bottom: var(--sl-spacing-medium);\n}\n.suggest[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-large);\n}\n.source-info[_ngcontent-%COMP%] {\n  display: flex;\n  height: 40px;\n  align-items: center;\n  padding-top: 24px;\n}\n.source-info[_ngcontent-%COMP%]   sl-button[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-large);\n}\n.source-info[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%], .source-info[_ngcontent-%COMP%]   sl-spinner[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  margin-right: var(--sl-spacing-x-small);\n}\n.source-info[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  font-weight: 400;\n  font-size: var(--sl-font-size-small);\n  line-height: 19px;\n}\n.source-info[_ngcontent-%COMP%]:not(.error)   sl-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-success-500);\n}\n.source-info[_ngcontent-%COMP%]:not(.error)   span[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-400);\n}\nsl-textarea[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-medium);\n}\nsl-tooltip[_ngcontent-%COMP%] {\n  --sl-tooltip-arrow-size: 0;\n}\nsl-tooltip[_ngcontent-%COMP%]::part(body) {\n  color: var(--sl-color-secondary-900);\n  background: var(--sl-color-neutral-0);\n  box-shadow: 0px 4px 16px rgba(0, 0, 0, 0.1);\n  border-radius: 8px;\n}\n.controlers[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  margin-bottom: var(--sl-spacing-medium);\n  height: 40px;\n}\n.result-controler[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  height: 100%;\n}\n.result-controler[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n}\n.result-controler[_ngcontent-%COMP%]   .chevron[_ngcontent-%COMP%] {\n  font-size: 13px;\n}\n.result-controler[_ngcontent-%COMP%]   .result-text[_ngcontent-%COMP%] {\n  font-weight: var(--sl-font-weight-bold);\n  color: #394146;\n}\n.info-icon[_ngcontent-%COMP%] {\n  color: var(--sl-color-secondary-700);\n  font-size: var(--sl-font-size-large);\n}\n.limit-controler[_ngcontent-%COMP%] {\n  display: flex;\n  height: 100%;\n  align-items: center;\n}\n.limit-controler[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  margin-right: var(--sl-spacing-x-small);\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-info-500);\n}\n.limit-controler[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%] {\n  height: 38px;\n  width: 130px;\n  margin-right: var(--sl-spacing-x-small);\n}\n.limit-controler[_ngcontent-%COMP%]   core-pagination[_ngcontent-%COMP%] {\n  padding-bottom: var(--sl-spacing-small);\n}\n.empty-preview[_ngcontent-%COMP%] {\n  height: 200px;\n  width: 100%;\n}\n.empty-preview[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  width: 100%;\n  margin: 40px auto var(--sl-spacing-small) auto;\n  height: 48px;\n}\n.empty-preview[_ngcontent-%COMP%]   .empty-preview-subtitle[_ngcontent-%COMP%] {\n  margin: 0 auto;\n  width: 500px;\n  line-height: 24px;\n  color: var(--sl-color-secondary-500);\n  text-align: center;\n}\n.columnType[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.columnType[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%] {\n  font-size: var(--sl-font-size-medium);\n  margin-right: 10px;\n}\n.columnType[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  line-height: 24px;\n}\n.column-type-new[_ngcontent-%COMP%] {\n  color: #3b82f6;\n}\n.column-type-change[_ngcontent-%COMP%] {\n  color: #a855f7;\n}\n.column-type-remove[_ngcontent-%COMP%] {\n  color: #ef4444;\n}\n.column-type-old[_ngcontent-%COMP%] {\n  color: #394146;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ 2703:
/*!******************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/dataset-settings.component.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetSettingsComponent": () => (/* binding */ DatasetSettingsComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _api_dataset_api_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../api/dataset-api.service */ 5640);
/* harmony import */ var _dataset_settings_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dataset-settings.service */ 714);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../modals/confirm/confirm.component */ 8268);
/* harmony import */ var _modals_column_modal_column_modal_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../modals/column-modal/column-modal.component */ 7582);











const _c0 = ["deleteDatasetConfirm"];
function DatasetSettingsComponent_sl_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "sl-button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DatasetSettingsComponent_sl_button_2_Template_sl_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r6); _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](5); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r2.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "toDeleteDataset"), " ");
} }
const _c1 = function () { return [".", "add-repeat-data"]; };
function DatasetSettingsComponent_div_3_a_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "a", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](4, _c1));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 2, "changeOrAddData"), " ");
} }
const _c2 = function (a2) { return [".", "column", a2]; };
const _c3 = function (a0) { return { type: a0 }; };
function DatasetSettingsComponent_div_3_a_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](1, "core-column-name", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const item_r9 = ctx.$implicit;
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction1"](3, _c2, item_r9.id))("queryParams", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction1"](5, _c3, ctx_r8.dataset.type));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("column", item_r9);
} }
const _c4 = function () { return ["."]; };
const _c5 = function () { return { queryParams: "ignored", fragment: "exact", matrixParams: "exact", paths: "exact" }; };
function DatasetSettingsComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 10)(1, "div", 11)(2, "sl-card", 12)(3, "a", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "sl-card", 14)(7, "div", 15)(8, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "sl-icon-button", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DatasetSettingsComponent_div_3_Template_sl_icon_button_click_11_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r11); _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](8); return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](_r4.show()); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](12, DatasetSettingsComponent_div_3_a_12_Template, 3, 5, "a", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, DatasetSettingsComponent_div_3_a_13_Template, 2, 7, "a", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](15, "router-outlet");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](10, _c4))("routerLinkActiveOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](11, _c5));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](5, 6, "mainSettings"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](10, 8, "settingsColumnsTitle"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx_r1.isShowChangeOrAddData);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r1.dataset.columns);
} }
function DatasetSettingsComponent_core_form_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "core-form", 23)(1, "core-validate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](2, "sl-input", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("data", ctx_r3.passwordForm);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 2, "confirm.deleteDatasetLabel"));
} }
var DatasourceType;
(function (DatasourceType) {
    DatasourceType["Csv"] = "file-csv";
    DatasourceType["Json"] = "file-json";
    DatasourceType["Xls"] = "file-xls";
    DatasourceType["Xml"] = "file-xml";
})(DatasourceType || (DatasourceType = {}));
class DatasetSettingsComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__.SubscribableComponent {
    constructor(appService, accessRightsService, datasetCoreApiService, datasetApiService, datasetSettingsService, formService, activatedRoute, translateService, router, notifyService, responseErrorService) {
        super();
        this.appService = appService;
        this.accessRightsService = accessRightsService;
        this.datasetCoreApiService = datasetCoreApiService;
        this.datasetApiService = datasetApiService;
        this.datasetSettingsService = datasetSettingsService;
        this.formService = formService;
        this.activatedRoute = activatedRoute;
        this.translateService = translateService;
        this.router = router;
        this.notifyService = notifyService;
        this.responseErrorService = responseErrorService;
        this.AccessRight = plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.AccessRight;
        this.crumbs = {
            items: [
                {
                    label: this.translateService.watchTranslation('datasets'),
                    link: '/dataset',
                },
            ],
            target: this.translateService.watchTranslation('settingsTitle'),
        };
        this.passwordForm = this.formService.form({
            password: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
        });
        this.isDatasetLock = false;
    }
    get user() {
        return this.appService.user.value;
    }
    get isDeleteButtonShown() {
        var _a;
        if (((_a = this.activatedRoute.snapshot.firstChild) === null || _a === void 0 ? void 0 : _a.params.column_id) !==
            undefined)
            return false;
        if (!this.dataset)
            return false;
        if (this.dataset.lock) {
            return (this.user.super_user ||
                this.dataset.lock.owner_id === this.user.id);
        }
        else {
            return this.dataset.access_right === plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.AccessRight.Full;
        }
    }
    get isShowChangeOrAddData() {
        var _a;
        switch ((_a = this.dataset) === null || _a === void 0 ? void 0 : _a.datasource_type) {
            case DatasourceType.Csv:
            case DatasourceType.Json:
            case DatasourceType.Xls:
            case DatasourceType.Xml:
                return true;
            default:
                return false;
        }
    }
    ngOnInit() {
        this.subscriptions = [
            this.datasetSettingsService.onChangeColumn.subscribe(() => {
                if (this.dataset) {
                    this.load();
                }
            }),
            this.datasetSettingsService.onLockDataset.subscribe((lock) => {
                this.isDatasetLock = lock;
            }),
            this.activatedRoute.params.subscribe(({ id }) => {
                this.datasetSettingsService.datasetId = id;
                this.load();
            }),
        ];
    }
    delete() {
        var _a;
        if (this.dataset.lock && this.passwordForm.invalid) {
            this.formService.showLocalErrors(this.passwordForm);
            this.deleteDatasetConfirm.isOpen = true;
            return;
        }
        const password = ((_a = this.passwordForm.get('password')) === null || _a === void 0 ? void 0 : _a.value) || '';
        this.datasetApiService
            .deleteList([this.dataset.id], password)
            .subscribe({
            next: () => {
                this.notifyService.toastByName('successRemoval');
                this.router.navigate(['/dataset']);
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'notification.delete.danger',
                });
            },
        });
        this.passwordForm.reset();
    }
    load() {
        this.datasetCoreApiService
            .get(this.datasetSettingsService.datasetId)
            .subscribe({
            next: ({ row }) => {
                this.datasetSettingsService.currentDataset.next(Object.assign({}, row));
                if (!this.accessRightsService.isSuperUser &&
                    row.access_right === plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.AccessRight.Read)
                    this.router.navigate([plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.accessDeniedPath], {
                        skipLocationChange: true,
                    });
                this.dataset = row;
                if (this.dataset.lock)
                    this.isDatasetLock = true;
                this.crumbs.items[1] = {
                    label: this.translateService.watchTranslation('datasetView'),
                    link: `/dataset/${this.dataset.id}`,
                };
            },
            error: (response) => {
                this.responseErrorService.show.emit({
                    responseError: response,
                    key: 'settingsViewDanger',
                });
            },
        });
    }
}
DatasetSettingsComponent.ɵfac = function DatasetSettingsComponent_Factory(t) { return new (t || DatasetSettingsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.AppService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.AccessRightsService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_api_dataset_api_service__WEBPACK_IMPORTED_MODULE_0__.DatasetApiService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_dataset_settings_service__WEBPACK_IMPORTED_MODULE_1__.DatasetSettingsService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_8__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslateService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_8__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.NotifyService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ResponseErrorService)); };
DatasetSettingsComponent.ɵcmp = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: DatasetSettingsComponent, selectors: [["app-dataset-settings"]], viewQuery: function DatasetSettingsComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c0, 5);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.deleteDatasetConfirm = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 12, vars: 11, consts: [[3, "breadcrumbs", "title"], ["variant", "danger", 3, "click", 4, "ngIf"], ["class", "grid", 4, "ngIf"], ["title", "deleteDataset", "description", "deleteDatasetDescription", 3, "onOk"], ["deleteDatasetConfirm", ""], ["class", "password-form", 3, "data", 4, "ngIf"], [3, "dataset", "onOk"], ["columnModalComponent", ""], ["variant", "success", "name", "successRemoval"], ["variant", "danger", 3, "click"], [1, "grid"], [1, "nav"], [1, "nav-card", "nav-card--header"], ["routerLinkActive", "active", 1, "nav-link", "nav-link--header", 3, "routerLink", "routerLinkActiveOptions"], [1, "nav-card"], [1, "nav-header"], ["name", "plus-circle", 1, "plus-icon", 3, "click"], ["class", "nav-add-data", 3, "routerLink", 4, "ngIf"], ["class", "nav-link", "routerLinkActive", "active", 3, "routerLink", "queryParams", 4, "ngFor", "ngForOf"], [1, "content"], [1, "nav-add-data", 3, "routerLink"], ["routerLinkActive", "active", 1, "nav-link", 3, "routerLink", "queryParams"], [3, "column"], [1, "password-form", 3, "data"], ["name", "password", "type", "password", 3, "label"]], template: function DatasetSettingsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "core-header", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](2, DatasetSettingsComponent_sl_button_2_Template, 3, 3, "sl-button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](3, DatasetSettingsComponent_div_3_Template, 16, 12, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "app-confirm", 3, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onOk", function DatasetSettingsComponent_Template_app_confirm_onOk_4_listener() { return ctx.delete(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](6, DatasetSettingsComponent_core_form_6_Template, 4, 4, "core-form", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "app-column-modal", 6, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("onOk", function DatasetSettingsComponent_Template_app_column_modal_onOk_7_listener() { return ctx.load(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "core-notify", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](11, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("title", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](1, 7, "settingsTitle"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("breadcrumbs", ctx.crumbs);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.isDeleteButtonShown);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.dataset);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.isDatasetLock);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataset", ctx.dataset);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](11, 9, "notification.delete"), "\n");
    } }, dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, _modals_confirm_confirm_component__WEBPACK_IMPORTED_MODULE_2__.ConfirmComponent, _modals_column_modal_column_modal_component__WEBPACK_IMPORTED_MODULE_3__.ColumnModalComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ColumnNameComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.HeaderComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.ValidateComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.NotifyComponent, _angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterOutlet, _angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterLinkWithHref, _angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterLinkActive, plmt_core_library__WEBPACK_IMPORTED_MODULE_6__.TranslatePipe], styles: [".grid[_ngcontent-%COMP%] {\n  display: flex;\n}\n.nav[_ngcontent-%COMP%] {\n  width: 100%;\n  max-width: 300px;\n}\n.content[_ngcontent-%COMP%] {\n  flex: 1;\n  box-sizing: border-box;\n  padding: 0 0 0 var(--sl-spacing-x-large);\n  overflow: hidden;\n}\n.nav-link[_ngcontent-%COMP%] {\n  display: block;\n  text-decoration: none;\n  color: var(--sl-color-secondary-900);\n  padding: var(--sl-spacing-small) var(--sl-spacing-x-large);\n}\n.nav-link.active[_ngcontent-%COMP%] {\n  background: var(--sl-color-primary-100);\n}\n.nav-link--header[_ngcontent-%COMP%] {\n  font-weight: var(--sl-font-weight-semibold);\n}\n.nav-header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  font-size: var(--sl-font-size-small);\n  color: var(--sl-color-secondary-600);\n  margin: var(--sl-spacing-medium) 0 0 0;\n  padding: 0 var(--sl-spacing-x-large);\n}\n.nav-add-data[_ngcontent-%COMP%] {\n  display: block;\n  text-decoration: none;\n  color: var(--sl-color-primary-500);\n  font-size: var(--sl-font-size-small);\n  margin-left: var(--sl-spacing-x-large);\n  padding: var(--sl-spacing-x-small) 0;\n  border: 1px solid var(--sl-color-primary-500);\n  width: 235px;\n  margin-top: 5px;\n  margin-bottom: 5px;\n  text-align: center;\n  cursor: pointer;\n}\n.nav-card[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.nav-card[_ngcontent-%COMP%]::part(base) {\n  border-radius: 4px;\n}\n.nav-card[_ngcontent-%COMP%]::part(body) {\n  padding: var(--sl-spacing-small) 0;\n}\n.nav-card--header[_ngcontent-%COMP%] {\n  margin-bottom: var(--sl-spacing-x-small);\n}\n.plus-icon[_ngcontent-%COMP%]::part(base) {\n  color: var(--sl-color-primary-500);\n  font-size: 16px;\n}\n.password-form[_ngcontent-%COMP%] {\n  padding: var(--sl-spacing-2x-small) 0;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRhdGFzZXQtc2V0dGluZ3MuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0FBQ0o7QUFFQTtFQUNJLFdBQUE7RUFDQSxnQkFBQTtBQUFKO0FBR0E7RUFDSSxPQUFBO0VBQ0Esc0JBQUE7RUFDQSx3Q0FBQTtFQUNBLGdCQUFBO0FBREo7QUFJQTtFQUNJLGNBQUE7RUFDQSxxQkFBQTtFQUNBLG9DQUFBO0VBQ0EsMERBQUE7QUFGSjtBQUlJO0VBQ0ksdUNBQUE7QUFGUjtBQUtJO0VBQ0ksMkNBQUE7QUFIUjtBQU9BO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7RUFFQSxvQ0FBQTtFQUVBLG9DQUFBO0VBQ0Esc0NBQUE7RUFDQSxvQ0FBQTtBQVBKO0FBVUE7RUFDSSxjQUFBO0VBQ0EscUJBQUE7RUFDQSxrQ0FBQTtFQUNBLG9DQUFBO0VBQ0Esc0NBQUE7RUFDQSxvQ0FBQTtFQUNBLDZDQUFBO0VBQ0EsWUFBQTtFQUNBLGVBQUE7RUFDQSxrQkFBQTtFQUNBLGtCQUFBO0VBQ0EsZUFBQTtBQVJKO0FBV0E7RUFDSSxXQUFBO0FBVEo7QUFXSTtFQUNJLGtCQUFBO0FBVFI7QUFZSTtFQUNJLGtDQUFBO0FBVlI7QUFhSTtFQUNJLHdDQUFBO0FBWFI7QUFlQTtFQUNJLGtDQUFBO0VBQ0EsZUFBQTtBQWJKO0FBZ0JBO0VBQ0kscUNBQUE7QUFkSiIsImZpbGUiOiJkYXRhc2V0LXNldHRpbmdzLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiLmdyaWQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG59XG5cbi5uYXYge1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIG1heC13aWR0aDogMzAwcHg7XG59XG5cbi5jb250ZW50IHtcbiAgICBmbGV4OiAxO1xuICAgIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gICAgcGFkZGluZzogMCAwIDAgdmFyKC0tc2wtc3BhY2luZy14LWxhcmdlKTtcbiAgICBvdmVyZmxvdzogaGlkZGVuO1xufVxuXG4ubmF2LWxpbmsge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIHRleHQtZGVjb3JhdGlvbjogbm9uZTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3Itc2Vjb25kYXJ5LTkwMCk7XG4gICAgcGFkZGluZzogdmFyKC0tc2wtc3BhY2luZy1zbWFsbCkgdmFyKC0tc2wtc3BhY2luZy14LWxhcmdlKTtcblxuICAgICYuYWN0aXZlIHtcbiAgICAgICAgYmFja2dyb3VuZDogdmFyKC0tc2wtY29sb3ItcHJpbWFyeS0xMDApO1xuICAgIH1cblxuICAgICYtLWhlYWRlciB7XG4gICAgICAgIGZvbnQtd2VpZ2h0OiB2YXIoLS1zbC1mb250LXdlaWdodC1zZW1pYm9sZCk7XG4gICAgfVxufVxuXG4ubmF2LWhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBhbGlnbi1pdGVtczogY2VudGVyO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcblxuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcblxuICAgIGNvbG9yOiB2YXIoLS1zbC1jb2xvci1zZWNvbmRhcnktNjAwKTtcbiAgICBtYXJnaW46IHZhcigtLXNsLXNwYWNpbmctbWVkaXVtKSAwIDAgMDtcbiAgICBwYWRkaW5nOiAwIHZhcigtLXNsLXNwYWNpbmcteC1sYXJnZSk7XG59XG5cbi5uYXYtYWRkLWRhdGEge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIHRleHQtZGVjb3JhdGlvbjogbm9uZTtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3ItcHJpbWFyeS01MDApO1xuICAgIGZvbnQtc2l6ZTogdmFyKC0tc2wtZm9udC1zaXplLXNtYWxsKTtcbiAgICBtYXJnaW4tbGVmdDogdmFyKC0tc2wtc3BhY2luZy14LWxhcmdlKTtcbiAgICBwYWRkaW5nOiB2YXIoLS1zbC1zcGFjaW5nLXgtc21hbGwpIDA7XG4gICAgYm9yZGVyOiAxcHggc29saWQgdmFyKC0tc2wtY29sb3ItcHJpbWFyeS01MDApO1xuICAgIHdpZHRoOiAyMzVweDtcbiAgICBtYXJnaW4tdG9wOiA1cHg7XG4gICAgbWFyZ2luLWJvdHRvbTogNXB4O1xuICAgIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgICBjdXJzb3I6IHBvaW50ZXI7XG59XG5cbi5uYXYtY2FyZCB7XG4gICAgd2lkdGg6IDEwMCU7XG5cbiAgICAmOjpwYXJ0KGJhc2UpIHtcbiAgICAgICAgYm9yZGVyLXJhZGl1czogNHB4O1xuICAgIH1cblxuICAgICY6OnBhcnQoYm9keSkge1xuICAgICAgICBwYWRkaW5nOiB2YXIoLS1zbC1zcGFjaW5nLXNtYWxsKSAwO1xuICAgIH1cblxuICAgICYtLWhlYWRlciB7XG4gICAgICAgIG1hcmdpbi1ib3R0b206IHZhcigtLXNsLXNwYWNpbmcteC1zbWFsbCk7XG4gICAgfVxufVxuXG4ucGx1cy1pY29uOjpwYXJ0KGJhc2UpIHtcbiAgICBjb2xvcjogdmFyKC0tc2wtY29sb3ItcHJpbWFyeS01MDApO1xuICAgIGZvbnQtc2l6ZTogMTZweDtcbn1cblxuLnBhc3N3b3JkLWZvcm0ge1xuICAgIHBhZGRpbmc6IHZhcigtLXNsLXNwYWNpbmctMngtc21hbGwpIDA7XG59XG4iXX0= */"] });


/***/ }),

/***/ 3361:
/*!***************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/dataset-settings.module.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetSettingsModule": () => (/* binding */ DatasetSettingsModule)
/* harmony export */ });
/* harmony import */ var _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! @angular/cdk/drag-drop */ 4941);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _dataset_settings_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dataset-settings.component */ 2703);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! @angular/router */ 2816);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var shoelace_style_angular__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! shoelace-style-angular */ 5219);
/* harmony import */ var _common_common_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./common/common.component */ 9603);
/* harmony import */ var _add_repeat_data_add_repeat_data_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./add-repeat-data/add-repeat-data.component */ 1814);
/* harmony import */ var _column_column_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./column/column.component */ 7227);
/* harmony import */ var _add_repeat_data_components_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./add-repeat-data/components/file-upload/file-upload.component */ 9111);
/* harmony import */ var _modals_confirm_confirm_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../modals/confirm/confirm.module */ 5254);
/* harmony import */ var _modals_column_modal_column_modal_module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../modals/column-modal/column-modal.module */ 2448);
/* harmony import */ var _common_local_rules_local_rules_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./common/local-rules/local-rules.component */ 6934);
/* harmony import */ var _common_params_params_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./common/params/params.component */ 8666);
/* harmony import */ var _common_local_rules_local_rules_modal_local_rules_modal_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./common/local-rules/local-rules-modal/local-rules-modal.component */ 4263);
/* harmony import */ var plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! plmt-core-library/filters */ 6866);
/* harmony import */ var _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../components/modal-actions/modal-actions.module */ 4108);
/* harmony import */ var _components_rule_access_rule_access_module__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../components/rule-access/rule-access.module */ 8723);
/* harmony import */ var src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! src/app/modals/add-repeat-data/add-repeat-data-conformation-modal/add-repeat-data-conformation-modal.component */ 3916);
/* harmony import */ var src_app_modals_add_repeat_data_add_repeat_data_final_modal_add_repeat_data_final_modal_component__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! src/app/modals/add-repeat-data/add-repeat-data-final-modal/add-repeat-data-final-modal.component */ 5175);
/* harmony import */ var src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_components_add_repeat_data_conformation_table_add_repeat_data_conformation_table_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! src/app/modals/add-repeat-data/add-repeat-data-conformation-modal/components/add-repeat-data-conformation-table/add-repeat-data-conformation-table.component */ 60);
/* harmony import */ var src_app_modals_add_repeat_data_add_repeat_data_conformation_rules_modal_add_repeat_data_conformation_rules_modal_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! src/app/modals/add-repeat-data/add-repeat-data-conformation-rules-modal/add-repeat-data-conformation-rules-modal.component */ 8015);
/* harmony import */ var src_app_modals_add_repeat_data_add_repeat_data_conformation_question_modal_add_repeat_data_conformation_question_modal_component__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! src/app/modals/add-repeat-data/add-repeat-data-conformation-question-modal/add-repeat-data-conformation-question-modal.component */ 5259);
/* harmony import */ var _common_local_rules_local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./common/local-rules/local-rule-form/local-rule-form.component */ 1275);
/* harmony import */ var _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../../api/dataset-rule-api.service */ 6119);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var _column_components_column_formatting_column_formatting_component__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./column/components/column-formatting/column-formatting.component */ 4091);
/* harmony import */ var plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! plmt-core-library/column-formatting */ 418);
/* harmony import */ var _common_local_access_module_rule_access_local_rule_access_module__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./common/local-access-module/rule-access/local-rule-access.module */ 9244);
/* harmony import */ var _common_dataset_update_dataset_update_component__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./common/dataset-update/dataset-update.component */ 3878);
/* harmony import */ var _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! @angular/cdk/scrolling */ 5752);
/* harmony import */ var _components_spinner_spinner_module__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../../components/spinner/spinner.module */ 1266);
/* harmony import */ var _column_components_conversion_result_column_conversion_result_column_component__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./column/components/conversion-result-column/conversion-result-column.component */ 8208);
/* harmony import */ var _column_components_conversion_result_column_modal_mask_modal_mask_component__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./column/components/conversion-result-column/modal-mask/modal-mask.component */ 2852);
/* harmony import */ var _enums_update_dataset__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../../enums/update-dataset */ 8278);
/* harmony import */ var _common_dataset_update_components_start_update_inputs_start_update_inputs_component__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./common/dataset-update/components/start-update-inputs/start-update-inputs.component */ 9247);
/* harmony import */ var _common_dataset_update_components_interval_inputs_interval_inputs_component__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./common/dataset-update/components/interval-inputs/interval-inputs.component */ 8358);
/* harmony import */ var _common_sql_request_sql_request_component__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./common/sql-request/sql-request.component */ 7455);
/* harmony import */ var ng_track_by__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ng-track-by */ 1050);
/* harmony import */ var _modals_save_confirm_save_confirm_module__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../../modals/save-confirm/save-confirm.module */ 3422);
/* harmony import */ var _enums_dataset__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../../enums/dataset */ 163);
/* harmony import */ var _common_dataset_update_components_period_inputs_period_inputs_component__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./common/dataset-update/components/period-inputs/period-inputs.component */ 2687);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @angular/core */ 3184);















































class DatasetSettingsModule {
}
DatasetSettingsModule.ɵfac = function DatasetSettingsModule_Factory(t) { return new (t || DatasetSettingsModule)(); };
DatasetSettingsModule.ɵmod = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_32__["ɵɵdefineNgModule"]({ type: DatasetSettingsModule });
DatasetSettingsModule.ɵinj = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_32__["ɵɵdefineInjector"]({ providers: [
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.PageTranslationsGuard,
        (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.providePageTranslations)({
            sources: [
                'assets/i18n/datasets/setting/',
                'assets/i18n/datasets/update/',
                'assets/i18n/modals/column-modal/',
                'assets/core-library/i18n/column-formatting/',
                'assets/core-library/i18n/filters/',
                'assets/i18n/components/access/',
            ],
            keyInterpolation: Object.assign(Object.assign(Object.assign({}, plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.columnFormattingInterpolationKeys), plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_35__.filtersInterpolationKeys), { GlobalRule: _api_dataset_rule_api_service__WEBPACK_IMPORTED_MODULE_18__.GlobalRule,
                ColumnType: plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.ColumnType,
                DayWeek: _enums_update_dataset__WEBPACK_IMPORTED_MODULE_25__.DayWeek,
                Month: _enums_update_dataset__WEBPACK_IMPORTED_MODULE_25__.Month,
                InputsType: _enums_update_dataset__WEBPACK_IMPORTED_MODULE_25__.InputsType,
                SqlColumnType: _enums_dataset__WEBPACK_IMPORTED_MODULE_30__.SqlColumnType }),
        }),
    ], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.BetaDirectiveModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_36__.CommonModule,
        plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.DateFormattingModule,
        _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_37__.DragDropModule,
        _modals_confirm_confirm_module__WEBPACK_IMPORTED_MODULE_5__.ConfirmModule,
        plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.ColumnFormattingModule,
        _modals_column_modal_column_modal_module__WEBPACK_IMPORTED_MODULE_6__.ColumnModalModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.ColumnNameModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.ColumnTypeIconModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.FormModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.FormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.FileModule,
        plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_35__.FiltersModule,
        _common_local_access_module_rule_access_local_rule_access_module__WEBPACK_IMPORTED_MODULE_20__.LocalRuleAccessModule,
        _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_10__.ModalActionsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.PaginationModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.ReactiveFormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableModule,
        _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_37__.DragDropModule,
        _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__.ScrollingModule,
        _angular_router__WEBPACK_IMPORTED_MODULE_40__.RouterModule.forChild([
            {
                path: '',
                component: _dataset_settings_component__WEBPACK_IMPORTED_MODULE_0__.DatasetSettingsComponent,
                canActivate: [plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.PageTranslationsGuard],
                children: [
                    {
                        path: '',
                        component: _common_common_component__WEBPACK_IMPORTED_MODULE_1__.CommonComponent,
                    },
                    {
                        path: 'add-repeat-data',
                        component: _add_repeat_data_add_repeat_data_component__WEBPACK_IMPORTED_MODULE_2__.AddRepeatDataComponent,
                    },
                    {
                        path: 'column/:column_id',
                        component: _column_column_component__WEBPACK_IMPORTED_MODULE_3__.ColumnComponent,
                    },
                ],
            },
        ]),
        _components_rule_access_rule_access_module__WEBPACK_IMPORTED_MODULE_11__.RuleAccessModule,
        _modals_save_confirm_save_confirm_module__WEBPACK_IMPORTED_MODULE_29__.SaveConfirmModule,
        _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__.ScrollingModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_41__.ShoelaceModule,
        _components_spinner_spinner_module__WEBPACK_IMPORTED_MODULE_22__.SpinnerModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.SuggestModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_42__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TooltipifyModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.ReactiveFormsModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.FormsModule,
        _common_local_access_module_rule_access_local_rule_access_module__WEBPACK_IMPORTED_MODULE_20__.LocalRuleAccessModule,
        _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__.ScrollingModule,
        _components_spinner_spinner_module__WEBPACK_IMPORTED_MODULE_22__.SpinnerModule,
        plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.DateFormattingModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.PaginationModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.EmptyStateModule] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_32__["ɵɵsetNgModuleScope"](DatasetSettingsModule, { declarations: [_dataset_settings_component__WEBPACK_IMPORTED_MODULE_0__.DatasetSettingsComponent,
        _common_common_component__WEBPACK_IMPORTED_MODULE_1__.CommonComponent,
        _column_column_component__WEBPACK_IMPORTED_MODULE_3__.ColumnComponent,
        _add_repeat_data_add_repeat_data_component__WEBPACK_IMPORTED_MODULE_2__.AddRepeatDataComponent,
        _common_local_rules_local_rules_component__WEBPACK_IMPORTED_MODULE_7__.LocalRulesComponent,
        _common_local_rules_local_rules_modal_local_rules_modal_component__WEBPACK_IMPORTED_MODULE_9__.LocalRulesModalComponent,
        _common_params_params_component__WEBPACK_IMPORTED_MODULE_8__.ParamsComponent,
        _common_local_rules_local_rule_form_local_rule_form_component__WEBPACK_IMPORTED_MODULE_17__.LocalRuleFormComponent,
        _column_components_column_formatting_column_formatting_component__WEBPACK_IMPORTED_MODULE_19__.ColumnFormattingComponent,
        _add_repeat_data_components_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_4__.FileUploadComponent,
        src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_12__.AddRepeatDataConformationModalComponent,
        src_app_modals_add_repeat_data_add_repeat_data_final_modal_add_repeat_data_final_modal_component__WEBPACK_IMPORTED_MODULE_13__.AddRepeatDataFinalModalComponent,
        src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_components_add_repeat_data_conformation_table_add_repeat_data_conformation_table_component__WEBPACK_IMPORTED_MODULE_14__.AddRepeatDataConformationTableComponent,
        src_app_modals_add_repeat_data_add_repeat_data_conformation_rules_modal_add_repeat_data_conformation_rules_modal_component__WEBPACK_IMPORTED_MODULE_15__.AddRepeatDataConformationRulesModalComponent,
        src_app_modals_add_repeat_data_add_repeat_data_conformation_question_modal_add_repeat_data_conformation_question_modal_component__WEBPACK_IMPORTED_MODULE_16__.AddRepeatDataConformationQuestionModalComponent,
        _common_dataset_update_dataset_update_component__WEBPACK_IMPORTED_MODULE_21__.DatasetUpdateComponent,
        _common_dataset_update_components_interval_inputs_interval_inputs_component__WEBPACK_IMPORTED_MODULE_27__.IntervalInputsComponent,
        _column_components_conversion_result_column_conversion_result_column_component__WEBPACK_IMPORTED_MODULE_23__.ConversionResultColumnComponent,
        _column_components_conversion_result_column_modal_mask_modal_mask_component__WEBPACK_IMPORTED_MODULE_24__.ModalMaskComponent,
        _common_dataset_update_components_period_inputs_period_inputs_component__WEBPACK_IMPORTED_MODULE_31__.PeriodInputsComponent,
        _common_dataset_update_components_start_update_inputs_start_update_inputs_component__WEBPACK_IMPORTED_MODULE_26__.StartUpdateInputsComponent,
        _common_sql_request_sql_request_component__WEBPACK_IMPORTED_MODULE_28__.SqlRequestComponent], imports: [plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.AccessModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.BetaDirectiveModule,
        _angular_common__WEBPACK_IMPORTED_MODULE_36__.CommonModule,
        plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.DateFormattingModule,
        _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_37__.DragDropModule,
        _modals_confirm_confirm_module__WEBPACK_IMPORTED_MODULE_5__.ConfirmModule,
        plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.ColumnFormattingModule,
        _modals_column_modal_column_modal_module__WEBPACK_IMPORTED_MODULE_6__.ColumnModalModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.ColumnNameModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.ColumnTypeIconModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.HeaderModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.FormModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.FormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.FileModule,
        plmt_core_library_filters__WEBPACK_IMPORTED_MODULE_35__.FiltersModule,
        _common_local_access_module_rule_access_local_rule_access_module__WEBPACK_IMPORTED_MODULE_20__.LocalRuleAccessModule,
        _components_modal_actions_modal_actions_module__WEBPACK_IMPORTED_MODULE_10__.ModalActionsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.NotifyModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.PaginationModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.ReactiveFormsModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableModule,
        _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_37__.DragDropModule,
        _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__.ScrollingModule, _angular_router__WEBPACK_IMPORTED_MODULE_40__.RouterModule, _components_rule_access_rule_access_module__WEBPACK_IMPORTED_MODULE_11__.RuleAccessModule,
        _modals_save_confirm_save_confirm_module__WEBPACK_IMPORTED_MODULE_29__.SaveConfirmModule,
        _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__.ScrollingModule,
        shoelace_style_angular__WEBPACK_IMPORTED_MODULE_41__.ShoelaceModule,
        _components_spinner_spinner_module__WEBPACK_IMPORTED_MODULE_22__.SpinnerModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.SuggestModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableModule,
        ng_track_by__WEBPACK_IMPORTED_MODULE_42__.TrackByIdModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TranslateModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TooltipifyModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.ReactiveFormsModule,
        _angular_forms__WEBPACK_IMPORTED_MODULE_38__.FormsModule,
        _common_local_access_module_rule_access_local_rule_access_module__WEBPACK_IMPORTED_MODULE_20__.LocalRuleAccessModule,
        _angular_cdk_scrolling__WEBPACK_IMPORTED_MODULE_39__.ScrollingModule,
        _components_spinner_spinner_module__WEBPACK_IMPORTED_MODULE_22__.SpinnerModule,
        plmt_core_library_column_formatting__WEBPACK_IMPORTED_MODULE_34__.DateFormattingModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.PaginationModule,
        plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.EmptyStateModule] }); })();
_angular_core__WEBPACK_IMPORTED_MODULE_32__["ɵɵsetComponentScope"](_add_repeat_data_add_repeat_data_component__WEBPACK_IMPORTED_MODULE_2__.AddRepeatDataComponent, function () { return [_angular_common__WEBPACK_IMPORTED_MODULE_36__.NgClass, _angular_common__WEBPACK_IMPORTED_MODULE_36__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_36__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.NotifyComponent, _add_repeat_data_components_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_4__.FileUploadComponent,
    src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_12__.AddRepeatDataConformationModalComponent,
    src_app_modals_add_repeat_data_add_repeat_data_final_modal_add_repeat_data_final_modal_component__WEBPACK_IMPORTED_MODULE_13__.AddRepeatDataFinalModalComponent]; }, function () { return [plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TranslatePipe]; });
_angular_core__WEBPACK_IMPORTED_MODULE_32__["ɵɵsetComponentScope"](src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_add_repeat_data_conformation_modal_component__WEBPACK_IMPORTED_MODULE_12__.AddRepeatDataConformationModalComponent, function () { return [_angular_common__WEBPACK_IMPORTED_MODULE_36__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_36__.NgIf, plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableCheckboxControllerDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TableTextOverflow, plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.WidthDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_41__.OpenableDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_41__.OpenableExtendedDirective, shoelace_style_angular__WEBPACK_IMPORTED_MODULE_41__.OpenDirective, src_app_modals_add_repeat_data_add_repeat_data_conformation_modal_components_add_repeat_data_conformation_table_add_repeat_data_conformation_table_component__WEBPACK_IMPORTED_MODULE_14__.AddRepeatDataConformationTableComponent,
    src_app_modals_add_repeat_data_add_repeat_data_conformation_rules_modal_add_repeat_data_conformation_rules_modal_component__WEBPACK_IMPORTED_MODULE_15__.AddRepeatDataConformationRulesModalComponent,
    src_app_modals_add_repeat_data_add_repeat_data_conformation_question_modal_add_repeat_data_conformation_question_modal_component__WEBPACK_IMPORTED_MODULE_16__.AddRepeatDataConformationQuestionModalComponent]; }, function () { return [plmt_core_library__WEBPACK_IMPORTED_MODULE_33__.TranslatePipe]; });


/***/ }),

/***/ 714:
/*!****************************************************************************!*\
  !*** ./src/app/pages/dataset/dataset-settings/dataset-settings.service.ts ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatasetSettingsService": () => (/* binding */ DatasetSettingsService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 6317);



class DatasetSettingsService {
    constructor() {
        this.onChangeColumn = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.onLockDataset = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
        this.currentDataset = new rxjs__WEBPACK_IMPORTED_MODULE_1__.BehaviorSubject(null);
        this.datasetId = 0;
    }
}
DatasetSettingsService.ɵfac = function DatasetSettingsService_Factory(t) { return new (t || DatasetSettingsService)(); };
DatasetSettingsService.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: DatasetSettingsService, factory: DatasetSettingsService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ 418:
/*!*****************************************************************************************!*\
  !*** ./node_modules/plmt-core-library/fesm2015/plmt-core-library-column-formatting.mjs ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColumnFormattingComponent": () => (/* binding */ ColumnFormattingComponent),
/* harmony export */   "ColumnFormattingModule": () => (/* binding */ ColumnFormattingModule),
/* harmony export */   "DateFormattingComponent": () => (/* binding */ DateFormattingComponent),
/* harmony export */   "DateFormattingModule": () => (/* binding */ DateFormattingModule),
/* harmony export */   "columnFormattingInterpolationKeys": () => (/* binding */ columnFormattingInterpolationKeys)
/* harmony export */ });
/* harmony import */ var _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/cdk/drag-drop */ 4941);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6362);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var plmt_core_library__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plmt-core-library */ 9543);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 4929);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 587);
/* harmony import */ var _shoelace_style_shoelace__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @shoelace-style/shoelace */ 3004);
/* harmony import */ var logical_not__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! logical-not */ 2905);
/* harmony import */ var ng_onpush__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ng-onpush */ 2387);
/* harmony import */ var ng_to_parent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ng-to-parent */ 5468);
/* harmony import */ var ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-subscribable */ 7973);
/* harmony import */ var ts_enum_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ts-enum-to-array */ 141);

















function DateFormattingComponent_div_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainer"](0);
  }
}

function DateFormattingComponent_div_1_ng_template_2_ng_container_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementContainer"](0);
  }
}

function DateFormattingComponent_div_1_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](0, DateFormattingComponent_div_1_ng_template_2_ng_container_0_Template, 1, 0, "ng-container", 4);
  }

  if (rf & 2) {
    const unit_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();

    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](3);

    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngTemplateOutlet", _r1)("ngTemplateOutletContext", ctx_r5.getUnitContext(unit_r3, true));
  }
}

function DateFormattingComponent_div_1_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "div", 7);
  }
}

function DateFormattingComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, DateFormattingComponent_div_1_ng_container_1_Template, 1, 0, "ng-container", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](2, DateFormattingComponent_div_1_ng_template_2_Template, 1, 2, "ng-template", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, DateFormattingComponent_div_1_div_3_Template, 1, 0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const unit_r3 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();

    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵreference"](3);

    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngTemplateOutlet", _r1)("ngTemplateOutletContext", ctx_r0.getUnitContext(unit_r3));
  }
}

function DateFormattingComponent_ng_template_2_sl_checkbox_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-checkbox", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const disabledControl_r11 = ctx_r17.disabledControl;
    const checkboxDisabled_r13 = ctx_r17.checkboxDisabled;
    const unit_r9 = ctx_r17.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("control", disabledControl_r11)("disabled", checkboxDisabled_r13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 3, "_$$.columnFormatting.dateFormatting." + unit_r9.type), " ");
  }
}

function DateFormattingComponent_ng_template_2_sl_checkbox_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-checkbox", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    const disabledControl_r11 = ctx_r18.disabledControl;
    const checkboxDisabled_r13 = ctx_r18.checkboxDisabled;
    const unit_r9 = ctx_r18.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("checked", disabledControl_r11.value)("disabled", checkboxDisabled_r13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 3, "_$$.columnFormatting.dateFormatting." + unit_r9.type), " ");
  }
}

function DateFormattingComponent_ng_template_2_sl_menu_item_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-menu-item", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const value_r19 = ctx.$implicit;
    const unit_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("value", value_r19);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 2, "_$$.columnFormatting.dateFormatting.value." + unit_r9.type + value_r19), " ");
  }
}

function DateFormattingComponent_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "sl-icon", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](2, DateFormattingComponent_ng_template_2_sl_checkbox_2_Template, 3, 5, "sl-checkbox", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, DateFormattingComponent_ng_template_2_sl_checkbox_3_Template, 3, 5, "sl-checkbox", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "sl-select", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("sl-change", function DateFormattingComponent_ng_template_2_Template_sl_select_sl_change_4_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r22);
      const unit_r9 = restoredCtx.$implicit;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r21.onChangeValue(unit_r9, $event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](5, DateFormattingComponent_ng_template_2_sl_menu_item_5_Template, 3, 4, "sl-menu-item", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "sl-input", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("sl-input", function DateFormattingComponent_ng_template_2_Template_sl_input_sl_input_6_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r22);
      const unit_r9 = restoredCtx.$implicit;
      const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r23.onChangeSuffix(unit_r9, $event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const unit_r9 = ctx.$implicit;
    const values_r10 = ctx.values;
    const isPreview_r12 = ctx.isPreview;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", !isPreview_r12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", isPreview_r12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("value", unit_r9.value);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", values_r10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("value", unit_r9.suffix);
  }
}

const _c0 = ["precisionInput"];

function ColumnFormattingComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "plmt-arounds");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }
}

function ColumnFormattingComponent_div_2_sl_menu_item_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-menu-item", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const abbr_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("value", abbr_r5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 2, "$.format.numberAbbr." + abbr_r5), " ");
  }
}

function ColumnFormattingComponent_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "plmt-to-fixed");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "sl-select", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "sl-menu-item", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](7, ColumnFormattingComponent_div_2_sl_menu_item_7_Template, 3, 4, "sl-menu-item", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](8, "plmt-arounds");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "sl-checkbox", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](11, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 5, "_$$.columnFormatting.label.abbr"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("value", null);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 7, "_$$.columnFormatting.abbr.no"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx_r1.numberAbbrs);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](11, 9, "_$$.columnFormatting.label.grouping"), " ");
  }
}

function ColumnFormattingComponent_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "plmt-arounds");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](2, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](5, "plmt-date-formatting");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](4, 1, "_$$.columnFormatting.label.dateFormatting"), " ");
  }
}

function ColumnFormattingComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "sl-input", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](4, "sl-input", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 4, "_$$.columnFormatting.label.true"))("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 6, "_$$.columnFormatting.label.true.placeholder"));
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](5, 8, "_$$.columnFormatting.label.false"))("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](6, 10, "_$$.columnFormatting.label.false.placeholder"));
  }
}

const valueOptions = {};
const unitTypes = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_2__.enumToArray)(plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitType);
unitTypes.forEach(type => {
  switch (type) {
    case plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitType.Year:
    case plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitType.Month:
      valueOptions[type] = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_2__.enumToArray)(plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitValue);
      break;

    case plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitType.Millisecond:
      valueOptions[type] = [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitValue.S];
      break;

    default:
      valueOptions[type] = [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitValue.M, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitValue.S];
  }
});

class DateFormattingComponent extends ngx_subscribable__WEBPACK_IMPORTED_MODULE_5__.SubscribableComponent {
  constructor(formControlService) {
    super();
    this.formControlService = formControlService;
    this.name = 'date_format';
    this.value = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
    this.units = [];
    this.disabledCheckboxesMap = {};
    this.disabledControls = {};
  }

  set disableChechboxes(types) {
    unitTypes.forEach(type => {
      this.disabledCheckboxesMap[type] = types.includes(type);
    });
  }

  ngOnInit() {
    unitTypes.forEach(type => {
      const control = new _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormControl(false);
      this.subscriptions.push(control.valueChanges.subscribe(checked => {
        const unit = this.units.find(unit => unit.type === type);

        if (unit) {
          unit.disabled = (0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(checked);
          this.emitChanges();
        }
      }));
      this.disabledControls[type] = control;
    });
    this.formControlService.provide(this.name, () => ({
      createValueStream: () => this.value,
      setValue: units => {
        if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(units)) return;
        this.units = units;
        units.forEach(({
          type,
          disabled
        }) => this.disabledControls[type].patchValue((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(disabled)));
      }
    }));
  }

  onDrop({
    previousIndex,
    currentIndex
  }) {
    (0,_angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.moveItemInArray)(this.units, previousIndex, currentIndex);
    this.emitChanges();
  }

  getUnitContext(unit, isPreview = false) {
    const {
      type
    } = unit;
    return {
      $implicit: unit,
      values: valueOptions[type],
      disabledControl: this.disabledControls[type],
      isPreview,
      checkboxDisabled: this.disabledCheckboxesMap[type]
    };
  }

  onChangeDisabled(unit, {
    target
  }) {
    if (target instanceof _shoelace_style_shoelace__WEBPACK_IMPORTED_MODULE_0__.SlCheckbox) unit.disabled = target.checked;
    this.emitChanges();
  }

  onChangeValue(unit, event) {
    unit.value = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.valueOf)(event);
    this.emitChanges();
  }

  onChangeSuffix(unit, event) {
    unit.suffix = (0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.valueOf)(event);
    this.emitChanges();
  }

  emitChanges() {
    this.value.emit([...this.units]);
  }

}

DateFormattingComponent.ɵfac = function DateFormattingComponent_Factory(t) {
  return new (t || DateFormattingComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService));
};

DateFormattingComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({
  type: DateFormattingComponent,
  selectors: [["plmt-date-formatting"]],
  inputs: {
    name: "name",
    disableChechboxes: "disableChechboxes"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵProvidersFeature"]([plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService, ng_to_parent__WEBPACK_IMPORTED_MODULE_8__.ToParent]), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵInheritDefinitionFeature"]],
  decls: 4,
  vars: 1,
  consts: [["cdkDropList", "", 3, "cdkDropListDropped"], ["cdkDrag", "", 4, "ngFor", "ngForOf"], ["line", ""], ["cdkDrag", ""], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], ["cdkDragPreview", ""], ["class", "placeholder", 4, "cdkDragPlaceholder"], [1, "placeholder"], [1, "line"], ["name", "grip-vertical", 1, "drag-icon"], [3, "control", "disabled", 4, "ngIf"], [3, "checked", "disabled", 4, "ngIf"], ["size", "small", 3, "value", "sl-change"], [3, "value", 4, "ngFor", "ngForOf"], ["size", "small", 3, "value", "sl-input"], [3, "control", "disabled"], [3, "checked", "disabled"], [3, "value"]],
  template: function DateFormattingComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("cdkDropListDropped", function DateFormattingComponent_Template_div_cdkDropListDropped_0_listener($event) {
        return ctx.onDrop($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, DateFormattingComponent_div_1_Template, 4, 2, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](2, DateFormattingComponent_ng_template_2_Template, 7, 5, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplateRefExtractor"]);
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngForOf", ctx.units);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgTemplateOutlet, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDropList, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDrag, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDragPreview, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.CdkDragPlaceholder, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlControlDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]{display:block}.cdk-drop-list[_ngcontent-%COMP%]{margin-top:var(--sl-spacing-medium)}.cdk-drag[_ngcontent-%COMP%]:not(:last-child){margin-bottom:var(--sl-spacing-x-small)}.line[_ngcontent-%COMP%], .placeholder[_ngcontent-%COMP%]{display:flex;width:300px}.line[_ngcontent-%COMP%]:not(:last-child), .placeholder[_ngcontent-%COMP%]:not(:last-child){margin-bottom:var(--sl-spacing-x-small)}.line[_ngcontent-%COMP%]{align-items:center;background:var(--sl-color-neutral-50);border:1px solid var(--sl-color-border-and-bg-200);border-radius:var(--sl-spacing-2x-small);padding:3px}.line[_ngcontent-%COMP%]   sl-icon[_ngcontent-%COMP%]{margin-right:var(--sl-spacing-x-small);border-right:1px solid var(--sl-color-neutral-1000);padding:7px 0;cursor:pointer}.line[_ngcontent-%COMP%]   sl-select[_ngcontent-%COMP%]{width:100px;margin-left:auto}.line[_ngcontent-%COMP%]   sl-input[_ngcontent-%COMP%]{--sl-input-spacing-small: var(--sl-spacing-2x-small);width:24px;margin-left:var(--sl-spacing-2x-small)}.line[_ngcontent-%COMP%]:not(:last-child){margin-bottom:var(--sl-spacing-x-small)}.placeholder[_ngcontent-%COMP%]{height:38px}"]
});

(0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([(0,ng_onpush__WEBPACK_IMPORTED_MODULE_11__.WatchChanges)()], DateFormattingComponent.prototype, "units", void 0);

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵsetClassMetadata"](DateFormattingComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Component,
    args: [{
      selector: 'plmt-date-formatting',
      providers: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService, ng_to_parent__WEBPACK_IMPORTED_MODULE_8__.ToParent],
      template: "<div cdkDropList (cdkDropListDropped)=\"onDrop($event)\">\n    <div *ngFor=\"let unit of units\" cdkDrag>\n        <ng-container\n            *ngTemplateOutlet=\"line; context: getUnitContext(unit)\"\n        ></ng-container>\n\n        <ng-template cdkDragPreview>\n            <ng-container\n                *ngTemplateOutlet=\"line; context: getUnitContext(unit, true)\"\n            ></ng-container>\n        </ng-template>\n\n        <div *cdkDragPlaceholder class=\"placeholder\"></div>\n    </div>\n</div>\n\n<ng-template\n    #line\n    let-unit\n    let-values=\"values\"\n    let-disabledControl=\"disabledControl\"\n    let-isPreview=\"isPreview\"\n    let-checkboxDisabled=\"checkboxDisabled\"\n>\n    <div class=\"line\">\n        <sl-icon class=\"drag-icon\" name=\"grip-vertical\"></sl-icon>\n\n        <sl-checkbox\n            *ngIf=\"!isPreview\"\n            [control]=\"disabledControl\"\n            [disabled]=\"checkboxDisabled\"\n        >\n            {{ '_$$.columnFormatting.dateFormatting.' + unit.type | translate }}\n        </sl-checkbox>\n\n        <sl-checkbox\n            *ngIf=\"isPreview\"\n            [checked]=\"disabledControl.value\"\n            [disabled]=\"checkboxDisabled\"\n        >\n            {{ '_$$.columnFormatting.dateFormatting.' + unit.type | translate }}\n        </sl-checkbox>\n\n        <sl-select\n            size=\"small\"\n            [value]=\"unit.value\"\n            (sl-change)=\"onChangeValue(unit, $event)\"\n        >\n            <sl-menu-item *ngFor=\"let value of values\" [value]=\"value\">\n                {{\n                    '_$$.columnFormatting.dateFormatting.value.' +\n                        unit.type +\n                        value | translate\n                }}\n            </sl-menu-item>\n        </sl-select>\n\n        <sl-input\n            size=\"small\"\n            [value]=\"unit.suffix\"\n            (sl-input)=\"onChangeSuffix(unit, $event)\"\n        ></sl-input>\n    </div>\n</ng-template>\n",
      styles: [":host{display:block}.cdk-drop-list{margin-top:var(--sl-spacing-medium)}.cdk-drag:not(:last-child){margin-bottom:var(--sl-spacing-x-small)}.line,.placeholder{display:flex;width:300px}.line:not(:last-child),.placeholder:not(:last-child){margin-bottom:var(--sl-spacing-x-small)}.line{align-items:center;background:var(--sl-color-neutral-50);border:1px solid var(--sl-color-border-and-bg-200);border-radius:var(--sl-spacing-2x-small);padding:3px}.line sl-icon{margin-right:var(--sl-spacing-x-small);border-right:1px solid var(--sl-color-neutral-1000);padding:7px 0;cursor:pointer}.line sl-select{width:100px;margin-left:auto}.line sl-input{--sl-input-spacing-small: var(--sl-spacing-2x-small);width:24px;margin-left:var(--sl-spacing-2x-small)}.line:not(:last-child){margin-bottom:var(--sl-spacing-x-small)}.placeholder{height:38px}\n"]
    }]
  }], function () {
    return [{
      type: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService
    }];
  }, {
    name: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
    }],
    disableChechboxes: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
    }],
    units: []
  });
})();

class DateFormattingModule {}

DateFormattingModule.ɵfac = function DateFormattingModule_Factory(t) {
  return new (t || DateFormattingModule)();
};

DateFormattingModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({
  type: DateFormattingModule
});
DateFormattingModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.DragDropModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵsetClassMetadata"](DateFormattingModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, _angular_cdk_drag_drop__WEBPACK_IMPORTED_MODULE_7__.DragDropModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [DateFormattingComponent],
      declarations: [DateFormattingComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_3__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

class AroundsComponent {}

AroundsComponent.ɵfac = function AroundsComponent_Factory(t) {
  return new (t || AroundsComponent)();
};

AroundsComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({
  type: AroundsComponent,
  selectors: [["plmt-arounds"]],
  decls: 4,
  vars: 6,
  consts: [["name", "prefix", 3, "label"], ["name", "suffix", 3, "label"]],
  template: function AroundsComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](0, "sl-input", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](1, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](2, "sl-input", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](3, "translate");
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](1, 2, "_$$.columnFormatting.label.prefix"));
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("label", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](3, 4, "_$$.columnFormatting.label.suffix"));
    }
  },
  dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]{display:flex;justify-content:space-between;width:var(--column-formating-width)}sl-input[_ngcontent-%COMP%]{width:calc(50% - 9px)}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵsetClassMetadata"](AroundsComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Component,
    args: [{
      selector: 'plmt-arounds',
      template: "<sl-input\n    name=\"prefix\"\n    [label]=\"'_$$.columnFormatting.label.prefix' | translate\"\n></sl-input>\n\n<sl-input\n    name=\"suffix\"\n    [label]=\"'_$$.columnFormatting.label.suffix' | translate\"\n></sl-input>\n",
      styles: [":host{display:flex;justify-content:space-between;width:var(--column-formating-width)}sl-input{width:calc(50% - 9px)}\n"]
    }]
  }], null, null);
})();

const defaultPrecision = 2;

class ToFixedComponent {
  constructor(formControlService) {
    this.formControlService = formControlService;
    this.value = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
    this.checked = false;
    this.precision = defaultPrecision;
  }

  ngOnInit() {
    this.formControlService.provide('digit_capacity', () => ({
      createValueStream: () => this.value,
      setValue: value => {
        this.checked = value !== null;
        this.precision = value !== null ? value : defaultPrecision;
        this.updatePrecisionInput();
      }
    }));
  }

  ngAfterViewInit() {
    this.updatePrecisionInput();
  }

  onCheck() {
    this.checked = (0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(this.checked);
    if (this.checked) this.value.next(this.precision || 0);else this.value.next(null);
  }

  onInput(event) {
    const value = +(0,plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.valueOf)(event);
    if ((0,logical_not__WEBPACK_IMPORTED_MODULE_1__.not)(isNaN(value))) this.value.next(value);
  }

  updatePrecisionInput() {
    if (this.precisionInput) this.precisionInput.nativeElement.value = String(this.precision);
  }

}

ToFixedComponent.ɵfac = function ToFixedComponent_Factory(t) {
  return new (t || ToFixedComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService));
};

ToFixedComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({
  type: ToFixedComponent,
  selectors: [["plmt-to-fixed"]],
  viewQuery: function ToFixedComponent_Query(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵviewQuery"](_c0, 7);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵloadQuery"]()) && (ctx.precisionInput = _t.first);
    }
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵProvidersFeature"]([plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService, ng_to_parent__WEBPACK_IMPORTED_MODULE_8__.ToParent])],
  decls: 5,
  vars: 6,
  consts: [[3, "checked", "sl-change"], ["type", "number", 3, "min", "disabled", "sl-input"], ["precisionInput", ""]],
  template: function ToFixedComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "sl-checkbox", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("sl-change", function ToFixedComponent_Template_sl_checkbox_sl_change_0_listener() {
        return ctx.onCheck();
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](2, "translate");
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "sl-input", 1, 2);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("sl-input", function ToFixedComponent_Template_sl_input_sl_input_3_listener($event) {
        return ctx.onInput($event);
      });
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("checked", ctx.checked);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind1"](2, 4, "_$$.columnFormatting.label.toFixed"), "\n");
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("min", 0)("disabled", !ctx.checked);
    }
  },
  dependencies: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]{display:flex;align-items:center;gap:24px}sl-input[_ngcontent-%COMP%]{width:80px}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵsetClassMetadata"](ToFixedComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Component,
    args: [{
      selector: 'plmt-to-fixed',
      providers: [plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService, ng_to_parent__WEBPACK_IMPORTED_MODULE_8__.ToParent],
      template: "<sl-checkbox [checked]=\"checked\" (sl-change)=\"onCheck()\">\n    {{ '_$$.columnFormatting.label.toFixed' | translate }}\n</sl-checkbox>\n\n<sl-input\n    #precisionInput\n    type=\"number\"\n    [min]=\"0\"\n    [disabled]=\"!checked\"\n    (sl-input)=\"onInput($event)\"\n></sl-input>\n",
      styles: [":host{display:flex;align-items:center;gap:24px}sl-input{width:80px}\n"]
    }]
  }], function () {
    return [{
      type: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormControlService
    }];
  }, {
    precisionInput: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.ViewChild,
      args: ['precisionInput', {
        static: true
      }]
    }]
  });
})();

class ColumnFormattingComponent {
  constructor() {
    this.ColumnType = plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.ColumnType;
    this.numberAbbrs = (0,ts_enum_to_array__WEBPACK_IMPORTED_MODULE_2__.enumToArray)(plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatNumberAbbreviation);
  }

}

ColumnFormattingComponent.ɵfac = function ColumnFormattingComponent_Factory(t) {
  return new (t || ColumnFormattingComponent)();
};

ColumnFormattingComponent.ɵcmp = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({
  type: ColumnFormattingComponent,
  selectors: [["core-column-formatting"]],
  inputs: {
    columnType: "columnType",
    control: "control"
  },
  decls: 5,
  vars: 6,
  consts: [[3, "data", "ngSwitch"], ["class", "content", 4, "ngSwitchCase"], [1, "content"], ["name", "digits_separate_type", 3, "label"], [3, "value"], [3, "value", 4, "ngFor", "ngForOf"], ["name", "separate_digits"], ["name", "bool_true_format", 3, "label", "placeholder"], ["name", "bool_false_format", 3, "label", "placeholder"]],
  template: function ColumnFormattingComponent_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "core-form", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](1, ColumnFormattingComponent_div_1_Template, 2, 0, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](2, ColumnFormattingComponent_div_2_Template, 12, 11, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](3, ColumnFormattingComponent_div_3_Template, 6, 3, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](4, ColumnFormattingComponent_div_4_Template, 7, 12, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    }

    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("data", ctx.control)("ngSwitch", ctx.columnType);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngSwitchCase", ctx.ColumnType.String);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngSwitchCase", ctx.ColumnType.Number);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngSwitchCase", ctx.ColumnType.Date);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngSwitchCase", ctx.ColumnType.Boolean);
    }
  },
  dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgSwitch, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgSwitchCase, DateFormattingComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.SlNameDirective, AroundsComponent, ToFixedComponent, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslatePipe],
  styles: ["[_nghost-%COMP%]{--column-formating-width: 438px;display:block}.content[_ngcontent-%COMP%] > [_ngcontent-%COMP%]:not(:last-child){margin-bottom:var(--sl-spacing-medium)}.content[_ngcontent-%COMP%] > sl-select[_ngcontent-%COMP%], .content[_ngcontent-%COMP%] > sl-checkbox[_ngcontent-%COMP%], .content[_ngcontent-%COMP%] > sl-input[_ngcontent-%COMP%]{width:var(--column-formating-width)}label[_ngcontent-%COMP%]{line-height:20px}"]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵsetClassMetadata"](ColumnFormattingComponent, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Component,
    args: [{
      selector: 'core-column-formatting',
      template: "<core-form [data]=\"control\" [ngSwitch]=\"columnType\">\n    <div *ngSwitchCase=\"ColumnType.String\" class=\"content\">\n        <plmt-arounds></plmt-arounds>\n    </div>\n\n    <div *ngSwitchCase=\"ColumnType.Number\" class=\"content\">\n        <plmt-to-fixed></plmt-to-fixed>\n\n        <sl-select\n            name=\"digits_separate_type\"\n            [label]=\"'_$$.columnFormatting.label.abbr' | translate\"\n        >\n            <sl-menu-item [value]=\"null\">\n                {{ '_$$.columnFormatting.abbr.no' | translate }}\n            </sl-menu-item>\n\n            <sl-menu-item *ngFor=\"let abbr of numberAbbrs\" [value]=\"abbr\">\n                {{ '$.format.numberAbbr.' + abbr | translate }}\n            </sl-menu-item>\n        </sl-select>\n\n        <plmt-arounds></plmt-arounds>\n\n        <sl-checkbox name=\"separate_digits\">\n            {{ '_$$.columnFormatting.label.grouping' | translate }}\n        </sl-checkbox>\n    </div>\n\n    <div *ngSwitchCase=\"ColumnType.Date\" class=\"content\">\n        <plmt-arounds></plmt-arounds>\n        <label>\n            {{ '_$$.columnFormatting.label.dateFormatting' | translate }}\n        </label>\n        <plmt-date-formatting></plmt-date-formatting>\n    </div>\n\n    <div *ngSwitchCase=\"ColumnType.Boolean\" class=\"content\">\n        <sl-input\n            name=\"bool_true_format\"\n            [label]=\"'_$$.columnFormatting.label.true' | translate\"\n            [placeholder]=\"\n                '_$$.columnFormatting.label.true.placeholder' | translate\n            \"\n        >\n        </sl-input>\n\n        <sl-input\n            name=\"bool_false_format\"\n            [label]=\"'_$$.columnFormatting.label.false' | translate\"\n            [placeholder]=\"\n                '_$$.columnFormatting.label.false.placeholder' | translate\n            \"\n        >\n        </sl-input>\n    </div>\n</core-form>\n",
      styles: [":host{--column-formating-width: 438px;display:block}.content>:not(:last-child){margin-bottom:var(--sl-spacing-medium)}.content>sl-select,.content>sl-checkbox,.content>sl-input{width:var(--column-formating-width)}label{line-height:20px}\n"]
    }]
  }], null, {
    columnType: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
    }],
    control: [{
      type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
    }]
  });
})();

const columnFormattingInterpolationKeys = {
  FormatDateUnitType: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitType,
  FormatDateUnitValue: plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormatDateUnitValue
};

class ColumnFormattingModule {}

ColumnFormattingModule.ɵfac = function ColumnFormattingModule_Factory(t) {
  return new (t || ColumnFormattingModule)();
};

ColumnFormattingModule.ɵmod = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({
  type: ColumnFormattingModule
});
ColumnFormattingModule.ɵinj = /* @__PURE__ */_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, DateFormattingModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule]
});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵsetClassMetadata"](ColumnFormattingModule, [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule,
    args: [{
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, DateFormattingModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.FormModule, plmt_core_library__WEBPACK_IMPORTED_MODULE_4__.TranslateModule],
      exports: [ColumnFormattingComponent],
      declarations: [AroundsComponent, ToFixedComponent, ColumnFormattingComponent],
      schemas: [_angular_core__WEBPACK_IMPORTED_MODULE_3__.CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})(); /// <reference types="shoelace-style-angular/events" />

/**
 * Generated bundle index. Do not edit.
 */




/***/ })

}]);
//# sourceMappingURL=src_app_pages_dataset_dataset-settings_dataset-settings_module_ts.js.map