import time


# logger
from settings import LOGGER


def merge_dicts(*dicts) -> dict:
    """
    Merge many dictionaries.

    :param dicts:
    :return:
    """
    res = {}
    for dict_ in dicts:
        assert isinstance(dict_, dict)
        res.update(dict_)
    return res


def crop_extra_double_quotes(text: str):
    """
    >>> crop_extra_double_quotes("example")
    'example'
    >>> crop_extra_double_quotes("\\"8c36a165-c56d8357-d1796d42-a217021e\\"")
    '8c36a165-c56d8357-d1796d42-a217021e'
    >>> crop_extra_double_quotes(None)
    >>> crop_extra_double_quotes("")
    ''
    >>> crop_extra_double_quotes([])
    []
    """
    if not isinstance(text, str):
        return text
    text = text.lstrip('\"')
    text = text.rstrip('\"')
    return text


def timing(func):
    def wrap(*args, **kwargs):
        start = time.time()
        result = func(*args, **kwargs)
        end = time.time()
        LOGGER.info(f"Func name: {func.__qualname__}; time spent: {(end - start):.2f} sec")
        return result

    return wrap
