import copy

from typing import Tuple, List, Dict

from tools.utils import timing


class Hierarchy:
    """
    Now works only for one group.
    """

    def __init__(self, grouped_column_ids: List[List], tab_symb: str):
        self.grouped_column_ids = grouped_column_ids
        self.tab_symb = tab_symb

        self._validate()

    def _validate(self):
        assert len(self.grouped_column_ids) > 0
        for i, group in enumerate(self.grouped_column_ids):
            assert len(group) == len(self.grouped_column_ids[0])

    @timing
    def process(self, top_dims, left_dims, data_header, left_data, data) -> \
            Tuple[List, List, List[List], List[List], List[List]]:

        # хранит строку предыдущего уровня иерархии со всеми заполненными значениями для каждой группы
        prev_layer_row = {}
        # хранит обновленные индексы колонок; первый индекс - собранная иерархия,
        # остальные индексы - прочие значения, которые могут оказаться пустыми
        updated_grouped_column_ids = []

        def new_left_data_process(row: List[Dict], level: int):
            """
            Функция обработки левых колонок и преобразования их к новому виду.
            """

            # переносим значения из другой колонки в первую колонку группы и делаем отступ
            # в соооветсвии с параметрами иерархии
            for indexes in self.grouped_column_ids:
                row[indexes[0]] = row[indexes[level]]
                if isinstance(row[indexes[level]]['value'], str):
                    row[indexes[0]]['value'] = level * self.tab_symb + row[indexes[0]]['value']
                row[indexes[0]]['level'] = level

            # выбрасываем ненужные индексы после переноса в иерархию
            indexes_for_drop = []
            for indexes in self.grouped_column_ids:
                indexes_for_drop += indexes[1:]
            # indexes_for_drop = indexes[1:]

            for index in sorted(indexes_for_drop, reverse=True):
                del row[index]

            # обновляем индексы после удаления ненужных колонок
            if not updated_grouped_column_ids:
                for indexes in self.grouped_column_ids:
                    tmp_indexes = []
                    for index in indexes:
                        left_shift = len([index_for_drop for index_for_drop in indexes_for_drop if index_for_drop < index])
                        tmp_indexes += [index - left_shift]
                    updated_grouped_column_ids.append(tmp_indexes)

            # проверка, что все ячейки имеют значение; если нет, копируем с предыдущей строки одного уровня;
            # пустые строки в ячейках справа от иерархии получаются в том случае,
            # если данные ячейки были изначально пустыми (принадлежали значению выше), а значения в ячейках справа,
            # которые в будущем будут перенесены в иерархию, непустые
            # for indexes_group, indexes in enumerate(updated_grouped_column_ids):
            for shift_idx, cell in enumerate(row[updated_grouped_column_ids[0][0]:]):
                if cell['type'] == 1 and row[updated_grouped_column_ids[0][0]]['type'] == 2 and level in prev_layer_row:
                    row[updated_grouped_column_ids[0][0] + shift_idx] = prev_layer_row[level][updated_grouped_column_ids[0][0] + shift_idx]

            if row[updated_grouped_column_ids[0][0]]['type'] == 2:
                prev_layer_row[level] = row

            return row

        # новые данные
        new_left_data, new_data = [], []
        row_idx = 0
        curr_level = 0

        # move rows
        while row_idx < len(left_data):

            updated: bool = False

            for group_idx, group in enumerate(self.grouped_column_ids):

                for col_i, col_idx in enumerate(group):

                    if left_data[row_idx][col_idx]['type'] != 1 and group_idx == 0:
                        curr_level = col_i
                        new_left_data += [new_left_data_process(copy.deepcopy(left_data[row_idx]), curr_level)]
                        new_data += [data[row_idx]]
                        updated = True

                    elif left_data[row_idx][col_idx]['type'] == 5:
                        curr_level = col_i
                        new_left_data += [new_left_data_process(copy.deepcopy(left_data[row_idx]), curr_level)]
                        new_data += [data[row_idx]]
                        updated = True

            if not updated:
                new_left_data += [new_left_data_process(copy.deepcopy(left_data[row_idx]), curr_level)]
                new_data += [data[row_idx]]

            row_idx += 1

        # move totals
        row_idx = 0
        level_row_idx = {}
        while row_idx < len(new_left_data):

            next_row: bool = True

            for group_idx, group in enumerate(updated_grouped_column_ids):
                col_idx = group[0]

                type_cell = new_left_data[row_idx][col_idx]['type']
                level_cell = new_left_data[row_idx][col_idx]['level']

                if type_cell == 2:
                    if group_idx == 0:
                        level_row_idx[level_cell] = row_idx
                    next_row = True

                elif type_cell == 5 and group_idx == 0 and level_cell > 0:
                    new_data[level_row_idx[level_cell - 1]] = new_data[row_idx]
                    new_data.pop(row_idx)
                    new_left_data.pop(row_idx)
                    next_row = False

                    # удалим текст из ячеек, которые лежат справа от иерархии и принадлежат строке с итогами
                    if len(new_left_data[level_row_idx[level_cell - 1]]) > updated_grouped_column_ids[-1][0] + 1:
                        for left_data_cell in \
                                new_left_data[level_row_idx[level_cell - 1]][updated_grouped_column_ids[-1][0]+1:]:
                            left_data_cell['value'] = None

                elif type_cell == 5 and group_idx != 0:
                    new_data.pop(row_idx)
                    new_left_data.pop(row_idx)
                    next_row = False

            if next_row:
                row_idx += 1

        # update left dims
        indexes_for_drop = []
        for indexes in self.grouped_column_ids:
            indexes_for_drop += indexes[1:]
        for index_drop in sorted(indexes_for_drop, reverse=True):
            del left_dims[index_drop]

        return top_dims, left_dims, data_header, new_left_data, new_data
