from pydantic import BaseModel as BaseFormat
from typing import Optional

from settings import TitleConf
from .base import BaseBlock


class TitleFormat(BaseFormat):
    name: str = TitleConf.NAME
    columns_size: int
    font_size: int = TitleConf.FONT_SIZE
    font_bold: bool = TitleConf.FONT_BOLD
    align_h: str = TitleConf.ALIGN_H
    align_v: str = TitleConf.ALIGN_V


class TitleBlock(BaseBlock):
    """
    Put date block on sheet.
    Block size - 1 x <columns_size>.
    """

    FONT_SIZE = None
    FONT_BOLD = None
    ALIGN_H = None
    ALIGN_V = None

    def __init__(self, sheet, row_start):
        super().__init__(sheet, row_start)

    @classmethod
    def update_font_settings(cls, font_size: Optional[int] = None,
                             font_bold: Optional[bool] = None,
                             align_h: Optional[str] = None,
                             align_v: Optional[str] = None,
                             **kwargs):
        cls.FONT_SIZE = font_size
        cls.FONT_BOLD = font_bold
        cls.ALIGN_H = align_h
        cls.ALIGN_V = align_v

    def put(self, name: str, columns_size: int, **kwargs) -> int:

        self.update_font_settings(**kwargs)

        self.sheet.merge_cells(start_row=self.row_start, start_column=1,
                               end_row=self.row_start, end_column=columns_size)
        self._set_value(self.row_start, 1, name,
                        font=self._create_font(self.FONT_SIZE, self.FONT_BOLD),
                        alignment=self._create_alignment(self.ALIGN_H, self.ALIGN_V))
        return self.row_start + 2
