from typing import Optional
from pydantic import BaseModel as BaseFormat

from settings import FilterConf
from .base import BaseBlock


class OutFilterFormat(BaseFormat):
    filters: Optional[dict] = None
    columns_size: int
    name: str = FilterConf.OUT_NAME
    name_font_size: int = FilterConf.OUT_NAME_FONT_SIZE
    name_font_bold: bool = FilterConf.OUT_NAME_FONT_BOLD


class OutFilterBlock(BaseBlock):
    """
    Put date block on sheet.
    Block size - <2 or (1 + len(filters))> x 1.
    """

    NAME_FONT_SIZE = None
    NAME_FONT_BOLD = None

    @classmethod
    def update_font_settings(cls, name_font_size: Optional[int] = None,
                             name_font_bold: Optional[bool] = None, **kwargs):
        cls.NAME_FONT_SIZE = name_font_size
        cls.NAME_FONT_BOLD = name_font_bold

    def __init__(self, sheet, row_start):
        super().__init__(sheet, row_start)

    def _put_filters(self, columns_size: int, filters: dict):
        for key, values in filters.items():
            self.sheet.merge_cells(start_row=self.row_start, start_column=1,
                                   end_row=self.row_start, end_column=columns_size)
            self._set_value(self.row_start, 1, f"{key}: {', '.join(values)}")
            self.row_start += 1

    def put(self, columns_size: int, filters: Optional[dict] = None, name: str = "", **kwargs) -> int:

        self.update_font_settings(**kwargs)

        self.sheet.merge_cells(start_row=self.row_start, start_column=1,
                               end_row=self.row_start, end_column=columns_size)
        self._set_value(self.row_start, 1, name, font=self._create_font(self.NAME_FONT_SIZE, self.NAME_FONT_BOLD))
        self.row_start += 1
        if filters:
            self._put_filters(columns_size, filters)
        return self.row_start + 1  # skip line
