import logging
import json
import os


ROOT_PATH = os.path.dirname(os.path.abspath(__file__))


logging.basicConfig(format='%(asctime)s: %(message)s', filename=os.path.join(ROOT_PATH, 'app.log'))

LOGGER = logging.getLogger("Python-export-excel")
LOGGER.setLevel(logging.DEBUG)


""" <===== IMPORT CONFIG =====> """

config_env = os.environ.get("CONFIG_PATH")
candidates = []

if config_env:
    p = os.path.join(config_env, 'config.json') if os.path.isdir(config_env) else config_env
    candidates.append(p)
    if not os.path.isabs(p):
        candidates.append(os.path.join(ROOT_PATH, p))

# default near this file
candidates.append(os.path.join(ROOT_PATH, 'config.json'))

LOGGER.debug(f"ROOT_PATH={ROOT_PATH}; cwd={os.getcwd()}; config paths={candidates}")

cfg = None
for candidate in candidates:
    if os.path.exists(candidate):
        with open(candidate, encoding='utf-8') as f:
            cfg = json.load(f)
            LOGGER.info(f"Loaded config: {candidate}")
        break

if cfg is None:
    raise ImportError(f"Can't import config! Tried: {candidates}")


""" <===== CONNECTION CONFIG =====> """


conn_cfg = cfg['connection']

URL = conn_cfg['url']

LOGIN_AUTH = dict(conn_cfg.get('login', {}))
SESSION_AUTH = dict(conn_cfg.get('session', {}))

SCRIPT_NAME = conn_cfg['script_name']
MODULE_UUID = conn_cfg['module_uuid']


""" <===== PATHs CONFIG =====> """


paths_cfg = cfg['paths']

FONTS_PATH = os.path.join(ROOT_PATH, paths_cfg['fonts_dir'])
OUTPUT_FILENAME = paths_cfg['output_filename']


""" <===== FONT CONFIG =====> """


default_cfg = cfg['font']

DEFAULT_FONT_SIZE = default_cfg['font_size']
DEFAULT_FONT_NAME = default_cfg['font_name']


""" <===== COLUMNS CONFIG =====> """


columns_cfg = cfg['columns']

COL_AUTOSIZE = columns_cfg['autosize']
COL_MAX_WIDTH = columns_cfg['max_width']
COL_MIN_WIDTH = columns_cfg['min_width']


""" <===== DATA CONFIG =====> """


data_cfg = cfg['data']

UNITS = data_cfg['units']
HIERARCHY_COLUMNS = data_cfg['hierarchy_columns']
SHIFT_SYMB = data_cfg['shift_symb']


""" <===== BLOCKS CONFIG =====> """


blocks_cfg = cfg['blocks']


class DataConf:
    date_cfg = blocks_cfg['date']
    DATE_FORMAT = date_cfg['format']
    DATE_NAME = date_cfg['name']
    DATE_NAME_FONT_SIZE = date_cfg['name_font_size']
    DATE_NAME_FONT_BOLD = date_cfg['name_font_bold']
    DATE_FONT_SIZE = date_cfg['date_font_size']
    DATE_FONT_BOLD = date_cfg['date_font_bold']

class DataRelevanceConf:
    date_cfg = blocks_cfg['date_relevance']
    DATE_NAME = date_cfg['name']
    DATE_NAME_FONT_SIZE = date_cfg['name_font_size']
    DATE_NAME_FONT_BOLD = date_cfg['name_font_bold']
    DATE_FONT_SIZE = date_cfg['date_font_size']
    DATE_FONT_BOLD = date_cfg['date_font_bold']


class TitleConf:
    title_cfg = blocks_cfg['title']
    NAME = title_cfg['name']
    OLAP_NAME_INSTEAD_OF_LAYER_NAME = title_cfg['olap_name_instead_of_layer_name']
    FONT_SIZE = title_cfg['font_size']
    FONT_BOLD = title_cfg['font_bold']
    ALIGN_H = title_cfg['align_h']
    ALIGN_V = title_cfg['align_v']


class FilterConf:
    filter_cfg = blocks_cfg['out_filter']
    OUT_NAME = filter_cfg['name']
    OUT_NAME_FONT_SIZE = filter_cfg['name_font_size']
    OUT_NAME_FONT_BOLD = filter_cfg['name_font_bold']

    filter_cfg = blocks_cfg['data_filter']
    DATA_NAME = filter_cfg['name']
    DATA_NAME_FONT_SIZE = filter_cfg['name_font_size']
    DATA_NAME_FONT_BOLD = filter_cfg['name_font_bold']


class TableConf:
    table_cfg = blocks_cfg['table']
    TOTAL_NAME = table_cfg['total_name']
    BORDER_STYLE = table_cfg['border_style']
    BORDER_COLOR = table_cfg['border_color']
    HEADER_FONT_SIZE = table_cfg['header_font_size']
    HEADER_FONT_BOLD = table_cfg['header_font_bold']
    HEADER_ALIGN_H = table_cfg['header_align_h']
    HEADER_ALIGN_V = table_cfg['header_align_v']
    HEADER_WRAP_TEXT = table_cfg['header_wrap_text']
    LEFT_DIM_ALIGN_H = table_cfg['left_dim_align_h']
    LEFT_DIM_ALIGN_V = table_cfg['left_dim_align_v']
    LEFT_WRAP_TEXT = table_cfg['left_dim_wrap_text']
    DATA_DIM_ALIGN_H = table_cfg['data_dim_align_h']
    DATA_DIM_ALIGN_V = table_cfg['data_dim_align_v']
    DATA_WRAP_TEXT = table_cfg['data_wrap_text']
    DATA_TOTAL_COL_FONT_BOLD = table_cfg['font_bold_total_col']
    DATA_TOTAL_ROW_FONT_BOLD = table_cfg['font_bold_total_row']
    MERGE_LEFT_DIMS_CELLS = table_cfg['merge_left_dims_cells']
    if 'data_number_format' in table_cfg:
        if table_cfg['data_number_format'] != "" :
            DATA_NUMBER_FORMAT = table_cfg['data_number_format']
        else:
            DATA_NUMBER_FORMAT = None
    else:
        DATA_NUMBER_FORMAT = None
    # DATA_NUMBER_FORMAT = table_cfg['data_number_format'] if 'data_number_format' in table_cfg or table_cfg['data_number_format'] == "" else None


""" <===== OTHER =====> """
