from fontTools.ttLib import TTFont
import os

from settings import FONTS_PATH

# logger
from settings import LOGGER


class FontNormCoef:
    FONT_NAME = "calibri"
    BOLD = False
    FONT_PATH = os.path.join(FONTS_PATH, f'{FONT_NAME + ("_bold" if BOLD else "")}.ttf')
    DEFAULT_FONT_SIZE = 11
    TEXT = "abc"
    TARGET_SIZE = len(TEXT)

    @classmethod
    def _get_font_params(cls):
        """
        Get fontTools params for calculation symbol width.

        :return: two fontTools params
        """
        font = TTFont(cls.FONT_PATH)
        t = font['cmap'].getcmap(3, 1).cmap
        s = font.getGlyphSet()
        return s, t

    @classmethod
    def _count_coeff(cls, s, t):
        """
        Calculate coefficient.
        """
        total = 0
        for c in cls.TEXT:
            if ord(c) in t and t[ord(c)] in s:
                total += s[t[ord(c)]].width
            else:
                total += s['.notdef'].width

        return total / len(cls.TEXT)

    @classmethod
    def get_norm_coef(cls, fonts_path: str = None):
        """
        Get normalization coefficient.

        :param fonts_path: optional path to folder with different fonts, example: 'home/user/fonts'
        :return: coefficient
        """
        if fonts_path:
            cls.FONT_PATH = os.path.join(fonts_path, f'{cls.FONT_NAME + ("_bold" if cls.BOLD else "")}.ttf')

        return cls._count_coeff(*cls._get_font_params())


if __name__ == "__main__":
    LOGGER.info(FontNormCoef.get_norm_coef())


# from math import ceil
#
#
# factor_of_font_size_to_width = {
#     # TODO: other sizes
#     12: {
#         "factor": 0.8,  # width / count of symbols at row
#         "height": 16
#     }
# }
#
#
# def get_height_for_row(sheet, row_number, font_size=12):
#     font_params = factor_of_font_size_to_width[font_size]
#     row = list(sheet.rows)[row_number]
#     height = font_params["height"]
#
#     for cell in row:
#         words_count_at_one_row = sheet.column_dimensions[cell.column_letter].width / font_params["factor"]
#         lines = ceil(len(str(cell.value)) / words_count_at_one_row)
#         height = max(height, lines * font_params["height"])
#
#     return height
