# from polyapi.business_scenarios import BusinessLogic
from polymatica.business_scenarios import BusinessLogic
from typing import Optional

from settings import URL


class Connector:
    """
    Connector to Analytics.
    """

    def __init__(self, host: str = URL, login: Optional[str] = None, password: Optional[str] = None,
                 session_auth: Optional[str] = None, is_guest: bool = False):
        self.host = host
        self.login = login
        self.password = password
        self.session_auth = session_auth
        self.is_guest = is_guest
        self.conn = None

    def connect(self) -> BusinessLogic:
        """
        Connect to server.

        :return: connection
        """
        self.conn = BusinessLogic(
            login=self.login,
            password=self.password,
            url=self.host,
            session_auth=self.session_auth,
            is_guest=self.is_guest,
            script_mode=True,
        )
        return self.conn
