import datetime
from typing import Optional
from pydantic import BaseModel as BaseFormat
from openpyxl.utils import get_column_letter

from settings import DataRelevanceConf
from .base import BaseBlock

class DateRelevanceFormat(BaseFormat):
    date_name: str = DataRelevanceConf.DATE_NAME
    date_name_font_size: int = DataRelevanceConf.DATE_NAME_FONT_SIZE
    date_name_font_bold: bool = DataRelevanceConf.DATE_NAME_FONT_BOLD
    date_font_size: int = DataRelevanceConf.DATE_FONT_SIZE
    date_font_bold: bool = DataRelevanceConf.DATE_FONT_BOLD
    relevance_date: str


class DateRelevanceBlock(BaseBlock):
    """
    Put date block on sheet.
    Block size - 1 x 2.
    """
    DATE_NAME_FONT_SIZE = None
    DATE_NAME_FONT_BOLD = None
    DATE_FONT_SIZE = None
    DATE_FONT_BOLD = None

    def __init__(self, sheet, row_start):
        super().__init__(sheet, row_start)
    
    @classmethod
    def update_font_settings(cls, date_name_font_size: Optional[int] = None,
                             date_name_font_bold: Optional[bool] = None, 
                             date_font_size: Optional[int] = None,
                             date_font_bold: Optional[bool] = None, **kwargs):
        cls.DATE_NAME_FONT_SIZE = date_name_font_size
        cls.DATE_NAME_FONT_BOLD = date_name_font_bold
        cls.DATE_FONT_SIZE = date_font_size
        cls.DATE_FONT_BOLD = date_font_bold

    def put(self, relevance_date:str = "", date_name: str = "", **kwargs) -> int:
        self.update_font_settings(**kwargs)
        self._set_value(self.row_start, 1, date_name, 
                        font=self._create_font(self.DATE_NAME_FONT_SIZE, 
                                               self.DATE_NAME_FONT_BOLD))
        self._set_value(self.row_start, 2, relevance_date,
                        font=self._create_font(self.DATE_FONT_SIZE, 
                                               self.DATE_FONT_BOLD))
        return self.row_start + 1
