import datetime
from typing import Optional
from pydantic import BaseModel as BaseFormat

from settings import DataConf
from .base import BaseBlock


class DateFormat(BaseFormat):
    date_format: str = DataConf.DATE_FORMAT
    date_name: str = DataConf.DATE_NAME
    date_name_font_size: int = DataConf.DATE_NAME_FONT_SIZE
    date_name_font_bold: bool = DataConf.DATE_NAME_FONT_BOLD
    date_font_size: int = DataConf.DATE_FONT_SIZE
    date_font_bold: bool = DataConf.DATE_FONT_BOLD


class DateBlock(BaseBlock):
    """
    Put date block on sheet.
    Block size - 1 x 2.
    """
    DATE_NAME_FONT_SIZE = None
    DATE_NAME_FONT_BOLD = None
    DATE_FONT_SIZE = None
    DATE_FONT_BOLD = None

    def __init__(self, sheet, row_start):
        super().__init__(sheet, row_start)
    
    @classmethod
    def update_font_settings(cls, date_name_font_size: Optional[int] = None,
                             date_name_font_bold: Optional[bool] = None, 
                             date_font_size: Optional[int] = None,
                             date_font_bold: Optional[bool] = None, **kwargs):
        cls.DATE_NAME_FONT_SIZE = date_name_font_size
        cls.DATE_NAME_FONT_BOLD = date_name_font_bold
        cls.DATE_FONT_SIZE = date_font_size
        cls.DATE_FONT_BOLD = date_font_bold

    @staticmethod
    def _get_date(date_format: str) -> str:
        return datetime.datetime.now().strftime(date_format)

    def put(self, date_format: str = "", date_name: str = "", **kwargs) -> int:
        self.update_font_settings(**kwargs)
        self._set_value(self.row_start, 1, date_name, 
                        font=self._create_font(self.DATE_NAME_FONT_SIZE, 
                                               self.DATE_NAME_FONT_BOLD))
        self._set_value(self.row_start, 2, self._get_date(date_format),
                        font=self._create_font(self.DATE_FONT_SIZE, 
                                               self.DATE_FONT_BOLD)).number_format
        return self.row_start + 1
