define( [], function(){ 
return {
    "log_level": {
        "none": 6,
        "critical": 5,
        "error": 4,
        "warning": 3,
        "information": 2,
        "debug": 1,
        "trace": 0
    },
    "locale": {
        "en": 0,
        "ru": 1,
        "de": 2,
        "fr": 3
    },
    "manager": {
        "id": 100,
        "member_roles": {
            "administrator": 1,
            "cube_creation": 2,
            "data_export": 8,
            "edition_functionality": 16
        },
        "schedule_type": {
            "none": 0,
            "daily": 1,
            "weekly": 2,
            "monthly": 3
        },
        "session_open_policy": {
            "last": 1,
            "blank": 2,
            "specific": 3,
            "script": 4,
            "scenario_list": 5
        },
        "data_source_type": {
            "none": 0,
            "file": 1,
            "excel": 2,
            "csv": 3,
            "odbc": 4,
            "mssql": 5,
            "mysql": 6,
            "dsn": 7,
            "psql": 8,
            "h2": 9,
            "oracle": 10,
            "jdbc": 11,
            "jdbc_bridge": 18
        },
        "field_mark_type": {
            "common": 0,
            "created": 1,
            "deleted": 2
        },
        "error": {
            "manager": 300,
            "resource_invalid": 301,
            "cube_deleted": 302,
            "user_deleted": 303,
            "session_busy": 304,
            "cube_update_cancelled": 305,
            "dashboard": 306,
            "edition": 307,
            "layer": 308,
            "layer_not_loaded": 309,
            "import_error": 310,
            "import_validation_error": 311,
            "import_partial_success_error": 312,
            "import_rollback_error": 313,
            "import_failed_with_all_sources_error": 319,
            "layer_already_loading_error": 314,
            "script": 315,
            "layer_busy_with_script": 316,
            "users_group_error": 317,
            "users_group_deleted": 318
        },
        "filter_status_codes": {
            "empty": 0,
            "partial": 1,
            "full": 2
        },
        "interval_update_type": {
            "today": 0,
            "yesterday": 1,
            "this_week": 2,
            "last_week": 3,
            "this_month": 4,
            "last_month": 5,
            "this_quarter": 6,
            "last_quarter": 7,
            "this_year": 8,
            "last_year": 9,
            "date_from": 10,
            "date_from_to": 11,
            "for_last_period": 12
        },
        "timezone": {
            "UTC-1:00": 0,
            "UTC-2:00": 1,
            "UTC-3:00": 3,
            "UTC-3:30": 4,
            "UTC-4:00": 5,
            "UTC-5:00": 6,
            "UTC-6:00": 7,
            "UTC-7:00": 8,
            "UTC-8:00": 9,
            "UTC-9:00": 10,
            "UTC-9:30": 11,
            "UTC-10:00": 12,
            "UTC-11:00": 13,
            "UTC-12:00": 14,
            "UTC±0:00": 15,
            "UTC+1:00": 16,
            "UTC+2:00": 17,
            "UTC+3:00": 18,
            "UTC+3:30": 19,
            "UTC+4:00": 20,
            "UTC+4:30": 21,
            "UTC+5:00": 22,
            "UTC+5:30": 23,
            "UTC+5:45": 24,
            "UTC+6:00": 25,
            "UTC+6:30": 26,
            "UTC+7:00": 27,
            "UTC+8:00": 28,
            "UTC+8:45": 29,
            "UTC+9:00": 30,
            "UTC+9:30": 31,
            "UTC+10:00": 32,
            "UTC+10:30": 33,
            "UTC+11:00": 34,
            "UTC+12:00": 35,
            "UTC+12:45": 36,
            "UTC+13:00": 37,
            "UTC+13:45": 38,
            "UTC+14:00": 39
        },
        "crypto": {
            "crypto_error": 1300,
            "private_key_read_error": 1301,
            "message_digest_not_found": 1302,
            "digital_signature_init_failed": 1303,
            "digital_signature_update_failed": 1304,
            "digital_signature_finish_failed": 1305,
            "big_num_wrong_encoding": 1306,
            "rsa_public_key_set_parameters_error": 1307,
            "rsa_key_set_assign_error": 1308,
            "pem_public_key_write_error": 1309
        },
        "command": {
            "query": {
                "id": 202,
                "state": {
                    "input": 0,
                    "output": 1
                }
            },
            "admin": {
                "id": 203,
                "state": {
                    "kick_user": 2,
                    "remove_user_layer": 3,
                    "response": 4,
                    "get_user_list": 5,
                    "user_list": 6,
                    "get_sys_settings": 7,
                    "sys_settings": 8
                }
            },
            "authenticate": {
                "id": 205,
                "state": {
                    "check": 1,
                    "login": 2,
                    "response": 3
                }
            },
            "user": {
                "id": 206,
                "state": {
                    "get_info": 1,
                    "get_by_login": 2,
                    "info": 3,
                    "list_request": 4,
                    "list_response": 5,
                    "add_user": 6,
                    "add_user_response": 7,
                    "del_user": 8,
                    "change_passwd": 9,
                    "change_user_passwd": 10,
                    "logout": 11,
                    "response": 12,
                    "get_user_info": 13,
                    "get_user_info_rp": 14,
                    "get_all_users_info": 15,
                    "get_all_users_info_rp": 16,
                    "block_user": 17,
                    "block_user_rp": 18
                }
            },
            "user_iface": {
                "id": 207,
                "state": {
                    "create_module": 0,
                    "open_parent": 1,
                    "clone_module": 2,
                    "detach_module": 3,
                    "new_module_desc": 4,
                    "get_module": 5,
                    "get_module_rp": 6,
                    "get_modules": 7,
                    "modules": 9,
                    "close_module": 10,
                    "load_settings": 11,
                    "load_settings_rp": 12,
                    "save_settings": 13,
                    "clear_settings": 14,
                    "move_module": 15,
                    "response": 16,
                    "get_configuration": 17,
                    "get_configuration_rp": 18,
                    "create_modules_from_profile": 19,
                    "create_modules_from_profile_rp": 20,
                    "rename_module": 21,
                    "rename_module_service": 22
                }
            },
            "user_cube": {
                "id": 208,
                "state": {
                    "list_request": 1,
                    "list_response": 2,
                    "info_request": 3,
                    "info_response": 4,
                    "ext_info_request": 5,
                    "ext_info_response": 6,
                    "save_ext_info_request": 7,
                    "save_ext_info_response": 8,
                    "manual_update": 9,
                    "stop_handle": 10,
                    "rename": 11,
                    "test_source_connection_request": 12,
                    "test_source_connection_response": 13,
                    "data_preview_request": 14,
                    "data_preview_response": 15,
                    "user_permissions_request": 16,
                    "user_permissions_response": 17,
                    "user_cube_permissions_request": 18,
                    "user_cube_permissions_response": 19,
                    "change_user_permissions": 20,
                    "add_cube": 21,
                    "del_cube": 22,
                    "response": 23,
                    "get_dimensions": 24,
                    "get_dimensions_response": 25,
                    "ext_info_several_sources_request": 26,
                    "ext_info_several_sources_response": 27,
                    "save_ext_info_several_sources_request": 28,
                    "save_ext_info_several_sources_response": 29,
                    "structure_preview_request": 30,
                    "structure_preview_response": 31,
                    "users_group_permissions_request": 32,
                    "users_group_permissions_response": 33,
                    "users_group_cube_permissions_request": 34,
                    "users_group_cube_permissions_response": 35,
                    "change_users_group_permissions": 36,
                    "users group response": 37,
                    "get_cubes_by_key": 38,
                    "get_cubes_by_key_response": 39,
                    "get_fields_request": 40,
                    "get_fields_response": 41,
                    "create_cube_request": 42,
                    "create_cube_response": 43,
                    "run_preview": 44,
                    "preview_running": 45,
                    "preview_failed": 46,
                    "get_preview_status": 47,
                    "preview_in_progress": 48,
                    "preview_success": 49,
                    "get_preview_result": 50,
                    "preview": 51,
                    "ext_info_several_sources_with_descendant_dims_request": 54,
                    "ext_info_several_sources_with_descendant_dims_response": 55,
                    "get_measures": 56,
                    "get_measures_rp": 57,
                    "cleanup": 58,
                    "cleanup_rp": 59
                }
            },
            "user_layer": {
                "id": 210,
                "state": {
                    "create_layer": 1,
                    "get_layer": 2,
                    "load_saved_layer": 3,
                    "init_layer": 4,
                    "clone_layer": 5,
                    "layer_rp": 6,
                    "save_layer": 7,
                    "save_layer_rp": 8,
                    "remove_saved_layer": 9,
                    "close_layer": 10,
                    "set_layer_settings": 11,
                    "set_layer_modules_order": 12,
                    "rename_layer": 14,
                    "rename_saved_layer": 15,
                    "set_active_layer": 16,
                    "layer_command_rp": 17,
                    "get_saved_layers": 18,
                    "get_saved_layers_rp": 19,
                    "get_session_layers": 20,
                    "get_session_layers_rp": 21,
                    "get_load_progress": 24,
                    "get_load_progress_rp": 25
                }
            },
            "dim_element_permission": {
                "id": 211,
                "state": {
                    "get_data": 1,
                    "pattern_change": 2,
                    "range_change": 3,
                    "rp_data": 4,
                    "filter_all_flag": 5,
                    "unfilter_all_flag": 6,
                    "invert_all_flag": 7,
                    "flags_rp": 8,
                    "apply_data": 9,
                    "rp": 10,
                    "filter_by_name": 11,
                    "filter_by_name_rp": 12,
                    "add_element": 13,
                    "rename_element": 14,
                    "remove_element": 15,
                    "user_element_rp": 16,
                    "set": 17,
                    "cancel": 18,
                    "clear": 19,
                    "response": 20
                }
            },
            "dim_element_multifilter": {
                "id": 213,
                "state": {
                    "get_data": 1,
                    "pattern_change": 2,
                    "range_change": 3,
                    "rp_data": 4,
                    "filter_all_flag": 5,
                    "unfilter_all_flag": 6,
                    "invert_all_flag": 7,
                    "flags_rp": 8,
                    "apply_data": 9,
                    "rp": 10,
                    "filter_by_name": 11,
                    "filter_by_name_rp": 12,
                    "add_element": 13,
                    "rename_element": 14,
                    "remove_element": 15,
                    "user_element_rp": 16,
                    "set": 17,
                    "cancel": 18,
                    "clear": 19,
                    "clear_all": 20,
                    "response": 21,
                    "get_filter_status": 22,
                    "get_filter_status_rp": 23,
                    "script_apply_data": 24,
                    "script_apply_data_rp": 25
                }
            },
            "group": {
                "id": 218,
                "state": {
                    "get_info": 1,
                    "get_info_response": 2,
                    "list_request": 3,
                    "list_response": 4,
                    "add_group": 5,
                    "add_group_response": 6,
                    "edit_group": 7,
                    "del_group": 8,
                    "add_member": 9,
                    "del_member": 10,
                    "move_member": 11,
                    "response": 12,
                    "list_member_groups": 13,
                    "list_member_groups_response": 14,
                    "edit_member_groups": 15,
                    "edit_member_groups_response": 16
                }
            },
            "permissions": {
                "id": 219,
                "state": {
                    "get_member_cubes_list": 1,
                    "get_member_cubes_list_rp": 2,
                    "get_detailed_cube_permissions": 3,
                    "get_detailed_cube_permissions_rp": 4,
                    "set_detailed_cube_permissions": 5,
                    "set_detailed_cube_permissions_rp": 6,
                    "cancel_staged_changes": 7,
                    "cancel_staged_changes_rp": 8
                }
            },
            "resource": {
                "id": 224,
                "state": {
                    "revoke": 0,
                    "delete": 1,
                    "reject": 2,
                    "response": 3,
                    "share_with_multiple_recipients": 4,
                    "share_with_multiple_recipients_rp": 5,
                    "share_multiple_resources": 6,
                    "share_multiple_resources_rp": 7,
                    "get_owners_by_resource": 8,
                    "get_owners_by_resource_rp": 9,
                    "get_resources_by_owner": 10,
                    "get_resources_by_owner_rp": 11,
                    "resource_rescan_repo": 12,
                    "resource_rescan_repo_rp": 13,
                    "resource_make_copy": 14,
                    "resource_make_copy_rp": 15
                }
            },
            "filterlists": {
                "id": 225,
                "state": {
                    "create": 1,
                    "create_rp": 2,
                    "delete": 3,
                    "reject": 4,
                    "set": 5,
                    "set_rp": 6,
                    "edit": 7,
                    "response": 8,
                    "list": 9,
                    "list_rp": 10
                }
            },
            "datasources": {
                "id": 226,
                "state": {
                    "create": 1,
                    "create_rp": 2,
                    "get": 3,
                    "get_rp": 4,
                    "set_parameters": 5,
                    "response": 6,
                    "list": 7,
                    "list_rp": 8,
                    "preview": 9,
                    "preview_rp": 10
                }
            },
            "scripts": {
                "id": 227,
                "state": {
                    "load_on_layer": 1,
                    "play_to_position": 2,
                    "pause": 3,
                    "interrupt": 4,
                    "get_script_status": 5,
                    "get_script_status_rp": 6,
                    "get_script_description": 7,
                    "get_script_description_rp": 8,
                    "get_script_descriptions_list": 9,
                    "get_script_descriptions_list_rp": 10,
                    "get_action_description": 11,
                    "get_action_description_rp": 12,
                    "get_action_by_position": 13,
                    "get_action_by_position_rp": 14,
                    "get_action_dependencies": 15,
                    "get_action_dependencies_rp": 16,
                    "replace_action_on_position": 17,
                    "delete_actions_on_positions": 18,
                    "delete_actions_from_position": 19,
                    "save_from_layer_history": 20,
                    "save_from_layer_script_history": 21,
                    "save_rp": 22,
                    "rename_saved_script": 23,
                    "get_script_metadata": 25,
                    "get_script_metadata_rp": 26,
                    "cancel_script_changes": 27,
                    "copy_script": 28,
                    "generic_rp": 24
                }
            },
            "members": {
                "id": 228,
                "state": {
                    "get_members_list": 1,
                    "get_members_list_rp": 2
                }
            }
        }
    },
    "olap": {
        "id": 500,
        "position": {
            "out": 0,
            "left": 1,
            "top": 2
        },
        "plm_dim_type": {
            "base": 1,
            "user": 2,
            "union": 3
        },
        "olap_data_type": {
            "uint8": 0,
            "uint16": 1,
            "uint32": 2,
            "uint64": 3,
            "double": 4,
            "string": 5,
            "date": 6,
            "time": 7,
            "datetime": 8,
            "date_year": 9,
            "date_quarter": 10,
            "date_month": 11,
            "date_day": 12,
            "date_week": 13,
            "date_wday": 14,
            "time_hour": 15,
            "time_minute": 16,
            "time_second": 17
        },
        "olap_fact_type": {
            "summ": 0,
            "percent": 1,
            "rank": 2,
            "count_distinct": 3,
            "average": 4,
            "sigma": 5,
            "min": 6,
            "max": 7,
            "variation": 8,
            "percent_variation": 9,
            "cumulative": 10,
            "abc": 11,
            "median": 12,
            "count": 13
        },
        "plm_fact_type": {
            "base": 1,
            "user": 2,
            "calc": 3,
            "group": 4
        },
        "sort_type": {
            "none": 0,
            "ascending": 1,
            "descending": 2
        },
        "view_item": {
            "empty": 1,
            "base": 2,
            "group": 3,
            "fact": 4,
            "total": 5
        },
        "view_item_flags": {
            "selected": 1,
            "unfolded": 2,
            "user_data": 4,
            "sort_ascending": 16,
            "sort_descending": 32,
            "is_horizontal": 64,
            "is_base": 128,
            "is_fact": 256,
            "is_group": 512,
            "is_total": 1024,
            "not_start_position": 2048
        },
        "error": {
            "olap": 400,
            "dimension_invalid": 401,
            "fact_invalid": 402,
            "filter_invalid": 403,
            "filter_not_changed": 404,
            "group_invalid": 405,
            "sorting": 406,
            "user_data": 408,
            "fact_is_used": 409,
            "dimension_load": 410,
            "fact_load": 411,
            "ignored_group_expression": 412,
            "read_is_aborting": 413,
            "element_is_removed": 414,
            "measures_tree_depth_error": 415
        },
        "command": {
            "dimension": {
                "id": 502,
                "state": {
                    "list_rq": 1,
                    "list_rp": 2,
                    "move": 3,
                    "move_all": 4,
                    "rename": 5,
                    "delete": 6,
                    "set_filter_mode": 7,
                    "clear_workspace": 8,
                    "rp": 9,
                    "create_copy": 10,
                    "create_union": 11,
                    "create_response": 12,
                    "distribute_elements_to_clusters": 13,
                    "copy_and_group_by_expression_rq": 14,
                    "copy_and_group_by_expression_rp": 15,
                    "get_parameters": 16,
                    "get_parameters_rp": 17,
                    "try_to_delete": 18,
                    "try_to_delete_rp": 19,
                    "tree_get_request": 20,
                    "tree_get_response": 21,
                    "tree_move_request": 22,
                    "tree_move_response": 23,
                    "delete_groups_request": 24,
                    "delete_groups_response": 25,
                    "create_group_request": 26,
                    "create_group_response": 27,
                    "rename_group_request": 28,
                    "rename_group_response": 29
                }
            },
            "fact": {
                "id": 503,
                "state": {
                    "list_rq": 1,
                    "list_rp": 2,
                    "create_copy": 3,
                    "create_calc": 4,
                    "create_user_from_other": 5,
                    "create_group": 6,
                    "create_rp": 7,
                    "edit_calc": 8,
                    "set_type": 9,
                    "set_level": 10,
                    "set_level_fixed": 26,
                    "set_direction": 11,
                    "set_visible": 12,
                    "set_selection": 13,
                    "set_visible_multi": 14,
                    "set_selection_multi": 15,
                    "del": 16,
                    "select_all": 17,
                    "unselect_all": 18,
                    "hide_selected": 19,
                    "unhide_selected": 20,
                    "hide_unselected": 21,
                    "ungroup_selected": 22,
                    "move": 23,
                    "rename": 24,
                    "response": 25,
                    "tree_get_request": 27,
                    "tree_get_response": 28,
                    "tree_create_group_request": 29,
                    "tree_create_group_response": 30,
                    "tree_delete_groups_request": 31,
                    "tree_delete_groups_response": 32,
                    "tree_move_request": 33,
                    "tree_move_response": 34,
                    "tree_rename_group_request": 35,
                    "tree_rename_group_response": 36,
                    "get_calculation_order_request": 37,
                    "get_calculation_order_response": 38,
                    "set_calculation_order_request": 39,
                    "set_calculation_order_response": 40,
                    "tree_visibility_group_request": 41,
                    "tree_visibility_group_response": 42
                }
            },
            "filter": {
                "id": 504,
                "state": {
                    "get_data": 1,
                    "pattern_change": 2,
                    "range_change": 3,
                    "rp_data": 4,
                    "filter_all_flag": 5,
                    "unfilter_all_flag": 6,
                    "invert_all_flag": 7,
                    "flags_rp": 8,
                    "apply_data": 9,
                    "rp": 10,
                    "filter_by_name": 11,
                    "filter_by_name_rp": 12,
                    "add_element": 13,
                    "rename_element": 14,
                    "remove_element": 15,
                    "user_element_rp": 16,
                    "set": 17,
                    "cancel": 18,
                    "clear": 19,
                    "transfer": 20,
                    "fetch": 21,
                    "response": 22,
                    "apply": 23,
                    "fetch_get": 27,
                    "fetch_get_rp": 28,
                    "filter_get": 29,
                    "filter_get_rp": 30,
                    "filter_get_status": 31,
                    "filter_get_status_rp": 32,
                    "filter_set_by_filterlist": 33,
                    "filter_set_by_filterlist_rp": 34,
                    "script_apply_data": 35,
                    "script_apply_data_rp": 36,
                    "row_fetch": 38
                }
            },
            "group": {
                "id": 505,
                "state": {
                    "get": 1,
                    "data": 2,
                    "remove": 3,
                    "set_name": 4,
                    "response": 5,
                    "get_description": 6,
                    "description": 7
                }
            },
            "view": {
                "id": 506,
                "state": {
                    "get": 1,
                    "data": 2,
                    "get_hints": 3,
                    "hints": 4,
                    "get_context": 5,
                    "fpc": 6,
                    "context": 7,
                    "f_sel": 8,
                    "f_unsel": 9,
                    "fold": 10,
                    "fold_all": 11,
                    "fold_all_at_level": 13,
                    "unfold_all": 12,
                    "unfold_all_at_level": 14,
                    "select": 15,
                    "sel_multi": 16,
                    "sel_all": 17,
                    "unsel_all": 18,
                    "group": 19,
                    "set_sort": 20,
                    "set_sort_dimension": 31,
                    "change_show_inter_total_mode": 21,
                    "add_dimension_element": 22,
                    "rename_dimension_element": 23,
                    "del_dimension_element": 24,
                    "change_fact_value": 26,
                    "response": 28,
                    "get_2": 29,
                    "data_2": 30,
                    "script_sel_multi": 32,
                    "script_sel": 33,
                    "script_response": 34,
                    "del_dimension_element_rp": 35,
                    "set_show_horizontal_total_mode": 36,
                    "set_show_horizontal_total_mode_rp": 37,
                    "set_show_vertical_total_mode": 38,
                    "set_show_vertical_total_mode_rp": 39,
                    "set_show_inter_total_mode": 40,
                    "set_show_inter_total_mode_rp": 41,
                    "set_view_formatting": 42,
                    "set_view_formatting_rp": 43,
                    "get_view_formatting": 44,
                    "get_view_formatting_rp": 45,
                    "set_show_all_inter_total_mode": 46,
                    "set_show_all_inter_total_mode_rp": 47,
                    "set_row_fetch_filter_status": 48,
                    "set_row_fetch_filter_status_response": 49,
                    "get_row_fetch_filter_status": 50,
                    "get_row_fetch_filter_status_response": 51,
                    "get_view_elements_as_strings": 52,
                    "get_view_elements_as_strings_response": 53,
                    "select_change": 54,
                    "select_change_rp": 55,
                    "select_multi": 56,
                    "select_multi_rp": 57,
                    "get_module_context": 58,
                    "get_module_context_rp": 59,
                    "expand": 60,
                    "expand_rp": 61,
                    "collapse": 62,
                    "collapse_rp": 63,
                    "get_module_configuration": 64,
                    "get_module_configuration_rp": 65
                }
            },
            "xls_export": {
                "id": 130,
                "state": {
                    "start": 1,
                    "check": 2,
                    "abort": 3,
                    "response": 4
                }
            },
            "user_data": {
                "id": 508,
                "state": {
                    "clear_all": 6,
                    "response": 7
                }
            },
            "dim_element_list_data": {
                "id": 509,
                "state": {
                    "get_data": 1,
                    "pattern_change": 2,
                    "range_change": 3,
                    "rp_data": 4,
                    "filter_all_flag": 5,
                    "unfilter_all_flag": 6,
                    "invert_all_flag": 7,
                    "flags_rp": 8,
                    "apply_data": 9,
                    "rp": 10,
                    "filter_by_name": 11,
                    "filter_by_name_rp": 12,
                    "add_element": 13,
                    "rename_element": 14,
                    "remove_element": 15,
                    "user_element_rp": 16
                }
            },
            "json_export": {
                "id": 510,
                "state": {
                    "run": 1,
                    "check": 2,
                    "stop": 3,
                    "response": 4
                }
            }
        }
    },
    "graph": {
        "id": 600,
        "graph_type": {
            "scatter": 630,
            "spheres": 631,
            "cluster_scatter": 632,
            "cluster_spheres": 633,
            "line": 634,
            "tube_line": 635,
            "pie": 636,
            "3d": 637,
            "radar": 638,
            "dimensioned_columns": 639,
            "graph": 640,
            "sankey": 641,
            "boxplot": 642,
            "parallel": 643,
            "combo_chart": 644,
            "chord_diagram": 645
        },
        "drill_action": {
            "in": 0,
            "out": 1
        },
        "error": {
            "graph": 1100,
            "graph_too_much_data": 1101,
            "graph_negative_value": 1102,
            "graph_not_enought_data": 1103,
            "graph_too_many_elements": 1104
        },
        "warning": {
            "selection_suppress": 681
        },
        "direction_type": {
            "column": 1,
            "row": 2,
            "none": 3
        },
        "command": {
            "graph": {
                "id": 601,
                "state": {
                    "get_available_types": 1,
                    "get_available_types_rp": 2,
                    "get_info": 3,
                    "get_info_rp": 4,
                    "stop": 5,
                    "stopped": 6,
                    "run": 7,
                    "run_rp": 8,
                    "check": 9,
                    "error": 10,
                    "state_changed": 11,
                    "idle": 12,
                    "done": 13,
                    "get": 14,
                    "data": 15,
                    "zoom": 16,
                    "zoom_rp": 17,
                    "drill": 20,
                    "drill_rp": 21,
                    "get_top_dimension_info": 22,
                    "get_top_dimension_info_rp": 23,
                    "pie_create_sector_other": 24,
                    "pie_create_sector_other_rp": 25,
                    "pie_get_sector_other_element_names": 26,
                    "pie_get_sector_other_element_names_rp": 27,
                    "run_service": 28
                }
            }
        }
    },
    "geo": {
        "id": 700,
        "geocoding_status": {
            "automatic": 0,
            "fail": 1,
            "manual": 2
        },
        "dimension_type": {
            "point": 0,
            "polygon": 1,
            "heatmap": 2,
            "gps": 3,
            "user_polygon": 4
        },
        "address_type": {
            "postcode": 0,
            "country": 1,
            "county": 2,
            "state": 3,
            "city": 4,
            "street": 5,
            "hno": 6
        },
        "error": {
            "geo": 1000,
            "geo_not_enough_left_dimensions": 1001,
            "geo_not_enough_top_dimensions": 1002,
            "geo_no_elements_on_dimension": 1003,
            "geo_all_dimensions_ignored": 1011,
            "geo_inconsistent_binded_settings_size": 1004,
            "geo_inconsistent_binded_settings_types": 1005,
            "geo_not_enough_dimensions_for_binded_address": 1006,
            "geo_address_unavailable_for_geocoding": 1007,
            "geo_database_server_connection_error": 1009,
            "geo_database_address_search_error": 1010,
            "geo_no_address_settings_for_dimension": 1008
        },
        "command": {
            "geo": {
                "id": 701,
                "state": {
                    "start": 1,
                    "start_rp": 2,
                    "stop": 3,
                    "check": 4,
                    "check_rp": 5,
                    "get": 6,
                    "get_rp": 7,
                    "set_address_format": 8,
                    "get_address_format": 9,
                    "get_address_format_rp": 10,
                    "set_binded_address_format": 11,
                    "get_binded_address_format": 12,
                    "get_binded_address_format_rp": 13,
                    "get_binded_address_info": 14,
                    "get_binded_address_info_rp": 15,
                    "set_point_position": 16,
                    "set_selection": 17,
                    "get_tiles_data": 18,
                    "get_tiles_data_rp": 19,
                    "get_top_dimension_info": 20,
                    "get_top_dimension_info_rp": 21,
                    "unspecified_response": 22
                }
            }
        }
    },
    "cluster": {
        "id": 900,
        "cluster_parameters": {
            "cluster_dimension_parameters": 904
        },
        "error": {
            "cluster": 500,
            "get_data": 501,
            "solution": 502
        },
        "command": {
            "cluster": {
                "id": 901,
                "state": {
                    "run": 1,
                    "check": 2,
                    "stop": 3,
                    "change_solution": 4,
                    "response": 5,
                    "apply": 6,
                    "apply_rp": 7
                }
            }
        }
    },
    "association": {
        "id": 800,
        "sort_type": {
            "none": 0,
            "support_up": 1,
            "support_down": 2,
            "confidence_up": 3,
            "confidence_down": 4,
            "lift_up": 5,
            "lift_down": 6
        },
        "dendrogram_type": {
            "node": 0,
            "rule": 1
        },
        "error": {
            "association": 700,
            "association_not_enough_left_dimensions": 701,
            "association_not_enough_top_dimensions": 702,
            "association_zero_size_transactions": 703
        },
        "command": {
            "association": {
                "id": 801,
                "state": {
                    "prerun": 1,
                    "check": 2,
                    "stop": 3,
                    "run": 4,
                    "select": 5,
                    "response": 6,
                    "get": 7,
                    "set_length": 8,
                    "set_pattern": 9,
                    "set_sort": 10,
                    "set_limits": 11,
                    "data": 12,
                    "get_rules": 13,
                    "rules": 14,
                    "start_graph": 15,
                    "get_graph": 16,
                    "graph_data": 17,
                    "start_dendrogram": 18,
                    "get_dendrogram": 19,
                    "dendrogram_data": 20,
                    "fold_rules": 21,
                    "fold_all_rules": 22,
                    "unfold_all_rules": 23,
                    "fold_rules_rp": 24
                }
            },
            "export": {
                "id": 130,
                "state": {
                    "start": 1,
                    "check": 2,
                    "abort": 3,
                    "response": 4
                }
            }
        }
    },
    "forecast": {
        "id": 1000,
        "error": {
            "forecast": 600,
            "forecast_not_enough_left_dimensions": 601,
            "forecast_not_enough_top_dimensions": 602,
            "forecast_calculation_error": 604,
            "forecast_not_enought_data": 605,
            "forecast_calculated_fact_error": 606,
            "forecast_add_to_cube_error": 607
        },
        "command": {
            "forecast": {
                "id": 1001,
                "state": {
                    "get": 1,
                    "response": 2,
                    "run": 3,
                    "idle": 4,
                    "stop": 5
                }
            }
        }
    },
    "license_error": {
        "license": 900,
        "not_found": 901,
        "blocked": 902,
        "expired": 903,
        "invalid": 904
    },
    "error": {
        "ok": 0,
        "logic": 100,
        "invalid_argument": 101,
        "null_pointer": 102,
        "illegal_state": 103,
        "invalid_access": 104,
        "not_implemented": 105,
        "runtime": 200,
        "object_type": 201,
        "object_factory": 202,
        "syntax": 203,
        "permission": 204,
        "config": 205,
        "process_running": 206,
        "process_finish": 207,
        "process_stopped": 208,
        "network": 209,
        "timeout": 210,
        "system_busy": 211,
        "internal_system": 212,
        "rule_complete": 214,
        "rule_close_connection": 215,
        "action_invalid": 216,
        "action_merge_prohibited": 217,
        "action_merge_allowed": 218,
        "action_empty": 219,
        "io": 230,
        "storage_empty": 231,
        "open_file": 232,
        "excel_file_load": 233,
        "serialization": 235,
        "serialize_read": 236,
        "json_field_name": 237,
        "json_field_type": 238,
        "json_field_empty": 239,
        "serialize_write": 240,
        "memory": 250,
        "memory_allocation": 251,
        "memory_deallocation": 252,
        "request": 260,
        "request_invalid": 261,
        "request_unhandled": 262,
        "request_handler": 263,
        "request_system": 264,
        "request_receiver_not_found": 265,
        "request_receiver_unreachable": 266,
        "request_receiver": 267,
        "request_network": 268,
        "request_timeout": 269,
        "request_authenticate": 270,
        "request_denied": 271,
        "resource_error": 272,
        "history_error": 273,
        "request_auth_invalid_password_error": 274,
        "meta_repository_error": 275,
        "facts_or_dims_unavailable_error": 276,
        "not_found_error": 277,
        "already_exist_error": 278,
        "reject_resource_error": 279,
        "delete_resource_error": 280,
        "profile_already_exist_error": 281,
        "serialization_bad_format_error": 282
    },
    "util_error": {
        "decoder_error": 1500,
        "converter_construct_error": 1501,
        "string_decode_error": 1502,
        "string_encode_error": 1503
    },
    "smart_connector": {
        "id": 273,
        "command": {}
    },
    "oauth2_errors": {
        "oauth2_error": 1400,
        "invalid_provider_metadata_issuer": 1401,
        "metadata_discovery_failed": 1402,
        "jwks_discovery_failed": 1403,
        "client_id_not_configured": 1404,
        "client_secret_not_configured": 1405,
        "authorization_endpoint_not_configured": 1406,
        "token_endpoint_not_configured": 1407,
        "incorrect_endpoint_format": 1408,
        "acquire_access_token_error": 1409,
        "acquire_user_info_error": 1410,
        "userinfo_empty_login_error": 1411,
        "access_token_refresh_error": 1412,
        "user_description_empty_login_error": 1413,
        "jwk_not_found": 1414,
        "jwk_parameters_type_mismatch": 1415,
        "user_logout_error": 1416
    }
}
;});
